# This file gets passed to gyp with -I so that it gets included everywhere.
{
  'variables': {
    'AOS': '<(DEPTH)/aos',
# A directory with everything in it ignored from source control.
    'TMPDIR': '<(DEPTH)/aos/build/temp',
    'aos_abs': '<!(readlink -f <(DEPTH)/aos)', # for use in non-path contexts
# The .gyp file that has targets for the various external libraries.
    'EXTERNALS': '<(AOS)/build/externals.gyp',
# The directory that gets rsynced to the target.
    'rsync_dir': '<(PRODUCT_DIR)/outputs',
# The directory for executables that don't get rsynced to the target.
    'other_outputs_dir': '<(PRODUCT_DIR)/other_outputs',
# The directory that executables that depend on <(EXTERNALS):gtest get put into.
    'test_dir': '<(PRODUCT_DIR)/tests',

# Stuck into a variable (with a space on the end) to make disabling it easy.
    'ccache': '<!(which ccache) ',

    'disable_sanitizers': [
      # Bad alignment is just slow on x86 and traps on ARM, so we'll find
      # it other ways, and some x86 code does it on purpose.
      'alignment',
    ],
  },
  'conditions': [
    ['PLATFORM=="linux-arm_frc-gcc"', {
        'make_global_settings': [
          ['CC', '<(ccache)<!(which arm-frc-linux-gnueabi-gcc-4.9)'],
          ['CXX', '<(ccache)<!(which arm-frc-linux-gnueabi-g++-4.9)'],
          ['LINK_wrapper', '<!(realpath -s <(AOS)/build/strip_debuglink) <!(which arm-frc-linux-gnueabi-objcopy)'],
        ],
      },
    ], ['PLATFORM=="linux-arm_frc-clang"', {
        'variables': {
          'arm-clang-symlinks': '<!(realpath -s <(AOS)/build/arm-clang-symlinks)',
          'arm-clang-sysroot': '<(arm-clang-symlinks)/sysroot',
# Flags that should be passed to all compile/link/etc commands.
          'platflags': [
            '-target', 'armv7a-frc-linux-gnueabi',
            '-mfloat-abi=softfp',
            '--sysroot=<(arm-clang-sysroot)',

            # TODO(brians): See if it will run with this enabled.
            #-mhwdiv=arm,thumb
          ],
        },
        'make_global_settings': [
          ['CC', '<(ccache)<(arm-clang-symlinks)/bin/clang'],
          ['CXX', '<(ccache)<(arm-clang-symlinks)/bin/clang++'],
          ['LINK_wrapper', '<!(realpath -s <(AOS)/build/strip_debuglink) <!(which arm-frc-linux-gnueabi-objcopy)'],
        ],
        'target_defaults': {
          'cflags': [
            '<@(platflags)',
          ],
          'cflags_cc': [
            '-isystem', '<(arm-clang-sysroot)/include/c++/4.9.1',
            '-isystem', '<(arm-clang-sysroot)/include/c++/4.9.1/arm-frc-linux-gnueabi',
          ],
          'ldflags': [
            '<@(platflags)',
            '-L/usr/lib/x86_64-linux-gnu/gcc/arm-frc-linux-gnueabi/4.9.1',
            '-L<(arm-clang-symlinks)/more_libs',
            '-B/usr/lib/x86_64-linux-gnu/gcc/arm-frc-linux-gnueabi/4.9.1',
          ],
        },
      },
    ], ['PLATFORM=="linux-amd64-clang"', {
        'make_global_settings': [
          ['CC', '<(ccache)<!(which clang)'],
          ['CXX', '<(ccache)<!(which clang++)'],
        ],
      },
    ], ['PLATFORM=="linux-amd64-gcc_4.8"', {
        'make_global_settings': [
          ['CC', '<(ccache)/opt/clang-3.5/bin/gcc'],
          ['CXX', '<(ccache)/opt/clang-3.5/bin/g++'],
        ],
      },
    ], ['SANITIZER!="none"', {
        'target_defaults': {
          'cflags': [
            '-fsanitize=<(SANITIZER)',
          ],
          'ldflags': [
            '-fsanitize=<(SANITIZER)',
          ],
          'defines': [
# GCC doesn't have __has_feature, so we have to use this instead.
            'AOS_SANITIZER_<(SANITIZER)',
          ],
        },
      },
    ], ['SANITIZER!="none" and COMPILER!="gcc"', {
        'target_defaults': {
          'cflags': [
            '-fno-sanitize-recover',
            '-fno-sanitize=<!(echo <(disable_sanitizers) | sed "s/ /,/g")',
          ],
        },
      },
    ], ['SANITIZER!="thread"', {
        'libraries': [
          '<!(readlink -f <(AOS)/../output/compiled-<(ARCHITECTURE)<(EXTERNALS_EXTRA)/gperftools-2.3-prefix/lib/libtcmalloc.a)',
          '<!(readlink -f <(AOS)/../output/compiled-<(ARCHITECTURE)<(EXTERNALS_EXTRA)/libunwind-1.1-prefix/lib/libunwind.a)',
        ],
        'defines': [
          'TCMALLOC',
        ],
      },
    ], ['EXTERNALS_EXTRA=="-fPIE"', {
        'target_defaults': {
          'cflags': [
            '-fPIE',
          ],
          'ldflags': [
            '-fPIE',
          ],
          'link_settings': {
            'ldflags': [
              '-pie',
            ],
          },
        },
      },
    ], ['SANITIZER=="memory"', {
        'target_defaults': {
          'cflags': [
            '-fsanitize-memory-track-origins',
          ],
          'ldflags': [
            '-fsanitize-memory-track-origins',
          ],
        },
      },
    ],
  ],
  'target_defaults': {
    'defines': [
      '__STDC_FORMAT_MACROS',
      '__STDC_CONSTANT_MACROS',
      '__STDC_LIMIT_MACROS',
      'AOS_COMPILER_<!(echo <(FULL_COMPILER) | sed \'s/\./_/g\')',
      'AOS_ARCHITECTURE_<(ARCHITECTURE)',
      '_FILE_OFFSET_BITS=64',
    ],
    'ldflags': [
      '-pipe',
      '-pthread',
    ],
    'libraries': [
      '-lm',
      '-lrt',
    ],
    'cflags': [
      '-pipe',

      '-pthread',

      '-Wall',
      '-Wextra',
      '-Wswitch-enum',
      '-Wpointer-arith',
      '-Wstrict-aliasing=2',
      '-Wcast-qual',
      '-Wcast-align',
      '-Wwrite-strings',
      '-Wtype-limits',
      '-Wsign-compare',
      '-Wformat=2',
      '-Werror',

      '-ggdb3',
      # Generate debugging info that gdb 7.4.1 can understand (Wheezy).
      # TODO(Brian): Remove this once we upgrade to Jessie.
      '-gdwarf-3',
    ],
    'cflags_c': [
      '-std=gnu99',
    ],
    'cflags_cc': [
      '-std=gnu++11',
    ],
    'include_dirs': [
      '<(DEPTH)',
    ],
    # These have to be here because apparently gyp evaluates target_conditions
    # even if the target is never used.
    'variables': {
      # Set this to 1 to disable rsyncing the file to the target.
      'no_rsync%': 0,
      # Set this to 1 if this file is a test that should not be run by
      # `build.py tests`.
      'is_special_test%': 0,
    },
    'conditions': [
      ['DEBUG=="yes"', {
          'defines': [
            'AOS_DEBUG=1',
          ],
          'conditions': [
            ['COMPILER!="clang"', {
                'cflags': [
                  '-Og',
                ],
              },
            ], ['COMPILER=="clang" and SANITIZER=="none"', {
                'cflags': [
                  '-O0',
                ],
              },
            ], ['COMPILER=="clang" and SANITIZER!="none"', {
                'cflags': [
                  '-O1',
                ],
              }
            ]
          ],
          'cflags': [
            '-fno-omit-frame-pointer',
          ],
        }, { # 'DEBUG=="no"'
          'defines': [
            'AOS_DEBUG=0',
            '_FORTIFY_SOURCE=2',
          ],
          'conditions': [
            # TODO(Brian): Remove this special case once we get a new enough
            # GCC here that it supports -Oz.
            ['COMPILER=="gcc" and ARCHITECTURE=="arm_frc"', {
                'cflags': [
                  '-Os',
                ],
                'ldflags': [
                  '-Os',
                ],
              }, {
                'cflags': [
                  '-Oz',
                ],
                'ldflags': [
                  '-Oz',
                ],
              }
            ], ['ARCHITECTURE=="amd64"', {
              'cflags': [
                '-fstack-protector-all',
                ],
              }
            ],
          ],
          'cflags': [
            '-fomit-frame-pointer',
          ],
        }
      ], ['OS=="linux" and ARCHITECTURE=="arm" and COMPILER=="gcc" and DEBUG=="yes"', {
          'cflags': [
              # GCC doesn't like letting us use r7 (which is also the frame
              # pointer) to pass the syscall number to the kernel even when
              # it's marked as clobbered.
              # See <https://bugzilla.mozilla.org/show_bug.cgi?id=633436> for
              # some more discussion.
            '-fomit-frame-pointer',
          ],
        }
      ],
      ['ARCHITECTURE=="arm"', {
        'cflags': [
          '-mcpu=cortex-a9',
          '-mfpu=neon',
          '-mfloat-abi=softfp',
        ],
        'ldflags': [
          '-mcpu=cortex-a9',
          '-mfpu=neon',
          '-mfloat-abi=softfp',
        ],
      }],
      ['COMPILER=="gcc"', {
        'cflags': [
          '-Wunused-local-typedefs',
        ],
        'defines': [
          '__has_feature(n)=0'
        ],
      }], ['COMPILER=="clang"', {
        'cflags': [
          '-fcolor-diagnostics',
          '-fmessage-length=80',
          '-fmacro-backtrace-limit=0',
        ],
        'defines': [
          # This tells clang's optimizer the same thing.
          '__builtin_assume_aligned(p, a)=({ const typeof(p) my_p_ = (p); ((((uintptr_t)my_p_ % (a)) == 0u) ? my_p_ : (__builtin_unreachable(), (my_p_))); })',
        ],
      }],
    ],
    'target_conditions': [
# Default to putting outputs into rsync_dir.
      ['no_rsync==0 and _type!="static_library"', {
          'product_dir': '<(rsync_dir)',
        },
      ], ['no_rsync==1 and _type!="static_library"', {
        'product_dir': '<(other_outputs_dir)',
        },
      ],
    ],
  },
}
