###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @//vendor_remote_pkgs:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({_CONDITIONS[condition]: deps.values()})

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": common_items}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        if condition_triples in crate_aliases:
            crate_aliases[condition_triples].update(deps)
        else:
            crate_aliases.update({_CONDITIONS[condition]: dict(deps.items() + common_items)})

    return selects.with_or(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "axum": "@crates_vendor_pkgs__axum-0.4.8//:axum",
            "hyper": "@crates_vendor_pkgs__hyper-0.14.26//:hyper",
            "mime": "@crates_vendor_pkgs__mime-0.3.17//:mime",
            "serde_json": "@crates_vendor_pkgs__serde_json-1.0.96//:serde_json",
            "socket2": "@crates_vendor_pkgs__socket2-0.4.9//:socket2",
            "tokio": "@crates_vendor_pkgs__tokio-1.27.0//:tokio",
            "tower": "@crates_vendor_pkgs__tower-0.4.13//:tower",
            "tower-http": "@crates_vendor_pkgs__tower-http-0.2.5//:tower_http",
            "tracing": "@crates_vendor_pkgs__tracing-0.1.37//:tracing",
            "tracing-subscriber": "@crates_vendor_pkgs__tracing-subscriber-0.3.17//:tracing_subscriber",
        },
    },
}

_NORMAL_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "": {
    },
}

_NORMAL_DEV_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "": {
    },
}

_BUILD_DEPENDENCIES = {
    "": {
    },
}

_BUILD_ALIASES = {
    "": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "": {
    },
}

_CONDITIONS = {
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["aarch64-pc-windows-msvc"],
    "aarch64-uwp-windows-msvc": [],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"aarch64\"), target_os = \"hermit\"))": [],
    "cfg(docsrs)": [],
    "cfg(not(any(target_arch = \"wasm32\", target_arch = \"wasm64\")))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-fuchsia", "aarch64-linux-android", "aarch64-pc-windows-msvc", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-pc-windows-msvc", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "riscv32imc-unknown-none-elf", "riscv64gc-unknown-none-elf", "s390x-unknown-linux-gnu", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-fuchsia", "x86_64-linux-android", "x86_64-pc-windows-msvc", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(not(windows))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-fuchsia", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "riscv32imc-unknown-none-elf", "riscv64gc-unknown-none-elf", "s390x-unknown-linux-gnu", "wasm32-unknown-unknown", "wasm32-wasi", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-fuchsia", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(not(windows_raw_dylib))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-fuchsia", "aarch64-linux-android", "aarch64-pc-windows-msvc", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-pc-windows-msvc", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "riscv32imc-unknown-none-elf", "riscv64gc-unknown-none-elf", "s390x-unknown-linux-gnu", "wasm32-unknown-unknown", "wasm32-wasi", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-fuchsia", "x86_64-linux-android", "x86_64-pc-windows-msvc", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"wasi\")": ["wasm32-wasi"],
    "cfg(target_os = \"windows\")": ["aarch64-pc-windows-msvc", "i686-pc-windows-msvc", "x86_64-pc-windows-msvc"],
    "cfg(tracing_unstable)": [],
    "cfg(unix)": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-fuchsia", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "s390x-unknown-linux-gnu", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-fuchsia", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(windows)": ["aarch64-pc-windows-msvc", "i686-pc-windows-msvc", "x86_64-pc-windows-msvc"],
    "i686-pc-windows-gnu": [],
    "i686-pc-windows-msvc": ["i686-pc-windows-msvc"],
    "i686-uwp-windows-gnu": [],
    "i686-uwp-windows-msvc": [],
    "x86_64-pc-windows-gnu": [],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["x86_64-pc-windows-msvc"],
    "x86_64-uwp-windows-gnu": [],
    "x86_64-uwp-windows-msvc": [],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates"""
    maybe(
        http_archive,
        name = "crates_vendor_pkgs__async-trait-0.1.68",
        sha256 = "b9ccdd8f2a161be9bd5c023df56f1b2a0bd1d83872ae53b71a84a12c9bf6e842",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/async-trait/0.1.68/download"],
        strip_prefix = "async-trait-0.1.68",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.async-trait-0.1.68.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__autocfg-1.1.0",
        sha256 = "d468802bab17cbc0cc575e9b053f41e72aa36bfa6b7f55e3529ffa43161b97fa",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/autocfg/1.1.0/download"],
        strip_prefix = "autocfg-1.1.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.autocfg-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__axum-0.4.8",
        sha256 = "c9f346c92c1e9a71d14fe4aaf7c2a5d9932cc4e5e48d8fb6641524416eb79ddd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/axum/0.4.8/download"],
        strip_prefix = "axum-0.4.8",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.axum-0.4.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__axum-core-0.1.2",
        sha256 = "6dbcda393bef9c87572779cb8ef916f12d77750b27535dd6819fa86591627a51",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/axum-core/0.1.2/download"],
        strip_prefix = "axum-core-0.1.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.axum-core-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__bytes-1.4.0",
        sha256 = "89b2fd2a0dcf38d7971e2194b6b6eebab45ae01067456a7fd93d5547a61b70be",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bytes/1.4.0/download"],
        strip_prefix = "bytes-1.4.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.bytes-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__fnv-1.0.7",
        sha256 = "3f9eec918d3f24069decb9af1554cad7c880e2da24a9afd88aca000531ab82c1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/fnv/1.0.7/download"],
        strip_prefix = "fnv-1.0.7",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.fnv-1.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__form_urlencoded-1.1.0",
        sha256 = "a9c384f161156f5260c24a097c56119f9be8c798586aecc13afbcbe7b7e26bf8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/form_urlencoded/1.1.0/download"],
        strip_prefix = "form_urlencoded-1.1.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.form_urlencoded-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-channel-0.3.28",
        sha256 = "955518d47e09b25bbebc7a18df10b81f0c766eaf4c4f1cccef2fca5f2a4fb5f2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-channel/0.3.28/download"],
        strip_prefix = "futures-channel-0.3.28",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.futures-channel-0.3.28.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-core-0.3.28",
        sha256 = "4bca583b7e26f571124fe5b7561d49cb2868d79116cfa0eefce955557c6fee8c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-core/0.3.28/download"],
        strip_prefix = "futures-core-0.3.28",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.futures-core-0.3.28.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-sink-0.3.28",
        sha256 = "f43be4fe21a13b9781a69afa4985b0f6ee0e1afab2c6f454a8cf30e2b2237b6e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-sink/0.3.28/download"],
        strip_prefix = "futures-sink-0.3.28",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.futures-sink-0.3.28.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-task-0.3.28",
        sha256 = "76d3d132be6c0e6aa1534069c705a74a5997a356c0dc2f86a47765e5617c5b65",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-task/0.3.28/download"],
        strip_prefix = "futures-task-0.3.28",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.futures-task-0.3.28.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-util-0.3.28",
        sha256 = "26b01e40b772d54cf6c6d721c1d1abd0647a0106a12ecaa1c186273392a69533",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-util/0.3.28/download"],
        strip_prefix = "futures-util-0.3.28",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.futures-util-0.3.28.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__h2-0.3.18",
        sha256 = "17f8a914c2987b688368b5138aa05321db91f4090cf26118185672ad588bce21",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/h2/0.3.18/download"],
        strip_prefix = "h2-0.3.18",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.h2-0.3.18.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__hashbrown-0.12.3",
        sha256 = "8a9ee70c43aaf417c914396645a0fa852624801b24ebb7ae78fe8272889ac888",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hashbrown/0.12.3/download"],
        strip_prefix = "hashbrown-0.12.3",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.hashbrown-0.12.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__hermit-abi-0.2.6",
        sha256 = "ee512640fe35acbfb4bb779db6f0d80704c2cacfa2e39b601ef3e3f47d1ae4c7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hermit-abi/0.2.6/download"],
        strip_prefix = "hermit-abi-0.2.6",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.hermit-abi-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__http-0.2.9",
        sha256 = "bd6effc99afb63425aff9b05836f029929e345a6148a14b7ecd5ab67af944482",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/http/0.2.9/download"],
        strip_prefix = "http-0.2.9",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.http-0.2.9.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__http-body-0.4.5",
        sha256 = "d5f38f16d184e36f2408a55281cd658ecbd3ca05cce6d6510a176eca393e26d1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/http-body/0.4.5/download"],
        strip_prefix = "http-body-0.4.5",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.http-body-0.4.5.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__http-range-header-0.3.0",
        sha256 = "0bfe8eed0a9285ef776bb792479ea3834e8b94e13d615c2f66d03dd50a435a29",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/http-range-header/0.3.0/download"],
        strip_prefix = "http-range-header-0.3.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.http-range-header-0.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__httparse-1.8.0",
        sha256 = "d897f394bad6a705d5f4104762e116a75639e470d80901eed05a860a95cb1904",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/httparse/1.8.0/download"],
        strip_prefix = "httparse-1.8.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.httparse-1.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__httpdate-1.0.2",
        sha256 = "c4a1e36c821dbe04574f602848a19f742f4fb3c98d40449f11bcad18d6b17421",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/httpdate/1.0.2/download"],
        strip_prefix = "httpdate-1.0.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.httpdate-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__hyper-0.14.26",
        sha256 = "ab302d72a6f11a3b910431ff93aae7e773078c769f0a3ef15fb9ec692ed147d4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hyper/0.14.26/download"],
        strip_prefix = "hyper-0.14.26",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.hyper-0.14.26.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__indexmap-1.9.3",
        sha256 = "bd070e393353796e801d209ad339e89596eb4c8d430d18ede6a1cced8fafbd99",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/indexmap/1.9.3/download"],
        strip_prefix = "indexmap-1.9.3",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.indexmap-1.9.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__itoa-1.0.6",
        sha256 = "453ad9f582a441959e5f0d088b02ce04cfe8d51a8eaf077f12ac6d3e94164ca6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/itoa/1.0.6/download"],
        strip_prefix = "itoa-1.0.6",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.itoa-1.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__lazy_static-1.4.0",
        sha256 = "e2abad23fbc42b3700f2f279844dc832adb2b2eb069b2df918f455c4e18cc646",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/lazy_static/1.4.0/download"],
        strip_prefix = "lazy_static-1.4.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.lazy_static-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__libc-0.2.142",
        sha256 = "6a987beff54b60ffa6d51982e1aa1146bc42f19bd26be28b0586f252fccf5317",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/libc/0.2.142/download"],
        strip_prefix = "libc-0.2.142",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.libc-0.2.142.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__lock_api-0.4.9",
        sha256 = "435011366fe56583b16cf956f9df0095b405b82d76425bc8981c0e22e60ec4df",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/lock_api/0.4.9/download"],
        strip_prefix = "lock_api-0.4.9",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.lock_api-0.4.9.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__log-0.4.17",
        sha256 = "abb12e687cfb44aa40f41fc3978ef76448f9b6038cad6aef4259d3c095a2382e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/log/0.4.17/download"],
        strip_prefix = "log-0.4.17",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.log-0.4.17.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__matchit-0.4.6",
        sha256 = "9376a4f0340565ad675d11fc1419227faf5f60cd7ac9cb2e7185a471f30af833",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/matchit/0.4.6/download"],
        strip_prefix = "matchit-0.4.6",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.matchit-0.4.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__memchr-2.5.0",
        sha256 = "2dffe52ecf27772e601905b7522cb4ef790d2cc203488bbd0e2fe85fcb74566d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/memchr/2.5.0/download"],
        strip_prefix = "memchr-2.5.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.memchr-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__mime-0.3.17",
        sha256 = "6877bb514081ee2a7ff5ef9de3281f14a4dd4bceac4c09388074a6b5df8a139a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/mime/0.3.17/download"],
        strip_prefix = "mime-0.3.17",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.mime-0.3.17.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__mio-0.8.6",
        sha256 = "5b9d9a46eff5b4ff64b45a9e316a6d1e0bc719ef429cbec4dc630684212bfdf9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/mio/0.8.6/download"],
        strip_prefix = "mio-0.8.6",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.mio-0.8.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__nu-ansi-term-0.46.0",
        sha256 = "77a8165726e8236064dbb45459242600304b42a5ea24ee2948e18e023bf7ba84",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/nu-ansi-term/0.46.0/download"],
        strip_prefix = "nu-ansi-term-0.46.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.nu-ansi-term-0.46.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__num_cpus-1.15.0",
        sha256 = "0fac9e2da13b5eb447a6ce3d392f23a29d8694bff781bf03a16cd9ac8697593b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num_cpus/1.15.0/download"],
        strip_prefix = "num_cpus-1.15.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.num_cpus-1.15.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__once_cell-1.17.1",
        sha256 = "b7e5500299e16ebb147ae15a00a942af264cf3688f47923b8fc2cd5858f23ad3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/once_cell/1.17.1/download"],
        strip_prefix = "once_cell-1.17.1",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.once_cell-1.17.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__overload-0.1.1",
        sha256 = "b15813163c1d831bf4a13c3610c05c0d03b39feb07f7e09fa234dac9b15aaf39",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/overload/0.1.1/download"],
        strip_prefix = "overload-0.1.1",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.overload-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__parking_lot-0.12.1",
        sha256 = "3742b2c103b9f06bc9fff0a37ff4912935851bee6d36f3c02bcc755bcfec228f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/parking_lot/0.12.1/download"],
        strip_prefix = "parking_lot-0.12.1",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.parking_lot-0.12.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__parking_lot_core-0.9.7",
        sha256 = "9069cbb9f99e3a5083476ccb29ceb1de18b9118cafa53e90c9551235de2b9521",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/parking_lot_core/0.9.7/download"],
        strip_prefix = "parking_lot_core-0.9.7",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.parking_lot_core-0.9.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__percent-encoding-2.2.0",
        sha256 = "478c572c3d73181ff3c2539045f6eb99e5491218eae919370993b890cdbdd98e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/percent-encoding/2.2.0/download"],
        strip_prefix = "percent-encoding-2.2.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.percent-encoding-2.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-project-1.0.12",
        sha256 = "ad29a609b6bcd67fee905812e544992d216af9d755757c05ed2d0e15a74c6ecc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pin-project/1.0.12/download"],
        strip_prefix = "pin-project-1.0.12",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.pin-project-1.0.12.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-project-internal-1.0.12",
        sha256 = "069bdb1e05adc7a8990dce9cc75370895fbe4e3d58b9b73bf1aee56359344a55",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pin-project-internal/1.0.12/download"],
        strip_prefix = "pin-project-internal-1.0.12",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.pin-project-internal-1.0.12.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-project-lite-0.2.9",
        sha256 = "e0a7ae3ac2f1173085d398531c705756c94a4c56843785df85a60c1a0afac116",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pin-project-lite/0.2.9/download"],
        strip_prefix = "pin-project-lite-0.2.9",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.pin-project-lite-0.2.9.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-utils-0.1.0",
        sha256 = "8b870d8c151b6f2fb93e84a13146138f05d02ed11c7e7c54f8826aaaf7c9f184",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pin-utils/0.1.0/download"],
        strip_prefix = "pin-utils-0.1.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.pin-utils-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__proc-macro2-1.0.56",
        sha256 = "2b63bdb0cd06f1f4dedf69b254734f9b45af66e4a031e42a7480257d9898b435",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/proc-macro2/1.0.56/download"],
        strip_prefix = "proc-macro2-1.0.56",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.proc-macro2-1.0.56.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__quote-1.0.26",
        sha256 = "4424af4bf778aae2051a77b60283332f386554255d722233d09fbfc7e30da2fc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/quote/1.0.26/download"],
        strip_prefix = "quote-1.0.26",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.quote-1.0.26.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__redox_syscall-0.2.16",
        sha256 = "fb5a58c1855b4b6819d59012155603f0b22ad30cad752600aadfcb695265519a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/redox_syscall/0.2.16/download"],
        strip_prefix = "redox_syscall-0.2.16",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.redox_syscall-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__ryu-1.0.13",
        sha256 = "f91339c0467de62360649f8d3e185ca8de4224ff281f66000de5eb2a77a79041",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ryu/1.0.13/download"],
        strip_prefix = "ryu-1.0.13",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.ryu-1.0.13.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__scopeguard-1.1.0",
        sha256 = "d29ab0c6d3fc0ee92fe66e2d99f700eab17a8d57d1c1d3b748380fb20baa78cd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/scopeguard/1.1.0/download"],
        strip_prefix = "scopeguard-1.1.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.scopeguard-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__serde-1.0.160",
        sha256 = "bb2f3770c8bce3bcda7e149193a069a0f4365bda1fa5cd88e03bca26afc1216c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde/1.0.160/download"],
        strip_prefix = "serde-1.0.160",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.serde-1.0.160.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__serde_json-1.0.96",
        sha256 = "057d394a50403bcac12672b2b18fb387ab6d289d957dab67dd201875391e52f1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_json/1.0.96/download"],
        strip_prefix = "serde_json-1.0.96",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.serde_json-1.0.96.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__serde_urlencoded-0.7.1",
        sha256 = "d3491c14715ca2294c4d6a88f15e84739788c1d030eed8c110436aafdaa2f3fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_urlencoded/0.7.1/download"],
        strip_prefix = "serde_urlencoded-0.7.1",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.serde_urlencoded-0.7.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__sharded-slab-0.1.4",
        sha256 = "900fba806f70c630b0a382d0d825e17a0f19fcd059a2ade1ff237bcddf446b31",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/sharded-slab/0.1.4/download"],
        strip_prefix = "sharded-slab-0.1.4",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.sharded-slab-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__signal-hook-registry-1.4.1",
        sha256 = "d8229b473baa5980ac72ef434c4415e70c4b5e71b423043adb4ba059f89c99a1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/signal-hook-registry/1.4.1/download"],
        strip_prefix = "signal-hook-registry-1.4.1",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.signal-hook-registry-1.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__slab-0.4.8",
        sha256 = "6528351c9bc8ab22353f9d776db39a20288e8d6c37ef8cfe3317cf875eecfc2d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/slab/0.4.8/download"],
        strip_prefix = "slab-0.4.8",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.slab-0.4.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__smallvec-1.10.0",
        sha256 = "a507befe795404456341dfab10cef66ead4c041f62b8b11bbb92bffe5d0953e0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/smallvec/1.10.0/download"],
        strip_prefix = "smallvec-1.10.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.smallvec-1.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__socket2-0.4.9",
        sha256 = "64a4a911eed85daf18834cfaa86a79b7d266ff93ff5ba14005426219480ed662",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/socket2/0.4.9/download"],
        strip_prefix = "socket2-0.4.9",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.socket2-0.4.9.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__syn-1.0.109",
        sha256 = "72b64191b275b66ffe2469e8af2c1cfe3bafa67b529ead792a6d0160888b4237",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/syn/1.0.109/download"],
        strip_prefix = "syn-1.0.109",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.syn-1.0.109.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__syn-2.0.15",
        sha256 = "a34fcf3e8b60f57e6a14301a2e916d323af98b0ea63c599441eec8558660c822",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/syn/2.0.15/download"],
        strip_prefix = "syn-2.0.15",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.syn-2.0.15.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__sync_wrapper-0.1.2",
        sha256 = "2047c6ded9c721764247e62cd3b03c09ffc529b2ba5b10ec482ae507a4a70160",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/sync_wrapper/0.1.2/download"],
        strip_prefix = "sync_wrapper-0.1.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.sync_wrapper-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__thread_local-1.1.7",
        sha256 = "3fdd6f064ccff2d6567adcb3873ca630700f00b5ad3f060c25b5dcfd9a4ce152",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/thread_local/1.1.7/download"],
        strip_prefix = "thread_local-1.1.7",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.thread_local-1.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tokio-1.27.0",
        sha256 = "d0de47a4eecbe11f498978a9b29d792f0d2692d1dd003650c24c76510e3bc001",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tokio/1.27.0/download"],
        strip_prefix = "tokio-1.27.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tokio-1.27.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tokio-macros-2.0.0",
        sha256 = "61a573bdc87985e9d6ddeed1b3d864e8a302c847e40d647746df2f1de209d1ce",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tokio-macros/2.0.0/download"],
        strip_prefix = "tokio-macros-2.0.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tokio-macros-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tokio-util-0.7.7",
        sha256 = "5427d89453009325de0d8f342c9490009f76e999cb7672d77e46267448f7e6b2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tokio-util/0.7.7/download"],
        strip_prefix = "tokio-util-0.7.7",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tokio-util-0.7.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-0.4.13",
        sha256 = "b8fa9be0de6cf49e536ce1851f987bd21a43b771b09473c3549a6c853db37c1c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tower/0.4.13/download"],
        strip_prefix = "tower-0.4.13",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tower-0.4.13.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-http-0.2.5",
        sha256 = "aba3f3efabf7fb41fae8534fc20a817013dd1c12cb45441efb6c82e6556b4cd8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tower-http/0.2.5/download"],
        strip_prefix = "tower-http-0.2.5",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tower-http-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-layer-0.3.2",
        sha256 = "c20c8dbed6283a09604c3e69b4b7eeb54e298b8a600d4d5ecb5ad39de609f1d0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tower-layer/0.3.2/download"],
        strip_prefix = "tower-layer-0.3.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tower-layer-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-service-0.3.2",
        sha256 = "b6bc1c9ce2b5135ac7f93c72918fc37feb872bdc6a5533a8b85eb4b86bfdae52",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tower-service/0.3.2/download"],
        strip_prefix = "tower-service-0.3.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tower-service-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-0.1.37",
        sha256 = "8ce8c33a8d48bd45d624a6e523445fd21ec13d3653cd51f681abf67418f54eb8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tracing/0.1.37/download"],
        strip_prefix = "tracing-0.1.37",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tracing-0.1.37.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-attributes-0.1.23",
        sha256 = "4017f8f45139870ca7e672686113917c71c7a6e02d4924eda67186083c03081a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tracing-attributes/0.1.23/download"],
        strip_prefix = "tracing-attributes-0.1.23",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tracing-attributes-0.1.23.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-core-0.1.30",
        sha256 = "24eb03ba0eab1fd845050058ce5e616558e8f8d8fca633e6b163fe25c797213a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tracing-core/0.1.30/download"],
        strip_prefix = "tracing-core-0.1.30",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tracing-core-0.1.30.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-log-0.1.3",
        sha256 = "78ddad33d2d10b1ed7eb9d1f518a5674713876e97e5bb9b7345a7984fbb4f922",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tracing-log/0.1.3/download"],
        strip_prefix = "tracing-log-0.1.3",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tracing-log-0.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-subscriber-0.3.17",
        sha256 = "30a651bc37f915e81f087d86e62a18eec5f79550c7faff886f7090b4ea757c77",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tracing-subscriber/0.3.17/download"],
        strip_prefix = "tracing-subscriber-0.3.17",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.tracing-subscriber-0.3.17.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__try-lock-0.2.4",
        sha256 = "3528ecfd12c466c6f163363caf2d02a71161dd5e1cc6ae7b34207ea2d42d81ed",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/try-lock/0.2.4/download"],
        strip_prefix = "try-lock-0.2.4",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.try-lock-0.2.4.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__unicode-ident-1.0.8",
        sha256 = "e5464a87b239f13a63a501f2701565754bae92d243d4bb7eb12f6d57d2269bf4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-ident/1.0.8/download"],
        strip_prefix = "unicode-ident-1.0.8",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.unicode-ident-1.0.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__valuable-0.1.0",
        sha256 = "830b7e5d4d90034032940e4ace0d9a9a057e7a45cd94e6c007832e39edb82f6d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/valuable/0.1.0/download"],
        strip_prefix = "valuable-0.1.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.valuable-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__want-0.3.0",
        sha256 = "1ce8a968cb1cd110d136ff8b819a556d6fb6d919363c61534f6860c7eb172ba0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/want/0.3.0/download"],
        strip_prefix = "want-0.3.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.want-0.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__wasi-0.11.0-wasi-snapshot-preview1",
        sha256 = "9c8d87e72b64a3b4db28d11ce29237c246188f4f51057d65a7eab63b7987e423",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasi/0.11.0+wasi-snapshot-preview1/download"],
        strip_prefix = "wasi-0.11.0+wasi-snapshot-preview1",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.wasi-0.11.0+wasi-snapshot-preview1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows-sys-0.45.0",
        sha256 = "75283be5efb2831d37ea142365f009c02ec203cd29a3ebecbc093d52315b66d0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows-sys/0.45.0/download"],
        strip_prefix = "windows-sys-0.45.0",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.windows-sys-0.45.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows-targets-0.42.2",
        sha256 = "8e5180c00cd44c9b1c88adb3693291f1cd93605ded80c250a75d472756b4d071",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows-targets/0.42.2/download"],
        strip_prefix = "windows-targets-0.42.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.windows-targets-0.42.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_aarch64_gnullvm-0.42.2",
        sha256 = "597a5118570b68bc08d8d59125332c54f1ba9d9adeedeef5b99b02ba2b0698f8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_aarch64_gnullvm/0.42.2/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.42.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.windows_aarch64_gnullvm-0.42.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_aarch64_msvc-0.42.2",
        sha256 = "e08e8864a60f06ef0d0ff4ba04124db8b0fb3be5776a5cd47641e942e58c4d43",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_aarch64_msvc/0.42.2/download"],
        strip_prefix = "windows_aarch64_msvc-0.42.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.windows_aarch64_msvc-0.42.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_i686_gnu-0.42.2",
        sha256 = "c61d927d8da41da96a81f029489353e68739737d3beca43145c8afec9a31a84f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_gnu/0.42.2/download"],
        strip_prefix = "windows_i686_gnu-0.42.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.windows_i686_gnu-0.42.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_i686_msvc-0.42.2",
        sha256 = "44d840b6ec649f480a41c8d80f9c65108b92d89345dd94027bfe06ac444d1060",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_msvc/0.42.2/download"],
        strip_prefix = "windows_i686_msvc-0.42.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.windows_i686_msvc-0.42.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_x86_64_gnu-0.42.2",
        sha256 = "8de912b8b8feb55c064867cf047dda097f92d51efad5b491dfb98f6bbb70cb36",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_gnu/0.42.2/download"],
        strip_prefix = "windows_x86_64_gnu-0.42.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.windows_x86_64_gnu-0.42.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_x86_64_gnullvm-0.42.2",
        sha256 = "26d41b46a36d453748aedef1486d5c7a85db22e56aff34643984ea85514e94a3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_gnullvm/0.42.2/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.42.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.windows_x86_64_gnullvm-0.42.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_x86_64_msvc-0.42.2",
        sha256 = "9aec5da331524158c6d1a4ac0ab1541149c0b9505fde06423b02f5ef0106b9f0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_msvc/0.42.2/download"],
        strip_prefix = "windows_x86_64_msvc-0.42.2",
        build_file = Label("@//vendor_remote_pkgs/crates:BUILD.windows_x86_64_msvc-0.42.2.bazel"),
    )
