###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @//crate_universe/3rdparty:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "crate_universe": {
        _COMMON_CONDITION: {
            "anyhow": "@cui__anyhow-1.0.68//:anyhow",
            "cargo-lock": "@cui__cargo-lock-8.0.3//:cargo_lock",
            "cargo-platform": "@cui__cargo-platform-0.1.2//:cargo_platform",
            "cargo_metadata": "@cui__cargo_metadata-0.15.3//:cargo_metadata",
            "cargo_toml": "@cui__cargo_toml-0.15.2//:cargo_toml",
            "cfg-expr": "@cui__cfg-expr-0.14.0//:cfg_expr",
            "clap": "@cui__clap-4.0.32//:clap",
            "crates-index": "@cui__crates-index-0.19.7//:crates_index",
            "hex": "@cui__hex-0.4.3//:hex",
            "normpath": "@cui__normpath-1.0.1//:normpath",
            "pathdiff": "@cui__pathdiff-0.2.1//:pathdiff",
            "regex": "@cui__regex-1.7.1//:regex",
            "semver": "@cui__semver-1.0.16//:semver",
            "serde": "@cui__serde-1.0.152//:serde",
            "serde_json": "@cui__serde_json-1.0.91//:serde_json",
            "serde_starlark": "@cui__serde_starlark-0.1.10//:serde_starlark",
            "sha2": "@cui__sha2-0.10.6//:sha2",
            "tempfile": "@cui__tempfile-3.3.0//:tempfile",
            "tera": "@cui__tera-1.17.1//:tera",
            "textwrap": "@cui__textwrap-0.16.0//:textwrap",
            "toml": "@cui__toml-0.7.2//:toml",
        },
    },
    "crate_universe/tools/cross_installer": {
        _COMMON_CONDITION: {
            "clap": "@cui__clap-4.0.32//:clap",
        },
    },
    "crate_universe/tools/urls_generator": {
        _COMMON_CONDITION: {
            "clap": "@cui__clap-4.0.32//:clap",
            "hex": "@cui__hex-0.4.3//:hex",
            "serde_json": "@cui__serde_json-1.0.91//:serde_json",
            "sha2": "@cui__sha2-0.10.6//:sha2",
        },
    },
}

_NORMAL_ALIASES = {
    "crate_universe": {
        _COMMON_CONDITION: {
        },
    },
    "crate_universe/tools/cross_installer": {
        _COMMON_CONDITION: {
        },
    },
    "crate_universe/tools/urls_generator": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "crate_universe": {
        _COMMON_CONDITION: {
            "maplit": "@cui__maplit-1.0.2//:maplit",
            "spectral": "@cui__spectral-0.6.0//:spectral",
        },
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_NORMAL_DEV_ALIASES = {
    "crate_universe": {
        _COMMON_CONDITION: {
        },
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "crate_universe": {
        _COMMON_CONDITION: {
            "indoc": "@cui__indoc-2.0.1//:indoc",
        },
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_PROC_MACRO_ALIASES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "crate_universe": {
        _COMMON_CONDITION: {
        },
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_BUILD_DEPENDENCIES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_BUILD_ALIASES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-uwp-windows-msvc": [],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"aarch64\"), target_os = \"hermit\"))": [],
    "cfg(all(any(target_os = \"android\", target_os = \"linux\"), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"), all(target_endian = \"little\", any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"powerpc64\", target_arch = \"riscv64\", target_arch = \"mips\", target_arch = \"mips64\"))))))))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-linux-android"],
    "cfg(all(not(rustix_use_libc), not(miri), target_os = \"linux\", any(target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"), all(target_endian = \"little\", any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"powerpc64\", target_arch = \"riscv64\", target_arch = \"mips\", target_arch = \"mips64\")))))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "cfg(all(target_arch = \"aarch64\", target_os = \"linux\"))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu"],
    "cfg(any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"), all(target_endian = \"little\", any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"powerpc64\", target_arch = \"riscv64\", target_arch = \"mips\", target_arch = \"mips64\")))))))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasi", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-none"],
    "cfg(any(target_arch = \"aarch64\", target_arch = \"x86_64\", target_arch = \"x86\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-none"],
    "cfg(any(target_os = \"linux\", target_os = \"android\", target_os = \"windows\", target_os = \"macos\", target_os = \"ios\", target_os = \"freebsd\", target_os = \"openbsd\", target_os = \"netbsd\", target_os = \"dragonfly\", target_os = \"solaris\", target_os = \"illumos\", target_os = \"fuchsia\", target_os = \"redox\", target_os = \"cloudabi\", target_os = \"haiku\", target_os = \"vxworks\", target_os = \"emscripten\", target_os = \"wasi\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-wasi", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "cfg(any(target_os = \"macos\", target_os = \"ios\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios"],
    "cfg(any(unix, target_os = \"wasi\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-wasi", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "cfg(not(all(target_arch = \"arm\", target_os = \"none\")))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasi", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-none"],
    "cfg(not(any(windows, target_os = \"hermit\", target_os = \"unknown\")))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-wasi", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-none"],
    "cfg(not(windows))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasi", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-none"],
    "cfg(target_arch = \"wasm32\")": ["@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasi"],
    "cfg(target_env = \"sgx\")": [],
    "cfg(target_os = \"android\")": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:x86_64-linux-android"],
    "cfg(target_os = \"dragonfly\")": [],
    "cfg(target_os = \"fuchsia\")": ["@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:x86_64-fuchsia"],
    "cfg(target_os = \"haiku\")": [],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"wasi\")": ["@rules_rust//rust/platform:wasm32-wasi"],
    "cfg(target_os = \"windows\")": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "i686-pc-windows-gnu": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-uwp-windows-gnu": [],
    "i686-uwp-windows-msvc": [],
    "x86_64-pc-windows-gnu": [],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-uwp-windows-gnu": [],
    "x86_64-uwp-windows-msvc": [],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates"""
    maybe(
        http_archive,
        name = "cui__ahash-0.7.6",
        sha256 = "fcb51a0695d8f838b1ee009b3fbf66bda078cd64590202a864a8f3e8c4315c47",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ahash/0.7.6/download"],
        strip_prefix = "ahash-0.7.6",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.ahash-0.7.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__aho-corasick-0.7.20",
        sha256 = "cc936419f96fa211c1b9166887b38e5e40b19958e5b895be7c1f93adec7071ac",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/aho-corasick/0.7.20/download"],
        strip_prefix = "aho-corasick-0.7.20",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.aho-corasick-0.7.20.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__android_system_properties-0.1.5",
        sha256 = "819e7219dbd41043ac279b19830f2efc897156490d7fd6ea916720117ee66311",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/android_system_properties/0.1.5/download"],
        strip_prefix = "android_system_properties-0.1.5",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.android_system_properties-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__anyhow-1.0.68",
        sha256 = "2cb2f989d18dd141ab8ae82f64d1a8cdd37e0840f73a406896cf5e99502fab61",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/anyhow/1.0.68/download"],
        strip_prefix = "anyhow-1.0.68",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.anyhow-1.0.68.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__autocfg-1.1.0",
        sha256 = "d468802bab17cbc0cc575e9b053f41e72aa36bfa6b7f55e3529ffa43161b97fa",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/autocfg/1.1.0/download"],
        strip_prefix = "autocfg-1.1.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.autocfg-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__block-buffer-0.10.3",
        sha256 = "69cce20737498f97b993470a6e536b8523f0af7892a4f928cceb1ac5e52ebe7e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/block-buffer/0.10.3/download"],
        strip_prefix = "block-buffer-0.10.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.block-buffer-0.10.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__bstr-1.1.0",
        sha256 = "b45ea9b00a7b3f2988e9a65ad3917e62123c38dba709b666506207be96d1790b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bstr/1.1.0/download"],
        strip_prefix = "bstr-1.1.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.bstr-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__bumpalo-3.11.1",
        sha256 = "572f695136211188308f16ad2ca5c851a712c464060ae6974944458eb83880ba",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bumpalo/3.11.1/download"],
        strip_prefix = "bumpalo-3.11.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.bumpalo-3.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__camino-1.1.2",
        sha256 = "c77df041dc383319cc661b428b6961a005db4d6808d5e12536931b1ca9556055",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/camino/1.1.2/download"],
        strip_prefix = "camino-1.1.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.camino-1.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cargo-lock-8.0.3",
        sha256 = "031718ddb8f78aa5def78a09e90defe30151d1f6c672f937af4dd916429ed996",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cargo-lock/8.0.3/download"],
        strip_prefix = "cargo-lock-8.0.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cargo-lock-8.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cargo-platform-0.1.2",
        sha256 = "cbdb825da8a5df079a43676dbe042702f1707b1109f713a01420fbb4cc71fa27",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cargo-platform/0.1.2/download"],
        strip_prefix = "cargo-platform-0.1.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cargo-platform-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cargo_metadata-0.15.3",
        sha256 = "08a1ec454bc3eead8719cb56e15dbbfecdbc14e4b3a3ae4936cc6e31f5fc0d07",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cargo_metadata/0.15.3/download"],
        strip_prefix = "cargo_metadata-0.15.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cargo_metadata-0.15.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cargo_toml-0.15.2",
        sha256 = "7f83bc2e401ed041b7057345ebc488c005efa0341d5541ce7004d30458d0090b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cargo_toml/0.15.2/download"],
        strip_prefix = "cargo_toml-0.15.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cargo_toml-0.15.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cc-1.0.78",
        sha256 = "a20104e2335ce8a659d6dd92a51a767a0c062599c73b343fd152cb401e828c3d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cc/1.0.78/download"],
        strip_prefix = "cc-1.0.78",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cc-1.0.78.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cfg-expr-0.14.0",
        sha256 = "a35b255461940a32985c627ce82900867c61db1659764d3675ea81963f72a4c6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cfg-expr/0.14.0/download"],
        strip_prefix = "cfg-expr-0.14.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cfg-expr-0.14.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__chrono-0.4.23",
        sha256 = "16b0a3d9ed01224b22057780a37bb8c5dbfe1be8ba48678e7bf57ec4b385411f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/chrono/0.4.23/download"],
        strip_prefix = "chrono-0.4.23",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.chrono-0.4.23.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__chrono-tz-0.6.3",
        sha256 = "29c39203181991a7dd4343b8005bd804e7a9a37afb8ac070e43771e8c820bbde",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/chrono-tz/0.6.3/download"],
        strip_prefix = "chrono-tz-0.6.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.chrono-tz-0.6.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__chrono-tz-build-0.0.3",
        sha256 = "6f509c3a87b33437b05e2458750a0700e5bdd6956176773e6c7d6dd15a283a0c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/chrono-tz-build/0.0.3/download"],
        strip_prefix = "chrono-tz-build-0.0.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.chrono-tz-build-0.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__clap-4.0.32",
        sha256 = "a7db700bc935f9e43e88d00b0850dae18a63773cfbec6d8e070fccf7fef89a39",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/clap/4.0.32/download"],
        strip_prefix = "clap-4.0.32",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.clap-4.0.32.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__clap_derive-4.0.21",
        sha256 = "0177313f9f02afc995627906bbd8967e2be069f5261954222dac78290c2b9014",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/clap_derive/4.0.21/download"],
        strip_prefix = "clap_derive-4.0.21",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.clap_derive-4.0.21.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__clap_lex-0.3.1",
        sha256 = "783fe232adfca04f90f56201b26d79682d4cd2625e0bc7290b95123afe558ade",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/clap_lex/0.3.1/download"],
        strip_prefix = "clap_lex-0.3.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.clap_lex-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__codespan-reporting-0.11.1",
        sha256 = "3538270d33cc669650c4b093848450d380def10c331d38c768e34cac80576e6e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/codespan-reporting/0.11.1/download"],
        strip_prefix = "codespan-reporting-0.11.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.codespan-reporting-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__core-foundation-sys-0.8.3",
        sha256 = "5827cebf4670468b8772dd191856768aedcb1b0278a04f989f7766351917b9dc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/core-foundation-sys/0.8.3/download"],
        strip_prefix = "core-foundation-sys-0.8.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.core-foundation-sys-0.8.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cpufeatures-0.2.5",
        sha256 = "28d997bd5e24a5928dd43e46dc529867e207907fe0b239c3477d924f7f2ca320",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cpufeatures/0.2.5/download"],
        strip_prefix = "cpufeatures-0.2.5",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cpufeatures-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__crates-index-0.19.7",
        sha256 = "51ddd986d8b0405750d3da55a36cfa5ddad74a6dbf8826dec1cae40bf1218bd4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crates-index/0.19.7/download"],
        strip_prefix = "crates-index-0.19.7",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.crates-index-0.19.7.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__crossbeam-utils-0.8.14",
        sha256 = "4fb766fa798726286dbbb842f174001dab8abc7b627a1dd86e0b7222a95d929f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crossbeam-utils/0.8.14/download"],
        strip_prefix = "crossbeam-utils-0.8.14",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.crossbeam-utils-0.8.14.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__crypto-common-0.1.6",
        sha256 = "1bfb12502f3fc46cca1bb51ac28df9d618d813cdc3d2f25b9fe775a34af26bb3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crypto-common/0.1.6/download"],
        strip_prefix = "crypto-common-0.1.6",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.crypto-common-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cxx-1.0.86",
        sha256 = "51d1075c37807dcf850c379432f0df05ba52cc30f279c5cfc43cc221ce7f8579",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cxx/1.0.86/download"],
        strip_prefix = "cxx-1.0.86",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cxx-1.0.86.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cxx-build-1.0.86",
        sha256 = "5044281f61b27bc598f2f6647d480aed48d2bf52d6eb0b627d84c0361b17aa70",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cxx-build/1.0.86/download"],
        strip_prefix = "cxx-build-1.0.86",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cxx-build-1.0.86.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cxxbridge-flags-1.0.86",
        sha256 = "61b50bc93ba22c27b0d31128d2d130a0a6b3d267ae27ef7e4fae2167dfe8781c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cxxbridge-flags/1.0.86/download"],
        strip_prefix = "cxxbridge-flags-1.0.86",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cxxbridge-flags-1.0.86.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cxxbridge-macro-1.0.86",
        sha256 = "39e61fda7e62115119469c7b3591fd913ecca96fb766cfd3f2e2502ab7bc87a5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cxxbridge-macro/1.0.86/download"],
        strip_prefix = "cxxbridge-macro-1.0.86",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.cxxbridge-macro-1.0.86.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__deunicode-0.4.3",
        sha256 = "850878694b7933ca4c9569d30a34b55031b9b139ee1fc7b94a527c4ef960d690",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/deunicode/0.4.3/download"],
        strip_prefix = "deunicode-0.4.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.deunicode-0.4.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__digest-0.10.6",
        sha256 = "8168378f4e5023e7218c89c891c0fd8ecdb5e5e4f18cb78f38cf245dd021e76f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/digest/0.10.6/download"],
        strip_prefix = "digest-0.10.6",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.digest-0.10.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__errno-0.2.8",
        sha256 = "f639046355ee4f37944e44f60642c6f3a7efa3cf6b78c78a0d989a8ce6c396a1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/errno/0.2.8/download"],
        strip_prefix = "errno-0.2.8",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.errno-0.2.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__errno-dragonfly-0.1.2",
        sha256 = "aa68f1b12764fab894d2755d2518754e71b4fd80ecfb822714a1206c2aab39bf",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/errno-dragonfly/0.1.2/download"],
        strip_prefix = "errno-dragonfly-0.1.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.errno-dragonfly-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__fastrand-1.8.0",
        sha256 = "a7a407cfaa3385c4ae6b23e84623d48c2798d06e3e6a1878f7f59f17b3f86499",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/fastrand/1.8.0/download"],
        strip_prefix = "fastrand-1.8.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.fastrand-1.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__fnv-1.0.7",
        sha256 = "3f9eec918d3f24069decb9af1554cad7c880e2da24a9afd88aca000531ab82c1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/fnv/1.0.7/download"],
        strip_prefix = "fnv-1.0.7",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.fnv-1.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__form_urlencoded-1.1.0",
        sha256 = "a9c384f161156f5260c24a097c56119f9be8c798586aecc13afbcbe7b7e26bf8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/form_urlencoded/1.1.0/download"],
        strip_prefix = "form_urlencoded-1.1.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.form_urlencoded-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__fuchsia-cprng-0.1.1",
        sha256 = "a06f77d526c1a601b7c4cdd98f54b5eaabffc14d5f2f0296febdc7f357c6d3ba",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/fuchsia-cprng/0.1.1/download"],
        strip_prefix = "fuchsia-cprng-0.1.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.fuchsia-cprng-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__generic-array-0.14.6",
        sha256 = "bff49e947297f3312447abdca79f45f4738097cc82b06e72054d2223f601f1b9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/generic-array/0.14.6/download"],
        strip_prefix = "generic-array-0.14.6",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.generic-array-0.14.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__getrandom-0.2.8",
        sha256 = "c05aeb6a22b8f62540c194aac980f2115af067bfe15a0734d7277a768d396b31",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/getrandom/0.2.8/download"],
        strip_prefix = "getrandom-0.2.8",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.getrandom-0.2.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__git2-0.16.1",
        sha256 = "ccf7f68c2995f392c49fffb4f95ae2c873297830eb25c6bc4c114ce8f4562acc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/git2/0.16.1/download"],
        strip_prefix = "git2-0.16.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.git2-0.16.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__globset-0.4.10",
        sha256 = "029d74589adefde59de1a0c4f4732695c32805624aec7b68d91503d4dba79afc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/globset/0.4.10/download"],
        strip_prefix = "globset-0.4.10",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.globset-0.4.10.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__globwalk-0.8.1",
        sha256 = "93e3af942408868f6934a7b85134a3230832b9977cf66125df2f9edcfce4ddcc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/globwalk/0.8.1/download"],
        strip_prefix = "globwalk-0.8.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.globwalk-0.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__hashbrown-0.12.3",
        sha256 = "8a9ee70c43aaf417c914396645a0fa852624801b24ebb7ae78fe8272889ac888",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hashbrown/0.12.3/download"],
        strip_prefix = "hashbrown-0.12.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.hashbrown-0.12.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__heck-0.4.0",
        sha256 = "2540771e65fc8cb83cd6e8a237f70c319bd5c29f78ed1084ba5d50eeac86f7f9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/heck/0.4.0/download"],
        strip_prefix = "heck-0.4.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.heck-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__hermit-abi-0.2.6",
        sha256 = "ee512640fe35acbfb4bb779db6f0d80704c2cacfa2e39b601ef3e3f47d1ae4c7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hermit-abi/0.2.6/download"],
        strip_prefix = "hermit-abi-0.2.6",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.hermit-abi-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__hex-0.4.3",
        sha256 = "7f24254aa9a54b5c858eaee2f5bccdb46aaf0e486a595ed5fd8f86ba55232a70",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hex/0.4.3/download"],
        strip_prefix = "hex-0.4.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.hex-0.4.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__home-0.5.4",
        sha256 = "747309b4b440c06d57b0b25f2aee03ee9b5e5397d288c60e21fc709bb98a7408",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/home/0.5.4/download"],
        strip_prefix = "home-0.5.4",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.home-0.5.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__humansize-1.1.1",
        sha256 = "02296996cb8796d7c6e3bc2d9211b7802812d36999a51bb754123ead7d37d026",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/humansize/1.1.1/download"],
        strip_prefix = "humansize-1.1.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.humansize-1.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__iana-time-zone-0.1.53",
        sha256 = "64c122667b287044802d6ce17ee2ddf13207ed924c712de9a66a5814d5b64765",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/iana-time-zone/0.1.53/download"],
        strip_prefix = "iana-time-zone-0.1.53",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.iana-time-zone-0.1.53.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__iana-time-zone-haiku-0.1.1",
        sha256 = "0703ae284fc167426161c2e3f1da3ea71d94b21bedbcc9494e92b28e334e3dca",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/iana-time-zone-haiku/0.1.1/download"],
        strip_prefix = "iana-time-zone-haiku-0.1.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.iana-time-zone-haiku-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__idna-0.3.0",
        sha256 = "e14ddfc70884202db2244c223200c204c2bda1bc6e0998d11b5e024d657209e6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/idna/0.3.0/download"],
        strip_prefix = "idna-0.3.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.idna-0.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__ignore-0.4.18",
        sha256 = "713f1b139373f96a2e0ce3ac931cd01ee973c3c5dd7c40c0c2efe96ad2b6751d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ignore/0.4.18/download"],
        strip_prefix = "ignore-0.4.18",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.ignore-0.4.18.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__indexmap-1.9.2",
        sha256 = "1885e79c1fc4b10f0e172c475f458b7f7b93061064d98c3293e98c5ba0c8b399",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/indexmap/1.9.2/download"],
        strip_prefix = "indexmap-1.9.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.indexmap-1.9.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__indoc-2.0.1",
        sha256 = "9f2cb48b81b1dc9f39676bf99f5499babfec7cd8fe14307f7b3d747208fb5690",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/indoc/2.0.1/download"],
        strip_prefix = "indoc-2.0.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.indoc-2.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__instant-0.1.12",
        sha256 = "7a5bbe824c507c5da5956355e86a746d82e0e1464f65d862cc5e71da70e94b2c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/instant/0.1.12/download"],
        strip_prefix = "instant-0.1.12",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.instant-0.1.12.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__io-lifetimes-1.0.4",
        sha256 = "e7d6c6f8c91b4b9ed43484ad1a938e393caf35960fce7f82a040497207bd8e9e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/io-lifetimes/1.0.4/download"],
        strip_prefix = "io-lifetimes-1.0.4",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.io-lifetimes-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__is-terminal-0.4.2",
        sha256 = "28dfb6c8100ccc63462345b67d1bbc3679177c75ee4bf59bf29c8b1d110b8189",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/is-terminal/0.4.2/download"],
        strip_prefix = "is-terminal-0.4.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.is-terminal-0.4.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__itoa-1.0.5",
        sha256 = "fad582f4b9e86b6caa621cabeb0963332d92eea04729ab12892c2533951e6440",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/itoa/1.0.5/download"],
        strip_prefix = "itoa-1.0.5",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.itoa-1.0.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__jobserver-0.1.25",
        sha256 = "068b1ee6743e4d11fb9c6a1e6064b3693a1b600e7f5f5988047d98b3dc9fb90b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/jobserver/0.1.25/download"],
        strip_prefix = "jobserver-0.1.25",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.jobserver-0.1.25.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__js-sys-0.3.60",
        sha256 = "49409df3e3bf0856b916e2ceaca09ee28e6871cf7d9ce97a692cacfdb2a25a47",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/js-sys/0.3.60/download"],
        strip_prefix = "js-sys-0.3.60",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.js-sys-0.3.60.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__lazy_static-1.4.0",
        sha256 = "e2abad23fbc42b3700f2f279844dc832adb2b2eb069b2df918f455c4e18cc646",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/lazy_static/1.4.0/download"],
        strip_prefix = "lazy_static-1.4.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.lazy_static-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__libc-0.2.139",
        sha256 = "201de327520df007757c1f0adce6e827fe8562fbc28bfd9c15571c66ca1f5f79",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/libc/0.2.139/download"],
        strip_prefix = "libc-0.2.139",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.libc-0.2.139.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__libgit2-sys-0.14.2-1.5.1",
        sha256 = "7f3d95f6b51075fe9810a7ae22c7095f12b98005ab364d8544797a825ce946a4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/libgit2-sys/0.14.2+1.5.1/download"],
        strip_prefix = "libgit2-sys-0.14.2+1.5.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.libgit2-sys-0.14.2+1.5.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__libz-sys-1.1.8",
        sha256 = "9702761c3935f8cc2f101793272e202c72b99da8f4224a19ddcf1279a6450bbf",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/libz-sys/1.1.8/download"],
        strip_prefix = "libz-sys-1.1.8",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.libz-sys-1.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__link-cplusplus-1.0.8",
        sha256 = "ecd207c9c713c34f95a097a5b029ac2ce6010530c7b49d7fea24d977dede04f5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/link-cplusplus/1.0.8/download"],
        strip_prefix = "link-cplusplus-1.0.8",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.link-cplusplus-1.0.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__linux-raw-sys-0.1.4",
        sha256 = "f051f77a7c8e6957c0696eac88f26b0117e54f52d3fc682ab19397a8812846a4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/linux-raw-sys/0.1.4/download"],
        strip_prefix = "linux-raw-sys-0.1.4",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.linux-raw-sys-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__log-0.4.17",
        sha256 = "abb12e687cfb44aa40f41fc3978ef76448f9b6038cad6aef4259d3c095a2382e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/log/0.4.17/download"],
        strip_prefix = "log-0.4.17",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.log-0.4.17.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__maplit-1.0.2",
        sha256 = "3e2e65a1a2e43cfcb47a895c4c8b10d1f4a61097f9f254f183aee60cad9c651d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/maplit/1.0.2/download"],
        strip_prefix = "maplit-1.0.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.maplit-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__memchr-2.5.0",
        sha256 = "2dffe52ecf27772e601905b7522cb4ef790d2cc203488bbd0e2fe85fcb74566d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/memchr/2.5.0/download"],
        strip_prefix = "memchr-2.5.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.memchr-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__normpath-1.0.1",
        sha256 = "3a37f4eb793d70ebef49f4643fe4b8c0e60d266e3fb607158e64b6ee24b0d6d4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/normpath/1.0.1/download"],
        strip_prefix = "normpath-1.0.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.normpath-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__num-0.1.42",
        sha256 = "4703ad64153382334aa8db57c637364c322d3372e097840c72000dabdcf6156e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num/0.1.42/download"],
        strip_prefix = "num-0.1.42",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.num-0.1.42.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__num-bigint-0.1.44",
        sha256 = "e63899ad0da84ce718c14936262a41cee2c79c981fc0a0e7c7beb47d5a07e8c1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num-bigint/0.1.44/download"],
        strip_prefix = "num-bigint-0.1.44",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.num-bigint-0.1.44.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__num-complex-0.1.43",
        sha256 = "b288631d7878aaf59442cffd36910ea604ecd7745c36054328595114001c9656",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num-complex/0.1.43/download"],
        strip_prefix = "num-complex-0.1.43",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.num-complex-0.1.43.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__num-integer-0.1.45",
        sha256 = "225d3389fb3509a24c93f5c29eb6bde2586b98d9f016636dff58d7c6f7569cd9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num-integer/0.1.45/download"],
        strip_prefix = "num-integer-0.1.45",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.num-integer-0.1.45.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__num-iter-0.1.43",
        sha256 = "7d03e6c028c5dc5cac6e2dec0efda81fc887605bb3d884578bb6d6bf7514e252",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num-iter/0.1.43/download"],
        strip_prefix = "num-iter-0.1.43",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.num-iter-0.1.43.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__num-rational-0.1.42",
        sha256 = "ee314c74bd753fc86b4780aa9475da469155f3848473a261d2d18e35245a784e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num-rational/0.1.42/download"],
        strip_prefix = "num-rational-0.1.42",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.num-rational-0.1.42.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__num-traits-0.2.15",
        sha256 = "578ede34cf02f8924ab9447f50c28075b4d3e5b269972345e7e0372b38c6cdcd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num-traits/0.2.15/download"],
        strip_prefix = "num-traits-0.2.15",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.num-traits-0.2.15.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__num_cpus-1.15.0",
        sha256 = "0fac9e2da13b5eb447a6ce3d392f23a29d8694bff781bf03a16cd9ac8697593b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num_cpus/1.15.0/download"],
        strip_prefix = "num_cpus-1.15.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.num_cpus-1.15.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__once_cell-1.17.0",
        sha256 = "6f61fba1741ea2b3d6a1e3178721804bb716a68a6aeba1149b5d52e3d464ea66",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/once_cell/1.17.0/download"],
        strip_prefix = "once_cell-1.17.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.once_cell-1.17.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__os_str_bytes-6.4.1",
        sha256 = "9b7820b9daea5457c9f21c69448905d723fbd21136ccf521748f23fd49e723ee",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/os_str_bytes/6.4.1/download"],
        strip_prefix = "os_str_bytes-6.4.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.os_str_bytes-6.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__parse-zoneinfo-0.3.0",
        sha256 = "c705f256449c60da65e11ff6626e0c16a0a0b96aaa348de61376b249bc340f41",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/parse-zoneinfo/0.3.0/download"],
        strip_prefix = "parse-zoneinfo-0.3.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.parse-zoneinfo-0.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pathdiff-0.2.1",
        sha256 = "8835116a5c179084a830efb3adc117ab007512b535bc1a21c991d3b32a6b44dd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pathdiff/0.2.1/download"],
        strip_prefix = "pathdiff-0.2.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.pathdiff-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__percent-encoding-2.2.0",
        sha256 = "478c572c3d73181ff3c2539045f6eb99e5491218eae919370993b890cdbdd98e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/percent-encoding/2.2.0/download"],
        strip_prefix = "percent-encoding-2.2.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.percent-encoding-2.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pest-2.5.3",
        sha256 = "4257b4a04d91f7e9e6290be5d3da4804dd5784fafde3a497d73eb2b4a158c30a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pest/2.5.3/download"],
        strip_prefix = "pest-2.5.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.pest-2.5.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pest_derive-2.5.3",
        sha256 = "241cda393b0cdd65e62e07e12454f1f25d57017dcc514b1514cd3c4645e3a0a6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pest_derive/2.5.3/download"],
        strip_prefix = "pest_derive-2.5.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.pest_derive-2.5.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pest_generator-2.5.3",
        sha256 = "46b53634d8c8196302953c74d5352f33d0c512a9499bd2ce468fc9f4128fa27c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pest_generator/2.5.3/download"],
        strip_prefix = "pest_generator-2.5.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.pest_generator-2.5.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pest_meta-2.5.3",
        sha256 = "0ef4f1332a8d4678b41966bb4cc1d0676880e84183a1ecc3f4b69f03e99c7a51",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pest_meta/2.5.3/download"],
        strip_prefix = "pest_meta-2.5.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.pest_meta-2.5.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__phf-0.11.1",
        sha256 = "928c6535de93548188ef63bb7c4036bd415cd8f36ad25af44b9789b2ee72a48c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/phf/0.11.1/download"],
        strip_prefix = "phf-0.11.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.phf-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__phf_codegen-0.11.1",
        sha256 = "a56ac890c5e3ca598bbdeaa99964edb5b0258a583a9eb6ef4e89fc85d9224770",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/phf_codegen/0.11.1/download"],
        strip_prefix = "phf_codegen-0.11.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.phf_codegen-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__phf_generator-0.11.1",
        sha256 = "b1181c94580fa345f50f19d738aaa39c0ed30a600d95cb2d3e23f94266f14fbf",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/phf_generator/0.11.1/download"],
        strip_prefix = "phf_generator-0.11.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.phf_generator-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__phf_shared-0.11.1",
        sha256 = "e1fb5f6f826b772a8d4c0394209441e7d37cbbb967ae9c7e0e8134365c9ee676",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/phf_shared/0.11.1/download"],
        strip_prefix = "phf_shared-0.11.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.phf_shared-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pkg-config-0.3.26",
        sha256 = "6ac9a59f73473f1b8d852421e59e64809f025994837ef743615c6d0c5b305160",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pkg-config/0.3.26/download"],
        strip_prefix = "pkg-config-0.3.26",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.pkg-config-0.3.26.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__ppv-lite86-0.2.17",
        sha256 = "5b40af805b3121feab8a3c29f04d8ad262fa8e0561883e7653e024ae4479e6de",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ppv-lite86/0.2.17/download"],
        strip_prefix = "ppv-lite86-0.2.17",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.ppv-lite86-0.2.17.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__proc-macro-error-1.0.4",
        sha256 = "da25490ff9892aab3fcf7c36f08cfb902dd3e71ca0f9f9517bea02a73a5ce38c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/proc-macro-error/1.0.4/download"],
        strip_prefix = "proc-macro-error-1.0.4",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.proc-macro-error-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__proc-macro-error-attr-1.0.4",
        sha256 = "a1be40180e52ecc98ad80b184934baf3d0d29f979574e439af5a55274b35f869",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/proc-macro-error-attr/1.0.4/download"],
        strip_prefix = "proc-macro-error-attr-1.0.4",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.proc-macro-error-attr-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__proc-macro2-1.0.49",
        sha256 = "57a8eca9f9c4ffde41714334dee777596264c7825420f521abc92b5b5deb63a5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/proc-macro2/1.0.49/download"],
        strip_prefix = "proc-macro2-1.0.49",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.proc-macro2-1.0.49.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__quote-1.0.23",
        sha256 = "8856d8364d252a14d474036ea1358d63c9e6965c8e5c1885c18f73d70bff9c7b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/quote/1.0.23/download"],
        strip_prefix = "quote-1.0.23",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.quote-1.0.23.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rand-0.4.6",
        sha256 = "552840b97013b1a26992c11eac34bdd778e464601a4c2054b5f0bff7c6761293",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand/0.4.6/download"],
        strip_prefix = "rand-0.4.6",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.rand-0.4.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rand-0.8.5",
        sha256 = "34af8d1a0e25924bc5b7c43c079c942339d8f0a8b57c39049bef581b46327404",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand/0.8.5/download"],
        strip_prefix = "rand-0.8.5",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.rand-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rand_chacha-0.3.1",
        sha256 = "e6c10a63a0fa32252be49d21e7709d4d4baf8d231c2dbce1eaa8141b9b127d88",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand_chacha/0.3.1/download"],
        strip_prefix = "rand_chacha-0.3.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.rand_chacha-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rand_core-0.3.1",
        sha256 = "7a6fdeb83b075e8266dcc8762c22776f6877a63111121f5f8c7411e5be7eed4b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand_core/0.3.1/download"],
        strip_prefix = "rand_core-0.3.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.rand_core-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rand_core-0.4.2",
        sha256 = "9c33a3c44ca05fa6f1807d8e6743f3824e8509beca625669633be0acbdf509dc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand_core/0.4.2/download"],
        strip_prefix = "rand_core-0.4.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.rand_core-0.4.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rand_core-0.6.4",
        sha256 = "ec0be4795e2f6a28069bec0b5ff3e2ac9bafc99e6a9a7dc3547996c5c816922c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand_core/0.6.4/download"],
        strip_prefix = "rand_core-0.6.4",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.rand_core-0.6.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rdrand-0.4.0",
        sha256 = "678054eb77286b51581ba43620cc911abf02758c91f93f479767aed0f90458b2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rdrand/0.4.0/download"],
        strip_prefix = "rdrand-0.4.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.rdrand-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__redox_syscall-0.2.16",
        sha256 = "fb5a58c1855b4b6819d59012155603f0b22ad30cad752600aadfcb695265519a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/redox_syscall/0.2.16/download"],
        strip_prefix = "redox_syscall-0.2.16",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.redox_syscall-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__regex-1.7.1",
        sha256 = "48aaa5748ba571fb95cd2c85c09f629215d3a6ece942baa100950af03a34f733",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/regex/1.7.1/download"],
        strip_prefix = "regex-1.7.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.regex-1.7.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__regex-syntax-0.6.28",
        sha256 = "456c603be3e8d448b072f410900c09faf164fbce2d480456f50eea6e25f9c848",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/regex-syntax/0.6.28/download"],
        strip_prefix = "regex-syntax-0.6.28",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.regex-syntax-0.6.28.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__remove_dir_all-0.5.3",
        sha256 = "3acd125665422973a33ac9d3dd2df85edad0f4ae9b00dafb1a05e43a9f5ef8e7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/remove_dir_all/0.5.3/download"],
        strip_prefix = "remove_dir_all-0.5.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.remove_dir_all-0.5.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rustc-hash-1.1.0",
        sha256 = "08d43f7aa6b08d49f382cde6a7982047c3426db949b1424bc4b7ec9ae12c6ce2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rustc-hash/1.1.0/download"],
        strip_prefix = "rustc-hash-1.1.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.rustc-hash-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rustc-serialize-0.3.24",
        sha256 = "dcf128d1287d2ea9d80910b5f1120d0b8eede3fbf1abe91c40d39ea7d51e6fda",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rustc-serialize/0.3.24/download"],
        strip_prefix = "rustc-serialize-0.3.24",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.rustc-serialize-0.3.24.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rustix-0.36.6",
        sha256 = "4feacf7db682c6c329c4ede12649cd36ecab0f3be5b7d74e6a20304725db4549",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rustix/0.36.6/download"],
        strip_prefix = "rustix-0.36.6",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.rustix-0.36.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__ryu-1.0.12",
        sha256 = "7b4b9743ed687d4b4bcedf9ff5eaa7398495ae14e61cba0a295704edbc7decde",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ryu/1.0.12/download"],
        strip_prefix = "ryu-1.0.12",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.ryu-1.0.12.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__same-file-1.0.6",
        sha256 = "93fc1dc3aaa9bfed95e02e6eadabb4baf7e3078b0bd1b4d7b6b0b68378900502",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/same-file/1.0.6/download"],
        strip_prefix = "same-file-1.0.6",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.same-file-1.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__scratch-1.0.3",
        sha256 = "ddccb15bcce173023b3fedd9436f882a0739b8dfb45e4f6b6002bee5929f61b2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/scratch/1.0.3/download"],
        strip_prefix = "scratch-1.0.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.scratch-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__semver-1.0.16",
        sha256 = "58bc9567378fc7690d6b2addae4e60ac2eeea07becb2c64b9f218b53865cba2a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/semver/1.0.16/download"],
        strip_prefix = "semver-1.0.16",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.semver-1.0.16.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__serde-1.0.152",
        sha256 = "bb7d1f0d3021d347a83e556fc4683dea2ea09d87bccdf88ff5c12545d89d5efb",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde/1.0.152/download"],
        strip_prefix = "serde-1.0.152",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.serde-1.0.152.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__serde_derive-1.0.152",
        sha256 = "af487d118eecd09402d70a5d72551860e788df87b464af30e5ea6a38c75c541e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_derive/1.0.152/download"],
        strip_prefix = "serde_derive-1.0.152",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.serde_derive-1.0.152.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__serde_json-1.0.91",
        sha256 = "877c235533714907a8c2464236f5c4b2a17262ef1bd71f38f35ea592c8da6883",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_json/1.0.91/download"],
        strip_prefix = "serde_json-1.0.91",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.serde_json-1.0.91.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__serde_spanned-0.6.1",
        sha256 = "0efd8caf556a6cebd3b285caf480045fcc1ac04f6bd786b09a6f11af30c4fcf4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_spanned/0.6.1/download"],
        strip_prefix = "serde_spanned-0.6.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.serde_spanned-0.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__serde_starlark-0.1.10",
        sha256 = "bd25c72b146e4248cfc7c45d1e12b9d1f01fc45ac698210b1be2e9cefad75452",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_starlark/0.1.10/download"],
        strip_prefix = "serde_starlark-0.1.10",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.serde_starlark-0.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__sha2-0.10.6",
        sha256 = "82e6b795fe2e3b1e845bafcb27aa35405c4d47cdfc92af5fc8d3002f76cebdc0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/sha2/0.10.6/download"],
        strip_prefix = "sha2-0.10.6",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.sha2-0.10.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__siphasher-0.3.10",
        sha256 = "7bd3e3206899af3f8b12af284fafc038cc1dc2b41d1b89dd17297221c5d225de",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/siphasher/0.3.10/download"],
        strip_prefix = "siphasher-0.3.10",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.siphasher-0.3.10.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__slug-0.1.4",
        sha256 = "b3bc762e6a4b6c6fcaade73e77f9ebc6991b676f88bb2358bddb56560f073373",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/slug/0.1.4/download"],
        strip_prefix = "slug-0.1.4",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.slug-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__smallvec-1.10.0",
        sha256 = "a507befe795404456341dfab10cef66ead4c041f62b8b11bbb92bffe5d0953e0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/smallvec/1.10.0/download"],
        strip_prefix = "smallvec-1.10.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.smallvec-1.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__smawk-0.3.1",
        sha256 = "f67ad224767faa3c7d8b6d91985b78e70a1324408abcb1cfcc2be4c06bc06043",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/smawk/0.3.1/download"],
        strip_prefix = "smawk-0.3.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.smawk-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__smol_str-0.1.24",
        sha256 = "fad6c857cbab2627dcf01ec85a623ca4e7dcb5691cbaa3d7fb7653671f0d09c9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/smol_str/0.1.24/download"],
        strip_prefix = "smol_str-0.1.24",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.smol_str-0.1.24.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__spectral-0.6.0",
        sha256 = "ae3c15181f4b14e52eeaac3efaeec4d2764716ce9c86da0c934c3e318649c5ba",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/spectral/0.6.0/download"],
        strip_prefix = "spectral-0.6.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.spectral-0.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__strsim-0.10.0",
        sha256 = "73473c0e59e6d5812c5dfe2a064a6444949f089e20eec9a2e5506596494e4623",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/strsim/0.10.0/download"],
        strip_prefix = "strsim-0.10.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.strsim-0.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__syn-1.0.107",
        sha256 = "1f4064b5b16e03ae50984a5a8ed5d4f8803e6bc1fd170a3cda91a1be4b18e3f5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/syn/1.0.107/download"],
        strip_prefix = "syn-1.0.107",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.syn-1.0.107.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tempfile-3.3.0",
        sha256 = "5cdb1ef4eaeeaddc8fbd371e5017057064af0911902ef36b39801f67cc6d79e4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tempfile/3.3.0/download"],
        strip_prefix = "tempfile-3.3.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.tempfile-3.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tera-1.17.1",
        sha256 = "3df578c295f9ec044ff1c829daf31bb7581d5b3c2a7a3d87419afe1f2531438c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tera/1.17.1/download"],
        strip_prefix = "tera-1.17.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.tera-1.17.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__termcolor-1.1.3",
        sha256 = "bab24d30b911b2376f3a13cc2cd443142f0c81dda04c118693e35b3835757755",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/termcolor/1.1.3/download"],
        strip_prefix = "termcolor-1.1.3",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.termcolor-1.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__textwrap-0.16.0",
        sha256 = "222a222a5bfe1bba4a77b45ec488a741b3cb8872e5e499451fd7d0129c9c7c3d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/textwrap/0.16.0/download"],
        strip_prefix = "textwrap-0.16.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.textwrap-0.16.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__thiserror-1.0.38",
        sha256 = "6a9cd18aa97d5c45c6603caea1da6628790b37f7a34b6ca89522331c5180fed0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/thiserror/1.0.38/download"],
        strip_prefix = "thiserror-1.0.38",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.thiserror-1.0.38.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__thiserror-impl-1.0.38",
        sha256 = "1fb327af4685e4d03fa8cbcf1716380da910eeb2bb8be417e7f9fd3fb164f36f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/thiserror-impl/1.0.38/download"],
        strip_prefix = "thiserror-impl-1.0.38",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.thiserror-impl-1.0.38.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__thread_local-1.1.4",
        sha256 = "5516c27b78311c50bf42c071425c560ac799b11c30b31f87e3081965fe5e0180",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/thread_local/1.1.4/download"],
        strip_prefix = "thread_local-1.1.4",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.thread_local-1.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tinyvec-1.6.0",
        sha256 = "87cc5ceb3875bb20c2890005a4e226a4651264a5c75edb2421b52861a0a0cb50",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tinyvec/1.6.0/download"],
        strip_prefix = "tinyvec-1.6.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.tinyvec-1.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tinyvec_macros-0.1.0",
        sha256 = "cda74da7e1a664f795bb1f8a87ec406fb89a02522cf6e50620d016add6dbbf5c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tinyvec_macros/0.1.0/download"],
        strip_prefix = "tinyvec_macros-0.1.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.tinyvec_macros-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__toml-0.5.10",
        sha256 = "1333c76748e868a4d9d1017b5ab53171dfd095f70c712fdb4653a406547f598f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/toml/0.5.10/download"],
        strip_prefix = "toml-0.5.10",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.toml-0.5.10.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__toml-0.7.2",
        sha256 = "f7afcae9e3f0fe2c370fd4657108972cbb2fa9db1b9f84849cefd80741b01cb6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/toml/0.7.2/download"],
        strip_prefix = "toml-0.7.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.toml-0.7.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__toml_datetime-0.6.1",
        sha256 = "3ab8ed2edee10b50132aed5f331333428b011c99402b5a534154ed15746f9622",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/toml_datetime/0.6.1/download"],
        strip_prefix = "toml_datetime-0.6.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.toml_datetime-0.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__toml_edit-0.19.5",
        sha256 = "7082a95d48029677a28f181e5f6422d0c8339ad8396a39d3f33d62a90c1f6c30",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/toml_edit/0.19.5/download"],
        strip_prefix = "toml_edit-0.19.5",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.toml_edit-0.19.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__typenum-1.16.0",
        sha256 = "497961ef93d974e23eb6f433eb5fe1b7930b659f06d12dec6fc44a8f554c0bba",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/typenum/1.16.0/download"],
        strip_prefix = "typenum-1.16.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.typenum-1.16.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__ucd-trie-0.1.5",
        sha256 = "9e79c4d996edb816c91e4308506774452e55e95c3c9de07b6729e17e15a5ef81",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ucd-trie/0.1.5/download"],
        strip_prefix = "ucd-trie-0.1.5",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.ucd-trie-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__uncased-0.9.7",
        sha256 = "09b01702b0fd0b3fadcf98e098780badda8742d4f4a7676615cad90e8ac73622",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/uncased/0.9.7/download"],
        strip_prefix = "uncased-0.9.7",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.uncased-0.9.7.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-char-property-0.9.0",
        sha256 = "a8c57a407d9b6fa02b4795eb81c5b6652060a15a7903ea981f3d723e6c0be221",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unic-char-property/0.9.0/download"],
        strip_prefix = "unic-char-property-0.9.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unic-char-property-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-char-range-0.9.0",
        sha256 = "0398022d5f700414f6b899e10b8348231abf9173fa93144cbc1a43b9793c1fbc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unic-char-range/0.9.0/download"],
        strip_prefix = "unic-char-range-0.9.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unic-char-range-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-common-0.9.0",
        sha256 = "80d7ff825a6a654ee85a63e80f92f054f904f21e7d12da4e22f9834a4aaa35bc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unic-common/0.9.0/download"],
        strip_prefix = "unic-common-0.9.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unic-common-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-segment-0.9.0",
        sha256 = "e4ed5d26be57f84f176157270c112ef57b86debac9cd21daaabbe56db0f88f23",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unic-segment/0.9.0/download"],
        strip_prefix = "unic-segment-0.9.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unic-segment-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-ucd-segment-0.9.0",
        sha256 = "2079c122a62205b421f499da10f3ee0f7697f012f55b675e002483c73ea34700",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unic-ucd-segment/0.9.0/download"],
        strip_prefix = "unic-ucd-segment-0.9.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unic-ucd-segment-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-ucd-version-0.9.0",
        sha256 = "96bd2f2237fe450fcd0a1d2f5f4e91711124f7857ba2e964247776ebeeb7b0c4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unic-ucd-version/0.9.0/download"],
        strip_prefix = "unic-ucd-version-0.9.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unic-ucd-version-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unicode-bidi-0.3.8",
        sha256 = "099b7128301d285f79ddd55b9a83d5e6b9e97c92e0ea0daebee7263e932de992",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-bidi/0.3.8/download"],
        strip_prefix = "unicode-bidi-0.3.8",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unicode-bidi-0.3.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unicode-ident-1.0.6",
        sha256 = "84a22b9f218b40614adcb3f4ff08b703773ad44fa9423e4e0d346d5db86e4ebc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-ident/1.0.6/download"],
        strip_prefix = "unicode-ident-1.0.6",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unicode-ident-1.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unicode-linebreak-0.1.4",
        sha256 = "c5faade31a542b8b35855fff6e8def199853b2da8da256da52f52f1316ee3137",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-linebreak/0.1.4/download"],
        strip_prefix = "unicode-linebreak-0.1.4",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unicode-linebreak-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unicode-normalization-0.1.22",
        sha256 = "5c5713f0fc4b5db668a2ac63cdb7bb4469d8c9fed047b1d0292cc7b0ce2ba921",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-normalization/0.1.22/download"],
        strip_prefix = "unicode-normalization-0.1.22",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unicode-normalization-0.1.22.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unicode-width-0.1.10",
        sha256 = "c0edd1e5b14653f783770bce4a4dabb4a5108a5370a5f5d8cfe8710c361f6c8b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-width/0.1.10/download"],
        strip_prefix = "unicode-width-0.1.10",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.unicode-width-0.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__url-2.3.1",
        sha256 = "0d68c799ae75762b8c3fe375feb6600ef5602c883c5d21eb51c09f22b83c4643",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/url/2.3.1/download"],
        strip_prefix = "url-2.3.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.url-2.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__vcpkg-0.2.15",
        sha256 = "accd4ea62f7bb7a82fe23066fb0957d48ef677f6eeb8215f372f52e48bb32426",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/vcpkg/0.2.15/download"],
        strip_prefix = "vcpkg-0.2.15",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.vcpkg-0.2.15.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__version_check-0.9.4",
        sha256 = "49874b5167b65d7193b8aba1567f5c7d93d001cafc34600cee003eda787e483f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/version_check/0.9.4/download"],
        strip_prefix = "version_check-0.9.4",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.version_check-0.9.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__walkdir-2.3.2",
        sha256 = "808cf2735cd4b6866113f648b791c6adc5714537bc222d9347bb203386ffda56",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/walkdir/2.3.2/download"],
        strip_prefix = "walkdir-2.3.2",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.walkdir-2.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__wasi-0.11.0-wasi-snapshot-preview1",
        sha256 = "9c8d87e72b64a3b4db28d11ce29237c246188f4f51057d65a7eab63b7987e423",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasi/0.11.0+wasi-snapshot-preview1/download"],
        strip_prefix = "wasi-0.11.0+wasi-snapshot-preview1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.wasi-0.11.0+wasi-snapshot-preview1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__wasm-bindgen-0.2.83",
        sha256 = "eaf9f5aceeec8be17c128b2e93e031fb8a4d469bb9c4ae2d7dc1888b26887268",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen/0.2.83/download"],
        strip_prefix = "wasm-bindgen-0.2.83",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.wasm-bindgen-0.2.83.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__wasm-bindgen-backend-0.2.83",
        sha256 = "4c8ffb332579b0557b52d268b91feab8df3615f265d5270fec2a8c95b17c1142",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-backend/0.2.83/download"],
        strip_prefix = "wasm-bindgen-backend-0.2.83",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.wasm-bindgen-backend-0.2.83.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__wasm-bindgen-macro-0.2.83",
        sha256 = "052be0f94026e6cbc75cdefc9bae13fd6052cdcaf532fa6c45e7ae33a1e6c810",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-macro/0.2.83/download"],
        strip_prefix = "wasm-bindgen-macro-0.2.83",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.wasm-bindgen-macro-0.2.83.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__wasm-bindgen-macro-support-0.2.83",
        sha256 = "07bc0c051dc5f23e307b13285f9d75df86bfdf816c5721e573dec1f9b8aa193c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-macro-support/0.2.83/download"],
        strip_prefix = "wasm-bindgen-macro-support-0.2.83",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.wasm-bindgen-macro-support-0.2.83.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__wasm-bindgen-shared-0.2.83",
        sha256 = "1c38c045535d93ec4f0b4defec448e4291638ee608530863b1e2ba115d4fff7f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-shared/0.2.83/download"],
        strip_prefix = "wasm-bindgen-shared-0.2.83",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.wasm-bindgen-shared-0.2.83.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winapi-util-0.1.5",
        sha256 = "70ec6ce85bb158151cae5e5c87f95a8e97d2c0c4b001223f33a334e3ce5de178",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-util/0.1.5/download"],
        strip_prefix = "winapi-util-0.1.5",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.winapi-util-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows-sys-0.42.0",
        sha256 = "5a3e1820f08b8513f676f7ab6c1f99ff312fb97b553d30ff4dd86f9f15728aa7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows-sys/0.42.0/download"],
        strip_prefix = "windows-sys-0.42.0",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.windows-sys-0.42.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_aarch64_gnullvm-0.42.1",
        sha256 = "8c9864e83243fdec7fc9c5444389dcbbfd258f745e7853198f365e3c4968a608",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_aarch64_gnullvm/0.42.1/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.42.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.windows_aarch64_gnullvm-0.42.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_aarch64_msvc-0.42.1",
        sha256 = "4c8b1b673ffc16c47a9ff48570a9d85e25d265735c503681332589af6253c6c7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_aarch64_msvc/0.42.1/download"],
        strip_prefix = "windows_aarch64_msvc-0.42.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.windows_aarch64_msvc-0.42.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_i686_gnu-0.42.1",
        sha256 = "de3887528ad530ba7bdbb1faa8275ec7a1155a45ffa57c37993960277145d640",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_gnu/0.42.1/download"],
        strip_prefix = "windows_i686_gnu-0.42.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.windows_i686_gnu-0.42.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_i686_msvc-0.42.1",
        sha256 = "bf4d1122317eddd6ff351aa852118a2418ad4214e6613a50e0191f7004372605",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_msvc/0.42.1/download"],
        strip_prefix = "windows_i686_msvc-0.42.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.windows_i686_msvc-0.42.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_x86_64_gnu-0.42.1",
        sha256 = "c1040f221285e17ebccbc2591ffdc2d44ee1f9186324dd3e84e99ac68d699c45",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_gnu/0.42.1/download"],
        strip_prefix = "windows_x86_64_gnu-0.42.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.windows_x86_64_gnu-0.42.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_x86_64_gnullvm-0.42.1",
        sha256 = "628bfdf232daa22b0d64fdb62b09fcc36bb01f05a3939e20ab73aaf9470d0463",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_gnullvm/0.42.1/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.42.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.windows_x86_64_gnullvm-0.42.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_x86_64_msvc-0.42.1",
        sha256 = "447660ad36a13288b1db4d4248e857b510e8c3a225c822ba4fb748c0aafecffd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_msvc/0.42.1/download"],
        strip_prefix = "windows_x86_64_msvc-0.42.1",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.windows_x86_64_msvc-0.42.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winnow-0.3.5",
        sha256 = "ee7b2c67f962bf5042bfd8b6a916178df33a26eec343ae064cb8e069f638fa6f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winnow/0.3.5/download"],
        strip_prefix = "winnow-0.3.5",
        build_file = Label("@rules_rust//crate_universe/3rdparty/crates:BUILD.winnow-0.3.5.bazel"),
    )
