// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

// THIS FILE WAS AUTO-GENERATED BY ./ntcore/generate_topics.py. DO NOT MODIFY

#pragma once

#include <vector>

#include "networktables/StringArrayTopic.h"
#include "networktables/NetworkTableType.h"
#include "ntcore_cpp.h"

namespace nt {

inline StringArraySubscriber::StringArraySubscriber(
    NT_Subscriber handle, std::span<const std::string> defaultValue)
    : Subscriber{handle},
      m_defaultValue{defaultValue.begin(), defaultValue.end()} {}

inline std::vector<std::string> StringArraySubscriber::Get() const {
  return Get(m_defaultValue);
}

inline std::vector<std::string> StringArraySubscriber::Get(
    std::span<const std::string> defaultValue) const {
  return ::nt::GetStringArray(m_subHandle, defaultValue);
}

inline TimestampedStringArray StringArraySubscriber::GetAtomic() const {
  return GetAtomic(m_defaultValue);
}

inline TimestampedStringArray StringArraySubscriber::GetAtomic(
    std::span<const std::string> defaultValue) const {
  return ::nt::GetAtomicStringArray(m_subHandle, defaultValue);
}

inline std::vector<TimestampedStringArray>
StringArraySubscriber::ReadQueue() {
  return ::nt::ReadQueueStringArray(m_subHandle);
}

inline StringArrayTopic StringArraySubscriber::GetTopic() const {
  return StringArrayTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline StringArrayPublisher::StringArrayPublisher(NT_Publisher handle)
    : Publisher{handle} {}

inline void StringArrayPublisher::Set(std::span<const std::string> value,
                                         int64_t time) {
  ::nt::SetStringArray(m_pubHandle, value, time);
}

inline void StringArrayPublisher::SetDefault(std::span<const std::string> value) {
  ::nt::SetDefaultStringArray(m_pubHandle, value);
}

inline StringArrayTopic StringArrayPublisher::GetTopic() const {
  return StringArrayTopic{::nt::GetTopicFromHandle(m_pubHandle)};
}

inline StringArrayEntry::StringArrayEntry(
    NT_Entry handle, std::span<const std::string> defaultValue)
    : StringArraySubscriber{handle, defaultValue},
      StringArrayPublisher{handle} {}

inline StringArrayTopic StringArrayEntry::GetTopic() const {
  return StringArrayTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline void StringArrayEntry::Unpublish() {
  ::nt::Unpublish(m_pubHandle);
}

inline StringArraySubscriber StringArrayTopic::Subscribe(
    std::span<const std::string> defaultValue,
    const PubSubOptions& options) {
  return StringArraySubscriber{
      ::nt::Subscribe(m_handle, NT_STRING_ARRAY, "string[]", options),
      defaultValue};
}
inline StringArraySubscriber StringArrayTopic::SubscribeEx(
    std::string_view typeString, std::span<const std::string> defaultValue,
    const PubSubOptions& options) {
  return StringArraySubscriber{
      ::nt::Subscribe(m_handle, NT_STRING_ARRAY, typeString, options),
      defaultValue};
}

inline StringArrayPublisher StringArrayTopic::Publish(
    const PubSubOptions& options) {
  return StringArrayPublisher{
      ::nt::Publish(m_handle, NT_STRING_ARRAY, "string[]", options)};
}

inline StringArrayPublisher StringArrayTopic::PublishEx(
    std::string_view typeString,
    const wpi::json& properties, const PubSubOptions& options) {
  return StringArrayPublisher{
      ::nt::PublishEx(m_handle, NT_STRING_ARRAY, typeString, properties, options)};
}

inline StringArrayEntry StringArrayTopic::GetEntry(
    std::span<const std::string> defaultValue,
    const PubSubOptions& options) {
  return StringArrayEntry{
      ::nt::GetEntry(m_handle, NT_STRING_ARRAY, "string[]", options),
      defaultValue};
}
inline StringArrayEntry StringArrayTopic::GetEntryEx(
    std::string_view typeString, std::span<const std::string> defaultValue,
    const PubSubOptions& options) {
  return StringArrayEntry{
      ::nt::GetEntry(m_handle, NT_STRING_ARRAY, typeString, options),
      defaultValue};
}

}  // namespace nt
