// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

// THIS FILE WAS AUTO-GENERATED BY ./ntcore/generate_topics.py. DO NOT MODIFY

#pragma once

#include <vector>

#include "networktables/BooleanTopic.h"
#include "networktables/NetworkTableType.h"
#include "ntcore_cpp.h"

namespace nt {

inline BooleanSubscriber::BooleanSubscriber(
    NT_Subscriber handle, bool defaultValue)
    : Subscriber{handle},
      m_defaultValue{defaultValue} {}

inline bool BooleanSubscriber::Get() const {
  return Get(m_defaultValue);
}

inline bool BooleanSubscriber::Get(
    bool defaultValue) const {
  return ::nt::GetBoolean(m_subHandle, defaultValue);
}

inline TimestampedBoolean BooleanSubscriber::GetAtomic() const {
  return GetAtomic(m_defaultValue);
}

inline TimestampedBoolean BooleanSubscriber::GetAtomic(
    bool defaultValue) const {
  return ::nt::GetAtomicBoolean(m_subHandle, defaultValue);
}

inline std::vector<TimestampedBoolean>
BooleanSubscriber::ReadQueue() {
  return ::nt::ReadQueueBoolean(m_subHandle);
}

inline BooleanTopic BooleanSubscriber::GetTopic() const {
  return BooleanTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline BooleanPublisher::BooleanPublisher(NT_Publisher handle)
    : Publisher{handle} {}

inline void BooleanPublisher::Set(bool value,
                                         int64_t time) {
  ::nt::SetBoolean(m_pubHandle, value, time);
}

inline void BooleanPublisher::SetDefault(bool value) {
  ::nt::SetDefaultBoolean(m_pubHandle, value);
}

inline BooleanTopic BooleanPublisher::GetTopic() const {
  return BooleanTopic{::nt::GetTopicFromHandle(m_pubHandle)};
}

inline BooleanEntry::BooleanEntry(
    NT_Entry handle, bool defaultValue)
    : BooleanSubscriber{handle, defaultValue},
      BooleanPublisher{handle} {}

inline BooleanTopic BooleanEntry::GetTopic() const {
  return BooleanTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline void BooleanEntry::Unpublish() {
  ::nt::Unpublish(m_pubHandle);
}

inline BooleanSubscriber BooleanTopic::Subscribe(
    bool defaultValue,
    const PubSubOptions& options) {
  return BooleanSubscriber{
      ::nt::Subscribe(m_handle, NT_BOOLEAN, "boolean", options),
      defaultValue};
}
inline BooleanSubscriber BooleanTopic::SubscribeEx(
    std::string_view typeString, bool defaultValue,
    const PubSubOptions& options) {
  return BooleanSubscriber{
      ::nt::Subscribe(m_handle, NT_BOOLEAN, typeString, options),
      defaultValue};
}

inline BooleanPublisher BooleanTopic::Publish(
    const PubSubOptions& options) {
  return BooleanPublisher{
      ::nt::Publish(m_handle, NT_BOOLEAN, "boolean", options)};
}

inline BooleanPublisher BooleanTopic::PublishEx(
    std::string_view typeString,
    const wpi::json& properties, const PubSubOptions& options) {
  return BooleanPublisher{
      ::nt::PublishEx(m_handle, NT_BOOLEAN, typeString, properties, options)};
}

inline BooleanEntry BooleanTopic::GetEntry(
    bool defaultValue,
    const PubSubOptions& options) {
  return BooleanEntry{
      ::nt::GetEntry(m_handle, NT_BOOLEAN, "boolean", options),
      defaultValue};
}
inline BooleanEntry BooleanTopic::GetEntryEx(
    std::string_view typeString, bool defaultValue,
    const PubSubOptions& options) {
  return BooleanEntry{
      ::nt::GetEntry(m_handle, NT_BOOLEAN, typeString, options),
      defaultValue};
}

}  // namespace nt
