// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package edu.wpi.first.apriltag;

import java.io.IOException;
import java.io.UncheckedIOException;

/** Loadable AprilTag field layouts. */
public enum AprilTagFields {
  /** 2022 Rapid React. */
  k2022RapidReact("2022-rapidreact.json"),
  /** 2023 Charged Up. */
  k2023ChargedUp("2023-chargedup.json"),
  /** 2024 Crescendo. */
  k2024Crescendo("2024-crescendo.json");

  /** Base resource directory. */
  public static final String kBaseResourceDir = "/edu/wpi/first/apriltag/";

  /** Alias to the current game. */
  public static final AprilTagFields kDefaultField = k2024Crescendo;

  /** Resource filename. */
  public final String m_resourceFile;

  AprilTagFields(String resourceFile) {
    m_resourceFile = kBaseResourceDir + resourceFile;
  }

  /**
   * Get a {@link AprilTagFieldLayout} from the resource JSON.
   *
   * @return AprilTagFieldLayout of the field
   * @throws UncheckedIOException If the layout does not exist
   */
  public AprilTagFieldLayout loadAprilTagLayoutField() {
    try {
      return AprilTagFieldLayout.loadFromResource(m_resourceFile);
    } catch (IOException e) {
      throw new UncheckedIOException(
          "Could not load AprilTagFieldLayout from " + m_resourceFile, e);
    }
  }
}
