(*:Name: Ionization *)

(* :Title: Ionization *)

(* :Author: Tom Wickham-Jones*)

(* :Summary: *)

(* :Context: ExtendGraphics`Ionization` *)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 2.2 *)

(*:Summary:
	This package extends the package Miscellaneous`ChemicalElements`
	to add information on the first ionization energy of the elements.
*)

(* :Source: The Elements, John Emsley, Oxford University Press, 1989; 
		CRC, 69th Edition *)

(* :History:
	Created summer 1993 by Tom Wickham-Jones.
*)

(*:Warnings:
*)


BeginPackage[ "ExtendGraphics`Ionization`", 
		"Miscellaneous`ChemicalElements`",
		"Miscellaneous`Units`",
		"Miscellaneous`SIUnits`"]


Ionization::usage =
	"Ionization[element] gives the first ionization energy of the 
	specified element."


Begin[ "`Private`"]


Ionization::unknown =
	"The first ionization energy of `1` is not known."

IonizationNA[name_Symbol] :=
	(Message[Ionization::unknown, name]; Unknown)

Attributes[ Ionization] = Listable


Ionization[x_] := 
	Module[
		   { i = Flatten[Position[ElementAbbreviations,ToString[x]]]},
           Ionization[ Elements[[ i[[1]] ]] ] /;
		       !SameQ[i,{}]
                 ]

Off[ Ionization::unknown]

Ionization[ Hydrogen] ^= 1312.0 Kilo Joule / Mole
Ionization[ Helium] ^= 2372.3 Kilo Joule / Mole
Ionization[ Lithium] ^= 513.3 Kilo Joule / Mole
Ionization[ Beryllium] ^= 899.4 Kilo Joule / Mole
Ionization[ Boron] ^= 800.6 Kilo Joule / Mole
Ionization[ Carbon] ^= 1086.2 Kilo Joule / Mole
Ionization[ Nitrogen] ^= 1302.3 Kilo Joule / Mole
Ionization[ Oxygen] ^= 1313.9 Kilo Joule / Mole
Ionization[ Fluorine] ^= 1681 Kilo Joule / Mole
Ionization[ Neon] ^= 2080.6 Kilo Joule / Mole

Ionization[ Sodium] ^= 495.8 Kilo Joule / Mole
Ionization[ Magnesium] ^= 737.7 Kilo Joule / Mole
Ionization[ Aluminium] ^= 577.4 Kilo Joule / Mole
Ionization[ Silicon] ^= 786.5 Kilo Joule / Mole
Ionization[ Phosphorus] ^= 1011.7 Kilo Joule / Mole
Ionization[ Sulfur] ^= 999.6 Kilo Joule / Mole
Ionization[ Chlorine] ^= 1251.1 Kilo Joule / Mole
Ionization[ Argon] ^= 1520.4 Kilo Joule / Mole

Ionization[ Potassium] ^= 418.8 Kilo Joule / Mole
Ionization[ Calcium] ^= 589.7 Kilo Joule / Mole

Ionization[ Scandium] ^= 631. Kilo Joule / Mole
Ionization[ Titanium] ^= 658 Kilo Joule / Mole
Ionization[ Vanadium] ^= 650 Kilo Joule / Mole
Ionization[ Chromium] ^= 652.7 Kilo Joule / Mole
Ionization[ Manganese] ^= 717.4 Kilo Joule / Mole
Ionization[Iron] ^= 759.3 Kilo Joule / Mole
Ionization[Cobalt] ^= 760. Kilo Joule / Mole
Ionization[Nickel] ^= 736.7 Kilo Joule / Mole
Ionization[Copper] ^= 745.4 Kilo Joule / Mole
Ionization[Zinc] ^= 906.4 Kilo Joule / Mole
Ionization[Gallium] ^=578.8 Kilo Joule / Mole
Ionization[Germanium] ^= 762.1 Kilo Joule / Mole
Ionization[Arsenic] ^= 947. Kilo Joule / Mole
Ionization[Selenium] ^= 940.9 Kilo Joule / Mole
Ionization[Bromine] ^= 1139.9 Kilo Joule / Mole
Ionization[Krypton] ^= 1350.7 Kilo Joule / Mole
Ionization[Rubidium] ^= 403. Kilo Joule / Mole
Ionization[Strontium] ^= 549.5 Kilo Joule / Mole
Ionization[Yttrium] ^= 616 Kilo Joule / Mole
Ionization[Zirconium] ^= 660 Kilo Joule / Mole
Ionization[Niobium] ^= 664 Kilo Joule / Mole
Ionization[Molybdenum] ^=685. Kilo Joule / Mole
Ionization[Technetium] ^= 702. Kilo Joule / Mole
Ionization[Ruthenium] ^= 711 Kilo Joule / Mole
Ionization[Rhodium] ^= 720 Kilo Joule / Mole
Ionization[Palladium] ^= 805 Kilo Joule / Mole
Ionization[Silver] ^= 731. Kilo Joule / Mole
Ionization[Cadmium] ^= 876.6 Kilo Joule / Mole
Ionization[Indium] ^= 558.3 Kilo Joule / Mole
Ionization[Tin] ^= 708.6 Kilo Joule / Mole
Ionization[Antimony] ^= 833.7 Kilo Joule / Mole
Ionization[Tellurium] ^= 869.2 Kilo Joule / Mole
Ionization[Iodine] ^= 1008.4 Kilo Joule / Mole
Ionization[Xenon] ^= 1170.4 Kilo Joule / Mole
Ionization[Caesium] ^= 375.7 Kilo Joule / Mole
Ionization[Barium] ^= 502.8 Kilo Joule / Mole
Ionization[Lanthanum] ^= 538.1 Kilo Joule / Mole
Ionization[Cerium] ^= 527.4 Kilo Joule / Mole
Ionization[Praseodymium] ^= 523.1 Kilo Joule / Mole
Ionization[Neodymium] ^= 529.6 Kilo Joule / Mole
Ionization[Promethium] ^= 535.9 Kilo Joule / Mole
Ionization[Samarium] ^= 543.3 Kilo Joule / Mole
Ionization[Europium] ^= 546.7 Kilo Joule / Mole
Ionization[Gadolinium] ^= 592.5 Kilo Joule / Mole
Ionization[Terbium] ^= 564.6 Kilo Joule / Mole
Ionization[Dysprosium] ^= 571.9 Kilo Joule / Mole
Ionization[Holmium] ^= 580.7 Kilo Joule / Mole
Ionization[Erbium] ^= 588.7 Kilo Joule / Mole
Ionization[Thulium] ^= 596.7 Kilo Joule / Mole
Ionization[Ytterbium] ^= 603.4 Kilo Joule / Mole
Ionization[Lutetium] ^= 523.5 Kilo Joule / Mole
Ionization[Hafnium] ^= 642. Kilo Joule / Mole
Ionization[Tantalum] ^= 761 Kilo Joule / Mole
Ionization[Tungsten] ^= 770 Kilo Joule / Mole
Ionization[Rhenium] ^= 760 Kilo Joule / Mole
Ionization[Osmium] ^= 840 Kilo Joule / Mole
Ionization[Iridium] ^= 880 Kilo Joule / Mole
Ionization[Platinum] ^= 870 Kilo Joule / Mole
Ionization[Gold] ^= 890.1 Kilo Joule / Mole
Ionization[Mercury] ^= 1007. Kilo Joule / Mole
Ionization[Thallium] ^= 589.3 Kilo Joule / Mole
Ionization[Lead] ^= 715.5 Kilo Joule / Mole
Ionization[Bismuth] ^= 703.2 Kilo Joule / Mole
Ionization[Polonium] ^= 812 Kilo Joule / Mole
Ionization[Astatine] ^= 930 Kilo Joule / Mole
Ionization[Radon] ^= 1037 Kilo Joule / Mole
Ionization[Francium] ^= 400 Kilo Joule / Mole
Ionization[Radium] ^= 509.3 Kilo Joule / Mole
Ionization[Actinium] ^= 499 Kilo Joule / Mole
Ionization[Thorium] ^= 587 Kilo Joule / Mole
Ionization[Protactinium] ^= 568 Kilo Joule / Mole
Ionization[Uranium] ^= 584 Kilo Joule / Mole
Ionization[Neptunium] ^= 597 Kilo Joule / Mole
Ionization[Plutonium] ^= 585 Kilo Joule / Mole
Ionization[Americium] ^= 578.2 Kilo Joule / Mole
Ionization[Curium] ^= 581 Kilo Joule / Mole
Ionization[Berkelium] ^= 601 Kilo Joule / Mole
Ionization[Californium] ^= 608 Kilo Joule / Mole
Ionization[Einsteinium] ^= 619 Kilo Joule / Mole
Ionization[Fermium] ^= 627 Kilo Joule / Mole
Ionization[Mendelevium] ^= 635 Kilo Joule / Mole
Ionization[Nobelium] ^=2 642 Kilo Joule / Mole

Ionization[Lawrencium] ^:= IonizationNA[Lawrencium]
Ionization[Unnilquadium] ^:= IonizationNA[Unnilquadium]
Ionization[Unnilpentium] ^:= IonizationNA[Unnilpentium]
Ionization[Unnilhexium] ^:= IonizationNA[Unnilhexium]


End[]

EndPackage[]

