(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4793,        177]*)
(*NotebookOutlinePosition[      5704,        208]*)
(*  CellTagsIndexPosition[      5660,        204]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Plotting Irregular Contours"], "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
This notebook demonstrates how to plot contours from irregular data. 
The topic is described in more detail in the book:

\tMathematica Graphics: Techniques and Applications.
\tTom Wickham-Jones, TELOS/Springer-Verlag 1994.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "This package is now updated to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 3.0."
}], "Text"],

Cell[CellGroupData[{

Cell["Installation and Initialization", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The ",
  StyleBox["ExtendGraphics", "Input"],
  " directory should be put in one of the canonical places for AddOns.   Two \
recommended places are first inside the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distribution in:"
}], "Text"],

Cell[BoxData[
    \(ToFileName[\ {$TopDirectory, \ "\<AddOns\>", \ "\<Applications\>"}]\)], 
  "Input"],

Cell["a second in the preferences directory:", "Text"],

Cell[BoxData[
    \(ToFileName[
      \ {$PreferencesDirectory, \ "\<AddOns\>", \ "\<Applications\>"}]\)], 
  "Input"],

Cell[TextData[{
  "When one of these locations is used there is no need to set $Path and the \
loading instructions are identical for all versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " binary delaunay.exe is provided for the Windows95 and Macintosh versions. \
 For other versions it should be built with the mcc tools that are provided."
}], "Text"],

Cell[TextData[{
  "The  ",
  StyleBox["ExtendGraphics`Contour` ", "Input"],
  "package can  be loaded"
}], "Text"],

Cell["Needs[ \"ExtendGraphics`Contour`\"]", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Turn off spelling checker", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Off[ General::spell];
Off[ General::spell1];
\
\>", "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Contours over Irregular Data"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Data to be plotted."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
pts = 
  Flatten[
    Table[
      Table[{r Sin[t], r Cos[t], r^2 Cos[t] Sin[t]}, 
            {t, 0, 2Pi-2Pi/( 10 r),2Pi/ (10 r)}],
        {r,5}], 1];\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData[
"The data do not fall in a regular rectangular grid.  The normal \
ListContourPlot could not plot contours from this data."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Show[Graphics[Map[Point[Drop[#,-1]]&, pts]]];", "Input",
  AspectRatioFixed->True],

Cell[TextData[
"The extended ListContourPlot can plot contours from the data."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["ListContourPlot[pts];", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{496, 436},
WindowMargins->{{Automatic, 128}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 102, 2, 105, "Title"],
Cell[1836, 55, 295, 8, 109, "Text"],
Cell[2134, 65, 134, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[2293, 74, 98, 2, 53, "Section"],
Cell[2394, 78, 272, 8, 53, "Text"],
Cell[2669, 88, 103, 2, 30, "Input"],
Cell[2775, 92, 54, 0, 33, "Text"],
Cell[2832, 94, 118, 3, 50, "Input"],
Cell[2953, 99, 222, 6, 52, "Text"],
Cell[3178, 107, 244, 6, 52, "Text"],
Cell[3425, 115, 114, 4, 34, "Text"],
Cell[3542, 121, 78, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[3645, 126, 95, 2, 47, "Subsection"],
Cell[3743, 130, 70, 4, 66, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3862, 140, 105, 2, 33, "Section"],
Cell[3970, 144, 93, 2, 33, "Text"],
Cell[4066, 148, 203, 8, 120, "Input"],
Cell[4272, 158, 196, 4, 52, "Text"],
Cell[4471, 164, 88, 1, 30, "Input"],
Cell[4562, 167, 136, 3, 33, "Text"],
Cell[4701, 172, 64, 1, 30, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

