/**********************************************************************************************************************
This file is part of the Control Toolbox (https://adrlab.bitbucket.io/ct), copyright by ETH Zurich, Google Inc.
Authors:  Michael Neunert, Markus Giftthaler, Markus Stäuble, Diego Pardo, Farbod Farshidian
Licensed under Apache2 license (see LICENSE file in main directory)
**********************************************************************************************************************/
#include "HyQForwardKinJacReverse.h"

namespace ct {
namespace models {
namespace HyQ {


HyQForwardKinJacReverse::JAC_TYPE HyQForwardKinJacReverse::jacobian(const Eigen::VectorXd& x_in)
{
    double* jac = jac_.data();

        v_[0] = cos(x_in[6]);
    v_[1] = 0.33 * v_[0];
    v_[2] = sin(x_in[7]);
    v_[3] = v_[1] * v_[2];
    v_[4] = sin(x_in[8]);
    v_[5] = 0.33 * v_[0];
    v_[6] = cos(x_in[7]);
    v_[7] = v_[5] * v_[6];
    v_[8] = cos(x_in[8]);
    v_[9] = 0.35 * v_[0];
    v_[10] = v_[3] * v_[4] - v_[7] * v_[8] - v_[9] * v_[6] - 0.08 * v_[0];
    v_[11] = 0.5 * x_in[0];
    v_[12] = cos(v_[11]);
    v_[13] = 0.5 * x_in[1];
    v_[14] = cos(v_[13]);
    v_[15] = v_[12] * v_[14];
    v_[16] = 0.5 * x_in[2];
    v_[17] = sin(v_[16]);
    v_[18] = sin(v_[11]);
    v_[19] = sin(v_[13]);
    v_[20] = v_[18] * v_[19];
    v_[21] = cos(v_[16]);
    v_[22] = v_[15] * v_[17] + v_[20] * v_[21];
    v_[23] = 2. * v_[22];
    v_[24] = sin(x_in[6]);
    v_[25] = 0.33 * v_[24];
    v_[26] = v_[25] * v_[2];
    v_[27] = 0.33 * v_[24];
    v_[28] = v_[27] * v_[6];
    v_[29] = 0.35 * v_[24];
    v_[30] = 0.207 + v_[26] * v_[4] - v_[28] * v_[8] - v_[29] * v_[6] - 0.08 * v_[24];
    v_[31] = v_[12] * v_[19];
    v_[32] = v_[18] * v_[14];
    v_[33] = v_[31] * v_[21] - v_[32] * v_[17];
    v_[34] = 2. * v_[33];
    v_[35] = v_[10] * v_[23] + v_[30] * v_[34];
    v_[36] = -0.33 * v_[6];
    v_[37] = 0.33 * v_[2];
    v_[38] = 0.3735 + v_[36] * v_[4] - v_[37] * v_[8] - 0.35 * v_[2];
    v_[39] = 0 - v_[38];
    v_[40] = v_[32] * v_[21] + v_[31] * v_[17];
    v_[41] = v_[15] * v_[21] - v_[20] * v_[17];
    v_[39] = v_[39] * v_[34] + (v_[39] * v_[33] + v_[30] * v_[40] + v_[10] * v_[41]) * 2.;
    v_[42] = 0 - v_[39];
    v_[43] = v_[35] * v_[21] + v_[42] * v_[17];
    v_[44] = 0 - v_[30];
    v_[45] = v_[44] * v_[23] + v_[10] * v_[34];
    v_[46] = 0 - v_[45];
    v_[47] = 0 - v_[38];
    v_[47] = v_[47] * v_[23] + (v_[47] * v_[22] + v_[10] * v_[40] + v_[44] * v_[41]) * 2.;
    v_[44] = v_[46] * v_[17] + v_[47] * v_[21];
    v_[48] = cos(v_[11]);
    v_[49] = v_[45] * v_[21] + v_[47] * v_[17];
    v_[50] = v_[35] * v_[17] + v_[39] * v_[21];
    v_[11] = sin(v_[11]);
    jac[0] = ((v_[43] * v_[14] + v_[44] * v_[19]) * v_[48] - (v_[49] * v_[14] + v_[50] * v_[19]) * v_[11]) * 0.5;
    v_[51] = 0 - v_[30];
    v_[52] = 2. * v_[40];
    v_[53] = 0 - v_[10];
    v_[51] = v_[38] * v_[34] + v_[51] * v_[52] + (v_[51] * v_[40] + v_[53] * v_[41]) * 2.;
    v_[54] = v_[10] * v_[23] + v_[38] * v_[40] * 2.;
    v_[55] = 0 - v_[54];
    v_[56] = v_[51] * v_[21] + v_[55] * v_[17];
    v_[53] = v_[38] * v_[23] + v_[53] * v_[52];
    v_[57] = 0 - v_[53];
    v_[58] = 0 - v_[30];
    v_[58] = v_[58] * v_[23] + (v_[58] * v_[22] + v_[10] * v_[33] + v_[38] * v_[41]) * 2.;
    v_[59] = v_[57] * v_[17] + v_[58] * v_[21];
    v_[60] = v_[53] * v_[21] + v_[58] * v_[17];
    v_[61] = v_[51] * v_[17] + v_[54] * v_[21];
    jac[1] = ((v_[56] * v_[14] + v_[59] * v_[19]) * v_[48] - (v_[60] * v_[14] + v_[61] * v_[19]) * v_[11]) * 0.5;
    v_[62] = 0 - v_[10];
    v_[62] = v_[38] * v_[23] + v_[62] * v_[52] + (v_[62] * v_[40] + v_[30] * v_[41]) * 2.;
    v_[10] = 0 - v_[10];
    v_[63] = 0 - v_[38];
    v_[10] = v_[30] * v_[23] + v_[10] * v_[34] + (v_[10] * v_[33] + v_[63] * v_[41]) * 2.;
    v_[64] = 0 - v_[10];
    v_[65] = v_[62] * v_[21] + v_[64] * v_[17];
    v_[63] = v_[63] * v_[34] + v_[30] * v_[52];
    v_[66] = 0 - v_[63];
    v_[38] = (v_[30] * v_[33] + v_[38] * v_[40]) * 2.;
    v_[30] = v_[66] * v_[17] + v_[38] * v_[21];
    v_[67] = v_[63] * v_[21] + v_[38] * v_[17];
    v_[21] = v_[62] * v_[17] + v_[10] * v_[21];
    jac[2] = ((v_[65] * v_[14] + v_[30] * v_[19]) * v_[48] - (v_[67] * v_[14] + v_[21] * v_[19]) * v_[11]) * 0.5;
    v_[11] = 0.33 * v_[0];
    v_[48] = v_[11] * v_[6];
    v_[19] = 0.33 * v_[0];
    v_[14] = v_[19] * v_[2];
    v_[17] = v_[48] * v_[4] + v_[14] * v_[8];
    v_[68] = v_[11] * v_[2];
    v_[69] = 0.33 * v_[0];
    v_[70] = v_[69] * v_[6];
    v_[71] = 0.35 * v_[0];
    v_[72] = v_[68] * v_[8] + v_[70] * v_[4] + v_[71] * v_[2];
    v_[73] = 0.33 * v_[24];
    v_[74] = v_[73] * v_[6];
    v_[75] = -0.33 * v_[24];
    v_[76] = v_[75] * v_[2];
    v_[77] = 0.35 * v_[24];
    v_[78] = v_[74] * v_[8] + v_[76] * v_[4] + v_[77] * v_[6] + 0.08 * v_[24];
    v_[79] = 0.33 * v_[24];
    v_[80] = v_[79] * v_[2];
    v_[81] = 0.33 * v_[24];
    v_[82] = v_[81] * v_[6];
    v_[83] = 0.35 * v_[24];
    v_[84] = 0.207 + v_[80] * v_[4] - v_[82] * v_[8] - v_[83] * v_[6] - 0.08 * v_[24];
    v_[85] = -0.33 * v_[6];
    v_[86] = 0.33 * v_[2];
    v_[87] = 0.3735 + v_[85] * v_[4] - v_[86] * v_[8] - 0.35 * v_[2];
    v_[88] = v_[17] * x_in[26] + v_[72] * x_in[25] + v_[78] * x_in[24] + x_in[23] + x_in[18] * v_[84] - x_in[19] * v_[87];
    v_[89] = 0.5 * x_in[0];
    v_[90] = cos(v_[89]);
    v_[91] = 0.5 * x_in[1];
    v_[92] = cos(v_[91]);
    v_[93] = v_[90] * v_[92];
    v_[94] = 0.5 * x_in[2];
    v_[95] = sin(v_[94]);
    v_[96] = sin(v_[89]);
    v_[97] = sin(v_[91]);
    v_[98] = v_[96] * v_[97];
    v_[99] = cos(v_[94]);
    v_[100] = v_[93] * v_[95] + v_[98] * v_[99];
    v_[101] = 2. * v_[100];
    v_[102] = 0.33 * v_[24];
    v_[103] = v_[102] * v_[6];
    v_[104] = 0.33 * v_[24];
    v_[105] = v_[104] * v_[2];
    v_[106] = v_[103] * v_[4] + v_[105] * v_[8];
    v_[107] = v_[102] * v_[2];
    v_[108] = 0.33 * v_[24];
    v_[109] = v_[108] * v_[6];
    v_[24] = 0.35 * v_[24];
    v_[110] = v_[107] * v_[8] + v_[109] * v_[4] + v_[24] * v_[2];
    v_[111] = 0.33 * v_[0];
    v_[112] = v_[111] * v_[2];
    v_[113] = 0.33 * v_[0];
    v_[114] = v_[113] * v_[6];
    v_[115] = 0.35 * v_[0];
    v_[116] = v_[112] * v_[4] - v_[114] * v_[8] - v_[115] * v_[6] - 0.08 * v_[0];
    v_[117] = 0.33 * v_[0];
    v_[118] = v_[117] * v_[2];
    v_[119] = 0.35 * v_[0];
    v_[0] = v_[118] * v_[4] - v_[114] * v_[8] - v_[119] * v_[6] - 0.08 * v_[0];
    v_[120] = v_[106] * x_in[26] + v_[110] * x_in[25] + v_[116] * x_in[24] + x_in[22] + x_in[20] * v_[87] - x_in[18] * v_[0];
    v_[121] = v_[90] * v_[97];
    v_[122] = v_[96] * v_[92];
    v_[123] = v_[121] * v_[99] - v_[122] * v_[95];
    v_[124] = 2. * v_[123];
    v_[125] = v_[88] * v_[101] + v_[120] * v_[124];
    v_[126] = 0.33 * v_[2];
    v_[127] = 0.33 * v_[6];
    v_[128] = v_[126] * v_[4] - v_[127] * v_[8];
    v_[129] = 0.33 * v_[2];
    v_[130] = 0.33 * v_[6];
    v_[131] = v_[129] * v_[4] - v_[130] * v_[8] - 0.35 * v_[6];
    v_[132] = v_[128] * x_in[26] + v_[131] * x_in[25] + x_in[21] + x_in[19] * v_[0] - x_in[20] * v_[84];
    v_[133] = 0 - v_[132];
    v_[134] = v_[122] * v_[99] + v_[121] * v_[95];
    v_[135] = v_[93] * v_[99] - v_[98] * v_[95];
    v_[133] = v_[133] * v_[124] + (v_[133] * v_[123] + v_[120] * v_[134] + v_[88] * v_[135]) * 2.;
    v_[136] = 0 - v_[133];
    v_[137] = v_[125] * v_[99] + v_[136] * v_[95];
    v_[138] = 0 - v_[120];
    v_[139] = v_[138] * v_[101] + v_[88] * v_[124];
    v_[140] = 0 - v_[139];
    v_[141] = 0 - v_[132];
    v_[141] = v_[141] * v_[101] + (v_[141] * v_[100] + v_[88] * v_[134] + v_[138] * v_[135]) * 2.;
    v_[138] = v_[140] * v_[95] + v_[141] * v_[99];
    v_[142] = cos(v_[89]);
    v_[143] = v_[139] * v_[99] + v_[141] * v_[95];
    v_[144] = v_[125] * v_[95] + v_[133] * v_[99];
    v_[89] = sin(v_[89]);
    jac[3] = ((v_[137] * v_[92] + v_[138] * v_[97]) * v_[142] - (v_[143] * v_[92] + v_[144] * v_[97]) * v_[89]) * 0.5;
    v_[145] = 0 - v_[120];
    v_[146] = 2. * v_[134];
    v_[147] = 0 - v_[88];
    v_[145] = v_[132] * v_[124] + v_[145] * v_[146] + (v_[145] * v_[134] + v_[147] * v_[135]) * 2.;
    v_[148] = v_[88] * v_[101] + v_[132] * v_[134] * 2.;
    v_[149] = 0 - v_[148];
    v_[150] = v_[145] * v_[99] + v_[149] * v_[95];
    v_[147] = v_[132] * v_[101] + v_[147] * v_[146];
    v_[151] = 0 - v_[147];
    v_[152] = 0 - v_[120];
    v_[152] = v_[152] * v_[101] + (v_[152] * v_[100] + v_[88] * v_[123] + v_[132] * v_[135]) * 2.;
    v_[153] = v_[151] * v_[95] + v_[152] * v_[99];
    v_[154] = v_[147] * v_[99] + v_[152] * v_[95];
    v_[155] = v_[145] * v_[95] + v_[148] * v_[99];
    jac[4] = ((v_[150] * v_[92] + v_[153] * v_[97]) * v_[142] - (v_[154] * v_[92] + v_[155] * v_[97]) * v_[89]) * 0.5;
    v_[156] = 0 - v_[88];
    v_[156] = v_[132] * v_[101] + v_[156] * v_[146] + (v_[156] * v_[134] + v_[120] * v_[135]) * 2.;
    v_[88] = 0 - v_[88];
    v_[157] = 0 - v_[132];
    v_[88] = v_[120] * v_[101] + v_[88] * v_[124] + (v_[88] * v_[123] + v_[157] * v_[135]) * 2.;
    v_[158] = 0 - v_[88];
    v_[159] = v_[156] * v_[99] + v_[158] * v_[95];
    v_[157] = v_[157] * v_[124] + v_[120] * v_[146];
    v_[160] = 0 - v_[157];
    v_[132] = (v_[120] * v_[123] + v_[132] * v_[134]) * 2.;
    v_[120] = v_[160] * v_[95] + v_[132] * v_[99];
    v_[161] = v_[157] * v_[99] + v_[132] * v_[95];
    v_[99] = v_[156] * v_[95] + v_[88] * v_[99];
    jac[5] = ((v_[159] * v_[92] + v_[120] * v_[97]) * v_[142] - (v_[161] * v_[92] + v_[99] * v_[97]) * v_[89]) * 0.5;
    v_[89] = cos(x_in[9]);
    v_[142] = 0.33 * v_[89];
    v_[97] = sin(x_in[10]);
    v_[92] = v_[142] * v_[97];
    v_[95] = sin(x_in[11]);
    v_[162] = 0.33 * v_[89];
    v_[163] = cos(x_in[10]);
    v_[164] = v_[162] * v_[163];
    v_[165] = cos(x_in[11]);
    v_[166] = 0.35 * v_[89];
    v_[167] = v_[92] * v_[95] - v_[164] * v_[165] - v_[166] * v_[163] - 0.08 * v_[89];
    v_[168] = 0.5 * x_in[0];
    v_[169] = cos(v_[168]);
    v_[170] = 0.5 * x_in[1];
    v_[171] = cos(v_[170]);
    v_[172] = v_[169] * v_[171];
    v_[173] = 0.5 * x_in[2];
    v_[174] = sin(v_[173]);
    v_[175] = sin(v_[168]);
    v_[176] = sin(v_[170]);
    v_[177] = v_[175] * v_[176];
    v_[178] = cos(v_[173]);
    v_[179] = v_[172] * v_[174] + v_[177] * v_[178];
    v_[180] = 2. * v_[179];
    v_[181] = sin(x_in[9]);
    v_[182] = 0.33 * v_[181];
    v_[183] = v_[182] * v_[163];
    v_[184] = -0.33 * v_[181];
    v_[185] = v_[184] * v_[97];
    v_[186] = 0.35 * v_[181];
    v_[187] = -0.207 + v_[183] * v_[165] + v_[185] * v_[95] + v_[186] * v_[163] + 0.08 * v_[181];
    v_[188] = v_[169] * v_[176];
    v_[189] = v_[175] * v_[171];
    v_[190] = v_[188] * v_[178] - v_[189] * v_[174];
    v_[191] = 2. * v_[190];
    v_[192] = v_[167] * v_[180] + v_[187] * v_[191];
    v_[193] = -0.33 * v_[163];
    v_[194] = 0.33 * v_[97];
    v_[195] = 0.3735 + v_[193] * v_[95] - v_[194] * v_[165] - 0.35 * v_[97];
    v_[196] = 0 - v_[195];
    v_[197] = v_[189] * v_[178] + v_[188] * v_[174];
    v_[198] = v_[172] * v_[178] - v_[177] * v_[174];
    v_[196] = v_[196] * v_[191] + (v_[196] * v_[190] + v_[187] * v_[197] + v_[167] * v_[198]) * 2.;
    v_[199] = 0 - v_[196];
    v_[200] = v_[192] * v_[178] + v_[199] * v_[174];
    v_[201] = 0 - v_[187];
    v_[202] = v_[201] * v_[180] + v_[167] * v_[191];
    v_[203] = 0 - v_[202];
    v_[204] = 0 - v_[195];
    v_[204] = v_[204] * v_[180] + (v_[204] * v_[179] + v_[167] * v_[197] + v_[201] * v_[198]) * 2.;
    v_[201] = v_[203] * v_[174] + v_[204] * v_[178];
    v_[205] = cos(v_[168]);
    v_[206] = v_[202] * v_[178] + v_[204] * v_[174];
    v_[207] = v_[192] * v_[174] + v_[196] * v_[178];
    v_[168] = sin(v_[168]);
    jac[6] = ((v_[200] * v_[171] + v_[201] * v_[176]) * v_[205] - (v_[206] * v_[171] + v_[207] * v_[176]) * v_[168]) * 0.5;
    v_[208] = 0 - v_[187];
    v_[209] = 2. * v_[197];
    v_[210] = 0 - v_[167];
    v_[208] = v_[195] * v_[191] + v_[208] * v_[209] + (v_[208] * v_[197] + v_[210] * v_[198]) * 2.;
    v_[211] = v_[167] * v_[180] + v_[195] * v_[197] * 2.;
    v_[212] = 0 - v_[211];
    v_[213] = v_[208] * v_[178] + v_[212] * v_[174];
    v_[210] = v_[195] * v_[180] + v_[210] * v_[209];
    v_[214] = 0 - v_[210];
    v_[215] = 0 - v_[187];
    v_[215] = v_[215] * v_[180] + (v_[215] * v_[179] + v_[167] * v_[190] + v_[195] * v_[198]) * 2.;
    v_[216] = v_[214] * v_[174] + v_[215] * v_[178];
    v_[217] = v_[210] * v_[178] + v_[215] * v_[174];
    v_[218] = v_[208] * v_[174] + v_[211] * v_[178];
    jac[7] = ((v_[213] * v_[171] + v_[216] * v_[176]) * v_[205] - (v_[217] * v_[171] + v_[218] * v_[176]) * v_[168]) * 0.5;
    v_[219] = 0 - v_[167];
    v_[219] = v_[195] * v_[180] + v_[219] * v_[209] + (v_[219] * v_[197] + v_[187] * v_[198]) * 2.;
    v_[167] = 0 - v_[167];
    v_[220] = 0 - v_[195];
    v_[167] = v_[187] * v_[180] + v_[167] * v_[191] + (v_[167] * v_[190] + v_[220] * v_[198]) * 2.;
    v_[221] = 0 - v_[167];
    v_[222] = v_[219] * v_[178] + v_[221] * v_[174];
    v_[220] = v_[220] * v_[191] + v_[187] * v_[209];
    v_[223] = 0 - v_[220];
    v_[195] = (v_[187] * v_[190] + v_[195] * v_[197]) * 2.;
    v_[187] = v_[223] * v_[174] + v_[195] * v_[178];
    v_[224] = v_[220] * v_[178] + v_[195] * v_[174];
    v_[178] = v_[219] * v_[174] + v_[167] * v_[178];
    jac[8] = ((v_[222] * v_[171] + v_[187] * v_[176]) * v_[205] - (v_[224] * v_[171] + v_[178] * v_[176]) * v_[168]) * 0.5;
    v_[168] = 0.33 * v_[89];
    v_[205] = v_[168] * v_[163];
    v_[176] = 0.33 * v_[89];
    v_[171] = v_[176] * v_[97];
    v_[174] = v_[205] * v_[95] + v_[171] * v_[165];
    v_[225] = v_[168] * v_[97];
    v_[226] = 0.33 * v_[89];
    v_[227] = v_[226] * v_[163];
    v_[228] = 0.35 * v_[89];
    v_[229] = v_[225] * v_[165] + v_[227] * v_[95] + v_[228] * v_[97];
    v_[230] = 0.33 * v_[181];
    v_[231] = v_[230] * v_[163];
    v_[232] = -0.33 * v_[181];
    v_[233] = v_[232] * v_[97];
    v_[234] = 0.35 * v_[181];
    v_[235] = v_[231] * v_[165] + v_[233] * v_[95] + v_[234] * v_[163] + 0.08 * v_[181];
    v_[236] = 0.33 * v_[181];
    v_[237] = v_[236] * v_[163];
    v_[238] = -0.33 * v_[181];
    v_[239] = v_[238] * v_[97];
    v_[240] = 0.35 * v_[181];
    v_[241] = -0.207 + v_[237] * v_[165] + v_[239] * v_[95] + v_[240] * v_[163] + 0.08 * v_[181];
    v_[242] = -0.33 * v_[163];
    v_[243] = 0.33 * v_[97];
    v_[244] = 0.3735 + v_[242] * v_[95] - v_[243] * v_[165] - 0.35 * v_[97];
    v_[245] = v_[174] * x_in[29] + v_[229] * x_in[28] + v_[235] * x_in[27] + x_in[23] + x_in[18] * v_[241] - x_in[19] * v_[244];
    v_[246] = 0.5 * x_in[0];
    v_[247] = cos(v_[246]);
    v_[248] = 0.5 * x_in[1];
    v_[249] = cos(v_[248]);
    v_[250] = v_[247] * v_[249];
    v_[251] = 0.5 * x_in[2];
    v_[252] = sin(v_[251]);
    v_[253] = sin(v_[246]);
    v_[254] = sin(v_[248]);
    v_[255] = v_[253] * v_[254];
    v_[256] = cos(v_[251]);
    v_[257] = v_[250] * v_[252] + v_[255] * v_[256];
    v_[258] = 2. * v_[257];
    v_[259] = -0.33 * v_[181];
    v_[260] = v_[259] * v_[163];
    v_[261] = 0.33 * v_[181];
    v_[262] = v_[261] * v_[97];
    v_[263] = v_[260] * v_[95] - v_[262] * v_[165];
    v_[264] = v_[232] * v_[163];
    v_[265] = 0.33 * v_[181];
    v_[266] = v_[265] * v_[97];
    v_[181] = 0.35 * v_[181];
    v_[267] = v_[264] * v_[95] - v_[266] * v_[165] - v_[181] * v_[97];
    v_[268] = 0.33 * v_[89];
    v_[269] = v_[268] * v_[163];
    v_[270] = -0.33 * v_[89];
    v_[271] = v_[270] * v_[97];
    v_[272] = 0.35 * v_[89];
    v_[273] = v_[269] * v_[165] + v_[271] * v_[95] + v_[272] * v_[163] + 0.08 * v_[89];
    v_[274] = 0.33 * v_[89];
    v_[275] = v_[274] * v_[97];
    v_[276] = 0.33 * v_[89];
    v_[277] = v_[276] * v_[163];
    v_[278] = 0.35 * v_[89];
    v_[89] = v_[275] * v_[95] - v_[277] * v_[165] - v_[278] * v_[163] - 0.08 * v_[89];
    v_[279] = v_[263] * x_in[29] + v_[267] * x_in[28] + v_[273] * x_in[27] + x_in[22] + x_in[20] * v_[244] - x_in[18] * v_[89];
    v_[280] = v_[247] * v_[254];
    v_[281] = v_[253] * v_[249];
    v_[282] = v_[280] * v_[256] - v_[281] * v_[252];
    v_[283] = 2. * v_[282];
    v_[284] = v_[245] * v_[258] + v_[279] * v_[283];
    v_[285] = 0.33 * v_[97];
    v_[286] = 0.33 * v_[163];
    v_[287] = v_[285] * v_[95] - v_[286] * v_[165];
    v_[288] = 0.33 * v_[97];
    v_[289] = 0.33 * v_[163];
    v_[290] = v_[288] * v_[95] - v_[289] * v_[165] - 0.35 * v_[163];
    v_[291] = v_[287] * x_in[29] + v_[290] * x_in[28] + x_in[21] + x_in[19] * v_[89] - x_in[20] * v_[241];
    v_[292] = 0 - v_[291];
    v_[293] = v_[281] * v_[256] + v_[280] * v_[252];
    v_[294] = v_[250] * v_[256] - v_[255] * v_[252];
    v_[292] = v_[292] * v_[283] + (v_[292] * v_[282] + v_[279] * v_[293] + v_[245] * v_[294]) * 2.;
    v_[295] = 0 - v_[292];
    v_[296] = v_[284] * v_[256] + v_[295] * v_[252];
    v_[297] = 0 - v_[279];
    v_[298] = v_[297] * v_[258] + v_[245] * v_[283];
    v_[299] = 0 - v_[298];
    v_[300] = 0 - v_[291];
    v_[300] = v_[300] * v_[258] + (v_[300] * v_[257] + v_[245] * v_[293] + v_[297] * v_[294]) * 2.;
    v_[297] = v_[299] * v_[252] + v_[300] * v_[256];
    v_[301] = cos(v_[246]);
    v_[302] = v_[298] * v_[256] + v_[300] * v_[252];
    v_[303] = v_[284] * v_[252] + v_[292] * v_[256];
    v_[246] = sin(v_[246]);
    jac[9] = ((v_[296] * v_[249] + v_[297] * v_[254]) * v_[301] - (v_[302] * v_[249] + v_[303] * v_[254]) * v_[246]) * 0.5;
    v_[304] = 0 - v_[279];
    v_[305] = 2. * v_[293];
    v_[306] = 0 - v_[245];
    v_[304] = v_[291] * v_[283] + v_[304] * v_[305] + (v_[304] * v_[293] + v_[306] * v_[294]) * 2.;
    v_[307] = v_[245] * v_[258] + v_[291] * v_[293] * 2.;
    v_[308] = 0 - v_[307];
    v_[309] = v_[304] * v_[256] + v_[308] * v_[252];
    v_[306] = v_[291] * v_[258] + v_[306] * v_[305];
    v_[310] = 0 - v_[306];
    v_[311] = 0 - v_[279];
    v_[311] = v_[311] * v_[258] + (v_[311] * v_[257] + v_[245] * v_[282] + v_[291] * v_[294]) * 2.;
    v_[312] = v_[310] * v_[252] + v_[311] * v_[256];
    v_[313] = v_[306] * v_[256] + v_[311] * v_[252];
    v_[314] = v_[304] * v_[252] + v_[307] * v_[256];
    jac[10] = ((v_[309] * v_[249] + v_[312] * v_[254]) * v_[301] - (v_[313] * v_[249] + v_[314] * v_[254]) * v_[246]) * 0.5;
    v_[315] = 0 - v_[245];
    v_[315] = v_[291] * v_[258] + v_[315] * v_[305] + (v_[315] * v_[293] + v_[279] * v_[294]) * 2.;
    v_[245] = 0 - v_[245];
    v_[316] = 0 - v_[291];
    v_[245] = v_[279] * v_[258] + v_[245] * v_[283] + (v_[245] * v_[282] + v_[316] * v_[294]) * 2.;
    v_[317] = 0 - v_[245];
    v_[318] = v_[315] * v_[256] + v_[317] * v_[252];
    v_[316] = v_[316] * v_[283] + v_[279] * v_[305];
    v_[319] = 0 - v_[316];
    v_[291] = (v_[279] * v_[282] + v_[291] * v_[293]) * 2.;
    v_[279] = v_[319] * v_[252] + v_[291] * v_[256];
    v_[320] = v_[316] * v_[256] + v_[291] * v_[252];
    v_[256] = v_[315] * v_[252] + v_[245] * v_[256];
    jac[11] = ((v_[318] * v_[249] + v_[279] * v_[254]) * v_[301] - (v_[320] * v_[249] + v_[256] * v_[254]) * v_[246]) * 0.5;
    v_[246] = cos(x_in[12]);
    v_[301] = 0.33 * v_[246];
    v_[254] = sin(x_in[13]);
    v_[249] = v_[301] * v_[254];
    v_[252] = sin(x_in[14]);
    v_[321] = 0.33 * v_[246];
    v_[322] = cos(x_in[13]);
    v_[323] = v_[321] * v_[322];
    v_[324] = cos(x_in[14]);
    v_[325] = 0.35 * v_[246];
    v_[326] = v_[249] * v_[252] - v_[323] * v_[324] - v_[325] * v_[322] - 0.08 * v_[246];
    v_[327] = 0.5 * x_in[0];
    v_[328] = cos(v_[327]);
    v_[329] = 0.5 * x_in[1];
    v_[330] = cos(v_[329]);
    v_[331] = v_[328] * v_[330];
    v_[332] = 0.5 * x_in[2];
    v_[333] = sin(v_[332]);
    v_[334] = sin(v_[327]);
    v_[335] = sin(v_[329]);
    v_[336] = v_[334] * v_[335];
    v_[337] = cos(v_[332]);
    v_[338] = v_[331] * v_[333] + v_[336] * v_[337];
    v_[339] = 2. * v_[338];
    v_[340] = sin(x_in[12]);
    v_[341] = 0.33 * v_[340];
    v_[342] = v_[341] * v_[254];
    v_[343] = 0.33 * v_[340];
    v_[344] = v_[343] * v_[322];
    v_[345] = 0.35 * v_[340];
    v_[346] = 0.207 + v_[342] * v_[252] - v_[344] * v_[324] - v_[345] * v_[322] - 0.08 * v_[340];
    v_[347] = v_[328] * v_[335];
    v_[348] = v_[334] * v_[330];
    v_[349] = v_[347] * v_[337] - v_[348] * v_[333];
    v_[350] = 2. * v_[349];
    v_[351] = v_[326] * v_[339] + v_[346] * v_[350];
    v_[352] = -0.33 * v_[322];
    v_[353] = 0.33 * v_[254];
    v_[354] = -0.3735 + v_[352] * v_[252] - v_[353] * v_[324] - 0.35 * v_[254];
    v_[355] = 0 - v_[354];
    v_[356] = v_[348] * v_[337] + v_[347] * v_[333];
    v_[357] = v_[331] * v_[337] - v_[336] * v_[333];
    v_[355] = v_[355] * v_[350] + (v_[355] * v_[349] + v_[346] * v_[356] + v_[326] * v_[357]) * 2.;
    v_[358] = 0 - v_[355];
    v_[359] = v_[351] * v_[337] + v_[358] * v_[333];
    v_[360] = 0 - v_[346];
    v_[361] = v_[360] * v_[339] + v_[326] * v_[350];
    v_[362] = 0 - v_[361];
    v_[363] = 0 - v_[354];
    v_[363] = v_[363] * v_[339] + (v_[363] * v_[338] + v_[326] * v_[356] + v_[360] * v_[357]) * 2.;
    v_[360] = v_[362] * v_[333] + v_[363] * v_[337];
    v_[364] = cos(v_[327]);
    v_[365] = v_[361] * v_[337] + v_[363] * v_[333];
    v_[366] = v_[351] * v_[333] + v_[355] * v_[337];
    v_[327] = sin(v_[327]);
    jac[12] = ((v_[359] * v_[330] + v_[360] * v_[335]) * v_[364] - (v_[365] * v_[330] + v_[366] * v_[335]) * v_[327]) * 0.5;
    v_[367] = 0 - v_[346];
    v_[368] = 2. * v_[356];
    v_[369] = 0 - v_[326];
    v_[367] = v_[354] * v_[350] + v_[367] * v_[368] + (v_[367] * v_[356] + v_[369] * v_[357]) * 2.;
    v_[370] = v_[326] * v_[339] + v_[354] * v_[356] * 2.;
    v_[371] = 0 - v_[370];
    v_[372] = v_[367] * v_[337] + v_[371] * v_[333];
    v_[369] = v_[354] * v_[339] + v_[369] * v_[368];
    v_[373] = 0 - v_[369];
    v_[374] = 0 - v_[346];
    v_[374] = v_[374] * v_[339] + (v_[374] * v_[338] + v_[326] * v_[349] + v_[354] * v_[357]) * 2.;
    v_[375] = v_[373] * v_[333] + v_[374] * v_[337];
    v_[376] = v_[369] * v_[337] + v_[374] * v_[333];
    v_[377] = v_[367] * v_[333] + v_[370] * v_[337];
    jac[13] = ((v_[372] * v_[330] + v_[375] * v_[335]) * v_[364] - (v_[376] * v_[330] + v_[377] * v_[335]) * v_[327]) * 0.5;
    v_[378] = 0 - v_[326];
    v_[378] = v_[354] * v_[339] + v_[378] * v_[368] + (v_[378] * v_[356] + v_[346] * v_[357]) * 2.;
    v_[326] = 0 - v_[326];
    v_[379] = 0 - v_[354];
    v_[326] = v_[346] * v_[339] + v_[326] * v_[350] + (v_[326] * v_[349] + v_[379] * v_[357]) * 2.;
    v_[380] = 0 - v_[326];
    v_[381] = v_[378] * v_[337] + v_[380] * v_[333];
    v_[379] = v_[379] * v_[350] + v_[346] * v_[368];
    v_[382] = 0 - v_[379];
    v_[354] = (v_[346] * v_[349] + v_[354] * v_[356]) * 2.;
    v_[346] = v_[382] * v_[333] + v_[354] * v_[337];
    v_[383] = v_[379] * v_[337] + v_[354] * v_[333];
    v_[337] = v_[378] * v_[333] + v_[326] * v_[337];
    jac[14] = ((v_[381] * v_[330] + v_[346] * v_[335]) * v_[364] - (v_[383] * v_[330] + v_[337] * v_[335]) * v_[327]) * 0.5;
    v_[327] = 0.33 * v_[246];
    v_[364] = v_[327] * v_[322];
    v_[335] = 0.33 * v_[246];
    v_[330] = v_[335] * v_[254];
    v_[333] = v_[364] * v_[252] + v_[330] * v_[324];
    v_[384] = v_[327] * v_[254];
    v_[385] = 0.33 * v_[246];
    v_[386] = v_[385] * v_[322];
    v_[387] = 0.35 * v_[246];
    v_[388] = v_[384] * v_[324] + v_[386] * v_[252] + v_[387] * v_[254];
    v_[389] = 0.33 * v_[340];
    v_[390] = v_[389] * v_[322];
    v_[391] = -0.33 * v_[340];
    v_[392] = v_[391] * v_[254];
    v_[393] = 0.35 * v_[340];
    v_[394] = v_[390] * v_[324] + v_[392] * v_[252] + v_[393] * v_[322] + 0.08 * v_[340];
    v_[395] = 0.33 * v_[340];
    v_[396] = v_[395] * v_[254];
    v_[397] = sin(x_in[14]);
    v_[398] = 0.33 * v_[340];
    v_[399] = v_[398] * v_[322];
    v_[400] = 0.35 * v_[340];
    v_[401] = 0.207 + v_[396] * v_[397] - v_[399] * v_[324] - v_[400] * v_[322] - 0.08 * v_[340];
    v_[402] = -0.33 * v_[322];
    v_[403] = 0.33 * v_[254];
    v_[404] = -0.3735 + v_[402] * v_[397] - v_[403] * v_[324] - 0.35 * v_[254];
    v_[405] = v_[333] * x_in[32] + v_[388] * x_in[31] + v_[394] * x_in[30] + x_in[23] + x_in[18] * v_[401] - x_in[19] * v_[404];
    v_[406] = 0.5 * x_in[0];
    v_[407] = cos(v_[406]);
    v_[408] = 0.5 * x_in[1];
    v_[409] = cos(v_[408]);
    v_[410] = v_[407] * v_[409];
    v_[411] = 0.5 * x_in[2];
    v_[412] = sin(v_[411]);
    v_[413] = sin(v_[406]);
    v_[414] = sin(v_[408]);
    v_[415] = v_[413] * v_[414];
    v_[416] = cos(v_[411]);
    v_[417] = v_[410] * v_[412] + v_[415] * v_[416];
    v_[418] = 2. * v_[417];
    v_[419] = 0.33 * v_[340];
    v_[420] = v_[419] * v_[322];
    v_[421] = 0.33 * v_[340];
    v_[422] = v_[421] * v_[254];
    v_[423] = v_[420] * v_[252] + v_[422] * v_[324];
    v_[424] = v_[419] * v_[254];
    v_[425] = 0.33 * v_[340];
    v_[426] = v_[425] * v_[322];
    v_[340] = 0.35 * v_[340];
    v_[427] = v_[424] * v_[324] + v_[426] * v_[252] + v_[340] * v_[254];
    v_[428] = 0.33 * v_[246];
    v_[429] = v_[428] * v_[254];
    v_[430] = 0.33 * v_[246];
    v_[431] = v_[430] * v_[322];
    v_[432] = 0.35 * v_[246];
    v_[433] = v_[429] * v_[252] - v_[431] * v_[324] - v_[432] * v_[322] - 0.08 * v_[246];
    v_[434] = 0.33 * v_[246];
    v_[435] = v_[434] * v_[254];
    v_[436] = 0.33 * v_[246];
    v_[437] = v_[436] * v_[322];
    v_[438] = 0.35 * v_[246];
    v_[246] = v_[435] * v_[397] - v_[437] * v_[324] - v_[438] * v_[322] - 0.08 * v_[246];
    v_[439] = v_[423] * x_in[32] + v_[427] * x_in[31] + v_[433] * x_in[30] + x_in[22] + x_in[20] * v_[404] - x_in[18] * v_[246];
    v_[440] = v_[407] * v_[414];
    v_[441] = v_[413] * v_[409];
    v_[442] = v_[440] * v_[416] - v_[441] * v_[412];
    v_[443] = 2. * v_[442];
    v_[444] = v_[405] * v_[418] + v_[439] * v_[443];
    v_[445] = 0.33 * v_[254];
    v_[446] = 0.33 * v_[322];
    v_[447] = v_[445] * v_[252] - v_[446] * v_[324];
    v_[448] = 0.33 * v_[254];
    v_[449] = 0.33 * v_[322];
    v_[450] = v_[448] * v_[252] - v_[449] * v_[324] - 0.35 * v_[322];
    v_[451] = v_[447] * x_in[32] + v_[450] * x_in[31] + x_in[21] + x_in[19] * v_[246] - x_in[20] * v_[401];
    v_[452] = 0 - v_[451];
    v_[453] = v_[441] * v_[416] + v_[440] * v_[412];
    v_[454] = v_[410] * v_[416] - v_[415] * v_[412];
    v_[452] = v_[452] * v_[443] + (v_[452] * v_[442] + v_[439] * v_[453] + v_[405] * v_[454]) * 2.;
    v_[455] = 0 - v_[452];
    v_[456] = v_[444] * v_[416] + v_[455] * v_[412];
    v_[457] = 0 - v_[439];
    v_[458] = v_[457] * v_[418] + v_[405] * v_[443];
    v_[459] = 0 - v_[458];
    v_[460] = 0 - v_[451];
    v_[460] = v_[460] * v_[418] + (v_[460] * v_[417] + v_[405] * v_[453] + v_[457] * v_[454]) * 2.;
    v_[457] = v_[459] * v_[412] + v_[460] * v_[416];
    v_[461] = cos(v_[406]);
    v_[462] = v_[458] * v_[416] + v_[460] * v_[412];
    v_[463] = v_[444] * v_[412] + v_[452] * v_[416];
    v_[406] = sin(v_[406]);
    jac[15] = ((v_[456] * v_[409] + v_[457] * v_[414]) * v_[461] - (v_[462] * v_[409] + v_[463] * v_[414]) * v_[406]) * 0.5;
    v_[464] = 0 - v_[439];
    v_[465] = 2. * v_[453];
    v_[466] = 0 - v_[405];
    v_[464] = v_[451] * v_[443] + v_[464] * v_[465] + (v_[464] * v_[453] + v_[466] * v_[454]) * 2.;
    v_[467] = v_[405] * v_[418] + v_[451] * v_[453] * 2.;
    v_[468] = 0 - v_[467];
    v_[469] = v_[464] * v_[416] + v_[468] * v_[412];
    v_[466] = v_[451] * v_[418] + v_[466] * v_[465];
    v_[470] = 0 - v_[466];
    v_[471] = 0 - v_[439];
    v_[471] = v_[471] * v_[418] + (v_[471] * v_[417] + v_[405] * v_[442] + v_[451] * v_[454]) * 2.;
    v_[472] = v_[470] * v_[412] + v_[471] * v_[416];
    v_[473] = v_[466] * v_[416] + v_[471] * v_[412];
    v_[474] = v_[464] * v_[412] + v_[467] * v_[416];
    jac[16] = ((v_[469] * v_[409] + v_[472] * v_[414]) * v_[461] - (v_[473] * v_[409] + v_[474] * v_[414]) * v_[406]) * 0.5;
    v_[475] = 0 - v_[405];
    v_[475] = v_[451] * v_[418] + v_[475] * v_[465] + (v_[475] * v_[453] + v_[439] * v_[454]) * 2.;
    v_[405] = 0 - v_[405];
    v_[476] = 0 - v_[451];
    v_[405] = v_[439] * v_[418] + v_[405] * v_[443] + (v_[405] * v_[442] + v_[476] * v_[454]) * 2.;
    v_[477] = 0 - v_[405];
    v_[478] = v_[475] * v_[416] + v_[477] * v_[412];
    v_[476] = v_[476] * v_[443] + v_[439] * v_[465];
    v_[479] = 0 - v_[476];
    v_[451] = (v_[439] * v_[442] + v_[451] * v_[453]) * 2.;
    v_[439] = v_[479] * v_[412] + v_[451] * v_[416];
    v_[480] = v_[476] * v_[416] + v_[451] * v_[412];
    v_[416] = v_[475] * v_[412] + v_[405] * v_[416];
    jac[17] = ((v_[478] * v_[409] + v_[439] * v_[414]) * v_[461] - (v_[480] * v_[409] + v_[416] * v_[414]) * v_[406]) * 0.5;
    v_[406] = cos(x_in[15]);
    v_[461] = 0.33 * v_[406];
    v_[414] = sin(x_in[16]);
    v_[409] = v_[461] * v_[414];
    v_[412] = sin(x_in[17]);
    v_[481] = 0.33 * v_[406];
    v_[482] = cos(x_in[16]);
    v_[483] = v_[481] * v_[482];
    v_[484] = cos(x_in[17]);
    v_[485] = 0.35 * v_[406];
    v_[486] = v_[409] * v_[412] - v_[483] * v_[484] - v_[485] * v_[482] - 0.08 * v_[406];
    v_[487] = 0.5 * x_in[0];
    v_[488] = cos(v_[487]);
    v_[489] = 0.5 * x_in[1];
    v_[490] = cos(v_[489]);
    v_[491] = v_[488] * v_[490];
    v_[492] = 0.5 * x_in[2];
    v_[493] = sin(v_[492]);
    v_[494] = sin(v_[487]);
    v_[495] = sin(v_[489]);
    v_[496] = v_[494] * v_[495];
    v_[497] = cos(v_[492]);
    v_[498] = v_[491] * v_[493] + v_[496] * v_[497];
    v_[499] = 2. * v_[498];
    v_[500] = sin(x_in[15]);
    v_[501] = 0.33 * v_[500];
    v_[502] = v_[501] * v_[482];
    v_[503] = -0.33 * v_[500];
    v_[504] = v_[503] * v_[414];
    v_[505] = 0.35 * v_[500];
    v_[506] = -0.207 + v_[502] * v_[484] + v_[504] * v_[412] + v_[505] * v_[482] + 0.08 * v_[500];
    v_[507] = v_[488] * v_[495];
    v_[508] = v_[494] * v_[490];
    v_[509] = v_[507] * v_[497] - v_[508] * v_[493];
    v_[510] = 2. * v_[509];
    v_[511] = v_[486] * v_[499] + v_[506] * v_[510];
    v_[512] = -0.33 * v_[482];
    v_[513] = 0.33 * v_[414];
    v_[514] = -0.3735 + v_[512] * v_[412] - v_[513] * v_[484] - 0.35 * v_[414];
    v_[515] = 0 - v_[514];
    v_[516] = v_[508] * v_[497] + v_[507] * v_[493];
    v_[517] = v_[491] * v_[497] - v_[496] * v_[493];
    v_[515] = v_[515] * v_[510] + (v_[515] * v_[509] + v_[506] * v_[516] + v_[486] * v_[517]) * 2.;
    v_[518] = 0 - v_[515];
    v_[519] = v_[511] * v_[497] + v_[518] * v_[493];
    v_[520] = 0 - v_[506];
    v_[521] = v_[520] * v_[499] + v_[486] * v_[510];
    v_[522] = 0 - v_[521];
    v_[523] = 0 - v_[514];
    v_[523] = v_[523] * v_[499] + (v_[523] * v_[498] + v_[486] * v_[516] + v_[520] * v_[517]) * 2.;
    v_[520] = v_[522] * v_[493] + v_[523] * v_[497];
    v_[524] = cos(v_[487]);
    v_[525] = v_[521] * v_[497] + v_[523] * v_[493];
    v_[526] = v_[511] * v_[493] + v_[515] * v_[497];
    v_[487] = sin(v_[487]);
    jac[18] = ((v_[519] * v_[490] + v_[520] * v_[495]) * v_[524] - (v_[525] * v_[490] + v_[526] * v_[495]) * v_[487]) * 0.5;
    v_[527] = 0 - v_[506];
    v_[528] = 2. * v_[516];
    v_[529] = 0 - v_[486];
    v_[527] = v_[514] * v_[510] + v_[527] * v_[528] + (v_[527] * v_[516] + v_[529] * v_[517]) * 2.;
    v_[530] = v_[486] * v_[499] + v_[514] * v_[516] * 2.;
    v_[531] = 0 - v_[530];
    v_[532] = v_[527] * v_[497] + v_[531] * v_[493];
    v_[529] = v_[514] * v_[499] + v_[529] * v_[528];
    v_[533] = 0 - v_[529];
    v_[534] = 0 - v_[506];
    v_[534] = v_[534] * v_[499] + (v_[534] * v_[498] + v_[486] * v_[509] + v_[514] * v_[517]) * 2.;
    v_[535] = v_[533] * v_[493] + v_[534] * v_[497];
    v_[536] = v_[529] * v_[497] + v_[534] * v_[493];
    v_[537] = v_[527] * v_[493] + v_[530] * v_[497];
    jac[19] = ((v_[532] * v_[490] + v_[535] * v_[495]) * v_[524] - (v_[536] * v_[490] + v_[537] * v_[495]) * v_[487]) * 0.5;
    v_[538] = 0 - v_[486];
    v_[538] = v_[514] * v_[499] + v_[538] * v_[528] + (v_[538] * v_[516] + v_[506] * v_[517]) * 2.;
    v_[486] = 0 - v_[486];
    v_[539] = 0 - v_[514];
    v_[486] = v_[506] * v_[499] + v_[486] * v_[510] + (v_[486] * v_[509] + v_[539] * v_[517]) * 2.;
    v_[540] = 0 - v_[486];
    v_[541] = v_[538] * v_[497] + v_[540] * v_[493];
    v_[539] = v_[539] * v_[510] + v_[506] * v_[528];
    v_[542] = 0 - v_[539];
    v_[514] = (v_[506] * v_[509] + v_[514] * v_[516]) * 2.;
    v_[506] = v_[542] * v_[493] + v_[514] * v_[497];
    v_[543] = v_[539] * v_[497] + v_[514] * v_[493];
    v_[497] = v_[538] * v_[493] + v_[486] * v_[497];
    jac[20] = ((v_[541] * v_[490] + v_[506] * v_[495]) * v_[524] - (v_[543] * v_[490] + v_[497] * v_[495]) * v_[487]) * 0.5;
    v_[487] = 0.33 * v_[406];
    v_[524] = v_[487] * v_[482];
    v_[495] = 0.33 * v_[406];
    v_[490] = v_[495] * v_[414];
    v_[493] = v_[524] * v_[412] + v_[490] * v_[484];
    v_[544] = v_[487] * v_[414];
    v_[545] = 0.33 * v_[406];
    v_[546] = v_[545] * v_[482];
    v_[547] = 0.35 * v_[406];
    v_[548] = v_[544] * v_[484] + v_[546] * v_[412] + v_[547] * v_[414];
    v_[549] = 0.33 * v_[500];
    v_[550] = v_[549] * v_[482];
    v_[551] = -0.33 * v_[500];
    v_[552] = v_[551] * v_[414];
    v_[553] = 0.35 * v_[500];
    v_[554] = v_[550] * v_[484] + v_[552] * v_[412] + v_[553] * v_[482] + 0.08 * v_[500];
    v_[555] = 0.33 * v_[500];
    v_[556] = v_[555] * v_[482];
    v_[557] = -0.33 * v_[500];
    v_[558] = v_[557] * v_[414];
    v_[559] = 0.35 * v_[500];
    v_[560] = -0.207 + v_[556] * v_[484] + v_[558] * v_[412] + v_[559] * v_[482] + 0.08 * v_[500];
    v_[561] = -0.33 * v_[482];
    v_[562] = 0.33 * v_[414];
    v_[563] = -0.3735 + v_[561] * v_[412] - v_[562] * v_[484] - 0.35 * v_[414];
    v_[564] = v_[493] * x_in[35] + v_[548] * x_in[34] + v_[554] * x_in[33] + x_in[23] + x_in[18] * v_[560] - x_in[19] * v_[563];
    v_[565] = 0.5 * x_in[0];
    v_[566] = cos(v_[565]);
    v_[567] = 0.5 * x_in[1];
    v_[568] = cos(v_[567]);
    v_[569] = v_[566] * v_[568];
    v_[570] = 0.5 * x_in[2];
    v_[571] = sin(v_[570]);
    v_[572] = sin(v_[565]);
    v_[573] = sin(v_[567]);
    v_[574] = v_[572] * v_[573];
    v_[575] = cos(v_[570]);
    v_[576] = v_[569] * v_[571] + v_[574] * v_[575];
    v_[577] = 2. * v_[576];
    v_[578] = -0.33 * v_[500];
    v_[579] = v_[578] * v_[482];
    v_[580] = 0.33 * v_[500];
    v_[581] = v_[580] * v_[414];
    v_[582] = v_[579] * v_[412] - v_[581] * v_[484];
    v_[583] = v_[551] * v_[482];
    v_[584] = 0.33 * v_[500];
    v_[585] = v_[584] * v_[414];
    v_[500] = 0.35 * v_[500];
    v_[586] = v_[583] * v_[412] - v_[585] * v_[484] - v_[500] * v_[414];
    v_[587] = 0.33 * v_[406];
    v_[588] = v_[587] * v_[482];
    v_[589] = -0.33 * v_[406];
    v_[590] = v_[589] * v_[414];
    v_[591] = 0.35 * v_[406];
    v_[592] = v_[588] * v_[484] + v_[590] * v_[412] + v_[591] * v_[482] + 0.08 * v_[406];
    v_[593] = 0.33 * v_[406];
    v_[594] = v_[593] * v_[414];
    v_[595] = 0.33 * v_[406];
    v_[596] = v_[595] * v_[482];
    v_[597] = 0.35 * v_[406];
    v_[406] = v_[594] * v_[412] - v_[596] * v_[484] - v_[597] * v_[482] - 0.08 * v_[406];
    v_[598] = v_[582] * x_in[35] + v_[586] * x_in[34] + v_[592] * x_in[33] + x_in[22] + x_in[20] * v_[563] - x_in[18] * v_[406];
    v_[599] = v_[566] * v_[573];
    v_[600] = v_[572] * v_[568];
    v_[601] = v_[599] * v_[575] - v_[600] * v_[571];
    v_[602] = 2. * v_[601];
    v_[603] = v_[564] * v_[577] + v_[598] * v_[602];
    v_[604] = 0.33 * v_[414];
    v_[605] = 0.33 * v_[482];
    v_[606] = v_[604] * v_[412] - v_[605] * v_[484];
    v_[607] = 0.33 * v_[414];
    v_[608] = 0.33 * v_[482];
    v_[609] = v_[607] * v_[412] - v_[608] * v_[484] - 0.35 * v_[482];
    v_[610] = v_[606] * x_in[35] + v_[609] * x_in[34] + x_in[21] + x_in[19] * v_[406] - x_in[20] * v_[560];
    v_[611] = 0 - v_[610];
    v_[612] = v_[600] * v_[575] + v_[599] * v_[571];
    v_[613] = v_[569] * v_[575] - v_[574] * v_[571];
    v_[611] = v_[611] * v_[602] + (v_[611] * v_[601] + v_[598] * v_[612] + v_[564] * v_[613]) * 2.;
    v_[614] = 0 - v_[611];
    v_[615] = v_[603] * v_[575] + v_[614] * v_[571];
    v_[616] = 0 - v_[598];
    v_[617] = v_[616] * v_[577] + v_[564] * v_[602];
    v_[618] = 0 - v_[617];
    v_[619] = 0 - v_[610];
    v_[619] = v_[619] * v_[577] + (v_[619] * v_[576] + v_[564] * v_[612] + v_[616] * v_[613]) * 2.;
    v_[616] = v_[618] * v_[571] + v_[619] * v_[575];
    v_[620] = cos(v_[565]);
    v_[621] = v_[617] * v_[575] + v_[619] * v_[571];
    v_[622] = v_[603] * v_[571] + v_[611] * v_[575];
    v_[565] = sin(v_[565]);
    jac[21] = ((v_[615] * v_[568] + v_[616] * v_[573]) * v_[620] - (v_[621] * v_[568] + v_[622] * v_[573]) * v_[565]) * 0.5;
    v_[623] = 0 - v_[598];
    v_[624] = 2. * v_[612];
    v_[625] = 0 - v_[564];
    v_[623] = v_[610] * v_[602] + v_[623] * v_[624] + (v_[623] * v_[612] + v_[625] * v_[613]) * 2.;
    v_[626] = v_[564] * v_[577] + v_[610] * v_[612] * 2.;
    v_[627] = 0 - v_[626];
    v_[628] = v_[623] * v_[575] + v_[627] * v_[571];
    v_[625] = v_[610] * v_[577] + v_[625] * v_[624];
    v_[629] = 0 - v_[625];
    v_[630] = 0 - v_[598];
    v_[630] = v_[630] * v_[577] + (v_[630] * v_[576] + v_[564] * v_[601] + v_[610] * v_[613]) * 2.;
    v_[631] = v_[629] * v_[571] + v_[630] * v_[575];
    v_[632] = v_[625] * v_[575] + v_[630] * v_[571];
    v_[633] = v_[623] * v_[571] + v_[626] * v_[575];
    jac[22] = ((v_[628] * v_[568] + v_[631] * v_[573]) * v_[620] - (v_[632] * v_[568] + v_[633] * v_[573]) * v_[565]) * 0.5;
    v_[634] = 0 - v_[564];
    v_[634] = v_[610] * v_[577] + v_[634] * v_[624] + (v_[634] * v_[612] + v_[598] * v_[613]) * 2.;
    v_[564] = 0 - v_[564];
    v_[635] = 0 - v_[610];
    v_[564] = v_[598] * v_[577] + v_[564] * v_[602] + (v_[564] * v_[601] + v_[635] * v_[613]) * 2.;
    v_[636] = 0 - v_[564];
    v_[637] = v_[634] * v_[575] + v_[636] * v_[571];
    v_[635] = v_[635] * v_[602] + v_[598] * v_[624];
    v_[638] = 0 - v_[635];
    v_[610] = (v_[598] * v_[601] + v_[610] * v_[612]) * 2.;
    v_[598] = v_[638] * v_[571] + v_[610] * v_[575];
    v_[639] = v_[635] * v_[575] + v_[610] * v_[571];
    v_[575] = v_[634] * v_[571] + v_[564] * v_[575];
    jac[23] = ((v_[637] * v_[568] + v_[598] * v_[573]) * v_[620] - (v_[639] * v_[568] + v_[575] * v_[573]) * v_[565]) * 0.5;
    v_[565] = cos(v_[13]);
    v_[13] = sin(v_[13]);
    jac[24] = ((v_[50] * v_[12] + v_[44] * v_[18]) * v_[565] - (v_[49] * v_[12] + v_[43] * v_[18]) * v_[13]) * 0.5;
    jac[25] = ((v_[61] * v_[12] + v_[59] * v_[18]) * v_[565] - (v_[60] * v_[12] + v_[56] * v_[18]) * v_[13]) * 0.5;
    jac[26] = ((v_[21] * v_[12] + v_[30] * v_[18]) * v_[565] - (v_[67] * v_[12] + v_[65] * v_[18]) * v_[13]) * 0.5;
    v_[13] = cos(v_[91]);
    v_[91] = sin(v_[91]);
    jac[27] = ((v_[144] * v_[90] + v_[138] * v_[96]) * v_[13] - (v_[143] * v_[90] + v_[137] * v_[96]) * v_[91]) * 0.5;
    jac[28] = ((v_[155] * v_[90] + v_[153] * v_[96]) * v_[13] - (v_[154] * v_[90] + v_[150] * v_[96]) * v_[91]) * 0.5;
    jac[29] = ((v_[99] * v_[90] + v_[120] * v_[96]) * v_[13] - (v_[161] * v_[90] + v_[159] * v_[96]) * v_[91]) * 0.5;
    v_[91] = cos(v_[170]);
    v_[170] = sin(v_[170]);
    jac[30] = ((v_[207] * v_[169] + v_[201] * v_[175]) * v_[91] - (v_[206] * v_[169] + v_[200] * v_[175]) * v_[170]) * 0.5;
    jac[31] = ((v_[218] * v_[169] + v_[216] * v_[175]) * v_[91] - (v_[217] * v_[169] + v_[213] * v_[175]) * v_[170]) * 0.5;
    jac[32] = ((v_[178] * v_[169] + v_[187] * v_[175]) * v_[91] - (v_[224] * v_[169] + v_[222] * v_[175]) * v_[170]) * 0.5;
    v_[170] = cos(v_[248]);
    v_[248] = sin(v_[248]);
    jac[33] = ((v_[303] * v_[247] + v_[297] * v_[253]) * v_[170] - (v_[302] * v_[247] + v_[296] * v_[253]) * v_[248]) * 0.5;
    jac[34] = ((v_[314] * v_[247] + v_[312] * v_[253]) * v_[170] - (v_[313] * v_[247] + v_[309] * v_[253]) * v_[248]) * 0.5;
    jac[35] = ((v_[256] * v_[247] + v_[279] * v_[253]) * v_[170] - (v_[320] * v_[247] + v_[318] * v_[253]) * v_[248]) * 0.5;
    v_[248] = cos(v_[329]);
    v_[329] = sin(v_[329]);
    jac[36] = ((v_[366] * v_[328] + v_[360] * v_[334]) * v_[248] - (v_[365] * v_[328] + v_[359] * v_[334]) * v_[329]) * 0.5;
    jac[37] = ((v_[377] * v_[328] + v_[375] * v_[334]) * v_[248] - (v_[376] * v_[328] + v_[372] * v_[334]) * v_[329]) * 0.5;
    jac[38] = ((v_[337] * v_[328] + v_[346] * v_[334]) * v_[248] - (v_[383] * v_[328] + v_[381] * v_[334]) * v_[329]) * 0.5;
    v_[329] = cos(v_[408]);
    v_[408] = sin(v_[408]);
    jac[39] = ((v_[463] * v_[407] + v_[457] * v_[413]) * v_[329] - (v_[462] * v_[407] + v_[456] * v_[413]) * v_[408]) * 0.5;
    jac[40] = ((v_[474] * v_[407] + v_[472] * v_[413]) * v_[329] - (v_[473] * v_[407] + v_[469] * v_[413]) * v_[408]) * 0.5;
    jac[41] = ((v_[416] * v_[407] + v_[439] * v_[413]) * v_[329] - (v_[480] * v_[407] + v_[478] * v_[413]) * v_[408]) * 0.5;
    v_[408] = cos(v_[489]);
    v_[489] = sin(v_[489]);
    jac[42] = ((v_[526] * v_[488] + v_[520] * v_[494]) * v_[408] - (v_[525] * v_[488] + v_[519] * v_[494]) * v_[489]) * 0.5;
    jac[43] = ((v_[537] * v_[488] + v_[535] * v_[494]) * v_[408] - (v_[536] * v_[488] + v_[532] * v_[494]) * v_[489]) * 0.5;
    jac[44] = ((v_[497] * v_[488] + v_[506] * v_[494]) * v_[408] - (v_[543] * v_[488] + v_[541] * v_[494]) * v_[489]) * 0.5;
    v_[489] = cos(v_[567]);
    v_[567] = sin(v_[567]);
    jac[45] = ((v_[622] * v_[566] + v_[616] * v_[572]) * v_[489] - (v_[621] * v_[566] + v_[615] * v_[572]) * v_[567]) * 0.5;
    jac[46] = ((v_[633] * v_[566] + v_[631] * v_[572]) * v_[489] - (v_[632] * v_[566] + v_[628] * v_[572]) * v_[567]) * 0.5;
    jac[47] = ((v_[575] * v_[566] + v_[598] * v_[572]) * v_[489] - (v_[639] * v_[566] + v_[637] * v_[572]) * v_[567]) * 0.5;
    v_[567] = cos(v_[16]);
    v_[16] = sin(v_[16]);
    jac[48] = ((v_[46] * v_[20] + v_[35] * v_[31] + v_[42] * v_[32] + v_[47] * v_[15]) * v_[567] - (v_[45] * v_[15] + v_[35] * v_[32] + v_[39] * v_[31] + v_[47] * v_[20]) * v_[16]) * 0.5;
    jac[49] = ((v_[57] * v_[20] + v_[51] * v_[31] + v_[55] * v_[32] + v_[58] * v_[15]) * v_[567] - (v_[53] * v_[15] + v_[51] * v_[32] + v_[54] * v_[31] + v_[58] * v_[20]) * v_[16]) * 0.5;
    jac[50] = ((v_[66] * v_[20] + v_[62] * v_[31] + v_[64] * v_[32] + v_[38] * v_[15]) * v_[567] - (v_[63] * v_[15] + v_[62] * v_[32] + v_[10] * v_[31] + v_[38] * v_[20]) * v_[16]) * 0.5;
    v_[16] = cos(v_[94]);
    v_[94] = sin(v_[94]);
    jac[51] = ((v_[140] * v_[98] + v_[125] * v_[121] + v_[136] * v_[122] + v_[141] * v_[93]) * v_[16] - (v_[139] * v_[93] + v_[125] * v_[122] + v_[133] * v_[121] + v_[141] * v_[98]) * v_[94]) * 0.5;
    jac[52] = ((v_[151] * v_[98] + v_[145] * v_[121] + v_[149] * v_[122] + v_[152] * v_[93]) * v_[16] - (v_[147] * v_[93] + v_[145] * v_[122] + v_[148] * v_[121] + v_[152] * v_[98]) * v_[94]) * 0.5;
    jac[53] = ((v_[160] * v_[98] + v_[156] * v_[121] + v_[158] * v_[122] + v_[132] * v_[93]) * v_[16] - (v_[157] * v_[93] + v_[156] * v_[122] + v_[88] * v_[121] + v_[132] * v_[98]) * v_[94]) * 0.5;
    v_[94] = cos(v_[173]);
    v_[173] = sin(v_[173]);
    jac[54] = ((v_[203] * v_[177] + v_[192] * v_[188] + v_[199] * v_[189] + v_[204] * v_[172]) * v_[94] - (v_[202] * v_[172] + v_[192] * v_[189] + v_[196] * v_[188] + v_[204] * v_[177]) * v_[173]) * 0.5;
    jac[55] = ((v_[214] * v_[177] + v_[208] * v_[188] + v_[212] * v_[189] + v_[215] * v_[172]) * v_[94] - (v_[210] * v_[172] + v_[208] * v_[189] + v_[211] * v_[188] + v_[215] * v_[177]) * v_[173]) * 0.5;
    jac[56] = ((v_[223] * v_[177] + v_[219] * v_[188] + v_[221] * v_[189] + v_[195] * v_[172]) * v_[94] - (v_[220] * v_[172] + v_[219] * v_[189] + v_[167] * v_[188] + v_[195] * v_[177]) * v_[173]) * 0.5;
    v_[173] = cos(v_[251]);
    v_[251] = sin(v_[251]);
    jac[57] = ((v_[299] * v_[255] + v_[284] * v_[280] + v_[295] * v_[281] + v_[300] * v_[250]) * v_[173] - (v_[298] * v_[250] + v_[284] * v_[281] + v_[292] * v_[280] + v_[300] * v_[255]) * v_[251]) * 0.5;
    jac[58] = ((v_[310] * v_[255] + v_[304] * v_[280] + v_[308] * v_[281] + v_[311] * v_[250]) * v_[173] - (v_[306] * v_[250] + v_[304] * v_[281] + v_[307] * v_[280] + v_[311] * v_[255]) * v_[251]) * 0.5;
    jac[59] = ((v_[319] * v_[255] + v_[315] * v_[280] + v_[317] * v_[281] + v_[291] * v_[250]) * v_[173] - (v_[316] * v_[250] + v_[315] * v_[281] + v_[245] * v_[280] + v_[291] * v_[255]) * v_[251]) * 0.5;
    v_[251] = cos(v_[332]);
    v_[332] = sin(v_[332]);
    jac[60] = ((v_[362] * v_[336] + v_[351] * v_[347] + v_[358] * v_[348] + v_[363] * v_[331]) * v_[251] - (v_[361] * v_[331] + v_[351] * v_[348] + v_[355] * v_[347] + v_[363] * v_[336]) * v_[332]) * 0.5;
    jac[61] = ((v_[373] * v_[336] + v_[367] * v_[347] + v_[371] * v_[348] + v_[374] * v_[331]) * v_[251] - (v_[369] * v_[331] + v_[367] * v_[348] + v_[370] * v_[347] + v_[374] * v_[336]) * v_[332]) * 0.5;
    jac[62] = ((v_[382] * v_[336] + v_[378] * v_[347] + v_[380] * v_[348] + v_[354] * v_[331]) * v_[251] - (v_[379] * v_[331] + v_[378] * v_[348] + v_[326] * v_[347] + v_[354] * v_[336]) * v_[332]) * 0.5;
    v_[332] = cos(v_[411]);
    v_[411] = sin(v_[411]);
    jac[63] = ((v_[459] * v_[415] + v_[444] * v_[440] + v_[455] * v_[441] + v_[460] * v_[410]) * v_[332] - (v_[458] * v_[410] + v_[444] * v_[441] + v_[452] * v_[440] + v_[460] * v_[415]) * v_[411]) * 0.5;
    jac[64] = ((v_[470] * v_[415] + v_[464] * v_[440] + v_[468] * v_[441] + v_[471] * v_[410]) * v_[332] - (v_[466] * v_[410] + v_[464] * v_[441] + v_[467] * v_[440] + v_[471] * v_[415]) * v_[411]) * 0.5;
    jac[65] = ((v_[479] * v_[415] + v_[475] * v_[440] + v_[477] * v_[441] + v_[451] * v_[410]) * v_[332] - (v_[476] * v_[410] + v_[475] * v_[441] + v_[405] * v_[440] + v_[451] * v_[415]) * v_[411]) * 0.5;
    v_[411] = cos(v_[492]);
    v_[492] = sin(v_[492]);
    jac[66] = ((v_[522] * v_[496] + v_[511] * v_[507] + v_[518] * v_[508] + v_[523] * v_[491]) * v_[411] - (v_[521] * v_[491] + v_[511] * v_[508] + v_[515] * v_[507] + v_[523] * v_[496]) * v_[492]) * 0.5;
    jac[67] = ((v_[533] * v_[496] + v_[527] * v_[507] + v_[531] * v_[508] + v_[534] * v_[491]) * v_[411] - (v_[529] * v_[491] + v_[527] * v_[508] + v_[530] * v_[507] + v_[534] * v_[496]) * v_[492]) * 0.5;
    jac[68] = ((v_[542] * v_[496] + v_[538] * v_[507] + v_[540] * v_[508] + v_[514] * v_[491]) * v_[411] - (v_[539] * v_[491] + v_[538] * v_[508] + v_[486] * v_[507] + v_[514] * v_[496]) * v_[492]) * 0.5;
    v_[492] = cos(v_[570]);
    v_[570] = sin(v_[570]);
    jac[69] = ((v_[618] * v_[574] + v_[603] * v_[599] + v_[614] * v_[600] + v_[619] * v_[569]) * v_[492] - (v_[617] * v_[569] + v_[603] * v_[600] + v_[611] * v_[599] + v_[619] * v_[574]) * v_[570]) * 0.5;
    jac[70] = ((v_[629] * v_[574] + v_[623] * v_[599] + v_[627] * v_[600] + v_[630] * v_[569]) * v_[492] - (v_[625] * v_[569] + v_[623] * v_[600] + v_[626] * v_[599] + v_[630] * v_[574]) * v_[570]) * 0.5;
    jac[71] = ((v_[638] * v_[574] + v_[634] * v_[599] + v_[636] * v_[600] + v_[610] * v_[569]) * v_[492] - (v_[635] * v_[569] + v_[634] * v_[600] + v_[564] * v_[599] + v_[610] * v_[574]) * v_[570]) * 0.5;
    v_[570] = v_[23] * v_[40];
    v_[492] = v_[34] * v_[41];
    v_[610] = v_[570] + v_[492];
    v_[638] = v_[610] * v_[4];
    v_[635] = 0 - v_[610];
    v_[636] = v_[635] * v_[8];
    v_[564] = 0 - v_[610];
    v_[634] = sin(x_in[6]);
    v_[600] = v_[34] * v_[40];
    v_[599] = v_[23] * v_[41];
    v_[574] = v_[600] - v_[599];
    v_[569] = v_[574] * v_[4];
    v_[630] = 0 - v_[574];
    v_[629] = v_[630] * v_[8];
    v_[625] = 0 - v_[574];
    v_[627] = cos(x_in[6]);
    jac[144] = 0 - (v_[638] * v_[2] * 0.33 + v_[636] * v_[6] * 0.33 + v_[564] * v_[6] * 0.35 + (0 - v_[610]) * 0.08) * v_[634] + (v_[569] * v_[2] * 0.33 + v_[629] * v_[6] * 0.33 + v_[625] * v_[6] * 0.35 + (0 - v_[574]) * 0.08) * v_[627];
    v_[626] = v_[23] * v_[33];
    v_[41] = v_[52] * v_[41];
    v_[623] = v_[626] - v_[41];
    v_[619] = v_[623] * v_[4];
    v_[618] = 0 - v_[623];
    v_[617] = v_[618] * v_[8];
    v_[614] = 0 - v_[623];
    v_[23] = v_[23] * v_[22];
    v_[52] = v_[52] * v_[40];
    v_[40] = 1 - v_[23] - v_[52];
    v_[22] = v_[40] * v_[4];
    v_[611] = 0 - v_[40];
    v_[603] = v_[611] * v_[8];
    v_[411] = 0 - v_[40];
    jac[145] = 0 - (v_[619] * v_[2] * 0.33 + v_[617] * v_[6] * 0.33 + v_[614] * v_[6] * 0.35 + (0 - v_[623]) * 0.08) * v_[634] + (v_[22] * v_[2] * 0.33 + v_[603] * v_[6] * 0.33 + v_[411] * v_[6] * 0.35 + (0 - v_[40]) * 0.08) * v_[627];
    v_[34] = v_[34] * v_[33];
    v_[52] = 1 - v_[34] - v_[52];
    v_[33] = v_[52] * v_[4];
    v_[514] = 0 - v_[52];
    v_[542] = v_[514] * v_[8];
    v_[539] = 0 - v_[52];
    v_[41] = v_[626] + v_[41];
    v_[626] = v_[41] * v_[4];
    v_[540] = 0 - v_[41];
    v_[486] = v_[540] * v_[8];
    v_[538] = 0 - v_[41];
    jac[146] = 0 - (v_[33] * v_[2] * 0.33 + v_[542] * v_[6] * 0.33 + v_[539] * v_[6] * 0.35 + (0 - v_[52]) * 0.08) * v_[634] + (v_[626] * v_[2] * 0.33 + v_[486] * v_[6] * 0.33 + v_[538] * v_[6] * 0.35 + (0 - v_[41]) * 0.08) * v_[627];
    v_[100] = v_[101] * v_[100];
    v_[508] = v_[124] * v_[123];
    jac[507] = 1 - v_[100] - v_[508];
    v_[507] = v_[124] * v_[134];
    v_[496] = v_[101] * v_[135];
    jac[531] = v_[507] - v_[496];
    jac[508] = v_[507] + v_[496];
    v_[496] = 0 - jac[531];
    v_[507] = jac[507] * x_in[19] + v_[496] * x_in[18];
    v_[491] = v_[507] * v_[4];
    v_[534] = 0 - v_[507];
    v_[533] = v_[101] * v_[134];
    v_[124] = v_[124] * v_[135];
    jac[555] = v_[533] + v_[124];
    jac[435] = v_[496] * v_[0] + jac[555] * v_[84];
    jac[509] = v_[533] - v_[124];
    jac[579] = jac[555] * v_[78] + jac[531] * v_[116];
    jac[603] = jac[555] * v_[72] + jac[531] * v_[110] + jac[507] * v_[131];
    jac[627] = jac[555] * v_[17] + jac[531] * v_[106] + jac[507] * v_[128];
    v_[124] = jac[555] * x_in[26];
    v_[533] = v_[124] * v_[8];
    v_[496] = jac[555] * x_in[25];
    v_[529] = v_[496] * v_[4];
    v_[531] = v_[124] * v_[4];
    v_[530] = v_[496] * v_[8];
    v_[527] = jac[531] * x_in[24];
    v_[523] = v_[527] * v_[4];
    v_[522] = 0 - v_[507];
    v_[521] = 0 - v_[527];
    v_[518] = v_[522] * v_[8] + v_[521] * v_[8];
    v_[515] = 0 - v_[527];
    v_[511] = 0 - jac[507];
    jac[483] = v_[511] * v_[84] + jac[531] * v_[87];
    v_[511] = v_[511] * x_in[20] + jac[555] * x_in[18];
    v_[332] = v_[511] * v_[4];
    v_[451] = 0 - v_[511];
    v_[479] = v_[451] * v_[8];
    v_[476] = 0 - v_[511];
    v_[477] = jac[555] * x_in[24];
    v_[405] = v_[477] * v_[4];
    v_[475] = v_[477] * v_[8];
    v_[441] = jac[531] * x_in[26];
    v_[440] = v_[441] * v_[8];
    v_[415] = jac[531] * x_in[25];
    v_[410] = v_[415] * v_[4];
    v_[471] = v_[441] * v_[4];
    v_[470] = v_[415] * v_[8];
    jac[147] = 0 - (v_[491] * v_[2] * 0.33 + v_[534] * v_[6] * 0.35 + (0 - v_[507]) * 0.08 + v_[533] * v_[2] * 0.33 + v_[529] * v_[6] * 0.33 + (v_[531] * v_[6] + v_[530] * v_[2]) * 0.33 + v_[496] * v_[2] * 0.35 + v_[523] * v_[2] * 0.33 + v_[518] * v_[6] * 0.33 + v_[515] * v_[6] * 0.35 + (0 - v_[527]) * 0.08) * v_[634] + (v_[332] * v_[2] * 0.33 + v_[479] * v_[6] * 0.33 + v_[476] * v_[6] * 0.35 + (0 - v_[511]) * 0.08 + v_[405] * v_[2] * -0.33 + v_[475] * v_[6] * 0.33 + v_[477] * v_[6] * 0.35 + v_[477] * 0.08 + v_[440] * v_[2] * 0.33 + v_[410] * v_[6] * 0.33 + (v_[471] * v_[6] + v_[470] * v_[2]) * 0.33 + v_[415] * v_[2] * 0.35) * v_[627];
    v_[134] = v_[146] * v_[134];
    jac[532] = 1 - v_[100] - v_[134];
    jac[557] = 1 - v_[508] - v_[134];
    v_[134] = 0 - jac[532];
    v_[508] = jac[508] * x_in[19] + v_[134] * x_in[18];
    v_[100] = v_[508] * v_[4];
    v_[466] = 0 - v_[508];
    v_[123] = v_[101] * v_[123];
    v_[146] = v_[146] * v_[135];
    jac[556] = v_[123] - v_[146];
    jac[436] = v_[134] * v_[0] + jac[556] * v_[84];
    jac[533] = v_[123] + v_[146];
    jac[580] = jac[556] * v_[78] + jac[532] * v_[116];
    jac[581] = jac[557] * v_[78] + jac[533] * v_[116];
    jac[604] = jac[556] * v_[72] + jac[532] * v_[110] + jac[508] * v_[131];
    jac[605] = jac[557] * v_[72] + jac[533] * v_[110] + jac[509] * v_[131];
    jac[628] = jac[556] * v_[17] + jac[532] * v_[106] + jac[508] * v_[128];
    jac[629] = jac[557] * v_[17] + jac[533] * v_[106] + jac[509] * v_[128];
    v_[128] = jac[556] * x_in[26];
    v_[106] = v_[128] * v_[8];
    v_[17] = jac[556] * x_in[25];
    v_[131] = v_[17] * v_[4];
    v_[110] = v_[128] * v_[4];
    v_[72] = v_[17] * v_[8];
    v_[116] = jac[532] * x_in[24];
    v_[78] = v_[116] * v_[4];
    v_[146] = 0 - v_[508];
    v_[123] = 0 - v_[116];
    v_[134] = v_[146] * v_[8] + v_[123] * v_[8];
    v_[135] = 0 - v_[116];
    v_[101] = 0 - jac[508];
    jac[484] = v_[101] * v_[84] + jac[532] * v_[87];
    v_[101] = v_[101] * x_in[20] + jac[556] * x_in[18];
    v_[468] = v_[101] * v_[4];
    v_[467] = 0 - v_[101];
    v_[464] = v_[467] * v_[8];
    v_[460] = 0 - v_[101];
    v_[459] = jac[556] * x_in[24];
    v_[458] = v_[459] * v_[4];
    v_[455] = v_[459] * v_[8];
    v_[452] = jac[532] * x_in[26];
    v_[444] = v_[452] * v_[8];
    v_[251] = jac[532] * x_in[25];
    v_[354] = v_[251] * v_[4];
    v_[382] = v_[452] * v_[4];
    v_[379] = v_[251] * v_[8];
    jac[148] = 0 - (v_[100] * v_[2] * 0.33 + v_[466] * v_[6] * 0.35 + (0 - v_[508]) * 0.08 + v_[106] * v_[2] * 0.33 + v_[131] * v_[6] * 0.33 + (v_[110] * v_[6] + v_[72] * v_[2]) * 0.33 + v_[17] * v_[2] * 0.35 + v_[78] * v_[2] * 0.33 + v_[134] * v_[6] * 0.33 + v_[135] * v_[6] * 0.35 + (0 - v_[116]) * 0.08) * v_[634] + (v_[468] * v_[2] * 0.33 + v_[464] * v_[6] * 0.33 + v_[460] * v_[6] * 0.35 + (0 - v_[101]) * 0.08 + v_[458] * v_[2] * -0.33 + v_[455] * v_[6] * 0.33 + v_[459] * v_[6] * 0.35 + v_[459] * 0.08 + v_[444] * v_[2] * 0.33 + v_[354] * v_[6] * 0.33 + (v_[382] * v_[6] + v_[379] * v_[2]) * 0.33 + v_[251] * v_[2] * 0.35) * v_[627];
    v_[380] = 0 - jac[533];
    v_[326] = jac[509] * x_in[19] + v_[380] * x_in[18];
    v_[378] = v_[326] * v_[4];
    v_[348] = 0 - v_[326];
    jac[437] = v_[380] * v_[0] + jac[557] * v_[84];
    v_[380] = jac[557] * x_in[26];
    v_[347] = v_[380] * v_[8];
    v_[336] = jac[557] * x_in[25];
    v_[331] = v_[336] * v_[4];
    v_[374] = v_[380] * v_[4];
    v_[373] = v_[336] * v_[8];
    v_[369] = jac[533] * x_in[24];
    v_[371] = v_[369] * v_[4];
    v_[370] = 0 - v_[326];
    v_[367] = 0 - v_[369];
    v_[363] = v_[370] * v_[8] + v_[367] * v_[8];
    v_[362] = 0 - v_[369];
    v_[361] = 0 - jac[509];
    jac[485] = v_[361] * v_[84] + jac[533] * v_[87];
    v_[361] = v_[361] * x_in[20] + jac[557] * x_in[18];
    v_[84] = v_[361] * v_[4];
    v_[358] = 0 - v_[361];
    v_[355] = v_[358] * v_[8];
    v_[351] = 0 - v_[361];
    v_[173] = jac[557] * x_in[24];
    v_[291] = v_[173] * v_[4];
    v_[319] = v_[173] * v_[8];
    v_[316] = jac[533] * x_in[26];
    v_[317] = v_[316] * v_[8];
    v_[245] = jac[533] * x_in[25];
    v_[315] = v_[245] * v_[4];
    v_[281] = v_[316] * v_[4];
    v_[280] = v_[245] * v_[8];
    jac[149] = 0 - (v_[378] * v_[2] * 0.33 + v_[348] * v_[6] * 0.35 + (0 - v_[326]) * 0.08 + v_[347] * v_[2] * 0.33 + v_[331] * v_[6] * 0.33 + (v_[374] * v_[6] + v_[373] * v_[2]) * 0.33 + v_[336] * v_[2] * 0.35 + v_[371] * v_[2] * 0.33 + v_[363] * v_[6] * 0.33 + v_[362] * v_[6] * 0.35 + (0 - v_[369]) * 0.08) * v_[634] + (v_[84] * v_[2] * 0.33 + v_[355] * v_[6] * 0.33 + v_[351] * v_[6] * 0.35 + (0 - v_[361]) * 0.08 + v_[291] * v_[2] * -0.33 + v_[319] * v_[6] * 0.33 + v_[173] * v_[6] * 0.35 + v_[173] * 0.08 + v_[317] * v_[2] * 0.33 + v_[315] * v_[6] * 0.33 + (v_[281] * v_[6] + v_[280] * v_[2]) * 0.33 + v_[245] * v_[2] * 0.35) * v_[627];
    v_[34] = 1 - v_[23] - v_[34];
    v_[23] = sin(x_in[7]);
    v_[627] = 0 - v_[34];
    v_[634] = cos(x_in[7]);
    jac[168] = 0 - (v_[636] * v_[5] + v_[564] * v_[9] + v_[629] * v_[27] + v_[625] * v_[29] + v_[34] * v_[4] * -0.33) * v_[23] + (v_[638] * v_[1] + v_[569] * v_[25] + v_[627] * v_[8] * 0.33 + (0 - v_[34]) * 0.35) * v_[634];
    v_[599] = v_[600] + v_[599];
    v_[600] = 0 - v_[599];
    jac[169] = 0 - (v_[617] * v_[5] + v_[614] * v_[9] + v_[603] * v_[27] + v_[411] * v_[29] + v_[599] * v_[4] * -0.33) * v_[23] + (v_[619] * v_[1] + v_[22] * v_[25] + v_[600] * v_[8] * 0.33 + (0 - v_[599]) * 0.35) * v_[634];
    v_[492] = v_[570] - v_[492];
    v_[570] = 0 - v_[492];
    jac[170] = 0 - (v_[542] * v_[5] + v_[539] * v_[9] + v_[486] * v_[27] + v_[538] * v_[29] + v_[492] * v_[4] * -0.33) * v_[23] + (v_[33] * v_[1] + v_[626] * v_[25] + v_[570] * v_[8] * 0.33 + (0 - v_[492]) * 0.35) * v_[634];
    v_[538] = 0 - jac[555];
    jac[459] = jac[507] * v_[0] + v_[538] * v_[87];
    v_[538] = jac[531] * x_in[20] + v_[538] * x_in[19];
    v_[486] = jac[507] * x_in[26];
    v_[626] = 0 - v_[486];
    v_[539] = jac[507] * x_in[25];
    v_[542] = 0 - v_[539];
    v_[33] = 0 - v_[538];
    jac[171] = 0 - (v_[534] * v_[119] + v_[479] * v_[81] + v_[476] * v_[83] + v_[538] * v_[4] * -0.33 + v_[531] * v_[11] + v_[529] * v_[69] + v_[475] * v_[73] + v_[477] * v_[77] + v_[471] * v_[102] + v_[410] * v_[108] + v_[518] * v_[113] + v_[515] * v_[115] + v_[626] * v_[8] * 0.33 + v_[542] * v_[8] * 0.33 + (0 - v_[539]) * 0.35) * v_[23] + (v_[491] * v_[117] + v_[332] * v_[79] + v_[33] * v_[8] * 0.33 + (0 - v_[538]) * 0.35 + v_[533] * v_[19] + v_[530] * v_[11] + v_[496] * v_[71] + v_[405] * v_[75] + v_[440] * v_[104] + v_[470] * v_[102] + v_[415] * v_[24] + v_[523] * v_[111] + v_[486] * v_[4] * 0.33 + v_[539] * v_[4] * 0.33) * v_[634];
    v_[470] = 0 - jac[556];
    jac[460] = jac[508] * v_[0] + v_[470] * v_[87];
    v_[470] = jac[532] * x_in[20] + v_[470] * x_in[19];
    v_[471] = jac[508] * x_in[26];
    v_[410] = 0 - v_[471];
    v_[440] = jac[508] * x_in[25];
    v_[475] = 0 - v_[440];
    v_[405] = 0 - v_[470];
    jac[172] = 0 - (v_[466] * v_[119] + v_[464] * v_[81] + v_[460] * v_[83] + v_[470] * v_[4] * -0.33 + v_[110] * v_[11] + v_[131] * v_[69] + v_[455] * v_[73] + v_[459] * v_[77] + v_[382] * v_[102] + v_[354] * v_[108] + v_[134] * v_[113] + v_[135] * v_[115] + v_[410] * v_[8] * 0.33 + v_[475] * v_[8] * 0.33 + (0 - v_[440]) * 0.35) * v_[23] + (v_[100] * v_[117] + v_[468] * v_[79] + v_[405] * v_[8] * 0.33 + (0 - v_[470]) * 0.35 + v_[106] * v_[19] + v_[72] * v_[11] + v_[17] * v_[71] + v_[458] * v_[75] + v_[444] * v_[104] + v_[379] * v_[102] + v_[251] * v_[24] + v_[78] * v_[111] + v_[471] * v_[4] * 0.33 + v_[440] * v_[4] * 0.33) * v_[634];
    v_[379] = 0 - jac[557];
    jac[461] = jac[509] * v_[0] + v_[379] * v_[87];
    v_[379] = jac[533] * x_in[20] + v_[379] * x_in[19];
    v_[0] = jac[509] * x_in[26];
    v_[87] = 0 - v_[0];
    v_[382] = jac[509] * x_in[25];
    v_[354] = 0 - v_[382];
    v_[444] = 0 - v_[379];
    jac[173] = 0 - (v_[348] * v_[119] + v_[355] * v_[81] + v_[351] * v_[83] + v_[379] * v_[4] * -0.33 + v_[374] * v_[11] + v_[331] * v_[69] + v_[319] * v_[73] + v_[173] * v_[77] + v_[281] * v_[102] + v_[315] * v_[108] + v_[363] * v_[113] + v_[362] * v_[115] + v_[87] * v_[8] * 0.33 + v_[354] * v_[8] * 0.33 + (0 - v_[382]) * 0.35) * v_[23] + (v_[378] * v_[117] + v_[84] * v_[79] + v_[444] * v_[8] * 0.33 + (0 - v_[379]) * 0.35 + v_[347] * v_[19] + v_[373] * v_[11] + v_[336] * v_[71] + v_[291] * v_[75] + v_[317] * v_[104] + v_[280] * v_[102] + v_[245] * v_[24] + v_[371] * v_[111] + v_[0] * v_[4] * 0.33 + v_[382] * v_[4] * 0.33) * v_[634];
    v_[634] = sin(x_in[8]);
    v_[23] = cos(x_in[8]);
    jac[192] = 0 - (v_[635] * v_[7] + v_[630] * v_[28] + v_[627] * v_[37]) * v_[634] + (v_[610] * v_[3] + v_[574] * v_[26] + v_[34] * v_[36]) * v_[23];
    jac[193] = 0 - (v_[618] * v_[7] + v_[611] * v_[28] + v_[600] * v_[37]) * v_[634] + (v_[623] * v_[3] + v_[40] * v_[26] + v_[599] * v_[36]) * v_[23];
    jac[194] = 0 - (v_[514] * v_[7] + v_[540] * v_[28] + v_[570] * v_[37]) * v_[634] + (v_[52] * v_[3] + v_[41] * v_[26] + v_[492] * v_[36]) * v_[23];
    jac[195] = 0 - (v_[522] * v_[114] + v_[451] * v_[82] + v_[33] * v_[86] + v_[124] * v_[14] + v_[496] * v_[68] + v_[477] * v_[74] + v_[441] * v_[105] + v_[415] * v_[107] + v_[521] * v_[114] + v_[626] * v_[127] + v_[542] * v_[130]) * v_[634] + (v_[507] * v_[118] + v_[511] * v_[80] + v_[538] * v_[85] + v_[124] * v_[48] + v_[496] * v_[70] + v_[477] * v_[76] + v_[441] * v_[103] + v_[415] * v_[109] + v_[527] * v_[112] + v_[486] * v_[126] + v_[539] * v_[129]) * v_[23];
    jac[196] = 0 - (v_[146] * v_[114] + v_[467] * v_[82] + v_[405] * v_[86] + v_[128] * v_[14] + v_[17] * v_[68] + v_[459] * v_[74] + v_[452] * v_[105] + v_[251] * v_[107] + v_[123] * v_[114] + v_[410] * v_[127] + v_[475] * v_[130]) * v_[634] + (v_[508] * v_[118] + v_[101] * v_[80] + v_[470] * v_[85] + v_[128] * v_[48] + v_[17] * v_[70] + v_[459] * v_[76] + v_[452] * v_[103] + v_[251] * v_[109] + v_[116] * v_[112] + v_[471] * v_[126] + v_[440] * v_[129]) * v_[23];
    jac[197] = 0 - (v_[370] * v_[114] + v_[358] * v_[82] + v_[444] * v_[86] + v_[380] * v_[14] + v_[336] * v_[68] + v_[173] * v_[74] + v_[316] * v_[105] + v_[245] * v_[107] + v_[367] * v_[114] + v_[87] * v_[127] + v_[354] * v_[130]) * v_[634] + (v_[326] * v_[118] + v_[361] * v_[80] + v_[379] * v_[85] + v_[380] * v_[48] + v_[336] * v_[70] + v_[173] * v_[76] + v_[316] * v_[103] + v_[245] * v_[109] + v_[369] * v_[112] + v_[0] * v_[126] + v_[382] * v_[129]) * v_[23];
    v_[23] = v_[180] * v_[197];
    v_[634] = v_[191] * v_[198];
    v_[444] = v_[23] + v_[634];
    v_[354] = v_[444] * v_[95];
    v_[382] = 0 - v_[444];
    v_[87] = v_[382] * v_[165];
    v_[0] = 0 - v_[444];
    v_[379] = sin(x_in[9]);
    v_[245] = v_[191] * v_[197];
    v_[316] = v_[180] * v_[198];
    v_[173] = v_[245] - v_[316];
    v_[358] = v_[173] * v_[95];
    v_[361] = v_[173] * v_[165];
    v_[367] = cos(x_in[9]);
    jac[222] = 0 - (v_[354] * v_[97] * 0.33 + v_[87] * v_[163] * 0.33 + v_[0] * v_[163] * 0.35 + (0 - v_[444]) * 0.08) * v_[379] + (v_[358] * v_[97] * -0.33 + v_[361] * v_[163] * 0.33 + v_[173] * v_[163] * 0.35 + v_[173] * 0.08) * v_[367];
    v_[370] = v_[180] * v_[190];
    v_[198] = v_[209] * v_[198];
    v_[369] = v_[370] - v_[198];
    v_[336] = v_[369] * v_[95];
    v_[380] = 0 - v_[369];
    v_[326] = v_[380] * v_[165];
    v_[130] = 0 - v_[369];
    v_[180] = v_[180] * v_[179];
    v_[209] = v_[209] * v_[197];
    v_[197] = 1 - v_[180] - v_[209];
    v_[179] = v_[197] * v_[95];
    v_[129] = v_[197] * v_[165];
    jac[223] = 0 - (v_[336] * v_[97] * 0.33 + v_[326] * v_[163] * 0.33 + v_[130] * v_[163] * 0.35 + (0 - v_[369]) * 0.08) * v_[379] + (v_[179] * v_[97] * -0.33 + v_[129] * v_[163] * 0.33 + v_[197] * v_[163] * 0.35 + v_[197] * 0.08) * v_[367];
    v_[191] = v_[191] * v_[190];
    v_[209] = 1 - v_[191] - v_[209];
    v_[190] = v_[209] * v_[95];
    v_[127] = 0 - v_[209];
    v_[126] = v_[127] * v_[165];
    v_[118] = 0 - v_[209];
    v_[198] = v_[370] + v_[198];
    v_[370] = v_[198] * v_[95];
    v_[114] = v_[198] * v_[165];
    jac[224] = 0 - (v_[190] * v_[97] * 0.33 + v_[126] * v_[163] * 0.33 + v_[118] * v_[163] * 0.35 + (0 - v_[209]) * 0.08) * v_[379] + (v_[370] * v_[97] * -0.33 + v_[114] * v_[163] * 0.33 + v_[198] * v_[163] * 0.35 + v_[198] * 0.08) * v_[367];
    v_[257] = v_[258] * v_[257];
    v_[112] = v_[283] * v_[282];
    jac[513] = 1 - v_[257] - v_[112];
    v_[109] = v_[283] * v_[293];
    v_[107] = v_[258] * v_[294];
    jac[537] = v_[109] - v_[107];
    jac[514] = v_[109] + v_[107];
    v_[107] = 0 - jac[537];
    v_[109] = jac[513] * x_in[19] + v_[107] * x_in[18];
    v_[105] = v_[109] * v_[95];
    v_[103] = 0 - v_[109];
    v_[86] = v_[103] * v_[165];
    v_[85] = 0 - v_[109];
    v_[82] = v_[258] * v_[293];
    v_[283] = v_[283] * v_[294];
    jac[561] = v_[82] + v_[283];
    jac[441] = v_[107] * v_[89] + jac[561] * v_[241];
    jac[515] = v_[82] - v_[283];
    jac[657] = jac[561] * v_[235] + jac[537] * v_[273];
    jac[681] = jac[561] * v_[229] + jac[537] * v_[267] + jac[513] * v_[290];
    jac[705] = jac[561] * v_[174] + jac[537] * v_[263] + jac[513] * v_[287];
    v_[283] = jac[561] * x_in[29];
    v_[82] = v_[283] * v_[165];
    v_[107] = jac[561] * x_in[28];
    v_[80] = v_[107] * v_[95];
    v_[76] = v_[283] * v_[95];
    v_[74] = v_[107] * v_[165];
    v_[70] = jac[537] * x_in[27];
    v_[68] = v_[70] * v_[95];
    v_[14] = v_[70] * v_[165];
    v_[48] = 0 - jac[513];
    jac[489] = v_[48] * v_[241] + jac[537] * v_[244];
    v_[48] = v_[48] * x_in[20] + jac[561] * x_in[18];
    v_[405] = v_[48] * v_[95];
    v_[475] = v_[48] * v_[165];
    v_[440] = jac[561] * x_in[27];
    v_[410] = v_[440] * v_[165];
    v_[471] = jac[537] * x_in[29];
    v_[470] = v_[471] * v_[95];
    v_[251] = 0 - v_[471];
    v_[452] = v_[251] * v_[165];
    v_[459] = v_[440] * v_[95];
    v_[467] = jac[537] * x_in[28];
    v_[101] = v_[467] * v_[95];
    v_[123] = 0 - v_[467];
    v_[146] = v_[123] * v_[165];
    v_[116] = 0 - v_[467];
    jac[225] = 0 - (v_[105] * v_[97] * 0.33 + v_[86] * v_[163] * 0.33 + v_[85] * v_[163] * 0.35 + (0 - v_[109]) * 0.08 + v_[82] * v_[97] * 0.33 + v_[80] * v_[163] * 0.33 + (v_[76] * v_[163] + v_[74] * v_[97]) * 0.33 + v_[107] * v_[97] * 0.35 + v_[68] * v_[97] * -0.33 + v_[14] * v_[163] * 0.33 + v_[70] * v_[163] * 0.35 + v_[70] * 0.08) * v_[379] + (v_[405] * v_[97] * -0.33 + v_[475] * v_[163] * 0.33 + v_[48] * v_[163] * 0.35 + v_[48] * 0.08 + v_[410] * v_[163] * 0.33 + v_[440] * v_[163] * 0.35 + v_[440] * 0.08 + v_[470] * v_[163] * -0.33 + v_[452] * v_[97] * 0.33 + (v_[459] * v_[97] + v_[101] * v_[163]) * -0.33 + v_[146] * v_[97] * 0.33 + v_[116] * v_[97] * 0.35) * v_[367];
    v_[293] = v_[305] * v_[293];
    jac[538] = 1 - v_[257] - v_[293];
    jac[563] = 1 - v_[112] - v_[293];
    v_[293] = 0 - jac[538];
    v_[112] = jac[514] * x_in[19] + v_[293] * x_in[18];
    v_[257] = v_[112] * v_[95];
    v_[17] = 0 - v_[112];
    v_[128] = v_[17] * v_[165];
    v_[508] = 0 - v_[112];
    v_[282] = v_[258] * v_[282];
    v_[305] = v_[305] * v_[294];
    jac[562] = v_[282] - v_[305];
    jac[442] = v_[293] * v_[89] + jac[562] * v_[241];
    jac[539] = v_[282] + v_[305];
    jac[658] = jac[562] * v_[235] + jac[538] * v_[273];
    jac[659] = jac[563] * v_[235] + jac[539] * v_[273];
    jac[682] = jac[562] * v_[229] + jac[538] * v_[267] + jac[514] * v_[290];
    jac[683] = jac[563] * v_[229] + jac[539] * v_[267] + jac[515] * v_[290];
    jac[706] = jac[562] * v_[174] + jac[538] * v_[263] + jac[514] * v_[287];
    jac[707] = jac[563] * v_[174] + jac[539] * v_[263] + jac[515] * v_[287];
    v_[287] = jac[562] * x_in[29];
    v_[263] = v_[287] * v_[165];
    v_[174] = jac[562] * x_in[28];
    v_[290] = v_[174] * v_[95];
    v_[267] = v_[287] * v_[95];
    v_[229] = v_[174] * v_[165];
    v_[273] = jac[538] * x_in[27];
    v_[235] = v_[273] * v_[95];
    v_[305] = v_[273] * v_[165];
    v_[282] = 0 - jac[514];
    jac[490] = v_[282] * v_[241] + jac[538] * v_[244];
    v_[282] = v_[282] * x_in[20] + jac[562] * x_in[18];
    v_[293] = v_[282] * v_[95];
    v_[294] = v_[282] * v_[165];
    v_[258] = jac[562] * x_in[27];
    v_[33] = v_[258] * v_[165];
    v_[542] = jac[538] * x_in[29];
    v_[539] = v_[542] * v_[95];
    v_[626] = 0 - v_[542];
    v_[486] = v_[626] * v_[165];
    v_[538] = v_[258] * v_[95];
    v_[415] = jac[538] * x_in[28];
    v_[441] = v_[415] * v_[95];
    v_[477] = 0 - v_[415];
    v_[451] = v_[477] * v_[165];
    v_[511] = 0 - v_[415];
    jac[226] = 0 - (v_[257] * v_[97] * 0.33 + v_[128] * v_[163] * 0.33 + v_[508] * v_[163] * 0.35 + (0 - v_[112]) * 0.08 + v_[263] * v_[97] * 0.33 + v_[290] * v_[163] * 0.33 + (v_[267] * v_[163] + v_[229] * v_[97]) * 0.33 + v_[174] * v_[97] * 0.35 + v_[235] * v_[97] * -0.33 + v_[305] * v_[163] * 0.33 + v_[273] * v_[163] * 0.35 + v_[273] * 0.08) * v_[379] + (v_[293] * v_[97] * -0.33 + v_[294] * v_[163] * 0.33 + v_[282] * v_[163] * 0.35 + v_[282] * 0.08 + v_[33] * v_[163] * 0.33 + v_[258] * v_[163] * 0.35 + v_[258] * 0.08 + v_[539] * v_[163] * -0.33 + v_[486] * v_[97] * 0.33 + (v_[538] * v_[97] + v_[441] * v_[163]) * -0.33 + v_[451] * v_[97] * 0.33 + v_[511] * v_[97] * 0.35) * v_[367];
    v_[521] = 0 - jac[539];
    v_[522] = jac[515] * x_in[19] + v_[521] * x_in[18];
    v_[527] = v_[522] * v_[95];
    v_[496] = 0 - v_[522];
    v_[124] = v_[496] * v_[165];
    v_[507] = 0 - v_[522];
    jac[443] = v_[521] * v_[89] + jac[563] * v_[241];
    v_[521] = jac[563] * x_in[29];
    v_[570] = v_[521] * v_[165];
    v_[492] = jac[563] * x_in[28];
    v_[540] = v_[492] * v_[95];
    v_[41] = v_[521] * v_[95];
    v_[514] = v_[492] * v_[165];
    v_[52] = jac[539] * x_in[27];
    v_[37] = v_[52] * v_[95];
    v_[36] = v_[52] * v_[165];
    v_[28] = 0 - jac[515];
    jac[491] = v_[28] * v_[241] + jac[539] * v_[244];
    v_[28] = v_[28] * x_in[20] + jac[563] * x_in[18];
    v_[241] = v_[28] * v_[95];
    v_[26] = v_[28] * v_[165];
    v_[7] = jac[563] * x_in[27];
    v_[3] = v_[7] * v_[165];
    v_[600] = jac[539] * x_in[29];
    v_[599] = v_[600] * v_[95];
    v_[611] = 0 - v_[600];
    v_[40] = v_[611] * v_[165];
    v_[618] = v_[7] * v_[95];
    v_[623] = jac[539] * x_in[28];
    v_[627] = v_[623] * v_[95];
    v_[34] = 0 - v_[623];
    v_[630] = v_[34] * v_[165];
    v_[574] = 0 - v_[623];
    jac[227] = 0 - (v_[527] * v_[97] * 0.33 + v_[124] * v_[163] * 0.33 + v_[507] * v_[163] * 0.35 + (0 - v_[522]) * 0.08 + v_[570] * v_[97] * 0.33 + v_[540] * v_[163] * 0.33 + (v_[41] * v_[163] + v_[514] * v_[97]) * 0.33 + v_[492] * v_[97] * 0.35 + v_[37] * v_[97] * -0.33 + v_[36] * v_[163] * 0.33 + v_[52] * v_[163] * 0.35 + v_[52] * 0.08) * v_[379] + (v_[241] * v_[97] * -0.33 + v_[26] * v_[163] * 0.33 + v_[28] * v_[163] * 0.35 + v_[28] * 0.08 + v_[3] * v_[163] * 0.33 + v_[7] * v_[163] * 0.35 + v_[7] * 0.08 + v_[599] * v_[163] * -0.33 + v_[40] * v_[97] * 0.33 + (v_[618] * v_[97] + v_[627] * v_[163]) * -0.33 + v_[630] * v_[97] * 0.33 + v_[574] * v_[97] * 0.35) * v_[367];
    v_[191] = 1 - v_[180] - v_[191];
    v_[180] = sin(x_in[10]);
    v_[367] = 0 - v_[191];
    v_[379] = cos(x_in[10]);
    jac[246] = 0 - (v_[87] * v_[162] + v_[0] * v_[166] + v_[361] * v_[182] + v_[173] * v_[186] + v_[191] * v_[95] * -0.33) * v_[180] + (v_[354] * v_[142] + v_[358] * v_[184] + v_[367] * v_[165] * 0.33 + (0 - v_[191]) * 0.35) * v_[379];
    v_[316] = v_[245] + v_[316];
    v_[245] = 0 - v_[316];
    jac[247] = 0 - (v_[326] * v_[162] + v_[130] * v_[166] + v_[129] * v_[182] + v_[197] * v_[186] + v_[316] * v_[95] * -0.33) * v_[180] + (v_[336] * v_[142] + v_[179] * v_[184] + v_[245] * v_[165] * 0.33 + (0 - v_[316]) * 0.35) * v_[379];
    v_[634] = v_[23] - v_[634];
    v_[23] = 0 - v_[634];
    jac[248] = 0 - (v_[126] * v_[162] + v_[118] * v_[166] + v_[114] * v_[182] + v_[198] * v_[186] + v_[634] * v_[95] * -0.33) * v_[180] + (v_[190] * v_[142] + v_[370] * v_[184] + v_[23] * v_[165] * 0.33 + (0 - v_[634]) * 0.35) * v_[379];
    v_[114] = 0 - jac[561];
    jac[465] = jac[513] * v_[89] + v_[114] * v_[244];
    v_[114] = jac[537] * x_in[20] + v_[114] * x_in[19];
    v_[370] = jac[513] * x_in[29];
    v_[118] = 0 - v_[370];
    v_[126] = jac[513] * x_in[28];
    v_[190] = 0 - v_[126];
    v_[186] = 0 - v_[114];
    jac[249] = 0 - (v_[86] * v_[276] + v_[85] * v_[278] + v_[475] * v_[236] + v_[48] * v_[240] + v_[114] * v_[95] * -0.33 + v_[76] * v_[168] + v_[80] * v_[226] + v_[410] * v_[230] + v_[440] * v_[234] + v_[470] * v_[259] + v_[101] * v_[232] + v_[14] * v_[268] + v_[70] * v_[272] + v_[118] * v_[165] * 0.33 + v_[190] * v_[165] * 0.33 + (0 - v_[126]) * 0.35) * v_[180] + (v_[105] * v_[274] + v_[405] * v_[238] + v_[186] * v_[165] * 0.33 + (0 - v_[114]) * 0.35 + v_[82] * v_[176] + v_[74] * v_[168] + v_[107] * v_[228] + v_[459] * v_[232] + v_[452] * v_[261] + v_[146] * v_[265] + v_[116] * v_[181] + v_[68] * v_[270] + v_[370] * v_[95] * 0.33 + v_[126] * v_[95] * 0.33) * v_[379];
    v_[116] = 0 - jac[562];
    jac[466] = jac[514] * v_[89] + v_[116] * v_[244];
    v_[116] = jac[538] * x_in[20] + v_[116] * x_in[19];
    v_[146] = jac[514] * x_in[29];
    v_[101] = 0 - v_[146];
    v_[459] = jac[514] * x_in[28];
    v_[452] = 0 - v_[459];
    v_[470] = 0 - v_[116];
    jac[250] = 0 - (v_[128] * v_[276] + v_[508] * v_[278] + v_[294] * v_[236] + v_[282] * v_[240] + v_[116] * v_[95] * -0.33 + v_[267] * v_[168] + v_[290] * v_[226] + v_[33] * v_[230] + v_[258] * v_[234] + v_[539] * v_[259] + v_[441] * v_[232] + v_[305] * v_[268] + v_[273] * v_[272] + v_[101] * v_[165] * 0.33 + v_[452] * v_[165] * 0.33 + (0 - v_[459]) * 0.35) * v_[180] + (v_[257] * v_[274] + v_[293] * v_[238] + v_[470] * v_[165] * 0.33 + (0 - v_[116]) * 0.35 + v_[263] * v_[176] + v_[229] * v_[168] + v_[174] * v_[228] + v_[538] * v_[232] + v_[486] * v_[261] + v_[451] * v_[265] + v_[511] * v_[181] + v_[235] * v_[270] + v_[146] * v_[95] * 0.33 + v_[459] * v_[95] * 0.33) * v_[379];
    v_[511] = 0 - jac[563];
    jac[467] = jac[515] * v_[89] + v_[511] * v_[244];
    v_[511] = jac[539] * x_in[20] + v_[511] * x_in[19];
    v_[89] = jac[515] * x_in[29];
    v_[244] = 0 - v_[89];
    v_[451] = jac[515] * x_in[28];
    v_[441] = 0 - v_[451];
    v_[538] = 0 - v_[511];
    jac[251] = 0 - (v_[124] * v_[276] + v_[507] * v_[278] + v_[26] * v_[236] + v_[28] * v_[240] + v_[511] * v_[95] * -0.33 + v_[41] * v_[168] + v_[540] * v_[226] + v_[3] * v_[230] + v_[7] * v_[234] + v_[599] * v_[259] + v_[627] * v_[232] + v_[36] * v_[268] + v_[52] * v_[272] + v_[244] * v_[165] * 0.33 + v_[441] * v_[165] * 0.33 + (0 - v_[451]) * 0.35) * v_[180] + (v_[527] * v_[274] + v_[241] * v_[238] + v_[538] * v_[165] * 0.33 + (0 - v_[511]) * 0.35 + v_[570] * v_[176] + v_[514] * v_[168] + v_[492] * v_[228] + v_[618] * v_[232] + v_[40] * v_[261] + v_[630] * v_[265] + v_[574] * v_[181] + v_[37] * v_[270] + v_[89] * v_[95] * 0.33 + v_[451] * v_[95] * 0.33) * v_[379];
    v_[379] = sin(x_in[11]);
    v_[180] = cos(x_in[11]);
    jac[270] = 0 - (v_[382] * v_[164] + v_[173] * v_[183] + v_[367] * v_[194]) * v_[379] + (v_[444] * v_[92] + v_[173] * v_[185] + v_[191] * v_[193]) * v_[180];
    jac[271] = 0 - (v_[380] * v_[164] + v_[197] * v_[183] + v_[245] * v_[194]) * v_[379] + (v_[369] * v_[92] + v_[197] * v_[185] + v_[316] * v_[193]) * v_[180];
    jac[272] = 0 - (v_[127] * v_[164] + v_[198] * v_[183] + v_[23] * v_[194]) * v_[379] + (v_[209] * v_[92] + v_[198] * v_[185] + v_[634] * v_[193]) * v_[180];
    jac[273] = 0 - (v_[103] * v_[277] + v_[48] * v_[237] + v_[186] * v_[243] + v_[283] * v_[171] + v_[107] * v_[225] + v_[440] * v_[231] + v_[251] * v_[262] + v_[123] * v_[266] + v_[70] * v_[269] + v_[118] * v_[286] + v_[190] * v_[289]) * v_[379] + (v_[109] * v_[275] + v_[48] * v_[239] + v_[114] * v_[242] + v_[283] * v_[205] + v_[107] * v_[227] + v_[440] * v_[233] + v_[471] * v_[260] + v_[467] * v_[264] + v_[70] * v_[271] + v_[370] * v_[285] + v_[126] * v_[288]) * v_[180];
    jac[274] = 0 - (v_[17] * v_[277] + v_[282] * v_[237] + v_[470] * v_[243] + v_[287] * v_[171] + v_[174] * v_[225] + v_[258] * v_[231] + v_[626] * v_[262] + v_[477] * v_[266] + v_[273] * v_[269] + v_[101] * v_[286] + v_[452] * v_[289]) * v_[379] + (v_[112] * v_[275] + v_[282] * v_[239] + v_[116] * v_[242] + v_[287] * v_[205] + v_[174] * v_[227] + v_[258] * v_[233] + v_[542] * v_[260] + v_[415] * v_[264] + v_[273] * v_[271] + v_[146] * v_[285] + v_[459] * v_[288]) * v_[180];
    jac[275] = 0 - (v_[496] * v_[277] + v_[28] * v_[237] + v_[538] * v_[243] + v_[521] * v_[171] + v_[492] * v_[225] + v_[7] * v_[231] + v_[611] * v_[262] + v_[34] * v_[266] + v_[52] * v_[269] + v_[244] * v_[286] + v_[441] * v_[289]) * v_[379] + (v_[522] * v_[275] + v_[28] * v_[239] + v_[511] * v_[242] + v_[521] * v_[205] + v_[492] * v_[227] + v_[7] * v_[233] + v_[600] * v_[260] + v_[623] * v_[264] + v_[52] * v_[271] + v_[89] * v_[285] + v_[451] * v_[288]) * v_[180];
    v_[180] = v_[339] * v_[356];
    v_[379] = v_[350] * v_[357];
    v_[538] = v_[180] + v_[379];
    v_[441] = v_[538] * v_[252];
    v_[451] = 0 - v_[538];
    v_[244] = v_[451] * v_[324];
    v_[89] = 0 - v_[538];
    v_[511] = sin(x_in[12]);
    v_[34] = v_[350] * v_[356];
    v_[623] = v_[339] * v_[357];
    v_[611] = v_[34] - v_[623];
    v_[600] = v_[611] * v_[252];
    v_[7] = 0 - v_[611];
    v_[28] = v_[7] * v_[324];
    v_[52] = 0 - v_[611];
    v_[492] = cos(x_in[12]);
    jac[300] = 0 - (v_[441] * v_[254] * 0.33 + v_[244] * v_[322] * 0.33 + v_[89] * v_[322] * 0.35 + (0 - v_[538]) * 0.08) * v_[511] + (v_[600] * v_[254] * 0.33 + v_[28] * v_[322] * 0.33 + v_[52] * v_[322] * 0.35 + (0 - v_[611]) * 0.08) * v_[492];
    v_[521] = v_[339] * v_[349];
    v_[357] = v_[368] * v_[357];
    v_[496] = v_[521] - v_[357];
    v_[522] = v_[496] * v_[252];
    v_[289] = 0 - v_[496];
    v_[288] = v_[289] * v_[324];
    v_[286] = 0 - v_[496];
    v_[339] = v_[339] * v_[338];
    v_[368] = v_[368] * v_[356];
    v_[356] = 1 - v_[339] - v_[368];
    v_[338] = v_[356] * v_[252];
    v_[285] = 0 - v_[356];
    v_[277] = v_[285] * v_[324];
    v_[275] = 0 - v_[356];
    jac[301] = 0 - (v_[522] * v_[254] * 0.33 + v_[288] * v_[322] * 0.33 + v_[286] * v_[322] * 0.35 + (0 - v_[496]) * 0.08) * v_[511] + (v_[338] * v_[254] * 0.33 + v_[277] * v_[322] * 0.33 + v_[275] * v_[322] * 0.35 + (0 - v_[356]) * 0.08) * v_[492];
    v_[350] = v_[350] * v_[349];
    v_[368] = 1 - v_[350] - v_[368];
    v_[349] = v_[368] * v_[252];
    v_[271] = 0 - v_[368];
    v_[269] = v_[271] * v_[324];
    v_[266] = 0 - v_[368];
    v_[357] = v_[521] + v_[357];
    v_[521] = v_[357] * v_[252];
    v_[264] = 0 - v_[357];
    v_[262] = v_[264] * v_[324];
    v_[260] = 0 - v_[357];
    jac[302] = 0 - (v_[349] * v_[254] * 0.33 + v_[269] * v_[322] * 0.33 + v_[266] * v_[322] * 0.35 + (0 - v_[368]) * 0.08) * v_[511] + (v_[521] * v_[254] * 0.33 + v_[262] * v_[322] * 0.33 + v_[260] * v_[322] * 0.35 + (0 - v_[357]) * 0.08) * v_[492];
    v_[417] = v_[418] * v_[417];
    v_[243] = v_[443] * v_[442];
    jac[519] = 1 - v_[417] - v_[243];
    v_[242] = v_[443] * v_[453];
    v_[239] = v_[418] * v_[454];
    jac[543] = v_[242] - v_[239];
    jac[520] = v_[242] + v_[239];
    v_[239] = 0 - jac[543];
    v_[242] = jac[519] * x_in[19] + v_[239] * x_in[18];
    v_[237] = v_[242] * v_[397];
    v_[233] = 0 - v_[242];
    v_[231] = v_[233] * v_[324];
    v_[227] = 0 - v_[242];
    v_[225] = v_[418] * v_[453];
    v_[443] = v_[443] * v_[454];
    jac[567] = v_[225] + v_[443];
    jac[447] = v_[239] * v_[246] + jac[567] * v_[401];
    jac[521] = v_[225] - v_[443];
    jac[735] = jac[567] * v_[394] + jac[543] * v_[433];
    jac[759] = jac[567] * v_[388] + jac[543] * v_[427] + jac[519] * v_[450];
    jac[783] = jac[567] * v_[333] + jac[543] * v_[423] + jac[519] * v_[447];
    v_[443] = jac[567] * x_in[32];
    v_[225] = v_[443] * v_[324];
    v_[239] = jac[567] * x_in[31];
    v_[171] = v_[239] * v_[252];
    v_[205] = v_[443] * v_[252];
    v_[470] = v_[239] * v_[324];
    v_[452] = jac[543] * x_in[30];
    v_[459] = v_[452] * v_[252];
    v_[101] = 0 - v_[452];
    v_[146] = v_[101] * v_[324];
    v_[116] = 0 - v_[452];
    v_[477] = 0 - jac[519];
    jac[495] = v_[477] * v_[401] + jac[543] * v_[404];
    v_[477] = v_[477] * x_in[20] + jac[567] * x_in[18];
    v_[415] = v_[477] * v_[397];
    v_[626] = 0 - v_[477];
    v_[542] = v_[626] * v_[324];
    v_[258] = 0 - v_[477];
    v_[282] = jac[567] * x_in[30];
    v_[273] = v_[282] * v_[252];
    v_[174] = v_[282] * v_[324];
    v_[287] = jac[543] * x_in[32];
    v_[17] = v_[287] * v_[324];
    v_[112] = jac[543] * x_in[31];
    v_[186] = v_[112] * v_[252];
    v_[190] = v_[287] * v_[252];
    v_[126] = v_[112] * v_[324];
    jac[303] = 0 - (v_[237] * v_[254] * 0.33 + v_[231] * v_[322] * 0.33 + v_[227] * v_[322] * 0.35 + (0 - v_[242]) * 0.08 + v_[225] * v_[254] * 0.33 + v_[171] * v_[322] * 0.33 + (v_[205] * v_[322] + v_[470] * v_[254]) * 0.33 + v_[239] * v_[254] * 0.35 + v_[459] * v_[254] * 0.33 + v_[146] * v_[322] * 0.33 + v_[116] * v_[322] * 0.35 + (0 - v_[452]) * 0.08) * v_[511] + (v_[415] * v_[254] * 0.33 + v_[542] * v_[322] * 0.33 + v_[258] * v_[322] * 0.35 + (0 - v_[477]) * 0.08 + v_[273] * v_[254] * -0.33 + v_[174] * v_[322] * 0.33 + v_[282] * v_[322] * 0.35 + v_[282] * 0.08 + v_[17] * v_[254] * 0.33 + v_[186] * v_[322] * 0.33 + (v_[190] * v_[322] + v_[126] * v_[254]) * 0.33 + v_[112] * v_[254] * 0.35) * v_[492];
    v_[453] = v_[465] * v_[453];
    jac[544] = 1 - v_[417] - v_[453];
    jac[569] = 1 - v_[243] - v_[453];
    v_[453] = 0 - jac[544];
    v_[243] = jac[520] * x_in[19] + v_[453] * x_in[18];
    v_[417] = v_[243] * v_[397];
    v_[118] = 0 - v_[243];
    v_[370] = v_[118] * v_[324];
    v_[114] = 0 - v_[243];
    v_[442] = v_[418] * v_[442];
    v_[465] = v_[465] * v_[454];
    jac[568] = v_[442] - v_[465];
    jac[448] = v_[453] * v_[246] + jac[568] * v_[401];
    jac[545] = v_[442] + v_[465];
    jac[736] = jac[568] * v_[394] + jac[544] * v_[433];
    jac[737] = jac[569] * v_[394] + jac[545] * v_[433];
    jac[760] = jac[568] * v_[388] + jac[544] * v_[427] + jac[520] * v_[450];
    jac[761] = jac[569] * v_[388] + jac[545] * v_[427] + jac[521] * v_[450];
    jac[784] = jac[568] * v_[333] + jac[544] * v_[423] + jac[520] * v_[447];
    jac[785] = jac[569] * v_[333] + jac[545] * v_[423] + jac[521] * v_[447];
    v_[447] = jac[568] * x_in[32];
    v_[423] = v_[447] * v_[324];
    v_[333] = jac[568] * x_in[31];
    v_[450] = v_[333] * v_[252];
    v_[427] = v_[447] * v_[252];
    v_[388] = v_[333] * v_[324];
    v_[433] = jac[544] * x_in[30];
    v_[394] = v_[433] * v_[252];
    v_[465] = 0 - v_[433];
    v_[442] = v_[465] * v_[324];
    v_[453] = 0 - v_[433];
    v_[454] = 0 - jac[520];
    jac[496] = v_[454] * v_[401] + jac[544] * v_[404];
    v_[454] = v_[454] * x_in[20] + jac[568] * x_in[18];
    v_[418] = v_[454] * v_[397];
    v_[123] = 0 - v_[454];
    v_[467] = v_[123] * v_[324];
    v_[251] = 0 - v_[454];
    v_[471] = jac[568] * x_in[30];
    v_[440] = v_[471] * v_[252];
    v_[48] = v_[471] * v_[324];
    v_[70] = jac[544] * x_in[32];
    v_[107] = v_[70] * v_[324];
    v_[283] = jac[544] * x_in[31];
    v_[103] = v_[283] * v_[252];
    v_[109] = v_[70] * v_[252];
    v_[23] = v_[283] * v_[324];
    jac[304] = 0 - (v_[417] * v_[254] * 0.33 + v_[370] * v_[322] * 0.33 + v_[114] * v_[322] * 0.35 + (0 - v_[243]) * 0.08 + v_[423] * v_[254] * 0.33 + v_[450] * v_[322] * 0.33 + (v_[427] * v_[322] + v_[388] * v_[254]) * 0.33 + v_[333] * v_[254] * 0.35 + v_[394] * v_[254] * 0.33 + v_[442] * v_[322] * 0.33 + v_[453] * v_[322] * 0.35 + (0 - v_[433]) * 0.08) * v_[511] + (v_[418] * v_[254] * 0.33 + v_[467] * v_[322] * 0.33 + v_[251] * v_[322] * 0.35 + (0 - v_[454]) * 0.08 + v_[440] * v_[254] * -0.33 + v_[48] * v_[322] * 0.33 + v_[471] * v_[322] * 0.35 + v_[471] * 0.08 + v_[107] * v_[254] * 0.33 + v_[103] * v_[322] * 0.33 + (v_[109] * v_[322] + v_[23] * v_[254]) * 0.33 + v_[283] * v_[254] * 0.35) * v_[492];
    v_[634] = 0 - jac[545];
    v_[198] = jac[521] * x_in[19] + v_[634] * x_in[18];
    v_[127] = v_[198] * v_[397];
    v_[209] = 0 - v_[198];
    v_[194] = v_[209] * v_[324];
    v_[193] = 0 - v_[198];
    jac[449] = v_[634] * v_[246] + jac[569] * v_[401];
    v_[634] = jac[569] * x_in[32];
    v_[185] = v_[634] * v_[324];
    v_[183] = jac[569] * x_in[31];
    v_[164] = v_[183] * v_[252];
    v_[92] = v_[634] * v_[252];
    v_[245] = v_[183] * v_[324];
    v_[316] = jac[545] * x_in[30];
    v_[197] = v_[316] * v_[252];
    v_[380] = 0 - v_[316];
    v_[369] = v_[380] * v_[324];
    v_[367] = 0 - v_[316];
    v_[191] = 0 - jac[521];
    jac[497] = v_[191] * v_[401] + jac[545] * v_[404];
    v_[191] = v_[191] * x_in[20] + jac[569] * x_in[18];
    v_[401] = v_[191] * v_[397];
    v_[173] = 0 - v_[191];
    v_[382] = v_[173] * v_[324];
    v_[444] = 0 - v_[191];
    v_[574] = jac[569] * x_in[30];
    v_[630] = v_[574] * v_[252];
    v_[627] = v_[574] * v_[324];
    v_[618] = jac[545] * x_in[32];
    v_[40] = v_[618] * v_[324];
    v_[599] = jac[545] * x_in[31];
    v_[3] = v_[599] * v_[252];
    v_[26] = v_[618] * v_[252];
    v_[241] = v_[599] * v_[324];
    jac[305] = 0 - (v_[127] * v_[254] * 0.33 + v_[194] * v_[322] * 0.33 + v_[193] * v_[322] * 0.35 + (0 - v_[198]) * 0.08 + v_[185] * v_[254] * 0.33 + v_[164] * v_[322] * 0.33 + (v_[92] * v_[322] + v_[245] * v_[254]) * 0.33 + v_[183] * v_[254] * 0.35 + v_[197] * v_[254] * 0.33 + v_[369] * v_[322] * 0.33 + v_[367] * v_[322] * 0.35 + (0 - v_[316]) * 0.08) * v_[511] + (v_[401] * v_[254] * 0.33 + v_[382] * v_[322] * 0.33 + v_[444] * v_[322] * 0.35 + (0 - v_[191]) * 0.08 + v_[630] * v_[254] * -0.33 + v_[627] * v_[322] * 0.33 + v_[574] * v_[322] * 0.35 + v_[574] * 0.08 + v_[40] * v_[254] * 0.33 + v_[3] * v_[322] * 0.33 + (v_[26] * v_[322] + v_[241] * v_[254]) * 0.33 + v_[599] * v_[254] * 0.35) * v_[492];
    v_[350] = 1 - v_[339] - v_[350];
    v_[339] = sin(x_in[13]);
    v_[492] = 0 - v_[350];
    v_[511] = cos(x_in[13]);
    jac[324] = 0 - (v_[244] * v_[321] + v_[89] * v_[325] + v_[28] * v_[343] + v_[52] * v_[345] + v_[350] * v_[252] * -0.33) * v_[339] + (v_[441] * v_[301] + v_[600] * v_[341] + v_[492] * v_[324] * 0.33 + (0 - v_[350]) * 0.35) * v_[511];
    v_[623] = v_[34] + v_[623];
    v_[34] = 0 - v_[623];
    jac[325] = 0 - (v_[288] * v_[321] + v_[286] * v_[325] + v_[277] * v_[343] + v_[275] * v_[345] + v_[623] * v_[252] * -0.33) * v_[339] + (v_[522] * v_[301] + v_[338] * v_[341] + v_[34] * v_[324] * 0.33 + (0 - v_[623]) * 0.35) * v_[511];
    v_[379] = v_[180] - v_[379];
    v_[180] = 0 - v_[379];
    jac[326] = 0 - (v_[269] * v_[321] + v_[266] * v_[325] + v_[262] * v_[343] + v_[260] * v_[345] + v_[379] * v_[252] * -0.33) * v_[339] + (v_[349] * v_[301] + v_[521] * v_[341] + v_[180] * v_[324] * 0.33 + (0 - v_[379]) * 0.35) * v_[511];
    v_[260] = 0 - jac[567];
    jac[471] = jac[519] * v_[246] + v_[260] * v_[404];
    v_[260] = jac[543] * x_in[20] + v_[260] * x_in[19];
    v_[262] = jac[519] * x_in[32];
    v_[521] = 0 - v_[262];
    v_[266] = jac[519] * x_in[31];
    v_[269] = 0 - v_[266];
    v_[349] = 0 - v_[260];
    jac[327] = 0 - (v_[231] * v_[436] + v_[227] * v_[438] + v_[542] * v_[398] + v_[258] * v_[400] + v_[260] * v_[397] * -0.33 + v_[205] * v_[327] + v_[171] * v_[385] + v_[174] * v_[389] + v_[282] * v_[393] + v_[190] * v_[419] + v_[186] * v_[425] + v_[146] * v_[430] + v_[116] * v_[432] + v_[521] * v_[324] * 0.33 + v_[269] * v_[324] * 0.33 + (0 - v_[266]) * 0.35) * v_[339] + (v_[237] * v_[434] + v_[415] * v_[395] + v_[349] * v_[324] * 0.33 + (0 - v_[260]) * 0.35 + v_[225] * v_[335] + v_[470] * v_[327] + v_[239] * v_[387] + v_[273] * v_[391] + v_[17] * v_[421] + v_[126] * v_[419] + v_[112] * v_[340] + v_[459] * v_[428] + v_[262] * v_[252] * 0.33 + v_[266] * v_[252] * 0.33) * v_[511];
    v_[126] = 0 - jac[568];
    jac[472] = jac[520] * v_[246] + v_[126] * v_[404];
    v_[126] = jac[544] * x_in[20] + v_[126] * x_in[19];
    v_[190] = jac[520] * x_in[32];
    v_[186] = 0 - v_[190];
    v_[17] = jac[520] * x_in[31];
    v_[174] = 0 - v_[17];
    v_[273] = 0 - v_[126];
    jac[328] = 0 - (v_[370] * v_[436] + v_[114] * v_[438] + v_[467] * v_[398] + v_[251] * v_[400] + v_[126] * v_[397] * -0.33 + v_[427] * v_[327] + v_[450] * v_[385] + v_[48] * v_[389] + v_[471] * v_[393] + v_[109] * v_[419] + v_[103] * v_[425] + v_[442] * v_[430] + v_[453] * v_[432] + v_[186] * v_[324] * 0.33 + v_[174] * v_[324] * 0.33 + (0 - v_[17]) * 0.35) * v_[339] + (v_[417] * v_[434] + v_[418] * v_[395] + v_[273] * v_[324] * 0.33 + (0 - v_[126]) * 0.35 + v_[423] * v_[335] + v_[388] * v_[327] + v_[333] * v_[387] + v_[440] * v_[391] + v_[107] * v_[421] + v_[23] * v_[419] + v_[283] * v_[340] + v_[394] * v_[428] + v_[190] * v_[252] * 0.33 + v_[17] * v_[252] * 0.33) * v_[511];
    v_[23] = 0 - jac[569];
    jac[473] = jac[521] * v_[246] + v_[23] * v_[404];
    v_[23] = jac[545] * x_in[20] + v_[23] * x_in[19];
    v_[246] = jac[521] * x_in[32];
    v_[404] = 0 - v_[246];
    v_[109] = jac[521] * x_in[31];
    v_[103] = 0 - v_[109];
    v_[107] = 0 - v_[23];
    jac[329] = 0 - (v_[194] * v_[436] + v_[193] * v_[438] + v_[382] * v_[398] + v_[444] * v_[400] + v_[23] * v_[397] * -0.33 + v_[92] * v_[327] + v_[164] * v_[385] + v_[627] * v_[389] + v_[574] * v_[393] + v_[26] * v_[419] + v_[3] * v_[425] + v_[369] * v_[430] + v_[367] * v_[432] + v_[404] * v_[324] * 0.33 + v_[103] * v_[324] * 0.33 + (0 - v_[109]) * 0.35) * v_[339] + (v_[127] * v_[434] + v_[401] * v_[395] + v_[107] * v_[324] * 0.33 + (0 - v_[23]) * 0.35 + v_[185] * v_[335] + v_[245] * v_[327] + v_[183] * v_[387] + v_[630] * v_[391] + v_[40] * v_[421] + v_[241] * v_[419] + v_[599] * v_[340] + v_[197] * v_[428] + v_[246] * v_[252] * 0.33 + v_[109] * v_[252] * 0.33) * v_[511];
    v_[511] = sin(x_in[14]);
    v_[339] = cos(x_in[14]);
    jac[348] = 0 - (v_[451] * v_[323] + v_[7] * v_[344] + v_[492] * v_[353]) * v_[511] + (v_[538] * v_[249] + v_[611] * v_[342] + v_[350] * v_[352]) * v_[339];
    jac[349] = 0 - (v_[289] * v_[323] + v_[285] * v_[344] + v_[34] * v_[353]) * v_[511] + (v_[496] * v_[249] + v_[356] * v_[342] + v_[623] * v_[352]) * v_[339];
    jac[350] = 0 - (v_[271] * v_[323] + v_[264] * v_[344] + v_[180] * v_[353]) * v_[511] + (v_[368] * v_[249] + v_[357] * v_[342] + v_[379] * v_[352]) * v_[339];
    v_[180] = cos(x_in[14]);
    jac[351] = (v_[242] * v_[435] + v_[477] * v_[396] + v_[260] * v_[402]) * v_[180] - (v_[233] * v_[437] + v_[626] * v_[399] + v_[349] * v_[403] + v_[443] * v_[330] + v_[239] * v_[384] + v_[282] * v_[390] + v_[287] * v_[422] + v_[112] * v_[424] + v_[101] * v_[431] + v_[521] * v_[446] + v_[269] * v_[449]) * v_[511] + (v_[443] * v_[364] + v_[239] * v_[386] + v_[282] * v_[392] + v_[287] * v_[420] + v_[112] * v_[426] + v_[452] * v_[429] + v_[262] * v_[445] + v_[266] * v_[448]) * v_[339];
    jac[352] = (v_[243] * v_[435] + v_[454] * v_[396] + v_[126] * v_[402]) * v_[180] - (v_[118] * v_[437] + v_[123] * v_[399] + v_[273] * v_[403] + v_[447] * v_[330] + v_[333] * v_[384] + v_[471] * v_[390] + v_[70] * v_[422] + v_[283] * v_[424] + v_[465] * v_[431] + v_[186] * v_[446] + v_[174] * v_[449]) * v_[511] + (v_[447] * v_[364] + v_[333] * v_[386] + v_[471] * v_[392] + v_[70] * v_[420] + v_[283] * v_[426] + v_[433] * v_[429] + v_[190] * v_[445] + v_[17] * v_[448]) * v_[339];
    jac[353] = (v_[198] * v_[435] + v_[191] * v_[396] + v_[23] * v_[402]) * v_[180] - (v_[209] * v_[437] + v_[173] * v_[399] + v_[107] * v_[403] + v_[634] * v_[330] + v_[183] * v_[384] + v_[574] * v_[390] + v_[618] * v_[422] + v_[599] * v_[424] + v_[380] * v_[431] + v_[404] * v_[446] + v_[103] * v_[449]) * v_[511] + (v_[634] * v_[364] + v_[183] * v_[386] + v_[574] * v_[392] + v_[618] * v_[420] + v_[599] * v_[426] + v_[316] * v_[429] + v_[246] * v_[445] + v_[109] * v_[448]) * v_[339];
    v_[180] = v_[499] * v_[516];
    v_[339] = v_[510] * v_[517];
    v_[511] = v_[180] + v_[339];
    v_[107] = v_[511] * v_[412];
    v_[103] = 0 - v_[511];
    v_[109] = v_[103] * v_[484];
    v_[404] = 0 - v_[511];
    v_[246] = sin(x_in[15]);
    v_[23] = v_[510] * v_[516];
    v_[599] = v_[499] * v_[517];
    v_[618] = v_[23] - v_[599];
    v_[574] = v_[618] * v_[412];
    v_[173] = v_[618] * v_[484];
    v_[191] = cos(x_in[15]);
    jac[378] = 0 - (v_[107] * v_[414] * 0.33 + v_[109] * v_[482] * 0.33 + v_[404] * v_[482] * 0.35 + (0 - v_[511]) * 0.08) * v_[246] + (v_[574] * v_[414] * -0.33 + v_[173] * v_[482] * 0.33 + v_[618] * v_[482] * 0.35 + v_[618] * 0.08) * v_[191];
    v_[380] = v_[499] * v_[509];
    v_[517] = v_[528] * v_[517];
    v_[316] = v_[380] - v_[517];
    v_[183] = v_[316] * v_[412];
    v_[634] = 0 - v_[316];
    v_[209] = v_[634] * v_[484];
    v_[198] = 0 - v_[316];
    v_[499] = v_[499] * v_[498];
    v_[528] = v_[528] * v_[516];
    v_[516] = 1 - v_[499] - v_[528];
    v_[498] = v_[516] * v_[412];
    v_[449] = v_[516] * v_[484];
    jac[379] = 0 - (v_[183] * v_[414] * 0.33 + v_[209] * v_[482] * 0.33 + v_[198] * v_[482] * 0.35 + (0 - v_[316]) * 0.08) * v_[246] + (v_[498] * v_[414] * -0.33 + v_[449] * v_[482] * 0.33 + v_[516] * v_[482] * 0.35 + v_[516] * 0.08) * v_[191];
    v_[510] = v_[510] * v_[509];
    v_[528] = 1 - v_[510] - v_[528];
    v_[509] = v_[528] * v_[412];
    v_[448] = 0 - v_[528];
    v_[446] = v_[448] * v_[484];
    v_[445] = 0 - v_[528];
    v_[517] = v_[380] + v_[517];
    v_[380] = v_[517] * v_[412];
    v_[437] = v_[517] * v_[484];
    jac[380] = 0 - (v_[509] * v_[414] * 0.33 + v_[446] * v_[482] * 0.33 + v_[445] * v_[482] * 0.35 + (0 - v_[528]) * 0.08) * v_[246] + (v_[380] * v_[414] * -0.33 + v_[437] * v_[482] * 0.33 + v_[517] * v_[482] * 0.35 + v_[517] * 0.08) * v_[191];
    v_[576] = v_[577] * v_[576];
    v_[435] = v_[602] * v_[601];
    jac[525] = 1 - v_[576] - v_[435];
    v_[431] = v_[602] * v_[612];
    v_[429] = v_[577] * v_[613];
    jac[549] = v_[431] - v_[429];
    jac[526] = v_[431] + v_[429];
    v_[429] = 0 - jac[549];
    v_[431] = jac[525] * x_in[19] + v_[429] * x_in[18];
    v_[426] = v_[431] * v_[412];
    v_[424] = 0 - v_[431];
    v_[422] = v_[424] * v_[484];
    v_[420] = 0 - v_[431];
    v_[403] = v_[577] * v_[612];
    v_[602] = v_[602] * v_[613];
    jac[573] = v_[403] + v_[602];
    jac[453] = v_[429] * v_[406] + jac[573] * v_[560];
    jac[527] = v_[403] - v_[602];
    jac[813] = jac[573] * v_[554] + jac[549] * v_[592];
    jac[837] = jac[573] * v_[548] + jac[549] * v_[586] + jac[525] * v_[609];
    jac[861] = jac[573] * v_[493] + jac[549] * v_[582] + jac[525] * v_[606];
    v_[602] = jac[573] * x_in[35];
    v_[403] = v_[602] * v_[484];
    v_[429] = jac[573] * x_in[34];
    v_[402] = v_[429] * v_[412];
    v_[399] = v_[602] * v_[412];
    v_[396] = v_[429] * v_[484];
    v_[392] = jac[549] * x_in[33];
    v_[390] = v_[392] * v_[412];
    v_[386] = v_[392] * v_[484];
    v_[384] = 0 - jac[525];
    jac[501] = v_[384] * v_[560] + jac[549] * v_[563];
    v_[384] = v_[384] * x_in[20] + jac[573] * x_in[18];
    v_[330] = v_[384] * v_[412];
    v_[364] = v_[384] * v_[484];
    v_[273] = jac[573] * x_in[33];
    v_[174] = v_[273] * v_[484];
    v_[17] = jac[549] * x_in[35];
    v_[186] = v_[17] * v_[412];
    v_[190] = 0 - v_[17];
    v_[126] = v_[190] * v_[484];
    v_[283] = v_[273] * v_[412];
    v_[70] = jac[549] * x_in[34];
    v_[471] = v_[70] * v_[412];
    v_[123] = 0 - v_[70];
    v_[454] = v_[123] * v_[484];
    v_[465] = 0 - v_[70];
    jac[381] = 0 - (v_[426] * v_[414] * 0.33 + v_[422] * v_[482] * 0.33 + v_[420] * v_[482] * 0.35 + (0 - v_[431]) * 0.08 + v_[403] * v_[414] * 0.33 + v_[402] * v_[482] * 0.33 + (v_[399] * v_[482] + v_[396] * v_[414]) * 0.33 + v_[429] * v_[414] * 0.35 + v_[390] * v_[414] * -0.33 + v_[386] * v_[482] * 0.33 + v_[392] * v_[482] * 0.35 + v_[392] * 0.08) * v_[246] + (v_[330] * v_[414] * -0.33 + v_[364] * v_[482] * 0.33 + v_[384] * v_[482] * 0.35 + v_[384] * 0.08 + v_[174] * v_[482] * 0.33 + v_[273] * v_[482] * 0.35 + v_[273] * 0.08 + v_[186] * v_[482] * -0.33 + v_[126] * v_[414] * 0.33 + (v_[283] * v_[414] + v_[471] * v_[482]) * -0.33 + v_[454] * v_[414] * 0.33 + v_[465] * v_[414] * 0.35) * v_[191];
    v_[612] = v_[624] * v_[612];
    jac[550] = 1 - v_[576] - v_[612];
    jac[575] = 1 - v_[435] - v_[612];
    v_[612] = 0 - jac[550];
    v_[435] = jac[526] * x_in[19] + v_[612] * x_in[18];
    v_[576] = v_[435] * v_[412];
    v_[433] = 0 - v_[435];
    v_[333] = v_[433] * v_[484];
    v_[447] = 0 - v_[435];
    v_[601] = v_[577] * v_[601];
    v_[624] = v_[624] * v_[613];
    jac[574] = v_[601] - v_[624];
    jac[454] = v_[612] * v_[406] + jac[574] * v_[560];
    jac[551] = v_[601] + v_[624];
    jac[814] = jac[574] * v_[554] + jac[550] * v_[592];
    jac[815] = jac[575] * v_[554] + jac[551] * v_[592];
    jac[838] = jac[574] * v_[548] + jac[550] * v_[586] + jac[526] * v_[609];
    jac[839] = jac[575] * v_[548] + jac[551] * v_[586] + jac[527] * v_[609];
    jac[862] = jac[574] * v_[493] + jac[550] * v_[582] + jac[526] * v_[606];
    jac[863] = jac[575] * v_[493] + jac[551] * v_[582] + jac[527] * v_[606];
    v_[606] = jac[574] * x_in[35];
    v_[582] = v_[606] * v_[484];
    v_[493] = jac[574] * x_in[34];
    v_[609] = v_[493] * v_[412];
    v_[586] = v_[606] * v_[412];
    v_[548] = v_[493] * v_[484];
    v_[592] = jac[550] * x_in[33];
    v_[554] = v_[592] * v_[412];
    v_[624] = v_[592] * v_[484];
    v_[601] = 0 - jac[526];
    jac[502] = v_[601] * v_[560] + jac[550] * v_[563];
    v_[601] = v_[601] * x_in[20] + jac[574] * x_in[18];
    v_[612] = v_[601] * v_[412];
    v_[613] = v_[601] * v_[484];
    v_[577] = jac[574] * x_in[33];
    v_[118] = v_[577] * v_[484];
    v_[243] = jac[550] * x_in[35];
    v_[349] = v_[243] * v_[412];
    v_[269] = 0 - v_[243];
    v_[266] = v_[269] * v_[484];
    v_[521] = v_[577] * v_[412];
    v_[262] = jac[550] * x_in[34];
    v_[260] = v_[262] * v_[412];
    v_[112] = 0 - v_[262];
    v_[287] = v_[112] * v_[484];
    v_[282] = 0 - v_[262];
    jac[382] = 0 - (v_[576] * v_[414] * 0.33 + v_[333] * v_[482] * 0.33 + v_[447] * v_[482] * 0.35 + (0 - v_[435]) * 0.08 + v_[582] * v_[414] * 0.33 + v_[609] * v_[482] * 0.33 + (v_[586] * v_[482] + v_[548] * v_[414]) * 0.33 + v_[493] * v_[414] * 0.35 + v_[554] * v_[414] * -0.33 + v_[624] * v_[482] * 0.33 + v_[592] * v_[482] * 0.35 + v_[592] * 0.08) * v_[246] + (v_[612] * v_[414] * -0.33 + v_[613] * v_[482] * 0.33 + v_[601] * v_[482] * 0.35 + v_[601] * 0.08 + v_[118] * v_[482] * 0.33 + v_[577] * v_[482] * 0.35 + v_[577] * 0.08 + v_[349] * v_[482] * -0.33 + v_[266] * v_[414] * 0.33 + (v_[521] * v_[414] + v_[260] * v_[482]) * -0.33 + v_[287] * v_[414] * 0.33 + v_[282] * v_[414] * 0.35) * v_[191];
    v_[626] = 0 - jac[551];
    v_[477] = jac[527] * x_in[19] + v_[626] * x_in[18];
    v_[101] = v_[477] * v_[412];
    v_[452] = 0 - v_[477];
    v_[239] = v_[452] * v_[484];
    v_[443] = 0 - v_[477];
    jac[455] = v_[626] * v_[406] + jac[575] * v_[560];
    v_[626] = jac[575] * x_in[35];
    v_[233] = v_[626] * v_[484];
    v_[242] = jac[575] * x_in[34];
    v_[379] = v_[242] * v_[412];
    v_[264] = v_[626] * v_[412];
    v_[357] = v_[242] * v_[484];
    v_[271] = jac[551] * x_in[33];
    v_[368] = v_[271] * v_[412];
    v_[353] = v_[271] * v_[484];
    v_[352] = 0 - jac[527];
    jac[503] = v_[352] * v_[560] + jac[551] * v_[563];
    v_[352] = v_[352] * x_in[20] + jac[575] * x_in[18];
    v_[560] = v_[352] * v_[412];
    v_[344] = v_[352] * v_[484];
    v_[342] = jac[575] * x_in[33];
    v_[323] = v_[342] * v_[484];
    v_[249] = jac[551] * x_in[35];
    v_[34] = v_[249] * v_[412];
    v_[623] = 0 - v_[249];
    v_[285] = v_[623] * v_[484];
    v_[356] = v_[342] * v_[412];
    v_[289] = jac[551] * x_in[34];
    v_[496] = v_[289] * v_[412];
    v_[492] = 0 - v_[289];
    v_[350] = v_[492] * v_[484];
    v_[7] = 0 - v_[289];
    jac[383] = 0 - (v_[101] * v_[414] * 0.33 + v_[239] * v_[482] * 0.33 + v_[443] * v_[482] * 0.35 + (0 - v_[477]) * 0.08 + v_[233] * v_[414] * 0.33 + v_[379] * v_[482] * 0.33 + (v_[264] * v_[482] + v_[357] * v_[414]) * 0.33 + v_[242] * v_[414] * 0.35 + v_[368] * v_[414] * -0.33 + v_[353] * v_[482] * 0.33 + v_[271] * v_[482] * 0.35 + v_[271] * 0.08) * v_[246] + (v_[560] * v_[414] * -0.33 + v_[344] * v_[482] * 0.33 + v_[352] * v_[482] * 0.35 + v_[352] * 0.08 + v_[323] * v_[482] * 0.33 + v_[342] * v_[482] * 0.35 + v_[342] * 0.08 + v_[34] * v_[482] * -0.33 + v_[285] * v_[414] * 0.33 + (v_[356] * v_[414] + v_[496] * v_[482]) * -0.33 + v_[350] * v_[414] * 0.33 + v_[7] * v_[414] * 0.35) * v_[191];
    v_[510] = 1 - v_[499] - v_[510];
    v_[499] = sin(x_in[16]);
    v_[191] = 0 - v_[510];
    v_[246] = cos(x_in[16]);
    jac[402] = 0 - (v_[109] * v_[481] + v_[404] * v_[485] + v_[173] * v_[501] + v_[618] * v_[505] + v_[510] * v_[412] * -0.33) * v_[499] + (v_[107] * v_[461] + v_[574] * v_[503] + v_[191] * v_[484] * 0.33 + (0 - v_[510]) * 0.35) * v_[246];
    v_[599] = v_[23] + v_[599];
    v_[23] = 0 - v_[599];
    jac[403] = 0 - (v_[209] * v_[481] + v_[198] * v_[485] + v_[449] * v_[501] + v_[516] * v_[505] + v_[599] * v_[412] * -0.33) * v_[499] + (v_[183] * v_[461] + v_[498] * v_[503] + v_[23] * v_[484] * 0.33 + (0 - v_[599]) * 0.35) * v_[246];
    v_[339] = v_[180] - v_[339];
    v_[180] = 0 - v_[339];
    jac[404] = 0 - (v_[446] * v_[481] + v_[445] * v_[485] + v_[437] * v_[501] + v_[517] * v_[505] + v_[339] * v_[412] * -0.33) * v_[499] + (v_[509] * v_[461] + v_[380] * v_[503] + v_[180] * v_[484] * 0.33 + (0 - v_[339]) * 0.35) * v_[246];
    v_[437] = 0 - jac[573];
    jac[477] = jac[525] * v_[406] + v_[437] * v_[563];
    v_[437] = jac[549] * x_in[20] + v_[437] * x_in[19];
    v_[380] = jac[525] * x_in[35];
    v_[445] = 0 - v_[380];
    v_[446] = jac[525] * x_in[34];
    v_[509] = 0 - v_[446];
    v_[505] = 0 - v_[437];
    jac[405] = 0 - (v_[422] * v_[595] + v_[420] * v_[597] + v_[364] * v_[555] + v_[384] * v_[559] + v_[437] * v_[412] * -0.33 + v_[399] * v_[487] + v_[402] * v_[545] + v_[174] * v_[549] + v_[273] * v_[553] + v_[186] * v_[578] + v_[471] * v_[551] + v_[386] * v_[587] + v_[392] * v_[591] + v_[445] * v_[484] * 0.33 + v_[509] * v_[484] * 0.33 + (0 - v_[446]) * 0.35) * v_[499] + (v_[426] * v_[593] + v_[330] * v_[557] + v_[505] * v_[484] * 0.33 + (0 - v_[437]) * 0.35 + v_[403] * v_[495] + v_[396] * v_[487] + v_[429] * v_[547] + v_[283] * v_[551] + v_[126] * v_[580] + v_[454] * v_[584] + v_[465] * v_[500] + v_[390] * v_[589] + v_[380] * v_[412] * 0.33 + v_[446] * v_[412] * 0.33) * v_[246];
    v_[465] = 0 - jac[574];
    jac[478] = jac[526] * v_[406] + v_[465] * v_[563];
    v_[465] = jac[550] * x_in[20] + v_[465] * x_in[19];
    v_[454] = jac[526] * x_in[35];
    v_[471] = 0 - v_[454];
    v_[283] = jac[526] * x_in[34];
    v_[126] = 0 - v_[283];
    v_[186] = 0 - v_[465];
    jac[406] = 0 - (v_[333] * v_[595] + v_[447] * v_[597] + v_[613] * v_[555] + v_[601] * v_[559] + v_[465] * v_[412] * -0.33 + v_[586] * v_[487] + v_[609] * v_[545] + v_[118] * v_[549] + v_[577] * v_[553] + v_[349] * v_[578] + v_[260] * v_[551] + v_[624] * v_[587] + v_[592] * v_[591] + v_[471] * v_[484] * 0.33 + v_[126] * v_[484] * 0.33 + (0 - v_[283]) * 0.35) * v_[499] + (v_[576] * v_[593] + v_[612] * v_[557] + v_[186] * v_[484] * 0.33 + (0 - v_[465]) * 0.35 + v_[582] * v_[495] + v_[548] * v_[487] + v_[493] * v_[547] + v_[521] * v_[551] + v_[266] * v_[580] + v_[287] * v_[584] + v_[282] * v_[500] + v_[554] * v_[589] + v_[454] * v_[412] * 0.33 + v_[283] * v_[412] * 0.33) * v_[246];
    v_[282] = 0 - jac[575];
    jac[479] = jac[527] * v_[406] + v_[282] * v_[563];
    v_[282] = jac[551] * x_in[20] + v_[282] * x_in[19];
    v_[406] = jac[527] * x_in[35];
    v_[563] = 0 - v_[406];
    v_[287] = jac[527] * x_in[34];
    v_[260] = 0 - v_[287];
    v_[521] = 0 - v_[282];
    jac[407] = 0 - (v_[239] * v_[595] + v_[443] * v_[597] + v_[344] * v_[555] + v_[352] * v_[559] + v_[282] * v_[412] * -0.33 + v_[264] * v_[487] + v_[379] * v_[545] + v_[323] * v_[549] + v_[342] * v_[553] + v_[34] * v_[578] + v_[496] * v_[551] + v_[353] * v_[587] + v_[271] * v_[591] + v_[563] * v_[484] * 0.33 + v_[260] * v_[484] * 0.33 + (0 - v_[287]) * 0.35) * v_[499] + (v_[101] * v_[593] + v_[560] * v_[557] + v_[521] * v_[484] * 0.33 + (0 - v_[282]) * 0.35 + v_[233] * v_[495] + v_[357] * v_[487] + v_[242] * v_[547] + v_[356] * v_[551] + v_[285] * v_[580] + v_[350] * v_[584] + v_[7] * v_[500] + v_[368] * v_[589] + v_[406] * v_[412] * 0.33 + v_[287] * v_[412] * 0.33) * v_[246];
    v_[246] = sin(x_in[17]);
    v_[499] = cos(x_in[17]);
    jac[426] = 0 - (v_[103] * v_[483] + v_[618] * v_[502] + v_[191] * v_[513]) * v_[246] + (v_[511] * v_[409] + v_[618] * v_[504] + v_[510] * v_[512]) * v_[499];
    jac[427] = 0 - (v_[634] * v_[483] + v_[516] * v_[502] + v_[23] * v_[513]) * v_[246] + (v_[316] * v_[409] + v_[516] * v_[504] + v_[599] * v_[512]) * v_[499];
    jac[428] = 0 - (v_[448] * v_[483] + v_[517] * v_[502] + v_[180] * v_[513]) * v_[246] + (v_[528] * v_[409] + v_[517] * v_[504] + v_[339] * v_[512]) * v_[499];
    jac[429] = 0 - (v_[424] * v_[596] + v_[384] * v_[556] + v_[505] * v_[562] + v_[602] * v_[490] + v_[429] * v_[544] + v_[273] * v_[550] + v_[190] * v_[581] + v_[123] * v_[585] + v_[392] * v_[588] + v_[445] * v_[605] + v_[509] * v_[608]) * v_[246] + (v_[431] * v_[594] + v_[384] * v_[558] + v_[437] * v_[561] + v_[602] * v_[524] + v_[429] * v_[546] + v_[273] * v_[552] + v_[17] * v_[579] + v_[70] * v_[583] + v_[392] * v_[590] + v_[380] * v_[604] + v_[446] * v_[607]) * v_[499];
    jac[430] = 0 - (v_[433] * v_[596] + v_[601] * v_[556] + v_[186] * v_[562] + v_[606] * v_[490] + v_[493] * v_[544] + v_[577] * v_[550] + v_[269] * v_[581] + v_[112] * v_[585] + v_[592] * v_[588] + v_[471] * v_[605] + v_[126] * v_[608]) * v_[246] + (v_[435] * v_[594] + v_[601] * v_[558] + v_[465] * v_[561] + v_[606] * v_[524] + v_[493] * v_[546] + v_[577] * v_[552] + v_[243] * v_[579] + v_[262] * v_[583] + v_[592] * v_[590] + v_[454] * v_[604] + v_[283] * v_[607]) * v_[499];
    jac[431] = 0 - (v_[452] * v_[596] + v_[352] * v_[556] + v_[521] * v_[562] + v_[626] * v_[490] + v_[242] * v_[544] + v_[342] * v_[550] + v_[623] * v_[581] + v_[492] * v_[585] + v_[271] * v_[588] + v_[563] * v_[605] + v_[260] * v_[608]) * v_[246] + (v_[477] * v_[594] + v_[352] * v_[558] + v_[282] * v_[561] + v_[626] * v_[524] + v_[242] * v_[546] + v_[342] * v_[552] + v_[249] * v_[579] + v_[289] * v_[583] + v_[271] * v_[590] + v_[406] * v_[604] + v_[287] * v_[607]) * v_[499];
    // dependent variables without operations
    jac[72] = 1;
    jac[78] = 1;
    jac[84] = 1;
    jac[90] = 1;
    jac[97] = 1;
    jac[103] = 1;
    jac[109] = 1;
    jac[115] = 1;
    jac[122] = 1;
    jac[128] = 1;
    jac[134] = 1;
    jac[140] = 1;


    return jac_;
}
}
}
}
