/**********************************************************************************************************************
This file is part of the Control Toolbox (https://adrlab.bitbucket.io/ct), copyright by ETH Zurich, Google Inc.
Authors:  Michael Neunert, Markus Giftthaler, Markus Stäuble, Diego Pardo, Farbod Farshidian
Licensed under Apache2 license (see LICENSE file in main directory)
**********************************************************************************************************************/
#include "HyAInverseDynJacReverse.h"

namespace ct {
namespace models {
namespace HyA {


HyAInverseDynJacReverse::JAC_TYPE HyAInverseDynJacReverse::jacobian(const Eigen::VectorXd& x_in)
{
    double* jac = jac_.data();

    v_[0] = sin(x_in[1]);
    v_[1] = v_[0] * x_in[6];
    v_[2] = 0 - v_[1];
    v_[3] = v_[2] * x_in[7];
    v_[4] = cos(x_in[1]);
    v_[5] = v_[4] * x_in[6];
    v_[6] = v_[5] * x_in[7];
    v_[7] = 9.81 * v_[0];
    v_[8] = x_in[7] * x_in[7];
    v_[9] = cos(x_in[2]);
    v_[10] = sin(x_in[2]);
    v_[11] = 0 - v_[9];
    v_[12] = v_[10] * v_[5] + v_[11] * x_in[7];
    v_[13] = 0 - v_[12];
    v_[14] = v_[9] * v_[3] + v_[13] * x_in[8];
    v_[15] = v_[9] * v_[5] + v_[10] * x_in[7];
    v_[16] = v_[10] * v_[3] + v_[15] * x_in[8];
    v_[17] = 9.81 * v_[4];
    v_[18] = 0.112 * v_[9];
    v_[19] = -0.112 * v_[10];
    v_[20] = 0.112 * v_[9];
    v_[21] = v_[19] * v_[5] + v_[20] * x_in[7];
    v_[22] = v_[10] * v_[17] + v_[18] * v_[3] + v_[21] * x_in[8];
    v_[23] = v_[1] + x_in[8];
    v_[24] = 0 - v_[23] * v_[21];
    v_[25] = v_[15] * v_[23];
    v_[26] = v_[23] * v_[23];
    v_[27] = v_[12] * v_[12];
    v_[28] = cos(x_in[3]);
    v_[29] = -1 * v_[16];
    v_[30] = sin(x_in[3]);
    v_[31] = 0 - v_[30];
    v_[32] = v_[30] * v_[15] + v_[28] * v_[23];
    v_[33] = 0 - v_[32];
    v_[34] = v_[31] * v_[6] + v_[28] * v_[14] + v_[33] * x_in[9];
    v_[35] = v_[28] * v_[15] + v_[31] * v_[23];
    v_[36] = v_[28] * v_[6] + v_[30] * v_[14] + v_[35] * x_in[9];
    v_[37] = -0.304 * v_[14] + -1 * v_[22];
    v_[38] = 0.112 * v_[10];
    v_[39] = v_[18] * v_[5] + v_[38] * x_in[7];
    v_[40] = 0 - v_[39];
    v_[41] = v_[9] * v_[17] + v_[19] * v_[3] + v_[40] * x_in[8];
    v_[42] = -0.304 * v_[30];
    v_[43] = -0.304 * v_[28];
    v_[44] = v_[43] * v_[12] + v_[28] * v_[21];
    v_[45] = v_[28] * v_[7] + v_[30] * v_[41] + v_[42] * v_[16] + v_[44] * x_in[9];
    v_[46] = -0.304 * v_[15] + -1 * v_[39];
    v_[47] = -1 * v_[12] + x_in[9];
    v_[48] = v_[35] * v_[46] - v_[47] * v_[44];
    v_[49] = v_[35] * v_[47];
    v_[50] = v_[47] * v_[47];
    v_[51] = v_[32] * v_[32];
    v_[52] = cos(x_in[4]);
    v_[53] = sin(x_in[4]);
    v_[54] = 0 - v_[52];
    v_[55] = v_[53] * v_[35] + v_[54] * v_[47];
    v_[56] = 0 - v_[55];
    v_[57] = v_[53] * v_[29] + v_[52] * v_[34] + v_[56] * x_in[10];
    v_[58] = v_[52] * v_[35] + v_[53] * v_[47];
    v_[59] = v_[54] * v_[29] + v_[53] * v_[34] + v_[58] * x_in[10];
    v_[60] = 0.112 * v_[53];
    v_[61] = 0.112 * v_[52];
    v_[62] = 0 - v_[52];
    v_[63] = 0 - v_[30];
    v_[64] = v_[42] * v_[12] + v_[30] * v_[21];
    v_[65] = 0 - v_[64];
    v_[66] = v_[63] * v_[7] + v_[28] * v_[41] + v_[43] * v_[16] + v_[65] * x_in[9];
    v_[67] = 0.112 * v_[52];
    v_[68] = -0.112 * v_[53];
    v_[69] = v_[67] * v_[47] + v_[68] * v_[35] + v_[53] * v_[46] + v_[52] * v_[44];
    v_[70] = v_[60] * v_[29] + v_[61] * v_[34] + v_[62] * v_[37] + v_[53] * v_[66] + v_[69] * x_in[10];
    v_[71] = v_[32] + x_in[10];
    v_[72] = v_[58] * v_[64] - v_[71] * v_[69];
    v_[73] = v_[58] * v_[71];
    v_[74] = v_[71] * v_[71];
    v_[75] = v_[55] * v_[55];
    v_[76] = sin(x_in[5]);
    v_[77] = cos(x_in[5]);
    v_[78] = 0.02075 * v_[76] + 0.184 * v_[77];
    v_[79] = 0 - v_[76];
    v_[80] = v_[60] * v_[47] + v_[61] * v_[35] + v_[62] * v_[46] + v_[53] * v_[44];
    v_[81] = 0.184 * v_[76] - 0.02075 * v_[77];
    v_[82] = v_[77] * v_[64] + v_[76] * v_[80] + v_[81] * v_[58];
    v_[83] = 0 - v_[82];
    v_[84] = v_[79] * v_[45] + v_[77] * v_[70] + v_[78] * v_[57] + v_[83] * x_in[11];
    v_[85] = v_[76] * v_[55] + v_[77] * v_[71];
    v_[86] = 0 - v_[76];
    v_[87] = v_[77] * v_[55] + v_[86] * v_[71];
    v_[88] = v_[85] * v_[87];
    v_[89] = 0.02075 * v_[71] + -0.184 * v_[55] + v_[69];
    v_[90] = v_[85] * v_[89];
    v_[91] = v_[58] + x_in[11];
    v_[92] = v_[91] * v_[82];
    v_[93] = 1.547475 * v_[84] + 0.038686875 * v_[57] + 0.038686875 * v_[88] + -1.547475 * (v_[90] - v_[92]);
    v_[94] = v_[79] * v_[64] + v_[77] * v_[80] + v_[78] * v_[58];
    v_[95] = v_[91] * v_[91];
    v_[96] = v_[87] * v_[87];
    v_[97] = 1.547475 * (v_[87] * v_[89] - v_[91] * v_[94]) +
             1.547475 * (v_[77] * v_[45] + v_[76] * v_[70] + v_[81] * v_[57] + v_[94] * x_in[11]) -
             0.038686875 * (v_[95] + v_[96]);
    v_[98] = 0 - v_[85];
    v_[99] = v_[86] * v_[36] + v_[77] * v_[59] + v_[98] * x_in[11];
    v_[100] = v_[77] * v_[36] + v_[76] * v_[59] + v_[87] * x_in[11];
    v_[101] = v_[85] * v_[91];
    v_[102] = v_[87] * v_[91];
    v_[103] = v_[85] * v_[85];
    v_[104] = v_[55] * v_[71];
    v_[105] = v_[55] * v_[58];
    v_[92] = -0.001243 * v_[36] + 0.029115 * v_[57] + -0.001387 * v_[59] + 0.057838 * v_[70] + 0.057838 * v_[72] +
             -0.001387 * v_[73] + -0.012652 * (v_[74] - v_[75]) + v_[78] * v_[93] + v_[81] * v_[97] +
             0.009277 * v_[57] + -0.000829 * v_[99] + 1.5e-05 * v_[100] + 0.038686875 * v_[84] + -0.00751 * v_[88] +
             0.038686875 * (v_[92] - v_[90]) + -0.000829 * v_[101] - 1.5e-05 * v_[102] - 0.000198 * (v_[96] - v_[103]) -
             -0.008386 * v_[104] - -0.001243 * v_[105];
    v_[90] = 0 - v_[80];
    v_[84] = v_[67] * v_[29] + v_[68] * v_[34] + v_[53] * v_[37] + v_[52] * v_[66] + v_[90] * x_in[10];
    v_[106] = v_[55] * v_[64] - v_[71] * v_[80];
    v_[107] = 0.02075 * v_[36] + -0.184 * v_[59] + v_[84];
    v_[108] = v_[85] * v_[94] - v_[87] * v_[82];
    v_[103] = -0.000829 * v_[57] + 0.003227 * v_[99] + 0.000198 * v_[100] + -0.038686875 * v_[107] +
              0.000198 * v_[102] + 1.5e-05 * (v_[95] - v_[103]) - 0.038686875 * v_[108] - -0.00146 * v_[101] -
              -0.000829 * v_[88];
    v_[102] = 1.5e-05 * v_[57] + 0.000198 * v_[99] + 0.010737 * v_[100] + 0.00605 * v_[102] + 1.5e-05 * v_[88] -
              0.000198 * v_[101] - -0.000829 * (v_[95] - v_[96]);
    v_[108] = 1.547475 * v_[107] + -0.038686875 * v_[99] + 0.038686875 * v_[101] + 1.547475 * v_[108];
    v_[107] = v_[58] * v_[58];
    v_[74] = -0.012652 * v_[36] + -0.001387 * v_[57] + 0.019432 * v_[59] + -0.057838 * v_[84] + -0.018069 * v_[73] +
             0.057838 * v_[106] + -0.012652 * v_[105] + v_[77] * v_[103] + v_[76] * v_[102] + -0.184 * v_[108] -
             -0.001387 * v_[104] - -0.001243 * (v_[74] - v_[107]);
    v_[106] = 2.1032 * v_[84] + -0.057838 * v_[59] + 0.057838 * v_[73] + -2.1032 * v_[106] + v_[108];
    v_[72] =
        2.1032 * v_[70] + 0.057838 * v_[57] + 0.057838 * v_[104] + 2.1032 * v_[72] + v_[77] * v_[93] + v_[76] * v_[97];
    v_[84] = v_[32] * v_[44] - v_[35] * v_[64];
    v_[101] = v_[32] * v_[47];
    v_[99] = v_[32] * v_[35];
    v_[100] = -0.0022920002 * v_[29] + 0.01828449 * v_[34] + 0.0036857284 * v_[36] + -0.160298259823722 * v_[37] +
              1.52322944854339e-09 * v_[45] + 1.52322944854339e-09 * v_[48] + 0.0036857284 * v_[49] +
              -0.00021200017 * (v_[50] - v_[51]) + v_[52] * v_[92] + v_[53] * v_[74] + v_[68] * v_[106] +
              v_[61] * v_[72] - 0.160298259823722 * v_[84] - 0.01404749 * v_[101] - -0.0022920002 * v_[99];
    v_[96] = v_[32] * v_[46];
    v_[95] = v_[47] * v_[64];
    v_[88] = v_[35] * v_[35];
    v_[108] = -0.00021200017 * v_[29] + 0.0036857284 * v_[34] + 0.081661 * v_[36] + -0.008711861 * v_[37] +
              -1.52322944854339e-09 * v_[66] + -0.008711861 * v_[84] + 1.52322944854339e-09 * (v_[96] - v_[95]) +
              0.077424 * v_[49] + -0.00021200017 * v_[99] + 0.011046 * v_[36] + -0.001243 * v_[57] +
              -0.012652 * v_[59] + -0.001243 * v_[104] + 0.009683 * v_[105] + v_[86] * v_[103] + v_[77] * v_[102] +
              0.02075 * v_[108] - -0.012652 * v_[73] - -0.001387 * (v_[107] - v_[75]) - 0.0036857284 * v_[101] -
              -0.0022920002 * (v_[50] - v_[88]);
    v_[84] = -0.160298259823722 * v_[34] + -0.008711861 * v_[36] + 1.7423722 * v_[37] + 1.7423722 * v_[84] +
             0.160298259823722 * v_[101] + -0.008711861 * v_[49] + v_[53] * v_[106] + v_[62] * v_[72] -
             1.52322944854339e-09 * (v_[88] + v_[51]);
    v_[105] = v_[12] * v_[21] - v_[15] * v_[39];
    v_[104] = v_[12] * v_[23];
    v_[73] = v_[12] * v_[15];
    v_[109] = -0.0037997814 * v_[6] + 0.20986895 * v_[14] + 5.399998e-05 * v_[16] + 0.0055615274403 * v_[7] +
              0.647967112 * v_[22] + 0.647967112 * v_[24] + 5.399998e-05 * v_[25] + -0.011715295 * (v_[26] - v_[27]) +
              v_[28] * v_[100] + v_[30] * v_[108] + -0.304 * v_[84] - -0.0055615274403 * v_[105] -
              -0.192033951 * v_[104] - -0.0037997814 * v_[73];
    v_[110] = v_[23] * v_[39];
    v_[111] = 0 - v_[110];
    v_[112] = 0.160298259823722 * v_[29] + -1.52322944854339e-09 * v_[36] + 1.7423722 * v_[66] +
              -1.7423722 * (v_[96] - v_[95]) + 0.160298259823722 * v_[99] + 1.52322944854339e-09 * v_[49] +
              v_[52] * v_[106] + v_[53] * v_[72] - -0.008711861 * (v_[50] + v_[51]);
    v_[107] = 0.008711861 * v_[29] + 1.52322944854339e-09 * v_[34] + 1.7423722 * v_[45] + 1.7423722 * v_[48] +
              1.52322944854339e-09 * v_[101] + -0.008711861 * v_[99] + 2.1032 * (v_[55] * v_[69] - v_[58] * v_[80]) +
              2.1032 * v_[45] + v_[79] * v_[93] + v_[77] * v_[97] - 0.160298259823722 * (v_[50] + v_[88]) -
              0.057838 * (v_[107] + v_[75]);
    v_[75] = v_[15] * v_[15];
    v_[105] =
        -0.011715295 * v_[6] + 5.399998e-05 * v_[14] + 0.20236395 * v_[16] + 0.01438086 * v_[7] +
        -0.647967112 * v_[41] + 0.01438086 * v_[105] + 0.647967112 * v_[111] + -0.199538951 * v_[25] +
        -0.011715295 * v_[73] + v_[43] * v_[112] + v_[42] * v_[107] +
        -1 * (0.09570849 * v_[29] + -0.0022920002 * v_[34] + -0.00021200017 * v_[36] + 0.160298259823722 * v_[66] +
                 0.008711861 * v_[45] + 0.160298259823722 * (v_[95] - v_[96]) + -0.06337651 * v_[99] +
                 -0.0022920002 * v_[101] + v_[53] * v_[92] + v_[54] * v_[74] + v_[67] * v_[106] + v_[60] * v_[72] -
                 -0.008711861 * v_[48] - -0.00021200017 * v_[49] - 0.0036857284 * (v_[88] - v_[51])) -
        5.399998e-05 * v_[104] - -0.0037997814 * (v_[26] - v_[75]);
    v_[111] = -0.0055615274403 * v_[6] + -0.647967112 * v_[16] + 2.327 * v_[41] + -2.327 * v_[111] +
              -0.0055615274403 * v_[73] + 0.647967112 * v_[25] + v_[28] * v_[112] + v_[30] * v_[107] -
              0.01438086 * (v_[26] + v_[27]);
    v_[84] = -0.01438086 * v_[6] + 0.647967112 * v_[14] + 2.327 * v_[22] + 2.327 * v_[24] + 0.647967112 * v_[104] +
             0.01438086 * v_[73] + -1 * v_[84] - -0.0055615274403 * (v_[26] + v_[75]);
    v_[26] = v_[1] * x_in[7];
    v_[88] = v_[1] * v_[5];
    v_[95] = v_[4] * v_[18];
    v_[96] = v_[4] * v_[9];
    v_[99] = v_[95] * -1 + v_[96] * -0.304;
    v_[101] = v_[4] * v_[19];
    v_[51] = v_[4] * v_[10];
    v_[49] = v_[101] * v_[28] + v_[51] * v_[43];
    v_[48] = v_[51] * -1;
    v_[50] = v_[0] * v_[31] + v_[96] * v_[28];
    v_[113] = v_[99] * v_[53] + v_[49] * v_[52] + v_[48] * v_[67] + v_[50] * v_[68];
    v_[114] = v_[0] * v_[28] + v_[96] * v_[30];
    v_[115] = v_[48] * v_[54] + v_[50] * v_[53];
    v_[116] = v_[113] + v_[114] * 0.02075 + v_[115] * -0.184;
    v_[117] = v_[114] * v_[86] + v_[115] * v_[77];
    v_[118] = v_[116] * 1.547475 + v_[117] * -0.038686875;
    v_[119] = v_[118] + v_[113] * 2.1032 + v_[115] * -0.057838;
    v_[120] = v_[101] * v_[30] + v_[51] * v_[42];
    v_[121] = v_[99] * v_[62] + v_[49] * v_[53] + v_[48] * v_[60] + v_[50] * v_[61];
    v_[122] = v_[48] * v_[53] + v_[50] * v_[52];
    v_[123] = v_[120] * v_[79] + v_[121] * v_[77] + v_[122] * v_[78];
    v_[124] = v_[123] * 1.547475 + v_[122] * 0.038686875;
    v_[125] = v_[120] * v_[77] + v_[121] * v_[76] + v_[122] * v_[81];
    v_[126] = v_[125] * 1.547475;
    v_[127] = v_[124] * v_[77] + v_[126] * v_[76] + v_[121] * 2.1032 + v_[122] * 0.057838;
    v_[128] = v_[119] * v_[52] + v_[127] * v_[53] + v_[49] * 1.7423722 + v_[48] * 0.160298259823722 +
              v_[114] * -1.52322944854339e-09;
    v_[129] = v_[124] * v_[79] + v_[126] * v_[77] + v_[120] * 2.1032 + v_[120] * 1.7423722 + v_[48] * 0.008711861 +
              v_[50] * 1.52322944854339e-09;
    v_[130] = v_[128] * v_[28] + v_[129] * v_[30] + v_[101] * 2.327 + v_[0] * -0.0055615274403 + v_[51] * -0.647967112;
    v_[131] =
        v_[119] * v_[53] + v_[127] * v_[62] + v_[99] * 1.7423722 + v_[50] * -0.160298259823722 + v_[114] * -0.008711861;
    v_[132] = v_[131] * -1 + v_[95] * 2.327 + v_[0] * -0.01438086 + v_[96] * 0.647967112;
    v_[133] = v_[125] * 1.547475;
    v_[134] = v_[123] * -1.547475;
    v_[135] = v_[122] * 0.038686875;
    v_[136] = v_[134] - v_[135];
    v_[137] = v_[133] * v_[87] + v_[136] * v_[85];
    v_[138] = v_[121] * 2.1032 + v_[122] * 0.057838;
    v_[139] = 0 - v_[138];
    v_[140] = v_[120] * 2.1032;
    v_[141] = v_[137] + v_[139] * v_[71] + v_[140] * v_[55] + v_[127] * x_in[10];
    v_[142] = 0 - v_[133];
    v_[143] = v_[116] * 1.547475 + (0 - v_[117]) * 0.038686875;
    v_[144] = v_[142] * v_[91] + v_[143] * v_[85] + v_[126] * x_in[11];
    v_[135] = 0 - v_[134] + v_[135];
    v_[134] = 0 - v_[143];
    v_[145] = v_[135] * v_[91] + v_[134] * v_[87] - v_[124] * x_in[11];
    v_[146] = v_[113] * -2.1032 + v_[115] * 0.057838;
    v_[147] = 0 - v_[146];
    v_[148] = 0 - v_[140];
    v_[149] = v_[144] * v_[77] + v_[145] * v_[76] + v_[147] * v_[71] + v_[148] * v_[58] - v_[119] * x_in[10];
    v_[150] = v_[120] * 1.7423722 + (0 - v_[48]) * -0.008711861 + v_[50] * 1.52322944854339e-09;
    v_[151] = 0 - v_[150];
    v_[152] = v_[99] * 1.7423722 + (0 - v_[50]) * 0.160298259823722 + v_[114] * -0.008711861;
    v_[153] = v_[141] * v_[52] + v_[149] * v_[53] + v_[151] * v_[47] + v_[152] * v_[32] + v_[129] * x_in[9];
    v_[154] = v_[49] * -1.7423722;
    v_[155] = v_[48] * 0.160298259823722;
    v_[156] = v_[114] * 1.52322944854339e-09;
    v_[157] = 0 - v_[154] + v_[155] - v_[156];
    v_[158] = 0 - v_[152];
    v_[159] = v_[144] * v_[79] + v_[145] * v_[77] + v_[138] * v_[58] + v_[146] * v_[55] + v_[157] * v_[47] +
              v_[158] * v_[35] - v_[128] * x_in[9];
    v_[160] = 0 - (v_[95] * 2.327 + (0 - v_[0]) * 0.01438086 + v_[96] * 0.647967112);
    v_[161] = (0 - v_[96]) * -0.0055615274403 + v_[51] * 0.01438086;
    v_[162] = v_[153] * v_[28] + v_[159] * v_[30] + v_[160] * v_[23] + v_[161] * v_[12] + v_[132] * x_in[8];
    v_[156] = v_[154] - v_[155] + v_[156];
    v_[155] = v_[141] * v_[53] + v_[149] * v_[62] + v_[150] * v_[35] + v_[156] * v_[32];
    v_[154] = v_[0] * -0.0055615274403 - (v_[101] * -2.327 + v_[51] * 0.647967112);
    v_[163] = 0 - v_[161];
    v_[164] = v_[155] * -1 + v_[154] * v_[23] + v_[163] * v_[15] - v_[130] * x_in[8];
    v_[165] = v_[114] * v_[77] + v_[115] * v_[76];
    v_[166] = (0 - v_[122]) * 1.5e-05 + v_[117] * 0.000198 + v_[165] * 0.00605;
    v_[167] = v_[116] * 0.038686875 + v_[122] * -0.000829 + (0 - v_[117]) * -0.00146 + (0 - v_[165]) * 0.000198;
    v_[125] = (0 - v_[125]) * 0.038686875;
    v_[168] = v_[117] * 1.5e-05;
    v_[169] = (0 - v_[165]) * -0.000829;
    v_[170] = v_[125] + v_[168] + v_[169];
    v_[170] =
        v_[142] * v_[94] + v_[135] * v_[82] + v_[166] * v_[87] + v_[167] * v_[85] + v_[170] * v_[91] + v_[170] * v_[91];
    v_[135] = v_[113] * 0.057838 + (0 - v_[114]) * -0.012652 + v_[122] * -0.001387 + v_[115] * -0.018069;
    v_[142] = v_[114] * 0.009683 + (0 - v_[122]) * -0.001243 + v_[115] * -0.012652;
    v_[171] = (0 - v_[120]) * 0.057838;
    v_[172] = (0 - v_[114]) * -0.001387;
    v_[173] = (0 - v_[115]) * -0.001243;
    v_[174] = v_[171] + v_[172] - v_[173];
    v_[116] = v_[116] * -0.038686875 + v_[122] * -0.000829 + v_[117] * 0.003227 + v_[165] * 0.000198;
    v_[175] = v_[122] * 1.5e-05 + v_[117] * 0.000198 + v_[165] * 0.010737;
    jac[66] = v_[124] * v_[83] + v_[126] * v_[94] + v_[116] * v_[98] + v_[175] * v_[87] + v_[170];
    v_[113] = v_[118] * -0.184 + v_[116] * v_[77] + v_[175] * v_[76] + v_[113] * -0.057838 + v_[114] * -0.012652 +
              v_[122] * -0.001387 + v_[115] * 0.019432;
    v_[174] = v_[170] + v_[144] * v_[78] + v_[145] * v_[81] + v_[138] * v_[64] + v_[148] * v_[80] + v_[135] * v_[71] +
              v_[142] * v_[55] + v_[174] * v_[58] + v_[174] * v_[58] + v_[113] * x_in[10];
    v_[170] = v_[123] * 0.038686875 + v_[122] * -0.00751 + (0 - v_[117]) * -0.000829 + v_[165] * 1.5e-05;
    v_[148] = (0 - v_[122]) * 0.000198;
    v_[169] = v_[125] + v_[148] - v_[169];
    v_[169] = v_[133] * v_[89] + v_[134] * v_[82] + v_[166] * v_[91] + v_[170] * v_[85] + v_[169] * v_[87] +
              v_[169] * v_[87] + v_[175] * x_in[11];
    v_[148] = 0 - v_[148] - v_[168];
    v_[148] = v_[136] * v_[89] + v_[143] * v_[94] + v_[167] * v_[91] + v_[170] * v_[87] + v_[148] * v_[85] +
              v_[148] * v_[85] - v_[116] * x_in[11];
    v_[170] = v_[121] * 0.057838 + v_[114] * -0.001243 + (0 - v_[122]) * -0.008386 + (0 - v_[115]) * -0.001387;
    v_[167] = v_[122] * -0.012652;
    v_[172] = v_[171] - v_[172] - v_[167];
    v_[165] = v_[123] * 0.038686875 + v_[122] * 0.009277 + v_[117] * -0.000829 + v_[165] * 1.5e-05 + v_[124] * v_[78] +
              v_[126] * v_[81] + v_[121] * 0.057838 + v_[114] * -0.001243 + v_[122] * 0.029115 + v_[115] * -0.001387;
    v_[172] = v_[137] * -0.184 + v_[169] * v_[77] + v_[148] * v_[76] + v_[146] * v_[64] + v_[140] * v_[69] +
              v_[170] * v_[71] + v_[142] * v_[58] + v_[172] * v_[55] + v_[172] * v_[55] - v_[165] * x_in[10];
    v_[142] = v_[99] * -0.008711861 + v_[49] * 1.52322944854339e-09 + (0 - v_[48]) * -0.00021200017 +
              v_[50] * 0.0036857284 + v_[114] * 0.077424;
    v_[146] = v_[49] * 0.160298259823722 + v_[120] * -0.008711861 + v_[48] * -0.06337651 +
              (0 - v_[50]) * -0.0022920002 + v_[114] * -0.00021200017;
    v_[140] = (0 - v_[99]) * 1.52322944854339e-09;
    v_[123] = (0 - v_[120]) * 0.160298259823722;
    v_[117] = (0 - v_[48]) * 0.0036857284;
    v_[171] = (0 - v_[114]) * -0.0022920002;
    v_[143] = v_[140] + v_[123] + v_[117] - v_[171];
    v_[118] = v_[118] * 0.02075 + v_[116] * v_[86] + v_[175] * v_[77] + v_[114] * 0.011046 + v_[122] * -0.001243 +
              v_[115] * -0.012652 + v_[99] * -0.008711861 + v_[49] * -1.52322944854339e-09 + v_[48] * -0.00021200017 +
              v_[50] * 0.0036857284 + v_[114] * 0.081661;
    v_[143] = v_[141] * v_[68] + v_[149] * v_[61] + v_[174] * v_[52] + v_[172] * v_[53] + v_[150] * v_[46] +
              v_[158] * v_[64] + v_[142] * v_[47] + v_[146] * v_[32] + v_[143] * v_[35] + v_[143] * v_[35] +
              v_[118] * x_in[9];
    v_[167] = v_[167] + v_[173];
    v_[167] = v_[137] * 0.02075 + v_[169] * v_[86] + v_[148] * v_[77] + v_[139] * v_[69] + v_[147] * v_[80] +
              v_[135] * v_[58] + v_[170] * v_[55] + v_[167] * v_[71] + v_[167] * v_[71];
    jac[60] = v_[119] * v_[90] + v_[127] * v_[69] + v_[165] * v_[56] + v_[113] * v_[58] + v_[167];
    v_[170] = v_[99] * 0.160298259823722 + v_[120] * 1.52322944854339e-09 + v_[48] * -0.0022920002 +
              (0 - v_[50]) * 0.01404749 + (0 - v_[114]) * 0.0036857284;
    v_[135] = (0 - v_[49]) * -0.008711861;
    v_[147] = v_[50] * -0.00021200017;
    v_[117] = v_[140] + v_[135] - v_[117] - v_[147];
    v_[140] = v_[119] * v_[68] + v_[127] * v_[61] + v_[165] * v_[52] + v_[113] * v_[53] + v_[99] * -0.160298259823722 +
              v_[120] * 1.52322944854339e-09 + v_[48] * -0.0022920002 + v_[50] * 0.01828449 + v_[114] * 0.0036857284;
    v_[117] = v_[167] + v_[156] * v_[46] + v_[152] * v_[44] + v_[170] * v_[47] + v_[146] * v_[35] + v_[117] * v_[32] +
              v_[117] * v_[32] - v_[140] * x_in[9];
    v_[167] = v_[101] * 0.647967112 + (0 - v_[0]) * -0.011715295 + v_[96] * 5.399998e-05 + v_[51] * -0.199538951;
    v_[146] = v_[101] * -0.0055615274403 + v_[95] * 0.01438086 + v_[0] * 0.00750500000000001 +
              (0 - v_[96]) * -0.0037997814 + v_[51] * -0.011715295;
    v_[156] = (0 - v_[95]) * -0.0055615274403;
    v_[152] = (0 - v_[0]) * 5.399998e-05;
    v_[139] = (0 - v_[51]) * -0.0037997814;
    v_[137] = v_[156] + v_[152] - v_[139];
    v_[173] = v_[128] * v_[43] + v_[129] * v_[42] +
              (v_[119] * v_[67] + v_[127] * v_[60] + v_[165] * v_[53] + v_[113] * v_[54] + v_[49] * 0.160298259823722 +
                  v_[120] * 0.008711861 + v_[48] * 0.09570849 + v_[50] * -0.0022920002 + v_[114] * -0.00021200017) *
                  -1 +
              v_[101] * -0.647967112 + v_[0] * -0.011715295 + v_[96] * 5.399998e-05 + v_[51] * 0.20236395;
    v_[137] = v_[155] * -0.304 + v_[143] * v_[28] + v_[117] * v_[30] + v_[163] * v_[39] + v_[167] * v_[23] +
              v_[146] * v_[12] + v_[137] * v_[15] + v_[137] * v_[15] + v_[173] * x_in[8];
    v_[147] = v_[135] + v_[123] + v_[147] + v_[171];
    v_[147] = v_[141] * v_[67] + v_[149] * v_[60] + v_[174] * v_[53] + v_[172] * v_[54] + v_[151] * v_[44] +
              v_[157] * v_[64] + v_[142] * v_[35] + v_[170] * v_[32] + v_[147] * v_[47] + v_[147] * v_[47];
    jac[54] = v_[128] * v_[65] + v_[129] * v_[44] + v_[140] * v_[33] + v_[118] * v_[35] + v_[147];
    v_[170] = v_[95] * 0.647967112 + v_[0] * -0.0037997814 + (0 - v_[96]) * -0.192033951 + (0 - v_[51]) * 5.399998e-05;
    v_[142] = (0 - v_[101]) * 0.01438086;
    v_[157] = v_[96] * -0.011715295;
    v_[152] = v_[142] - v_[152] - v_[157];
    v_[131] = v_[131] * -0.304 + v_[140] * v_[28] + v_[118] * v_[30] + v_[95] * 0.647967112 + v_[0] * -0.0037997814 +
              v_[96] * 0.20986895 + v_[51] * 5.399998e-05;
    v_[152] = v_[153] * v_[43] + v_[159] * v_[42] + v_[147] * -1 + v_[161] * v_[21] + v_[170] * v_[23] +
              v_[146] * v_[15] + v_[152] * v_[12] + v_[152] * v_[12] - v_[131] * x_in[8];
    v_[147] = (0 - v_[4]) * -0.002752 + v_[0] * -0.022851627;
    v_[146] = (0 - v_[0]) * -0.002752;
    v_[161] = 0 - v_[146];
    v_[95] = v_[140] * v_[31] + v_[118] * v_[28] + v_[101] * -0.0055615274403 + v_[95] * -0.01438086 +
             v_[0] * 0.010329999 + v_[96] * -0.0037997814 + v_[51] * -0.011715295 + v_[4] * 0.0055279857 +
             v_[0] * 0.039002996 + v_[4] * 0.0055279857 + v_[0] * -0.034462002;
    v_[161] = v_[162] * v_[19] + v_[164] * v_[18] + v_[137] * v_[9] + v_[152] * v_[10] + v_[147] * v_[1] +
              v_[161] * v_[5] + v_[161] * v_[5] + v_[95] * x_in[7];
    v_[151] = sin(x_in[1]);
    v_[157] = v_[142] + v_[156] + v_[157] + v_[139];
    v_[157] = v_[143] * v_[31] + v_[117] * v_[28] + v_[160] * v_[21] + v_[154] * v_[39] + v_[167] * v_[15] +
              v_[170] * v_[12] + v_[157] * v_[23] + v_[157] * v_[23];
    jac[48] = v_[130] * v_[40] + v_[132] * v_[21] + v_[131] * v_[13] + v_[173] * v_[15] + v_[157];
    v_[170] = (0 - v_[4]) * 0.012390532 + (0 - v_[0]) * 0.0055279857;
    v_[167] = v_[4] * -0.022851627;
    v_[154] = 0 - v_[167];
    v_[160] = v_[130] * v_[19] + v_[132] * v_[18] + v_[131] * v_[9] + v_[173] * v_[10] + v_[4] * 0.08585553 +
              v_[0] * 0.0055279857;
    v_[154] = v_[157] + v_[170] * x_in[7] + v_[147] * v_[5] + v_[154] * v_[1] + v_[154] * v_[1] - v_[160] * x_in[7];
    jac[36] = v_[161] * v_[4] + v_[154] * v_[0];
    v_[157] = cos(x_in[1]);
    jac[6] = 0 -
             (0.08585553 * v_[3] + 0.0055279857 * v_[6] + 0.0099341499912 * v_[7] + 0.0055279857 * v_[6] +
                 -0.022851627 * (v_[8] - v_[1] * v_[1]) + v_[9] * v_[109] + v_[10] * v_[105] + v_[19] * v_[111] +
                 v_[18] * v_[84] - 0.012390532 * v_[26] - -0.002752 * v_[88] +
                 (v_[130] * v_[9] + v_[132] * v_[10] + v_[0] * -0.0099341499912) * 9.81 + v_[161] * x_in[6]) *
                 v_[151] +
             (0.0055279857 * v_[3] + 0.039002996 * v_[6] + -0.0099341499912 * v_[17] + -0.034462002 * v_[6] +
                 -0.022851627 * v_[88] + 0.010329999 * v_[6] + -0.0037997814 * v_[14] + -0.011715295 * v_[16] +
                 -0.0055615274403 * v_[41] + -0.01438086 * v_[22] + -0.0055615274403 * v_[110] +
                 0.00750500000000001 * v_[73] + -0.0037997814 * v_[104] + v_[31] * v_[100] + v_[28] * v_[108] -
                 0.01438086 * v_[24] - -0.011715295 * v_[25] - 5.399998e-05 * (v_[75] - v_[27]) -
                 0.0055279857 * v_[26] - -0.002752 * (v_[8] - v_[5] * v_[5]) +
                 (v_[128] * v_[63] + v_[129] * v_[28] + v_[96] * 0.0055615274403 + v_[51] * 0.01438086 +
                     v_[4] * 0.0099341499912) *
                     9.81 +
                 v_[154] * x_in[6]) *
                 v_[157];
    v_[154] = v_[38] * -1 + v_[10] * -0.304;
    v_[161] = v_[20] * v_[28] + v_[11] * v_[43];
    v_[88] = v_[11] * -1;
    v_[26] = v_[10] * v_[28];
    v_[75] = v_[154] * v_[53] + v_[161] * v_[52] + v_[88] * v_[67] + v_[26] * v_[68];
    v_[110] = v_[10] * v_[30];
    v_[73] = v_[88] * v_[54] + v_[26] * v_[53];
    v_[104] = v_[75] + v_[110] * 0.02075 + v_[73] * -0.184;
    v_[27] = v_[110] * v_[86] + v_[73] * v_[77];
    v_[25] = v_[104] * 1.547475 + v_[27] * -0.038686875;
    v_[24] = v_[25] + v_[75] * 2.1032 + v_[73] * -0.057838;
    v_[22] = v_[20] * v_[30] + v_[11] * v_[42];
    v_[8] = v_[154] * v_[62] + v_[161] * v_[53] + v_[88] * v_[60] + v_[26] * v_[61];
    v_[147] = v_[88] * v_[53] + v_[26] * v_[52];
    v_[142] = v_[22] * v_[79] + v_[8] * v_[77] + v_[147] * v_[78];
    v_[139] = v_[142] * 1.547475 + v_[147] * 0.038686875;
    v_[156] = v_[22] * v_[77] + v_[8] * v_[76] + v_[147] * v_[81];
    v_[135] = v_[156] * 1.547475;
    v_[171] = v_[139] * v_[77] + v_[135] * v_[76] + v_[8] * 2.1032 + v_[147] * 0.057838;
    v_[123] = v_[24] * v_[52] + v_[171] * v_[53] + v_[161] * 1.7423722 + v_[88] * 0.160298259823722 +
              v_[110] * -1.52322944854339e-09;
    v_[163] = v_[139] * v_[79] + v_[135] * v_[77] + v_[22] * 2.1032 + v_[22] * 1.7423722 + v_[88] * 0.008711861 +
              v_[26] * 1.52322944854339e-09;
    v_[155] = v_[123] * v_[28] + v_[163] * v_[30] + v_[20] * 2.327 + v_[11] * -0.647967112;
    v_[158] =
        v_[24] * v_[53] + v_[171] * v_[62] + v_[154] * 1.7423722 + v_[26] * -0.160298259823722 + v_[110] * -0.008711861;
    v_[150] = v_[158] * -1 + v_[38] * 2.327 + v_[10] * 0.647967112;
    v_[136] = v_[156] * 1.547475;
    v_[168] = v_[142] * -1.547475;
    v_[166] = v_[147] * 0.038686875;
    v_[134] = v_[168] - v_[166];
    v_[133] = v_[136] * v_[87] + v_[134] * v_[85];
    v_[125] = v_[8] * 2.1032 + v_[147] * 0.057838;
    v_[138] = 0 - v_[125];
    v_[176] = v_[22] * 2.1032;
    v_[177] = v_[133] + v_[138] * v_[71] + v_[176] * v_[55] + v_[171] * x_in[10];
    v_[178] = 0 - v_[136];
    v_[179] = v_[104] * 1.547475 + (0 - v_[27]) * 0.038686875;
    v_[180] = v_[178] * v_[91] + v_[179] * v_[85] + v_[135] * x_in[11];
    v_[166] = 0 - v_[168] + v_[166];
    v_[168] = 0 - v_[179];
    v_[181] = v_[166] * v_[91] + v_[168] * v_[87] - v_[139] * x_in[11];
    v_[182] = v_[75] * -2.1032 + v_[73] * 0.057838;
    v_[183] = 0 - v_[182];
    v_[184] = 0 - v_[176];
    v_[185] = v_[180] * v_[77] + v_[181] * v_[76] + v_[183] * v_[71] + v_[184] * v_[58] - v_[24] * x_in[10];
    v_[186] = v_[22] * 1.7423722 + (0 - v_[88]) * -0.008711861 + v_[26] * 1.52322944854339e-09;
    v_[187] = 0 - v_[186];
    v_[188] = v_[154] * 1.7423722 + (0 - v_[26]) * 0.160298259823722 + v_[110] * -0.008711861;
    v_[189] = v_[177] * v_[52] + v_[185] * v_[53] + v_[187] * v_[47] + v_[188] * v_[32] + v_[163] * x_in[9];
    v_[190] = v_[161] * -1.7423722;
    v_[191] = v_[88] * 0.160298259823722;
    v_[192] = v_[110] * 1.52322944854339e-09;
    v_[193] = 0 - v_[190] + v_[191] - v_[192];
    v_[194] = 0 - v_[188];
    v_[195] = v_[180] * v_[79] + v_[181] * v_[77] + v_[125] * v_[58] + v_[182] * v_[55] + v_[193] * v_[47] +
              v_[194] * v_[35] - v_[123] * x_in[9];
    v_[196] = 0 - (v_[38] * 2.327 + v_[10] * 0.647967112);
    v_[197] = (0 - v_[10]) * -0.0055615274403 + v_[11] * 0.01438086;
    v_[198] = v_[189] * v_[28] + v_[195] * v_[30] + v_[196] * v_[23] + v_[197] * v_[12] + v_[150] * x_in[8];
    v_[192] = v_[190] - v_[191] + v_[192];
    v_[191] = v_[177] * v_[53] + v_[185] * v_[62] + v_[186] * v_[35] + v_[192] * v_[32];
    v_[190] = 0 - (v_[20] * -2.327 + v_[11] * 0.647967112);
    v_[199] = 0 - v_[197];
    v_[200] = v_[191] * -1 + v_[190] * v_[23] + v_[199] * v_[15] - v_[155] * x_in[8];
    v_[201] = v_[110] * v_[77] + v_[73] * v_[76];
    v_[202] = (0 - v_[147]) * 1.5e-05 + v_[27] * 0.000198 + v_[201] * 0.00605;
    v_[203] = v_[104] * 0.038686875 + v_[147] * -0.000829 + (0 - v_[27]) * -0.00146 + (0 - v_[201]) * 0.000198;
    v_[156] = (0 - v_[156]) * 0.038686875;
    v_[204] = v_[27] * 1.5e-05;
    v_[205] = (0 - v_[201]) * -0.000829;
    v_[206] = v_[156] + v_[204] + v_[205];
    v_[206] =
        v_[178] * v_[94] + v_[166] * v_[82] + v_[202] * v_[87] + v_[203] * v_[85] + v_[206] * v_[91] + v_[206] * v_[91];
    v_[166] = v_[75] * 0.057838 + (0 - v_[110]) * -0.012652 + v_[147] * -0.001387 + v_[73] * -0.018069;
    v_[178] = v_[110] * 0.009683 + (0 - v_[147]) * -0.001243 + v_[73] * -0.012652;
    v_[207] = (0 - v_[22]) * 0.057838;
    v_[208] = (0 - v_[110]) * -0.001387;
    v_[209] = (0 - v_[73]) * -0.001243;
    v_[210] = v_[207] + v_[208] - v_[209];
    v_[104] = v_[104] * -0.038686875 + v_[147] * -0.000829 + v_[27] * 0.003227 + v_[201] * 0.000198;
    v_[211] = v_[147] * 1.5e-05 + v_[27] * 0.000198 + v_[201] * 0.010737;
    jac[67] = v_[139] * v_[83] + v_[135] * v_[94] + v_[104] * v_[98] + v_[211] * v_[87] + v_[206];
    v_[75] = v_[25] * -0.184 + v_[104] * v_[77] + v_[211] * v_[76] + v_[75] * -0.057838 + v_[110] * -0.012652 +
             v_[147] * -0.001387 + v_[73] * 0.019432;
    v_[210] = v_[206] + v_[180] * v_[78] + v_[181] * v_[81] + v_[125] * v_[64] + v_[184] * v_[80] + v_[166] * v_[71] +
              v_[178] * v_[55] + v_[210] * v_[58] + v_[210] * v_[58] + v_[75] * x_in[10];
    v_[206] = v_[142] * 0.038686875 + v_[147] * -0.00751 + (0 - v_[27]) * -0.000829 + v_[201] * 1.5e-05;
    v_[184] = (0 - v_[147]) * 0.000198;
    v_[205] = v_[156] + v_[184] - v_[205];
    v_[205] = v_[136] * v_[89] + v_[168] * v_[82] + v_[202] * v_[91] + v_[206] * v_[85] + v_[205] * v_[87] +
              v_[205] * v_[87] + v_[211] * x_in[11];
    v_[184] = 0 - v_[184] - v_[204];
    v_[184] = v_[134] * v_[89] + v_[179] * v_[94] + v_[203] * v_[91] + v_[206] * v_[87] + v_[184] * v_[85] +
              v_[184] * v_[85] - v_[104] * x_in[11];
    v_[206] = v_[8] * 0.057838 + v_[110] * -0.001243 + (0 - v_[147]) * -0.008386 + (0 - v_[73]) * -0.001387;
    v_[203] = v_[147] * -0.012652;
    v_[208] = v_[207] - v_[208] - v_[203];
    v_[201] = v_[142] * 0.038686875 + v_[147] * 0.009277 + v_[27] * -0.000829 + v_[201] * 1.5e-05 + v_[139] * v_[78] +
              v_[135] * v_[81] + v_[8] * 0.057838 + v_[110] * -0.001243 + v_[147] * 0.029115 + v_[73] * -0.001387;
    v_[208] = v_[133] * -0.184 + v_[205] * v_[77] + v_[184] * v_[76] + v_[182] * v_[64] + v_[176] * v_[69] +
              v_[206] * v_[71] + v_[178] * v_[58] + v_[208] * v_[55] + v_[208] * v_[55] - v_[201] * x_in[10];
    v_[178] = v_[154] * -0.008711861 + v_[161] * 1.52322944854339e-09 + (0 - v_[88]) * -0.00021200017 +
              v_[26] * 0.0036857284 + v_[110] * 0.077424;
    v_[182] = v_[161] * 0.160298259823722 + v_[22] * -0.008711861 + v_[88] * -0.06337651 +
              (0 - v_[26]) * -0.0022920002 + v_[110] * -0.00021200017;
    v_[176] = (0 - v_[154]) * 1.52322944854339e-09;
    v_[142] = (0 - v_[22]) * 0.160298259823722;
    v_[27] = (0 - v_[88]) * 0.0036857284;
    v_[207] = (0 - v_[110]) * -0.0022920002;
    v_[179] = v_[176] + v_[142] + v_[27] - v_[207];
    v_[25] = v_[25] * 0.02075 + v_[104] * v_[86] + v_[211] * v_[77] + v_[110] * 0.011046 + v_[147] * -0.001243 +
             v_[73] * -0.012652 + v_[154] * -0.008711861 + v_[161] * -1.52322944854339e-09 + v_[88] * -0.00021200017 +
             v_[26] * 0.0036857284 + v_[110] * 0.081661;
    v_[179] = v_[177] * v_[68] + v_[185] * v_[61] + v_[210] * v_[52] + v_[208] * v_[53] + v_[186] * v_[46] +
              v_[194] * v_[64] + v_[178] * v_[47] + v_[182] * v_[32] + v_[179] * v_[35] + v_[179] * v_[35] +
              v_[25] * x_in[9];
    v_[203] = v_[203] + v_[209];
    v_[203] = v_[133] * 0.02075 + v_[205] * v_[86] + v_[184] * v_[77] + v_[138] * v_[69] + v_[183] * v_[80] +
              v_[166] * v_[58] + v_[206] * v_[55] + v_[203] * v_[71] + v_[203] * v_[71];
    jac[61] = v_[24] * v_[90] + v_[171] * v_[69] + v_[201] * v_[56] + v_[75] * v_[58] + v_[203];
    v_[206] = v_[154] * 0.160298259823722 + v_[22] * 1.52322944854339e-09 + v_[88] * -0.0022920002 +
              (0 - v_[26]) * 0.01404749 + (0 - v_[110]) * 0.0036857284;
    v_[166] = (0 - v_[161]) * -0.008711861;
    v_[183] = v_[26] * -0.00021200017;
    v_[27] = v_[176] + v_[166] - v_[27] - v_[183];
    v_[176] = v_[24] * v_[68] + v_[171] * v_[61] + v_[201] * v_[52] + v_[75] * v_[53] + v_[154] * -0.160298259823722 +
              v_[22] * 1.52322944854339e-09 + v_[88] * -0.0022920002 + v_[26] * 0.01828449 + v_[110] * 0.0036857284;
    v_[27] = v_[203] + v_[192] * v_[46] + v_[188] * v_[44] + v_[206] * v_[47] + v_[182] * v_[35] + v_[27] * v_[32] +
             v_[27] * v_[32] - v_[176] * x_in[9];
    v_[203] = v_[20] * 0.647967112 + v_[10] * 5.399998e-05 + v_[11] * -0.199538951;
    v_[182] = v_[20] * -0.0055615274403 + v_[38] * 0.01438086 + (0 - v_[10]) * -0.0037997814 + v_[11] * -0.011715295;
    v_[192] = (0 - v_[38]) * -0.0055615274403;
    v_[188] = (0 - v_[11]) * -0.0037997814;
    v_[138] = v_[192] - v_[188];
    v_[133] = v_[123] * v_[43] + v_[163] * v_[42] +
              (v_[24] * v_[67] + v_[171] * v_[60] + v_[201] * v_[53] + v_[75] * v_[54] + v_[161] * 0.160298259823722 +
                  v_[22] * 0.008711861 + v_[88] * 0.09570849 + v_[26] * -0.0022920002 + v_[110] * -0.00021200017) *
                  -1 +
              v_[20] * -0.647967112 + v_[10] * 5.399998e-05 + v_[11] * 0.20236395;
    v_[138] = v_[191] * -0.304 + v_[179] * v_[28] + v_[27] * v_[30] + v_[199] * v_[39] + v_[203] * v_[23] +
              v_[182] * v_[12] + v_[138] * v_[15] + v_[138] * v_[15] + v_[133] * x_in[8];
    v_[183] = v_[166] + v_[142] + v_[183] + v_[207];
    v_[183] = v_[177] * v_[67] + v_[185] * v_[60] + v_[210] * v_[53] + v_[208] * v_[54] + v_[187] * v_[44] +
              v_[193] * v_[64] + v_[178] * v_[35] + v_[206] * v_[32] + v_[183] * v_[47] + v_[183] * v_[47];
    jac[55] = v_[123] * v_[65] + v_[163] * v_[44] + v_[176] * v_[33] + v_[25] * v_[35] + v_[183];
    v_[206] = v_[38] * 0.647967112 + (0 - v_[10]) * -0.192033951 + (0 - v_[11]) * 5.399998e-05;
    v_[178] = (0 - v_[20]) * 0.01438086;
    v_[193] = v_[10] * -0.011715295;
    v_[187] = v_[178] - v_[193];
    v_[158] = v_[158] * -0.304 + v_[176] * v_[28] + v_[25] * v_[30] + v_[38] * 0.647967112 + v_[10] * 0.20986895 +
              v_[11] * 5.399998e-05;
    v_[187] = v_[189] * v_[43] + v_[195] * v_[42] + v_[183] * -1 + v_[197] * v_[21] + v_[206] * v_[23] +
              v_[182] * v_[15] + v_[187] * v_[12] + v_[187] * v_[12] - v_[158] * x_in[8];
    v_[183] = v_[176] * v_[31] + v_[25] * v_[28] + v_[20] * -0.0055615274403 + v_[38] * -0.01438086 +
              v_[10] * -0.0037997814 + v_[11] * -0.011715295 - 0.022851627 + 0.022851627;
    v_[182] = v_[198] * v_[19] + v_[200] * v_[18] + v_[138] * v_[9] + v_[187] * v_[10] + 0.046852534 * v_[1] +
              -0.0055279857 * v_[5] + -0.0055279857 * v_[5] + v_[183] * x_in[7];
    v_[193] = v_[178] + v_[192] + v_[193] + v_[188];
    v_[193] = v_[179] * v_[31] + v_[27] * v_[28] + v_[196] * v_[21] + v_[190] * v_[39] + v_[203] * v_[15] +
              v_[206] * v_[12] + v_[193] * v_[23] + v_[193] * v_[23];
    jac[49] = v_[155] * v_[40] + v_[150] * v_[21] + v_[158] * v_[13] + v_[133] * v_[15] + v_[193];
    v_[206] = v_[155] * v_[19] + v_[150] * v_[18] + v_[158] * v_[9] + v_[133] * v_[10] - 0.002752;
    jac[43] = v_[198] * v_[20] + v_[200] * v_[38] + v_[138] * v_[10] + v_[187] * v_[11] + -0.002752 * v_[1] +
              v_[206] * v_[2] + v_[183] * v_[5];
    v_[206] = v_[193] + -0.002752 * x_in[7] + 0.046852534 * v_[5] + 0.0055279857 * v_[1] + 0.0055279857 * v_[1] -
              v_[206] * x_in[7];
    jac[7] = 0 - ((v_[155] * v_[9] + v_[150] * v_[10] + 0.293374233908935) * 9.81 + v_[182] * x_in[6]) * v_[151] +
             ((v_[123] * v_[63] + v_[163] * v_[28] + v_[10] * 0.0055615274403 + v_[11] * 0.01438086 + 0.0606159433962) *
                     9.81 +
                 v_[206] * x_in[6]) *
                 v_[157];
    jac[37] = v_[182] * v_[4] + v_[206] * v_[0];
    v_[206] = v_[31] * v_[68];
    v_[182] = v_[31] * v_[53];
    v_[193] = v_[206] + v_[28] * 0.02075 + v_[182] * -0.184;
    v_[183] = v_[28] * v_[86] + v_[182] * v_[77];
    v_[203] = v_[193] * 1.547475 + v_[183] * -0.038686875;
    v_[190] = v_[203] + v_[206] * 2.1032 + v_[182] * -0.057838;
    v_[196] = v_[31] * v_[61];
    v_[178] = v_[31] * v_[52];
    v_[188] = v_[196] * v_[77] + v_[178] * v_[78];
    v_[192] = v_[188] * 1.547475 + v_[178] * 0.038686875;
    v_[197] = v_[196] * v_[76] + v_[178] * v_[81];
    v_[166] = v_[197] * 1.547475;
    v_[207] = v_[192] * v_[77] + v_[166] * v_[76] + v_[196] * 2.1032 + v_[178] * 0.057838;
    v_[142] = v_[190] * v_[52] + v_[207] * v_[53] + v_[28] * -1.52322944854339e-09;
    v_[199] = v_[192] * v_[79] + v_[166] * v_[77] + v_[31] * 1.52322944854339e-09;
    v_[191] = v_[142] * v_[28] + v_[199] * v_[30] - 0.0055615274403;
    v_[209] = v_[190] * v_[53] + v_[207] * v_[62] + v_[31] * -0.160298259823722 + v_[28] * -0.008711861;
    v_[194] = v_[209] * -1 - 0.01438086;
    v_[186] = v_[197] * 1.547475;
    v_[134] = v_[188] * -1.547475;
    v_[204] = v_[178] * 0.038686875;
    v_[202] = v_[134] - v_[204];
    v_[168] = v_[186] * v_[87] + v_[202] * v_[85];
    v_[136] = v_[196] * 2.1032 + v_[178] * 0.057838;
    v_[156] = 0 - v_[136];
    v_[125] = v_[168] + v_[156] * v_[71] + v_[207] * x_in[10];
    v_[212] = 0 - v_[186];
    v_[213] = v_[193] * 1.547475 + (0 - v_[183]) * 0.038686875;
    v_[214] = v_[212] * v_[91] + v_[213] * v_[85] + v_[166] * x_in[11];
    v_[204] = 0 - v_[134] + v_[204];
    v_[134] = 0 - v_[213];
    v_[215] = v_[204] * v_[91] + v_[134] * v_[87] - v_[192] * x_in[11];
    v_[216] = v_[206] * -2.1032 + v_[182] * 0.057838;
    v_[217] = 0 - v_[216];
    v_[218] = v_[214] * v_[77] + v_[215] * v_[76] + v_[217] * v_[71] - v_[190] * x_in[10];
    v_[219] = v_[31] * 1.52322944854339e-09;
    v_[220] = 0 - v_[219];
    v_[221] = (0 - v_[31]) * 0.160298259823722 + v_[28] * -0.008711861;
    v_[222] = v_[125] * v_[52] + v_[218] * v_[53] + v_[220] * v_[47] + v_[221] * v_[32] + v_[199] * x_in[9];
    v_[223] = v_[28] * 1.52322944854339e-09;
    v_[224] = 0 - v_[223];
    v_[225] = 0 - v_[221];
    v_[226] = v_[214] * v_[79] + v_[215] * v_[77] + v_[136] * v_[58] + v_[216] * v_[55] + v_[224] * v_[47] +
              v_[225] * v_[35] - v_[142] * x_in[9];
    v_[227] = v_[222] * v_[28] + v_[226] * v_[30] + 0.01438086 * v_[23] + v_[194] * x_in[8];
    v_[228] = v_[125] * v_[53] + v_[218] * v_[62] + v_[219] * v_[35] + v_[223] * v_[32];
    v_[229] = v_[228] * -1 + -0.0055615274403 * v_[23] - v_[191] * x_in[8];
    v_[230] = v_[28] * v_[77] + v_[182] * v_[76];
    v_[231] = (0 - v_[178]) * 1.5e-05 + v_[183] * 0.000198 + v_[230] * 0.00605;
    v_[232] = v_[193] * 0.038686875 + v_[178] * -0.000829 + (0 - v_[183]) * -0.00146 + (0 - v_[230]) * 0.000198;
    v_[197] = (0 - v_[197]) * 0.038686875;
    v_[233] = v_[183] * 1.5e-05;
    v_[234] = (0 - v_[230]) * -0.000829;
    v_[235] = v_[197] + v_[233] + v_[234];
    v_[235] =
        v_[212] * v_[94] + v_[204] * v_[82] + v_[231] * v_[87] + v_[232] * v_[85] + v_[235] * v_[91] + v_[235] * v_[91];
    v_[204] = v_[206] * 0.057838 + (0 - v_[28]) * -0.012652 + v_[178] * -0.001387 + v_[182] * -0.018069;
    v_[212] = v_[28] * 0.009683 + (0 - v_[178]) * -0.001243 + v_[182] * -0.012652;
    v_[236] = (0 - v_[28]) * -0.001387;
    v_[237] = (0 - v_[182]) * -0.001243;
    v_[238] = v_[236] - v_[237];
    v_[193] = v_[193] * -0.038686875 + v_[178] * -0.000829 + v_[183] * 0.003227 + v_[230] * 0.000198;
    v_[239] = v_[178] * 1.5e-05 + v_[183] * 0.000198 + v_[230] * 0.010737;
    jac[68] = v_[192] * v_[83] + v_[166] * v_[94] + v_[193] * v_[98] + v_[239] * v_[87] + v_[235];
    v_[206] = v_[203] * -0.184 + v_[193] * v_[77] + v_[239] * v_[76] + v_[206] * -0.057838 + v_[28] * -0.012652 +
              v_[178] * -0.001387 + v_[182] * 0.019432;
    v_[238] = v_[235] + v_[214] * v_[78] + v_[215] * v_[81] + v_[136] * v_[64] + v_[204] * v_[71] + v_[212] * v_[55] +
              v_[238] * v_[58] + v_[238] * v_[58] + v_[206] * x_in[10];
    v_[235] = v_[188] * 0.038686875 + v_[178] * -0.00751 + (0 - v_[183]) * -0.000829 + v_[230] * 1.5e-05;
    v_[136] = (0 - v_[178]) * 0.000198;
    v_[234] = v_[197] + v_[136] - v_[234];
    v_[234] = v_[186] * v_[89] + v_[134] * v_[82] + v_[231] * v_[91] + v_[235] * v_[85] + v_[234] * v_[87] +
              v_[234] * v_[87] + v_[239] * x_in[11];
    v_[136] = 0 - v_[136] - v_[233];
    v_[136] = v_[202] * v_[89] + v_[213] * v_[94] + v_[232] * v_[91] + v_[235] * v_[87] + v_[136] * v_[85] +
              v_[136] * v_[85] - v_[193] * x_in[11];
    v_[235] = v_[196] * 0.057838 + v_[28] * -0.001243 + (0 - v_[178]) * -0.008386 + (0 - v_[182]) * -0.001387;
    v_[232] = v_[178] * -0.012652;
    v_[236] = 0 - v_[236] - v_[232];
    v_[230] = v_[188] * 0.038686875 + v_[178] * 0.009277 + v_[183] * -0.000829 + v_[230] * 1.5e-05 + v_[192] * v_[78] +
              v_[166] * v_[81] + v_[196] * 0.057838 + v_[28] * -0.001243 + v_[178] * 0.029115 + v_[182] * -0.001387;
    v_[236] = v_[168] * -0.184 + v_[234] * v_[77] + v_[136] * v_[76] + v_[216] * v_[64] + v_[235] * v_[71] +
              v_[212] * v_[58] + v_[236] * v_[55] + v_[236] * v_[55] - v_[230] * x_in[10];
    v_[212] = v_[31] * 0.0036857284 + v_[28] * 0.077424;
    v_[216] = (0 - v_[31]) * -0.0022920002 + v_[28] * -0.00021200017;
    v_[188] = (0 - v_[28]) * -0.0022920002;
    v_[183] = 0 - v_[188];
    v_[203] = v_[203] * 0.02075 + v_[193] * v_[86] + v_[239] * v_[77] + v_[28] * 0.011046 + v_[178] * -0.001243 +
              v_[182] * -0.012652 + v_[31] * 0.0036857284 + v_[28] * 0.081661;
    v_[183] = v_[125] * v_[68] + v_[218] * v_[61] + v_[238] * v_[52] + v_[236] * v_[53] + v_[219] * v_[46] +
              v_[225] * v_[64] + v_[212] * v_[47] + v_[216] * v_[32] + v_[183] * v_[35] + v_[183] * v_[35] +
              v_[203] * x_in[9];
    v_[232] = v_[232] + v_[237];
    v_[232] = v_[168] * 0.02075 + v_[234] * v_[86] + v_[136] * v_[77] + v_[156] * v_[69] + v_[217] * v_[80] +
              v_[204] * v_[58] + v_[235] * v_[55] + v_[232] * v_[71] + v_[232] * v_[71];
    jac[62] = v_[190] * v_[90] + v_[207] * v_[69] + v_[230] * v_[56] + v_[206] * v_[58] + v_[232];
    v_[235] = (0 - v_[31]) * 0.01404749 + (0 - v_[28]) * 0.0036857284;
    v_[204] = v_[31] * -0.00021200017;
    v_[217] = 0 - v_[204];
    v_[156] = v_[190] * v_[68] + v_[207] * v_[61] + v_[230] * v_[52] + v_[206] * v_[53] + v_[31] * 0.01828449 +
              v_[28] * 0.0036857284;
    v_[217] = v_[232] + v_[223] * v_[46] + v_[221] * v_[44] + v_[235] * v_[47] + v_[216] * v_[35] + v_[217] * v_[32] +
              v_[217] * v_[32] - v_[156] * x_in[9];
    v_[232] = v_[142] * v_[43] + v_[199] * v_[42] +
              (v_[190] * v_[67] + v_[207] * v_[60] + v_[230] * v_[53] + v_[206] * v_[54] + v_[31] * -0.0022920002 +
                  v_[28] * -0.00021200017) *
                  -1 -
              0.011715295;
    v_[228] = v_[228] * -0.304 + v_[183] * v_[28] + v_[217] * v_[30] + 0.011715295 * v_[23] +
              0.00750500000000001 * v_[12] + -5.399998e-05 * v_[15] + -5.399998e-05 * v_[15] + v_[232] * x_in[8];
    v_[204] = v_[204] + v_[188];
    v_[204] = v_[125] * v_[67] + v_[218] * v_[60] + v_[238] * v_[53] + v_[236] * v_[54] + v_[220] * v_[44] +
              v_[224] * v_[64] + v_[212] * v_[35] + v_[235] * v_[32] + v_[204] * v_[47] + v_[204] * v_[47];
    jac[56] = v_[142] * v_[65] + v_[199] * v_[44] + v_[156] * v_[33] + v_[203] * v_[35] + v_[204];
    v_[209] = v_[209] * -0.304 + v_[156] * v_[28] + v_[203] * v_[30] - 0.0037997814;
    v_[204] = v_[222] * v_[43] + v_[226] * v_[42] + v_[204] * -1 + -0.0037997814 * v_[23] +
              0.00750500000000001 * v_[15] + 5.399998e-05 * v_[12] + 5.399998e-05 * v_[12] - v_[209] * x_in[8];
    v_[235] = v_[156] * v_[31] + v_[203] * v_[28] + 0.010329999;
    v_[212] = v_[227] * v_[19] + v_[229] * v_[18] + v_[228] * v_[9] + v_[204] * v_[10] + v_[235] * x_in[7];
    v_[39] = v_[183] * v_[31] + v_[217] * v_[28] + 0.01438086 * v_[21] + -0.0055615274403 * v_[39] +
             0.011715295 * v_[15] + -0.0037997814 * v_[12];
    jac[50] = v_[191] * v_[40] + v_[194] * v_[21] + v_[209] * v_[13] + v_[232] * v_[15] + v_[39];
    v_[224] = v_[191] * v_[19] + v_[194] * v_[18] + v_[209] * v_[9] + v_[232] * v_[10];
    jac[44] =
        v_[227] * v_[20] + v_[229] * v_[38] + v_[228] * v_[10] + v_[204] * v_[11] + v_[224] * v_[2] + v_[235] * v_[5];
    v_[224] = v_[39] - v_[224] * x_in[7];
    jac[8] = 0 - ((v_[191] * v_[9] + v_[194] * v_[10]) * 9.81 + v_[212] * x_in[6]) * v_[151] +
             ((v_[142] * v_[63] + v_[199] * v_[28]) * 9.81 + v_[224] * x_in[6]) * v_[157];
    jac[38] = v_[212] * v_[4] + v_[224] * v_[0];
    v_[224] = v_[67] + v_[54] * -0.184;
    v_[212] = v_[54] * v_[77];
    v_[39] = v_[224] * 1.547475 + v_[212] * -0.038686875;
    v_[235] = v_[39] + v_[67] * 2.1032 + v_[54] * -0.057838;
    v_[220] = v_[60] * v_[77] + v_[53] * v_[78];
    v_[188] = v_[220] * 1.547475 + v_[53] * 0.038686875;
    v_[216] = v_[60] * v_[76] + v_[53] * v_[81];
    v_[223] = v_[216] * 1.547475;
    v_[221] = v_[188] * v_[77] + v_[223] * v_[76] + v_[60] * 2.1032 + v_[53] * 0.057838;
    v_[168] = v_[235] * v_[52] + v_[221] * v_[53] + 0.160298259823722;
    v_[237] = v_[188] * v_[79] + v_[223] * v_[77] + 0.008711861;
    v_[225] = v_[168] * v_[28] + v_[237] * v_[30];
    v_[219] = v_[235] * v_[53] + v_[221] * v_[62];
    v_[213] = v_[219] * -1;
    v_[202] = v_[216] * 1.547475;
    v_[233] = v_[220] * -1.547475;
    v_[231] = v_[53] * 0.038686875;
    v_[134] = v_[233] - v_[231];
    v_[186] = v_[202] * v_[87] + v_[134] * v_[85];
    v_[197] = v_[60] * 2.1032 + v_[53] * 0.057838;
    v_[240] = 0 - v_[197];
    v_[241] = v_[186] + v_[240] * v_[71] + v_[221] * x_in[10];
    v_[242] = 0 - v_[202];
    v_[243] = v_[224] * 1.547475 + (0 - v_[212]) * 0.038686875;
    v_[244] = v_[242] * v_[91] + v_[243] * v_[85] + v_[223] * x_in[11];
    v_[231] = 0 - v_[233] + v_[231];
    v_[233] = 0 - v_[243];
    v_[245] = v_[231] * v_[91] + v_[233] * v_[87] - v_[188] * x_in[11];
    v_[246] = v_[67] * -2.1032 + v_[54] * 0.057838;
    v_[247] = 0 - v_[246];
    v_[248] = v_[244] * v_[77] + v_[245] * v_[76] + v_[247] * v_[71] - v_[235] * x_in[10];
    v_[249] = v_[241] * v_[52] + v_[248] * v_[53] + -0.008711861 * v_[47] + v_[237] * x_in[9];
    v_[250] = v_[244] * v_[79] + v_[245] * v_[77] + v_[197] * v_[58] + v_[246] * v_[55] + 0.160298259823722 * v_[47] -
              v_[168] * x_in[9];
    v_[251] = v_[249] * v_[28] + v_[250] * v_[30] + v_[213] * x_in[8];
    v_[252] = v_[241] * v_[53] + v_[248] * v_[62] + 0.008711861 * v_[35] + -0.160298259823722 * v_[32];
    v_[253] = v_[252] * -1 - v_[225] * x_in[8];
    v_[254] = v_[54] * v_[76];
    v_[255] = (0 - v_[53]) * 1.5e-05 + v_[212] * 0.000198 + v_[254] * 0.00605;
    v_[256] = v_[224] * 0.038686875 + v_[53] * -0.000829 + (0 - v_[212]) * -0.00146 + (0 - v_[254]) * 0.000198;
    v_[216] = (0 - v_[216]) * 0.038686875;
    v_[257] = v_[212] * 1.5e-05;
    v_[258] = (0 - v_[254]) * -0.000829;
    v_[259] = v_[216] + v_[257] + v_[258];
    v_[259] =
        v_[242] * v_[94] + v_[231] * v_[82] + v_[255] * v_[87] + v_[256] * v_[85] + v_[259] * v_[91] + v_[259] * v_[91];
    v_[231] = v_[67] * 0.057838 + v_[53] * -0.001387 + v_[54] * -0.018069;
    v_[242] = (0 - v_[53]) * -0.001243 + v_[54] * -0.012652;
    v_[260] = (0 - v_[54]) * -0.001243;
    v_[261] = 0 - v_[260];
    v_[224] = v_[224] * -0.038686875 + v_[53] * -0.000829 + v_[212] * 0.003227 + v_[254] * 0.000198;
    v_[262] = v_[53] * 1.5e-05 + v_[212] * 0.000198 + v_[254] * 0.010737;
    jac[69] = v_[188] * v_[83] + v_[223] * v_[94] + v_[224] * v_[98] + v_[262] * v_[87] + v_[259];
    v_[263] = v_[39] * -0.184 + v_[224] * v_[77] + v_[262] * v_[76] + v_[67] * -0.057838 + v_[53] * -0.001387 +
              v_[54] * 0.019432;
    v_[261] = v_[259] + v_[244] * v_[78] + v_[245] * v_[81] + v_[197] * v_[64] + v_[231] * v_[71] + v_[242] * v_[55] +
              v_[261] * v_[58] + v_[261] * v_[58] + v_[263] * x_in[10];
    v_[259] = v_[220] * 0.038686875 + v_[53] * -0.00751 + (0 - v_[212]) * -0.000829 + v_[254] * 1.5e-05;
    v_[197] = (0 - v_[53]) * 0.000198;
    v_[258] = v_[216] + v_[197] - v_[258];
    v_[258] = v_[202] * v_[89] + v_[233] * v_[82] + v_[255] * v_[91] + v_[259] * v_[85] + v_[258] * v_[87] +
              v_[258] * v_[87] + v_[262] * x_in[11];
    v_[197] = 0 - v_[197] - v_[257];
    v_[197] = v_[134] * v_[89] + v_[243] * v_[94] + v_[256] * v_[91] + v_[259] * v_[87] + v_[197] * v_[85] +
              v_[197] * v_[85] - v_[224] * x_in[11];
    v_[259] = v_[60] * 0.057838 + (0 - v_[53]) * -0.008386 + (0 - v_[54]) * -0.001387;
    v_[256] = v_[53] * -0.012652;
    v_[243] = 0 - v_[256];
    v_[254] = v_[220] * 0.038686875 + v_[53] * 0.009277 + v_[212] * -0.000829 + v_[254] * 1.5e-05 + v_[188] * v_[78] +
              v_[223] * v_[81] + v_[60] * 0.057838 + v_[53] * 0.029115 + v_[54] * -0.001387;
    v_[243] = v_[186] * -0.184 + v_[258] * v_[77] + v_[197] * v_[76] + v_[246] * v_[64] + v_[259] * v_[71] +
              v_[242] * v_[58] + v_[243] * v_[55] + v_[243] * v_[55] - v_[254] * x_in[10];
    v_[39] = v_[39] * 0.02075 + v_[224] * v_[86] + v_[262] * v_[77] + v_[53] * -0.001243 + v_[54] * -0.012652 -
             0.00021200017;
    v_[242] = v_[241] * v_[68] + v_[248] * v_[61] + v_[261] * v_[52] + v_[243] * v_[53] + 0.008711861 * v_[46] +
              0.00021200017 * v_[47] + -0.06337651 * v_[32] + -0.0036857284 * v_[35] + -0.0036857284 * v_[35] +
              v_[39] * x_in[9];
    v_[256] = v_[256] + v_[260];
    v_[256] = v_[186] * 0.02075 + v_[258] * v_[86] + v_[197] * v_[77] + v_[240] * v_[69] + v_[247] * v_[80] +
              v_[231] * v_[58] + v_[259] * v_[55] + v_[256] * v_[71] + v_[256] * v_[71];
    jac[63] = v_[235] * v_[90] + v_[221] * v_[69] + v_[254] * v_[56] + v_[263] * v_[58] + v_[256];
    v_[259] = v_[235] * v_[68] + v_[221] * v_[61] + v_[254] * v_[52] + v_[263] * v_[53] - 0.0022920002;
    v_[256] = v_[256] + -0.160298259823722 * v_[46] + -0.0022920002 * v_[47] + -0.06337651 * v_[35] +
              0.0036857284 * v_[32] + 0.0036857284 * v_[32] - v_[259] * x_in[9];
    v_[231] = v_[168] * v_[43] + v_[237] * v_[42] +
              (v_[235] * v_[67] + v_[221] * v_[60] + v_[254] * v_[53] + v_[263] * v_[54] + 0.09570849) * -1;
    v_[252] = v_[252] * -0.304 + v_[242] * v_[28] + v_[256] * v_[30] + v_[231] * x_in[8];
    v_[32] = v_[241] * v_[67] + v_[248] * v_[60] + v_[261] * v_[53] + v_[243] * v_[54] + -0.008711861 * v_[44] +
             0.160298259823722 * v_[64] + 0.00021200017 * v_[35] + -0.0022920002 * v_[32];
    jac[57] = v_[168] * v_[65] + v_[237] * v_[44] + v_[259] * v_[33] + v_[39] * v_[35] + v_[32];
    v_[219] = v_[219] * -0.304 + v_[259] * v_[28] + v_[39] * v_[30];
    v_[32] = v_[249] * v_[43] + v_[250] * v_[42] + v_[32] * -1 - v_[219] * x_in[8];
    v_[247] = v_[259] * v_[31] + v_[39] * v_[28];
    v_[240] = v_[251] * v_[19] + v_[253] * v_[18] + v_[252] * v_[9] + v_[32] * v_[10] + v_[247] * x_in[7];
    v_[186] = v_[242] * v_[31] + v_[256] * v_[28];
    jac[51] = v_[225] * v_[40] + v_[213] * v_[21] + v_[219] * v_[13] + v_[231] * v_[15] + v_[186];
    v_[260] = v_[225] * v_[19] + v_[213] * v_[18] + v_[219] * v_[9] + v_[231] * v_[10];
    jac[45] =
        v_[251] * v_[20] + v_[253] * v_[38] + v_[252] * v_[10] + v_[32] * v_[11] + v_[260] * v_[2] + v_[247] * v_[5];
    v_[260] = v_[186] - v_[260] * x_in[7];
    jac[9] = 0 - ((v_[225] * v_[9] + v_[213] * v_[10]) * 9.81 + v_[240] * x_in[6]) * v_[151] +
             ((v_[168] * v_[63] + v_[237] * v_[28]) * 9.81 + v_[260] * x_in[6]) * v_[157];
    jac[39] = v_[240] * v_[4] + v_[260] * v_[0];
    v_[260] = 0.03211010625 + v_[86] * -0.038686875;
    v_[240] = v_[260] * v_[52];
    v_[186] = v_[240] * v_[28];
    v_[247] = v_[260] * v_[53];
    v_[246] = v_[247] * -1;
    v_[220] = 0.03211010625 + (0 - v_[86]) * 0.038686875;
    v_[212] = v_[220] * v_[85];
    v_[134] = 0 - v_[220];
    v_[257] = v_[134] * v_[87];
    v_[255] = v_[212] * v_[77] + v_[257] * v_[76] - v_[260] * x_in[10];
    v_[233] = v_[255] * v_[53];
    v_[202] = v_[212] * v_[79] + v_[257] * v_[77] - v_[240] * x_in[9];
    v_[216] = v_[233] * v_[28] + v_[202] * v_[30] + v_[246] * x_in[8];
    v_[264] = v_[255] * v_[62];
    v_[265] = v_[264] * -1 - v_[186] * x_in[8];
    v_[266] = v_[86] * 0.000198 + v_[77] * 0.00605;
    v_[267] = 0.00080275265625 + (0 - v_[86]) * -0.00146 + (0 - v_[77]) * 0.000198;
    v_[268] = v_[86] * 1.5e-05;
    v_[269] = (0 - v_[77]) * -0.000829;
    v_[270] = v_[268] + v_[269];
    v_[270] = v_[266] * v_[87] + v_[267] * v_[85] + v_[270] * v_[91] + v_[270] * v_[91];
    v_[271] = -0.00080275265625 + v_[86] * 0.003227 + v_[77] * 0.000198;
    v_[272] = v_[86] * 0.000198 + v_[77] * 0.010737;
    jac[70] = v_[271] * v_[98] + v_[272] * v_[87] + v_[270];
    v_[273] = v_[260] * -0.184 + v_[271] * v_[77] + v_[272] * v_[76] - 0.012652;
    v_[270] = v_[270] + v_[212] * v_[78] + v_[257] * v_[81] + 0.012652 * v_[71] + 0.009683 * v_[55] +
              0.001387 * v_[58] + 0.001387 * v_[58] + v_[273] * x_in[10];
    v_[274] = (0 - v_[86]) * -0.000829 + v_[77] * 1.5e-05;
    v_[269] = 0 - v_[269];
    v_[269] = v_[134] * v_[82] + v_[266] * v_[91] + v_[274] * v_[85] + v_[269] * v_[87] + v_[269] * v_[87] +
              v_[272] * x_in[11];
    v_[268] = 0 - v_[268];
    v_[268] = v_[220] * v_[94] + v_[267] * v_[91] + v_[274] * v_[87] + v_[268] * v_[85] + v_[268] * v_[85] -
              v_[271] * x_in[11];
    v_[274] = v_[86] * -0.000829 + v_[77] * 1.5e-05 - 0.001243;
    v_[267] = v_[269] * v_[77] + v_[268] * v_[76] + -0.001243 * v_[71] + 0.009683 * v_[58] + -0.001387 * v_[55] +
              -0.001387 * v_[55] - v_[274] * x_in[10];
    v_[220] = v_[260] * 0.02075 + v_[271] * v_[86] + v_[272] * v_[77] + 0.011046;
    v_[94] = v_[255] * v_[61] + v_[270] * v_[52] + v_[267] * v_[53] + v_[220] * x_in[9];
    v_[266] = v_[269] * v_[86] + v_[268] * v_[77] + 0.012652 * v_[58] + -0.001243 * v_[55];
    jac[64] = v_[260] * v_[90] + v_[274] * v_[56] + v_[273] * v_[58] + v_[266];
    v_[90] = v_[260] * v_[68] + v_[274] * v_[52] + v_[273] * v_[53];
    v_[266] = v_[266] - v_[90] * x_in[9];
    v_[134] = v_[240] * v_[43] + (v_[260] * v_[67] + v_[274] * v_[53] + v_[273] * v_[54]) * -1;
    v_[264] = v_[264] * -0.304 + v_[94] * v_[28] + v_[266] * v_[30] + v_[134] * x_in[8];
    v_[275] = v_[255] * v_[60] + v_[270] * v_[53] + v_[267] * v_[54];
    jac[58] = v_[240] * v_[65] + v_[90] * v_[33] + v_[220] * v_[35] + v_[275];
    v_[247] = v_[247] * -0.304 + v_[90] * v_[28] + v_[220] * v_[30];
    v_[275] = v_[233] * v_[43] + v_[202] * v_[42] + v_[275] * -1 - v_[247] * x_in[8];
    v_[276] = v_[90] * v_[31] + v_[220] * v_[28];
    v_[277] = v_[216] * v_[19] + v_[265] * v_[18] + v_[264] * v_[9] + v_[275] * v_[10] + v_[276] * x_in[7];
    v_[278] = v_[94] * v_[31] + v_[266] * v_[28];
    jac[52] = v_[186] * v_[40] + v_[246] * v_[21] + v_[247] * v_[13] + v_[134] * v_[15] + v_[278];
    v_[279] = v_[186] * v_[19] + v_[246] * v_[18] + v_[247] * v_[9] + v_[134] * v_[10];
    jac[46] =
        v_[216] * v_[20] + v_[265] * v_[38] + v_[264] * v_[10] + v_[275] * v_[11] + v_[279] * v_[2] + v_[276] * v_[5];
    v_[279] = v_[278] - v_[279] * x_in[7];
    jac[10] = 0 - ((v_[186] * v_[9] + v_[246] * v_[10]) * 9.81 + v_[277] * x_in[6]) * v_[151] +
              (v_[240] * v_[63] * 9.81 + v_[279] * x_in[6]) * v_[157];
    jac[40] = v_[277] * v_[4] + v_[279] * v_[0];
    v_[279] = 0.038686875 * v_[77];
    v_[277] = v_[279] * v_[53];
    v_[79] = 0.038686875 * v_[79];
    v_[278] = v_[277] * v_[28] + v_[79] * v_[30];
    v_[276] = v_[279] * v_[62];
    v_[280] = v_[276] * -1;
    v_[281] = -0.038686875 * v_[85];
    v_[282] = v_[281] + v_[279] * x_in[10];
    v_[283] = 0.038686875 * v_[91] - 0.038686875 * x_in[11];
    v_[284] = v_[283] * v_[76];
    v_[285] = v_[282] * v_[52] + v_[284] * v_[53] + v_[79] * x_in[9];
    v_[286] = v_[283] * v_[77] - v_[277] * x_in[9];
    v_[287] = v_[285] * v_[28] + v_[286] * v_[30] + v_[280] * x_in[8];
    v_[62] = v_[282] * v_[53] + v_[284] * v_[62];
    v_[288] = v_[62] * -1 - v_[278] * x_in[8];
    v_[82] = 0.038686875 * v_[82] + -1.5e-05 * v_[87] + -0.000829 * v_[85];
    jac[71] = 0.038686875 * v_[83] + -0.000829 * v_[98] + 1.5e-05 * v_[87] + v_[82];
    v_[98] = -0.000829 * v_[77] + 1.5e-05 * v_[76];
    v_[82] = v_[82] + v_[283] * v_[81] + v_[98] * x_in[10];
    v_[81] = -1.5e-05 * v_[91] + -0.00751 * v_[85] + -0.000198 * v_[87] + -0.000198 * v_[87] + 1.5e-05 * x_in[11];
    v_[91] = -0.038686875 * v_[89] + -0.000829 * v_[91] + -0.00751 * v_[87] + 0.000198 * v_[85] + 0.000198 * v_[85] -
             -0.000829 * x_in[11];
    v_[78] = 0.009277 + 0.038686875 * v_[78];
    v_[76] = v_[281] * -0.184 + v_[81] * v_[77] + v_[91] * v_[76] - v_[78] * x_in[10];
    v_[89] = -0.000829 * v_[86] + 1.5e-05 * v_[77];
    v_[68] = v_[282] * v_[68] + v_[284] * v_[61] + v_[82] * v_[52] + v_[76] * v_[53] + v_[89] * x_in[9];
    v_[281] = v_[281] * 0.02075 + v_[81] * v_[86] + v_[91] * v_[77];
    jac[65] = v_[279] * v_[69] + v_[78] * v_[56] + v_[98] * v_[58] + v_[281];
    v_[61] = v_[279] * v_[61] + v_[78] * v_[52] + v_[98] * v_[53];
    v_[281] = v_[281] - v_[61] * x_in[9];
    v_[52] = v_[277] * v_[43] + v_[79] * v_[42] + (v_[279] * v_[60] + v_[78] * v_[53] + v_[98] * v_[54]) * -1;
    v_[62] = v_[62] * -0.304 + v_[68] * v_[28] + v_[281] * v_[30] + v_[52] * x_in[8];
    v_[67] = v_[282] * v_[67] + v_[284] * v_[60] + v_[82] * v_[53] + v_[76] * v_[54];
    jac[59] = v_[277] * v_[65] + v_[79] * v_[44] + v_[61] * v_[33] + v_[89] * v_[35] + v_[67];
    v_[276] = v_[276] * -0.304 + v_[61] * v_[28] + v_[89] * v_[30];
    v_[67] = v_[285] * v_[43] + v_[286] * v_[42] + v_[67] * -1 - v_[276] * x_in[8];
    v_[43] = v_[61] * v_[31] + v_[89] * v_[28];
    v_[42] = v_[287] * v_[19] + v_[288] * v_[18] + v_[62] * v_[9] + v_[67] * v_[10] + v_[43] * x_in[7];
    v_[30] = v_[68] * v_[31] + v_[281] * v_[28];
    jac[53] = v_[278] * v_[40] + v_[280] * v_[21] + v_[276] * v_[13] + v_[52] * v_[15] + v_[30];
    v_[19] = v_[278] * v_[19] + v_[280] * v_[18] + v_[276] * v_[9] + v_[52] * v_[10];
    jac[47] = v_[287] * v_[20] + v_[288] * v_[38] + v_[62] * v_[10] + v_[67] * v_[11] + v_[19] * v_[2] + v_[43] * v_[5];
    v_[19] = v_[30] - v_[19] * x_in[7];
    jac[11] = 0 - ((v_[278] * v_[9] + v_[280] * v_[10]) * 9.81 + v_[42] * x_in[6]) * v_[151] +
              ((v_[277] * v_[63] + v_[79] * v_[28]) * 9.81 + v_[19] * x_in[6]) * v_[157];
    jac[41] = v_[42] * v_[4] + v_[19] * v_[0];
    v_[19] = sin(x_in[2]);
    v_[42] = cos(x_in[2]);
    jac[12] = 0 -
              (v_[4] * v_[109] + v_[130] * v_[17] + v_[131] * v_[3] + v_[137] * v_[5] + v_[162] * x_in[7] * 0.112 +
                  (v_[4] * v_[84] + v_[132] * v_[3] + v_[164] * v_[5]) * 0.112 - v_[152] * x_in[7]) *
                  v_[19] +
              (v_[4] * v_[105] + v_[132] * v_[17] + v_[173] * v_[3] + v_[137] * x_in[7] + v_[152] * v_[5] +
                  (v_[4] * v_[111] + v_[130] * v_[3] + v_[162] * v_[5]) * -0.112 + v_[164] * x_in[7] * 0.112) *
                  v_[42];
    jac[13] = 0 -
              (v_[155] * v_[17] + v_[158] * v_[3] + v_[138] * v_[5] + (v_[111] + v_[198] * x_in[7]) * 0.112 +
                  (v_[150] * v_[3] + v_[200] * v_[5]) * 0.112 - (v_[105] + v_[187] * x_in[7])) *
                  v_[19] +
              (v_[109] + v_[150] * v_[17] + v_[133] * v_[3] + v_[138] * x_in[7] + v_[187] * v_[5] +
                  (v_[155] * v_[3] + v_[198] * v_[5]) * -0.112 + (v_[84] + v_[200] * x_in[7]) * 0.112) *
                  v_[42];
    jac[14] = 0 -
              (v_[191] * v_[17] + v_[209] * v_[3] + v_[228] * v_[5] + v_[227] * x_in[7] * 0.112 +
                  (v_[194] * v_[3] + v_[229] * v_[5]) * 0.112 - v_[204] * x_in[7]) *
                  v_[19] +
              (v_[194] * v_[17] + v_[232] * v_[3] + v_[228] * x_in[7] + v_[204] * v_[5] +
                  (v_[191] * v_[3] + v_[227] * v_[5]) * -0.112 + v_[229] * x_in[7] * 0.112) *
                  v_[42];
    jac[15] = 0 -
              (v_[225] * v_[17] + v_[219] * v_[3] + v_[252] * v_[5] + v_[251] * x_in[7] * 0.112 +
                  (v_[213] * v_[3] + v_[253] * v_[5]) * 0.112 - v_[32] * x_in[7]) *
                  v_[19] +
              (v_[213] * v_[17] + v_[231] * v_[3] + v_[252] * x_in[7] + v_[32] * v_[5] +
                  (v_[225] * v_[3] + v_[251] * v_[5]) * -0.112 + v_[253] * x_in[7] * 0.112) *
                  v_[42];
    jac[16] = 0 -
              (v_[186] * v_[17] + v_[247] * v_[3] + v_[264] * v_[5] + v_[216] * x_in[7] * 0.112 +
                  (v_[246] * v_[3] + v_[265] * v_[5]) * 0.112 - v_[275] * x_in[7]) *
                  v_[19] +
              (v_[246] * v_[17] + v_[134] * v_[3] + v_[264] * x_in[7] + v_[275] * v_[5] +
                  (v_[186] * v_[3] + v_[216] * v_[5]) * -0.112 + v_[265] * x_in[7] * 0.112) *
                  v_[42];
    jac[17] = 0 -
              (v_[278] * v_[17] + v_[276] * v_[3] + v_[62] * v_[5] + v_[287] * x_in[7] * 0.112 +
                  (v_[280] * v_[3] + v_[288] * v_[5]) * 0.112 - v_[67] * x_in[7]) *
                  v_[19] +
              (v_[280] * v_[17] + v_[52] * v_[3] + v_[62] * x_in[7] + v_[67] * v_[5] +
                  (v_[278] * v_[3] + v_[287] * v_[5]) * -0.112 + v_[288] * x_in[7] * 0.112) *
                  v_[42];
    v_[42] = sin(x_in[3]);
    v_[19] = cos(x_in[3]);
    jac[18] =
        0 -
        (v_[101] * v_[112] + v_[0] * v_[108] + v_[96] * v_[100] + v_[128] * v_[41] + v_[129] * v_[7] +
            v_[140] * v_[14] + v_[118] * v_[6] + v_[153] * v_[21] + v_[143] * v_[15] + v_[117] * v_[23] +
            (v_[51] * v_[112] + v_[128] * v_[16] + v_[153] * v_[12]) * -0.304) *
            v_[42] +
        (v_[101] * v_[107] + v_[96] * v_[108] + v_[129] * v_[41] + v_[118] * v_[14] + v_[159] * v_[21] +
            v_[117] * v_[15] - v_[128] * v_[7] + (v_[51] * v_[107] + v_[129] * v_[16] + v_[159] * v_[12]) * -0.304 -
            (v_[0] * v_[100] + v_[140] * v_[6] + v_[143] * v_[23])) *
            v_[19];
    jac[19] =
        0 -
        (v_[20] * v_[112] + v_[10] * v_[100] + v_[123] * v_[41] + v_[163] * v_[7] + v_[176] * v_[14] + v_[25] * v_[6] +
            v_[189] * v_[21] + v_[179] * v_[15] + v_[27] * v_[23] +
            (v_[11] * v_[112] + v_[123] * v_[16] + v_[189] * v_[12]) * -0.304) *
            v_[42] +
        (v_[20] * v_[107] + v_[10] * v_[108] + v_[163] * v_[41] + v_[25] * v_[14] + v_[195] * v_[21] + v_[27] * v_[15] -
            v_[123] * v_[7] + (v_[11] * v_[107] + v_[163] * v_[16] + v_[195] * v_[12]) * -0.304 -
            (v_[176] * v_[6] + v_[179] * v_[23])) *
            v_[19];
    jac[20] = 0 -
              (v_[108] + v_[142] * v_[41] + v_[199] * v_[7] + v_[156] * v_[14] + v_[203] * v_[6] + v_[222] * v_[21] +
                  v_[183] * v_[15] + v_[217] * v_[23] + (v_[142] * v_[16] + v_[222] * v_[12]) * -0.304) *
                  v_[42] +
              (v_[199] * v_[41] + v_[203] * v_[14] + v_[226] * v_[21] + v_[217] * v_[15] - v_[142] * v_[7] +
                  (v_[199] * v_[16] + v_[226] * v_[12]) * -0.304 - (v_[100] + v_[156] * v_[6] + v_[183] * v_[23])) *
                  v_[19];
    jac[21] = 0 -
              (v_[168] * v_[41] + v_[237] * v_[7] + v_[259] * v_[14] + v_[39] * v_[6] + v_[249] * v_[21] +
                  v_[242] * v_[15] + v_[256] * v_[23] + (v_[168] * v_[16] + v_[249] * v_[12]) * -0.304) *
                  v_[42] +
              (v_[237] * v_[41] + v_[39] * v_[14] + v_[250] * v_[21] + v_[256] * v_[15] - v_[168] * v_[7] +
                  (v_[237] * v_[16] + v_[250] * v_[12]) * -0.304 - (v_[259] * v_[6] + v_[242] * v_[23])) *
                  v_[19];
    jac[22] = 0 -
              (v_[240] * v_[41] + v_[90] * v_[14] + v_[220] * v_[6] + v_[233] * v_[21] + v_[94] * v_[15] +
                  v_[266] * v_[23] + (v_[240] * v_[16] + v_[233] * v_[12]) * -0.304) *
                  v_[42] +
              (v_[220] * v_[14] + v_[202] * v_[21] + v_[266] * v_[15] - v_[240] * v_[7] + v_[202] * v_[12] * -0.304 -
                  (v_[90] * v_[6] + v_[94] * v_[23])) *
                  v_[19];
    jac[23] = 0 -
              (v_[277] * v_[41] + v_[79] * v_[7] + v_[61] * v_[14] + v_[89] * v_[6] + v_[285] * v_[21] +
                  v_[68] * v_[15] + v_[281] * v_[23] + (v_[277] * v_[16] + v_[285] * v_[12]) * -0.304) *
                  v_[42] +
              (v_[79] * v_[41] + v_[89] * v_[14] + v_[286] * v_[21] + v_[281] * v_[15] - v_[277] * v_[7] +
                  (v_[79] * v_[16] + v_[286] * v_[12]) * -0.304 - (v_[61] * v_[6] + v_[68] * v_[23])) *
                  v_[19];
    v_[19] = sin(x_in[4]);
    v_[42] = cos(x_in[4]);
    jac[24] =
        0 -
        (v_[49] * v_[106] + v_[50] * v_[92] + v_[119] * v_[66] + v_[165] * v_[34] + v_[141] * v_[44] +
            v_[174] * v_[35] + (v_[48] * v_[106] + v_[119] * v_[29] + v_[141] * v_[47]) * 0.112 -
            (v_[99] * v_[72] + v_[127] * v_[37] + v_[149] * v_[46]) +
            (v_[50] * v_[72] + v_[127] * v_[34] + v_[149] * v_[35]) * 0.112 -
            (v_[48] * v_[74] + v_[113] * v_[29] + v_[172] * v_[47])) *
            v_[19] +
        (v_[99] * v_[106] + v_[49] * v_[72] + v_[48] * v_[92] + v_[50] * v_[74] + v_[119] * v_[37] + v_[127] * v_[66] +
            v_[165] * v_[29] + v_[113] * v_[34] + v_[141] * v_[46] + v_[149] * v_[44] + v_[174] * v_[47] +
            v_[172] * v_[35] + (v_[50] * v_[106] + v_[119] * v_[34] + v_[141] * v_[35]) * -0.112 +
            (v_[48] * v_[72] + v_[127] * v_[29] + v_[149] * v_[47]) * 0.112) *
            v_[42];
    jac[25] =
        0 -
        (v_[161] * v_[106] + v_[26] * v_[92] + v_[24] * v_[66] + v_[201] * v_[34] + v_[177] * v_[44] +
            v_[210] * v_[35] + (v_[88] * v_[106] + v_[24] * v_[29] + v_[177] * v_[47]) * 0.112 -
            (v_[154] * v_[72] + v_[171] * v_[37] + v_[185] * v_[46]) +
            (v_[26] * v_[72] + v_[171] * v_[34] + v_[185] * v_[35]) * 0.112 -
            (v_[88] * v_[74] + v_[75] * v_[29] + v_[208] * v_[47])) *
            v_[19] +
        (v_[154] * v_[106] + v_[161] * v_[72] + v_[88] * v_[92] + v_[26] * v_[74] + v_[24] * v_[37] + v_[171] * v_[66] +
            v_[201] * v_[29] + v_[75] * v_[34] + v_[177] * v_[46] + v_[185] * v_[44] + v_[210] * v_[47] +
            v_[208] * v_[35] + (v_[26] * v_[106] + v_[24] * v_[34] + v_[177] * v_[35]) * -0.112 +
            (v_[88] * v_[72] + v_[171] * v_[29] + v_[185] * v_[47]) * 0.112) *
            v_[42];
    jac[26] =
        0 -
        (v_[31] * v_[92] + v_[190] * v_[66] + v_[230] * v_[34] + v_[125] * v_[44] + v_[238] * v_[35] +
            (v_[190] * v_[29] + v_[125] * v_[47]) * 0.112 - (v_[207] * v_[37] + v_[218] * v_[46]) +
            (v_[31] * v_[72] + v_[207] * v_[34] + v_[218] * v_[35]) * 0.112 - (v_[206] * v_[29] + v_[236] * v_[47])) *
            v_[19] +
        (v_[31] * v_[74] + v_[190] * v_[37] + v_[207] * v_[66] + v_[230] * v_[29] + v_[206] * v_[34] +
            v_[125] * v_[46] + v_[218] * v_[44] + v_[238] * v_[47] + v_[236] * v_[35] +
            (v_[31] * v_[106] + v_[190] * v_[34] + v_[125] * v_[35]) * -0.112 +
            (v_[207] * v_[29] + v_[218] * v_[47]) * 0.112) *
            v_[42];
    jac[27] =
        0 -
        (v_[235] * v_[66] + v_[254] * v_[34] + v_[241] * v_[44] + v_[261] * v_[35] +
            (v_[106] + v_[235] * v_[29] + v_[241] * v_[47]) * 0.112 - (v_[221] * v_[37] + v_[248] * v_[46]) +
            (v_[221] * v_[34] + v_[248] * v_[35]) * 0.112 - (v_[74] + v_[263] * v_[29] + v_[243] * v_[47])) *
            v_[19] +
        (v_[92] + v_[235] * v_[37] + v_[221] * v_[66] + v_[254] * v_[29] + v_[263] * v_[34] + v_[241] * v_[46] +
            v_[248] * v_[44] + v_[261] * v_[47] + v_[243] * v_[35] + (v_[235] * v_[34] + v_[241] * v_[35]) * -0.112 +
            (v_[72] + v_[221] * v_[29] + v_[248] * v_[47]) * 0.112) *
            v_[42];
    jac[28] = 0 -
              (v_[260] * v_[66] + v_[274] * v_[34] + v_[270] * v_[35] + v_[260] * v_[29] * 0.112 - v_[255] * v_[46] +
                  v_[255] * v_[35] * 0.112 - (v_[273] * v_[29] + v_[267] * v_[47])) *
                  v_[19] +
              (v_[260] * v_[37] + v_[274] * v_[29] + v_[273] * v_[34] + v_[255] * v_[44] + v_[270] * v_[47] +
                  v_[267] * v_[35] + v_[260] * v_[34] * -0.112 + v_[255] * v_[47] * 0.112) *
                  v_[42];
    jac[29] =
        0 -
        (v_[78] * v_[34] + v_[282] * v_[44] + v_[82] * v_[35] + v_[282] * v_[47] * 0.112 -
            (v_[279] * v_[37] + v_[284] * v_[46]) + (v_[279] * v_[34] + v_[284] * v_[35]) * 0.112 -
            (v_[98] * v_[29] + v_[76] * v_[47])) *
            v_[19] +
        (v_[279] * v_[66] + v_[78] * v_[29] + v_[98] * v_[34] + v_[282] * v_[46] + v_[284] * v_[44] + v_[82] * v_[47] +
            v_[76] * v_[35] + v_[282] * v_[35] * -0.112 + (v_[279] * v_[29] + v_[284] * v_[47]) * 0.112) *
            v_[42];
    v_[42] = v_[122] * v_[93] + v_[124] * v_[57] + v_[144] * v_[58];
    v_[122] = v_[122] * v_[97] + v_[126] * v_[57] + v_[145] * v_[58];
    v_[19] = sin(x_in[5]);
    v_[76] = cos(x_in[5]);
    jac[30] = 0 -
              (v_[120] * v_[97] + v_[121] * v_[93] + v_[114] * v_[102] + v_[115] * v_[103] + v_[124] * v_[70] +
                  v_[126] * v_[45] + v_[116] * v_[59] + v_[175] * v_[36] + v_[144] * v_[80] + v_[145] * v_[64] +
                  v_[169] * v_[55] + v_[148] * v_[71] + v_[42] * 0.184 + (0 - v_[122]) * 0.02075) *
                  v_[19] +
              (v_[121] * v_[97] + v_[115] * v_[102] + v_[126] * v_[70] + v_[175] * v_[59] + v_[145] * v_[80] +
                  v_[148] * v_[55] - (v_[120] * v_[93] + v_[124] * v_[45] + v_[144] * v_[64]) + v_[42] * 0.02075 +
                  v_[122] * 0.184 - (v_[114] * v_[103] + v_[116] * v_[36] + v_[169] * v_[71])) *
                  v_[76];
    v_[122] = v_[147] * v_[93] + v_[139] * v_[57] + v_[180] * v_[58];
    v_[147] = v_[147] * v_[97] + v_[135] * v_[57] + v_[181] * v_[58];
    jac[31] = 0 -
              (v_[22] * v_[97] + v_[8] * v_[93] + v_[110] * v_[102] + v_[73] * v_[103] + v_[139] * v_[70] +
                  v_[135] * v_[45] + v_[104] * v_[59] + v_[211] * v_[36] + v_[180] * v_[80] + v_[181] * v_[64] +
                  v_[205] * v_[55] + v_[184] * v_[71] + v_[122] * 0.184 + (0 - v_[147]) * 0.02075) *
                  v_[19] +
              (v_[8] * v_[97] + v_[73] * v_[102] + v_[135] * v_[70] + v_[211] * v_[59] + v_[181] * v_[80] +
                  v_[184] * v_[55] - (v_[22] * v_[93] + v_[139] * v_[45] + v_[180] * v_[64]) + v_[122] * 0.02075 +
                  v_[147] * 0.184 - (v_[110] * v_[103] + v_[104] * v_[36] + v_[205] * v_[71])) *
                  v_[76];
    v_[147] = v_[178] * v_[93] + v_[192] * v_[57] + v_[214] * v_[58];
    v_[178] = v_[178] * v_[97] + v_[166] * v_[57] + v_[215] * v_[58];
    jac[32] = 0 -
              (v_[196] * v_[93] + v_[28] * v_[102] + v_[182] * v_[103] + v_[192] * v_[70] + v_[166] * v_[45] +
                  v_[193] * v_[59] + v_[239] * v_[36] + v_[214] * v_[80] + v_[215] * v_[64] + v_[234] * v_[55] +
                  v_[136] * v_[71] + v_[147] * 0.184 + (0 - v_[178]) * 0.02075) *
                  v_[19] +
              (v_[196] * v_[97] + v_[182] * v_[102] + v_[166] * v_[70] + v_[239] * v_[59] + v_[215] * v_[80] +
                  v_[136] * v_[55] - (v_[192] * v_[45] + v_[214] * v_[64]) + v_[147] * 0.02075 + v_[178] * 0.184 -
                  (v_[28] * v_[103] + v_[193] * v_[36] + v_[234] * v_[71])) *
                  v_[76];
    v_[178] = v_[53] * v_[93] + v_[188] * v_[57] + v_[244] * v_[58];
    v_[53] = v_[53] * v_[97] + v_[223] * v_[57] + v_[245] * v_[58];
    jac[33] = 0 -
              (v_[60] * v_[93] + v_[54] * v_[103] + v_[188] * v_[70] + v_[223] * v_[45] + v_[224] * v_[59] +
                  v_[262] * v_[36] + v_[244] * v_[80] + v_[245] * v_[64] + v_[258] * v_[55] + v_[197] * v_[71] +
                  v_[178] * 0.184 + (0 - v_[53]) * 0.02075) *
                  v_[19] +
              (v_[60] * v_[97] + v_[54] * v_[102] + v_[223] * v_[70] + v_[262] * v_[59] + v_[245] * v_[80] +
                  v_[197] * v_[55] - (v_[188] * v_[45] + v_[244] * v_[64]) + v_[178] * 0.02075 + v_[53] * 0.184 -
                  (v_[224] * v_[36] + v_[258] * v_[71])) *
                  v_[76];
    v_[53] = v_[212] * v_[58];
    v_[178] = v_[257] * v_[58];
    jac[34] = 0 -
              (v_[102] + v_[271] * v_[59] + v_[272] * v_[36] + v_[212] * v_[80] + v_[257] * v_[64] + v_[269] * v_[55] +
                  v_[268] * v_[71] + v_[53] * 0.184 + (0 - v_[178]) * 0.02075) *
                  v_[19] +
              (v_[272] * v_[59] + v_[257] * v_[80] + v_[268] * v_[55] - v_[212] * v_[64] + v_[53] * 0.02075 +
                  v_[178] * 0.184 - (v_[103] + v_[271] * v_[36] + v_[269] * v_[71])) *
                  v_[76];
    v_[57] = 0.038686875 * v_[57];
    v_[58] = v_[283] * v_[58];
    jac[35] = 0 -
              (0.038686875 * v_[70] + -0.000829 * v_[59] + 1.5e-05 * v_[36] + v_[283] * v_[64] + v_[81] * v_[55] +
                  v_[91] * v_[71] + v_[57] * 0.184 + (0 - v_[58]) * 0.02075) *
                  v_[19] +
              (1.5e-05 * v_[59] + v_[283] * v_[80] + v_[91] * v_[55] - 0.038686875 * v_[45] + v_[57] * 0.02075 +
                  v_[58] * 0.184 - (-0.000829 * v_[36] + v_[81] * v_[71])) *
                  v_[76];
    v_[167] = v_[167] + v_[146];
    jac[42] = v_[162] * v_[20] + v_[164] * v_[38] + v_[137] * v_[10] + v_[152] * v_[11] + v_[170] * v_[1] +
              v_[167] * x_in[7] + v_[167] * x_in[7] + v_[160] * v_[2] + v_[95] * v_[5];


    return jac_;
}
}  // namespace HyA
}  // namespace models
}  // namespace ct
