/**********************************************************************************************************************
This file is part of the Control Toolbox (https://adrlab.bitbucket.io/ct), copyright by ETH Zurich, Google Inc.
Authors:  Michael Neunert, Markus Giftthaler, Markus Stäuble, Diego Pardo, Farbod Farshidian
Licensed under Apache2 license (see LICENSE file in main directory)
**********************************************************************************************************************/
#include "HyAInverseDynJacForward.h"

namespace ct {
namespace models {
namespace HyA {


HyAInverseDynJacForward::JAC_TYPE HyAInverseDynJacForward::jacobian(const Eigen::VectorXd& x_in)
{
    double* jac = jac_.data();

    v_[0] = sin(x_in[1]);
    v_[1] = cos(x_in[1]);
    v_[2] = v_[1] * x_in[6];
    v_[3] = (-v_[2]) * x_in[7];
    v_[4] = -1 * sin(x_in[1]);
    v_[5] = v_[4] * x_in[6];
    v_[6] = v_[5] * x_in[7];
    v_[7] = 9.81 * v_[4];
    v_[8] = v_[0] * x_in[6];
    v_[9] = cos(x_in[1]);
    v_[10] = v_[9] * x_in[6];
    v_[11] = v_[8] * v_[5] + v_[2] * v_[10];
    v_[12] = cos(x_in[2]);
    v_[13] = sin(x_in[2]);
    v_[14] = v_[13] * v_[5];
    v_[15] = v_[12] * v_[3] + (-v_[14]) * x_in[8];
    v_[16] = v_[12] * v_[5];
    v_[17] = v_[13] * v_[3] + v_[16] * x_in[8];
    v_[18] = -0.112 * v_[13];
    v_[19] = 0.112 * v_[12];
    v_[20] = v_[19] * v_[5];
    v_[21] = v_[12] * v_[7] + v_[18] * v_[3] + (-v_[20]) * x_in[8];
    v_[22] = v_[18] * v_[5];
    v_[23] = v_[13] * v_[7] + v_[19] * v_[3] + v_[22] * x_in[8];
    v_[24] = v_[8] + x_in[8];
    v_[25] = 0.112 * v_[13];
    v_[26] = v_[19] * v_[10] + v_[25] * x_in[7];
    v_[27] = v_[24] * v_[20] + v_[2] * v_[26];
    v_[28] = 0 - v_[12];
    v_[29] = v_[13] * v_[10] + v_[28] * x_in[7];
    v_[30] = v_[12] * v_[10] + v_[13] * x_in[7];
    v_[31] = v_[29] * v_[16] + v_[14] * v_[30];
    v_[32] = v_[29] * v_[2] + v_[14] * v_[24];
    v_[33] = sin(x_in[3]);
    v_[34] = 0 - v_[33];
    v_[35] = -1 * v_[17];
    v_[36] = cos(x_in[3]);
    v_[37] = v_[33] * v_[16] + v_[36] * v_[2];
    v_[38] = v_[34] * v_[6] + v_[36] * v_[15] + (-v_[37]) * x_in[9];
    v_[39] = v_[36] * v_[16] + v_[34] * v_[2];
    v_[40] = v_[36] * v_[6] + v_[33] * v_[15] + v_[39] * x_in[9];
    v_[41] = -0.304 * v_[15] + -1 * v_[23];
    v_[42] = 9.81 * v_[1];
    v_[43] = -0.304 * v_[33];
    v_[44] = -0.304 * v_[36];
    v_[45] = v_[44] * v_[14] + v_[36] * v_[22];
    v_[46] = v_[36] * v_[42] + v_[33] * v_[21] + v_[43] * v_[17] + v_[45] * x_in[9];
    v_[47] = v_[36] * v_[30] + v_[34] * v_[24];
    v_[48] = -0.304 * v_[16] + -1 * v_[20];
    v_[49] = -0.304 * v_[30] + -1 * v_[26];
    v_[50] = -1 * v_[29] + x_in[9];
    v_[51] = -1 * v_[14];
    v_[52] = 0.112 * v_[12];
    v_[53] = v_[18] * v_[10] + v_[52] * x_in[7];
    v_[54] = v_[44] * v_[29] + v_[36] * v_[53];
    v_[55] = v_[47] * v_[48] + v_[39] * v_[49] - (v_[50] * v_[45] + v_[51] * v_[54]);
    v_[56] = v_[47] * v_[51] + v_[39] * v_[50];
    v_[57] = v_[50] * v_[51] + v_[51] * v_[50];
    v_[58] = v_[33] * v_[30] + v_[36] * v_[24];
    v_[59] = v_[58] * v_[37] + v_[37] * v_[58];
    v_[60] = cos(x_in[4]);
    v_[61] = sin(x_in[4]);
    v_[62] = 0 - v_[60];
    v_[63] = v_[61] * v_[39] + v_[62] * v_[51];
    v_[64] = v_[61] * v_[35] + v_[60] * v_[38] + (-v_[63]) * x_in[10];
    v_[65] = v_[60] * v_[39] + v_[61] * v_[51];
    v_[66] = v_[62] * v_[35] + v_[61] * v_[38] + v_[65] * x_in[10];
    v_[67] = 0.112 * v_[61];
    v_[68] = 0.112 * v_[60];
    v_[69] = 0 - v_[60];
    v_[70] = 0 - v_[33];
    v_[71] = v_[43] * v_[14] + v_[33] * v_[22];
    v_[72] = v_[70] * v_[42] + v_[36] * v_[21] + v_[44] * v_[17] + (-v_[71]) * x_in[9];
    v_[73] = 0.112 * v_[60];
    v_[74] = -0.112 * v_[61];
    v_[75] = v_[73] * v_[51] + v_[74] * v_[39] + v_[61] * v_[48] + v_[60] * v_[45];
    v_[76] = v_[67] * v_[35] + v_[68] * v_[38] + v_[69] * v_[41] + v_[61] * v_[72] + v_[75] * x_in[10];
    v_[77] = v_[60] * v_[47] + v_[61] * v_[50];
    v_[78] = v_[43] * v_[29] + v_[33] * v_[53];
    v_[79] = v_[58] + x_in[10];
    v_[80] = v_[73] * v_[50] + v_[74] * v_[47] + v_[61] * v_[49] + v_[60] * v_[54];
    v_[81] = v_[77] * v_[71] + v_[65] * v_[78] - (v_[79] * v_[75] + v_[37] * v_[80]);
    v_[82] = v_[77] * v_[37] + v_[65] * v_[79];
    v_[83] = v_[79] * v_[37] + v_[37] * v_[79];
    v_[84] = v_[61] * v_[47] + v_[62] * v_[50];
    v_[85] = v_[84] * v_[63] + v_[63] * v_[84];
    v_[86] = sin(x_in[5]);
    v_[87] = cos(x_in[5]);
    v_[88] = 0.02075 * v_[86] + 0.184 * v_[87];
    v_[89] = 0 - v_[86];
    v_[90] = v_[67] * v_[51] + v_[68] * v_[39] + v_[69] * v_[48] + v_[61] * v_[45];
    v_[91] = 0.184 * v_[86] - 0.02075 * v_[87];
    v_[92] = v_[87] * v_[71] + v_[86] * v_[90] + v_[91] * v_[65];
    v_[93] = v_[89] * v_[46] + v_[87] * v_[76] + v_[88] * v_[64] + (-v_[92]) * x_in[11];
    v_[94] = v_[86] * v_[84] + v_[87] * v_[79];
    v_[95] = 0 - v_[86];
    v_[96] = v_[87] * v_[63] + v_[95] * v_[37];
    v_[97] = v_[86] * v_[63] + v_[87] * v_[37];
    v_[98] = v_[87] * v_[84] + v_[95] * v_[79];
    v_[99] = v_[94] * v_[96] + v_[97] * v_[98];
    v_[100] = 0.02075 * v_[37] + -0.184 * v_[63] + v_[75];
    v_[101] = 0.02075 * v_[79] + -0.184 * v_[84] + v_[80];
    v_[102] = v_[94] * v_[100] + v_[97] * v_[101];
    v_[103] = v_[77] + x_in[11];
    v_[104] = v_[67] * v_[50] + v_[68] * v_[47] + v_[69] * v_[49] + v_[61] * v_[54];
    v_[105] = v_[87] * v_[78] + v_[86] * v_[104] + v_[91] * v_[77];
    v_[106] = v_[103] * v_[92] + v_[65] * v_[105];
    v_[107] = 1.547475 * v_[93] + 0.038686875 * v_[64] + 0.038686875 * v_[99] + -1.547475 * (v_[102] - v_[106]);
    v_[108] = v_[89] * v_[71] + v_[87] * v_[90] + v_[88] * v_[65];
    v_[109] = v_[89] * v_[78] + v_[87] * v_[104] + v_[88] * v_[77];
    v_[110] = v_[103] * v_[65] + v_[65] * v_[103];
    v_[111] = v_[98] * v_[96] + v_[96] * v_[98];
    v_[100] = 1.547475 * (v_[98] * v_[100] + v_[96] * v_[101] - (v_[103] * v_[108] + v_[65] * v_[109])) +
              1.547475 * (v_[87] * v_[46] + v_[86] * v_[76] + v_[91] * v_[64] + v_[108] * x_in[11]) -
              0.038686875 * (v_[110] + v_[111]);
    v_[112] = v_[95] * v_[40] + v_[87] * v_[66] + (-v_[97]) * x_in[11];
    v_[113] = v_[87] * v_[40] + v_[86] * v_[66] + v_[96] * x_in[11];
    v_[114] = v_[94] * v_[65] + v_[97] * v_[103];
    v_[115] = v_[98] * v_[65] + v_[96] * v_[103];
    v_[116] = v_[94] * v_[97] + v_[97] * v_[94];
    jac[11] = 0.009277 * v_[64] + -0.000829 * v_[112] + 1.5e-05 * v_[113] + 0.038686875 * v_[93] + -0.00751 * v_[99] +
              0.038686875 * (v_[106] - v_[102]) + -0.000829 * v_[114] - 1.5e-05 * v_[115] -
              0.000198 * (v_[111] - v_[116]);
    v_[106] = v_[84] * v_[37] + v_[63] * v_[79];
    v_[102] = v_[84] * v_[65] + v_[63] * v_[77];
    v_[93] = -0.001243 * v_[40] + 0.029115 * v_[64] + -0.001387 * v_[66] + 0.057838 * v_[76] + 0.057838 * v_[81] +
             -0.001387 * v_[82] + -0.012652 * (v_[83] - v_[85]) + v_[88] * v_[107] + v_[91] * v_[100] + jac[11] -
             -0.008386 * v_[106] - -0.001243 * v_[102];
    v_[117] = v_[73] * v_[35] + v_[74] * v_[38] + v_[61] * v_[41] + v_[60] * v_[72] + (-v_[90]) * x_in[10];
    v_[118] = v_[84] * v_[71] + v_[63] * v_[78] - (v_[79] * v_[90] + v_[37] * v_[104]);
    v_[119] = 0.02075 * v_[40] + -0.184 * v_[66] + v_[117];
    v_[108] = v_[94] * v_[108] + v_[97] * v_[109] - (v_[98] * v_[92] + v_[96] * v_[105]);
    v_[116] = -0.000829 * v_[64] + 0.003227 * v_[112] + 0.000198 * v_[113] + -0.038686875 * v_[119] +
              0.000198 * v_[115] + 1.5e-05 * (v_[110] - v_[116]) - 0.038686875 * v_[108] - -0.00146 * v_[114] -
              -0.000829 * v_[99];
    v_[115] = 1.5e-05 * v_[64] + 0.000198 * v_[112] + 0.010737 * v_[113] + 0.00605 * v_[115] + 1.5e-05 * v_[99] -
              0.000198 * v_[114] - -0.000829 * (v_[110] - v_[111]);
    v_[108] = 1.547475 * v_[119] + -0.038686875 * v_[112] + 0.038686875 * v_[114] + 1.547475 * v_[108];
    v_[119] = v_[77] * v_[65] + v_[65] * v_[77];
    jac[10] = 0.011046 * v_[40] + -0.001243 * v_[64] + -0.012652 * v_[66] + -0.001243 * v_[106] + 0.009683 * v_[102] +
              v_[95] * v_[116] + v_[87] * v_[115] + 0.02075 * v_[108] - -0.012652 * v_[82] -
              -0.001387 * (v_[119] - v_[85]);
    v_[115] = -0.012652 * v_[40] + -0.001387 * v_[64] + 0.019432 * v_[66] + -0.057838 * v_[117] + -0.018069 * v_[82] +
              0.057838 * v_[118] + -0.012652 * v_[102] + v_[87] * v_[116] + v_[86] * v_[115] + -0.184 * v_[108] -
              -0.001387 * v_[106] - -0.001243 * (v_[83] - v_[119]);
    v_[108] = 2.1032 * v_[117] + -0.057838 * v_[66] + 0.057838 * v_[82] + -2.1032 * v_[118] + v_[108];
    v_[106] = 2.1032 * v_[76] + 0.057838 * v_[64] + 0.057838 * v_[106] + 2.1032 * v_[81] + v_[87] * v_[107] +
              v_[86] * v_[100];
    v_[45] = v_[58] * v_[45] + v_[37] * v_[54] - (v_[47] * v_[71] + v_[39] * v_[78]);
    v_[81] = v_[58] * v_[51] + v_[37] * v_[50];
    v_[76] = v_[58] * v_[39] + v_[37] * v_[47];
    v_[64] = -0.0022920002 * v_[35] + 0.01828449 * v_[38] + 0.0036857284 * v_[40] + -0.160298259823722 * v_[41] +
             1.52322944854339e-09 * v_[46] + 1.52322944854339e-09 * v_[55] + 0.0036857284 * v_[56] +
             -0.00021200017 * (v_[57] - v_[59]) + v_[60] * v_[93] + v_[61] * v_[115] + v_[74] * v_[108] +
             v_[68] * v_[106] - 0.160298259823722 * v_[45] - 0.01404749 * v_[81] - -0.0022920002 * v_[76];
    v_[48] = v_[58] * v_[48] + v_[37] * v_[49];
    v_[71] = v_[50] * v_[71] + v_[51] * v_[78];
    v_[39] = v_[47] * v_[39] + v_[39] * v_[47];
    jac[9] = 0.09570849 * v_[35] + -0.0022920002 * v_[38] + -0.00021200017 * v_[40] + 0.160298259823722 * v_[72] +
             0.008711861 * v_[46] + 0.160298259823722 * (v_[71] - v_[48]) + -0.06337651 * v_[76] +
             -0.0022920002 * v_[81] + v_[61] * v_[93] + v_[62] * v_[115] + v_[73] * v_[108] + v_[67] * v_[106] -
             -0.008711861 * v_[55] - -0.00021200017 * v_[56] - 0.0036857284 * (v_[39] - v_[59]);
    v_[115] = -0.00021200017 * v_[35] + 0.0036857284 * v_[38] + 0.081661 * v_[40] + -0.008711861 * v_[41] +
              -1.52322944854339e-09 * v_[72] + -0.008711861 * v_[45] + 1.52322944854339e-09 * (v_[48] - v_[71]) +
              0.077424 * v_[56] + -0.00021200017 * v_[76] + jac[10] - 0.0036857284 * v_[81] -
              -0.0022920002 * (v_[57] - v_[39]);
    v_[93] = -(v_[24] * v_[22] + v_[2] * v_[53]);
    v_[51] = v_[30] * v_[2] + v_[16] * v_[24];
    v_[37] = v_[30] * v_[16] + v_[16] * v_[30];
    v_[118] = v_[29] * v_[14] + v_[14] * v_[29];
    jac[8] = 0.010329999 * v_[6] + -0.0037997814 * v_[15] + -0.011715295 * v_[17] + -0.0055615274403 * v_[21] +
             -0.01438086 * v_[23] + -0.0055615274403 * v_[27] + 0.00750500000000001 * v_[31] + -0.0037997814 * v_[32] +
             v_[34] * v_[64] + v_[36] * v_[115] - 0.01438086 * v_[93] - -0.011715295 * v_[51] -
             5.399998e-05 * (v_[37] - v_[118]);
    v_[117] = v_[2] * x_in[7];
    v_[5] = v_[10] * v_[5] + v_[5] * v_[10];
    v_[82] = 0 - v_[8];
    v_[66] = v_[82] * x_in[7];
    v_[116] = v_[10] * x_in[7];
    v_[102] = 9.81 * v_[9];
    v_[83] = v_[8] * v_[10];
    v_[114] = 0 - v_[29];
    v_[112] = v_[12] * v_[66] + v_[114] * x_in[8];
    v_[113] = v_[13] * v_[66] + v_[30] * x_in[8];
    v_[111] = 0 - v_[26];
    v_[110] = v_[12] * v_[102] + v_[18] * v_[66] + v_[111] * x_in[8];
    v_[99] = v_[13] * v_[102] + v_[19] * v_[66] + v_[53] * x_in[8];
    v_[97] = v_[24] * v_[26];
    v_[96] = v_[29] * v_[30];
    v_[92] = v_[29] * v_[24];
    v_[120] = -1 * v_[113];
    v_[121] = 0 - v_[58];
    v_[122] = v_[34] * v_[116] + v_[36] * v_[112] + v_[121] * x_in[9];
    v_[123] = v_[36] * v_[116] + v_[33] * v_[112] + v_[47] * x_in[9];
    v_[124] = -0.304 * v_[112] + -1 * v_[99];
    v_[125] = 9.81 * v_[0];
    v_[126] = v_[36] * v_[125] + v_[33] * v_[110] + v_[43] * v_[113] + v_[54] * x_in[9];
    v_[127] = v_[47] * v_[49] - v_[50] * v_[54];
    v_[128] = v_[47] * v_[50];
    v_[129] = v_[50] * v_[50];
    v_[130] = v_[58] * v_[58];
    v_[131] = 0 - v_[84];
    v_[132] = v_[61] * v_[120] + v_[60] * v_[122] + v_[131] * x_in[10];
    v_[133] = v_[62] * v_[120] + v_[61] * v_[122] + v_[77] * x_in[10];
    v_[134] = 0 - v_[78];
    v_[70] = v_[70] * v_[125] + v_[36] * v_[110] + v_[44] * v_[113] + v_[134] * x_in[9];
    v_[135] = v_[67] * v_[120] + v_[68] * v_[122] + v_[69] * v_[124] + v_[61] * v_[70] + v_[80] * x_in[10];
    v_[136] = v_[77] * v_[78] - v_[79] * v_[80];
    v_[137] = v_[77] * v_[79];
    v_[138] = v_[79] * v_[79];
    v_[139] = v_[84] * v_[84];
    v_[140] = 0 - v_[105];
    v_[141] = v_[89] * v_[126] + v_[87] * v_[135] + v_[88] * v_[132] + v_[140] * x_in[11];
    v_[142] = v_[94] * v_[98];
    v_[143] = v_[94] * v_[101];
    v_[144] = v_[103] * v_[105];
    v_[145] = 1.547475 * v_[141] + 0.038686875 * v_[132] + 0.038686875 * v_[142] + -1.547475 * (v_[143] - v_[144]);
    v_[146] = v_[103] * v_[103];
    v_[147] = v_[98] * v_[98];
    v_[148] = 1.547475 * (v_[98] * v_[101] - v_[103] * v_[109]) +
              1.547475 * (v_[87] * v_[126] + v_[86] * v_[135] + v_[91] * v_[132] + v_[109] * x_in[11]) -
              0.038686875 * (v_[146] + v_[147]);
    v_[149] = 0 - v_[94];
    jac[71] = -0.000829 * v_[149] + 1.5e-05 * v_[98] + 0.038686875 * v_[140] + 0.038686875 * v_[105] +
              -0.000829 * v_[94] - 1.5e-05 * v_[98];
    v_[150] = v_[95] * v_[123] + v_[87] * v_[133] + v_[149] * x_in[11];
    v_[151] = v_[87] * v_[123] + v_[86] * v_[133] + v_[98] * x_in[11];
    v_[152] = v_[94] * v_[103];
    v_[153] = v_[98] * v_[103];
    v_[154] = v_[94] * v_[94];
    v_[155] = v_[84] * v_[79];
    v_[156] = v_[84] * v_[77];
    v_[144] = -0.001243 * v_[123] + 0.029115 * v_[132] + -0.001387 * v_[133] + 0.057838 * v_[135] + 0.057838 * v_[136] +
              -0.001387 * v_[137] + -0.012652 * (v_[138] - v_[139]) + v_[88] * v_[145] + v_[91] * v_[148] +
              0.009277 * v_[132] + -0.000829 * v_[150] + 1.5e-05 * v_[151] + 0.038686875 * v_[141] +
              -0.00751 * v_[142] + 0.038686875 * (v_[144] - v_[143]) + -0.000829 * v_[152] - 1.5e-05 * v_[153] -
              0.000198 * (v_[147] - v_[154]) - -0.008386 * v_[155] - -0.001243 * v_[156];
    v_[143] = 0 - v_[104];
    v_[141] = v_[73] * v_[120] + v_[74] * v_[122] + v_[61] * v_[124] + v_[60] * v_[70] + v_[143] * x_in[10];
    v_[157] = v_[84] * v_[78] - v_[79] * v_[104];
    v_[158] = 0.02075 * v_[123] + -0.184 * v_[133] + v_[141];
    v_[159] = v_[94] * v_[109] - v_[98] * v_[105];
    v_[154] = -0.000829 * v_[132] + 0.003227 * v_[150] + 0.000198 * v_[151] + -0.038686875 * v_[158] +
              0.000198 * v_[153] + 1.5e-05 * (v_[146] - v_[154]) - 0.038686875 * v_[159] - -0.00146 * v_[152] -
              -0.000829 * v_[142];
    v_[153] = 1.5e-05 * v_[132] + 0.000198 * v_[150] + 0.010737 * v_[151] + 0.00605 * v_[153] + 1.5e-05 * v_[142] -
              0.000198 * v_[152] - -0.000829 * (v_[146] - v_[147]);
    v_[159] = 1.547475 * v_[158] + -0.038686875 * v_[150] + 0.038686875 * v_[152] + 1.547475 * v_[159];
    v_[158] = v_[77] * v_[77];
    v_[138] = -0.012652 * v_[123] + -0.001387 * v_[132] + 0.019432 * v_[133] + -0.057838 * v_[141] +
              -0.018069 * v_[137] + 0.057838 * v_[157] + -0.012652 * v_[156] + v_[87] * v_[154] + v_[86] * v_[153] +
              -0.184 * v_[159] - -0.001387 * v_[155] - -0.001243 * (v_[138] - v_[158]);
    v_[157] = 2.1032 * v_[141] + -0.057838 * v_[133] + 0.057838 * v_[137] + -2.1032 * v_[157] + v_[159];
    v_[136] = 2.1032 * v_[135] + 0.057838 * v_[132] + 0.057838 * v_[155] + 2.1032 * v_[136] + v_[87] * v_[145] +
              v_[86] * v_[148];
    v_[141] = v_[58] * v_[54] - v_[47] * v_[78];
    v_[152] = v_[58] * v_[50];
    v_[150] = v_[58] * v_[47];
    v_[151] = -0.0022920002 * v_[120] + 0.01828449 * v_[122] + 0.0036857284 * v_[123] + -0.160298259823722 * v_[124] +
              1.52322944854339e-09 * v_[126] + 1.52322944854339e-09 * v_[127] + 0.0036857284 * v_[128] +
              -0.00021200017 * (v_[129] - v_[130]) + v_[60] * v_[144] + v_[61] * v_[138] + v_[74] * v_[157] +
              v_[68] * v_[136] - 0.160298259823722 * v_[141] - 0.01404749 * v_[152] - -0.0022920002 * v_[150];
    v_[147] = v_[58] * v_[49];
    v_[146] = v_[50] * v_[78];
    v_[142] = v_[47] * v_[47];
    v_[159] = -0.00021200017 * v_[120] + 0.0036857284 * v_[122] + 0.081661 * v_[123] + -0.008711861 * v_[124] +
              -1.52322944854339e-09 * v_[70] + -0.008711861 * v_[141] + 1.52322944854339e-09 * (v_[147] - v_[146]) +
              0.077424 * v_[128] + -0.00021200017 * v_[150] + 0.011046 * v_[123] + -0.001243 * v_[132] +
              -0.012652 * v_[133] + -0.001243 * v_[155] + 0.009683 * v_[156] + v_[95] * v_[154] + v_[87] * v_[153] +
              0.02075 * v_[159] - -0.012652 * v_[137] - -0.001387 * (v_[158] - v_[139]) - 0.0036857284 * v_[152] -
              -0.0022920002 * (v_[129] - v_[142]);
    v_[156] = 0 - v_[24] * v_[53];
    v_[155] = v_[30] * v_[24];
    v_[137] = v_[30] * v_[30];
    v_[160] = v_[29] * v_[29];
    v_[161] = v_[8] * x_in[7];
    v_[162] = x_in[7] * x_in[7];
    v_[163] = v_[8] * v_[2] + v_[2] * v_[8];
    v_[2] = v_[24] * v_[2] + v_[2] * v_[24];
    v_[45] = -0.160298259823722 * v_[38] + -0.008711861 * v_[40] + 1.7423722 * v_[41] + 1.7423722 * v_[45] +
             0.160298259823722 * v_[81] + -0.008711861 * v_[56] + v_[61] * v_[108] + v_[69] * v_[106] -
             1.52322944854339e-09 * (v_[39] + v_[59]);
    v_[22] = v_[29] * v_[22] + v_[14] * v_[53] - (v_[30] * v_[20] + v_[16] * v_[26]);
    v_[115] = -0.0037997814 * v_[6] + 0.20986895 * v_[15] + 5.399998e-05 * v_[17] + 0.0055615274403 * v_[42] +
              0.647967112 * v_[23] + 0.647967112 * v_[93] + 5.399998e-05 * v_[51] + -0.011715295 * (v_[2] - v_[118]) +
              v_[36] * v_[64] + v_[33] * v_[115] + -0.304 * v_[45] - -0.0055615274403 * v_[22] - -0.192033951 * v_[32] -
              -0.0037997814 * v_[31];
    v_[27] = -v_[27];
    v_[71] = 0.160298259823722 * v_[35] + -1.52322944854339e-09 * v_[40] + 1.7423722 * v_[72] +
             -1.7423722 * (v_[48] - v_[71]) + 0.160298259823722 * v_[76] + 1.52322944854339e-09 * v_[56] +
             v_[60] * v_[108] + v_[61] * v_[106] - -0.008711861 * (v_[57] + v_[59]);
    v_[39] = 0.008711861 * v_[35] + 1.52322944854339e-09 * v_[38] + 1.7423722 * v_[46] + 1.7423722 * v_[55] +
             1.52322944854339e-09 * v_[81] + -0.008711861 * v_[76] +
             2.1032 * (v_[84] * v_[75] + v_[63] * v_[80] - (v_[77] * v_[90] + v_[65] * v_[104])) + 2.1032 * v_[46] +
             v_[89] * v_[107] + v_[87] * v_[100] - 0.160298259823722 * (v_[57] + v_[39]) -
             0.057838 * (v_[119] + v_[85]);
    v_[22] = -0.011715295 * v_[6] + 5.399998e-05 * v_[15] + 0.20236395 * v_[17] + 0.01438086 * v_[42] +
             -0.647967112 * v_[21] + 0.01438086 * v_[22] + 0.647967112 * v_[27] + -0.199538951 * v_[51] +
             -0.011715295 * v_[31] + v_[44] * v_[71] + v_[43] * v_[39] + -1 * jac[9] - 5.399998e-05 * v_[32] -
             -0.0037997814 * (v_[2] - v_[37]);
    v_[39] = -0.0055615274403 * v_[6] + -0.647967112 * v_[17] + 2.327 * v_[21] + -2.327 * v_[27] +
             -0.0055615274403 * v_[31] + 0.647967112 * v_[51] + v_[36] * v_[71] + v_[33] * v_[39] -
             0.01438086 * (v_[2] + v_[118]);
    v_[45] = -0.01438086 * v_[6] + 0.647967112 * v_[15] + 2.327 * v_[23] + 2.327 * v_[93] + 0.647967112 * v_[32] +
             0.01438086 * v_[31] + -1 * v_[45] - -0.0055615274403 * (v_[2] + v_[37]);
    jac[7] = -0.002752 * v_[3] + -0.022851627 * v_[6] + 0.293374233908935 * v_[7] + 0.0606159433962 * v_[42] +
             -0.002752 * v_[117] + 0.046852534 * v_[11] + v_[13] * v_[115] + v_[28] * v_[22] + v_[52] * v_[39] +
             v_[25] * v_[45] - -0.022851627 * v_[6] - 0.0055279857 * (v_[5] - v_[163]);
    v_[2] = v_[24] * v_[24];
    v_[141] = -0.160298259823722 * v_[122] + -0.008711861 * v_[123] + 1.7423722 * v_[124] + 1.7423722 * v_[141] +
              0.160298259823722 * v_[152] + -0.008711861 * v_[128] + v_[61] * v_[157] + v_[69] * v_[136] -
              1.52322944854339e-09 * (v_[142] + v_[130]);
    v_[37] = v_[29] * v_[53] - v_[30] * v_[26];
    v_[93] = -0.0037997814 * v_[116] + 0.20986895 * v_[112] + 5.399998e-05 * v_[113] + 0.0055615274403 * v_[125] +
             0.647967112 * v_[99] + 0.647967112 * v_[156] + 5.399998e-05 * v_[155] + -0.011715295 * (v_[2] - v_[160]) +
             v_[36] * v_[151] + v_[33] * v_[159] + -0.304 * v_[141] - -0.0055615274403 * v_[37] -
             -0.192033951 * v_[92] - -0.0037997814 * v_[96];
    v_[32] = 0 - v_[97];
    v_[31] = 0.160298259823722 * v_[120] + -1.52322944854339e-09 * v_[123] + 1.7423722 * v_[70] +
             -1.7423722 * (v_[147] - v_[146]) + 0.160298259823722 * v_[150] + 1.52322944854339e-09 * v_[128] +
             v_[60] * v_[157] + v_[61] * v_[136] - -0.008711861 * (v_[129] + v_[130]);
    v_[158] = 0.008711861 * v_[120] + 1.52322944854339e-09 * v_[122] + 1.7423722 * v_[126] + 1.7423722 * v_[127] +
              1.52322944854339e-09 * v_[152] + -0.008711861 * v_[150] + 2.1032 * (v_[84] * v_[80] - v_[77] * v_[104]) +
              2.1032 * v_[126] + v_[89] * v_[145] + v_[87] * v_[148] - 0.160298259823722 * (v_[129] + v_[142]) -
              0.057838 * (v_[158] + v_[139]);
    v_[37] =
        -0.011715295 * v_[116] + 5.399998e-05 * v_[112] + 0.20236395 * v_[113] + 0.01438086 * v_[125] +
        -0.647967112 * v_[110] + 0.01438086 * v_[37] + 0.647967112 * v_[32] + -0.199538951 * v_[155] +
        -0.011715295 * v_[96] + v_[44] * v_[31] + v_[43] * v_[158] +
        -1 * (0.09570849 * v_[120] + -0.0022920002 * v_[122] + -0.00021200017 * v_[123] + 0.160298259823722 * v_[70] +
                 0.008711861 * v_[126] + 0.160298259823722 * (v_[146] - v_[147]) + -0.06337651 * v_[150] +
                 -0.0022920002 * v_[152] + v_[61] * v_[144] + v_[62] * v_[138] + v_[73] * v_[157] + v_[67] * v_[136] -
                 -0.008711861 * v_[127] - -0.00021200017 * v_[128] - 0.0036857284 * (v_[142] - v_[130])) -
        5.399998e-05 * v_[92] - -0.0037997814 * (v_[2] - v_[137]);
    v_[32] = -0.0055615274403 * v_[116] + -0.647967112 * v_[113] + 2.327 * v_[110] + -2.327 * v_[32] +
             -0.0055615274403 * v_[96] + 0.647967112 * v_[155] + v_[36] * v_[31] + v_[33] * v_[158] -
             0.01438086 * (v_[2] + v_[160]);
    v_[141] = -0.01438086 * v_[116] + 0.647967112 * v_[112] + 2.327 * v_[99] + 2.327 * v_[156] + 0.647967112 * v_[92] +
              0.01438086 * v_[96] + -1 * v_[141] - -0.0055615274403 * (v_[2] + v_[137]);
    jac[6] =
        v_[0] * (0.0055279857 * v_[3] + 0.039002996 * v_[6] + -0.0099341499912 * v_[7] + -0.034462002 * v_[6] +
                    -0.022851627 * v_[11] + jac[8] - 0.0055279857 * v_[117] - -0.002752 * (0 - v_[5])) +
        v_[1] * (0.0055279857 * v_[66] + 0.039002996 * v_[116] + -0.0099341499912 * v_[102] + -0.034462002 * v_[116] +
                    -0.022851627 * v_[83] + 0.010329999 * v_[116] + -0.0037997814 * v_[112] + -0.011715295 * v_[113] +
                    -0.0055615274403 * v_[110] + -0.01438086 * v_[99] + -0.0055615274403 * v_[97] +
                    0.00750500000000001 * v_[96] + -0.0037997814 * v_[92] + v_[34] * v_[151] + v_[36] * v_[159] -
                    0.01438086 * v_[156] - -0.011715295 * v_[155] - 5.399998e-05 * (v_[137] - v_[160]) -
                    0.0055279857 * v_[161] - -0.002752 * (v_[162] - v_[10] * v_[10])) +
        v_[9] * (0.08585553 * v_[3] + 0.0055279857 * v_[6] + 0.0099341499912 * v_[42] + 0.0055279857 * v_[6] +
                    -0.022851627 * (0 - v_[163]) + v_[12] * v_[115] + v_[13] * v_[22] + v_[18] * v_[39] +
                    v_[19] * v_[45] - 0.012390532 * v_[117] - -0.002752 * v_[11]) +
        v_[4] * (0.08585553 * v_[66] + 0.0055279857 * v_[116] + 0.0099341499912 * v_[125] + 0.0055279857 * v_[116] +
                    -0.022851627 * (v_[162] - v_[8] * v_[8]) + v_[12] * v_[93] + v_[13] * v_[37] + v_[18] * v_[32] +
                    v_[19] * v_[141] - 0.012390532 * v_[161] - -0.002752 * v_[83]);
    v_[45] = -1 * sin(x_in[2]);
    v_[39] = cos(x_in[2]);
    v_[22] = -v_[45];
    v_[115] = v_[39] * v_[10] + v_[22] * x_in[7];
    v_[163] = v_[45] * v_[66] + (-v_[115]) * x_in[8];
    v_[162] = v_[45] * v_[10] + v_[39] * x_in[7];
    v_[161] = v_[39] * v_[66] + v_[162] * x_in[8];
    v_[160] = -0.112 * v_[39];
    v_[137] = 0.112 * v_[45];
    v_[155] = 0.112 * v_[39];
    v_[156] = v_[137] * v_[10] + v_[155] * x_in[7];
    v_[92] = v_[45] * v_[102] + v_[160] * v_[66] + (-v_[156]) * x_in[8];
    v_[96] = 0.112 * v_[45];
    v_[97] = v_[160] * v_[10] + v_[96] * x_in[7];
    v_[102] = v_[39] * v_[102] + v_[137] * v_[66] + v_[97] * x_in[8];
    v_[66] = v_[24] * v_[156];
    v_[99] = v_[29] * v_[162] + v_[115] * v_[30];
    v_[83] = v_[115] * v_[24];
    v_[5] = -1 * v_[161];
    v_[117] = v_[33] * v_[162];
    v_[42] = v_[36] * v_[163] + (-v_[117]) * x_in[9];
    v_[11] = v_[36] * v_[162];
    v_[7] = v_[33] * v_[163] + v_[11] * x_in[9];
    v_[6] = -0.304 * v_[163] + -1 * v_[102];
    v_[4] = v_[44] * v_[115] + v_[36] * v_[97];
    v_[3] = v_[33] * v_[92] + v_[43] * v_[161] + v_[4] * x_in[9];
    v_[1] = -0.304 * v_[162] + -1 * v_[156];
    v_[2] = -1 * v_[115];
    v_[142] = v_[47] * v_[1] + v_[11] * v_[49] - (v_[50] * v_[4] + v_[2] * v_[54]);
    v_[146] = v_[47] * v_[2] + v_[11] * v_[50];
    v_[147] = v_[50] * v_[2] + v_[2] * v_[50];
    v_[150] = v_[58] * v_[117] + v_[117] * v_[58];
    v_[152] = v_[61] * v_[11] + v_[62] * v_[2];
    v_[130] = v_[61] * v_[5] + v_[60] * v_[42] + (-v_[152]) * x_in[10];
    v_[128] = v_[60] * v_[11] + v_[61] * v_[2];
    v_[127] = v_[62] * v_[5] + v_[61] * v_[42] + v_[128] * x_in[10];
    v_[139] = v_[43] * v_[115] + v_[33] * v_[97];
    v_[129] = v_[36] * v_[92] + v_[44] * v_[161] + (-v_[139]) * x_in[9];
    v_[23] = v_[73] * v_[2] + v_[74] * v_[11] + v_[61] * v_[1] + v_[60] * v_[4];
    v_[15] = v_[67] * v_[5] + v_[68] * v_[42] + v_[69] * v_[6] + v_[61] * v_[129] + v_[23] * x_in[10];
    v_[71] = v_[77] * v_[139] + v_[128] * v_[78] - (v_[79] * v_[23] + v_[117] * v_[80]);
    v_[27] = v_[77] * v_[117] + v_[128] * v_[79];
    v_[118] = v_[79] * v_[117] + v_[117] * v_[79];
    v_[51] = v_[84] * v_[152] + v_[152] * v_[84];
    v_[21] = v_[67] * v_[2] + v_[68] * v_[11] + v_[69] * v_[1] + v_[61] * v_[4];
    v_[17] = v_[87] * v_[139] + v_[86] * v_[21] + v_[91] * v_[128];
    v_[76] = v_[89] * v_[3] + v_[87] * v_[15] + v_[88] * v_[130] + (-v_[17]) * x_in[11];
    v_[81] = v_[87] * v_[152] + v_[95] * v_[117];
    v_[119] = v_[86] * v_[152] + v_[87] * v_[117];
    v_[100] = v_[94] * v_[81] + v_[119] * v_[98];
    v_[107] = 0.02075 * v_[117] + -0.184 * v_[152] + v_[23];
    v_[90] = v_[94] * v_[107] + v_[119] * v_[101];
    v_[85] = v_[103] * v_[17] + v_[128] * v_[105];
    v_[75] = 1.547475 * v_[76] + 0.038686875 * v_[130] + 0.038686875 * v_[100] + -1.547475 * (v_[90] - v_[85]);
    v_[65] = v_[89] * v_[139] + v_[87] * v_[21] + v_[88] * v_[128];
    v_[63] = v_[103] * v_[128] + v_[128] * v_[103];
    v_[57] = v_[98] * v_[81] + v_[81] * v_[98];
    v_[107] = 1.547475 * (v_[98] * v_[107] + v_[81] * v_[101] - (v_[103] * v_[65] + v_[128] * v_[109])) +
              1.547475 * (v_[87] * v_[3] + v_[86] * v_[15] + v_[91] * v_[130] + v_[65] * x_in[11]) -
              0.038686875 * (v_[63] + v_[57]);
    v_[55] = v_[95] * v_[7] + v_[87] * v_[127] + (-v_[119]) * x_in[11];
    v_[46] = v_[87] * v_[7] + v_[86] * v_[127] + v_[81] * x_in[11];
    v_[38] = v_[94] * v_[128] + v_[119] * v_[103];
    v_[35] = v_[98] * v_[128] + v_[81] * v_[103];
    v_[48] = v_[94] * v_[119] + v_[119] * v_[94];
    jac[17] = 0.009277 * v_[130] + -0.000829 * v_[55] + 1.5e-05 * v_[46] + 0.038686875 * v_[76] + -0.00751 * v_[100] +
              0.038686875 * (v_[85] - v_[90]) + -0.000829 * v_[38] - 1.5e-05 * v_[35] - 0.000198 * (v_[57] - v_[48]);
    v_[85] = v_[84] * v_[117] + v_[152] * v_[79];
    v_[90] = v_[84] * v_[128] + v_[152] * v_[77];
    v_[76] = -0.001243 * v_[7] + 0.029115 * v_[130] + -0.001387 * v_[127] + 0.057838 * v_[15] + 0.057838 * v_[71] +
             -0.001387 * v_[27] + -0.012652 * (v_[118] - v_[51]) + v_[88] * v_[75] + v_[91] * v_[107] + jac[17] -
             -0.008386 * v_[85] - -0.001243 * v_[90];
    v_[106] = v_[73] * v_[5] + v_[74] * v_[42] + v_[61] * v_[6] + v_[60] * v_[129] + (-v_[21]) * x_in[10];
    v_[108] = v_[84] * v_[139] + v_[152] * v_[78] - (v_[79] * v_[21] + v_[117] * v_[104]);
    v_[72] = 0.02075 * v_[7] + -0.184 * v_[127] + v_[106];
    v_[65] = v_[94] * v_[65] + v_[119] * v_[109] - (v_[98] * v_[17] + v_[81] * v_[105]);
    v_[48] = -0.000829 * v_[130] + 0.003227 * v_[55] + 0.000198 * v_[46] + -0.038686875 * v_[72] + 0.000198 * v_[35] +
             1.5e-05 * (v_[63] - v_[48]) - 0.038686875 * v_[65] - -0.00146 * v_[38] - -0.000829 * v_[100];
    v_[35] = 1.5e-05 * v_[130] + 0.000198 * v_[55] + 0.010737 * v_[46] + 0.00605 * v_[35] + 1.5e-05 * v_[100] -
             0.000198 * v_[38] - -0.000829 * (v_[63] - v_[57]);
    v_[65] = 1.547475 * v_[72] + -0.038686875 * v_[55] + 0.038686875 * v_[38] + 1.547475 * v_[65];
    v_[72] = v_[77] * v_[128] + v_[128] * v_[77];
    jac[16] = 0.011046 * v_[7] + -0.001243 * v_[130] + -0.012652 * v_[127] + -0.001243 * v_[85] + 0.009683 * v_[90] +
              v_[95] * v_[48] + v_[87] * v_[35] + 0.02075 * v_[65] - -0.012652 * v_[27] - -0.001387 * (v_[72] - v_[51]);
    v_[35] = -0.012652 * v_[7] + -0.001387 * v_[130] + 0.019432 * v_[127] + -0.057838 * v_[106] + -0.018069 * v_[27] +
             0.057838 * v_[108] + -0.012652 * v_[90] + v_[87] * v_[48] + v_[86] * v_[35] + -0.184 * v_[65] -
             -0.001387 * v_[85] - -0.001243 * (v_[118] - v_[72]);
    v_[65] = 2.1032 * v_[106] + -0.057838 * v_[127] + 0.057838 * v_[27] + -2.1032 * v_[108] + v_[65];
    v_[85] =
        2.1032 * v_[15] + 0.057838 * v_[130] + 0.057838 * v_[85] + 2.1032 * v_[71] + v_[87] * v_[75] + v_[86] * v_[107];
    v_[4] = v_[58] * v_[4] + v_[117] * v_[54] - (v_[47] * v_[139] + v_[11] * v_[78]);
    v_[71] = v_[58] * v_[2] + v_[117] * v_[50];
    v_[15] = v_[58] * v_[11] + v_[117] * v_[47];
    v_[130] = -0.0022920002 * v_[5] + 0.01828449 * v_[42] + 0.0036857284 * v_[7] + -0.160298259823722 * v_[6] +
              1.52322944854339e-09 * v_[3] + 1.52322944854339e-09 * v_[142] + 0.0036857284 * v_[146] +
              -0.00021200017 * (v_[147] - v_[150]) + v_[60] * v_[76] + v_[61] * v_[35] + v_[74] * v_[65] +
              v_[68] * v_[85] - 0.160298259823722 * v_[4] - 0.01404749 * v_[71] - -0.0022920002 * v_[15];
    v_[1] = v_[58] * v_[1] + v_[117] * v_[49];
    v_[139] = v_[50] * v_[139] + v_[2] * v_[78];
    v_[11] = v_[47] * v_[11] + v_[11] * v_[47];
    jac[15] = 0.09570849 * v_[5] + -0.0022920002 * v_[42] + -0.00021200017 * v_[7] + 0.160298259823722 * v_[129] +
              0.008711861 * v_[3] + 0.160298259823722 * (v_[139] - v_[1]) + -0.06337651 * v_[15] +
              -0.0022920002 * v_[71] + v_[61] * v_[76] + v_[62] * v_[35] + v_[73] * v_[65] + v_[67] * v_[85] -
              -0.008711861 * v_[142] - -0.00021200017 * v_[146] - 0.0036857284 * (v_[11] - v_[150]);
    v_[35] = -0.00021200017 * v_[5] + 0.0036857284 * v_[42] + 0.081661 * v_[7] + -0.008711861 * v_[6] +
             -1.52322944854339e-09 * v_[129] + -0.008711861 * v_[4] + 1.52322944854339e-09 * (v_[1] - v_[139]) +
             0.077424 * v_[146] + -0.00021200017 * v_[15] + jac[16] - 0.0036857284 * v_[71] -
             -0.0022920002 * (v_[147] - v_[11]);
    v_[76] = -v_[24] * v_[97];
    v_[2] = v_[162] * v_[24];
    v_[117] = v_[30] * v_[162] + v_[162] * v_[30];
    v_[108] = v_[29] * v_[115] + v_[115] * v_[29];
    jac[14] = -0.0037997814 * v_[163] + -0.011715295 * v_[161] + -0.0055615274403 * v_[92] + -0.01438086 * v_[102] +
              -0.0055615274403 * v_[66] + 0.00750500000000001 * v_[99] + -0.0037997814 * v_[83] + v_[34] * v_[130] +
              v_[36] * v_[35] - 0.01438086 * v_[76] - -0.011715295 * v_[2] - 5.399998e-05 * (v_[117] - v_[108]);
    v_[4] = -0.160298259823722 * v_[42] + -0.008711861 * v_[7] + 1.7423722 * v_[6] + 1.7423722 * v_[4] +
            0.160298259823722 * v_[71] + -0.008711861 * v_[146] + v_[61] * v_[65] + v_[69] * v_[85] -
            1.52322944854339e-09 * (v_[11] + v_[150]);
    v_[97] = v_[29] * v_[97] + v_[115] * v_[53] - (v_[30] * v_[156] + v_[162] * v_[26]);
    v_[35] = 0.20986895 * v_[163] + 5.399998e-05 * v_[161] + 0.647967112 * v_[102] + 0.647967112 * v_[76] +
             5.399998e-05 * v_[2] + -0.011715295 * (0 - v_[108]) + v_[36] * v_[130] + v_[33] * v_[35] + -0.304 * v_[4] -
             -0.0055615274403 * v_[97] - -0.192033951 * v_[83] - -0.0037997814 * v_[99];
    v_[66] = -v_[66];
    v_[139] = 0.160298259823722 * v_[5] + -1.52322944854339e-09 * v_[7] + 1.7423722 * v_[129] +
              -1.7423722 * (v_[1] - v_[139]) + 0.160298259823722 * v_[15] + 1.52322944854339e-09 * v_[146] +
              v_[60] * v_[65] + v_[61] * v_[85] - -0.008711861 * (v_[147] + v_[150]);
    v_[11] = 0.008711861 * v_[5] + 1.52322944854339e-09 * v_[42] + 1.7423722 * v_[3] + 1.7423722 * v_[142] +
             1.52322944854339e-09 * v_[71] + -0.008711861 * v_[15] +
             2.1032 * (v_[84] * v_[23] + v_[152] * v_[80] - (v_[77] * v_[21] + v_[128] * v_[104])) + 2.1032 * v_[3] +
             v_[89] * v_[75] + v_[87] * v_[107] - 0.160298259823722 * (v_[147] + v_[11]) - 0.057838 * (v_[72] + v_[51]);
    v_[97] = 5.399998e-05 * v_[163] + 0.20236395 * v_[161] + -0.647967112 * v_[92] + 0.01438086 * v_[97] +
             0.647967112 * v_[66] + -0.199538951 * v_[2] + -0.011715295 * v_[99] + v_[44] * v_[139] + v_[43] * v_[11] +
             -1 * jac[15] - 5.399998e-05 * v_[83] - -0.0037997814 * (0 - v_[117]);
    v_[11] = -0.647967112 * v_[161] + 2.327 * v_[92] + -2.327 * v_[66] + -0.0055615274403 * v_[99] +
             0.647967112 * v_[2] + v_[36] * v_[139] + v_[33] * v_[11] - 0.01438086 * v_[108];
    v_[4] = 0.647967112 * v_[163] + 2.327 * v_[102] + 2.327 * v_[76] + 0.647967112 * v_[83] + 0.01438086 * v_[99] +
            -1 * v_[4] - -0.0055615274403 * v_[117];
    jac[12] = v_[0] * jac[14] + v_[9] * (v_[12] * v_[35] + v_[45] * v_[93] + v_[13] * v_[97] + v_[39] * v_[37] +
                                            v_[18] * v_[11] + v_[160] * v_[32] + v_[19] * v_[4] + v_[137] * v_[141]);
    jac[13] = v_[13] * v_[35] + v_[39] * v_[93] + v_[28] * v_[97] + v_[22] * v_[37] + v_[52] * v_[11] +
              v_[96] * v_[32] + v_[25] * v_[4] + v_[155] * v_[141];
    v_[4] = cos(x_in[3]);
    v_[11] = -v_[4];
    v_[97] = -1 * sin(x_in[3]);
    v_[35] = v_[4] * v_[30] + v_[97] * v_[24];
    v_[96] = v_[11] * v_[116] + v_[97] * v_[112] + (-v_[35]) * x_in[9];
    v_[155] = v_[97] * v_[30] + v_[11] * v_[24];
    v_[112] = v_[97] * v_[116] + v_[4] * v_[112] + v_[155] * x_in[9];
    v_[116] = -0.304 * v_[4];
    v_[22] = -0.304 * v_[97];
    v_[39] = v_[22] * v_[29] + v_[97] * v_[53];
    v_[141] = v_[97] * v_[125] + v_[4] * v_[110] + v_[116] * v_[113] + v_[39] * x_in[9];
    v_[32] = v_[155] * v_[49] - v_[50] * v_[39];
    v_[37] = v_[155] * v_[50];
    v_[93] = v_[58] * v_[35] + v_[35] * v_[58];
    v_[137] = v_[61] * v_[155];
    v_[160] = v_[60] * v_[96] + (-v_[137]) * x_in[10];
    v_[45] = v_[60] * v_[155];
    v_[117] = v_[61] * v_[96] + v_[45] * x_in[10];
    v_[76] = v_[116] * v_[29] + v_[4] * v_[53];
    v_[125] = (-v_[4]) * v_[125] + v_[97] * v_[110] + v_[22] * v_[113] + (-v_[76]) * x_in[9];
    v_[110] = v_[74] * v_[155] + v_[60] * v_[39];
    v_[113] = v_[68] * v_[96] + v_[61] * v_[125] + v_[110] * x_in[10];
    v_[83] = v_[77] * v_[76] + v_[45] * v_[78] - (v_[79] * v_[110] + v_[35] * v_[80]);
    v_[99] = v_[77] * v_[35] + v_[45] * v_[79];
    v_[102] = v_[79] * v_[35] + v_[35] * v_[79];
    v_[163] = v_[84] * v_[137] + v_[137] * v_[84];
    v_[139] = v_[68] * v_[155] + v_[61] * v_[39];
    v_[66] = v_[87] * v_[76] + v_[86] * v_[139] + v_[91] * v_[45];
    v_[108] = v_[89] * v_[141] + v_[87] * v_[113] + v_[88] * v_[160] + (-v_[66]) * x_in[11];
    v_[2] = v_[87] * v_[137] + v_[95] * v_[35];
    v_[92] = v_[86] * v_[137] + v_[87] * v_[35];
    v_[161] = v_[94] * v_[2] + v_[92] * v_[98];
    v_[15] = 0.02075 * v_[35] + -0.184 * v_[137] + v_[110];
    v_[71] = v_[94] * v_[15] + v_[92] * v_[101];
    v_[72] = v_[103] * v_[66] + v_[45] * v_[105];
    v_[107] = 1.547475 * v_[108] + 0.038686875 * v_[160] + 0.038686875 * v_[161] + -1.547475 * (v_[71] - v_[72]);
    v_[75] = v_[89] * v_[76] + v_[87] * v_[139] + v_[88] * v_[45];
    v_[21] = v_[103] * v_[45] + v_[45] * v_[103];
    v_[51] = v_[98] * v_[2] + v_[2] * v_[98];
    v_[15] = 1.547475 * (v_[98] * v_[15] + v_[2] * v_[101] - (v_[103] * v_[75] + v_[45] * v_[109])) +
             1.547475 * (v_[87] * v_[141] + v_[86] * v_[113] + v_[91] * v_[160] + v_[75] * x_in[11]) -
             0.038686875 * (v_[21] + v_[51]);
    v_[23] = v_[95] * v_[112] + v_[87] * v_[117] + (-v_[92]) * x_in[11];
    v_[128] = v_[87] * v_[112] + v_[86] * v_[117] + v_[2] * x_in[11];
    v_[152] = v_[94] * v_[45] + v_[92] * v_[103];
    v_[147] = v_[98] * v_[45] + v_[2] * v_[103];
    v_[142] = v_[94] * v_[92] + v_[92] * v_[94];
    jac[23] = 0.009277 * v_[160] + -0.000829 * v_[23] + 1.5e-05 * v_[128] + 0.038686875 * v_[108] + -0.00751 * v_[161] +
              0.038686875 * (v_[72] - v_[71]) + -0.000829 * v_[152] - 1.5e-05 * v_[147] - 0.000198 * (v_[51] - v_[142]);
    v_[72] = v_[84] * v_[35] + v_[137] * v_[79];
    v_[71] = v_[84] * v_[45] + v_[137] * v_[77];
    v_[108] = -0.001243 * v_[112] + 0.029115 * v_[160] + -0.001387 * v_[117] + 0.057838 * v_[113] + 0.057838 * v_[83] +
              -0.001387 * v_[99] + -0.012652 * (v_[102] - v_[163]) + v_[88] * v_[107] + v_[91] * v_[15] + jac[23] -
              -0.008386 * v_[72] - -0.001243 * v_[71];
    v_[3] = v_[74] * v_[96] + v_[60] * v_[125] + (-v_[139]) * x_in[10];
    v_[42] = v_[84] * v_[76] + v_[137] * v_[78] - (v_[79] * v_[139] + v_[35] * v_[104]);
    v_[5] = 0.02075 * v_[112] + -0.184 * v_[117] + v_[3];
    v_[75] = v_[94] * v_[75] + v_[92] * v_[109] - (v_[98] * v_[66] + v_[2] * v_[105]);
    v_[142] = -0.000829 * v_[160] + 0.003227 * v_[23] + 0.000198 * v_[128] + -0.038686875 * v_[5] + 0.000198 * v_[147] +
              1.5e-05 * (v_[21] - v_[142]) - 0.038686875 * v_[75] - -0.00146 * v_[152] - -0.000829 * v_[161];
    v_[147] = 1.5e-05 * v_[160] + 0.000198 * v_[23] + 0.010737 * v_[128] + 0.00605 * v_[147] + 1.5e-05 * v_[161] -
              0.000198 * v_[152] - -0.000829 * (v_[21] - v_[51]);
    v_[75] = 1.547475 * v_[5] + -0.038686875 * v_[23] + 0.038686875 * v_[152] + 1.547475 * v_[75];
    v_[5] = v_[77] * v_[45] + v_[45] * v_[77];
    jac[22] = 0.011046 * v_[112] + -0.001243 * v_[160] + -0.012652 * v_[117] + -0.001243 * v_[72] + 0.009683 * v_[71] +
              v_[95] * v_[142] + v_[87] * v_[147] + 0.02075 * v_[75] - -0.012652 * v_[99] -
              -0.001387 * (v_[5] - v_[163]);
    v_[147] = -0.012652 * v_[112] + -0.001387 * v_[160] + 0.019432 * v_[117] + -0.057838 * v_[3] + -0.018069 * v_[99] +
              0.057838 * v_[42] + -0.012652 * v_[71] + v_[87] * v_[142] + v_[86] * v_[147] + -0.184 * v_[75] -
              -0.001387 * v_[72] - -0.001243 * (v_[102] - v_[5]);
    v_[75] = 2.1032 * v_[3] + -0.057838 * v_[117] + 0.057838 * v_[99] + -2.1032 * v_[42] + v_[75];
    v_[72] = 2.1032 * v_[113] + 0.057838 * v_[160] + 0.057838 * v_[72] + 2.1032 * v_[83] + v_[87] * v_[107] +
             v_[86] * v_[15];
    v_[39] = v_[58] * v_[39] + v_[35] * v_[54] - (v_[47] * v_[76] + v_[155] * v_[78]);
    v_[83] = v_[35] * v_[50];
    v_[113] = v_[58] * v_[155] + v_[35] * v_[47];
    v_[160] = 0.01828449 * v_[96] + 0.0036857284 * v_[112] + 1.52322944854339e-09 * v_[141] +
              1.52322944854339e-09 * v_[32] + 0.0036857284 * v_[37] + -0.00021200017 * (0 - v_[93]) + v_[60] * v_[108] +
              v_[61] * v_[147] + v_[74] * v_[75] + v_[68] * v_[72] - 0.160298259823722 * v_[39] - 0.01404749 * v_[83] -
              -0.0022920002 * v_[113];
    v_[35] = v_[35] * v_[49];
    v_[76] = v_[50] * v_[76];
    v_[155] = v_[47] * v_[155] + v_[155] * v_[47];
    jac[21] = -0.0022920002 * v_[96] + -0.00021200017 * v_[112] + 0.160298259823722 * v_[125] + 0.008711861 * v_[141] +
              0.160298259823722 * (v_[76] - v_[35]) + -0.06337651 * v_[113] + -0.0022920002 * v_[83] +
              v_[61] * v_[108] + v_[62] * v_[147] + v_[73] * v_[75] + v_[67] * v_[72] - -0.008711861 * v_[32] -
              -0.00021200017 * v_[37] - 0.0036857284 * (v_[155] - v_[93]);
    v_[147] = 0.0036857284 * v_[96] + 0.081661 * v_[112] + -1.52322944854339e-09 * v_[125] + -0.008711861 * v_[39] +
              1.52322944854339e-09 * (v_[35] - v_[76]) + 0.077424 * v_[37] + -0.00021200017 * v_[113] + jac[22] -
              0.0036857284 * v_[83] - -0.0022920002 * (0 - v_[155]);
    jac[20] = v_[34] * v_[160] + v_[11] * v_[151] + v_[36] * v_[147] + v_[97] * v_[159];
    v_[39] = -0.160298259823722 * v_[96] + -0.008711861 * v_[112] + 1.7423722 * v_[39] + 0.160298259823722 * v_[83] +
             -0.008711861 * v_[37] + v_[61] * v_[75] + v_[69] * v_[72] - 1.52322944854339e-09 * (v_[155] + v_[93]);
    v_[147] = v_[36] * v_[160] + v_[97] * v_[151] + v_[33] * v_[147] + v_[4] * v_[159] + -0.304 * v_[39];
    v_[76] = -1.52322944854339e-09 * v_[112] + 1.7423722 * v_[125] + -1.7423722 * (v_[35] - v_[76]) +
             0.160298259823722 * v_[113] + 1.52322944854339e-09 * v_[37] + v_[60] * v_[75] + v_[61] * v_[72] -
             -0.008711861 * v_[93];
    v_[155] = 1.52322944854339e-09 * v_[96] + 1.7423722 * v_[141] + 1.7423722 * v_[32] + 1.52322944854339e-09 * v_[83] +
              -0.008711861 * v_[113] +
              2.1032 * (v_[84] * v_[110] + v_[137] * v_[80] - (v_[77] * v_[139] + v_[45] * v_[104])) +
              2.1032 * v_[141] + v_[89] * v_[107] + v_[87] * v_[15] - 0.160298259823722 * v_[155] -
              0.057838 * (v_[5] + v_[163]);
    v_[22] = v_[44] * v_[76] + v_[22] * v_[31] + v_[43] * v_[155] + v_[116] * v_[158] + -1 * jac[21];
    v_[155] = v_[36] * v_[76] + v_[97] * v_[31] + v_[33] * v_[155] + v_[4] * v_[158];
    v_[39] = -1 * v_[39];
    jac[18] = v_[0] * jac[20] + v_[9] * (v_[12] * v_[147] + v_[13] * v_[22] + v_[18] * v_[155] + v_[19] * v_[39]);
    jac[19] = v_[13] * v_[147] + v_[28] * v_[22] + v_[52] * v_[155] + v_[25] * v_[39];
    v_[39] = cos(x_in[4]);
    v_[155] = -1 * sin(x_in[4]);
    v_[22] = -v_[155];
    v_[147] = v_[39] * v_[47] + v_[22] * v_[50];
    v_[76] = v_[39] * v_[120] + v_[155] * v_[122] + (-v_[147]) * x_in[10];
    v_[97] = v_[155] * v_[47] + v_[39] * v_[50];
    v_[4] = v_[22] * v_[120] + v_[39] * v_[122] + v_[97] * x_in[10];
    v_[158] = 0.112 * v_[39];
    v_[31] = 0.112 * v_[155];
    v_[116] = -v_[155];
    v_[113] = 0.112 * v_[155];
    v_[83] = -0.112 * v_[39];
    v_[5] = v_[113] * v_[50] + v_[83] * v_[47] + v_[39] * v_[49] + v_[155] * v_[54];
    v_[15] = v_[158] * v_[120] + v_[31] * v_[122] + v_[116] * v_[124] + v_[39] * v_[70] + v_[5] * x_in[10];
    v_[107] = v_[97] * v_[78] - v_[79] * v_[5];
    v_[139] = v_[97] * v_[79];
    v_[163] = v_[84] * v_[147] + v_[147] * v_[84];
    v_[110] = v_[158] * v_[50] + v_[31] * v_[47] + v_[116] * v_[49] + v_[39] * v_[54];
    v_[45] = v_[86] * v_[110] + v_[91] * v_[97];
    v_[137] = v_[87] * v_[15] + v_[88] * v_[76] + (-v_[45]) * x_in[11];
    v_[32] = v_[87] * v_[147];
    v_[141] = v_[86] * v_[147];
    v_[96] = v_[94] * v_[32] + v_[141] * v_[98];
    v_[35] = -0.184 * v_[147] + v_[5];
    v_[72] = v_[94] * v_[35] + v_[141] * v_[101];
    v_[75] = v_[103] * v_[45] + v_[97] * v_[105];
    v_[125] = 1.547475 * v_[137] + 0.038686875 * v_[76] + 0.038686875 * v_[96] + -1.547475 * (v_[72] - v_[75]);
    v_[93] = v_[87] * v_[110] + v_[88] * v_[97];
    v_[37] = v_[103] * v_[97] + v_[97] * v_[103];
    v_[112] = v_[98] * v_[32] + v_[32] * v_[98];
    v_[35] = 1.547475 * (v_[98] * v_[35] + v_[32] * v_[101] - (v_[103] * v_[93] + v_[97] * v_[109])) +
             1.547475 * (v_[86] * v_[15] + v_[91] * v_[76] + v_[93] * x_in[11]) - 0.038686875 * (v_[37] + v_[112]);
    v_[160] = v_[87] * v_[4] + (-v_[141]) * x_in[11];
    v_[159] = v_[86] * v_[4] + v_[32] * x_in[11];
    v_[151] = v_[94] * v_[97] + v_[141] * v_[103];
    v_[11] = v_[98] * v_[97] + v_[32] * v_[103];
    v_[108] = v_[94] * v_[141] + v_[141] * v_[94];
    jac[29] = 0.009277 * v_[76] + -0.000829 * v_[160] + 1.5e-05 * v_[159] + 0.038686875 * v_[137] + -0.00751 * v_[96] +
              0.038686875 * (v_[75] - v_[72]) + -0.000829 * v_[151] - 1.5e-05 * v_[11] - 0.000198 * (v_[112] - v_[108]);
    v_[75] = v_[147] * v_[79];
    v_[72] = v_[84] * v_[97] + v_[147] * v_[77];
    v_[137] = 0.029115 * v_[76] + -0.001387 * v_[4] + 0.057838 * v_[15] + 0.057838 * v_[107] + -0.001387 * v_[139] +
              -0.012652 * (0 - v_[163]) + v_[88] * v_[125] + v_[91] * v_[35] + jac[29] - -0.008386 * v_[75] -
              -0.001243 * v_[72];
    v_[70] = v_[113] * v_[120] + v_[83] * v_[122] + v_[39] * v_[124] + v_[155] * v_[70] + (-v_[110]) * x_in[10];
    v_[124] = v_[147] * v_[78] - v_[79] * v_[110];
    v_[122] = -0.184 * v_[4] + v_[70];
    v_[93] = v_[94] * v_[93] + v_[141] * v_[109] - (v_[98] * v_[45] + v_[32] * v_[105]);
    v_[108] = -0.000829 * v_[76] + 0.003227 * v_[160] + 0.000198 * v_[159] + -0.038686875 * v_[122] +
              0.000198 * v_[11] + 1.5e-05 * (v_[37] - v_[108]) - 0.038686875 * v_[93] - -0.00146 * v_[151] -
              -0.000829 * v_[96];
    v_[11] = 1.5e-05 * v_[76] + 0.000198 * v_[160] + 0.010737 * v_[159] + 0.00605 * v_[11] + 1.5e-05 * v_[96] -
             0.000198 * v_[151] - -0.000829 * (v_[37] - v_[112]);
    v_[93] = 1.547475 * v_[122] + -0.038686875 * v_[160] + 0.038686875 * v_[151] + 1.547475 * v_[93];
    v_[122] = v_[77] * v_[97] + v_[97] * v_[77];
    jac[28] = -0.001243 * v_[76] + -0.012652 * v_[4] + -0.001243 * v_[75] + 0.009683 * v_[72] + v_[95] * v_[108] +
              v_[87] * v_[11] + 0.02075 * v_[93] - -0.012652 * v_[139] - -0.001387 * (v_[122] - v_[163]);
    v_[11] = -0.001387 * v_[76] + 0.019432 * v_[4] + -0.057838 * v_[70] + -0.018069 * v_[139] + 0.057838 * v_[124] +
             -0.012652 * v_[72] + v_[87] * v_[108] + v_[86] * v_[11] + -0.184 * v_[93] - -0.001387 * v_[75] -
             -0.001243 * (0 - v_[122]);
    v_[93] = 2.1032 * v_[70] + -0.057838 * v_[4] + 0.057838 * v_[139] + -2.1032 * v_[124] + v_[93];
    v_[75] =
        2.1032 * v_[15] + 0.057838 * v_[76] + 0.057838 * v_[75] + 2.1032 * v_[107] + v_[87] * v_[125] + v_[86] * v_[35];
    jac[27] = v_[61] * v_[137] + v_[39] * v_[144] + v_[62] * v_[11] + v_[22] * v_[138] + v_[73] * v_[93] +
              v_[113] * v_[157] + v_[67] * v_[75] + v_[158] * v_[136];
    v_[11] = v_[60] * v_[137] + v_[155] * v_[144] + v_[61] * v_[11] + v_[39] * v_[138] + v_[74] * v_[93] +
             v_[83] * v_[157] + v_[68] * v_[75] + v_[31] * v_[136];
    jac[26] = v_[34] * v_[11] + v_[36] * jac[28];
    v_[116] = v_[61] * v_[93] + v_[39] * v_[157] + v_[69] * v_[75] + v_[116] * v_[136];
    v_[11] = v_[36] * v_[11] + v_[33] * jac[28] + -0.304 * v_[116];
    v_[75] = v_[60] * v_[93] + v_[155] * v_[157] + v_[61] * v_[75] + v_[39] * v_[136];
    v_[122] = 2.1032 * (v_[84] * v_[5] + v_[147] * v_[80] - (v_[77] * v_[110] + v_[97] * v_[104])) + v_[89] * v_[125] +
              v_[87] * v_[35] - 0.057838 * (v_[122] + v_[163]);
    v_[35] = v_[44] * v_[75] + v_[43] * v_[122] + -1 * jac[27];
    v_[122] = v_[36] * v_[75] + v_[33] * v_[122];
    v_[116] = -1 * v_[116];
    jac[24] = v_[0] * jac[26] + v_[9] * (v_[12] * v_[11] + v_[13] * v_[35] + v_[18] * v_[122] + v_[19] * v_[116]);
    jac[25] = v_[13] * v_[11] + v_[28] * v_[35] + v_[52] * v_[122] + v_[25] * v_[116];
    v_[116] = cos(x_in[5]);
    v_[122] = -v_[116];
    v_[35] = -1 * sin(x_in[5]);
    v_[11] = 0.02075 * v_[116] + 0.184 * v_[35];
    v_[75] = 0.184 * v_[116] - 0.02075 * v_[35];
    v_[125] = v_[35] * v_[78] + v_[116] * v_[104] + v_[75] * v_[77];
    v_[110] = v_[122] * v_[126] + v_[35] * v_[135] + v_[11] * v_[132] + (-v_[125]) * x_in[11];
    v_[163] = -v_[116];
    v_[5] = v_[35] * v_[84] + v_[163] * v_[79];
    v_[97] = v_[116] * v_[84] + v_[35] * v_[79];
    v_[147] = v_[94] * v_[5] + v_[97] * v_[98];
    v_[93] = v_[97] * v_[101];
    v_[155] = v_[103] * v_[125];
    v_[39] = 1.547475 * v_[110] + 0.038686875 * v_[147] + -1.547475 * (v_[93] - v_[155]);
    v_[136] = v_[122] * v_[78] + v_[35] * v_[104] + v_[11] * v_[77];
    v_[157] = v_[98] * v_[5] + v_[5] * v_[98];
    v_[135] = 1.547475 * (v_[5] * v_[101] - v_[103] * v_[136]) +
              1.547475 * (v_[35] * v_[126] + v_[116] * v_[135] + v_[75] * v_[132] + v_[136] * x_in[11]) -
              0.038686875 * v_[157];
    v_[132] = v_[163] * v_[123] + v_[35] * v_[133] + (-v_[97]) * x_in[11];
    v_[133] = v_[35] * v_[123] + v_[116] * v_[133] + v_[5] * x_in[11];
    v_[123] = v_[97] * v_[103];
    v_[126] = v_[5] * v_[103];
    v_[137] = v_[94] * v_[97] + v_[97] * v_[94];
    jac[35] = -0.000829 * v_[132] + 1.5e-05 * v_[133] + 0.038686875 * v_[110] + -0.00751 * v_[147] +
              0.038686875 * (v_[155] - v_[93]) + -0.000829 * v_[123] - 1.5e-05 * v_[126] -
              0.000198 * (v_[157] - v_[137]);
    v_[75] = v_[88] * v_[39] + v_[11] * v_[145] + v_[91] * v_[135] + v_[75] * v_[148] + jac[35];
    v_[136] = v_[94] * v_[136] + v_[97] * v_[109] - (v_[98] * v_[125] + v_[5] * v_[105]);
    v_[137] = 0.003227 * v_[132] + 0.000198 * v_[133] + 0.000198 * v_[126] + 1.5e-05 * (0 - v_[137]) -
              0.038686875 * v_[136] - -0.00146 * v_[123] - -0.000829 * v_[147];
    v_[126] = 0.000198 * v_[132] + 0.010737 * v_[133] + 0.00605 * v_[126] + 1.5e-05 * v_[147] - 0.000198 * v_[123] -
              -0.000829 * (0 - v_[157]);
    v_[136] = -0.038686875 * v_[132] + 0.038686875 * v_[123] + 1.547475 * v_[136];
    jac[34] = v_[95] * v_[137] + v_[163] * v_[154] + v_[87] * v_[126] + v_[35] * v_[153] + 0.02075 * v_[136];
    v_[126] = v_[87] * v_[137] + v_[35] * v_[154] + v_[86] * v_[126] + v_[116] * v_[153] + -0.184 * v_[136];
    v_[116] = v_[87] * v_[39] + v_[35] * v_[145] + v_[86] * v_[135] + v_[116] * v_[148];
    jac[33] = v_[61] * v_[75] + v_[62] * v_[126] + v_[73] * v_[136] + v_[67] * v_[116];
    v_[126] = v_[60] * v_[75] + v_[61] * v_[126] + v_[74] * v_[136] + v_[68] * v_[116];
    jac[32] = v_[34] * v_[126] + v_[36] * jac[34];
    v_[75] = v_[61] * v_[136] + v_[69] * v_[116];
    v_[126] = v_[36] * v_[126] + v_[33] * jac[34] + -0.304 * v_[75];
    v_[116] = v_[60] * v_[136] + v_[61] * v_[116];
    v_[135] = v_[89] * v_[39] + v_[122] * v_[145] + v_[87] * v_[135] + v_[35] * v_[148];
    v_[39] = v_[44] * v_[116] + v_[43] * v_[135] + -1 * jac[33];
    v_[135] = v_[36] * v_[116] + v_[33] * v_[135];
    v_[75] = -1 * v_[75];
    jac[30] = v_[0] * jac[32] + v_[9] * (v_[12] * v_[126] + v_[13] * v_[39] + v_[18] * v_[135] + v_[19] * v_[75]);
    jac[31] = v_[13] * v_[126] + v_[28] * v_[39] + v_[52] * v_[135] + v_[25] * v_[75];
    v_[75] = (-v_[0]) * x_in[7];
    v_[135] = v_[9] * x_in[7];
    v_[39] = v_[8] * v_[9] + v_[0] * v_[10];
    v_[126] = v_[13] * v_[9];
    v_[116] = v_[12] * v_[75] + (-v_[126]) * x_in[8];
    v_[35] = v_[12] * v_[9];
    v_[122] = v_[13] * v_[75] + v_[35] * x_in[8];
    v_[148] = v_[19] * v_[9];
    v_[145] = v_[18] * v_[75] + (-v_[148]) * x_in[8];
    v_[136] = v_[18] * v_[9];
    v_[137] = v_[19] * v_[75] + v_[136] * x_in[8];
    v_[153] = v_[24] * v_[148] + v_[0] * v_[26];
    v_[154] = v_[29] * v_[35] + v_[126] * v_[30];
    v_[163] = v_[29] * v_[0] + v_[126] * v_[24];
    v_[123] = -1 * v_[122];
    v_[132] = v_[33] * v_[35] + v_[36] * v_[0];
    v_[133] = v_[34] * v_[135] + v_[36] * v_[116] + (-v_[132]) * x_in[9];
    v_[157] = v_[36] * v_[35] + v_[34] * v_[0];
    v_[147] = v_[36] * v_[135] + v_[33] * v_[116] + v_[157] * x_in[9];
    v_[97] = -0.304 * v_[116] + -1 * v_[137];
    v_[5] = v_[44] * v_[126] + v_[36] * v_[136];
    v_[125] = v_[33] * v_[145] + v_[43] * v_[122] + v_[5] * x_in[9];
    v_[11] = -0.304 * v_[35] + -1 * v_[148];
    v_[155] = -1 * v_[126];
    v_[93] = v_[47] * v_[11] + v_[157] * v_[49] - (v_[50] * v_[5] + v_[155] * v_[54]);
    v_[110] = v_[47] * v_[155] + v_[157] * v_[50];
    v_[83] = v_[50] * v_[155] + v_[155] * v_[50];
    v_[31] = v_[58] * v_[132] + v_[132] * v_[58];
    v_[138] = v_[61] * v_[157] + v_[62] * v_[155];
    v_[144] = v_[61] * v_[123] + v_[60] * v_[133] + (-v_[138]) * x_in[10];
    v_[113] = v_[60] * v_[157] + v_[61] * v_[155];
    v_[158] = v_[62] * v_[123] + v_[61] * v_[133] + v_[113] * x_in[10];
    v_[22] = v_[43] * v_[126] + v_[33] * v_[136];
    v_[107] = v_[36] * v_[145] + v_[44] * v_[122] + (-v_[22]) * x_in[9];
    v_[15] = v_[73] * v_[155] + v_[74] * v_[157] + v_[61] * v_[11] + v_[60] * v_[5];
    v_[76] = v_[67] * v_[123] + v_[68] * v_[133] + v_[69] * v_[97] + v_[61] * v_[107] + v_[15] * x_in[10];
    v_[124] = v_[77] * v_[22] + v_[113] * v_[78] - (v_[79] * v_[15] + v_[132] * v_[80]);
    v_[70] = v_[77] * v_[132] + v_[113] * v_[79];
    v_[139] = v_[79] * v_[132] + v_[132] * v_[79];
    v_[4] = v_[84] * v_[138] + v_[138] * v_[84];
    v_[108] = v_[67] * v_[155] + v_[68] * v_[157] + v_[69] * v_[11] + v_[61] * v_[5];
    v_[72] = v_[87] * v_[22] + v_[86] * v_[108] + v_[91] * v_[113];
    v_[151] = v_[89] * v_[125] + v_[87] * v_[76] + v_[88] * v_[144] + (-v_[72]) * x_in[11];
    v_[160] = v_[87] * v_[138] + v_[95] * v_[132];
    v_[159] = v_[86] * v_[138] + v_[87] * v_[132];
    v_[112] = v_[94] * v_[160] + v_[159] * v_[98];
    v_[37] = 0.02075 * v_[132] + -0.184 * v_[138] + v_[15];
    v_[96] = v_[94] * v_[37] + v_[159] * v_[101];
    v_[141] = v_[103] * v_[72] + v_[113] * v_[105];
    v_[32] = 1.547475 * v_[151] + 0.038686875 * v_[144] + 0.038686875 * v_[112] + -1.547475 * (v_[96] - v_[141]);
    v_[45] = v_[89] * v_[22] + v_[87] * v_[108] + v_[88] * v_[113];
    v_[120] = v_[103] * v_[113] + v_[113] * v_[103];
    v_[42] = v_[98] * v_[160] + v_[160] * v_[98];
    v_[37] = 1.547475 * (v_[98] * v_[37] + v_[160] * v_[101] - (v_[103] * v_[45] + v_[113] * v_[109])) +
             1.547475 * (v_[87] * v_[125] + v_[86] * v_[76] + v_[91] * v_[144] + v_[45] * x_in[11]) -
             0.038686875 * (v_[120] + v_[42]);
    v_[3] = v_[95] * v_[147] + v_[87] * v_[158] + (-v_[159]) * x_in[11];
    v_[99] = v_[87] * v_[147] + v_[86] * v_[158] + v_[160] * x_in[11];
    v_[117] = v_[94] * v_[113] + v_[159] * v_[103];
    v_[142] = v_[98] * v_[113] + v_[160] * v_[103];
    v_[71] = v_[94] * v_[159] + v_[159] * v_[94];
    jac[41] = 0.009277 * v_[144] + -0.000829 * v_[3] + 1.5e-05 * v_[99] + 0.038686875 * v_[151] + -0.00751 * v_[112] +
              0.038686875 * (v_[141] - v_[96]) + -0.000829 * v_[117] - 1.5e-05 * v_[142] - 0.000198 * (v_[42] - v_[71]);
    v_[141] = v_[84] * v_[132] + v_[138] * v_[79];
    v_[96] = v_[84] * v_[113] + v_[138] * v_[77];
    v_[151] = -0.001243 * v_[147] + 0.029115 * v_[144] + -0.001387 * v_[158] + 0.057838 * v_[76] + 0.057838 * v_[124] +
              -0.001387 * v_[70] + -0.012652 * (v_[139] - v_[4]) + v_[88] * v_[32] + v_[91] * v_[37] + jac[41] -
              -0.008386 * v_[141] - -0.001243 * v_[96];
    v_[102] = v_[73] * v_[123] + v_[74] * v_[133] + v_[61] * v_[97] + v_[60] * v_[107] + (-v_[108]) * x_in[10];
    v_[152] = v_[84] * v_[22] + v_[138] * v_[78] - (v_[79] * v_[108] + v_[132] * v_[104]);
    v_[23] = 0.02075 * v_[147] + -0.184 * v_[158] + v_[102];
    v_[45] = v_[94] * v_[45] + v_[159] * v_[109] - (v_[98] * v_[72] + v_[160] * v_[105]);
    v_[71] = -0.000829 * v_[144] + 0.003227 * v_[3] + 0.000198 * v_[99] + -0.038686875 * v_[23] + 0.000198 * v_[142] +
             1.5e-05 * (v_[120] - v_[71]) - 0.038686875 * v_[45] - -0.00146 * v_[117] - -0.000829 * v_[112];
    v_[142] = 1.5e-05 * v_[144] + 0.000198 * v_[3] + 0.010737 * v_[99] + 0.00605 * v_[142] + 1.5e-05 * v_[112] -
              0.000198 * v_[117] - -0.000829 * (v_[120] - v_[42]);
    v_[45] = 1.547475 * v_[23] + -0.038686875 * v_[3] + 0.038686875 * v_[117] + 1.547475 * v_[45];
    v_[23] = v_[77] * v_[113] + v_[113] * v_[77];
    jac[40] = 0.011046 * v_[147] + -0.001243 * v_[144] + -0.012652 * v_[158] + -0.001243 * v_[141] + 0.009683 * v_[96] +
              v_[95] * v_[71] + v_[87] * v_[142] + 0.02075 * v_[45] - -0.012652 * v_[70] - -0.001387 * (v_[23] - v_[4]);
    v_[142] = -0.012652 * v_[147] + -0.001387 * v_[144] + 0.019432 * v_[158] + -0.057838 * v_[102] +
              -0.018069 * v_[70] + 0.057838 * v_[152] + -0.012652 * v_[96] + v_[87] * v_[71] + v_[86] * v_[142] +
              -0.184 * v_[45] - -0.001387 * v_[141] - -0.001243 * (v_[139] - v_[23]);
    v_[45] = 2.1032 * v_[102] + -0.057838 * v_[158] + 0.057838 * v_[70] + -2.1032 * v_[152] + v_[45];
    v_[141] = 2.1032 * v_[76] + 0.057838 * v_[144] + 0.057838 * v_[141] + 2.1032 * v_[124] + v_[87] * v_[32] +
              v_[86] * v_[37];
    v_[5] = v_[58] * v_[5] + v_[132] * v_[54] - (v_[47] * v_[22] + v_[157] * v_[78]);
    v_[124] = v_[58] * v_[155] + v_[132] * v_[50];
    v_[76] = v_[58] * v_[157] + v_[132] * v_[47];
    v_[144] = -0.0022920002 * v_[123] + 0.01828449 * v_[133] + 0.0036857284 * v_[147] + -0.160298259823722 * v_[97] +
              1.52322944854339e-09 * v_[125] + 1.52322944854339e-09 * v_[93] + 0.0036857284 * v_[110] +
              -0.00021200017 * (v_[83] - v_[31]) + v_[60] * v_[151] + v_[61] * v_[142] + v_[74] * v_[45] +
              v_[68] * v_[141] - 0.160298259823722 * v_[5] - 0.01404749 * v_[124] - -0.0022920002 * v_[76];
    v_[11] = v_[58] * v_[11] + v_[132] * v_[49];
    v_[22] = v_[50] * v_[22] + v_[155] * v_[78];
    v_[157] = v_[47] * v_[157] + v_[157] * v_[47];
    jac[39] = 0.09570849 * v_[123] + -0.0022920002 * v_[133] + -0.00021200017 * v_[147] + 0.160298259823722 * v_[107] +
              0.008711861 * v_[125] + 0.160298259823722 * (v_[22] - v_[11]) + -0.06337651 * v_[76] +
              -0.0022920002 * v_[124] + v_[61] * v_[151] + v_[62] * v_[142] + v_[73] * v_[45] + v_[67] * v_[141] -
              -0.008711861 * v_[93] - -0.00021200017 * v_[110] - 0.0036857284 * (v_[157] - v_[31]);
    v_[142] = -0.00021200017 * v_[123] + 0.0036857284 * v_[133] + 0.081661 * v_[147] + -0.008711861 * v_[97] +
              -1.52322944854339e-09 * v_[107] + -0.008711861 * v_[5] + 1.52322944854339e-09 * (v_[11] - v_[22]) +
              0.077424 * v_[110] + -0.00021200017 * v_[76] + jac[40] - 0.0036857284 * v_[124] -
              -0.0022920002 * (v_[83] - v_[157]);
    v_[151] = -(v_[24] * v_[136] + v_[0] * v_[53]);
    v_[155] = v_[30] * v_[0] + v_[35] * v_[24];
    v_[132] = v_[30] * v_[35] + v_[35] * v_[30];
    v_[152] = v_[29] * v_[126] + v_[126] * v_[29];
    jac[38] = 0.010329999 * v_[135] + -0.0037997814 * v_[116] + -0.011715295 * v_[122] + -0.0055615274403 * v_[145] +
              -0.01438086 * v_[137] + -0.0055615274403 * v_[153] + 0.00750500000000001 * v_[154] +
              -0.0037997814 * v_[163] + v_[34] * v_[144] + v_[36] * v_[142] - 0.01438086 * v_[151] -
              -0.011715295 * v_[155] - 5.399998e-05 * (v_[132] - v_[152]);
    v_[102] = v_[0] * x_in[7];
    v_[70] = v_[10] * v_[9] + v_[9] * v_[10];
    v_[158] = v_[8] * v_[0] + v_[0] * v_[8];
    v_[71] = v_[24] * v_[0] + v_[0] * v_[24];
    v_[5] = -0.160298259823722 * v_[133] + -0.008711861 * v_[147] + 1.7423722 * v_[97] + 1.7423722 * v_[5] +
            0.160298259823722 * v_[124] + -0.008711861 * v_[110] + v_[61] * v_[45] + v_[69] * v_[141] -
            1.52322944854339e-09 * (v_[157] + v_[31]);
    v_[136] = v_[29] * v_[136] + v_[126] * v_[53] - (v_[30] * v_[148] + v_[35] * v_[26]);
    v_[142] = -0.0037997814 * v_[135] + 0.20986895 * v_[116] + 5.399998e-05 * v_[122] + 0.647967112 * v_[137] +
              0.647967112 * v_[151] + 5.399998e-05 * v_[155] + -0.011715295 * (v_[71] - v_[152]) + v_[36] * v_[144] +
              v_[33] * v_[142] + -0.304 * v_[5] - -0.0055615274403 * v_[136] - -0.192033951 * v_[163] -
              -0.0037997814 * v_[154];
    v_[153] = -v_[153];
    v_[22] = 0.160298259823722 * v_[123] + -1.52322944854339e-09 * v_[147] + 1.7423722 * v_[107] +
             -1.7423722 * (v_[11] - v_[22]) + 0.160298259823722 * v_[76] + 1.52322944854339e-09 * v_[110] +
             v_[60] * v_[45] + v_[61] * v_[141] - -0.008711861 * (v_[83] + v_[31]);
    v_[157] = 0.008711861 * v_[123] + 1.52322944854339e-09 * v_[133] + 1.7423722 * v_[125] + 1.7423722 * v_[93] +
              1.52322944854339e-09 * v_[124] + -0.008711861 * v_[76] +
              2.1032 * (v_[84] * v_[15] + v_[138] * v_[80] - (v_[77] * v_[108] + v_[113] * v_[104])) +
              2.1032 * v_[125] + v_[89] * v_[32] + v_[87] * v_[37] - 0.160298259823722 * (v_[83] + v_[157]) -
              0.057838 * (v_[23] + v_[4]);
    v_[136] = -0.011715295 * v_[135] + 5.399998e-05 * v_[116] + 0.20236395 * v_[122] + -0.647967112 * v_[145] +
              0.01438086 * v_[136] + 0.647967112 * v_[153] + -0.199538951 * v_[155] + -0.011715295 * v_[154] +
              v_[44] * v_[22] + v_[43] * v_[157] + -1 * jac[39] - 5.399998e-05 * v_[163] -
              -0.0037997814 * (v_[71] - v_[132]);
    v_[157] = -0.0055615274403 * v_[135] + -0.647967112 * v_[122] + 2.327 * v_[145] + -2.327 * v_[153] +
              -0.0055615274403 * v_[154] + 0.647967112 * v_[155] + v_[36] * v_[22] + v_[33] * v_[157] -
              0.01438086 * (v_[71] + v_[152]);
    v_[5] = -0.01438086 * v_[135] + 0.647967112 * v_[116] + 2.327 * v_[137] + 2.327 * v_[151] + 0.647967112 * v_[163] +
            0.01438086 * v_[154] + -1 * v_[5] - -0.0055615274403 * (v_[71] + v_[132]);
    jac[36] = v_[0] * (0.0055279857 * v_[75] + 0.039002996 * v_[135] + -0.034462002 * v_[135] + -0.022851627 * v_[39] +
                          jac[38] - 0.0055279857 * v_[102] - -0.002752 * (0 - v_[70])) +
              v_[9] * (0.08585553 * v_[75] + 0.0055279857 * v_[135] + 0.0055279857 * v_[135] +
                          -0.022851627 * (0 - v_[158]) + v_[12] * v_[142] + v_[13] * v_[136] + v_[18] * v_[157] +
                          v_[19] * v_[5] - 0.012390532 * v_[102] - -0.002752 * v_[39]);
    jac[37] = -0.002752 * v_[75] + -0.022851627 * v_[135] + -0.002752 * v_[102] + 0.046852534 * v_[39] +
              v_[13] * v_[142] + v_[28] * v_[136] + v_[52] * v_[157] + v_[25] * v_[5] - -0.022851627 * v_[135] -
              0.0055279857 * (v_[70] - v_[158]);
    v_[5] = v_[12] * v_[82] + (-v_[28]) * x_in[8];
    v_[157] = v_[13] * v_[82] + v_[13] * x_in[8];
    v_[136] = v_[18] * v_[82] + (-v_[25]) * x_in[8];
    v_[142] = v_[19] * v_[82] + v_[52] * x_in[8];
    v_[158] = v_[24] * v_[25];
    v_[70] = v_[29] * v_[13] + v_[28] * v_[30];
    v_[102] = v_[28] * v_[24];
    v_[39] = -1 * v_[157];
    v_[135] = v_[33] * v_[13];
    v_[75] = v_[34] * v_[10] + v_[36] * v_[5] + (-v_[135]) * x_in[9];
    v_[71] = v_[36] * v_[13];
    v_[132] = v_[36] * v_[10] + v_[33] * v_[5] + v_[71] * x_in[9];
    v_[151] = -0.304 * v_[5] + -1 * v_[142];
    v_[163] = v_[44] * v_[28] + v_[36] * v_[52];
    v_[154] = v_[33] * v_[136] + v_[43] * v_[157] + v_[163] * x_in[9];
    v_[137] = -0.304 * v_[13] + -1 * v_[25];
    v_[116] = -1 * v_[28];
    v_[22] = v_[47] * v_[137] + v_[71] * v_[49] - (v_[50] * v_[163] + v_[116] * v_[54]);
    v_[153] = v_[47] * v_[116] + v_[71] * v_[50];
    v_[152] = v_[50] * v_[116] + v_[116] * v_[50];
    v_[155] = v_[58] * v_[135] + v_[135] * v_[58];
    v_[145] = v_[61] * v_[71] + v_[62] * v_[116];
    v_[122] = v_[61] * v_[39] + v_[60] * v_[75] + (-v_[145]) * x_in[10];
    v_[76] = v_[60] * v_[71] + v_[61] * v_[116];
    v_[124] = v_[62] * v_[39] + v_[61] * v_[75] + v_[76] * x_in[10];
    v_[23] = v_[43] * v_[28] + v_[33] * v_[52];
    v_[37] = v_[36] * v_[136] + v_[44] * v_[157] + (-v_[23]) * x_in[9];
    v_[32] = v_[73] * v_[116] + v_[74] * v_[71] + v_[61] * v_[137] + v_[60] * v_[163];
    v_[108] = v_[67] * v_[39] + v_[68] * v_[75] + v_[69] * v_[151] + v_[61] * v_[37] + v_[32] * x_in[10];
    v_[4] = v_[77] * v_[23] + v_[76] * v_[78] - (v_[79] * v_[32] + v_[135] * v_[80]);
    v_[15] = v_[77] * v_[135] + v_[76] * v_[79];
    v_[113] = v_[79] * v_[135] + v_[135] * v_[79];
    v_[138] = v_[84] * v_[145] + v_[145] * v_[84];
    v_[83] = v_[67] * v_[116] + v_[68] * v_[71] + v_[69] * v_[137] + v_[61] * v_[163];
    v_[93] = v_[87] * v_[23] + v_[86] * v_[83] + v_[91] * v_[76];
    v_[125] = v_[89] * v_[154] + v_[87] * v_[108] + v_[88] * v_[122] + (-v_[93]) * x_in[11];
    v_[133] = v_[87] * v_[145] + v_[95] * v_[135];
    v_[123] = v_[86] * v_[145] + v_[87] * v_[135];
    v_[11] = v_[94] * v_[133] + v_[123] * v_[98];
    v_[141] = 0.02075 * v_[135] + -0.184 * v_[145] + v_[32];
    v_[45] = v_[94] * v_[141] + v_[123] * v_[101];
    v_[107] = v_[103] * v_[93] + v_[76] * v_[105];
    v_[31] = 1.547475 * v_[125] + 0.038686875 * v_[122] + 0.038686875 * v_[11] + -1.547475 * (v_[45] - v_[107]);
    v_[110] = v_[89] * v_[23] + v_[87] * v_[83] + v_[88] * v_[76];
    v_[147] = v_[103] * v_[76] + v_[76] * v_[103];
    v_[144] = v_[98] * v_[133] + v_[133] * v_[98];
    v_[141] = 1.547475 * (v_[98] * v_[141] + v_[133] * v_[101] - (v_[103] * v_[110] + v_[76] * v_[109])) +
              1.547475 * (v_[87] * v_[154] + v_[86] * v_[108] + v_[91] * v_[122] + v_[110] * x_in[11]) -
              0.038686875 * (v_[147] + v_[144]);
    v_[148] = v_[95] * v_[132] + v_[87] * v_[124] + (-v_[123]) * x_in[11];
    v_[35] = v_[87] * v_[132] + v_[86] * v_[124] + v_[133] * x_in[11];
    v_[126] = v_[94] * v_[76] + v_[123] * v_[103];
    v_[97] = v_[98] * v_[76] + v_[133] * v_[103];
    v_[96] = v_[94] * v_[123] + v_[123] * v_[94];
    jac[47] = 0.009277 * v_[122] + -0.000829 * v_[148] + 1.5e-05 * v_[35] + 0.038686875 * v_[125] + -0.00751 * v_[11] +
              0.038686875 * (v_[107] - v_[45]) + -0.000829 * v_[126] - 1.5e-05 * v_[97] - 0.000198 * (v_[144] - v_[96]);
    v_[107] = v_[84] * v_[135] + v_[145] * v_[79];
    v_[45] = v_[84] * v_[76] + v_[145] * v_[77];
    v_[125] = -0.001243 * v_[132] + 0.029115 * v_[122] + -0.001387 * v_[124] + 0.057838 * v_[108] + 0.057838 * v_[4] +
              -0.001387 * v_[15] + -0.012652 * (v_[113] - v_[138]) + v_[88] * v_[31] + v_[91] * v_[141] + jac[47] -
              -0.008386 * v_[107] - -0.001243 * v_[45];
    v_[139] = v_[73] * v_[39] + v_[74] * v_[75] + v_[61] * v_[151] + v_[60] * v_[37] + (-v_[83]) * x_in[10];
    v_[117] = v_[84] * v_[23] + v_[145] * v_[78] - (v_[79] * v_[83] + v_[135] * v_[104]);
    v_[3] = 0.02075 * v_[132] + -0.184 * v_[124] + v_[139];
    v_[110] = v_[94] * v_[110] + v_[123] * v_[109] - (v_[98] * v_[93] + v_[133] * v_[105]);
    v_[96] = -0.000829 * v_[122] + 0.003227 * v_[148] + 0.000198 * v_[35] + -0.038686875 * v_[3] + 0.000198 * v_[97] +
             1.5e-05 * (v_[147] - v_[96]) - 0.038686875 * v_[110] - -0.00146 * v_[126] - -0.000829 * v_[11];
    v_[97] = 1.5e-05 * v_[122] + 0.000198 * v_[148] + 0.010737 * v_[35] + 0.00605 * v_[97] + 1.5e-05 * v_[11] -
             0.000198 * v_[126] - -0.000829 * (v_[147] - v_[144]);
    v_[110] = 1.547475 * v_[3] + -0.038686875 * v_[148] + 0.038686875 * v_[126] + 1.547475 * v_[110];
    v_[3] = v_[77] * v_[76] + v_[76] * v_[77];
    jac[46] = 0.011046 * v_[132] + -0.001243 * v_[122] + -0.012652 * v_[124] + -0.001243 * v_[107] + 0.009683 * v_[45] +
              v_[95] * v_[96] + v_[87] * v_[97] + 0.02075 * v_[110] - -0.012652 * v_[15] -
              -0.001387 * (v_[3] - v_[138]);
    v_[97] = -0.012652 * v_[132] + -0.001387 * v_[122] + 0.019432 * v_[124] + -0.057838 * v_[139] + -0.018069 * v_[15] +
             0.057838 * v_[117] + -0.012652 * v_[45] + v_[87] * v_[96] + v_[86] * v_[97] + -0.184 * v_[110] -
             -0.001387 * v_[107] - -0.001243 * (v_[113] - v_[3]);
    v_[110] = 2.1032 * v_[139] + -0.057838 * v_[124] + 0.057838 * v_[15] + -2.1032 * v_[117] + v_[110];
    v_[107] = 2.1032 * v_[108] + 0.057838 * v_[122] + 0.057838 * v_[107] + 2.1032 * v_[4] + v_[87] * v_[31] +
              v_[86] * v_[141];
    v_[163] = v_[58] * v_[163] + v_[135] * v_[54] - (v_[47] * v_[23] + v_[71] * v_[78]);
    v_[4] = v_[58] * v_[116] + v_[135] * v_[50];
    v_[108] = v_[58] * v_[71] + v_[135] * v_[47];
    v_[122] = -0.0022920002 * v_[39] + 0.01828449 * v_[75] + 0.0036857284 * v_[132] + -0.160298259823722 * v_[151] +
              1.52322944854339e-09 * v_[154] + 1.52322944854339e-09 * v_[22] + 0.0036857284 * v_[153] +
              -0.00021200017 * (v_[152] - v_[155]) + v_[60] * v_[125] + v_[61] * v_[97] + v_[74] * v_[110] +
              v_[68] * v_[107] - 0.160298259823722 * v_[163] - 0.01404749 * v_[4] - -0.0022920002 * v_[108];
    v_[137] = v_[58] * v_[137] + v_[135] * v_[49];
    v_[23] = v_[50] * v_[23] + v_[116] * v_[78];
    v_[71] = v_[47] * v_[71] + v_[71] * v_[47];
    jac[45] = 0.09570849 * v_[39] + -0.0022920002 * v_[75] + -0.00021200017 * v_[132] + 0.160298259823722 * v_[37] +
              0.008711861 * v_[154] + 0.160298259823722 * (v_[23] - v_[137]) + -0.06337651 * v_[108] +
              -0.0022920002 * v_[4] + v_[61] * v_[125] + v_[62] * v_[97] + v_[73] * v_[110] + v_[67] * v_[107] -
              -0.008711861 * v_[22] - -0.00021200017 * v_[153] - 0.0036857284 * (v_[71] - v_[155]);
    v_[97] = -0.00021200017 * v_[39] + 0.0036857284 * v_[75] + 0.081661 * v_[132] + -0.008711861 * v_[151] +
             -1.52322944854339e-09 * v_[37] + -0.008711861 * v_[163] + 1.52322944854339e-09 * (v_[137] - v_[23]) +
             0.077424 * v_[153] + -0.00021200017 * v_[108] + jac[46] - 0.0036857284 * v_[4] -
             -0.0022920002 * (v_[152] - v_[71]);
    v_[125] = -v_[24] * v_[52];
    v_[116] = v_[13] * v_[24];
    v_[135] = v_[30] * v_[13] + v_[13] * v_[30];
    v_[117] = v_[29] * v_[28] + v_[28] * v_[29];
    jac[44] = 0.010329999 * v_[10] + -0.0037997814 * v_[5] + -0.011715295 * v_[157] + -0.0055615274403 * v_[136] +
              -0.01438086 * v_[142] + -0.0055615274403 * v_[158] + 0.00750500000000001 * v_[70] +
              -0.0037997814 * v_[102] + v_[34] * v_[122] + v_[36] * v_[97] - 0.01438086 * v_[125] -
              -0.011715295 * v_[116] - 5.399998e-05 * (v_[135] - v_[117]);
    v_[139] = x_in[7] + x_in[7];
    v_[163] = -0.160298259823722 * v_[75] + -0.008711861 * v_[132] + 1.7423722 * v_[151] + 1.7423722 * v_[163] +
              0.160298259823722 * v_[4] + -0.008711861 * v_[153] + v_[61] * v_[110] + v_[69] * v_[107] -
              1.52322944854339e-09 * (v_[71] + v_[155]);
    v_[151] = v_[29] * v_[52] + v_[28] * v_[53] - (v_[30] * v_[25] + v_[13] * v_[26]);
    v_[97] = -0.0037997814 * v_[10] + 0.20986895 * v_[5] + 5.399998e-05 * v_[157] + 0.647967112 * v_[142] +
             0.647967112 * v_[125] + 5.399998e-05 * v_[116] + -0.011715295 * (0 - v_[117]) + v_[36] * v_[122] +
             v_[33] * v_[97] + -0.304 * v_[163] - -0.0055615274403 * v_[151] - -0.192033951 * v_[102] -
             -0.0037997814 * v_[70];
    v_[158] = -v_[158];
    v_[23] = 0.160298259823722 * v_[39] + -1.52322944854339e-09 * v_[132] + 1.7423722 * v_[37] +
             -1.7423722 * (v_[137] - v_[23]) + 0.160298259823722 * v_[108] + 1.52322944854339e-09 * v_[153] +
             v_[60] * v_[110] + v_[61] * v_[107] - -0.008711861 * (v_[152] + v_[155]);
    v_[71] = 0.008711861 * v_[39] + 1.52322944854339e-09 * v_[75] + 1.7423722 * v_[154] + 1.7423722 * v_[22] +
             1.52322944854339e-09 * v_[4] + -0.008711861 * v_[108] +
             2.1032 * (v_[84] * v_[32] + v_[145] * v_[80] - (v_[77] * v_[83] + v_[76] * v_[104])) + 2.1032 * v_[154] +
             v_[89] * v_[31] + v_[87] * v_[141] - 0.160298259823722 * (v_[152] + v_[71]) - 0.057838 * (v_[3] + v_[138]);
    v_[151] = -0.011715295 * v_[10] + 5.399998e-05 * v_[5] + 0.20236395 * v_[157] + -0.647967112 * v_[136] +
              0.01438086 * v_[151] + 0.647967112 * v_[158] + -0.199538951 * v_[116] + -0.011715295 * v_[70] +
              v_[44] * v_[23] + v_[43] * v_[71] + -1 * jac[45] - 5.399998e-05 * v_[102] - -0.0037997814 * (0 - v_[135]);
    v_[71] = -0.0055615274403 * v_[10] + -0.647967112 * v_[157] + 2.327 * v_[136] + -2.327 * v_[158] +
             -0.0055615274403 * v_[70] + 0.647967112 * v_[116] + v_[36] * v_[23] + v_[33] * v_[71] -
             0.01438086 * v_[117];
    v_[163] = -0.01438086 * v_[10] + 0.647967112 * v_[5] + 2.327 * v_[142] + 2.327 * v_[125] + 0.647967112 * v_[102] +
              0.01438086 * v_[70] + -1 * v_[163] - -0.0055615274403 * v_[135];
    jac[42] =
        v_[0] * (0.0055279857 * v_[82] + 0.039002996 * v_[10] + -0.034462002 * v_[10] + jac[44] - 0.0055279857 * v_[8] -
                    -0.002752 * v_[139]) +
        v_[9] * (0.08585553 * v_[82] + 0.0055279857 * v_[10] + 0.0055279857 * v_[10] + -0.022851627 * v_[139] +
                    v_[12] * v_[97] + v_[13] * v_[151] + v_[18] * v_[71] + v_[19] * v_[163] - 0.012390532 * v_[8]);
    jac[43] = -0.002752 * v_[82] + -0.022851627 * v_[10] + -0.002752 * v_[8] + v_[13] * v_[97] + v_[28] * v_[151] +
              v_[52] * v_[71] + v_[25] * v_[163] - -0.022851627 * v_[10];
    v_[163] = -1 * v_[30];
    v_[71] = v_[36] * v_[114] + (-v_[36]) * x_in[9];
    v_[151] = v_[33] * v_[114] + v_[34] * x_in[9];
    v_[97] = -0.304 * v_[114] + -1 * v_[53];
    v_[82] = v_[33] * v_[111] + v_[43] * v_[30];
    v_[10] = v_[34] * v_[49];
    v_[8] = v_[34] * v_[50];
    v_[139] = v_[58] * v_[36] + v_[36] * v_[58];
    v_[135] = v_[61] * v_[34];
    v_[125] = v_[61] * v_[163] + v_[60] * v_[71] + (-v_[135]) * x_in[10];
    v_[102] = v_[60] * v_[34];
    v_[70] = v_[62] * v_[163] + v_[61] * v_[71] + v_[102] * x_in[10];
    v_[142] = v_[36] * v_[111] + v_[44] * v_[30];
    v_[5] = v_[74] * v_[34];
    v_[23] = v_[67] * v_[163] + v_[68] * v_[71] + v_[69] * v_[97] + v_[61] * v_[142] + v_[5] * x_in[10];
    v_[158] = v_[102] * v_[78] - (v_[79] * v_[5] + v_[36] * v_[80]);
    v_[117] = v_[77] * v_[36] + v_[102] * v_[79];
    v_[116] = v_[79] * v_[36] + v_[36] * v_[79];
    v_[136] = v_[84] * v_[135] + v_[135] * v_[84];
    v_[157] = v_[68] * v_[34];
    v_[108] = v_[86] * v_[157] + v_[91] * v_[102];
    v_[4] = v_[89] * v_[82] + v_[87] * v_[23] + v_[88] * v_[125] + (-v_[108]) * x_in[11];
    v_[3] = v_[87] * v_[135] + v_[95] * v_[36];
    v_[141] = v_[86] * v_[135] + v_[87] * v_[36];
    v_[31] = v_[94] * v_[3] + v_[141] * v_[98];
    v_[83] = 0.02075 * v_[36] + -0.184 * v_[135] + v_[5];
    v_[138] = v_[94] * v_[83] + v_[141] * v_[101];
    v_[32] = v_[103] * v_[108] + v_[102] * v_[105];
    v_[76] = 1.547475 * v_[4] + 0.038686875 * v_[125] + 0.038686875 * v_[31] + -1.547475 * (v_[138] - v_[32]);
    v_[145] = v_[87] * v_[157] + v_[88] * v_[102];
    v_[152] = v_[103] * v_[102] + v_[102] * v_[103];
    v_[22] = v_[98] * v_[3] + v_[3] * v_[98];
    v_[83] = 1.547475 * (v_[98] * v_[83] + v_[3] * v_[101] - (v_[103] * v_[145] + v_[102] * v_[109])) +
             1.547475 * (v_[87] * v_[82] + v_[86] * v_[23] + v_[91] * v_[125] + v_[145] * x_in[11]) -
             0.038686875 * (v_[152] + v_[22]);
    v_[154] = v_[95] * v_[151] + v_[87] * v_[70] + (-v_[141]) * x_in[11];
    v_[75] = v_[87] * v_[151] + v_[86] * v_[70] + v_[3] * x_in[11];
    v_[39] = v_[94] * v_[102] + v_[141] * v_[103];
    v_[137] = v_[98] * v_[102] + v_[3] * v_[103];
    v_[107] = v_[94] * v_[141] + v_[141] * v_[94];
    jac[53] = 0.009277 * v_[125] + -0.000829 * v_[154] + 1.5e-05 * v_[75] + 0.038686875 * v_[4] + -0.00751 * v_[31] +
              0.038686875 * (v_[32] - v_[138]) + -0.000829 * v_[39] - 1.5e-05 * v_[137] - 0.000198 * (v_[22] - v_[107]);
    v_[32] = v_[84] * v_[36] + v_[135] * v_[79];
    v_[138] = v_[84] * v_[102] + v_[135] * v_[77];
    v_[4] = -0.001243 * v_[151] + 0.029115 * v_[125] + -0.001387 * v_[70] + 0.057838 * v_[23] + 0.057838 * v_[158] +
            -0.001387 * v_[117] + -0.012652 * (v_[116] - v_[136]) + v_[88] * v_[76] + v_[91] * v_[83] + jac[53] -
            -0.008386 * v_[32] - -0.001243 * v_[138];
    v_[110] = v_[73] * v_[163] + v_[74] * v_[71] + v_[61] * v_[97] + v_[60] * v_[142] + (-v_[157]) * x_in[10];
    v_[37] = v_[135] * v_[78] - (v_[79] * v_[157] + v_[36] * v_[104]);
    v_[155] = 0.02075 * v_[151] + -0.184 * v_[70] + v_[110];
    v_[145] = v_[94] * v_[145] + v_[141] * v_[109] - (v_[98] * v_[108] + v_[3] * v_[105]);
    v_[107] = -0.000829 * v_[125] + 0.003227 * v_[154] + 0.000198 * v_[75] + -0.038686875 * v_[155] +
              0.000198 * v_[137] + 1.5e-05 * (v_[152] - v_[107]) - 0.038686875 * v_[145] - -0.00146 * v_[39] -
              -0.000829 * v_[31];
    v_[137] = 1.5e-05 * v_[125] + 0.000198 * v_[154] + 0.010737 * v_[75] + 0.00605 * v_[137] + 1.5e-05 * v_[31] -
              0.000198 * v_[39] - -0.000829 * (v_[152] - v_[22]);
    v_[145] = 1.547475 * v_[155] + -0.038686875 * v_[154] + 0.038686875 * v_[39] + 1.547475 * v_[145];
    v_[155] = v_[77] * v_[102] + v_[102] * v_[77];
    jac[52] = 0.011046 * v_[151] + -0.001243 * v_[125] + -0.012652 * v_[70] + -0.001243 * v_[32] + 0.009683 * v_[138] +
              v_[95] * v_[107] + v_[87] * v_[137] + 0.02075 * v_[145] - -0.012652 * v_[117] -
              -0.001387 * (v_[155] - v_[136]);
    v_[137] = -0.012652 * v_[151] + -0.001387 * v_[125] + 0.019432 * v_[70] + -0.057838 * v_[110] +
              -0.018069 * v_[117] + 0.057838 * v_[37] + -0.012652 * v_[138] + v_[87] * v_[107] + v_[86] * v_[137] +
              -0.184 * v_[145] - -0.001387 * v_[32] - -0.001243 * (v_[116] - v_[155]);
    v_[145] = 2.1032 * v_[110] + -0.057838 * v_[70] + 0.057838 * v_[117] + -2.1032 * v_[37] + v_[145];
    v_[32] =
        2.1032 * v_[23] + 0.057838 * v_[125] + 0.057838 * v_[32] + 2.1032 * v_[158] + v_[87] * v_[76] + v_[86] * v_[83];
    v_[158] = v_[36] * v_[54] - v_[34] * v_[78];
    v_[23] = v_[36] * v_[50];
    v_[125] = v_[58] * v_[34] + v_[36] * v_[47];
    v_[37] = -0.0022920002 * v_[163] + 0.01828449 * v_[71] + 0.0036857284 * v_[151] + -0.160298259823722 * v_[97] +
             1.52322944854339e-09 * v_[82] + 1.52322944854339e-09 * v_[10] + 0.0036857284 * v_[8] +
             -0.00021200017 * (0 - v_[139]) + v_[60] * v_[4] + v_[61] * v_[137] + v_[74] * v_[145] + v_[68] * v_[32] -
             0.160298259823722 * v_[158] - 0.01404749 * v_[23] - -0.0022920002 * v_[125];
    v_[49] = v_[36] * v_[49];
    v_[110] = v_[47] * v_[34] + v_[34] * v_[47];
    jac[51] = 0.09570849 * v_[163] + -0.0022920002 * v_[71] + -0.00021200017 * v_[151] + 0.160298259823722 * v_[142] +
              0.008711861 * v_[82] + 0.160298259823722 * (0 - v_[49]) + -0.06337651 * v_[125] + -0.0022920002 * v_[23] +
              v_[61] * v_[4] + v_[62] * v_[137] + v_[73] * v_[145] + v_[67] * v_[32] - -0.008711861 * v_[10] -
              -0.00021200017 * v_[8] - 0.0036857284 * (v_[110] - v_[139]);
    v_[137] = -0.00021200017 * v_[163] + 0.0036857284 * v_[71] + 0.081661 * v_[151] + -0.008711861 * v_[97] +
              -1.52322944854339e-09 * v_[142] + -0.008711861 * v_[158] + 1.52322944854339e-09 * v_[49] +
              0.077424 * v_[8] + -0.00021200017 * v_[125] + jac[52] - 0.0036857284 * v_[23] -
              -0.0022920002 * (0 - v_[110]);
    v_[4] = -v_[53];
    jac[50] = -0.0037997814 * v_[114] + -0.011715295 * v_[30] + -0.0055615274403 * v_[111] + -0.01438086 * v_[53] +
              -0.0055615274403 * v_[26] + -0.0037997814 * v_[29] + v_[34] * v_[37] + v_[36] * v_[137] -
              0.01438086 * v_[4] - -0.011715295 * v_[30];
    v_[24] = v_[24] + v_[24];
    v_[158] = -0.160298259823722 * v_[71] + -0.008711861 * v_[151] + 1.7423722 * v_[97] + 1.7423722 * v_[158] +
              0.160298259823722 * v_[23] + -0.008711861 * v_[8] + v_[61] * v_[145] + v_[69] * v_[32] -
              1.52322944854339e-09 * (v_[110] + v_[139]);
    v_[137] = 0.20986895 * v_[114] + 5.399998e-05 * v_[30] + 0.647967112 * v_[53] + 0.647967112 * v_[4] +
              5.399998e-05 * v_[30] + -0.011715295 * v_[24] + v_[36] * v_[37] + v_[33] * v_[137] + -0.304 * v_[158] -
              -0.192033951 * v_[29];
    v_[26] = -v_[26];
    v_[49] = 0.160298259823722 * v_[163] + -1.52322944854339e-09 * v_[151] + 1.7423722 * v_[142] + -1.7423722 * v_[49] +
             0.160298259823722 * v_[125] + 1.52322944854339e-09 * v_[8] + v_[60] * v_[145] + v_[61] * v_[32] -
             -0.008711861 * v_[139];
    v_[110] = 0.008711861 * v_[163] + 1.52322944854339e-09 * v_[71] + 1.7423722 * v_[82] + 1.7423722 * v_[10] +
              1.52322944854339e-09 * v_[23] + -0.008711861 * v_[125] +
              2.1032 * (v_[84] * v_[5] + v_[135] * v_[80] - (v_[77] * v_[157] + v_[102] * v_[104])) + 2.1032 * v_[82] +
              v_[89] * v_[76] + v_[87] * v_[83] - 0.160298259823722 * v_[110] - 0.057838 * (v_[155] + v_[136]);
    v_[125] = 5.399998e-05 * v_[114] + 0.20236395 * v_[30] + -0.647967112 * v_[111] + 0.647967112 * v_[26] +
              -0.199538951 * v_[30] + v_[44] * v_[49] + v_[43] * v_[110] + -1 * jac[51] - 5.399998e-05 * v_[29] -
              -0.0037997814 * v_[24];
    v_[110] = -0.647967112 * v_[30] + 2.327 * v_[111] + -2.327 * v_[26] + 0.647967112 * v_[30] + v_[36] * v_[49] +
              v_[33] * v_[110] - 0.01438086 * v_[24];
    v_[158] = 0.647967112 * v_[114] + 2.327 * v_[53] + 2.327 * v_[4] + 0.647967112 * v_[29] + -1 * v_[158] -
              -0.0055615274403 * v_[24];
    jac[48] = v_[0] * jac[50] + v_[9] * (v_[12] * v_[137] + v_[13] * v_[125] + v_[18] * v_[110] + v_[19] * v_[158]);
    jac[49] = v_[13] * v_[137] + v_[28] * v_[125] + v_[52] * v_[110] + v_[25] * v_[158];
    v_[158] = 0 - v_[54];
    v_[50] = v_[50] + v_[50];
    v_[110] = v_[60] * v_[121] + (-v_[62]) * x_in[10];
    v_[125] = v_[61] * v_[121] + v_[61] * x_in[10];
    v_[137] = v_[68] * v_[121] + v_[61] * v_[134] + v_[73] * x_in[10];
    v_[24] = v_[61] * v_[78] - v_[79] * v_[73];
    v_[4] = v_[61] * v_[79];
    v_[114] = v_[84] * v_[62] + v_[62] * v_[84];
    v_[53] = v_[86] * v_[67] + v_[91] * v_[61];
    v_[29] = v_[89] * v_[54] + v_[87] * v_[137] + v_[88] * v_[110] + (-v_[53]) * x_in[11];
    v_[49] = v_[87] * v_[62];
    v_[26] = v_[86] * v_[62];
    v_[111] = v_[94] * v_[49] + v_[26] * v_[98];
    v_[30] = -0.184 * v_[62] + v_[73];
    v_[23] = v_[94] * v_[30] + v_[26] * v_[101];
    v_[155] = v_[103] * v_[53] + v_[61] * v_[105];
    v_[83] = 1.547475 * v_[29] + 0.038686875 * v_[110] + 0.038686875 * v_[111] + -1.547475 * (v_[23] - v_[155]);
    v_[76] = v_[87] * v_[67] + v_[88] * v_[61];
    v_[157] = v_[103] * v_[61] + v_[61] * v_[103];
    v_[136] = v_[98] * v_[49] + v_[49] * v_[98];
    v_[30] = 1.547475 * (v_[98] * v_[30] + v_[49] * v_[101] - (v_[103] * v_[76] + v_[61] * v_[109])) +
             1.547475 * (v_[87] * v_[54] + v_[86] * v_[137] + v_[91] * v_[110] + v_[76] * x_in[11]) -
             0.038686875 * (v_[157] + v_[136]);
    v_[5] = v_[95] * v_[47] + v_[87] * v_[125] + (-v_[26]) * x_in[11];
    v_[102] = v_[87] * v_[47] + v_[86] * v_[125] + v_[49] * x_in[11];
    v_[135] = v_[94] * v_[61] + v_[26] * v_[103];
    v_[10] = v_[98] * v_[61] + v_[49] * v_[103];
    v_[82] = v_[94] * v_[26] + v_[26] * v_[94];
    jac[59] = 0.009277 * v_[110] + -0.000829 * v_[5] + 1.5e-05 * v_[102] + 0.038686875 * v_[29] + -0.00751 * v_[111] +
              0.038686875 * (v_[155] - v_[23]) + -0.000829 * v_[135] - 1.5e-05 * v_[10] - 0.000198 * (v_[136] - v_[82]);
    v_[155] = v_[62] * v_[79];
    v_[23] = v_[84] * v_[61] + v_[62] * v_[77];
    v_[29] = -0.001243 * v_[47] + 0.029115 * v_[110] + -0.001387 * v_[125] + 0.057838 * v_[137] + 0.057838 * v_[24] +
             -0.001387 * v_[4] + -0.012652 * (0 - v_[114]) + v_[88] * v_[83] + v_[91] * v_[30] + jac[59] -
             -0.008386 * v_[155] - -0.001243 * v_[23];
    v_[71] = v_[74] * v_[121] + v_[60] * v_[134] + (-v_[67]) * x_in[10];
    v_[163] = v_[62] * v_[78] - v_[79] * v_[67];
    v_[32] = 0.02075 * v_[47] + -0.184 * v_[125] + v_[71];
    v_[76] = v_[94] * v_[76] + v_[26] * v_[109] - (v_[98] * v_[53] + v_[49] * v_[105]);
    v_[82] = -0.000829 * v_[110] + 0.003227 * v_[5] + 0.000198 * v_[102] + -0.038686875 * v_[32] + 0.000198 * v_[10] +
             1.5e-05 * (v_[157] - v_[82]) - 0.038686875 * v_[76] - -0.00146 * v_[135] - -0.000829 * v_[111];
    v_[10] = 1.5e-05 * v_[110] + 0.000198 * v_[5] + 0.010737 * v_[102] + 0.00605 * v_[10] + 1.5e-05 * v_[111] -
             0.000198 * v_[135] - -0.000829 * (v_[157] - v_[136]);
    v_[76] = 1.547475 * v_[32] + -0.038686875 * v_[5] + 0.038686875 * v_[135] + 1.547475 * v_[76];
    v_[32] = v_[77] * v_[61] + v_[61] * v_[77];
    jac[58] = 0.011046 * v_[47] + -0.001243 * v_[110] + -0.012652 * v_[125] + -0.001243 * v_[155] + 0.009683 * v_[23] +
              v_[95] * v_[82] + v_[87] * v_[10] + 0.02075 * v_[76] - -0.012652 * v_[4] - -0.001387 * (v_[32] - v_[114]);
    v_[10] = -0.012652 * v_[47] + -0.001387 * v_[110] + 0.019432 * v_[125] + -0.057838 * v_[71] + -0.018069 * v_[4] +
             0.057838 * v_[163] + -0.012652 * v_[23] + v_[87] * v_[82] + v_[86] * v_[10] + -0.184 * v_[76] -
             -0.001387 * v_[155] - -0.001243 * (0 - v_[32]);
    v_[76] = 2.1032 * v_[71] + -0.057838 * v_[125] + 0.057838 * v_[4] + -2.1032 * v_[163] + v_[76];
    v_[155] = 2.1032 * v_[137] + 0.057838 * v_[110] + 0.057838 * v_[155] + 2.1032 * v_[24] + v_[87] * v_[83] +
              v_[86] * v_[30];
    jac[57] = -0.0022920002 * v_[121] + -0.00021200017 * v_[47] + 0.160298259823722 * v_[134] + 0.008711861 * v_[54] +
              0.160298259823722 * v_[78] + -0.0022920002 * v_[58] + v_[61] * v_[29] + v_[62] * v_[10] +
              v_[73] * v_[76] + v_[67] * v_[155] - -0.008711861 * v_[158] - -0.00021200017 * v_[47];
    v_[10] = 0.01828449 * v_[121] + 0.0036857284 * v_[47] + 1.52322944854339e-09 * v_[54] +
             1.52322944854339e-09 * v_[158] + 0.0036857284 * v_[47] + -0.00021200017 * v_[50] + v_[60] * v_[29] +
             v_[61] * v_[10] + v_[74] * v_[76] + v_[68] * v_[155] - 0.01404749 * v_[58];
    v_[29] = 0.0036857284 * v_[121] + 0.081661 * v_[47] + -1.52322944854339e-09 * v_[134] +
             1.52322944854339e-09 * (0 - v_[78]) + 0.077424 * v_[47] + jac[58] - 0.0036857284 * v_[58] -
             -0.0022920002 * v_[50];
    jac[56] = v_[34] * v_[10] + v_[36] * v_[29];
    v_[24] = -0.160298259823722 * v_[121] + -0.008711861 * v_[47] + 0.160298259823722 * v_[58] + -0.008711861 * v_[47] +
             v_[61] * v_[76] + v_[69] * v_[155];
    v_[29] = v_[36] * v_[10] + v_[33] * v_[29] + -0.304 * v_[24];
    v_[155] = -1.52322944854339e-09 * v_[47] + 1.7423722 * v_[134] + -1.7423722 * (0 - v_[78]) +
              1.52322944854339e-09 * v_[47] + v_[60] * v_[76] + v_[61] * v_[155] - -0.008711861 * v_[50];
    v_[32] = 1.52322944854339e-09 * v_[121] + 1.7423722 * v_[54] + 1.7423722 * v_[158] + 1.52322944854339e-09 * v_[58] +
             2.1032 * (v_[84] * v_[73] + v_[62] * v_[80] - (v_[77] * v_[67] + v_[61] * v_[104])) + 2.1032 * v_[54] +
             v_[89] * v_[83] + v_[87] * v_[30] - 0.160298259823722 * v_[50] - 0.057838 * (v_[32] + v_[114]);
    v_[30] = v_[44] * v_[155] + v_[43] * v_[32] + -1 * jac[57];
    v_[32] = v_[36] * v_[155] + v_[33] * v_[32];
    v_[24] = -1 * v_[24];
    jac[54] = v_[0] * jac[56] + v_[9] * (v_[12] * v_[29] + v_[13] * v_[30] + v_[18] * v_[32] + v_[19] * v_[24]);
    jac[55] = v_[13] * v_[29] + v_[28] * v_[30] + v_[52] * v_[32] + v_[25] * v_[24];
    v_[24] = 0 - v_[80];
    v_[79] = v_[79] + v_[79];
    v_[32] = v_[87] * v_[80] + v_[88] * v_[131];
    v_[30] = v_[94] * v_[95] + v_[87] * v_[98];
    v_[29] = v_[94] * 0.02075 + v_[87] * v_[101];
    v_[155] = 1.547475 * v_[32] + 0.038686875 * v_[131] + 0.038686875 * v_[30] + -1.547475 * v_[29];
    v_[83] = v_[98] * v_[95] + v_[95] * v_[98];
    v_[101] = 1.547475 * (v_[98] * 0.02075 + v_[95] * v_[101]) + 1.547475 * (v_[86] * v_[80] + v_[91] * v_[131]) -
              0.038686875 * v_[83];
    v_[114] = v_[87] * v_[77] + (-v_[87]) * x_in[11];
    v_[50] = v_[86] * v_[77] + v_[95] * x_in[11];
    v_[158] = v_[87] * v_[103];
    v_[121] = v_[95] * v_[103];
    v_[58] = v_[94] * v_[87] + v_[87] * v_[94];
    jac[65] = 0.009277 * v_[131] + -0.000829 * v_[114] + 1.5e-05 * v_[50] + 0.038686875 * v_[32] + -0.00751 * v_[30] +
              0.038686875 * (0 - v_[29]) + -0.000829 * v_[158] - 1.5e-05 * v_[121] - 0.000198 * (v_[83] - v_[58]);
    v_[29] = 0.029115 * v_[131] + -0.001387 * v_[77] + 0.057838 * v_[80] + 0.057838 * v_[24] + -0.001387 * v_[77] +
             -0.012652 * v_[79] + v_[88] * v_[155] + v_[91] * v_[101] + jac[65] - -0.008386 * v_[84];
    v_[104] = 0 - v_[104];
    v_[32] = -0.184 * v_[77] + v_[143];
    v_[54] = v_[87] * v_[109] - v_[95] * v_[105];
    v_[58] = -0.000829 * v_[131] + 0.003227 * v_[114] + 0.000198 * v_[50] + -0.038686875 * v_[32] + 0.000198 * v_[121] +
             1.5e-05 * (0 - v_[58]) - 0.038686875 * v_[54] - -0.00146 * v_[158] - -0.000829 * v_[30];
    v_[121] = 1.5e-05 * v_[131] + 0.000198 * v_[114] + 0.010737 * v_[50] + 0.00605 * v_[121] + 1.5e-05 * v_[30] -
              0.000198 * v_[158] - -0.000829 * (0 - v_[83]);
    v_[54] = 1.547475 * v_[32] + -0.038686875 * v_[114] + 0.038686875 * v_[158] + 1.547475 * v_[54];
    jac[64] = -0.001243 * v_[131] + -0.012652 * v_[77] + -0.001243 * v_[84] + v_[95] * v_[58] + v_[87] * v_[121] +
              0.02075 * v_[54] - -0.012652 * v_[77];
    v_[121] = -0.001387 * v_[131] + 0.019432 * v_[77] + -0.057838 * v_[143] + -0.018069 * v_[77] + 0.057838 * v_[104] +
              v_[87] * v_[58] + v_[86] * v_[121] + -0.184 * v_[54] - -0.001387 * v_[84] - -0.001243 * v_[79];
    v_[54] = 2.1032 * v_[143] + -0.057838 * v_[77] + 0.057838 * v_[77] + -2.1032 * v_[104] + v_[54];
    v_[24] = 2.1032 * v_[80] + 0.057838 * v_[131] + 0.057838 * v_[84] + 2.1032 * v_[24] + v_[87] * v_[155] +
             v_[86] * v_[101];
    jac[63] = v_[61] * v_[29] + v_[62] * v_[121] + v_[73] * v_[54] + v_[67] * v_[24];
    v_[121] = v_[60] * v_[29] + v_[61] * v_[121] + v_[74] * v_[54] + v_[68] * v_[24];
    jac[62] = v_[34] * v_[121] + v_[36] * jac[64];
    v_[29] = v_[61] * v_[54] + v_[69] * v_[24];
    v_[121] = v_[36] * v_[121] + v_[33] * jac[64] + -0.304 * v_[29];
    v_[24] = v_[60] * v_[54] + v_[61] * v_[24];
    v_[101] = v_[89] * v_[155] + v_[87] * v_[101];
    v_[155] = v_[44] * v_[24] + v_[43] * v_[101] + -1 * jac[63];
    v_[101] = v_[36] * v_[24] + v_[33] * v_[101];
    v_[29] = -1 * v_[29];
    jac[60] = v_[0] * jac[62] + v_[9] * (v_[12] * v_[121] + v_[13] * v_[155] + v_[18] * v_[101] + v_[19] * v_[29]);
    jac[61] = v_[13] * v_[121] + v_[28] * v_[155] + v_[52] * v_[101] + v_[25] * v_[29];
    v_[140] = 1.547475 * v_[140] + -1.547475 * (0 - v_[105]);
    v_[103] = v_[103] + v_[103];
    v_[109] = 1.547475 * (0 - v_[109]) + 1.547475 * v_[109] - 0.038686875 * v_[103];
    v_[91] = v_[88] * v_[140] + v_[91] * v_[109] + jac[71];
    v_[88] = 0.003227 * v_[149] + 0.000198 * v_[98] + 0.000198 * v_[98] + 1.5e-05 * v_[103] - -0.00146 * v_[94];
    v_[103] = 0.000198 * v_[149] + 0.010737 * v_[98] + 0.00605 * v_[98] - 0.000198 * v_[94] - -0.000829 * v_[103];
    v_[149] = -0.038686875 * v_[149] + 0.038686875 * v_[94];
    jac[70] = v_[95] * v_[88] + v_[87] * v_[103] + 0.02075 * v_[149];
    v_[103] = v_[87] * v_[88] + v_[86] * v_[103] + -0.184 * v_[149];
    v_[86] = v_[87] * v_[140] + v_[86] * v_[109];
    jac[69] = v_[61] * v_[91] + v_[62] * v_[103] + v_[73] * v_[149] + v_[67] * v_[86];
    v_[103] = v_[60] * v_[91] + v_[61] * v_[103] + v_[74] * v_[149] + v_[68] * v_[86];
    jac[68] = v_[34] * v_[103] + v_[36] * jac[70];
    v_[69] = v_[61] * v_[149] + v_[69] * v_[86];
    v_[103] = v_[36] * v_[103] + v_[33] * jac[70] + -0.304 * v_[69];
    v_[86] = v_[60] * v_[149] + v_[61] * v_[86];
    v_[109] = v_[89] * v_[140] + v_[87] * v_[109];
    v_[44] = v_[44] * v_[86] + v_[43] * v_[109] + -1 * jac[69];
    v_[109] = v_[36] * v_[86] + v_[33] * v_[109];
    v_[69] = -1 * v_[69];
    jac[66] = v_[0] * jac[68] + v_[9] * (v_[12] * v_[103] + v_[13] * v_[44] + v_[18] * v_[109] + v_[19] * v_[69]);
    jac[67] = v_[13] * v_[103] + v_[28] * v_[44] + v_[52] * v_[109] + v_[25] * v_[69];


    return jac_;
}
}  // namespace HyA
}  // namespace models
}  // namespace ct
