/*----------------------------------------------------------------------------*/
/* Copyright (c) 2019 FIRST. All Rights Reserved.                             */
/* Open Source Software - may be modified and shared by FRC teams. The code   */
/* must be accompanied by the FIRST BSD license file in the root directory of */
/* the project.                                                               */
/*----------------------------------------------------------------------------*/

#include "Constants.h"

namespace DriveConstants {

const frc::MecanumDriveKinematics kDriveKinematics{
    frc::Translation2d(kWheelBase / 2, kTrackWidth / 2),
    frc::Translation2d(kWheelBase / 2, -kTrackWidth / 2),
    frc::Translation2d(-kWheelBase / 2, kTrackWidth / 2),
    frc::Translation2d(-kWheelBase / 2, -kTrackWidth / 2)};

}  // namespace DriveConstants

namespace AutoConstants {

const frc::TrapezoidProfile<units::radians>::Constraints
    kThetaControllerConstraints{kMaxAngularSpeed, kMaxAngularAcceleration};

}  // namespace AutoConstants
