/*----------------------------------------------------------------------------*/
/* Copyright (c) 2015-2018 FIRST. All Rights Reserved.                        */
/* Open Source Software - may be modified and shared by FRC teams. The code   */
/* must be accompanied by the FIRST BSD license file in the root directory of */
/* the project.                                                               */
/*----------------------------------------------------------------------------*/

#include <climits>

#include "gmock/gmock.h"
#include "ntcore.h"

int main(int argc, char** argv) {
  nt::AddLogger(nt::GetDefaultInstance(),
                [](const nt::LogMessage& msg) {
                  std::fputs(msg.message.c_str(), stderr);
                  std::fputc('\n', stderr);
                },
                0, UINT_MAX);
  ::testing::InitGoogleMock(&argc, argv);
  int ret = RUN_ALL_TESTS();
  return ret;
}
