###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run //vendor_remote_pkgs:crates_vendor_pkgs
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependnecies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normla dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({_CONDITIONS[condition]: deps.values()})

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normla dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": common_items}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        if condition_triples in crate_aliases:
            crate_aliases[condition_triples].update(deps)
        else:
            crate_aliases.update({_CONDITIONS[condition]: dict(deps.items() + common_items)})

    return selects.with_or(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "axum": "@crates_vendor_pkgs__axum-0.4.8//:axum",
            "hyper": "@crates_vendor_pkgs__hyper-0.14.20//:hyper",
            "mime": "@crates_vendor_pkgs__mime-0.3.16//:mime",
            "serde_json": "@crates_vendor_pkgs__serde_json-1.0.82//:serde_json",
            "tokio": "@crates_vendor_pkgs__tokio-1.16.1//:tokio",
            "tower": "@crates_vendor_pkgs__tower-0.4.13//:tower",
            "tower-http": "@crates_vendor_pkgs__tower-http-0.2.5//:tower_http",
            "tracing": "@crates_vendor_pkgs__tracing-0.1.35//:tracing",
            "tracing-subscriber": "@crates_vendor_pkgs__tracing-subscriber-0.3.15//:tracing_subscriber",
        },
    },
}

_NORMAL_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "": {
    },
}

_NORMAL_DEV_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "": {
    },
}

_BUILD_DEPENDENCIES = {
    "": {
    },
}

_BUILD_ALIASES = {
    "": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "": {
    },
}

_CONDITIONS = {
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"aarch64\"), target_os = \"hermit\"))": [],
    "cfg(not(windows))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "riscv32imc-unknown-none-elf", "s390x-unknown-linux-gnu", "wasm32-unknown-unknown", "wasm32-wasi", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"windows\")": ["i686-pc-windows-msvc", "x86_64-pc-windows-msvc"],
    "cfg(tracing_unstable)": [],
    "cfg(unix)": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "s390x-unknown-linux-gnu", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(windows)": ["i686-pc-windows-msvc", "x86_64-pc-windows-msvc"],
    "i686-pc-windows-gnu": [],
    "x86_64-pc-windows-gnu": [],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates"""
    maybe(
        http_archive,
        name = "crates_vendor_pkgs__ansi_term-0.12.1",
        sha256 = "d52a9bb7ec0cf484c551830a7ce27bd20d67eac647e1befb56b0be4ee39a55d2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ansi_term/0.12.1/download"],
        strip_prefix = "ansi_term-0.12.1",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.ansi_term-0.12.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__async-trait-0.1.56",
        sha256 = "96cf8829f67d2eab0b2dfa42c5d0ef737e0724e4a82b01b3e292456202b19716",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/async-trait/0.1.56/download"],
        strip_prefix = "async-trait-0.1.56",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.async-trait-0.1.56.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__autocfg-1.1.0",
        sha256 = "d468802bab17cbc0cc575e9b053f41e72aa36bfa6b7f55e3529ffa43161b97fa",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/autocfg/1.1.0/download"],
        strip_prefix = "autocfg-1.1.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.autocfg-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__axum-0.4.8",
        sha256 = "c9f346c92c1e9a71d14fe4aaf7c2a5d9932cc4e5e48d8fb6641524416eb79ddd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/axum/0.4.8/download"],
        strip_prefix = "axum-0.4.8",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.axum-0.4.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__axum-core-0.1.2",
        sha256 = "6dbcda393bef9c87572779cb8ef916f12d77750b27535dd6819fa86591627a51",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/axum-core/0.1.2/download"],
        strip_prefix = "axum-core-0.1.2",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.axum-core-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__bytes-1.2.0",
        sha256 = "f0b3de4a0c5e67e16066a0715723abd91edc2f9001d09c46e1dca929351e130e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bytes/1.2.0/download"],
        strip_prefix = "bytes-1.2.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.bytes-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__fnv-1.0.7",
        sha256 = "3f9eec918d3f24069decb9af1554cad7c880e2da24a9afd88aca000531ab82c1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/fnv/1.0.7/download"],
        strip_prefix = "fnv-1.0.7",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.fnv-1.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__form_urlencoded-1.0.1",
        sha256 = "5fc25a87fa4fd2094bffb06925852034d90a17f0d1e05197d4956d3555752191",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/form_urlencoded/1.0.1/download"],
        strip_prefix = "form_urlencoded-1.0.1",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.form_urlencoded-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-channel-0.3.21",
        sha256 = "c3083ce4b914124575708913bca19bfe887522d6e2e6d0952943f5eac4a74010",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-channel/0.3.21/download"],
        strip_prefix = "futures-channel-0.3.21",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.futures-channel-0.3.21.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-core-0.3.21",
        sha256 = "0c09fd04b7e4073ac7156a9539b57a484a8ea920f79c7c675d05d289ab6110d3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-core/0.3.21/download"],
        strip_prefix = "futures-core-0.3.21",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.futures-core-0.3.21.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-sink-0.3.21",
        sha256 = "21163e139fa306126e6eedaf49ecdb4588f939600f0b1e770f4205ee4b7fa868",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-sink/0.3.21/download"],
        strip_prefix = "futures-sink-0.3.21",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.futures-sink-0.3.21.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-task-0.3.21",
        sha256 = "57c66a976bf5909d801bbef33416c41372779507e7a6b3a5e25e4749c58f776a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-task/0.3.21/download"],
        strip_prefix = "futures-task-0.3.21",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.futures-task-0.3.21.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-util-0.3.21",
        sha256 = "d8b7abd5d659d9b90c8cba917f6ec750a74e2dc23902ef9cd4cc8c8b22e6036a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-util/0.3.21/download"],
        strip_prefix = "futures-util-0.3.21",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.futures-util-0.3.21.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__h2-0.3.13",
        sha256 = "37a82c6d637fc9515a4694bbf1cb2457b79d81ce52b3108bdeea58b07dd34a57",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/h2/0.3.13/download"],
        strip_prefix = "h2-0.3.13",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.h2-0.3.13.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__hashbrown-0.12.3",
        sha256 = "8a9ee70c43aaf417c914396645a0fa852624801b24ebb7ae78fe8272889ac888",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hashbrown/0.12.3/download"],
        strip_prefix = "hashbrown-0.12.3",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.hashbrown-0.12.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__hermit-abi-0.1.19",
        sha256 = "62b467343b94ba476dcb2500d242dadbb39557df889310ac77c5d99100aaac33",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hermit-abi/0.1.19/download"],
        strip_prefix = "hermit-abi-0.1.19",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.hermit-abi-0.1.19.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__http-0.2.8",
        sha256 = "75f43d41e26995c17e71ee126451dd3941010b0514a81a9d11f3b341debc2399",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/http/0.2.8/download"],
        strip_prefix = "http-0.2.8",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.http-0.2.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__http-body-0.4.5",
        sha256 = "d5f38f16d184e36f2408a55281cd658ecbd3ca05cce6d6510a176eca393e26d1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/http-body/0.4.5/download"],
        strip_prefix = "http-body-0.4.5",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.http-body-0.4.5.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__http-range-header-0.3.0",
        sha256 = "0bfe8eed0a9285ef776bb792479ea3834e8b94e13d615c2f66d03dd50a435a29",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/http-range-header/0.3.0/download"],
        strip_prefix = "http-range-header-0.3.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.http-range-header-0.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__httparse-1.7.1",
        sha256 = "496ce29bb5a52785b44e0f7ca2847ae0bb839c9bd28f69acac9b99d461c0c04c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/httparse/1.7.1/download"],
        strip_prefix = "httparse-1.7.1",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.httparse-1.7.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__httpdate-1.0.2",
        sha256 = "c4a1e36c821dbe04574f602848a19f742f4fb3c98d40449f11bcad18d6b17421",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/httpdate/1.0.2/download"],
        strip_prefix = "httpdate-1.0.2",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.httpdate-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__hyper-0.14.20",
        sha256 = "02c929dc5c39e335a03c405292728118860721b10190d98c2a0f0efd5baafbac",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hyper/0.14.20/download"],
        strip_prefix = "hyper-0.14.20",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.hyper-0.14.20.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__indexmap-1.9.1",
        sha256 = "10a35a97730320ffe8e2d410b5d3b69279b98d2c14bdb8b70ea89ecf7888d41e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/indexmap/1.9.1/download"],
        strip_prefix = "indexmap-1.9.1",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.indexmap-1.9.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__instant-0.1.12",
        sha256 = "7a5bbe824c507c5da5956355e86a746d82e0e1464f65d862cc5e71da70e94b2c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/instant/0.1.12/download"],
        strip_prefix = "instant-0.1.12",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.instant-0.1.12.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__itoa-1.0.2",
        sha256 = "112c678d4050afce233f4f2852bb2eb519230b3cf12f33585275537d7e41578d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/itoa/1.0.2/download"],
        strip_prefix = "itoa-1.0.2",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.itoa-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__lazy_static-1.4.0",
        sha256 = "e2abad23fbc42b3700f2f279844dc832adb2b2eb069b2df918f455c4e18cc646",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/lazy_static/1.4.0/download"],
        strip_prefix = "lazy_static-1.4.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.lazy_static-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__libc-0.2.126",
        sha256 = "349d5a591cd28b49e1d1037471617a32ddcda5731b99419008085f72d5a53836",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/libc/0.2.126/download"],
        strip_prefix = "libc-0.2.126",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.libc-0.2.126.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__lock_api-0.4.7",
        sha256 = "327fa5b6a6940e4699ec49a9beae1ea4845c6bab9314e4f84ac68742139d8c53",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/lock_api/0.4.7/download"],
        strip_prefix = "lock_api-0.4.7",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.lock_api-0.4.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__log-0.4.17",
        sha256 = "abb12e687cfb44aa40f41fc3978ef76448f9b6038cad6aef4259d3c095a2382e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/log/0.4.17/download"],
        strip_prefix = "log-0.4.17",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.log-0.4.17.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__matches-0.1.9",
        sha256 = "a3e378b66a060d48947b590737b30a1be76706c8dd7b8ba0f2fe3989c68a853f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/matches/0.1.9/download"],
        strip_prefix = "matches-0.1.9",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.matches-0.1.9.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__matchit-0.4.6",
        sha256 = "9376a4f0340565ad675d11fc1419227faf5f60cd7ac9cb2e7185a471f30af833",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/matchit/0.4.6/download"],
        strip_prefix = "matchit-0.4.6",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.matchit-0.4.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__memchr-2.5.0",
        sha256 = "2dffe52ecf27772e601905b7522cb4ef790d2cc203488bbd0e2fe85fcb74566d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/memchr/2.5.0/download"],
        strip_prefix = "memchr-2.5.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.memchr-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__mime-0.3.16",
        sha256 = "2a60c7ce501c71e03a9c9c0d35b861413ae925bd979cc7a4e30d060069aaac8d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/mime/0.3.16/download"],
        strip_prefix = "mime-0.3.16",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.mime-0.3.16.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__mio-0.7.14",
        sha256 = "8067b404fe97c70829f082dec8bcf4f71225d7eaea1d8645349cb76fa06205cc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/mio/0.7.14/download"],
        strip_prefix = "mio-0.7.14",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.mio-0.7.14.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__miow-0.3.7",
        sha256 = "b9f1c5b025cda876f66ef43a113f91ebc9f4ccef34843000e0adf6ebbab84e21",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/miow/0.3.7/download"],
        strip_prefix = "miow-0.3.7",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.miow-0.3.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__ntapi-0.3.7",
        sha256 = "c28774a7fd2fbb4f0babd8237ce554b73af68021b5f695a3cebd6c59bac0980f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ntapi/0.3.7/download"],
        strip_prefix = "ntapi-0.3.7",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.ntapi-0.3.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__num_cpus-1.13.1",
        sha256 = "19e64526ebdee182341572e50e9ad03965aa510cd94427a4549448f285e957a1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num_cpus/1.13.1/download"],
        strip_prefix = "num_cpus-1.13.1",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.num_cpus-1.13.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__once_cell-1.13.0",
        sha256 = "18a6dbe30758c9f83eb00cbea4ac95966305f5a7772f3f42ebfc7fc7eddbd8e1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/once_cell/1.13.0/download"],
        strip_prefix = "once_cell-1.13.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.once_cell-1.13.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__parking_lot-0.11.2",
        sha256 = "7d17b78036a60663b797adeaee46f5c9dfebb86948d1255007a1d6be0271ff99",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/parking_lot/0.11.2/download"],
        strip_prefix = "parking_lot-0.11.2",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.parking_lot-0.11.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__parking_lot_core-0.8.5",
        sha256 = "d76e8e1493bcac0d2766c42737f34458f1c8c50c0d23bcb24ea953affb273216",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/parking_lot_core/0.8.5/download"],
        strip_prefix = "parking_lot_core-0.8.5",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.parking_lot_core-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__percent-encoding-2.1.0",
        sha256 = "d4fd5641d01c8f18a23da7b6fe29298ff4b55afcccdf78973b24cf3175fee32e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/percent-encoding/2.1.0/download"],
        strip_prefix = "percent-encoding-2.1.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.percent-encoding-2.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-project-1.0.11",
        sha256 = "78203e83c48cffbe01e4a2d35d566ca4de445d79a85372fc64e378bfc812a260",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pin-project/1.0.11/download"],
        strip_prefix = "pin-project-1.0.11",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.pin-project-1.0.11.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-project-internal-1.0.11",
        sha256 = "710faf75e1b33345361201d36d04e98ac1ed8909151a017ed384700836104c74",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pin-project-internal/1.0.11/download"],
        strip_prefix = "pin-project-internal-1.0.11",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.pin-project-internal-1.0.11.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-project-lite-0.2.9",
        sha256 = "e0a7ae3ac2f1173085d398531c705756c94a4c56843785df85a60c1a0afac116",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pin-project-lite/0.2.9/download"],
        strip_prefix = "pin-project-lite-0.2.9",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.pin-project-lite-0.2.9.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-utils-0.1.0",
        sha256 = "8b870d8c151b6f2fb93e84a13146138f05d02ed11c7e7c54f8826aaaf7c9f184",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pin-utils/0.1.0/download"],
        strip_prefix = "pin-utils-0.1.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.pin-utils-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__proc-macro2-1.0.40",
        sha256 = "dd96a1e8ed2596c337f8eae5f24924ec83f5ad5ab21ea8e455d3566c69fbcaf7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/proc-macro2/1.0.40/download"],
        strip_prefix = "proc-macro2-1.0.40",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.proc-macro2-1.0.40.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__quote-1.0.20",
        sha256 = "3bcdf212e9776fbcb2d23ab029360416bb1706b1aea2d1a5ba002727cbcab804",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/quote/1.0.20/download"],
        strip_prefix = "quote-1.0.20",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.quote-1.0.20.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__redox_syscall-0.2.13",
        sha256 = "62f25bc4c7e55e0b0b7a1d43fb893f4fa1361d0abe38b9ce4f323c2adfe6ef42",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/redox_syscall/0.2.13/download"],
        strip_prefix = "redox_syscall-0.2.13",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.redox_syscall-0.2.13.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__ryu-1.0.10",
        sha256 = "f3f6f92acf49d1b98f7a81226834412ada05458b7364277387724a237f062695",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ryu/1.0.10/download"],
        strip_prefix = "ryu-1.0.10",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.ryu-1.0.10.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__scopeguard-1.1.0",
        sha256 = "d29ab0c6d3fc0ee92fe66e2d99f700eab17a8d57d1c1d3b748380fb20baa78cd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/scopeguard/1.1.0/download"],
        strip_prefix = "scopeguard-1.1.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.scopeguard-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__serde-1.0.140",
        sha256 = "fc855a42c7967b7c369eb5860f7164ef1f6f81c20c7cc1141f2a604e18723b03",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde/1.0.140/download"],
        strip_prefix = "serde-1.0.140",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.serde-1.0.140.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__serde_json-1.0.82",
        sha256 = "82c2c1fdcd807d1098552c5b9a36e425e42e9fbd7c6a37a8425f390f781f7fa7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_json/1.0.82/download"],
        strip_prefix = "serde_json-1.0.82",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.serde_json-1.0.82.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__serde_urlencoded-0.7.1",
        sha256 = "d3491c14715ca2294c4d6a88f15e84739788c1d030eed8c110436aafdaa2f3fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_urlencoded/0.7.1/download"],
        strip_prefix = "serde_urlencoded-0.7.1",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.serde_urlencoded-0.7.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__sharded-slab-0.1.4",
        sha256 = "900fba806f70c630b0a382d0d825e17a0f19fcd059a2ade1ff237bcddf446b31",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/sharded-slab/0.1.4/download"],
        strip_prefix = "sharded-slab-0.1.4",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.sharded-slab-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__signal-hook-registry-1.4.0",
        sha256 = "e51e73328dc4ac0c7ccbda3a494dfa03df1de2f46018127f60c693f2648455b0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/signal-hook-registry/1.4.0/download"],
        strip_prefix = "signal-hook-registry-1.4.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.signal-hook-registry-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__slab-0.4.7",
        sha256 = "4614a76b2a8be0058caa9dbbaf66d988527d86d003c11a94fbd335d7661edcef",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/slab/0.4.7/download"],
        strip_prefix = "slab-0.4.7",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.slab-0.4.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__smallvec-1.9.0",
        sha256 = "2fd0db749597d91ff862fd1d55ea87f7855a744a8425a64695b6fca237d1dad1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/smallvec/1.9.0/download"],
        strip_prefix = "smallvec-1.9.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.smallvec-1.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__socket2-0.4.4",
        sha256 = "66d72b759436ae32898a2af0a14218dbf55efde3feeb170eb623637db85ee1e0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/socket2/0.4.4/download"],
        strip_prefix = "socket2-0.4.4",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.socket2-0.4.4.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__syn-1.0.98",
        sha256 = "c50aef8a904de4c23c788f104b7dddc7d6f79c647c7c8ce4cc8f73eb0ca773dd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/syn/1.0.98/download"],
        strip_prefix = "syn-1.0.98",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.syn-1.0.98.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__sync_wrapper-0.1.1",
        sha256 = "20518fe4a4c9acf048008599e464deb21beeae3d3578418951a189c235a7a9a8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/sync_wrapper/0.1.1/download"],
        strip_prefix = "sync_wrapper-0.1.1",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.sync_wrapper-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__thread_local-1.1.4",
        sha256 = "5516c27b78311c50bf42c071425c560ac799b11c30b31f87e3081965fe5e0180",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/thread_local/1.1.4/download"],
        strip_prefix = "thread_local-1.1.4",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.thread_local-1.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tokio-1.16.1",
        sha256 = "0c27a64b625de6d309e8c57716ba93021dccf1b3b5c97edd6d3dd2d2135afc0a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tokio/1.16.1/download"],
        strip_prefix = "tokio-1.16.1",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tokio-1.16.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tokio-macros-1.8.0",
        sha256 = "9724f9a975fb987ef7a3cd9be0350edcbe130698af5b8f7a631e23d42d052484",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tokio-macros/1.8.0/download"],
        strip_prefix = "tokio-macros-1.8.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tokio-macros-1.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tokio-util-0.7.2",
        sha256 = "f988a1a1adc2fb21f9c12aa96441da33a1728193ae0b95d2be22dbd17fcb4e5c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tokio-util/0.7.2/download"],
        strip_prefix = "tokio-util-0.7.2",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tokio-util-0.7.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-0.4.13",
        sha256 = "b8fa9be0de6cf49e536ce1851f987bd21a43b771b09473c3549a6c853db37c1c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tower/0.4.13/download"],
        strip_prefix = "tower-0.4.13",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tower-0.4.13.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-http-0.2.5",
        sha256 = "aba3f3efabf7fb41fae8534fc20a817013dd1c12cb45441efb6c82e6556b4cd8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tower-http/0.2.5/download"],
        strip_prefix = "tower-http-0.2.5",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tower-http-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-layer-0.3.1",
        sha256 = "343bc9466d3fe6b0f960ef45960509f84480bf4fd96f92901afe7ff3df9d3a62",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tower-layer/0.3.1/download"],
        strip_prefix = "tower-layer-0.3.1",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tower-layer-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-service-0.3.2",
        sha256 = "b6bc1c9ce2b5135ac7f93c72918fc37feb872bdc6a5533a8b85eb4b86bfdae52",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tower-service/0.3.2/download"],
        strip_prefix = "tower-service-0.3.2",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tower-service-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-0.1.35",
        sha256 = "a400e31aa60b9d44a52a8ee0343b5b18566b03a8321e0d321f695cf56e940160",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tracing/0.1.35/download"],
        strip_prefix = "tracing-0.1.35",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tracing-0.1.35.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-attributes-0.1.22",
        sha256 = "11c75893af559bc8e10716548bdef5cb2b983f8e637db9d0e15126b61b484ee2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tracing-attributes/0.1.22/download"],
        strip_prefix = "tracing-attributes-0.1.22",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tracing-attributes-0.1.22.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-core-0.1.28",
        sha256 = "7b7358be39f2f274f322d2aaed611acc57f382e8eb1e5b48cb9ae30933495ce7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tracing-core/0.1.28/download"],
        strip_prefix = "tracing-core-0.1.28",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tracing-core-0.1.28.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-log-0.1.3",
        sha256 = "78ddad33d2d10b1ed7eb9d1f518a5674713876e97e5bb9b7345a7984fbb4f922",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tracing-log/0.1.3/download"],
        strip_prefix = "tracing-log-0.1.3",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tracing-log-0.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-subscriber-0.3.15",
        sha256 = "60db860322da191b40952ad9affe65ea23e7dd6a5c442c2c42865810c6ab8e6b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tracing-subscriber/0.3.15/download"],
        strip_prefix = "tracing-subscriber-0.3.15",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.tracing-subscriber-0.3.15.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__try-lock-0.2.3",
        sha256 = "59547bce71d9c38b83d9c0e92b6066c4253371f15005def0c30d9657f50c7642",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/try-lock/0.2.3/download"],
        strip_prefix = "try-lock-0.2.3",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.try-lock-0.2.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__unicode-ident-1.0.2",
        sha256 = "15c61ba63f9235225a22310255a29b806b907c9b8c964bcbd0a2c70f3f2deea7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-ident/1.0.2/download"],
        strip_prefix = "unicode-ident-1.0.2",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.unicode-ident-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__valuable-0.1.0",
        sha256 = "830b7e5d4d90034032940e4ace0d9a9a057e7a45cd94e6c007832e39edb82f6d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/valuable/0.1.0/download"],
        strip_prefix = "valuable-0.1.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.valuable-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__want-0.3.0",
        sha256 = "1ce8a968cb1cd110d136ff8b819a556d6fb6d919363c61534f6860c7eb172ba0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/want/0.3.0/download"],
        strip_prefix = "want-0.3.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.want-0.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("@examples//vendor_remote_pkgs/crates:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )
