/*----------------------------------------------------------------------------*/
/* Copyright (c) FIRST 2014-2017. All Rights Reserved.                        */
/* Open Source Software - may be modified and shared by FRC teams. The code   */
/* must be accompanied by the FIRST BSD license file in the root directory of */
/* the project.                                                               */
/*----------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>

#include <memory>
#include <string>

#include "HAL/AnalogOutput.h"
#include "SensorBase.h"

namespace frc {

/**
 * MXP analog output class.
 */
class AnalogOutput : public SensorBase {
 public:
  explicit AnalogOutput(int channel);
  virtual ~AnalogOutput();

  void SetVoltage(double voltage);
  double GetVoltage() const;
  int GetChannel();

 protected:
  int m_channel;
  HAL_AnalogOutputHandle m_port;
};

}  // namespace frc
