# Patches

Details related to patches required for the rules_rust protobuf rules.

## protobuf-2.8.2

The protobuf crate from the rust-protobuf repository introduced a build.rs
script in the 2.x.x series. This generates a small version.rs file that would be
[included into lib.rs](https://github.com/stepancheg/rust-protobuf/blob/v2.8/protobuf/src/lib.rs#L122).
However, the build.rs file requires a number of environment variables, normally
provided by cargo to the build file. Cargo raze does not provide these
variables. The resulting code includes a version string and version identifier.
The version string is then used by protobuf-codegen to generate code refering to
the identifier in the protobuf library. The use can be seen
[here](https://github.com/stepancheg/rust-protobuf/blob/v2.8/protobuf-codegen/src/lib.rs#L160).
This is to enforce at compile time that the version of protobuf-codegen matches
the version of the protobuf crate.

For this crate, the patch that is applied is replacing the include! macro with
what would be generated by the build.rs file. This lets us avoid running the
build file altogether, at the expense of having to update the patch for every
version.


## com_google_protobuf-v3.10.0-bzl_visibility

The patches here provide the required visibility to `*.bzl` files used by the rules defined in `com_google_protobuf`.
