(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4903,        181]*)
(*NotebookOutlinePosition[      5814,        212]*)
(*  CellTagsIndexPosition[      5770,        208]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Mandelbrot Images"], "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"This notebook demonstrates the plotting of images from the Mandelbrot set. \n\
The topic is described in more detail in the book:\n\n\tMathematica Graphics: \
Techniques and Applications.\n\tTom Wickham-Jones, TELOS/Springer-Verlag \
1994."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "This package is now updated to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 3.0."
}], "Text"],

Cell[CellGroupData[{

Cell["Installation and Initialization", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The ",
  StyleBox["ExtendGraphics", "Input"],
  " directory should be put in one of the canonical places for AddOns.   Two \
recommended places are first inside the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distribution in:"
}], "Text"],

Cell[BoxData[
    \(ToFileName[\ {$TopDirectory, \ "\<AddOns\>", \ "\<Applications\>"}]\)], 
  "Input"],

Cell["a second is in the preferences directory:", "Text"],

Cell[BoxData[
    \(ToFileName[
      \ {$PreferencesDirectory, \ "\<AddOns\>", \ "\<Applications\>"}]\)], 
  "Input"],

Cell[TextData[{
  "When one of these locations is used there is no need to set $Path and the \
loading instructions are identical for all versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " binary Mandelbrot.exe is provided for the Windows95 and Macintosh \
versions.  For other versions it should be built with the mcc tools that are \
provided."
}], "Text"],

Cell[TextData[{
  "The  ",
  StyleBox["ExtendGraphics`Mandelbrot` ", "Input"],
  "package can  be loaded"
}], "Text"],

Cell["Needs[ \"ExtendGraphics`Mandelbrot`\"]", "Input"],

Cell[CellGroupData[{

Cell["Turn off spelling checker", "Subsection"],

Cell["\<\
Off[ General::spell];
Off[ General::spell1];
\
\>", "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Mandelbrot Images"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["The main function is MandelbrotImage."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?MandelbrotImage", "Input",
  AspectRatioFixed->True],

Cell[TextData["This makes a 50 x 50 image."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["MandelbrotImage[{-3,-2}, {1,2}, 50, 10];", "Input",
  AspectRatioFixed->True],

Cell[TextData["The image is plotted."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Show[%];", "Input",
  AspectRatioFixed->True],

Cell[TextData["This makes a 200 x 200 image. "], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Show[MandelbrotImage[{-2,-1.5}, {1,1.5}, 200, 10]];", "Input",
  AspectRatioFixed->True],

Cell[TextData["This makes another 200 x 200 image."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Show[
  MandelbrotImage[{-1.49, -0.01}, 
                  {-1.47, 0.01}, 200, 2]];\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{464, 404},
WindowMargins->{{139, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 92, 2, 105, "Title"],
Cell[1826, 55, 314, 6, 109, "Text"],
Cell[2143, 63, 134, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[2302, 72, 98, 2, 53, "Section"],
Cell[2403, 76, 272, 8, 53, "Text"],
Cell[2678, 86, 103, 2, 30, "Input"],
Cell[2784, 90, 57, 0, 33, "Text"],
Cell[2844, 92, 118, 3, 50, "Input"],
Cell[2965, 97, 222, 6, 52, "Text"],
Cell[3190, 105, 248, 7, 52, "Text"],
Cell[3441, 114, 117, 4, 34, "Text"],
Cell[3561, 120, 55, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[3641, 124, 47, 0, 47, "Subsection"],
Cell[3691, 126, 70, 4, 66, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3810, 136, 94, 2, 33, "Section"],
Cell[3907, 140, 111, 2, 33, "Text"],
Cell[4021, 144, 59, 1, 30, "Input"],
Cell[4083, 147, 101, 2, 33, "Text"],
Cell[4187, 151, 83, 1, 30, "Input"],
Cell[4273, 154, 95, 2, 33, "Text"],
Cell[4371, 158, 51, 1, 30, "Input"],
Cell[4425, 161, 104, 2, 33, "Text"],
Cell[4532, 165, 94, 1, 30, "Input"],
Cell[4629, 168, 109, 2, 33, "Text"],
Cell[4741, 172, 134, 5, 66, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

