#!/bin/bash

# --- begin runfiles.bash initialization v2 ---
# Copy-pasted from the Bazel Bash runfiles library v2.
set -uo pipefail; f=bazel_tools/tools/bash/runfiles/runfiles.bash
source "${RUNFILES_DIR:-/dev/null}/$f" 2>/dev/null || \
  source "$(grep -sm1 "^$f " "${RUNFILES_MANIFEST_FILE:-/dev/null}" | cut -f2- -d' ')" 2>/dev/null || \
  source "$0.runfiles/$f" 2>/dev/null || \
  source "$(grep -sm1 "^$f " "$0.runfiles_manifest" | cut -f2- -d' ')" 2>/dev/null || \
  source "$(grep -sm1 "^$f " "$0.exe.runfiles_manifest" | cut -f2- -d' ')" 2>/dev/null || \
  { echo>&2 "ERROR: cannot find $f"; exit 1; }; f=; set -e
# --- end runfiles.bash initialization v2 ---

readonly RUSTFMT="$(rlocation rust__x86_64-unknown-linux-gnu__stable_tools/bin/rustfmt)"

# Run everything from the root of the tree.
cd "${BUILD_WORKSPACE_DIRECTORY}"

# Find all the Rust files in the repo.
rust_files=($(git ls-tree --name-only --full-tree -r @ \
    | grep -v '^third_party/' \
    | (grep '\.rs$' || :)))

# If we have any Rust files, format them.
if ((${#rust_files[@]} > 0)); then
    exec "${RUSTFMT}" --edition=2021 "${rust_files[@]}"
fi
