###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @//wasm_bindgen/3rdparty:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "anyhow": "@rules_rust_wasm_bindgen__anyhow-1.0.68//:anyhow",
            "curl": "@rules_rust_wasm_bindgen__curl-0.4.44//:curl",
            "docopt": "@rules_rust_wasm_bindgen__docopt-1.1.1//:docopt",
            "env_logger": "@rules_rust_wasm_bindgen__env_logger-0.8.4//:env_logger",
            "log": "@rules_rust_wasm_bindgen__log-0.4.17//:log",
            "rouille": "@rules_rust_wasm_bindgen__rouille-3.6.1//:rouille",
            "serde": "@rules_rust_wasm_bindgen__serde-1.0.152//:serde",
            "serde_json": "@rules_rust_wasm_bindgen__serde_json-1.0.91//:serde_json",
            "walrus": "@rules_rust_wasm_bindgen__walrus-0.19.0//:walrus",
            "wasm-bindgen": "@rules_rust_wasm_bindgen__wasm-bindgen-0.2.84//:wasm_bindgen",
            "wasm-bindgen-cli-support": "@rules_rust_wasm_bindgen__wasm-bindgen-cli-support-0.2.84//:wasm_bindgen_cli_support",
            "wasm-bindgen-shared": "@rules_rust_wasm_bindgen__wasm-bindgen-shared-0.2.84//:wasm_bindgen_shared",
        },
    },
}

_NORMAL_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "assert_cmd": "@rules_rust_wasm_bindgen__assert_cmd-1.0.8//:assert_cmd",
            "diff": "@rules_rust_wasm_bindgen__diff-0.1.13//:diff",
            "predicates": "@rules_rust_wasm_bindgen__predicates-1.0.8//:predicates",
            "rayon": "@rules_rust_wasm_bindgen__rayon-1.6.1//:rayon",
            "tempfile": "@rules_rust_wasm_bindgen__tempfile-3.3.0//:tempfile",
            "wasmprinter": "@rules_rust_wasm_bindgen__wasmprinter-0.2.33//:wasmprinter",
            "wit-printer": "@rules_rust_wasm_bindgen__wit-printer-0.2.0//:wit_printer",
            "wit-text": "@rules_rust_wasm_bindgen__wit-text-0.8.0//:wit_text",
            "wit-validator": "@rules_rust_wasm_bindgen__wit-validator-0.2.1//:wit_validator",
            "wit-walrus": "@rules_rust_wasm_bindgen__wit-walrus-0.6.0//:wit_walrus",
        },
    },
}

_NORMAL_DEV_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "serde_derive": "@rules_rust_wasm_bindgen__serde_derive-1.0.152//:serde_derive",
        },
    },
}

_PROC_MACRO_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_BUILD_DEPENDENCIES = {
    "": {
    },
}

_BUILD_ALIASES = {
    "": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-uwp-windows-msvc": [],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"aarch64\"), target_os = \"hermit\"))": [],
    "cfg(all(target_arch = \"aarch64\", target_os = \"linux\"))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu"],
    "cfg(all(unix, not(target_os = \"macos\")))": ["@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "cfg(any(target_arch = \"aarch64\", target_arch = \"x86\", target_arch = \"x86_64\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-none"],
    "cfg(any(target_os = \"macos\", target_os = \"ios\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios"],
    "cfg(any(target_os = \"macos\", target_os = \"ios\", target_os = \"freebsd\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "cfg(any(unix, target_os = \"wasi\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-wasi", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "cfg(not(windows))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasi", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-none"],
    "cfg(target_arch = \"wasm32\")": ["@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasi"],
    "cfg(target_env = \"msvc\")": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(target_family = \"unix\")": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "cfg(target_os = \"android\")": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:x86_64-linux-android"],
    "cfg(target_os = \"haiku\")": [],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"wasi\")": ["@rules_rust//rust/platform:wasm32-wasi"],
    "cfg(target_os = \"windows\")": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-fuchsia", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-fuchsia", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "i686-pc-windows-gnu": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-uwp-windows-gnu": [],
    "i686-uwp-windows-msvc": [],
    "x86_64-pc-windows-gnu": [],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-uwp-windows-gnu": [],
    "x86_64-uwp-windows-msvc": [],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates"""
    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__aho-corasick-0.7.20",
        sha256 = "cc936419f96fa211c1b9166887b38e5e40b19958e5b895be7c1f93adec7071ac",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/aho-corasick/0.7.20/download"],
        strip_prefix = "aho-corasick-0.7.20",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.aho-corasick-0.7.20.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__android_system_properties-0.1.5",
        sha256 = "819e7219dbd41043ac279b19830f2efc897156490d7fd6ea916720117ee66311",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/android_system_properties/0.1.5/download"],
        strip_prefix = "android_system_properties-0.1.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.android_system_properties-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__anyhow-1.0.68",
        sha256 = "2cb2f989d18dd141ab8ae82f64d1a8cdd37e0840f73a406896cf5e99502fab61",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/anyhow/1.0.68/download"],
        strip_prefix = "anyhow-1.0.68",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.anyhow-1.0.68.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__ascii-1.1.0",
        sha256 = "d92bec98840b8f03a5ff5413de5293bfcd8bf96467cf5452609f939ec6f5de16",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ascii/1.1.0/download"],
        strip_prefix = "ascii-1.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.ascii-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__assert_cmd-1.0.8",
        sha256 = "c98233c6673d8601ab23e77eb38f999c51100d46c5703b17288c57fddf3a1ffe",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/assert_cmd/1.0.8/download"],
        strip_prefix = "assert_cmd-1.0.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.assert_cmd-1.0.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__atty-0.2.14",
        sha256 = "d9b39be18770d11421cdb1b9947a45dd3f37e93092cbf377614828a319d5fee8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/atty/0.2.14/download"],
        strip_prefix = "atty-0.2.14",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.atty-0.2.14.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__autocfg-1.1.0",
        sha256 = "d468802bab17cbc0cc575e9b053f41e72aa36bfa6b7f55e3529ffa43161b97fa",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/autocfg/1.1.0/download"],
        strip_prefix = "autocfg-1.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.autocfg-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__base64-0.13.1",
        sha256 = "9e1b586273c5702936fe7b7d6896644d8be71e6314cfe09d3167c95f712589e8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/base64/0.13.1/download"],
        strip_prefix = "base64-0.13.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.base64-0.13.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__base64-0.9.3",
        sha256 = "489d6c0ed21b11d038c31b6ceccca973e65d73ba3bd8ecb9a2babf5546164643",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/base64/0.9.3/download"],
        strip_prefix = "base64-0.9.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.base64-0.9.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__block-buffer-0.10.3",
        sha256 = "69cce20737498f97b993470a6e536b8523f0af7892a4f928cceb1ac5e52ebe7e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/block-buffer/0.10.3/download"],
        strip_prefix = "block-buffer-0.10.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.block-buffer-0.10.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__bstr-0.2.17",
        sha256 = "ba3569f383e8f1598449f1a423e72e99569137b47740b1da11ef19af3d5c3223",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bstr/0.2.17/download"],
        strip_prefix = "bstr-0.2.17",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.bstr-0.2.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__buf_redux-0.8.4",
        sha256 = "b953a6887648bb07a535631f2bc00fbdb2a2216f135552cb3f534ed136b9c07f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/buf_redux/0.8.4/download"],
        strip_prefix = "buf_redux-0.8.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.buf_redux-0.8.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__bumpalo-3.11.1",
        sha256 = "572f695136211188308f16ad2ca5c851a712c464060ae6974944458eb83880ba",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bumpalo/3.11.1/download"],
        strip_prefix = "bumpalo-3.11.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.bumpalo-3.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__byteorder-1.4.3",
        sha256 = "14c189c53d098945499cdfa7ecc63567cf3886b3332b312a5b4585d8d3a6a610",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/byteorder/1.4.3/download"],
        strip_prefix = "byteorder-1.4.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.byteorder-1.4.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__cc-1.0.78",
        sha256 = "a20104e2335ce8a659d6dd92a51a767a0c062599c73b343fd152cb401e828c3d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cc/1.0.78/download"],
        strip_prefix = "cc-1.0.78",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.cc-1.0.78.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__chrono-0.4.23",
        sha256 = "16b0a3d9ed01224b22057780a37bb8c5dbfe1be8ba48678e7bf57ec4b385411f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/chrono/0.4.23/download"],
        strip_prefix = "chrono-0.4.23",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.chrono-0.4.23.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__chunked_transfer-1.4.1",
        sha256 = "cca491388666e04d7248af3f60f0c40cfb0991c72205595d7c396e3510207d1a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/chunked_transfer/1.4.1/download"],
        strip_prefix = "chunked_transfer-1.4.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.chunked_transfer-1.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__codespan-reporting-0.11.1",
        sha256 = "3538270d33cc669650c4b093848450d380def10c331d38c768e34cac80576e6e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/codespan-reporting/0.11.1/download"],
        strip_prefix = "codespan-reporting-0.11.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.codespan-reporting-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__core-foundation-sys-0.8.3",
        sha256 = "5827cebf4670468b8772dd191856768aedcb1b0278a04f989f7766351917b9dc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/core-foundation-sys/0.8.3/download"],
        strip_prefix = "core-foundation-sys-0.8.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.core-foundation-sys-0.8.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__cpufeatures-0.2.5",
        sha256 = "28d997bd5e24a5928dd43e46dc529867e207907fe0b239c3477d924f7f2ca320",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cpufeatures/0.2.5/download"],
        strip_prefix = "cpufeatures-0.2.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.cpufeatures-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__crossbeam-channel-0.5.6",
        sha256 = "c2dd04ddaf88237dc3b8d8f9a3c1004b506b54b3313403944054d23c0870c521",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crossbeam-channel/0.5.6/download"],
        strip_prefix = "crossbeam-channel-0.5.6",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.crossbeam-channel-0.5.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__crossbeam-deque-0.8.2",
        sha256 = "715e8152b692bba2d374b53d4875445368fdf21a94751410af607a5ac677d1fc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crossbeam-deque/0.8.2/download"],
        strip_prefix = "crossbeam-deque-0.8.2",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.crossbeam-deque-0.8.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__crossbeam-epoch-0.9.13",
        sha256 = "01a9af1f4c2ef74bb8aa1f7e19706bc72d03598c8a570bb5de72243c7a9d9d5a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crossbeam-epoch/0.9.13/download"],
        strip_prefix = "crossbeam-epoch-0.9.13",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.crossbeam-epoch-0.9.13.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__crossbeam-utils-0.8.14",
        sha256 = "4fb766fa798726286dbbb842f174001dab8abc7b627a1dd86e0b7222a95d929f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crossbeam-utils/0.8.14/download"],
        strip_prefix = "crossbeam-utils-0.8.14",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.crossbeam-utils-0.8.14.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__crypto-common-0.1.6",
        sha256 = "1bfb12502f3fc46cca1bb51ac28df9d618d813cdc3d2f25b9fe775a34af26bb3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crypto-common/0.1.6/download"],
        strip_prefix = "crypto-common-0.1.6",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.crypto-common-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__curl-0.4.44",
        sha256 = "509bd11746c7ac09ebd19f0b17782eae80aadee26237658a6b4808afb5c11a22",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/curl/0.4.44/download"],
        strip_prefix = "curl-0.4.44",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.curl-0.4.44.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__curl-sys-0.4.59-curl-7.86.0",
        sha256 = "6cfce34829f448b08f55b7db6d0009e23e2e86a34e8c2b366269bf5799b4a407",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/curl-sys/0.4.59+curl-7.86.0/download"],
        strip_prefix = "curl-sys-0.4.59+curl-7.86.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.curl-sys-0.4.59+curl-7.86.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__cxx-1.0.85",
        sha256 = "5add3fc1717409d029b20c5b6903fc0c0b02fa6741d820054f4a2efa5e5816fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cxx/1.0.85/download"],
        strip_prefix = "cxx-1.0.85",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.cxx-1.0.85.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__cxx-build-1.0.85",
        sha256 = "b4c87959ba14bc6fbc61df77c3fcfe180fc32b93538c4f1031dd802ccb5f2ff0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cxx-build/1.0.85/download"],
        strip_prefix = "cxx-build-1.0.85",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.cxx-build-1.0.85.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__cxxbridge-flags-1.0.85",
        sha256 = "69a3e162fde4e594ed2b07d0f83c6c67b745e7f28ce58c6df5e6b6bef99dfb59",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cxxbridge-flags/1.0.85/download"],
        strip_prefix = "cxxbridge-flags-1.0.85",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.cxxbridge-flags-1.0.85.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__cxxbridge-macro-1.0.85",
        sha256 = "3e7e2adeb6a0d4a282e581096b06e1791532b7d576dcde5ccd9382acf55db8e6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cxxbridge-macro/1.0.85/download"],
        strip_prefix = "cxxbridge-macro-1.0.85",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.cxxbridge-macro-1.0.85.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__diff-0.1.13",
        sha256 = "56254986775e3233ffa9c4d7d3faaf6d36a2c09d30b20687e9f88bc8bafc16c8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/diff/0.1.13/download"],
        strip_prefix = "diff-0.1.13",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.diff-0.1.13.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__difference-2.0.0",
        sha256 = "524cbf6897b527295dff137cec09ecf3a05f4fddffd7dfcd1585403449e74198",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/difference/2.0.0/download"],
        strip_prefix = "difference-2.0.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.difference-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__difflib-0.4.0",
        sha256 = "6184e33543162437515c2e2b48714794e37845ec9851711914eec9d308f6ebe8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/difflib/0.4.0/download"],
        strip_prefix = "difflib-0.4.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.difflib-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__digest-0.10.6",
        sha256 = "8168378f4e5023e7218c89c891c0fd8ecdb5e5e4f18cb78f38cf245dd021e76f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/digest/0.10.6/download"],
        strip_prefix = "digest-0.10.6",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.digest-0.10.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__doc-comment-0.3.3",
        sha256 = "fea41bba32d969b513997752735605054bc0dfa92b4c56bf1189f2e174be7a10",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/doc-comment/0.3.3/download"],
        strip_prefix = "doc-comment-0.3.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.doc-comment-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__docopt-1.1.1",
        sha256 = "7f3f119846c823f9eafcf953a8f6ffb6ed69bf6240883261a7f13b634579a51f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/docopt/1.1.1/download"],
        strip_prefix = "docopt-1.1.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.docopt-1.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__either-1.8.0",
        sha256 = "90e5c1c8368803113bf0c9584fc495a58b86dc8a29edbf8fe877d21d9507e797",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/either/1.8.0/download"],
        strip_prefix = "either-1.8.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.either-1.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__env_logger-0.8.4",
        sha256 = "a19187fea3ac7e84da7dacf48de0c45d63c6a76f9490dae389aead16c243fce3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/env_logger/0.8.4/download"],
        strip_prefix = "env_logger-0.8.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.env_logger-0.8.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__fastrand-1.8.0",
        sha256 = "a7a407cfaa3385c4ae6b23e84623d48c2798d06e3e6a1878f7f59f17b3f86499",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/fastrand/1.8.0/download"],
        strip_prefix = "fastrand-1.8.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.fastrand-1.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__filetime-0.2.19",
        sha256 = "4e884668cd0c7480504233e951174ddc3b382f7c2666e3b7310b5c4e7b0c37f9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/filetime/0.2.19/download"],
        strip_prefix = "filetime-0.2.19",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.filetime-0.2.19.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__float-cmp-0.8.0",
        sha256 = "e1267f4ac4f343772758f7b1bdcbe767c218bbab93bb432acbf5162bbf85a6c4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/float-cmp/0.8.0/download"],
        strip_prefix = "float-cmp-0.8.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.float-cmp-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__form_urlencoded-1.1.0",
        sha256 = "a9c384f161156f5260c24a097c56119f9be8c798586aecc13afbcbe7b7e26bf8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/form_urlencoded/1.1.0/download"],
        strip_prefix = "form_urlencoded-1.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.form_urlencoded-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__generic-array-0.14.6",
        sha256 = "bff49e947297f3312447abdca79f45f4738097cc82b06e72054d2223f601f1b9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/generic-array/0.14.6/download"],
        strip_prefix = "generic-array-0.14.6",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.generic-array-0.14.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__getrandom-0.2.8",
        sha256 = "c05aeb6a22b8f62540c194aac980f2115af067bfe15a0734d7277a768d396b31",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/getrandom/0.2.8/download"],
        strip_prefix = "getrandom-0.2.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.getrandom-0.2.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__heck-0.3.3",
        sha256 = "6d621efb26863f0e9924c6ac577e8275e5e6b77455db64ffa6c65c904e9e132c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/heck/0.3.3/download"],
        strip_prefix = "heck-0.3.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.heck-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__hermit-abi-0.1.19",
        sha256 = "62b467343b94ba476dcb2500d242dadbb39557df889310ac77c5d99100aaac33",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hermit-abi/0.1.19/download"],
        strip_prefix = "hermit-abi-0.1.19",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.hermit-abi-0.1.19.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__hermit-abi-0.2.6",
        sha256 = "ee512640fe35acbfb4bb779db6f0d80704c2cacfa2e39b601ef3e3f47d1ae4c7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hermit-abi/0.2.6/download"],
        strip_prefix = "hermit-abi-0.2.6",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.hermit-abi-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__httparse-1.8.0",
        sha256 = "d897f394bad6a705d5f4104762e116a75639e470d80901eed05a860a95cb1904",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/httparse/1.8.0/download"],
        strip_prefix = "httparse-1.8.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.httparse-1.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__httpdate-1.0.2",
        sha256 = "c4a1e36c821dbe04574f602848a19f742f4fb3c98d40449f11bcad18d6b17421",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/httpdate/1.0.2/download"],
        strip_prefix = "httpdate-1.0.2",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.httpdate-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__humantime-2.1.0",
        sha256 = "9a3a5bfb195931eeb336b2a7b4d761daec841b97f947d34394601737a7bba5e4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/humantime/2.1.0/download"],
        strip_prefix = "humantime-2.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.humantime-2.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__iana-time-zone-0.1.53",
        sha256 = "64c122667b287044802d6ce17ee2ddf13207ed924c712de9a66a5814d5b64765",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/iana-time-zone/0.1.53/download"],
        strip_prefix = "iana-time-zone-0.1.53",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.iana-time-zone-0.1.53.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__iana-time-zone-haiku-0.1.1",
        sha256 = "0703ae284fc167426161c2e3f1da3ea71d94b21bedbcc9494e92b28e334e3dca",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/iana-time-zone-haiku/0.1.1/download"],
        strip_prefix = "iana-time-zone-haiku-0.1.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.iana-time-zone-haiku-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__id-arena-2.2.1",
        sha256 = "25a2bc672d1148e28034f176e01fffebb08b35768468cc954630da77a1449005",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/id-arena/2.2.1/download"],
        strip_prefix = "id-arena-2.2.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.id-arena-2.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__idna-0.3.0",
        sha256 = "e14ddfc70884202db2244c223200c204c2bda1bc6e0998d11b5e024d657209e6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/idna/0.3.0/download"],
        strip_prefix = "idna-0.3.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.idna-0.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__instant-0.1.12",
        sha256 = "7a5bbe824c507c5da5956355e86a746d82e0e1464f65d862cc5e71da70e94b2c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/instant/0.1.12/download"],
        strip_prefix = "instant-0.1.12",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.instant-0.1.12.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__itertools-0.10.5",
        sha256 = "b0fd2260e829bddf4cb6ea802289de2f86d6a7a690192fbe91b3f46e0f2c8473",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/itertools/0.10.5/download"],
        strip_prefix = "itertools-0.10.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.itertools-0.10.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__itoa-1.0.5",
        sha256 = "fad582f4b9e86b6caa621cabeb0963332d92eea04729ab12892c2533951e6440",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/itoa/1.0.5/download"],
        strip_prefix = "itoa-1.0.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.itoa-1.0.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__js-sys-0.3.60",
        sha256 = "49409df3e3bf0856b916e2ceaca09ee28e6871cf7d9ce97a692cacfdb2a25a47",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/js-sys/0.3.60/download"],
        strip_prefix = "js-sys-0.3.60",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.js-sys-0.3.60.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__lazy_static-1.4.0",
        sha256 = "e2abad23fbc42b3700f2f279844dc832adb2b2eb069b2df918f455c4e18cc646",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/lazy_static/1.4.0/download"],
        strip_prefix = "lazy_static-1.4.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.lazy_static-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__leb128-0.2.5",
        sha256 = "884e2677b40cc8c339eaefcb701c32ef1fd2493d71118dc0ca4b6a736c93bd67",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/leb128/0.2.5/download"],
        strip_prefix = "leb128-0.2.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.leb128-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__libc-0.2.139",
        sha256 = "201de327520df007757c1f0adce6e827fe8562fbc28bfd9c15571c66ca1f5f79",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/libc/0.2.139/download"],
        strip_prefix = "libc-0.2.139",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.libc-0.2.139.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__libz-sys-1.1.8",
        sha256 = "9702761c3935f8cc2f101793272e202c72b99da8f4224a19ddcf1279a6450bbf",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/libz-sys/1.1.8/download"],
        strip_prefix = "libz-sys-1.1.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.libz-sys-1.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__link-cplusplus-1.0.8",
        sha256 = "ecd207c9c713c34f95a097a5b029ac2ce6010530c7b49d7fea24d977dede04f5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/link-cplusplus/1.0.8/download"],
        strip_prefix = "link-cplusplus-1.0.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.link-cplusplus-1.0.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__log-0.4.17",
        sha256 = "abb12e687cfb44aa40f41fc3978ef76448f9b6038cad6aef4259d3c095a2382e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/log/0.4.17/download"],
        strip_prefix = "log-0.4.17",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.log-0.4.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__memchr-2.5.0",
        sha256 = "2dffe52ecf27772e601905b7522cb4ef790d2cc203488bbd0e2fe85fcb74566d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/memchr/2.5.0/download"],
        strip_prefix = "memchr-2.5.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.memchr-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__memoffset-0.7.1",
        sha256 = "5de893c32cde5f383baa4c04c5d6dbdd735cfd4a794b0debdb2bb1b421da5ff4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/memoffset/0.7.1/download"],
        strip_prefix = "memoffset-0.7.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.memoffset-0.7.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__mime-0.3.16",
        sha256 = "2a60c7ce501c71e03a9c9c0d35b861413ae925bd979cc7a4e30d060069aaac8d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/mime/0.3.16/download"],
        strip_prefix = "mime-0.3.16",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.mime-0.3.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__mime_guess-2.0.4",
        sha256 = "4192263c238a5f0d0c6bfd21f336a313a4ce1c450542449ca191bb657b4642ef",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/mime_guess/2.0.4/download"],
        strip_prefix = "mime_guess-2.0.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.mime_guess-2.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__multipart-0.18.0",
        sha256 = "00dec633863867f29cb39df64a397cdf4a6354708ddd7759f70c7fb51c5f9182",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/multipart/0.18.0/download"],
        strip_prefix = "multipart-0.18.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.multipart-0.18.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__normalize-line-endings-0.3.0",
        sha256 = "61807f77802ff30975e01f4f071c8ba10c022052f98b3294119f3e615d13e5be",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/normalize-line-endings/0.3.0/download"],
        strip_prefix = "normalize-line-endings-0.3.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.normalize-line-endings-0.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__num-integer-0.1.45",
        sha256 = "225d3389fb3509a24c93f5c29eb6bde2586b98d9f016636dff58d7c6f7569cd9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num-integer/0.1.45/download"],
        strip_prefix = "num-integer-0.1.45",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.num-integer-0.1.45.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__num-traits-0.2.15",
        sha256 = "578ede34cf02f8924ab9447f50c28075b4d3e5b269972345e7e0372b38c6cdcd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num-traits/0.2.15/download"],
        strip_prefix = "num-traits-0.2.15",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.num-traits-0.2.15.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__num_cpus-1.15.0",
        sha256 = "0fac9e2da13b5eb447a6ce3d392f23a29d8694bff781bf03a16cd9ac8697593b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num_cpus/1.15.0/download"],
        strip_prefix = "num_cpus-1.15.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.num_cpus-1.15.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__num_threads-0.1.6",
        sha256 = "2819ce041d2ee131036f4fc9d6ae7ae125a3a40e97ba64d04fe799ad9dabbb44",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num_threads/0.1.6/download"],
        strip_prefix = "num_threads-0.1.6",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.num_threads-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__once_cell-1.17.0",
        sha256 = "6f61fba1741ea2b3d6a1e3178721804bb716a68a6aeba1149b5d52e3d464ea66",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/once_cell/1.17.0/download"],
        strip_prefix = "once_cell-1.17.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.once_cell-1.17.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__openssl-probe-0.1.5",
        sha256 = "ff011a302c396a5197692431fc1948019154afc178baf7d8e37367442a4601cf",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/openssl-probe/0.1.5/download"],
        strip_prefix = "openssl-probe-0.1.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.openssl-probe-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__openssl-sys-0.9.80",
        sha256 = "23bbbf7854cd45b83958ebe919f0e8e516793727652e27fda10a8384cfc790b7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/openssl-sys/0.9.80/download"],
        strip_prefix = "openssl-sys-0.9.80",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.openssl-sys-0.9.80.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__percent-encoding-2.2.0",
        sha256 = "478c572c3d73181ff3c2539045f6eb99e5491218eae919370993b890cdbdd98e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/percent-encoding/2.2.0/download"],
        strip_prefix = "percent-encoding-2.2.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.percent-encoding-2.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__pkg-config-0.3.26",
        sha256 = "6ac9a59f73473f1b8d852421e59e64809f025994837ef743615c6d0c5b305160",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pkg-config/0.3.26/download"],
        strip_prefix = "pkg-config-0.3.26",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.pkg-config-0.3.26.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__ppv-lite86-0.2.17",
        sha256 = "5b40af805b3121feab8a3c29f04d8ad262fa8e0561883e7653e024ae4479e6de",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ppv-lite86/0.2.17/download"],
        strip_prefix = "ppv-lite86-0.2.17",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.ppv-lite86-0.2.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__predicates-1.0.8",
        sha256 = "f49cfaf7fdaa3bfacc6fa3e7054e65148878354a5cfddcf661df4c851f8021df",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/predicates/1.0.8/download"],
        strip_prefix = "predicates-1.0.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.predicates-1.0.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__predicates-2.1.5",
        sha256 = "59230a63c37f3e18569bdb90e4a89cbf5bf8b06fea0b84e65ea10cc4df47addd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/predicates/2.1.5/download"],
        strip_prefix = "predicates-2.1.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.predicates-2.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__predicates-core-1.0.5",
        sha256 = "72f883590242d3c6fc5bf50299011695fa6590c2c70eac95ee1bdb9a733ad1a2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/predicates-core/1.0.5/download"],
        strip_prefix = "predicates-core-1.0.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.predicates-core-1.0.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__predicates-tree-1.0.7",
        sha256 = "54ff541861505aabf6ea722d2131ee980b8276e10a1297b94e896dd8b621850d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/predicates-tree/1.0.7/download"],
        strip_prefix = "predicates-tree-1.0.7",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.predicates-tree-1.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__proc-macro2-1.0.49",
        sha256 = "57a8eca9f9c4ffde41714334dee777596264c7825420f521abc92b5b5deb63a5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/proc-macro2/1.0.49/download"],
        strip_prefix = "proc-macro2-1.0.49",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.proc-macro2-1.0.49.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__quick-error-1.2.3",
        sha256 = "a1d01941d82fa2ab50be1e79e6714289dd7cde78eba4c074bc5a4374f650dfe0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/quick-error/1.2.3/download"],
        strip_prefix = "quick-error-1.2.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.quick-error-1.2.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__quote-1.0.23",
        sha256 = "8856d8364d252a14d474036ea1358d63c9e6965c8e5c1885c18f73d70bff9c7b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/quote/1.0.23/download"],
        strip_prefix = "quote-1.0.23",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.quote-1.0.23.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rand-0.8.5",
        sha256 = "34af8d1a0e25924bc5b7c43c079c942339d8f0a8b57c39049bef581b46327404",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand/0.8.5/download"],
        strip_prefix = "rand-0.8.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rand-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rand_chacha-0.3.1",
        sha256 = "e6c10a63a0fa32252be49d21e7709d4d4baf8d231c2dbce1eaa8141b9b127d88",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand_chacha/0.3.1/download"],
        strip_prefix = "rand_chacha-0.3.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rand_chacha-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rand_core-0.6.4",
        sha256 = "ec0be4795e2f6a28069bec0b5ff3e2ac9bafc99e6a9a7dc3547996c5c816922c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand_core/0.6.4/download"],
        strip_prefix = "rand_core-0.6.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rand_core-0.6.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rayon-1.6.1",
        sha256 = "6db3a213adf02b3bcfd2d3846bb41cb22857d131789e01df434fb7e7bc0759b7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rayon/1.6.1/download"],
        strip_prefix = "rayon-1.6.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rayon-1.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rayon-core-1.10.1",
        sha256 = "cac410af5d00ab6884528b4ab69d1e8e146e8d471201800fa1b4524126de6ad3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rayon-core/1.10.1/download"],
        strip_prefix = "rayon-core-1.10.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rayon-core-1.10.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__redox_syscall-0.2.16",
        sha256 = "fb5a58c1855b4b6819d59012155603f0b22ad30cad752600aadfcb695265519a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/redox_syscall/0.2.16/download"],
        strip_prefix = "redox_syscall-0.2.16",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.redox_syscall-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__regex-1.7.0",
        sha256 = "e076559ef8e241f2ae3479e36f97bd5741c0330689e217ad51ce2c76808b868a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/regex/1.7.0/download"],
        strip_prefix = "regex-1.7.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.regex-1.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__regex-automata-0.1.10",
        sha256 = "6c230d73fb8d8c1b9c0b3135c5142a8acee3a0558fb8db5cf1cb65f8d7862132",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/regex-automata/0.1.10/download"],
        strip_prefix = "regex-automata-0.1.10",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.regex-automata-0.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__regex-syntax-0.6.28",
        sha256 = "456c603be3e8d448b072f410900c09faf164fbce2d480456f50eea6e25f9c848",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/regex-syntax/0.6.28/download"],
        strip_prefix = "regex-syntax-0.6.28",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.regex-syntax-0.6.28.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__remove_dir_all-0.5.3",
        sha256 = "3acd125665422973a33ac9d3dd2df85edad0f4ae9b00dafb1a05e43a9f5ef8e7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/remove_dir_all/0.5.3/download"],
        strip_prefix = "remove_dir_all-0.5.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.remove_dir_all-0.5.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rouille-3.6.1",
        sha256 = "4f86e4c51a773f953f02bbab5fd049f004bfd384341d62da2a079aff812ab176",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rouille/3.6.1/download"],
        strip_prefix = "rouille-3.6.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rouille-3.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rustc-demangle-0.1.21",
        sha256 = "7ef03e0a2b150c7a90d01faf6254c9c48a41e95fb2a8c2ac1c6f0d2b9aefc342",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rustc-demangle/0.1.21/download"],
        strip_prefix = "rustc-demangle-0.1.21",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rustc-demangle-0.1.21.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__ryu-1.0.12",
        sha256 = "7b4b9743ed687d4b4bcedf9ff5eaa7398495ae14e61cba0a295704edbc7decde",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ryu/1.0.12/download"],
        strip_prefix = "ryu-1.0.12",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.ryu-1.0.12.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__safemem-0.3.3",
        sha256 = "ef703b7cb59335eae2eb93ceb664c0eb7ea6bf567079d843e09420219668e072",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/safemem/0.3.3/download"],
        strip_prefix = "safemem-0.3.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.safemem-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__schannel-0.1.20",
        sha256 = "88d6731146462ea25d9244b2ed5fd1d716d25c52e4d54aa4fb0f3c4e9854dbe2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/schannel/0.1.20/download"],
        strip_prefix = "schannel-0.1.20",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.schannel-0.1.20.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__scopeguard-1.1.0",
        sha256 = "d29ab0c6d3fc0ee92fe66e2d99f700eab17a8d57d1c1d3b748380fb20baa78cd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/scopeguard/1.1.0/download"],
        strip_prefix = "scopeguard-1.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.scopeguard-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__scratch-1.0.3",
        sha256 = "ddccb15bcce173023b3fedd9436f882a0739b8dfb45e4f6b6002bee5929f61b2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/scratch/1.0.3/download"],
        strip_prefix = "scratch-1.0.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.scratch-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__serde-1.0.152",
        sha256 = "bb7d1f0d3021d347a83e556fc4683dea2ea09d87bccdf88ff5c12545d89d5efb",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde/1.0.152/download"],
        strip_prefix = "serde-1.0.152",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.serde-1.0.152.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__serde_derive-1.0.152",
        sha256 = "af487d118eecd09402d70a5d72551860e788df87b464af30e5ea6a38c75c541e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_derive/1.0.152/download"],
        strip_prefix = "serde_derive-1.0.152",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.serde_derive-1.0.152.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__serde_json-1.0.91",
        sha256 = "877c235533714907a8c2464236f5c4b2a17262ef1bd71f38f35ea592c8da6883",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_json/1.0.91/download"],
        strip_prefix = "serde_json-1.0.91",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.serde_json-1.0.91.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__sha1-0.10.5",
        sha256 = "f04293dc80c3993519f2d7f6f511707ee7094fe0c6d3406feb330cdb3540eba3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/sha1/0.10.5/download"],
        strip_prefix = "sha1-0.10.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.sha1-0.10.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__socket2-0.4.7",
        sha256 = "02e2d2db9033d13a1567121ddd7a095ee144db4e1ca1b1bda3419bc0da294ebd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/socket2/0.4.7/download"],
        strip_prefix = "socket2-0.4.7",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.socket2-0.4.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__strsim-0.10.0",
        sha256 = "73473c0e59e6d5812c5dfe2a064a6444949f089e20eec9a2e5506596494e4623",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/strsim/0.10.0/download"],
        strip_prefix = "strsim-0.10.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.strsim-0.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__syn-1.0.107",
        sha256 = "1f4064b5b16e03ae50984a5a8ed5d4f8803e6bc1fd170a3cda91a1be4b18e3f5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/syn/1.0.107/download"],
        strip_prefix = "syn-1.0.107",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.syn-1.0.107.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__tempfile-3.3.0",
        sha256 = "5cdb1ef4eaeeaddc8fbd371e5017057064af0911902ef36b39801f67cc6d79e4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tempfile/3.3.0/download"],
        strip_prefix = "tempfile-3.3.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.tempfile-3.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__termcolor-1.1.3",
        sha256 = "bab24d30b911b2376f3a13cc2cd443142f0c81dda04c118693e35b3835757755",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/termcolor/1.1.3/download"],
        strip_prefix = "termcolor-1.1.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.termcolor-1.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__termtree-0.4.0",
        sha256 = "95059e91184749cb66be6dc994f67f182b6d897cb3df74a5bf66b5e709295fd8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/termtree/0.4.0/download"],
        strip_prefix = "termtree-0.4.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.termtree-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__threadpool-1.8.1",
        sha256 = "d050e60b33d41c19108b32cea32164033a9013fe3b46cbd4457559bfbf77afaa",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/threadpool/1.8.1/download"],
        strip_prefix = "threadpool-1.8.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.threadpool-1.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__time-0.3.17",
        sha256 = "a561bf4617eebd33bca6434b988f39ed798e527f51a1e797d0ee4f61c0a38376",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/time/0.3.17/download"],
        strip_prefix = "time-0.3.17",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.time-0.3.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__time-core-0.1.0",
        sha256 = "2e153e1f1acaef8acc537e68b44906d2db6436e2b35ac2c6b42640fff91f00fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/time-core/0.1.0/download"],
        strip_prefix = "time-core-0.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.time-core-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__tiny_http-0.12.0",
        sha256 = "389915df6413a2e74fb181895f933386023c71110878cd0825588928e64cdc82",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tiny_http/0.12.0/download"],
        strip_prefix = "tiny_http-0.12.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.tiny_http-0.12.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__tinyvec-1.6.0",
        sha256 = "87cc5ceb3875bb20c2890005a4e226a4651264a5c75edb2421b52861a0a0cb50",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tinyvec/1.6.0/download"],
        strip_prefix = "tinyvec-1.6.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.tinyvec-1.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__tinyvec_macros-0.1.0",
        sha256 = "cda74da7e1a664f795bb1f8a87ec406fb89a02522cf6e50620d016add6dbbf5c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tinyvec_macros/0.1.0/download"],
        strip_prefix = "tinyvec_macros-0.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.tinyvec_macros-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__twoway-0.1.8",
        sha256 = "59b11b2b5241ba34be09c3cc85a36e56e48f9888862e19cedf23336d35316ed1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/twoway/0.1.8/download"],
        strip_prefix = "twoway-0.1.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.twoway-0.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__typenum-1.16.0",
        sha256 = "497961ef93d974e23eb6f433eb5fe1b7930b659f06d12dec6fc44a8f554c0bba",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/typenum/1.16.0/download"],
        strip_prefix = "typenum-1.16.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.typenum-1.16.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicase-2.6.0",
        sha256 = "50f37be617794602aabbeee0be4f259dc1778fabe05e2d67ee8f79326d5cb4f6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicase/2.6.0/download"],
        strip_prefix = "unicase-2.6.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicase-2.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicode-bidi-0.3.8",
        sha256 = "099b7128301d285f79ddd55b9a83d5e6b9e97c92e0ea0daebee7263e932de992",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-bidi/0.3.8/download"],
        strip_prefix = "unicode-bidi-0.3.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicode-bidi-0.3.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicode-ident-1.0.6",
        sha256 = "84a22b9f218b40614adcb3f4ff08b703773ad44fa9423e4e0d346d5db86e4ebc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-ident/1.0.6/download"],
        strip_prefix = "unicode-ident-1.0.6",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicode-ident-1.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicode-normalization-0.1.22",
        sha256 = "5c5713f0fc4b5db668a2ac63cdb7bb4469d8c9fed047b1d0292cc7b0ce2ba921",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-normalization/0.1.22/download"],
        strip_prefix = "unicode-normalization-0.1.22",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicode-normalization-0.1.22.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicode-segmentation-1.10.0",
        sha256 = "0fdbf052a0783de01e944a6ce7a8cb939e295b1e7be835a1112c3b9a7f047a5a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-segmentation/1.10.0/download"],
        strip_prefix = "unicode-segmentation-1.10.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicode-segmentation-1.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicode-width-0.1.10",
        sha256 = "c0edd1e5b14653f783770bce4a4dabb4a5108a5370a5f5d8cfe8710c361f6c8b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-width/0.1.10/download"],
        strip_prefix = "unicode-width-0.1.10",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicode-width-0.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__url-2.3.1",
        sha256 = "0d68c799ae75762b8c3fe375feb6600ef5602c883c5d21eb51c09f22b83c4643",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/url/2.3.1/download"],
        strip_prefix = "url-2.3.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.url-2.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__vcpkg-0.2.15",
        sha256 = "accd4ea62f7bb7a82fe23066fb0957d48ef677f6eeb8215f372f52e48bb32426",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/vcpkg/0.2.15/download"],
        strip_prefix = "vcpkg-0.2.15",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.vcpkg-0.2.15.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__version_check-0.9.4",
        sha256 = "49874b5167b65d7193b8aba1567f5c7d93d001cafc34600cee003eda787e483f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/version_check/0.9.4/download"],
        strip_prefix = "version_check-0.9.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.version_check-0.9.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wait-timeout-0.2.0",
        sha256 = "9f200f5b12eb75f8c1ed65abd4b2db8a6e1b138a20de009dacee265a2498f3f6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wait-timeout/0.2.0/download"],
        strip_prefix = "wait-timeout-0.2.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wait-timeout-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__walrus-0.19.0",
        sha256 = "4eb08e48cde54c05f363d984bb54ce374f49e242def9468d2e1b6c2372d291f8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/walrus/0.19.0/download"],
        strip_prefix = "walrus-0.19.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.walrus-0.19.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__walrus-macro-0.19.0",
        sha256 = "0a6e5bd22c71e77d60140b0bd5be56155a37e5bd14e24f5f87298040d0cc40d7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/walrus-macro/0.19.0/download"],
        strip_prefix = "walrus-macro-0.19.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.walrus-macro-0.19.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasi-0.11.0-wasi-snapshot-preview1",
        sha256 = "9c8d87e72b64a3b4db28d11ce29237c246188f4f51057d65a7eab63b7987e423",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasi/0.11.0+wasi-snapshot-preview1/download"],
        strip_prefix = "wasi-0.11.0+wasi-snapshot-preview1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasi-0.11.0+wasi-snapshot-preview1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-0.2.84",
        sha256 = "31f8dcbc21f30d9b8f2ea926ecb58f6b91192c17e9d33594b3df58b2007ca53b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen/0.2.84/download"],
        strip_prefix = "wasm-bindgen-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-backend-0.2.84",
        sha256 = "95ce90fd5bcc06af55a641a86428ee4229e44e07033963a2290a8e241607ccb9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-backend/0.2.84/download"],
        strip_prefix = "wasm-bindgen-backend-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-backend-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-cli-support-0.2.84",
        sha256 = "9d4780c659b883a19ddb7ced365db19f7f45cd182d832ee14de2b7ef52e88a9f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-cli-support/0.2.84/download"],
        strip_prefix = "wasm-bindgen-cli-support-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-cli-support-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-externref-xform-0.2.84",
        sha256 = "1d154c3843bf3b635b602ad41b56f505f8f1a25f8a0133fca4bbd0918d74efdc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-externref-xform/0.2.84/download"],
        strip_prefix = "wasm-bindgen-externref-xform-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-externref-xform-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-macro-0.2.84",
        sha256 = "4c21f77c0bedc37fd5dc21f897894a5ca01e7bb159884559461862ae90c0b4c5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-macro/0.2.84/download"],
        strip_prefix = "wasm-bindgen-macro-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-macro-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-macro-support-0.2.84",
        sha256 = "2aff81306fcac3c7515ad4e177f521b5c9a15f2b08f4e32d823066102f35a5f6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-macro-support/0.2.84/download"],
        strip_prefix = "wasm-bindgen-macro-support-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-macro-support-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-multi-value-xform-0.2.84",
        sha256 = "c00a577fbd4be358ef8095432189b5c2e6b6e71f5081797c2032572f77d65d26",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-multi-value-xform/0.2.84/download"],
        strip_prefix = "wasm-bindgen-multi-value-xform-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-multi-value-xform-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-shared-0.2.84",
        sha256 = "0046fef7e28c3804e5e38bfa31ea2a0f73905319b677e57ebe37e49358989b5d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-shared/0.2.84/download"],
        strip_prefix = "wasm-bindgen-shared-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-shared-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-threads-xform-0.2.84",
        sha256 = "0aa93941bae037b7b4fac4ecfc132294b828036c5990a806d0e6fd9284297d94",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-threads-xform/0.2.84/download"],
        strip_prefix = "wasm-bindgen-threads-xform-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-threads-xform-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-wasm-conventions-0.2.84",
        sha256 = "d8f5de325048d945c90600fdf66b13521f3340d85971287775c36aa99c04466b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-wasm-conventions/0.2.84/download"],
        strip_prefix = "wasm-bindgen-wasm-conventions-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-wasm-conventions-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-wasm-interpreter-0.2.84",
        sha256 = "f695df44962e3a107436282232a2daa185b8453c16be8ddfb637cd2601f31128",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-wasm-interpreter/0.2.84/download"],
        strip_prefix = "wasm-bindgen-wasm-interpreter-0.2.84",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-wasm-interpreter-0.2.84.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasmparser-0.59.0",
        sha256 = "a950e6a618f62147fd514ff445b2a0b53120d382751960797f85f058c7eda9b9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasmparser/0.59.0/download"],
        strip_prefix = "wasmparser-0.59.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasmparser-0.59.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasmparser-0.77.0",
        sha256 = "b35c86d22e720a07d954ebbed772d01180501afe7d03d464f413bb5f8914a8d6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasmparser/0.77.0/download"],
        strip_prefix = "wasmparser-0.77.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasmparser-0.77.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasmparser-0.83.0",
        sha256 = "718ed7c55c2add6548cca3ddd6383d738cd73b892df400e96b9aa876f0141d7a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasmparser/0.83.0/download"],
        strip_prefix = "wasmparser-0.83.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasmparser-0.83.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasmprinter-0.2.33",
        sha256 = "f973822fb3ca7e03ab421910274514b405df19a3d53acb131ae4df3a2fc4eb58",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasmprinter/0.2.33/download"],
        strip_prefix = "wasmprinter-0.2.33",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasmprinter-0.2.33.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wast-21.0.0",
        sha256 = "0b1844f66a2bc8526d71690104c0e78a8e59ffa1597b7245769d174ebb91deb5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wast/21.0.0/download"],
        strip_prefix = "wast-21.0.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wast-21.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__winapi-util-0.1.5",
        sha256 = "70ec6ce85bb158151cae5e5c87f95a8e97d2c0c4b001223f33a334e3ce5de178",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-util/0.1.5/download"],
        strip_prefix = "winapi-util-0.1.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.winapi-util-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows-sys-0.36.1",
        sha256 = "ea04155a16a59f9eab786fe12a4a450e75cdb175f9e0d80da1e17db09f55b8d2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows-sys/0.36.1/download"],
        strip_prefix = "windows-sys-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows-sys-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows-sys-0.42.0",
        sha256 = "5a3e1820f08b8513f676f7ab6c1f99ff312fb97b553d30ff4dd86f9f15728aa7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows-sys/0.42.0/download"],
        strip_prefix = "windows-sys-0.42.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows-sys-0.42.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_aarch64_gnullvm-0.42.0",
        sha256 = "41d2aa71f6f0cbe00ae5167d90ef3cfe66527d6f613ca78ac8024c3ccab9a19e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_aarch64_gnullvm/0.42.0/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.42.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_aarch64_gnullvm-0.42.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_aarch64_msvc-0.36.1",
        sha256 = "9bb8c3fd39ade2d67e9874ac4f3db21f0d710bee00fe7cab16949ec184eeaa47",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_aarch64_msvc/0.36.1/download"],
        strip_prefix = "windows_aarch64_msvc-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_aarch64_msvc-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_aarch64_msvc-0.42.0",
        sha256 = "dd0f252f5a35cac83d6311b2e795981f5ee6e67eb1f9a7f64eb4500fbc4dcdb4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_aarch64_msvc/0.42.0/download"],
        strip_prefix = "windows_aarch64_msvc-0.42.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_aarch64_msvc-0.42.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_i686_gnu-0.36.1",
        sha256 = "180e6ccf01daf4c426b846dfc66db1fc518f074baa793aa7d9b9aaeffad6a3b6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_gnu/0.36.1/download"],
        strip_prefix = "windows_i686_gnu-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_i686_gnu-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_i686_gnu-0.42.0",
        sha256 = "fbeae19f6716841636c28d695375df17562ca208b2b7d0dc47635a50ae6c5de7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_gnu/0.42.0/download"],
        strip_prefix = "windows_i686_gnu-0.42.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_i686_gnu-0.42.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_i686_msvc-0.36.1",
        sha256 = "e2e7917148b2812d1eeafaeb22a97e4813dfa60a3f8f78ebe204bcc88f12f024",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_msvc/0.36.1/download"],
        strip_prefix = "windows_i686_msvc-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_i686_msvc-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_i686_msvc-0.42.0",
        sha256 = "84c12f65daa39dd2babe6e442988fc329d6243fdce47d7d2d155b8d874862246",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_msvc/0.42.0/download"],
        strip_prefix = "windows_i686_msvc-0.42.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_i686_msvc-0.42.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_x86_64_gnu-0.36.1",
        sha256 = "4dcd171b8776c41b97521e5da127a2d86ad280114807d0b2ab1e462bc764d9e1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_gnu/0.36.1/download"],
        strip_prefix = "windows_x86_64_gnu-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_x86_64_gnu-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_x86_64_gnu-0.42.0",
        sha256 = "bf7b1b21b5362cbc318f686150e5bcea75ecedc74dd157d874d754a2ca44b0ed",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_gnu/0.42.0/download"],
        strip_prefix = "windows_x86_64_gnu-0.42.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_x86_64_gnu-0.42.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_x86_64_gnullvm-0.42.0",
        sha256 = "09d525d2ba30eeb3297665bd434a54297e4170c7f1a44cad4ef58095b4cd2028",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_gnullvm/0.42.0/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.42.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_x86_64_gnullvm-0.42.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_x86_64_msvc-0.36.1",
        sha256 = "c811ca4a8c853ef420abd8592ba53ddbbac90410fab6903b3e79972a631f7680",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_msvc/0.36.1/download"],
        strip_prefix = "windows_x86_64_msvc-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_x86_64_msvc-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_x86_64_msvc-0.42.0",
        sha256 = "f40009d85759725a34da6d89a94e63d7bdc50a862acf0dbc7c8e488f1edcb6f5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_msvc/0.42.0/download"],
        strip_prefix = "windows_x86_64_msvc-0.42.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_x86_64_msvc-0.42.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-parser-0.2.0",
        sha256 = "3f5fd97866f4b9c8e1ed57bcf9446f3d0d8ba37e2dd01c3c612c046c053b06f7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-parser/0.2.0/download"],
        strip_prefix = "wit-parser-0.2.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-parser-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-printer-0.2.0",
        sha256 = "93f19ca44555a3c14d69acee6447a6e4f52771b0c6e5d8db3e42db3b90f6fce9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-printer/0.2.0/download"],
        strip_prefix = "wit-printer-0.2.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-printer-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-schema-version-0.1.0",
        sha256 = "bfee4a6a4716eefa0682e7a3b836152e894a3e4f34a9d6c2c3e1c94429bfe36a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-schema-version/0.1.0/download"],
        strip_prefix = "wit-schema-version-0.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-schema-version-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-text-0.8.0",
        sha256 = "33358e95c77d660f1c7c07f4a93c2bd89768965e844e3c50730bb4b42658df5f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-text/0.8.0/download"],
        strip_prefix = "wit-text-0.8.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-text-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-validator-0.2.1",
        sha256 = "3c11d93d925420e7872b226c4161849c32be38385ccab026b88df99d8ddc6ba6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-validator/0.2.1/download"],
        strip_prefix = "wit-validator-0.2.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-validator-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-walrus-0.6.0",
        sha256 = "ad559e3e4c6404b2a6a675d44129d62a3836e3b951b90112fa1c5feb852757cd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-walrus/0.6.0/download"],
        strip_prefix = "wit-walrus-0.6.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-walrus-0.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-writer-0.2.0",
        sha256 = "c2ad01ba5e9cbcff799a0689e56a153776ea694cec777f605938cb9880d41a09",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-writer/0.2.0/download"],
        strip_prefix = "wit-writer-0.2.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-writer-0.2.0.bazel"),
    )
