/*################################################################################
  ##
  ##   Copyright (C) 2016-2023 Keith O'Hara
  ##
  ##   This file is part of the GCE-Math C++ library.
  ##
  ##   Licensed under the Apache License, Version 2.0 (the "License");
  ##   you may not use this file except in compliance with the License.
  ##   You may obtain a copy of the License at
  ##
  ##       http://www.apache.org/licenses/LICENSE-2.0
  ##
  ##   Unless required by applicable law or agreed to in writing, software
  ##   distributed under the License is distributed on an "AS IS" BASIS,
  ##   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  ##   See the License for the specific language governing permissions and
  ##   limitations under the License.
  ##
  ################################################################################*/

/*
 * compile-time check if integer is odd
 */

#ifndef _gcem_is_odd_HPP
#define _gcem_is_odd_HPP

namespace gcem
{

namespace internal
{

constexpr
bool
is_odd(const llint_t x)
noexcept
{
    // return( x % llint_t(2) == llint_t(0) ? false : true );
    return (x & 1U) != 0;
}

}

}

#endif
