// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.
// Code generated by protocol buffer compiler. Do not edit!
package edu.wpi.first.math.proto;

import java.io.IOException;
import us.hebi.quickbuf.Descriptors;
import us.hebi.quickbuf.FieldName;
import us.hebi.quickbuf.InvalidProtocolBufferException;
import us.hebi.quickbuf.JsonSink;
import us.hebi.quickbuf.JsonSource;
import us.hebi.quickbuf.MessageFactory;
import us.hebi.quickbuf.ProtoMessage;
import us.hebi.quickbuf.ProtoSink;
import us.hebi.quickbuf.ProtoSource;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedByte;

public final class Geometry2D {
  private static final RepeatedByte descriptorData = ProtoUtil.decodeBase64(1256,
    "ChBnZW9tZXRyeTJkLnByb3RvEgl3cGkucHJvdG8iMwoVUHJvdG9idWZUcmFuc2xhdGlvbjJkEgwKAXgY" + 
    "ASABKAFSAXgSDAoBeRgCIAEoAVIBeSIqChJQcm90b2J1ZlJvdGF0aW9uMmQSFAoFdmFsdWUYASABKAFS" + 
    "BXZhbHVlIo8BCg5Qcm90b2J1ZlBvc2UyZBJCCgt0cmFuc2xhdGlvbhgBIAEoCzIgLndwaS5wcm90by5Q" + 
    "cm90b2J1ZlRyYW5zbGF0aW9uMmRSC3RyYW5zbGF0aW9uEjkKCHJvdGF0aW9uGAIgASgLMh0ud3BpLnBy" + 
    "b3RvLlByb3RvYnVmUm90YXRpb24yZFIIcm90YXRpb24ilAEKE1Byb3RvYnVmVHJhbnNmb3JtMmQSQgoL" + 
    "dHJhbnNsYXRpb24YASABKAsyIC53cGkucHJvdG8uUHJvdG9idWZUcmFuc2xhdGlvbjJkUgt0cmFuc2xh" + 
    "dGlvbhI5Cghyb3RhdGlvbhgCIAEoCzIdLndwaS5wcm90by5Qcm90b2J1ZlJvdGF0aW9uMmRSCHJvdGF0" + 
    "aW9uIkkKD1Byb3RvYnVmVHdpc3QyZBIOCgJkeBgBIAEoAVICZHgSDgoCZHkYAiABKAFSAmR5EhYKBmR0" + 
    "aGV0YRgDIAEoAVIGZHRoZXRhQhoKGGVkdS53cGkuZmlyc3QubWF0aC5wcm90b0rPBQoGEgQAAB0BCggK" + 
    "AQwSAwAAEgoICgECEgMCABIKCAoBCBIDBAAxCgkKAggBEgMEADEKCgoCBAASBAYACQEKCgoDBAABEgMG" + 
    "CB0KCwoEBAACABIDBwIPCgwKBQQAAgAFEgMHAggKDAoFBAACAAESAwcJCgoMCgUEAAIAAxIDBw0OCgsK" + 
    "BAQAAgESAwgCDwoMCgUEAAIBBRIDCAIICgwKBQQAAgEBEgMICQoKDAoFBAACAQMSAwgNDgoKCgIEARIE" + 
    "CwANAQoKCgMEAQESAwsIGgoLCgQEAQIAEgMMAhMKDAoFBAECAAUSAwwCCAoMCgUEAQIAARIDDAkOCgwK" + 
    "BQQBAgADEgMMERIKCgoCBAISBA8AEgEKCgoDBAIBEgMPCBYKCwoEBAICABIDEAIoCgwKBQQCAgAGEgMQ" + 
    "AhcKDAoFBAICAAESAxAYIwoMCgUEAgIAAxIDECYnCgsKBAQCAgESAxECIgoMCgUEAgIBBhIDEQIUCgwK" + 
    "BQQCAgEBEgMRFR0KDAoFBAICAQMSAxEgIQoKCgIEAxIEFAAXAQoKCgMEAwESAxQIGwoLCgQEAwIAEgMV" + 
    "AigKDAoFBAMCAAYSAxUCFwoMCgUEAwIAARIDFRgjCgwKBQQDAgADEgMVJicKCwoEBAMCARIDFgIiCgwK" + 
    "BQQDAgEGEgMWAhQKDAoFBAMCAQESAxYVHQoMCgUEAwIBAxIDFiAhCgoKAgQEEgQZAB0BCgoKAwQEARID" + 
    "GQgXCgsKBAQEAgASAxoCEAoMCgUEBAIABRIDGgIICgwKBQQEAgABEgMaCQsKDAoFBAQCAAMSAxoODwoL" + 
    "CgQEBAIBEgMbAhAKDAoFBAQCAQUSAxsCCAoMCgUEBAIBARIDGwkLCgwKBQQEAgEDEgMbDg8KCwoEBAQC",
    "AhIDHAIUCgwKBQQEAgIFEgMcAggKDAoFBAQCAgESAxwJDwoMCgUEBAICAxIDHBITYgZwcm90bzM=");

  static final Descriptors.FileDescriptor descriptor = Descriptors.FileDescriptor.internalBuildGeneratedFileFrom("geometry2d.proto", "wpi.proto", descriptorData);

  static final Descriptors.Descriptor wpi_proto_ProtobufTranslation2d_descriptor = descriptor.internalContainedType(31, 51, "ProtobufTranslation2d", "wpi.proto.ProtobufTranslation2d");

  static final Descriptors.Descriptor wpi_proto_ProtobufRotation2d_descriptor = descriptor.internalContainedType(84, 42, "ProtobufRotation2d", "wpi.proto.ProtobufRotation2d");

  static final Descriptors.Descriptor wpi_proto_ProtobufPose2d_descriptor = descriptor.internalContainedType(129, 143, "ProtobufPose2d", "wpi.proto.ProtobufPose2d");

  static final Descriptors.Descriptor wpi_proto_ProtobufTransform2d_descriptor = descriptor.internalContainedType(275, 148, "ProtobufTransform2d", "wpi.proto.ProtobufTransform2d");

  static final Descriptors.Descriptor wpi_proto_ProtobufTwist2d_descriptor = descriptor.internalContainedType(425, 73, "ProtobufTwist2d", "wpi.proto.ProtobufTwist2d");

  /**
   * @return this proto file's descriptor.
   */
  public static Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  /**
   * Protobuf type {@code ProtobufTranslation2d}
   */
  public static final class ProtobufTranslation2d extends ProtoMessage<ProtobufTranslation2d> implements Cloneable {
    private static final long serialVersionUID = 0L;

    /**
     * <code>optional double x = 1;</code>
     */
    private double x;

    /**
     * <code>optional double y = 2;</code>
     */
    private double y;

    private ProtobufTranslation2d() {
    }

    /**
     * @return a new empty instance of {@code ProtobufTranslation2d}
     */
    public static ProtobufTranslation2d newInstance() {
      return new ProtobufTranslation2d();
    }

    /**
     * <code>optional double x = 1;</code>
     * @return whether the x field is set
     */
    public boolean hasX() {
      return (bitField0_ & 0x00000001) != 0;
    }

    /**
     * <code>optional double x = 1;</code>
     * @return this
     */
    public ProtobufTranslation2d clearX() {
      bitField0_ &= ~0x00000001;
      x = 0D;
      return this;
    }

    /**
     * <code>optional double x = 1;</code>
     * @return the x
     */
    public double getX() {
      return x;
    }

    /**
     * <code>optional double x = 1;</code>
     * @param value the x to set
     * @return this
     */
    public ProtobufTranslation2d setX(final double value) {
      bitField0_ |= 0x00000001;
      x = value;
      return this;
    }

    /**
     * <code>optional double y = 2;</code>
     * @return whether the y field is set
     */
    public boolean hasY() {
      return (bitField0_ & 0x00000002) != 0;
    }

    /**
     * <code>optional double y = 2;</code>
     * @return this
     */
    public ProtobufTranslation2d clearY() {
      bitField0_ &= ~0x00000002;
      y = 0D;
      return this;
    }

    /**
     * <code>optional double y = 2;</code>
     * @return the y
     */
    public double getY() {
      return y;
    }

    /**
     * <code>optional double y = 2;</code>
     * @param value the y to set
     * @return this
     */
    public ProtobufTranslation2d setY(final double value) {
      bitField0_ |= 0x00000002;
      y = value;
      return this;
    }

    @Override
    public ProtobufTranslation2d copyFrom(final ProtobufTranslation2d other) {
      cachedSize = other.cachedSize;
      if ((bitField0_ | other.bitField0_) != 0) {
        bitField0_ = other.bitField0_;
        x = other.x;
        y = other.y;
      }
      return this;
    }

    @Override
    public ProtobufTranslation2d mergeFrom(final ProtobufTranslation2d other) {
      if (other.isEmpty()) {
        return this;
      }
      cachedSize = -1;
      if (other.hasX()) {
        setX(other.x);
      }
      if (other.hasY()) {
        setY(other.y);
      }
      return this;
    }

    @Override
    public ProtobufTranslation2d clear() {
      if (isEmpty()) {
        return this;
      }
      cachedSize = -1;
      bitField0_ = 0;
      x = 0D;
      y = 0D;
      return this;
    }

    @Override
    public ProtobufTranslation2d clearQuick() {
      if (isEmpty()) {
        return this;
      }
      cachedSize = -1;
      bitField0_ = 0;
      return this;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (!(o instanceof ProtobufTranslation2d)) {
        return false;
      }
      ProtobufTranslation2d other = (ProtobufTranslation2d) o;
      return bitField0_ == other.bitField0_
        && (!hasX() || ProtoUtil.isEqual(x, other.x))
        && (!hasY() || ProtoUtil.isEqual(y, other.y));
    }

    @Override
    public void writeTo(final ProtoSink output) throws IOException {
      if ((bitField0_ & 0x00000001) != 0) {
        output.writeRawByte((byte) 9);
        output.writeDoubleNoTag(x);
      }
      if ((bitField0_ & 0x00000002) != 0) {
        output.writeRawByte((byte) 17);
        output.writeDoubleNoTag(y);
      }
    }

    @Override
    protected int computeSerializedSize() {
      int size = 0;
      if ((bitField0_ & 0x00000001) != 0) {
        size += 9;
      }
      if ((bitField0_ & 0x00000002) != 0) {
        size += 9;
      }
      return size;
    }

    @Override
    @SuppressWarnings("fallthrough")
    public ProtobufTranslation2d mergeFrom(final ProtoSource input) throws IOException {
      // Enabled Fall-Through Optimization (QuickBuffers)
      int tag = input.readTag();
      while (true) {
        switch (tag) {
          case 9: {
            // x
            x = input.readDouble();
            bitField0_ |= 0x00000001;
            tag = input.readTag();
            if (tag != 17) {
              break;
            }
          }
          case 17: {
            // y
            y = input.readDouble();
            bitField0_ |= 0x00000002;
            tag = input.readTag();
            if (tag != 0) {
              break;
            }
          }
          case 0: {
            return this;
          }
          default: {
            if (!input.skipField(tag)) {
              return this;
            }
            tag = input.readTag();
            break;
          }
        }
      }
    }

    @Override
    public void writeTo(final JsonSink output) throws IOException {
      output.beginObject();
      if ((bitField0_ & 0x00000001) != 0) {
        output.writeDouble(FieldNames.x, x);
      }
      if ((bitField0_ & 0x00000002) != 0) {
        output.writeDouble(FieldNames.y, y);
      }
      output.endObject();
    }

    @Override
    public ProtobufTranslation2d mergeFrom(final JsonSource input) throws IOException {
      if (!input.beginObject()) {
        return this;
      }
      while (!input.isAtEnd()) {
        switch (input.readFieldHash()) {
          case 120: {
            if (input.isAtField(FieldNames.x)) {
              if (!input.trySkipNullValue()) {
                x = input.readDouble();
                bitField0_ |= 0x00000001;
              }
            } else {
              input.skipUnknownField();
            }
            break;
          }
          case 121: {
            if (input.isAtField(FieldNames.y)) {
              if (!input.trySkipNullValue()) {
                y = input.readDouble();
                bitField0_ |= 0x00000002;
              }
            } else {
              input.skipUnknownField();
            }
            break;
          }
          default: {
            input.skipUnknownField();
            break;
          }
        }
      }
      input.endObject();
      return this;
    }

    @Override
    public ProtobufTranslation2d clone() {
      return new ProtobufTranslation2d().copyFrom(this);
    }

    @Override
    public boolean isEmpty() {
      return ((bitField0_) == 0);
    }

    public static ProtobufTranslation2d parseFrom(final byte[] data) throws
        InvalidProtocolBufferException {
      return ProtoMessage.mergeFrom(new ProtobufTranslation2d(), data).checkInitialized();
    }

    public static ProtobufTranslation2d parseFrom(final ProtoSource input) throws IOException {
      return ProtoMessage.mergeFrom(new ProtobufTranslation2d(), input).checkInitialized();
    }

    public static ProtobufTranslation2d parseFrom(final JsonSource input) throws IOException {
      return ProtoMessage.mergeFrom(new ProtobufTranslation2d(), input).checkInitialized();
    }

    /**
     * @return factory for creating ProtobufTranslation2d messages
     */
    public static MessageFactory<ProtobufTranslation2d> getFactory() {
      return ProtobufTranslation2dFactory.INSTANCE;
    }

    /**
     * @return this type's descriptor.
     */
    public static Descriptors.Descriptor getDescriptor() {
      return Geometry2D.wpi_proto_ProtobufTranslation2d_descriptor;
    }

    private enum ProtobufTranslation2dFactory implements MessageFactory<ProtobufTranslation2d> {
      INSTANCE;

      @Override
      public ProtobufTranslation2d create() {
        return ProtobufTranslation2d.newInstance();
      }
    }

    /**
     * Contains name constants used for serializing JSON
     */
    static class FieldNames {
      static final FieldName x = FieldName.forField("x");

      static final FieldName y = FieldName.forField("y");
    }
  }

  /**
   * Protobuf type {@code ProtobufRotation2d}
   */
  public static final class ProtobufRotation2d extends ProtoMessage<ProtobufRotation2d> implements Cloneable {
    private static final long serialVersionUID = 0L;

    /**
     * <code>optional double value = 1;</code>
     */
    private double value_;

    private ProtobufRotation2d() {
    }

    /**
     * @return a new empty instance of {@code ProtobufRotation2d}
     */
    public static ProtobufRotation2d newInstance() {
      return new ProtobufRotation2d();
    }

    /**
     * <code>optional double value = 1;</code>
     * @return whether the value_ field is set
     */
    public boolean hasValue() {
      return (bitField0_ & 0x00000001) != 0;
    }

    /**
     * <code>optional double value = 1;</code>
     * @return this
     */
    public ProtobufRotation2d clearValue() {
      bitField0_ &= ~0x00000001;
      value_ = 0D;
      return this;
    }

    /**
     * <code>optional double value = 1;</code>
     * @return the value_
     */
    public double getValue() {
      return value_;
    }

    /**
     * <code>optional double value = 1;</code>
     * @param value the value_ to set
     * @return this
     */
    public ProtobufRotation2d setValue(final double value) {
      bitField0_ |= 0x00000001;
      value_ = value;
      return this;
    }

    @Override
    public ProtobufRotation2d copyFrom(final ProtobufRotation2d other) {
      cachedSize = other.cachedSize;
      if ((bitField0_ | other.bitField0_) != 0) {
        bitField0_ = other.bitField0_;
        value_ = other.value_;
      }
      return this;
    }

    @Override
    public ProtobufRotation2d mergeFrom(final ProtobufRotation2d other) {
      if (other.isEmpty()) {
        return this;
      }
      cachedSize = -1;
      if (other.hasValue()) {
        setValue(other.value_);
      }
      return this;
    }

    @Override
    public ProtobufRotation2d clear() {
      if (isEmpty()) {
        return this;
      }
      cachedSize = -1;
      bitField0_ = 0;
      value_ = 0D;
      return this;
    }

    @Override
    public ProtobufRotation2d clearQuick() {
      if (isEmpty()) {
        return this;
      }
      cachedSize = -1;
      bitField0_ = 0;
      return this;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (!(o instanceof ProtobufRotation2d)) {
        return false;
      }
      ProtobufRotation2d other = (ProtobufRotation2d) o;
      return bitField0_ == other.bitField0_
        && (!hasValue() || ProtoUtil.isEqual(value_, other.value_));
    }

    @Override
    public void writeTo(final ProtoSink output) throws IOException {
      if ((bitField0_ & 0x00000001) != 0) {
        output.writeRawByte((byte) 9);
        output.writeDoubleNoTag(value_);
      }
    }

    @Override
    protected int computeSerializedSize() {
      int size = 0;
      if ((bitField0_ & 0x00000001) != 0) {
        size += 9;
      }
      return size;
    }

    @Override
    @SuppressWarnings("fallthrough")
    public ProtobufRotation2d mergeFrom(final ProtoSource input) throws IOException {
      // Enabled Fall-Through Optimization (QuickBuffers)
      int tag = input.readTag();
      while (true) {
        switch (tag) {
          case 9: {
            // value_
            value_ = input.readDouble();
            bitField0_ |= 0x00000001;
            tag = input.readTag();
            if (tag != 0) {
              break;
            }
          }
          case 0: {
            return this;
          }
          default: {
            if (!input.skipField(tag)) {
              return this;
            }
            tag = input.readTag();
            break;
          }
        }
      }
    }

    @Override
    public void writeTo(final JsonSink output) throws IOException {
      output.beginObject();
      if ((bitField0_ & 0x00000001) != 0) {
        output.writeDouble(FieldNames.value_, value_);
      }
      output.endObject();
    }

    @Override
    public ProtobufRotation2d mergeFrom(final JsonSource input) throws IOException {
      if (!input.beginObject()) {
        return this;
      }
      while (!input.isAtEnd()) {
        switch (input.readFieldHash()) {
          case 111972721: {
            if (input.isAtField(FieldNames.value_)) {
              if (!input.trySkipNullValue()) {
                value_ = input.readDouble();
                bitField0_ |= 0x00000001;
              }
            } else {
              input.skipUnknownField();
            }
            break;
          }
          default: {
            input.skipUnknownField();
            break;
          }
        }
      }
      input.endObject();
      return this;
    }

    @Override
    public ProtobufRotation2d clone() {
      return new ProtobufRotation2d().copyFrom(this);
    }

    @Override
    public boolean isEmpty() {
      return ((bitField0_) == 0);
    }

    public static ProtobufRotation2d parseFrom(final byte[] data) throws
        InvalidProtocolBufferException {
      return ProtoMessage.mergeFrom(new ProtobufRotation2d(), data).checkInitialized();
    }

    public static ProtobufRotation2d parseFrom(final ProtoSource input) throws IOException {
      return ProtoMessage.mergeFrom(new ProtobufRotation2d(), input).checkInitialized();
    }

    public static ProtobufRotation2d parseFrom(final JsonSource input) throws IOException {
      return ProtoMessage.mergeFrom(new ProtobufRotation2d(), input).checkInitialized();
    }

    /**
     * @return factory for creating ProtobufRotation2d messages
     */
    public static MessageFactory<ProtobufRotation2d> getFactory() {
      return ProtobufRotation2dFactory.INSTANCE;
    }

    /**
     * @return this type's descriptor.
     */
    public static Descriptors.Descriptor getDescriptor() {
      return Geometry2D.wpi_proto_ProtobufRotation2d_descriptor;
    }

    private enum ProtobufRotation2dFactory implements MessageFactory<ProtobufRotation2d> {
      INSTANCE;

      @Override
      public ProtobufRotation2d create() {
        return ProtobufRotation2d.newInstance();
      }
    }

    /**
     * Contains name constants used for serializing JSON
     */
    static class FieldNames {
      static final FieldName value_ = FieldName.forField("value");
    }
  }

  /**
   * Protobuf type {@code ProtobufPose2d}
   */
  public static final class ProtobufPose2d extends ProtoMessage<ProtobufPose2d> implements Cloneable {
    private static final long serialVersionUID = 0L;

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     */
    private final ProtobufTranslation2d translation = ProtobufTranslation2d.newInstance();

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     */
    private final ProtobufRotation2d rotation = ProtobufRotation2d.newInstance();

    private ProtobufPose2d() {
    }

    /**
     * @return a new empty instance of {@code ProtobufPose2d}
     */
    public static ProtobufPose2d newInstance() {
      return new ProtobufPose2d();
    }

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     * @return whether the translation field is set
     */
    public boolean hasTranslation() {
      return (bitField0_ & 0x00000001) != 0;
    }

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     * @return this
     */
    public ProtobufPose2d clearTranslation() {
      bitField0_ &= ~0x00000001;
      translation.clear();
      return this;
    }

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     *
     * This method returns the internal storage object without modifying any has state.
     * The returned object should not be modified and be treated as read-only.
     *
     * Use {@link #getMutableTranslation()} if you want to modify it.
     *
     * @return internal storage object for reading
     */
    public ProtobufTranslation2d getTranslation() {
      return translation;
    }

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     *
     * This method returns the internal storage object and sets the corresponding
     * has state. The returned object will become part of this message and its
     * contents may be modified as long as the has state is not cleared.
     *
     * @return internal storage object for modifications
     */
    public ProtobufTranslation2d getMutableTranslation() {
      bitField0_ |= 0x00000001;
      return translation;
    }

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     * @param value the translation to set
     * @return this
     */
    public ProtobufPose2d setTranslation(final ProtobufTranslation2d value) {
      bitField0_ |= 0x00000001;
      translation.copyFrom(value);
      return this;
    }

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     * @return whether the rotation field is set
     */
    public boolean hasRotation() {
      return (bitField0_ & 0x00000002) != 0;
    }

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     * @return this
     */
    public ProtobufPose2d clearRotation() {
      bitField0_ &= ~0x00000002;
      rotation.clear();
      return this;
    }

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     *
     * This method returns the internal storage object without modifying any has state.
     * The returned object should not be modified and be treated as read-only.
     *
     * Use {@link #getMutableRotation()} if you want to modify it.
     *
     * @return internal storage object for reading
     */
    public ProtobufRotation2d getRotation() {
      return rotation;
    }

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     *
     * This method returns the internal storage object and sets the corresponding
     * has state. The returned object will become part of this message and its
     * contents may be modified as long as the has state is not cleared.
     *
     * @return internal storage object for modifications
     */
    public ProtobufRotation2d getMutableRotation() {
      bitField0_ |= 0x00000002;
      return rotation;
    }

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     * @param value the rotation to set
     * @return this
     */
    public ProtobufPose2d setRotation(final ProtobufRotation2d value) {
      bitField0_ |= 0x00000002;
      rotation.copyFrom(value);
      return this;
    }

    @Override
    public ProtobufPose2d copyFrom(final ProtobufPose2d other) {
      cachedSize = other.cachedSize;
      if ((bitField0_ | other.bitField0_) != 0) {
        bitField0_ = other.bitField0_;
        translation.copyFrom(other.translation);
        rotation.copyFrom(other.rotation);
      }
      return this;
    }

    @Override
    public ProtobufPose2d mergeFrom(final ProtobufPose2d other) {
      if (other.isEmpty()) {
        return this;
      }
      cachedSize = -1;
      if (other.hasTranslation()) {
        getMutableTranslation().mergeFrom(other.translation);
      }
      if (other.hasRotation()) {
        getMutableRotation().mergeFrom(other.rotation);
      }
      return this;
    }

    @Override
    public ProtobufPose2d clear() {
      if (isEmpty()) {
        return this;
      }
      cachedSize = -1;
      bitField0_ = 0;
      translation.clear();
      rotation.clear();
      return this;
    }

    @Override
    public ProtobufPose2d clearQuick() {
      if (isEmpty()) {
        return this;
      }
      cachedSize = -1;
      bitField0_ = 0;
      translation.clearQuick();
      rotation.clearQuick();
      return this;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (!(o instanceof ProtobufPose2d)) {
        return false;
      }
      ProtobufPose2d other = (ProtobufPose2d) o;
      return bitField0_ == other.bitField0_
        && (!hasTranslation() || translation.equals(other.translation))
        && (!hasRotation() || rotation.equals(other.rotation));
    }

    @Override
    public void writeTo(final ProtoSink output) throws IOException {
      if ((bitField0_ & 0x00000001) != 0) {
        output.writeRawByte((byte) 10);
        output.writeMessageNoTag(translation);
      }
      if ((bitField0_ & 0x00000002) != 0) {
        output.writeRawByte((byte) 18);
        output.writeMessageNoTag(rotation);
      }
    }

    @Override
    protected int computeSerializedSize() {
      int size = 0;
      if ((bitField0_ & 0x00000001) != 0) {
        size += 1 + ProtoSink.computeMessageSizeNoTag(translation);
      }
      if ((bitField0_ & 0x00000002) != 0) {
        size += 1 + ProtoSink.computeMessageSizeNoTag(rotation);
      }
      return size;
    }

    @Override
    @SuppressWarnings("fallthrough")
    public ProtobufPose2d mergeFrom(final ProtoSource input) throws IOException {
      // Enabled Fall-Through Optimization (QuickBuffers)
      int tag = input.readTag();
      while (true) {
        switch (tag) {
          case 10: {
            // translation
            input.readMessage(translation);
            bitField0_ |= 0x00000001;
            tag = input.readTag();
            if (tag != 18) {
              break;
            }
          }
          case 18: {
            // rotation
            input.readMessage(rotation);
            bitField0_ |= 0x00000002;
            tag = input.readTag();
            if (tag != 0) {
              break;
            }
          }
          case 0: {
            return this;
          }
          default: {
            if (!input.skipField(tag)) {
              return this;
            }
            tag = input.readTag();
            break;
          }
        }
      }
    }

    @Override
    public void writeTo(final JsonSink output) throws IOException {
      output.beginObject();
      if ((bitField0_ & 0x00000001) != 0) {
        output.writeMessage(FieldNames.translation, translation);
      }
      if ((bitField0_ & 0x00000002) != 0) {
        output.writeMessage(FieldNames.rotation, rotation);
      }
      output.endObject();
    }

    @Override
    public ProtobufPose2d mergeFrom(final JsonSource input) throws IOException {
      if (!input.beginObject()) {
        return this;
      }
      while (!input.isAtEnd()) {
        switch (input.readFieldHash()) {
          case -1840647503: {
            if (input.isAtField(FieldNames.translation)) {
              if (!input.trySkipNullValue()) {
                input.readMessage(translation);
                bitField0_ |= 0x00000001;
              }
            } else {
              input.skipUnknownField();
            }
            break;
          }
          case -40300674: {
            if (input.isAtField(FieldNames.rotation)) {
              if (!input.trySkipNullValue()) {
                input.readMessage(rotation);
                bitField0_ |= 0x00000002;
              }
            } else {
              input.skipUnknownField();
            }
            break;
          }
          default: {
            input.skipUnknownField();
            break;
          }
        }
      }
      input.endObject();
      return this;
    }

    @Override
    public ProtobufPose2d clone() {
      return new ProtobufPose2d().copyFrom(this);
    }

    @Override
    public boolean isEmpty() {
      return ((bitField0_) == 0);
    }

    public static ProtobufPose2d parseFrom(final byte[] data) throws
        InvalidProtocolBufferException {
      return ProtoMessage.mergeFrom(new ProtobufPose2d(), data).checkInitialized();
    }

    public static ProtobufPose2d parseFrom(final ProtoSource input) throws IOException {
      return ProtoMessage.mergeFrom(new ProtobufPose2d(), input).checkInitialized();
    }

    public static ProtobufPose2d parseFrom(final JsonSource input) throws IOException {
      return ProtoMessage.mergeFrom(new ProtobufPose2d(), input).checkInitialized();
    }

    /**
     * @return factory for creating ProtobufPose2d messages
     */
    public static MessageFactory<ProtobufPose2d> getFactory() {
      return ProtobufPose2dFactory.INSTANCE;
    }

    /**
     * @return this type's descriptor.
     */
    public static Descriptors.Descriptor getDescriptor() {
      return Geometry2D.wpi_proto_ProtobufPose2d_descriptor;
    }

    private enum ProtobufPose2dFactory implements MessageFactory<ProtobufPose2d> {
      INSTANCE;

      @Override
      public ProtobufPose2d create() {
        return ProtobufPose2d.newInstance();
      }
    }

    /**
     * Contains name constants used for serializing JSON
     */
    static class FieldNames {
      static final FieldName translation = FieldName.forField("translation");

      static final FieldName rotation = FieldName.forField("rotation");
    }
  }

  /**
   * Protobuf type {@code ProtobufTransform2d}
   */
  public static final class ProtobufTransform2d extends ProtoMessage<ProtobufTransform2d> implements Cloneable {
    private static final long serialVersionUID = 0L;

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     */
    private final ProtobufTranslation2d translation = ProtobufTranslation2d.newInstance();

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     */
    private final ProtobufRotation2d rotation = ProtobufRotation2d.newInstance();

    private ProtobufTransform2d() {
    }

    /**
     * @return a new empty instance of {@code ProtobufTransform2d}
     */
    public static ProtobufTransform2d newInstance() {
      return new ProtobufTransform2d();
    }

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     * @return whether the translation field is set
     */
    public boolean hasTranslation() {
      return (bitField0_ & 0x00000001) != 0;
    }

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     * @return this
     */
    public ProtobufTransform2d clearTranslation() {
      bitField0_ &= ~0x00000001;
      translation.clear();
      return this;
    }

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     *
     * This method returns the internal storage object without modifying any has state.
     * The returned object should not be modified and be treated as read-only.
     *
     * Use {@link #getMutableTranslation()} if you want to modify it.
     *
     * @return internal storage object for reading
     */
    public ProtobufTranslation2d getTranslation() {
      return translation;
    }

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     *
     * This method returns the internal storage object and sets the corresponding
     * has state. The returned object will become part of this message and its
     * contents may be modified as long as the has state is not cleared.
     *
     * @return internal storage object for modifications
     */
    public ProtobufTranslation2d getMutableTranslation() {
      bitField0_ |= 0x00000001;
      return translation;
    }

    /**
     * <code>optional .wpi.proto.ProtobufTranslation2d translation = 1;</code>
     * @param value the translation to set
     * @return this
     */
    public ProtobufTransform2d setTranslation(final ProtobufTranslation2d value) {
      bitField0_ |= 0x00000001;
      translation.copyFrom(value);
      return this;
    }

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     * @return whether the rotation field is set
     */
    public boolean hasRotation() {
      return (bitField0_ & 0x00000002) != 0;
    }

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     * @return this
     */
    public ProtobufTransform2d clearRotation() {
      bitField0_ &= ~0x00000002;
      rotation.clear();
      return this;
    }

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     *
     * This method returns the internal storage object without modifying any has state.
     * The returned object should not be modified and be treated as read-only.
     *
     * Use {@link #getMutableRotation()} if you want to modify it.
     *
     * @return internal storage object for reading
     */
    public ProtobufRotation2d getRotation() {
      return rotation;
    }

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     *
     * This method returns the internal storage object and sets the corresponding
     * has state. The returned object will become part of this message and its
     * contents may be modified as long as the has state is not cleared.
     *
     * @return internal storage object for modifications
     */
    public ProtobufRotation2d getMutableRotation() {
      bitField0_ |= 0x00000002;
      return rotation;
    }

    /**
     * <code>optional .wpi.proto.ProtobufRotation2d rotation = 2;</code>
     * @param value the rotation to set
     * @return this
     */
    public ProtobufTransform2d setRotation(final ProtobufRotation2d value) {
      bitField0_ |= 0x00000002;
      rotation.copyFrom(value);
      return this;
    }

    @Override
    public ProtobufTransform2d copyFrom(final ProtobufTransform2d other) {
      cachedSize = other.cachedSize;
      if ((bitField0_ | other.bitField0_) != 0) {
        bitField0_ = other.bitField0_;
        translation.copyFrom(other.translation);
        rotation.copyFrom(other.rotation);
      }
      return this;
    }

    @Override
    public ProtobufTransform2d mergeFrom(final ProtobufTransform2d other) {
      if (other.isEmpty()) {
        return this;
      }
      cachedSize = -1;
      if (other.hasTranslation()) {
        getMutableTranslation().mergeFrom(other.translation);
      }
      if (other.hasRotation()) {
        getMutableRotation().mergeFrom(other.rotation);
      }
      return this;
    }

    @Override
    public ProtobufTransform2d clear() {
      if (isEmpty()) {
        return this;
      }
      cachedSize = -1;
      bitField0_ = 0;
      translation.clear();
      rotation.clear();
      return this;
    }

    @Override
    public ProtobufTransform2d clearQuick() {
      if (isEmpty()) {
        return this;
      }
      cachedSize = -1;
      bitField0_ = 0;
      translation.clearQuick();
      rotation.clearQuick();
      return this;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (!(o instanceof ProtobufTransform2d)) {
        return false;
      }
      ProtobufTransform2d other = (ProtobufTransform2d) o;
      return bitField0_ == other.bitField0_
        && (!hasTranslation() || translation.equals(other.translation))
        && (!hasRotation() || rotation.equals(other.rotation));
    }

    @Override
    public void writeTo(final ProtoSink output) throws IOException {
      if ((bitField0_ & 0x00000001) != 0) {
        output.writeRawByte((byte) 10);
        output.writeMessageNoTag(translation);
      }
      if ((bitField0_ & 0x00000002) != 0) {
        output.writeRawByte((byte) 18);
        output.writeMessageNoTag(rotation);
      }
    }

    @Override
    protected int computeSerializedSize() {
      int size = 0;
      if ((bitField0_ & 0x00000001) != 0) {
        size += 1 + ProtoSink.computeMessageSizeNoTag(translation);
      }
      if ((bitField0_ & 0x00000002) != 0) {
        size += 1 + ProtoSink.computeMessageSizeNoTag(rotation);
      }
      return size;
    }

    @Override
    @SuppressWarnings("fallthrough")
    public ProtobufTransform2d mergeFrom(final ProtoSource input) throws IOException {
      // Enabled Fall-Through Optimization (QuickBuffers)
      int tag = input.readTag();
      while (true) {
        switch (tag) {
          case 10: {
            // translation
            input.readMessage(translation);
            bitField0_ |= 0x00000001;
            tag = input.readTag();
            if (tag != 18) {
              break;
            }
          }
          case 18: {
            // rotation
            input.readMessage(rotation);
            bitField0_ |= 0x00000002;
            tag = input.readTag();
            if (tag != 0) {
              break;
            }
          }
          case 0: {
            return this;
          }
          default: {
            if (!input.skipField(tag)) {
              return this;
            }
            tag = input.readTag();
            break;
          }
        }
      }
    }

    @Override
    public void writeTo(final JsonSink output) throws IOException {
      output.beginObject();
      if ((bitField0_ & 0x00000001) != 0) {
        output.writeMessage(FieldNames.translation, translation);
      }
      if ((bitField0_ & 0x00000002) != 0) {
        output.writeMessage(FieldNames.rotation, rotation);
      }
      output.endObject();
    }

    @Override
    public ProtobufTransform2d mergeFrom(final JsonSource input) throws IOException {
      if (!input.beginObject()) {
        return this;
      }
      while (!input.isAtEnd()) {
        switch (input.readFieldHash()) {
          case -1840647503: {
            if (input.isAtField(FieldNames.translation)) {
              if (!input.trySkipNullValue()) {
                input.readMessage(translation);
                bitField0_ |= 0x00000001;
              }
            } else {
              input.skipUnknownField();
            }
            break;
          }
          case -40300674: {
            if (input.isAtField(FieldNames.rotation)) {
              if (!input.trySkipNullValue()) {
                input.readMessage(rotation);
                bitField0_ |= 0x00000002;
              }
            } else {
              input.skipUnknownField();
            }
            break;
          }
          default: {
            input.skipUnknownField();
            break;
          }
        }
      }
      input.endObject();
      return this;
    }

    @Override
    public ProtobufTransform2d clone() {
      return new ProtobufTransform2d().copyFrom(this);
    }

    @Override
    public boolean isEmpty() {
      return ((bitField0_) == 0);
    }

    public static ProtobufTransform2d parseFrom(final byte[] data) throws
        InvalidProtocolBufferException {
      return ProtoMessage.mergeFrom(new ProtobufTransform2d(), data).checkInitialized();
    }

    public static ProtobufTransform2d parseFrom(final ProtoSource input) throws IOException {
      return ProtoMessage.mergeFrom(new ProtobufTransform2d(), input).checkInitialized();
    }

    public static ProtobufTransform2d parseFrom(final JsonSource input) throws IOException {
      return ProtoMessage.mergeFrom(new ProtobufTransform2d(), input).checkInitialized();
    }

    /**
     * @return factory for creating ProtobufTransform2d messages
     */
    public static MessageFactory<ProtobufTransform2d> getFactory() {
      return ProtobufTransform2dFactory.INSTANCE;
    }

    /**
     * @return this type's descriptor.
     */
    public static Descriptors.Descriptor getDescriptor() {
      return Geometry2D.wpi_proto_ProtobufTransform2d_descriptor;
    }

    private enum ProtobufTransform2dFactory implements MessageFactory<ProtobufTransform2d> {
      INSTANCE;

      @Override
      public ProtobufTransform2d create() {
        return ProtobufTransform2d.newInstance();
      }
    }

    /**
     * Contains name constants used for serializing JSON
     */
    static class FieldNames {
      static final FieldName translation = FieldName.forField("translation");

      static final FieldName rotation = FieldName.forField("rotation");
    }
  }

  /**
   * Protobuf type {@code ProtobufTwist2d}
   */
  public static final class ProtobufTwist2d extends ProtoMessage<ProtobufTwist2d> implements Cloneable {
    private static final long serialVersionUID = 0L;

    /**
     * <code>optional double dx = 1;</code>
     */
    private double dx;

    /**
     * <code>optional double dy = 2;</code>
     */
    private double dy;

    /**
     * <code>optional double dtheta = 3;</code>
     */
    private double dtheta;

    private ProtobufTwist2d() {
    }

    /**
     * @return a new empty instance of {@code ProtobufTwist2d}
     */
    public static ProtobufTwist2d newInstance() {
      return new ProtobufTwist2d();
    }

    /**
     * <code>optional double dx = 1;</code>
     * @return whether the dx field is set
     */
    public boolean hasDx() {
      return (bitField0_ & 0x00000001) != 0;
    }

    /**
     * <code>optional double dx = 1;</code>
     * @return this
     */
    public ProtobufTwist2d clearDx() {
      bitField0_ &= ~0x00000001;
      dx = 0D;
      return this;
    }

    /**
     * <code>optional double dx = 1;</code>
     * @return the dx
     */
    public double getDx() {
      return dx;
    }

    /**
     * <code>optional double dx = 1;</code>
     * @param value the dx to set
     * @return this
     */
    public ProtobufTwist2d setDx(final double value) {
      bitField0_ |= 0x00000001;
      dx = value;
      return this;
    }

    /**
     * <code>optional double dy = 2;</code>
     * @return whether the dy field is set
     */
    public boolean hasDy() {
      return (bitField0_ & 0x00000002) != 0;
    }

    /**
     * <code>optional double dy = 2;</code>
     * @return this
     */
    public ProtobufTwist2d clearDy() {
      bitField0_ &= ~0x00000002;
      dy = 0D;
      return this;
    }

    /**
     * <code>optional double dy = 2;</code>
     * @return the dy
     */
    public double getDy() {
      return dy;
    }

    /**
     * <code>optional double dy = 2;</code>
     * @param value the dy to set
     * @return this
     */
    public ProtobufTwist2d setDy(final double value) {
      bitField0_ |= 0x00000002;
      dy = value;
      return this;
    }

    /**
     * <code>optional double dtheta = 3;</code>
     * @return whether the dtheta field is set
     */
    public boolean hasDtheta() {
      return (bitField0_ & 0x00000004) != 0;
    }

    /**
     * <code>optional double dtheta = 3;</code>
     * @return this
     */
    public ProtobufTwist2d clearDtheta() {
      bitField0_ &= ~0x00000004;
      dtheta = 0D;
      return this;
    }

    /**
     * <code>optional double dtheta = 3;</code>
     * @return the dtheta
     */
    public double getDtheta() {
      return dtheta;
    }

    /**
     * <code>optional double dtheta = 3;</code>
     * @param value the dtheta to set
     * @return this
     */
    public ProtobufTwist2d setDtheta(final double value) {
      bitField0_ |= 0x00000004;
      dtheta = value;
      return this;
    }

    @Override
    public ProtobufTwist2d copyFrom(final ProtobufTwist2d other) {
      cachedSize = other.cachedSize;
      if ((bitField0_ | other.bitField0_) != 0) {
        bitField0_ = other.bitField0_;
        dx = other.dx;
        dy = other.dy;
        dtheta = other.dtheta;
      }
      return this;
    }

    @Override
    public ProtobufTwist2d mergeFrom(final ProtobufTwist2d other) {
      if (other.isEmpty()) {
        return this;
      }
      cachedSize = -1;
      if (other.hasDx()) {
        setDx(other.dx);
      }
      if (other.hasDy()) {
        setDy(other.dy);
      }
      if (other.hasDtheta()) {
        setDtheta(other.dtheta);
      }
      return this;
    }

    @Override
    public ProtobufTwist2d clear() {
      if (isEmpty()) {
        return this;
      }
      cachedSize = -1;
      bitField0_ = 0;
      dx = 0D;
      dy = 0D;
      dtheta = 0D;
      return this;
    }

    @Override
    public ProtobufTwist2d clearQuick() {
      if (isEmpty()) {
        return this;
      }
      cachedSize = -1;
      bitField0_ = 0;
      return this;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (!(o instanceof ProtobufTwist2d)) {
        return false;
      }
      ProtobufTwist2d other = (ProtobufTwist2d) o;
      return bitField0_ == other.bitField0_
        && (!hasDx() || ProtoUtil.isEqual(dx, other.dx))
        && (!hasDy() || ProtoUtil.isEqual(dy, other.dy))
        && (!hasDtheta() || ProtoUtil.isEqual(dtheta, other.dtheta));
    }

    @Override
    public void writeTo(final ProtoSink output) throws IOException {
      if ((bitField0_ & 0x00000001) != 0) {
        output.writeRawByte((byte) 9);
        output.writeDoubleNoTag(dx);
      }
      if ((bitField0_ & 0x00000002) != 0) {
        output.writeRawByte((byte) 17);
        output.writeDoubleNoTag(dy);
      }
      if ((bitField0_ & 0x00000004) != 0) {
        output.writeRawByte((byte) 25);
        output.writeDoubleNoTag(dtheta);
      }
    }

    @Override
    protected int computeSerializedSize() {
      int size = 0;
      if ((bitField0_ & 0x00000001) != 0) {
        size += 9;
      }
      if ((bitField0_ & 0x00000002) != 0) {
        size += 9;
      }
      if ((bitField0_ & 0x00000004) != 0) {
        size += 9;
      }
      return size;
    }

    @Override
    @SuppressWarnings("fallthrough")
    public ProtobufTwist2d mergeFrom(final ProtoSource input) throws IOException {
      // Enabled Fall-Through Optimization (QuickBuffers)
      int tag = input.readTag();
      while (true) {
        switch (tag) {
          case 9: {
            // dx
            dx = input.readDouble();
            bitField0_ |= 0x00000001;
            tag = input.readTag();
            if (tag != 17) {
              break;
            }
          }
          case 17: {
            // dy
            dy = input.readDouble();
            bitField0_ |= 0x00000002;
            tag = input.readTag();
            if (tag != 25) {
              break;
            }
          }
          case 25: {
            // dtheta
            dtheta = input.readDouble();
            bitField0_ |= 0x00000004;
            tag = input.readTag();
            if (tag != 0) {
              break;
            }
          }
          case 0: {
            return this;
          }
          default: {
            if (!input.skipField(tag)) {
              return this;
            }
            tag = input.readTag();
            break;
          }
        }
      }
    }

    @Override
    public void writeTo(final JsonSink output) throws IOException {
      output.beginObject();
      if ((bitField0_ & 0x00000001) != 0) {
        output.writeDouble(FieldNames.dx, dx);
      }
      if ((bitField0_ & 0x00000002) != 0) {
        output.writeDouble(FieldNames.dy, dy);
      }
      if ((bitField0_ & 0x00000004) != 0) {
        output.writeDouble(FieldNames.dtheta, dtheta);
      }
      output.endObject();
    }

    @Override
    public ProtobufTwist2d mergeFrom(final JsonSource input) throws IOException {
      if (!input.beginObject()) {
        return this;
      }
      while (!input.isAtEnd()) {
        switch (input.readFieldHash()) {
          case 3220: {
            if (input.isAtField(FieldNames.dx)) {
              if (!input.trySkipNullValue()) {
                dx = input.readDouble();
                bitField0_ |= 0x00000001;
              }
            } else {
              input.skipUnknownField();
            }
            break;
          }
          case 3221: {
            if (input.isAtField(FieldNames.dy)) {
              if (!input.trySkipNullValue()) {
                dy = input.readDouble();
                bitField0_ |= 0x00000002;
              }
            } else {
              input.skipUnknownField();
            }
            break;
          }
          case -1321724742: {
            if (input.isAtField(FieldNames.dtheta)) {
              if (!input.trySkipNullValue()) {
                dtheta = input.readDouble();
                bitField0_ |= 0x00000004;
              }
            } else {
              input.skipUnknownField();
            }
            break;
          }
          default: {
            input.skipUnknownField();
            break;
          }
        }
      }
      input.endObject();
      return this;
    }

    @Override
    public ProtobufTwist2d clone() {
      return new ProtobufTwist2d().copyFrom(this);
    }

    @Override
    public boolean isEmpty() {
      return ((bitField0_) == 0);
    }

    public static ProtobufTwist2d parseFrom(final byte[] data) throws
        InvalidProtocolBufferException {
      return ProtoMessage.mergeFrom(new ProtobufTwist2d(), data).checkInitialized();
    }

    public static ProtobufTwist2d parseFrom(final ProtoSource input) throws IOException {
      return ProtoMessage.mergeFrom(new ProtobufTwist2d(), input).checkInitialized();
    }

    public static ProtobufTwist2d parseFrom(final JsonSource input) throws IOException {
      return ProtoMessage.mergeFrom(new ProtobufTwist2d(), input).checkInitialized();
    }

    /**
     * @return factory for creating ProtobufTwist2d messages
     */
    public static MessageFactory<ProtobufTwist2d> getFactory() {
      return ProtobufTwist2dFactory.INSTANCE;
    }

    /**
     * @return this type's descriptor.
     */
    public static Descriptors.Descriptor getDescriptor() {
      return Geometry2D.wpi_proto_ProtobufTwist2d_descriptor;
    }

    private enum ProtobufTwist2dFactory implements MessageFactory<ProtobufTwist2d> {
      INSTANCE;

      @Override
      public ProtobufTwist2d create() {
        return ProtobufTwist2d.newInstance();
      }
    }

    /**
     * Contains name constants used for serializing JSON
     */
    static class FieldNames {
      static final FieldName dx = FieldName.forField("dx");

      static final FieldName dy = FieldName.forField("dy");

      static final FieldName dtheta = FieldName.forField("dtheta");
    }
  }
}
