// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

// THIS FILE WAS AUTO-GENERATED BY ./ntcore/generate_topics.py. DO NOT MODIFY

#pragma once

#include <vector>

#include "networktables/DoubleArrayTopic.h"
#include "networktables/NetworkTableType.h"
#include "ntcore_cpp.h"

namespace nt {

inline DoubleArraySubscriber::DoubleArraySubscriber(
    NT_Subscriber handle, std::span<const double> defaultValue)
    : Subscriber{handle},
      m_defaultValue{defaultValue.begin(), defaultValue.end()} {}

inline std::vector<double> DoubleArraySubscriber::Get() const {
  return Get(m_defaultValue);
}

inline std::vector<double> DoubleArraySubscriber::Get(
    std::span<const double> defaultValue) const {
  return ::nt::GetDoubleArray(m_subHandle, defaultValue);
}

inline std::span<double> DoubleArraySubscriber::Get(wpi::SmallVectorImpl<double>& buf) const {
  return Get(buf, m_defaultValue);
}

inline std::span<double> DoubleArraySubscriber::Get(wpi::SmallVectorImpl<double>& buf, std::span<const double> defaultValue) const {
  return nt::GetDoubleArray(m_subHandle, buf, defaultValue);
}

inline TimestampedDoubleArray DoubleArraySubscriber::GetAtomic() const {
  return GetAtomic(m_defaultValue);
}

inline TimestampedDoubleArray DoubleArraySubscriber::GetAtomic(
    std::span<const double> defaultValue) const {
  return ::nt::GetAtomicDoubleArray(m_subHandle, defaultValue);
}

inline TimestampedDoubleArrayView DoubleArraySubscriber::GetAtomic(wpi::SmallVectorImpl<double>& buf) const {
  return GetAtomic(buf, m_defaultValue);
}

inline TimestampedDoubleArrayView DoubleArraySubscriber::GetAtomic(wpi::SmallVectorImpl<double>& buf, std::span<const double> defaultValue) const {
  return nt::GetAtomicDoubleArray(m_subHandle, buf, defaultValue);
}

inline std::vector<TimestampedDoubleArray>
DoubleArraySubscriber::ReadQueue() {
  return ::nt::ReadQueueDoubleArray(m_subHandle);
}

inline DoubleArrayTopic DoubleArraySubscriber::GetTopic() const {
  return DoubleArrayTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline DoubleArrayPublisher::DoubleArrayPublisher(NT_Publisher handle)
    : Publisher{handle} {}

inline void DoubleArrayPublisher::Set(std::span<const double> value,
                                         int64_t time) {
  ::nt::SetDoubleArray(m_pubHandle, value, time);
}

inline void DoubleArrayPublisher::SetDefault(std::span<const double> value) {
  ::nt::SetDefaultDoubleArray(m_pubHandle, value);
}

inline DoubleArrayTopic DoubleArrayPublisher::GetTopic() const {
  return DoubleArrayTopic{::nt::GetTopicFromHandle(m_pubHandle)};
}

inline DoubleArrayEntry::DoubleArrayEntry(
    NT_Entry handle, std::span<const double> defaultValue)
    : DoubleArraySubscriber{handle, defaultValue},
      DoubleArrayPublisher{handle} {}

inline DoubleArrayTopic DoubleArrayEntry::GetTopic() const {
  return DoubleArrayTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline void DoubleArrayEntry::Unpublish() {
  ::nt::Unpublish(m_pubHandle);
}

inline DoubleArraySubscriber DoubleArrayTopic::Subscribe(
    std::span<const double> defaultValue,
    const PubSubOptions& options) {
  return DoubleArraySubscriber{
      ::nt::Subscribe(m_handle, NT_DOUBLE_ARRAY, "double[]", options),
      defaultValue};
}
inline DoubleArraySubscriber DoubleArrayTopic::SubscribeEx(
    std::string_view typeString, std::span<const double> defaultValue,
    const PubSubOptions& options) {
  return DoubleArraySubscriber{
      ::nt::Subscribe(m_handle, NT_DOUBLE_ARRAY, typeString, options),
      defaultValue};
}

inline DoubleArrayPublisher DoubleArrayTopic::Publish(
    const PubSubOptions& options) {
  return DoubleArrayPublisher{
      ::nt::Publish(m_handle, NT_DOUBLE_ARRAY, "double[]", options)};
}

inline DoubleArrayPublisher DoubleArrayTopic::PublishEx(
    std::string_view typeString,
    const wpi::json& properties, const PubSubOptions& options) {
  return DoubleArrayPublisher{
      ::nt::PublishEx(m_handle, NT_DOUBLE_ARRAY, typeString, properties, options)};
}

inline DoubleArrayEntry DoubleArrayTopic::GetEntry(
    std::span<const double> defaultValue,
    const PubSubOptions& options) {
  return DoubleArrayEntry{
      ::nt::GetEntry(m_handle, NT_DOUBLE_ARRAY, "double[]", options),
      defaultValue};
}
inline DoubleArrayEntry DoubleArrayTopic::GetEntryEx(
    std::string_view typeString, std::span<const double> defaultValue,
    const PubSubOptions& options) {
  return DoubleArrayEntry{
      ::nt::GetEntry(m_handle, NT_DOUBLE_ARRAY, typeString, options),
      defaultValue};
}

}  // namespace nt
