/*----------------------------------------------------------------------------*/
/* Copyright (c) FIRST 2008. All Rights Reserved.							  */
/* Open Source Software - may be modified and shared by FRC teams. The code   */
/* must be accompanied by the FIRST BSD license file in $(WIND_BASE)/WPILib.  */
/*----------------------------------------------------------------------------*/

#ifndef __MOTOR_SAFETY_HELPER__
#define __MOTOR_SAFETY_HELPER__

#include "ErrorBase.h"
#include "Synchronized.h"
#include <semLib.h>

class MotorSafety;

class MotorSafetyHelper : public ErrorBase
{
public:
	MotorSafetyHelper(MotorSafety *safeObject);
	~MotorSafetyHelper();
	void Feed();
	void SetExpiration(float expirationTime);
	float GetExpiration();
	bool IsAlive();
	void Check();
	void SetSafetyEnabled(bool enabled);
	bool IsSafetyEnabled();
	static void CheckMotors();
private:
	double m_expiration;			// the expiration time for this object
	bool m_enabled;					// true if motor safety is enabled for this motor
	double m_stopTime; 				// the FPGA clock value when this motor has expired
	MotorSafety *m_safeObject;		// the object that is using the helper
	MotorSafetyHelper *m_nextHelper; // next object in the list of MotorSafetyHelpers
	static MotorSafetyHelper *m_headHelper; // the head of the list of MotorSafetyHelper objects
	static Semaphore m_listMutex; // protect accesses to the list of helpers
	Semaphore m_syncMutex;        // protect accesses to the state for this object
};

#endif
