require_relative 'load.rb'

require 'fileutils'

TypeNames = [8, 16, 32, 64].collect do |size|
  ["uint#{size}_t", "int#{size}_t"]
end.flatten + ['bool', 'float', 'char', 'double', '::aos::monotonic_clock::time_point']

FileUtils.mkdir_p(File.dirname(ARGV[0]))
WriteIffChanged.open(ARGV[0]) do |output|
  output.puts <<END
// This file is generated by #{File.expand_path(__FILE__)}.
// DO NOT EDIT BY HAND!

#include <stdint.h>

#include "aos/time/time.h"

namespace aos {
namespace queue_primitive_types {
#{TypeNames.collect do |name|
  message_element = Target::MessageElement.new(name, 'value')
  statement = MessageElementStmt.new(name, 'value')
  message_element.size = statement.size
  name = 'Time' if name == '::aos::monotonic_clock::time_point'
  next <<END2
  static const uint32_t #{name}_p = #{message_element.getTypeID()};
END2
end.join('')}
}  // namespace queue_primitive_types

// A class for mapping an actual type to a type ID.
// There are specializations for all of the actual primitive types.
template<typename T>
class TypeID {
 public:
  static const uint32_t id;
};

#{TypeNames.collect do |name|
  message_element = Target::MessageElement.new(name, 'value')
  statement = MessageElementStmt.new(name, 'value')
  message_element.size = statement.size
  next <<END2
template<>
class TypeID< #{name}> {
 public:
  static const uint32_t id = #{message_element.getTypeID()};
};
END2
end.join('')}
}  // namespace aos
END
end
