
(*

<</twj/og/part2/chap6/proj.m

Off[ General::spell1]

  rmax = {xmax, ymax, zmax};
  rmin = {xmin, ymin, zmin};
  box  = {xrat, yrat, zrat};

  vp = {1.3, -2.4, 2.};
  vc = {1/2, 1/2, 1/2};
  rmax = {2.05, 2.05, 4.1};
  rmin = {-0.05, -0.05, -0.1};
  box = {2.1, 2.1, 4.2};

plrng = {{-10, 1}, {0,10}, {-1,1}};

box = {1,2,3};

vp = {2,2,2};

p m1[0][0]@4
p m1[1][0]@4
p m1[2][0]@4
p m1[3][0]@4
p v->m[0][0]@4
p v->m[1][0]@4
p v->m[2][0]@4
p v->m[3][0]@4

Show[ Graphics3D[ Point[ {0,0,0}]], 
	ViewPoint -> {2,2,2},
	BoxRatios -> {1,2,3},
	PlotRange -> {{-10, 1}, {0,10}, {-1,1}}]

Plot3Matrix[ %]
*)

Unprotect[ Plot3Matrix]

(*
	Plot3Matrix takes a viewpoint,  a plotrange and a boxratios.
	It returns a transformation matrix which corresponds to that projection.
*)


ProjectVector[ {x_, y_, z_}, mat_] :=
    Block[{tmp},
	tmp = mat.{x, y, z, 1} ;
	Drop[ tmp, -2] / Last[ tmp]
	]

Plot3Matrix[ g_Graphics3D | g_SurfaceGraphics] :=
    Block[{vp, vc, vv, prng, boxrat, opt},
    	opt = FullOptions[ g] ;
	{vp, vc, vv, prng, boxrat} = 
	    {ViewPoint, ViewCenter, ViewVertical, PlotRange, BoxRatios}/. opt;
	MatrixCalculate[ vp, vc, vv, prng, boxrat]
	]

MatrixCalculate[ vp_,  vc_, vv_, prng_, boxrat_] :=
    Block[{mat1, mat2, mat3, ctr, tmp, rmax, rmin, sfact},
	{rmin, rmax} = N[Transpose[ prng]] ;
				(* min and max user coords of box *)
	ctr = (rmax + rmin)/2. ;
				(* center of box *)
	mat1 = TransMatrix[ -ctr] ;
				(* origin at center of box *)
	tmp = N[boxrat/(rmax-rmin)/Max[boxrat]] ;
				(* Scale user coords to boxratios *)
	mat2 = ScaleMatrix[ tmp] ;
				(* Scale matrix for boxratios *)
	mat3 = TransMatrix[ -vp] ;
				(* translate to put viewpoint at origin *)
	mat1 = mat3 . mat2 . mat1 ;
				(* put all together *)
	mat2 = CalculateRotate[ -vp] ;
				(* rotate to look along -z and up correct *)
	mat3 = DiagonalMatrix[ {1,1,-1,1}] ;
				(* reflect so project along +z *)
	mat1 = mat3. mat2 . mat1 ;
	sfact = ScaleBox[ mat1, prng] ;	
				(* Get the scale factor *)
	mat1 = ProjMatrix[ 0.5] . mat1 ;	
	ctr = HMatrixTimesVector[ mat1, ctr] ;
				(* ctr is now box center imager *)
	mat1 = FinalMatrix[ sfact, ctr].mat1 ;
                        	(* move ctr to center and scale *)
	mat1
	]



FinalMatrix[ s_, ctr_] :=
	Module[{m1, m2},
		m1 = TransMatrix[-ctr] {s,s,s,1} ;		(* move ctr to origin *)
		TransMatrix[ {0.5, 0.5, 0.0}].m1  (* T to mid screen*)	
	]



ProjMatrix[ z_] :=
    ( t = 1/(1-z);
      Join[
        Map[ Join[ #, {0,0}]&, IdentityMatrix[ 2]],
	Map[ Join[ {0,0}, #]&, {{t, -z t}, {1, 0}}]]
    )


ScaleBox[ mat_, {xb_, yb_, zb_}] :=
	Module[{pts, tvc},
		pts = Flatten[ Outer[ List, xb, yb, zb], 2] ;
				(* coordinates of box corners *)
		pts = Map[ HMatrixTimesVector[mat, #]&, pts] ;
				(* apply box transform to corners *)
		pts = Map[ ProjectCrude, pts] ; 	
				(* crude project box corners *)
		pts = Abs[ pts] ;
				(* get abs distance *)
		1/ (2 * Max[pts])
				(* scale is half of 1/max *)
	]


ProjectCrude[ vec_] := Drop[ vec, {-1}] / Last[ vec]

	


(*
  Take a vector and return a homogeneous matrix to make it point the
  -z axis with the projection of the original z-axis in +y.
*)

CalculateRotate[ vec_] :=
	Block[{ proj, norm, mat1, mat2},
		proj = N[ Drop[ vec, -1]] ;
			(* xy projection of vec *)
		norm = Sqrt[ proj.proj] ;
			(* length of proj *)
		mat1 = If[ norm == 0,
				IdentityMatrix[ 4],
				RotateMatrixZ[ Reverse[ proj/norm]]] ;
			(* Rotate around z axis to make proj along +y *)
		proj = HMatrixTimesVector[ mat1, vec] ;
			(* Rotate vector around z-axis *)
		proj = Rest[ proj] ;
			(* yz projection of vector *)
		norm = Sqrt[ proj.proj] ;
			(* length of proj *)
		mat2 = If[ norm == 0,
				IdentityMatrix[ 4],
				proj = -Reverse[ proj/norm] ;
				RotateMatrixX[ proj]] ;
			(* Rotate around x axis to make proj along -z *)
		mat2 . mat1
	]


HMatrixTimesVector[ m_, h_] :=
	Block[{ tmp},
		tmp = m . Append[ h, 1] ;
		Drop[ tmp / tmp[[4]] , -1]
	]
	
TransMatrix[ d_] :=
        Transpose[ ReplacePart[ IdentityMatrix[ 4], Append[ d, 1], 4]]

ScaleMatrix[ s_] := 
	DiagonalMatrix[ Append[ s, 1]]

RotateMatrixZ[ {ct_, st_}] :=
     {{ct, -st, 0, 0}, {st, ct, 0, 0}, {0,0,1,0}, {0,0,0,1}}

RotateMatrixX[ {ct_, st_}] :=
     {{1, 0, 0, 0}, {0, ct, -st, 0}, {0,st,ct,0}, {0,0,0,1}}


