/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpijavacv;

import com.googlecode.javacpp.Pointer;

public abstract class WPIDisposable {
    private boolean disposed = false;

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.disposed();
        }
    }

    protected abstract void disposed();

    public boolean isDisposed() {
        return this.disposed;
    }

    protected void validateDisposed() {
        if (this.disposed) {
            throw new DisposedException(this + " has been disposed");
        }
    }

    protected void validateDisposed(String message) {
        if (this.disposed) {
            throw new DisposedException(message);
        }
    }

    protected static boolean isNull(Pointer pointer) {
        return pointer == null || pointer.isNull();
    }

    protected static void free(Pointer pointer) {
        if (pointer != null && !pointer.isNull()) {
            pointer.deallocate();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public static class DisposedException
    extends RuntimeException {
        public DisposedException(String message) {
            super(message);
        }
    }
}

