/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import com.googlecode.javacv.cpp.videoInputLib;

public class VideoInputFrameGrabber
extends FrameGrabber {
    private static Exception loadingException = null;
    private int deviceNumber = 0;
    private videoInputLib.videoInput myVideoInput = null;
    private opencv_core.IplImage bgrImage = null;
    private opencv_core.IplImage grayImage = null;
    private BytePointer bgrImageData = null;

    public static String[] getDeviceDescriptions() throws Exception {
        VideoInputFrameGrabber.tryLoad();
        int count = videoInputLib.videoInput.listDevices();
        String[] descriptions = new String[count];
        if (count > 0) {
            for (int i = 0; i < descriptions.length; ++i) {
                descriptions[i] = videoInputLib.videoInput.getDeviceName(i);
            }
        }
        return descriptions;
    }

    public static void tryLoad() throws Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(videoInputLib.class);
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                loadingException = (Exception)t;
                throw loadingException;
            }
            loadingException = new Exception(t);
            throw loadingException;
        }
    }

    public VideoInputFrameGrabber(int deviceNumber) {
        this.deviceNumber = deviceNumber;
    }

    public void release() throws Exception {
        this.stop();
    }

    protected void finalize() {
        try {
            this.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double getGamma() {
        if (this.gamma == 0.0) {
            return 2.2;
        }
        return this.gamma;
    }

    public void start() throws Exception {
        this.myVideoInput = new videoInputLib.videoInput();
        if (this.frameRate > 0.0) {
            this.myVideoInput.setIdealFramerate(this.deviceNumber, (int)this.frameRate);
        }
        if (this.imageWidth <= 0 || this.imageHeight <= 0 ? !this.myVideoInput.setupDevice(this.deviceNumber) : !this.myVideoInput.setupDevice(this.deviceNumber, this.imageWidth, this.imageHeight)) {
            this.myVideoInput = null;
            throw new Exception("videoInput.setupDevice() Error: Could not setup device.");
        }
        if (this.format != null && this.format.length() > 0) {
            int f;
            int n = this.format.equals("VI_NTSC_M") ? 0 : (this.format.equals("VI_PAL_B") ? 1 : (this.format.equals("VI_PAL_D") ? 2 : (this.format.equals("VI_PAL_G") ? 3 : (this.format.equals("VI_PAL_H") ? 4 : (this.format.equals("VI_PAL_I") ? 5 : (this.format.equals("VI_PAL_M") ? 6 : (this.format.equals("VI_PAL_N") ? 7 : (this.format.equals("VI_PAL_NC") ? 8 : (this.format.equals("VI_SECAM_B") ? 9 : (this.format.equals("VI_SECAM_D") ? 10 : (this.format.equals("VI_SECAM_G") ? 11 : (this.format.equals("VI_SECAM_H") ? 12 : (this.format.equals("VI_SECAM_K") ? 13 : (this.format.equals("VI_SECAM_K1") ? 14 : (this.format.equals("VI_SECAM_L") ? 15 : (this.format.equals("VI_NTSC_M_J") ? 16 : (f = this.format.equals("VI_NTSC_433") ? 17 : -1)))))))))))))))));
            if (f >= 0 && !this.myVideoInput.setFormat(this.deviceNumber, f)) {
                throw new Exception("videoInput.setFormat() Error: Could not set format " + this.format + ".");
            }
        }
    }

    public void stop() throws Exception {
        if (this.myVideoInput != null) {
            this.myVideoInput.stopDevice(this.deviceNumber);
            this.myVideoInput = null;
        }
    }

    public void trigger() throws Exception {
        if (this.myVideoInput == null) {
            throw new Exception("videoInput is null. (Has start() been called?)");
        }
        int w = this.myVideoInput.getWidth(this.deviceNumber);
        int h = this.myVideoInput.getHeight(this.deviceNumber);
        if (this.bgrImage == null || this.bgrImage.width() != w || this.bgrImage.height() != h) {
            this.bgrImage = opencv_core.IplImage.create(w, h, 8, 3);
            this.bgrImageData = this.bgrImage.imageData();
        }
        for (int i = 0; i < this.triggerFlushSize; ++i) {
            this.myVideoInput.getPixels(this.deviceNumber, this.bgrImageData, false, true);
        }
    }

    public opencv_core.IplImage grab() throws Exception {
        if (this.myVideoInput == null) {
            throw new Exception("videoInput is null. (Has start() been called?)");
        }
        int w = this.myVideoInput.getWidth(this.deviceNumber);
        int h = this.myVideoInput.getHeight(this.deviceNumber);
        if (this.bgrImage == null || this.bgrImage.width() != w || this.bgrImage.height() != h) {
            this.bgrImage = opencv_core.IplImage.create(w, h, 8, 3);
            this.bgrImageData = this.bgrImage.imageData();
        }
        if (!this.myVideoInput.getPixels(this.deviceNumber, this.bgrImageData, false, true)) {
            throw new Exception("videoInput.getPixels() Error: Could not get pixels.");
        }
        if (this.colorMode == FrameGrabber.ColorMode.GRAY) {
            if (this.grayImage == null) {
                this.grayImage = opencv_core.IplImage.create(w, h, 8, 1);
            }
            opencv_imgproc.cvCvtColor(this.bgrImage, this.grayImage, 6);
            return this.grayImage;
        }
        return this.bgrImage;
    }
}

