/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_highgui;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.io.File;

public class OpenCVFrameGrabber
extends FrameGrabber {
    private static Exception loadingException = null;
    private static final boolean macosx = Loader.getPlatformName().startsWith("macosx");
    private int deviceNumber = 0;
    private String filename = null;
    private opencv_highgui.CvCapture capture = null;
    private opencv_core.IplImage return_image = null;

    public static String[] getDeviceDescriptions() throws Exception {
        OpenCVFrameGrabber.tryLoad();
        throw new UnsupportedOperationException("Device enumeration not support by OpenCV.");
    }

    public static void tryLoad() throws Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(opencv_highgui.class);
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                loadingException = (Exception)t;
                throw loadingException;
            }
            loadingException = new Exception(t);
            throw loadingException;
        }
    }

    public OpenCVFrameGrabber(int deviceNumber) {
        this.deviceNumber = deviceNumber;
    }

    public OpenCVFrameGrabber(File file) {
        this(file.getAbsolutePath());
    }

    public OpenCVFrameGrabber(String filename) {
        this.filename = filename;
    }

    public void release() throws Exception {
        this.stop();
    }

    protected void finalize() {
        try {
            this.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double getGamma() {
        if (this.gamma == 0.0) {
            return 2.2;
        }
        return this.gamma;
    }

    public void start() throws Exception {
        if (this.filename != null && this.filename.length() > 0) {
            this.capture = opencv_highgui.cvCreateFileCapture(this.filename);
            if (this.capture == null) {
                throw new Exception("cvCreateFileCapture() Error: Could not create camera capture.");
            }
        } else {
            this.capture = opencv_highgui.cvCreateCameraCapture(this.deviceNumber);
            if (this.capture == null) {
                throw new Exception("cvCreateCameraCapture() Error: Could not create camera capture.");
            }
        }
        if (this.imageWidth > 0 && opencv_highgui.cvSetCaptureProperty(this.capture, 3, this.imageWidth) == 0) {
            opencv_highgui.cvSetCaptureProperty(this.capture, 9, this.imageWidth);
        }
        if (this.imageHeight > 0 && opencv_highgui.cvSetCaptureProperty(this.capture, 4, this.imageHeight) == 0) {
            opencv_highgui.cvSetCaptureProperty(this.capture, 9, this.imageHeight);
        }
        if (this.frameRate > 0.0) {
            opencv_highgui.cvSetCaptureProperty(this.capture, 5, this.frameRate);
        }
        if (this.bpp > 0) {
            opencv_highgui.cvSetCaptureProperty(this.capture, 8, this.bpp);
        }
        opencv_highgui.cvSetCaptureProperty(this.capture, 16, this.colorMode == FrameGrabber.ColorMode.BGR ? 1.0 : 0.0);
        if (macosx) {
            int count = 0;
            while (count++ < 100 && opencv_highgui.cvGrabFrame(this.capture) != 0 && opencv_highgui.cvRetrieveFrame(this.capture) == null) {
                Thread.sleep(100L);
            }
        }
        if (!this.triggerMode) {
            this.trigger();
        }
    }

    public void stop() throws Exception {
        if (this.capture != null) {
            opencv_highgui.cvReleaseCapture(this.capture);
            this.capture = null;
        }
    }

    public void trigger() throws Exception {
        for (int i = 0; i < this.triggerFlushSize; ++i) {
            opencv_highgui.cvQueryFrame(this.capture);
        }
        int err = opencv_highgui.cvGrabFrame(this.capture);
        if (err == 0) {
            throw new Exception("cvGrabFrame() Error: Could not grab frame. (Has start() been called?)");
        }
    }

    public opencv_core.IplImage grab() throws Exception {
        opencv_core.IplImage image = opencv_highgui.cvRetrieveFrame(this.capture);
        if (image == null) {
            throw new Exception("cvRetrieveFrame() Error: Could not retrieve frame. (Has start() been called?)");
        }
        if (!this.triggerMode) {
            this.trigger();
        }
        if (this.colorMode == FrameGrabber.ColorMode.GRAY && image.nChannels() > 1) {
            if (this.return_image == null) {
                this.return_image = opencv_core.IplImage.create(image.width(), image.height(), image.depth(), 1);
            }
            opencv_imgproc.cvCvtColor(image, this.return_image, 6);
        } else if (this.colorMode == FrameGrabber.ColorMode.BGR && image.nChannels() == 1) {
            if (this.return_image == null) {
                this.return_image = opencv_core.IplImage.create(image.width(), image.height(), image.depth(), 3);
            }
            opencv_imgproc.cvCvtColor(image, this.return_image, 8);
        } else {
            this.return_image = image;
        }
        this.return_image.timestamp(Math.round(opencv_highgui.cvGetCaptureProperty(this.capture, 0) * 1000.0));
        return this.return_image;
    }
}

