/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.BaseChildSettings;
import com.googlecode.javacv.JavaCV;
import com.googlecode.javacv.Marker;
import com.googlecode.javacv.cpp.ARToolKitPlus;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.util.Arrays;
import java.util.logging.Logger;

public class MarkerDetector {
    private Settings settings;
    private ARToolKitPlus.MultiTracker tracker = null;
    private int width = 0;
    private int height = 0;
    private int depth = 0;
    private int channels = 0;
    private opencv_core.IplImage tempsrc;
    private opencv_core.IplImage tempsrc2;
    private opencv_core.IplImage sumimage;
    private opencv_core.IplImage sqsumimage;
    private opencv_core.IplImage binarized;
    private opencv_core.CvMat points = opencv_core.CvMat.create(1, 4, 5, 2);
    private opencv_core.CvPoint2D32f corners = new opencv_core.CvPoint2D32f(4);
    private opencv_core.CvMemStorage memory = opencv_core.CvMemStorage.create();
    private opencv_core.CvSize subPixelSize = null;
    private opencv_core.CvSize subPixelZeroZone = null;
    private opencv_core.CvTermCriteria subPixelTermCriteria = null;
    private opencv_core.CvPoint pts = new opencv_core.CvPoint(4);
    private opencv_core.CvPoint pt1 = new opencv_core.CvPoint();
    private opencv_core.CvPoint pt2 = new opencv_core.CvPoint();
    private opencv_core.CvFont font = new opencv_core.CvFont(1, 1.0, 1);
    private opencv_core.CvSize text_size = new opencv_core.CvSize();

    public MarkerDetector(Settings settings) {
        this.setSettings(settings);
    }

    public MarkerDetector() {
        this(new Settings());
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.subPixelSize = opencv_core.cvSize(settings.subPixelWindow / 2, settings.subPixelWindow / 2);
        this.subPixelZeroZone = opencv_core.cvSize(-1, -1);
        this.subPixelTermCriteria = opencv_core.cvTermCriteria(2, 100, 0.001);
    }

    private void init(opencv_core.IplImage image) {
        if (this.tracker != null && image.width() == this.width && image.height() == this.height && image.depth() == this.depth && image.nChannels() == this.channels) {
            return;
        }
        this.width = image.width();
        this.height = image.height();
        this.depth = image.depth();
        this.channels = image.nChannels();
        if (this.depth != 8 || this.channels > 1) {
            this.tempsrc = opencv_core.IplImage.create(this.width, this.height, 8, 1);
        }
        if (this.depth != 8 && this.channels > 1) {
            this.tempsrc2 = opencv_core.IplImage.create(this.width, this.height, 8, 3);
        }
        this.sumimage = opencv_core.IplImage.create(this.width + 1, this.height + 1, 64, 1);
        this.sqsumimage = opencv_core.IplImage.create(this.width + 1, this.height + 1, 64, 1);
        this.binarized = opencv_core.IplImage.create(this.width, this.height, 8, 1);
        this.tracker = new ARToolKitPlus.MultiTracker(this.binarized.widthStep(), this.binarized.height());
        this.tracker.setLoggerFunction(new ARToolKitPlus.ArtLogFunction(){

            public void call(String nStr) {
                Logger.getLogger(MarkerDetector.class.getName()).warning(nStr);
            }
        });
        int pixfmt = 7;
        this.tracker.setPixelFormat(pixfmt);
        this.tracker.setBorderWidth(0.125);
        this.tracker.setUndistortionMode(0);
        this.tracker.setMarkerMode(2);
        this.tracker.setImageProcessingMode(1);
    }

    public opencv_core.IplImage getBinarized() {
        return this.binarized;
    }

    public Marker[] detect(opencv_core.IplImage image, boolean whiteMarkers) {
        this.init(image);
        if (this.depth != 8 && this.channels > 1) {
            opencv_core.cvConvertScale(image, this.tempsrc2, 255.0 / image.highValue(), 0.0);
            opencv_imgproc.cvCvtColor(this.tempsrc2, this.tempsrc, 6);
            image = this.tempsrc;
        } else if (this.depth != 8) {
            opencv_core.cvConvertScale(image, this.tempsrc, 255.0 / image.highValue(), 0.0);
            image = this.tempsrc;
        } else if (this.channels > 1) {
            opencv_imgproc.cvCvtColor(image, this.tempsrc, 6);
            image = this.tempsrc;
        }
        JavaCV.adaptiveBinarization(image, this.sumimage, this.sqsumimage, this.binarized, whiteMarkers, this.settings.binarizationWindowMin, this.settings.binarizationWindowMax, this.settings.binarizationVarianceMultiplier, whiteMarkers ? this.settings.binarizationKWhiteMarkers : this.settings.binarizationKBlackMarkers);
        int[] n = new int[1];
        ARToolKitPlus.ARMarkerInfo markers = new ARToolKitPlus.ARMarkerInfo(null);
        this.tracker.arDetectMarkerLite(this.binarized.getByteBuffer(), 128, markers, n);
        Marker[] markers2 = new Marker[n[0]];
        int n2 = 0;
        for (int i = 0; i < n[0] && !markers.isNull(); ++i) {
            markers.position(i);
            int id = markers.id();
            if (id < 0) continue;
            int dir = markers.dir();
            double confidence = markers.cf();
            double[] vertex = new double[8];
            markers.vertex().asBuffer(8).get(vertex);
            int w = this.settings.subPixelWindow / 2 + 1;
            if (vertex[0] - (double)w < 0.0 || vertex[0] + (double)w >= (double)this.width || vertex[1] - (double)w < 0.0 || vertex[1] + (double)w >= (double)this.height || vertex[2] - (double)w < 0.0 || vertex[2] + (double)w >= (double)this.width || vertex[3] - (double)w < 0.0 || vertex[3] + (double)w >= (double)this.height || vertex[4] - (double)w < 0.0 || vertex[4] + (double)w >= (double)this.width || vertex[5] - (double)w < 0.0 || vertex[5] + (double)w >= (double)this.height || vertex[6] - (double)w < 0.0 || vertex[6] + (double)w >= (double)this.width || vertex[7] - (double)w < 0.0 || vertex[7] + (double)w >= (double)this.height) continue;
            this.points.put(vertex);
            opencv_core.CvBox2D box = opencv_imgproc.cvMinAreaRect2(this.points, this.memory);
            float bw = box.size().width();
            float bh = box.size().height();
            opencv_core.cvClearMemStorage(this.memory);
            if (bw <= 0.0f || bh <= 0.0f || (double)(bw / bh) < 0.1 || bw / bh > 10.0f) continue;
            for (int j = 0; j < 4; ++j) {
                this.corners.position(j).set(vertex[2 * j], vertex[2 * j + 1]);
            }
            opencv_imgproc.cvFindCornerSubPix(image, this.corners.position(0), 4, this.subPixelSize, this.subPixelZeroZone, this.subPixelTermCriteria);
            vertex[0] = this.corners.position((4 - dir) % 4).x();
            vertex[1] = this.corners.position((4 - dir) % 4).y();
            vertex[2] = this.corners.position((5 - dir) % 4).x();
            vertex[3] = this.corners.position((5 - dir) % 4).y();
            vertex[4] = this.corners.position((6 - dir) % 4).x();
            vertex[5] = this.corners.position((6 - dir) % 4).y();
            vertex[6] = this.corners.position((7 - dir) % 4).x();
            vertex[7] = this.corners.position((7 - dir) % 4).y();
            markers2[n2++] = new Marker(id, vertex, confidence);
        }
        return Arrays.copyOf(markers2, n2);
    }

    public void draw(opencv_core.IplImage image, Marker[] markers) {
        for (Marker m : markers) {
            int cx = 0;
            int cy = 0;
            for (int i = 0; i < 4; ++i) {
                int x = (int)Math.round(m.corners[i * 2] * 65536.0);
                int y = (int)Math.round(m.corners[i * 2 + 1] * 65536.0);
                this.pts.position(i).x(x);
                this.pts.position(i).y(y);
                cx += x;
                cy += y;
            }
            cx /= 4;
            cy /= 4;
            opencv_core.cvPolyLine((opencv_core.CvArr)image, this.pts, new int[]{4}, 1, 1, opencv_core.CV_RGB(0.0, 0.0, image.highValue()), 1, 16, 16);
            String text = Integer.toString(m.id);
            int[] baseline = new int[1];
            opencv_core.cvGetTextSize(text, this.font, this.text_size, baseline);
            this.pt1.x(cx - (this.text_size.width() * 3 / 2 << 16) / 2);
            this.pt1.y(cy + (this.text_size.height() * 3 / 2 << 16) / 2);
            this.pt2.x(cx + (this.text_size.width() * 3 / 2 << 16) / 2);
            this.pt2.y(cy - (this.text_size.height() * 3 / 2 << 16) / 2);
            opencv_core.cvRectangle(image, this.pt1, this.pt2, opencv_core.CV_RGB(0.0, image.highValue(), 0.0), -1, 16, 16);
            this.pt1.x((int)Math.round((double)cx / 65536.0 - (double)(this.text_size.width() / 2)));
            this.pt1.y((int)Math.round((double)cy / 65536.0 + (double)(this.text_size.height() / 2) + 1.0));
            opencv_core.cvPutText(image, text, this.pt1, this.font, opencv_core.CvScalar.BLACK);
        }
    }

    public static class Settings
    extends BaseChildSettings {
        int binarizationWindowMin = 5;
        int binarizationWindowMax = 63;
        double binarizationVarianceMultiplier = 1.0;
        double binarizationKBlackMarkers = 0.6;
        double binarizationKWhiteMarkers = 1.0;
        int subPixelWindow = 11;

        public int getBinarizationWindowMin() {
            return this.binarizationWindowMin;
        }

        public void setBinarizationWindowMin(int binarizationWindowMin) {
            this.binarizationWindowMin = binarizationWindowMin;
        }

        public int getBinarizationWindowMax() {
            return this.binarizationWindowMax;
        }

        public void setBinarizationWindowMax(int binarizationWindowMax) {
            this.binarizationWindowMax = binarizationWindowMax;
        }

        public double getBinarizationVarianceMultiplier() {
            return this.binarizationVarianceMultiplier;
        }

        public void setBinarizationVarianceMultiplier(double binarizationVarianceMultiplier) {
            this.binarizationVarianceMultiplier = binarizationVarianceMultiplier;
        }

        public double getBinarizationKBlackMarkers() {
            return this.binarizationKBlackMarkers;
        }

        public void setBinarizationKBlackMarkers(double binarizationKBlackMarkers) {
            this.binarizationKBlackMarkers = binarizationKBlackMarkers;
        }

        public double getBinarizationKWhiteMarkers() {
            return this.binarizationKWhiteMarkers;
        }

        public void setBinarizationKWhiteMarkers(double binarizationKWhiteMarkers) {
            this.binarizationKWhiteMarkers = binarizationKWhiteMarkers;
        }

        public int getSubPixelWindow() {
            return this.subPixelWindow;
        }

        public void setSubPixelWindow(int subPixelWindow) {
            this.subPixelWindow = subPixelWindow;
        }
    }
}

