/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.JavaCV;
import com.googlecode.javacv.Marker;
import com.googlecode.javacv.cpp.opencv_calib3d;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;

public class MarkedPlane {
    private Marker[] markers = null;
    private opencv_core.CvMat prewarp;
    private opencv_core.IplImage planeImage = null;
    private opencv_core.IplImage superPlaneImage = null;
    private opencv_core.CvScalar foregroundColor;
    private opencv_core.CvScalar backgroundColor;
    private ThreadLocal<opencv_core.CvMat> localSrcPts;
    private ThreadLocal<opencv_core.CvMat> localDstPts;
    private static ThreadLocal<opencv_core.CvMat> tempWarp3x3 = opencv_core.CvMat.createThreadLocal(3, 3);

    public MarkedPlane(int width, int height, Marker[] planeMarkers, double superScale) {
        this(width, height, planeMarkers, false, opencv_core.CvScalar.BLACK, opencv_core.CvScalar.WHITE, superScale);
    }

    public MarkedPlane(int width, int height, Marker[] markers, boolean initPrewarp, opencv_core.CvScalar foregroundColor, opencv_core.CvScalar backgroundColor, double superScale) {
        this.markers = markers;
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.prewarp = null;
        if (initPrewarp) {
            this.prewarp = opencv_core.CvMat.create(3, 3);
            double minx = Double.MAX_VALUE;
            double miny = Double.MAX_VALUE;
            double maxx = Double.MIN_VALUE;
            double maxy = Double.MIN_VALUE;
            for (Marker m : markers) {
                double[] c = m.corners;
                minx = Math.min(Math.min(Math.min(Math.min(minx, c[0]), c[2]), c[4]), c[6]);
                miny = Math.min(Math.min(Math.min(Math.min(miny, c[1]), c[3]), c[5]), c[7]);
                maxx = Math.max(Math.max(Math.max(Math.max(maxx, c[0]), c[2]), c[4]), c[6]);
                maxy = Math.max(Math.max(Math.max(Math.max(maxy, c[1]), c[3]), c[5]), c[7]);
            }
            double aspect = (maxx - minx) / (maxy - miny);
            if (aspect > (double)width / (double)height) {
                double h = (double)width / aspect;
                JavaCV.getPerspectiveTransform(new double[]{minx, miny, maxx, miny, maxx, maxy, minx, maxy}, new double[]{0.0, (double)height - h, width, (double)height - h, width, height, 0.0, height}, this.prewarp);
            } else {
                double w = (double)height * aspect;
                JavaCV.getPerspectiveTransform(new double[]{minx, miny, maxx, miny, maxx, maxy, minx, maxy}, new double[]{0.0, 0.0, w, 0.0, w, height, 0.0, height}, this.prewarp);
            }
        }
        if (width > 0 && height > 0) {
            this.planeImage = opencv_core.IplImage.create(width, height, 8, 1);
            this.superPlaneImage = superScale == 1.0 ? null : opencv_core.IplImage.create((int)Math.ceil((double)width * superScale), (int)Math.ceil((double)height * superScale), 8, 1);
            this.setPrewarp(this.prewarp);
        }
        this.localSrcPts = opencv_core.CvMat.createThreadLocal(markers.length * 4, 2);
        this.localDstPts = opencv_core.CvMat.createThreadLocal(markers.length * 4, 2);
    }

    public opencv_core.CvScalar getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(opencv_core.CvScalar foregroundColor) {
        this.foregroundColor = foregroundColor;
        this.setPrewarp(this.prewarp);
    }

    public opencv_core.CvScalar getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(opencv_core.CvScalar backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.setPrewarp(this.prewarp);
    }

    public Marker[] getMarkers() {
        return this.markers;
    }

    public void setColors(opencv_core.CvScalar foregroundColor, opencv_core.CvScalar backgroundColor) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.setPrewarp(this.prewarp);
    }

    public opencv_core.CvMat getPrewarp() {
        return this.prewarp;
    }

    public void setPrewarp(opencv_core.CvMat prewarp) {
        this.prewarp = prewarp;
        if (this.superPlaneImage == null) {
            opencv_core.cvSet(this.planeImage, this.backgroundColor);
        } else {
            opencv_core.cvSet(this.superPlaneImage, this.backgroundColor);
        }
        for (int i = 0; i < this.markers.length; ++i) {
            if (this.superPlaneImage == null) {
                this.markers[i].draw(this.planeImage, this.foregroundColor, 1.0, prewarp);
                continue;
            }
            this.markers[i].draw(this.superPlaneImage, this.foregroundColor, (double)this.superPlaneImage.width() / (double)this.planeImage.width(), prewarp);
        }
        if (this.superPlaneImage != null) {
            opencv_imgproc.cvResize(this.superPlaneImage, this.planeImage, 3);
        }
    }

    public opencv_core.IplImage getImage() {
        return this.planeImage;
    }

    public int getWidth() {
        return this.planeImage.width();
    }

    public int getHeight() {
        return this.planeImage.height();
    }

    public double getTotalWarp(Marker[] imagedMarkers, opencv_core.CvMat totalWarp) {
        return this.getTotalWarp(imagedMarkers, totalWarp, false);
    }

    public double getTotalWarp(Marker[] imagedMarkers, opencv_core.CvMat totalWarp, boolean useCenters) {
        double rmse = Double.POSITIVE_INFINITY;
        int pointsPerMarker = useCenters ? 1 : 4;
        opencv_core.CvMat srcPts = this.localSrcPts.get();
        srcPts.rows(this.markers.length * pointsPerMarker);
        opencv_core.CvMat dstPts = this.localDstPts.get();
        dstPts.rows(this.markers.length * pointsPerMarker);
        int numPoints = 0;
        block0: for (Marker m1 : this.markers) {
            for (Marker m2 : imagedMarkers) {
                if (m1.id != m2.id) continue;
                if (useCenters) {
                    srcPts.put(numPoints * 2, m1.getCenter());
                    dstPts.put(numPoints * 2, m2.getCenter());
                } else {
                    srcPts.put(numPoints * 2, m1.corners);
                    dstPts.put(numPoints * 2, m2.corners);
                }
                numPoints += pointsPerMarker;
                continue block0;
            }
        }
        if (numPoints > 4 || srcPts.rows() == 4 && numPoints == 4) {
            srcPts.rows(numPoints);
            dstPts.rows(numPoints);
            if (numPoints == 4) {
                JavaCV.getPerspectiveTransform(srcPts.get(), dstPts.get(), totalWarp);
            } else {
                opencv_calib3d.cvFindHomography(srcPts, dstPts, totalWarp);
            }
            srcPts.cols(1);
            srcPts.type(6, 2);
            dstPts.cols(1);
            dstPts.type(6, 2);
            opencv_core.cvPerspectiveTransform(srcPts, srcPts, totalWarp);
            srcPts.cols(2);
            srcPts.type(6, 1);
            dstPts.cols(2);
            dstPts.type(6, 1);
            rmse = 0.0;
            for (int i = 0; i < numPoints; ++i) {
                double dx = dstPts.get(i * 2) - srcPts.get(i * 2);
                double dy = dstPts.get(i * 2 + 1) - srcPts.get(i * 2 + 1);
                rmse += dx * dx + dy * dy;
            }
            rmse = Math.sqrt(rmse / (double)numPoints);
            if (this.prewarp != null) {
                opencv_core.CvMat tempWarp = tempWarp3x3.get();
                opencv_core.cvInvert(this.prewarp, tempWarp);
                opencv_core.cvMatMul(totalWarp, tempWarp, totalWarp);
            }
        }
        return rmse;
    }
}

