/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.ImageAligner;
import com.googlecode.javacv.ImageTransformer;
import com.googlecode.javacv.JavaCV;
import com.googlecode.javacv.Parallel;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.util.Arrays;

public class GNImageAligner
implements ImageAligner {
    private Settings settings;
    private opencv_core.IplImage[] template;
    private opencv_core.IplImage[] target;
    private opencv_core.IplImage[] transformed;
    private opencv_core.IplImage[] residual;
    private opencv_core.IplImage[] roiMask;
    private opencv_core.CvMat srcRoiPts;
    private opencv_core.CvMat dstRoiPts;
    private opencv_core.CvPoint dstRoiPtsArray;
    private opencv_core.CvRect roi;
    private opencv_core.CvRect[] subroi;
    private ImageTransformer transformer;
    private ImageTransformer.Data[][] hessianGradientTransformerData;
    private ImageTransformer.Data[][] residualTransformerData;
    private ImageTransformer.Parameters parameters;
    private ImageTransformer.Parameters[] parametersArray;
    private ImageTransformer.Parameters[] tempParameters;
    private ImageTransformer.Parameters priorParameters;
    private opencv_core.CvMat hessian;
    private opencv_core.CvMat regularizedHessian;
    private opencv_core.CvMat gradient;
    private opencv_core.CvMat update;
    private opencv_core.CvMat prior;
    private double[] constraintGrad;
    private double[] subspaceResidual;
    private double[][] subspaceJacobian;
    private double[] updateScale;
    private boolean[] subspaceCorrelated;
    private int pyramidLevel;
    private double RMSE;
    private boolean residualUpdateNeeded = true;
    private int lastLinePosition = 0;
    private int trials = 0;
    public double[] subspaceParameters;
    public double[][] tempSubspaceParameters;

    public GNImageAligner(ImageTransformer transformer, ImageTransformer.Parameters initialParameters, opencv_core.IplImage template0, double[] roiPts, opencv_core.IplImage target0) {
        this(transformer, initialParameters, template0, roiPts, target0, new Settings());
    }

    public GNImageAligner(ImageTransformer transformer, ImageTransformer.Parameters initialParameters, opencv_core.IplImage template0, double[] roiPts, opencv_core.IplImage target0, Settings settings) {
        int i;
        this.setSettings(settings);
        int n = initialParameters.size();
        this.template = new opencv_core.IplImage[settings.pyramidLevels];
        this.target = new opencv_core.IplImage[settings.pyramidLevels];
        this.transformed = new opencv_core.IplImage[settings.pyramidLevels];
        this.residual = new opencv_core.IplImage[settings.pyramidLevels];
        this.roiMask = new opencv_core.IplImage[settings.pyramidLevels];
        int w = template0.width();
        int h = template0.height();
        int c = template0.nChannels();
        int o = template0.origin();
        for (i = 0; i < settings.pyramidLevels; ++i) {
            if (i == 0 && template0.depth() == 32) {
                this.template[0] = template0;
            } else {
                this.template[i] = opencv_core.IplImage.create(w, h, 32, c, o);
            }
            if (i == 0 && target0.depth() == 32) {
                this.target[0] = target0;
            } else {
                this.target[i] = opencv_core.IplImage.create(w, h, 32, c, o);
            }
            this.transformed[i] = opencv_core.IplImage.create(w, h, 32, c, o);
            this.residual[i] = opencv_core.IplImage.create(w, h, 32, c, o);
            this.roiMask[i] = opencv_core.IplImage.create(w, h, 8, 1, o);
            w /= 2;
            h /= 2;
        }
        this.srcRoiPts = opencv_core.CvMat.create(4, 1, 6, 2);
        this.dstRoiPts = opencv_core.CvMat.create(4, 1, 6, 2);
        this.dstRoiPtsArray = new opencv_core.CvPoint(4);
        this.roi = new opencv_core.CvRect();
        this.subroi = new opencv_core.CvRect[settings.numThreads];
        for (i = 0; i < this.subroi.length; ++i) {
            this.subroi[i] = new opencv_core.CvRect();
        }
        this.transformer = transformer;
        this.hessianGradientTransformerData = new ImageTransformer.Data[settings.numThreads][n];
        for (i = 0; i < this.hessianGradientTransformerData.length; ++i) {
            for (int j = 0; j < this.hessianGradientTransformerData[i].length; ++j) {
                this.hessianGradientTransformerData[i][j] = new ImageTransformer.Data(this.template[this.pyramidLevel], this.transformed[this.pyramidLevel], this.residual[this.pyramidLevel], this.roiMask[this.pyramidLevel], 0.0, 0.0, this.pyramidLevel, null, null, n);
            }
        }
        this.residualTransformerData = new ImageTransformer.Data[settings.numThreads][1];
        for (i = 0; i < this.residualTransformerData.length; ++i) {
            this.residualTransformerData[i][0] = new ImageTransformer.Data(this.template[this.pyramidLevel], this.target[this.pyramidLevel], null, this.roiMask[this.pyramidLevel], 0.0, 0.0, this.pyramidLevel, this.transformed[this.pyramidLevel], this.residual[this.pyramidLevel], 1);
        }
        this.parameters = initialParameters.clone();
        this.parametersArray = new ImageTransformer.Parameters[]{this.parameters};
        this.tempParameters = new ImageTransformer.Parameters[n];
        for (i = 0; i < this.tempParameters.length; ++i) {
            this.tempParameters[i] = initialParameters.clone();
        }
        this.subspaceParameters = this.parameters.getSubspace();
        if (this.subspaceParameters != null) {
            this.tempSubspaceParameters = new double[settings.numThreads][];
            for (i = 0; i < this.tempSubspaceParameters.length; ++i) {
                this.tempSubspaceParameters[i] = (double[])this.subspaceParameters.clone();
            }
        }
        this.setConstrained(settings.constrained);
        this.setTemplateImage(template0, roiPts);
        this.setTargetImage(target0);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(ImageAligner.Settings settings) {
        this.settings = (Settings)settings;
    }

    public opencv_core.IplImage getTemplateImage() {
        return this.template[this.pyramidLevel];
    }

    public void setTemplateImage(opencv_core.IplImage template0, double[] roiPts) {
        if (roiPts == null) {
            this.srcRoiPts.put(0.0, 0.0, template0.width(), 0.0, template0.width(), template0.height(), 0.0, template0.height());
        } else {
            this.srcRoiPts.put(roiPts);
        }
        if (template0.depth() == 32) {
            this.template[0] = template0;
        } else {
            opencv_core.cvConvertScale(template0, this.template[0], 1.0 / template0.highValue(), 0.0);
        }
        for (int i = 1; i < this.template.length; ++i) {
            opencv_imgproc.cvPyrDown(this.template[i - 1], this.template[i], 7);
        }
        this.setPyramidLevel(this.template.length - 1);
    }

    public opencv_core.IplImage getTargetImage() {
        return this.target[this.pyramidLevel];
    }

    public void setTargetImage(opencv_core.IplImage target0) {
        if (target0.depth() == 32) {
            this.target[0] = target0;
        }
        if (this.settings.displacementMax > 0.0) {
            this.setPyramidLevel(0);
            this.doRoi(this.settings.displacementMax);
            int align = 1 << this.target.length;
            this.subroi[0].x(Math.max(0, (int)Math.floor((double)this.roi.x() / (double)align) * align));
            this.subroi[0].y(Math.max(0, (int)Math.floor((double)this.roi.y() / (double)align) * align));
            this.subroi[0].width(Math.min(target0.width(), (int)Math.ceil((double)this.roi.width() / (double)align) * align));
            this.subroi[0].height(Math.min(target0.height(), (int)Math.ceil((double)this.roi.height() / (double)align) * align));
            opencv_core.cvSetImageROI(target0, this.subroi[0]);
            opencv_core.cvSetImageROI(this.target[0], this.subroi[0]);
        } else {
            opencv_core.cvResetImageROI(target0);
            opencv_core.cvResetImageROI(this.target[0]);
        }
        if (target0.depth() != 32) {
            opencv_core.cvConvertScale(target0, this.target[0], 1.0 / target0.highValue(), 0.0);
            opencv_core.cvResetImageROI(target0);
        }
        for (int i = 1; i < this.target.length; ++i) {
            opencv_core.IplROI ir = this.target[i - 1].roi();
            if (ir != null) {
                this.subroi[0].x(ir.xOffset() / 2);
                this.subroi[0].width(ir.width() / 2);
                this.subroi[0].y(ir.yOffset() / 2);
                this.subroi[0].height(ir.height() / 2);
                opencv_core.cvSetImageROI(this.target[i], this.subroi[0]);
            } else {
                opencv_core.cvResetImageROI(this.target[i]);
            }
            opencv_imgproc.cvPyrDown(this.target[i - 1], this.target[i], 7);
        }
        this.setPyramidLevel(this.target.length - 1);
    }

    public int getPyramidLevel() {
        return this.pyramidLevel;
    }

    public void setPyramidLevel(int pyramidLevel) {
        this.pyramidLevel = pyramidLevel;
        this.residualUpdateNeeded = true;
        this.trials = 0;
    }

    public boolean isConstrained() {
        return this.settings.constrained;
    }

    public void setConstrained(boolean constrained) {
        int m;
        if (this.settings.constrained == constrained && this.hessian != null && this.regularizedHessian != null && this.gradient != null && this.update != null) {
            return;
        }
        this.settings.constrained = constrained;
        int n = this.parameters.size();
        int n2 = m = constrained ? n + 1 : n;
        if (this.subspaceParameters != null && this.settings.subspaceAlpha != 0.0) {
            m += this.subspaceParameters.length;
        }
        this.hessian = opencv_core.CvMat.create(m, m);
        this.regularizedHessian = opencv_core.CvMat.create(m, m);
        this.gradient = opencv_core.CvMat.create(m, 1);
        this.update = opencv_core.CvMat.create(m, 1);
        this.updateScale = new double[m];
        this.prior = opencv_core.CvMat.create(n, 1);
        this.constraintGrad = new double[n];
        this.subspaceResidual = new double[n];
        this.subspaceJacobian = new double[m][n];
        this.subspaceCorrelated = new boolean[n];
    }

    public ImageTransformer.Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(ImageTransformer.Parameters parameters) {
        this.parameters.set(parameters);
        this.subspaceParameters = parameters.getSubspace();
        if (this.subspaceParameters != null && this.settings.subspaceAlpha != 0.0) {
            for (int i = 0; i < this.tempSubspaceParameters.length; ++i) {
                this.tempSubspaceParameters[i] = (double[])this.subspaceParameters.clone();
            }
        }
        this.residualUpdateNeeded = true;
    }

    public ImageTransformer.Parameters getPriorParameters() {
        return this.priorParameters;
    }

    public void setPriorParameters(ImageTransformer.Parameters priorParameters) {
        this.priorParameters.set(priorParameters);
    }

    public double[] getTransformedRoiPts() {
        return this.dstRoiPts.get();
    }

    public opencv_core.IplImage getTransformedImage() {
        if (this.residualUpdateNeeded) {
            this.doRoi();
            this.doResidual();
        }
        return this.transformed[this.pyramidLevel];
    }

    public opencv_core.IplImage getResidualImage() {
        if (this.residualUpdateNeeded) {
            this.doRoi();
            this.doResidual();
        }
        return this.residual[this.pyramidLevel];
    }

    public opencv_core.IplImage getRoiMaskImage() {
        return this.roiMask[this.pyramidLevel];
    }

    public double getRMSE() {
        if (this.residualUpdateNeeded) {
            this.doRoi();
            this.doResidual();
        }
        return this.RMSE;
    }

    public int getPixelCount() {
        int dstCount = 0;
        for (ImageTransformer.Data[] data : this.residualTransformerData) {
            dstCount += data[0].dstCount;
        }
        return dstCount;
    }

    public opencv_core.CvRect getRoi() {
        if (this.residualUpdateNeeded) {
            this.doRoi();
        }
        return this.roi;
    }

    public int getLastLinePosition() {
        return this.lastLinePosition;
    }

    public boolean iterate(double[] delta) {
        boolean invalid;
        int i;
        double[] prevSubspaceParameters;
        boolean converged = false;
        int n = this.parameters.size();
        double prevRMSE = this.getRMSE();
        double[] prevParameters = this.parameters.get();
        double[] dArray = prevSubspaceParameters = this.subspaceParameters == null ? null : (double[])this.subspaceParameters.clone();
        if (this.trials == 0 && this.parameters.preoptimize()) {
            this.setParameters(this.parameters);
            this.doResidual();
        }
        double[] resetParameters = this.parameters.get();
        double[] resetSubspaceParameters = this.subspaceParameters == null ? null : (double[])this.subspaceParameters.clone();
        this.doHessianGradient(this.updateScale);
        int rows = this.hessian.rows();
        int cols = this.hessian.cols();
        for (i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                double h = this.hessian.get(i, j);
                double g = 0.0;
                if (this.settings.gammaTgamma != null && i < this.settings.gammaTgamma.rows() && j < this.settings.gammaTgamma.cols()) {
                    g = this.settings.gammaTgamma.get(i, j);
                }
                double a = 0.0;
                if (i == j && i < n) {
                    a = this.settings.tikhonovAlpha * this.settings.tikhonovAlpha;
                }
                this.regularizedHessian.put(i, j, h + g + a);
            }
        }
        this.lastLinePosition = 0;
        opencv_core.cvSolve(this.regularizedHessian, this.gradient, this.update, 1);
        for (i = 0; i < n; ++i) {
            this.parameters.set(i, this.parameters.get(i) + this.settings.lineSearch[0] * this.update.get(i) * this.updateScale[i]);
        }
        for (i = n; i < this.update.length(); ++i) {
            int n2 = i - n;
            this.subspaceParameters[n2] = this.subspaceParameters[n2] + this.settings.lineSearch[0] * this.update.get(i) * this.updateScale[i];
        }
        this.residualUpdateNeeded = true;
        for (int j = 1; j < this.settings.lineSearch.length && this.getRMSE() > prevRMSE; ++j) {
            int i2;
            this.RMSE = prevRMSE;
            this.parameters.set(resetParameters);
            if (this.subspaceParameters != null) {
                System.arraycopy(resetSubspaceParameters, 0, this.subspaceParameters, 0, this.subspaceParameters.length);
            }
            this.lastLinePosition = j;
            for (i2 = 0; i2 < n; ++i2) {
                this.parameters.set(i2, this.parameters.get(i2) + this.settings.lineSearch[j] * this.update.get(i2) * this.updateScale[i2]);
            }
            for (i2 = n; i2 < this.update.length(); ++i2) {
                int n3 = i2 - n;
                this.subspaceParameters[n3] = this.subspaceParameters[n3] + this.settings.lineSearch[j] * this.update.get(i2) * this.updateScale[i2];
            }
            this.residualUpdateNeeded = true;
        }
        double deltaNorm = 0.0;
        if (delta != null) {
            for (int i3 = 0; i3 < delta.length && i3 < this.updateScale.length; ++i3) {
                delta[i3] = this.settings.lineSearch[this.lastLinePosition] * this.update.get(i3) * this.updateScale[i3];
            }
            deltaNorm = JavaCV.norm(Arrays.copyOf(delta, n));
        }
        boolean bl = invalid = this.getRMSE() > prevRMSE || deltaNorm > this.settings.deltaMax || Double.isNaN(this.RMSE) || Double.isInfinite(this.RMSE);
        if (invalid) {
            this.RMSE = prevRMSE;
            this.parameters.set(prevParameters);
            if (this.subspaceParameters != null) {
                System.arraycopy(prevSubspaceParameters, 0, this.subspaceParameters, 0, this.subspaceParameters.length);
            }
            this.residualUpdateNeeded = true;
        }
        if (invalid && deltaNorm > this.settings.deltaMin && ++this.trials < 2) {
            return false;
        }
        if (invalid || deltaNorm < this.settings.deltaMin) {
            this.trials = 0;
            if (this.pyramidLevel > 0) {
                this.setPyramidLevel(this.pyramidLevel - 1);
            } else {
                converged = true;
            }
        } else {
            this.trials = 0;
        }
        return converged;
    }

    private void doHessianGradient(final double[] scale) {
        int i;
        final int n = this.parameters.size();
        final double constraintError = this.parameters.getConstraintError();
        final double stepScale = this.settings.stepScale;
        opencv_core.cvSetZero(this.gradient);
        opencv_core.cvSetZero(this.hessian);
        Parallel.loop(0, n, this.settings.numThreads, new Parallel.Looper(){

            public void loop(int from, int to, int looperID) {
                for (int i = from; i < to; ++i) {
                    GNImageAligner.this.tempParameters[i].set(GNImageAligner.this.parameters);
                    GNImageAligner.this.tempParameters[i].set(i, GNImageAligner.this.tempParameters[i].get(i) + stepScale);
                    scale[i] = GNImageAligner.this.tempParameters[i].get(i) - GNImageAligner.this.parameters.get(i);
                    ((GNImageAligner)GNImageAligner.this).constraintGrad[i] = GNImageAligner.this.tempParameters[i].getConstraintError() - constraintError;
                }
            }
        });
        Parallel.loop(0, this.hessianGradientTransformerData.length, this.settings.numThreads, new Parallel.Looper(){

            public void loop(int from, int to, int looperID) {
                for (int i = 0; i < n; ++i) {
                    ImageTransformer.Data d = GNImageAligner.this.hessianGradientTransformerData[looperID][i];
                    d.srcImg = GNImageAligner.this.template[GNImageAligner.this.pyramidLevel];
                    d.subImg = GNImageAligner.this.transformed[GNImageAligner.this.pyramidLevel];
                    d.srcDotImg = GNImageAligner.this.residual[GNImageAligner.this.pyramidLevel];
                    d.dstImg = null;
                    d.transImg = null;
                    d.mask = GNImageAligner.this.roiMask[GNImageAligner.this.pyramidLevel];
                    d.zeroThreshold = ((GNImageAligner)GNImageAligner.this).settings.zeroThresholds[Math.min(((GNImageAligner)GNImageAligner.this).settings.zeroThresholds.length - 1, GNImageAligner.this.pyramidLevel)];
                    d.outlierThreshold = ((GNImageAligner)GNImageAligner.this).settings.outlierThresholds[Math.min(((GNImageAligner)GNImageAligner.this).settings.outlierThresholds.length - 1, GNImageAligner.this.pyramidLevel)];
                    d.pyramidLevel = GNImageAligner.this.pyramidLevel;
                }
                int y1 = GNImageAligner.this.roi.y() + looperID * GNImageAligner.this.roi.height() / GNImageAligner.this.hessianGradientTransformerData.length;
                int y2 = GNImageAligner.this.roi.y() + (looperID + 1) * GNImageAligner.this.roi.height() / GNImageAligner.this.hessianGradientTransformerData.length;
                GNImageAligner.this.subroi[looperID].x(GNImageAligner.this.roi.x());
                GNImageAligner.this.subroi[looperID].y(y1);
                GNImageAligner.this.subroi[looperID].width(GNImageAligner.this.roi.width());
                GNImageAligner.this.subroi[looperID].height(y2 - y1);
                GNImageAligner.this.transformer.transform(GNImageAligner.this.hessianGradientTransformerData[looperID], GNImageAligner.this.subroi[looperID], GNImageAligner.this.tempParameters, null);
            }
        });
        double dstCount = 0.0;
        double dstCountZero = 0.0;
        double dstCountOutlier = 0.0;
        for (ImageTransformer.Data[] data : this.hessianGradientTransformerData) {
            dstCount += (double)data[0].dstCount;
            dstCountZero += (double)data[0].dstCountZero;
            dstCountOutlier += (double)data[0].dstCountOutlier;
            for (int i2 = 0; i2 < n; ++i2) {
                ImageTransformer.Data d = data[i2];
                this.gradient.put(i2, this.gradient.get(i2) - d.srcDstDot);
                for (int j = 0; j < n; ++j) {
                    this.hessian.put(i2, j, this.hessian.get(i2, j) + d.dstDstDot[j]);
                }
            }
        }
        if ((this.settings.gammaTgamma != null || this.settings.tikhonovAlpha != 0.0) && this.prior != null && this.priorParameters != null) {
            int i3;
            for (i3 = 0; i3 < n; ++i3) {
                this.prior.put(i3, this.parameters.get(i3) - this.priorParameters.get(i3));
            }
            opencv_core.cvMatMul(this.hessian, this.prior, this.prior);
            for (i3 = 0; i3 < n; ++i3) {
                this.gradient.put(i3, this.gradient.get(i3) + this.prior.get(i3));
            }
        }
        if (this.settings.constrained) {
            double constraintGradSum = 0.0;
            for (double d : this.constraintGrad) {
                constraintGradSum += d;
            }
            scale[n] = (double)n * constraintGradSum;
            for (i = 0; i < n; ++i) {
                double c = this.constraintGrad[i] * scale[n];
                this.hessian.put(i, n, c);
                this.hessian.put(n, i, c);
            }
            this.gradient.put(n, -constraintError * scale[n]);
        }
        if (this.subspaceParameters != null && this.subspaceParameters.length > 0 && this.settings.subspaceAlpha != 0.0) {
            final int m = this.subspaceParameters.length;
            Arrays.fill(this.subspaceCorrelated, false);
            this.tempParameters[0].set(this.parameters);
            this.tempParameters[0].setSubspace(this.subspaceParameters);
            Parallel.loop(0, n + m, this.settings.numThreads, new Parallel.Looper(){

                public void loop(int from, int to, int looperID) {
                    for (int i = from; i < to; ++i) {
                        if (i < n) {
                            Arrays.fill(GNImageAligner.this.subspaceJacobian[i], 0.0);
                            ((GNImageAligner)GNImageAligner.this).subspaceJacobian[i][i] = scale[i];
                            continue;
                        }
                        System.arraycopy(GNImageAligner.this.subspaceParameters, 0, GNImageAligner.this.tempSubspaceParameters[looperID], 0, m);
                        double[] dArray = GNImageAligner.this.tempSubspaceParameters[looperID];
                        int n3 = i - n;
                        dArray[n3] = dArray[n3] + stepScale;
                        GNImageAligner.this.tempParameters[i - n + 1].set(GNImageAligner.this.parameters);
                        GNImageAligner.this.tempParameters[i - n + 1].setSubspace(GNImageAligner.this.tempSubspaceParameters[looperID]);
                        scale[i] = GNImageAligner.this.tempSubspaceParameters[looperID][i - n] - GNImageAligner.this.subspaceParameters[i - n];
                        for (int j = 0; j < n; ++j) {
                            ((GNImageAligner)GNImageAligner.this).subspaceJacobian[i][j] = GNImageAligner.this.tempParameters[0].get(j) - GNImageAligner.this.tempParameters[i - n + 1].get(j);
                            boolean[] blArray = GNImageAligner.this.subspaceCorrelated;
                            int n2 = j;
                            blArray[n2] = blArray[n2] | GNImageAligner.this.subspaceJacobian[i][j] != 0.0;
                        }
                    }
                }
            });
            int subspaceCorrelatedCount = 0;
            for (i = 0; i < n; ++i) {
                this.subspaceResidual[i] = this.parameters.get(i) - this.tempParameters[0].get(i);
                if (!this.subspaceCorrelated[i]) continue;
                ++subspaceCorrelatedCount;
            }
            final double K = this.settings.subspaceAlpha * this.settings.subspaceAlpha * this.RMSE * this.RMSE / (double)subspaceCorrelatedCount;
            Parallel.loop(0, n + m, this.settings.numThreads, new Parallel.Looper(){

                public void loop(int from, int to, int looperID) {
                    for (int i = from; i < to; ++i) {
                        if (i < n && !GNImageAligner.this.subspaceCorrelated[i]) continue;
                        for (int j = i; j < n + m; ++j) {
                            if (j < n && !GNImageAligner.this.subspaceCorrelated[j]) continue;
                            double h = 0.0;
                            for (int k = 0; k < n; ++k) {
                                h += GNImageAligner.this.subspaceJacobian[i][k] * GNImageAligner.this.subspaceJacobian[j][k];
                            }
                            h = GNImageAligner.this.hessian.get(i, j) + K * h;
                            GNImageAligner.this.hessian.put(i, j, h);
                            GNImageAligner.this.hessian.put(j, i, h);
                        }
                        double g = 0.0;
                        for (int k = 0; k < n; ++k) {
                            g -= GNImageAligner.this.subspaceJacobian[i][k] * GNImageAligner.this.subspaceResidual[k];
                        }
                        g = GNImageAligner.this.gradient.get(i) + K * g;
                        GNImageAligner.this.gradient.put(i, g);
                    }
                }
            });
        }
    }

    private void doRoi() {
        this.doRoi(0.0);
    }

    private void doRoi(double extraPadding) {
        this.transformer.transform(this.srcRoiPts, this.dstRoiPts, this.parameters, false);
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (int i = 0; i < this.dstRoiPts.length(); ++i) {
            double x = this.dstRoiPts.get(2 * i) / (double)(1 << this.pyramidLevel);
            double y = this.dstRoiPts.get(2 * i + 1) / (double)(1 << this.pyramidLevel);
            this.dstRoiPts.put(2 * i, x);
            this.dstRoiPts.put(2 * i + 1, y);
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
        }
        opencv_core.cvSetZero(this.roiMask[this.pyramidLevel]);
        this.dstRoiPtsArray.fill((byte)16, this.dstRoiPts.get());
        opencv_core.cvFillConvexPoly(this.roiMask[this.pyramidLevel], this.dstRoiPtsArray, 4, opencv_core.CvScalar.WHITE, 8, 16);
        minX = Math.max(0.0, minX - 3.0 - (maxX - minX) * extraPadding);
        minY = Math.max(0.0, minY - 3.0 - (maxY - minY) * extraPadding);
        maxX = Math.min((double)this.roiMask[this.pyramidLevel].width(), maxX + 3.0 + (maxX - minX) * extraPadding);
        maxY = Math.min((double)this.roiMask[this.pyramidLevel].height(), maxY + 3.0 + (maxY - minY) * extraPadding);
        this.roi.x(Math.max(0, (int)Math.floor(minX / 16.0) * 16));
        this.roi.y(Math.max(0, (int)Math.floor(minY)));
        this.roi.width(Math.min(this.roiMask[this.pyramidLevel].width(), (int)Math.ceil(maxX / 16.0) * 16) - this.roi.x());
        this.roi.height(Math.min(this.roiMask[this.pyramidLevel].height(), (int)Math.ceil(maxY)) - this.roi.y());
    }

    private void doResidual() {
        this.parameters.getConstraintError();
        Parallel.loop(0, this.residualTransformerData.length, this.settings.numThreads, new Parallel.Looper(){

            public void loop(int from, int to, int looperID) {
                ImageTransformer.Data d = GNImageAligner.this.residualTransformerData[looperID][0];
                d.srcImg = GNImageAligner.this.template[GNImageAligner.this.pyramidLevel];
                d.subImg = GNImageAligner.this.target[GNImageAligner.this.pyramidLevel];
                d.srcDotImg = null;
                d.transImg = GNImageAligner.this.transformed[GNImageAligner.this.pyramidLevel];
                d.dstImg = GNImageAligner.this.residual[GNImageAligner.this.pyramidLevel];
                d.mask = GNImageAligner.this.roiMask[GNImageAligner.this.pyramidLevel];
                d.zeroThreshold = 0.0;
                d.outlierThreshold = 0.0;
                d.pyramidLevel = GNImageAligner.this.pyramidLevel;
                int y1 = GNImageAligner.this.roi.y() + looperID * GNImageAligner.this.roi.height() / GNImageAligner.this.residualTransformerData.length;
                int y2 = GNImageAligner.this.roi.y() + (looperID + 1) * GNImageAligner.this.roi.height() / GNImageAligner.this.residualTransformerData.length;
                GNImageAligner.this.subroi[looperID].x(GNImageAligner.this.roi.x());
                GNImageAligner.this.subroi[looperID].y(y1);
                GNImageAligner.this.subroi[looperID].width(GNImageAligner.this.roi.width());
                GNImageAligner.this.subroi[looperID].height(y2 - y1);
                GNImageAligner.this.transformer.transform(GNImageAligner.this.residualTransformerData[looperID], GNImageAligner.this.subroi[looperID], GNImageAligner.this.parametersArray, null);
            }
        });
        double dstDstDot = 0.0;
        double dstCount = 0.0;
        for (ImageTransformer.Data[] data : this.residualTransformerData) {
            dstDstDot += data[0].dstDstDot[0];
            dstCount += (double)data[0].dstCount;
        }
        this.RMSE = dstCount < (double)this.parameters.size() ? Double.NaN : Math.sqrt(dstDstDot / dstCount);
        this.residualUpdateNeeded = false;
    }

    public static class Settings
    extends ImageAligner.Settings
    implements Cloneable {
        double stepScale = 0.1;
        double[] lineSearch = new double[]{1.0, 0.25};
        double deltaMin = 10.0;
        double deltaMax = 300.0;
        double displacementMax = 0.15;
        double subspaceAlpha = 0.1;
        int numThreads = Parallel.numCores;

        public Settings() {
        }

        public Settings(Settings s) {
            super(s);
            this.stepScale = s.stepScale;
            this.lineSearch = s.lineSearch;
            this.deltaMin = s.deltaMin;
            this.deltaMax = s.deltaMax;
            this.displacementMax = s.displacementMax;
            this.subspaceAlpha = s.subspaceAlpha;
            this.numThreads = s.numThreads;
        }

        public double getStepScale() {
            return this.stepScale;
        }

        public void setStepScale(double stepScale) {
            this.stepScale = stepScale;
        }

        public double[] getLineSearch() {
            return this.lineSearch;
        }

        public void setLineSearch(double[] lineSearch) {
            this.lineSearch = lineSearch;
        }

        public double getDeltaMin() {
            return this.deltaMin;
        }

        public void setDeltaMin(double deltaMin) {
            this.deltaMin = deltaMin;
        }

        public double getDeltaMax() {
            return this.deltaMax;
        }

        public void setDeltaMax(double deltaMax) {
            this.deltaMax = deltaMax;
        }

        public double getDisplacementMax() {
            return this.displacementMax;
        }

        public void setDisplacementMax(double displacementMax) {
            this.displacementMax = displacementMax;
        }

        public double getSubspaceAlpha() {
            return this.subspaceAlpha;
        }

        public void setSubspaceAlpha(double subspaceAlpha) {
            this.subspaceAlpha = subspaceAlpha;
        }

        public int getNumThreads() {
            return this.numThreads;
        }

        public void setNumThreads(int numThreads) {
            this.numThreads = numThreads;
        }

        public Settings clone() {
            return new Settings(this);
        }
    }
}

