/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpijavacv;

import com.googlecode.javacv.cpp.opencv_core;
import edu.wpi.first.wpijavacv.WPIColor;
import edu.wpi.first.wpijavacv.WPIContour;
import edu.wpi.first.wpijavacv.WPIGrayscaleImage;
import edu.wpi.first.wpijavacv.WPIImage;
import edu.wpi.first.wpijavacv.WPIPoint;
import edu.wpi.first.wpijavacv.WPIPolygon;
import java.awt.image.BufferedImage;

public class WPIColorImage
extends WPIImage {
    private WPIGrayscaleImage red;
    private WPIGrayscaleImage blue;
    private WPIGrayscaleImage green;

    public WPIColorImage(BufferedImage imageSrc) {
        super(imageSrc);
    }

    WPIColorImage(opencv_core.IplImage imageSrc) {
        super(imageSrc);
    }

    public void drawContour(WPIContour c, WPIColor color, int thickness) {
        opencv_core.cvDrawContours((opencv_core.CvArr)this.image, (opencv_core.CvSeq)c.getCVSeq(), (opencv_core.CvScalar)color.toCvScalar(), (opencv_core.CvScalar)color.toCvScalar(), (int)100, (int)thickness, (int)8);
    }

    public void drawContours(WPIContour[] c, WPIColor color, int thickness) {
        for (WPIContour con : c) {
            this.drawContour(con, color, thickness);
        }
    }

    public void drawLine(WPIPoint p1, WPIPoint p2, WPIColor color, int thickness) {
        opencv_core.cvLine((opencv_core.CvArr)this.image, (opencv_core.CvPoint)p1.getCvPoint(), (opencv_core.CvPoint)p2.getCvPoint(), (opencv_core.CvScalar)color.toCvScalar(), (int)thickness, (int)8, (int)0);
    }

    public void drawPolygon(WPIPolygon p, WPIColor color, int thickness) {
        opencv_core.cvDrawContours((opencv_core.CvArr)this.image, (opencv_core.CvSeq)p.getCVSeq(), (opencv_core.CvScalar)color.toCvScalar(), (opencv_core.CvScalar)color.toCvScalar(), (int)100, (int)thickness, (int)8);
    }

    public void drawPoint(WPIPoint p, WPIColor color, int thickness) {
        opencv_core.cvDrawCircle((opencv_core.CvArr)this.image, (opencv_core.CvPoint)p.getCvPoint(), (int)thickness, (opencv_core.CvScalar)color.toCvScalar(), (int)-1, (int)8, (int)0);
    }

    public void drawPoints(WPIPoint[] p, WPIColor color, int thickness) {
        for (int i = 0; i < p.length; ++i) {
            this.drawPoint(p[i], color, thickness);
        }
    }

    public void drawPolygons(WPIPolygon[] p, WPIColor color, int thickness) {
        for (WPIPolygon polygon : p) {
            if (polygon == null || polygon.getCVSeq().isNull()) continue;
            this.drawPolygon(polygon, color, thickness);
        }
    }

    public void drawRect(int x, int y, int width, int height, WPIColor color, int thickness) {
        opencv_core.cvDrawRect((opencv_core.CvArr)this.image, (opencv_core.CvPoint)opencv_core.cvPoint((int)x, (int)y), (opencv_core.CvPoint)opencv_core.cvPoint((int)(x + width), (int)(y + height)), (opencv_core.CvScalar)color.toCvScalar(), (int)thickness, (int)8, (int)0);
    }

    private void generateChannels() {
        if (this.red == null) {
            opencv_core.IplImage redChannel = opencv_core.IplImage.create((opencv_core.CvSize)this.image.cvSize(), (int)8, (int)1);
            opencv_core.IplImage greenChannel = opencv_core.IplImage.create((opencv_core.CvSize)this.image.cvSize(), (int)8, (int)1);
            opencv_core.IplImage blueChannel = opencv_core.IplImage.create((opencv_core.CvSize)this.image.cvSize(), (int)8, (int)1);
            opencv_core.cvSplit((opencv_core.CvArr)this.image, (opencv_core.CvArr)blueChannel, (opencv_core.CvArr)greenChannel, (opencv_core.CvArr)redChannel, null);
            this.red = new WPIGrayscaleImage(redChannel);
            this.blue = new WPIGrayscaleImage(blueChannel);
            this.green = new WPIGrayscaleImage(greenChannel);
        }
    }

    public WPIGrayscaleImage getRedChannel() {
        this.generateChannels();
        return this.red;
    }

    public WPIGrayscaleImage getBlueChannel() {
        this.generateChannels();
        return this.blue;
    }

    public WPIGrayscaleImage getGreenChannel() {
        this.generateChannels();
        return this.green;
    }
}

