/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpijavacv;

import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.FFmpegFrameGrabber;
import com.googlecode.javacv.cpp.opencv_core;
import edu.wpi.first.wpijavacv.WPIColorImage;
import edu.wpi.first.wpijavacv.WPIDisposable;
import edu.wpi.first.wpijavacv.WPIGrayscaleImage;
import edu.wpi.first.wpijavacv.WPIImage;

public class WPICamera
extends WPIDisposable {
    private static final int DEFAULT_ENDING_IP = 20;
    private FFmpegFrameGrabber grabber;
    private opencv_core.IplImage image;
    private boolean readImage = true;
    private boolean badConnection = false;
    private final Object imageLock = new Object();
    private final Object grabberLock = new Object();

    public WPICamera(String loginName, String password, int team) {
        this(loginName + ":" + password + "@10." + team / 100 + "." + team % 100 + "." + 20);
    }

    public WPICamera(int team) {
        this("10." + team / 100 + "." + team % 100 + "." + 20);
    }

    public WPICamera(String loginName, String password, String ip) {
        this(loginName + ":" + password + "@" + ip);
    }

    public WPICamera(String ip) {
        final String path = "http://" + ip + "/mjpg/video.mjpg";
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                WPICamera.this.grabber = new FFmpegFrameGrabber(path);
                try {
                    WPICamera.this.grabber.start();
                    while (!WPICamera.this.isDisposed()) {
                        Object object;
                        try {
                            opencv_core.IplImage newest;
                            object = WPICamera.this.grabberLock;
                            synchronized (object) {
                                if (WPICamera.this.isDisposed()) {
                                    return;
                                }
                                newest = WPICamera.this.grabber.grab();
                            }
                            if (WPIDisposable.isNull((Pointer)newest)) {
                                object = WPICamera.this.imageLock;
                                synchronized (object) {
                                    WPICamera.this.badConnection = true;
                                    WPICamera.this.imageLock.notify();
                                }
                                return;
                            }
                            object = WPICamera.this.imageLock;
                            synchronized (object) {
                                if (WPICamera.this.image == null) {
                                    WPICamera.this.image = opencv_core.cvCreateImage((opencv_core.CvSize)newest.cvSize(), (int)newest.depth(), (int)newest.nChannels());
                                }
                                opencv_core.cvCopy((opencv_core.CvArr)newest, (opencv_core.CvArr)WPICamera.this.image);
                                WPICamera.this.readImage = false;
                                WPICamera.this.badConnection = false;
                                WPICamera.this.imageLock.notify();
                            }
                        }
                        catch (Exception ex) {
                            object = WPICamera.this.imageLock;
                            synchronized (object) {
                                WPICamera.this.badConnection = true;
                                WPICamera.this.imageLock.notify();
                            }
                            ex.printStackTrace();
                            return;
                        }
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                catch (Exception ex) {
                    Object object = WPICamera.this.imageLock;
                    synchronized (object) {
                        WPICamera.this.badConnection = true;
                        WPICamera.this.imageLock.notify();
                    }
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WPIImage getImage() throws BadConnectionException {
        this.validateDisposed();
        Object object = this.imageLock;
        synchronized (object) {
            if (this.badConnection) {
                throw new BadConnectionException();
            }
            if (this.image == null) {
                return null;
            }
            if (this.image.nChannels() == 1) {
                return new WPIGrayscaleImage(this.image.clone());
            }
            assert (this.image.nChannels() == 3);
            return new WPIColorImage(this.image.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WPIImage getNewImage(double timeout) throws BadConnectionException {
        this.validateDisposed();
        this.readImage = true;
        Object object = this.imageLock;
        synchronized (object) {
            while (this.readImage && !this.badConnection) {
                try {
                    this.badConnection = true;
                    this.imageLock.wait((long)(timeout * 1000.0));
                }
                catch (InterruptedException ex) {}
            }
            this.readImage = true;
            if (this.badConnection) {
                throw new BadConnectionException();
            }
            if (this.image.nChannels() == 1) {
                return new WPIGrayscaleImage(this.image.clone());
            }
            assert (this.image.nChannels() == 3);
            return new WPIColorImage(this.image.clone());
        }
    }

    public WPIImage getNewImage() throws BadConnectionException {
        return this.getNewImage(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposed() {
        try {
            Object object = this.imageLock;
            synchronized (object) {
                if (!WPICamera.isNull((Pointer)this.image)) {
                    this.image.release();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.grabber.stop();
        super.finalize();
    }

    public static class BadConnectionException
    extends Exception {
    }
}

