/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.annotation.Opaque;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@Opaque
public class Pointer {
    static final ReferenceQueue<Pointer> referenceQueue = new ReferenceQueue();
    protected long address;
    protected int position;
    private Deallocator deallocator;

    public Pointer() {
    }

    public Pointer(Pointer p) {
        if (p == null) {
            this.address = 0L;
            this.position = 0;
        } else {
            this.address = p.address;
            this.position = p.position;
        }
    }

    void init(long allocatedAddress, long deallocatorAddress) {
        this.address = allocatedAddress;
        this.deallocator(new ReferenceDeallocator(this, allocatedAddress, deallocatorAddress));
    }

    public boolean isNull() {
        return this.address == 0L;
    }

    public void setNull() {
        this.address = 0L;
    }

    public int position() {
        return this.position;
    }

    public Pointer position(int position) {
        this.position = position;
        return this;
    }

    protected Deallocator deallocator() {
        return this.deallocator;
    }

    protected Pointer deallocator(Deallocator deallocator) {
        this.deallocator = deallocator;
        DeallocatorReference r = null;
        while ((r = (DeallocatorReference)referenceQueue.poll()) != null) {
            r.clear();
            r.remove();
        }
        r = deallocator instanceof DeallocatorReference ? (DeallocatorReference)((Object)deallocator) : new DeallocatorReference(this, deallocator);
        r.add();
        return this;
    }

    public void deallocate() {
        this.deallocator.deallocate();
        this.address = 0L;
    }

    private native ByteBuffer asDirectBuffer(int var1);

    public ByteBuffer asByteBuffer(int capacity) {
        if (this.isNull()) {
            return null;
        }
        int valueSize = 1;
        try {
            Class<?> c = this.getClass();
            if (c != Pointer.class) {
                valueSize = Loader.sizeof(c);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        int arrayPosition = this.position;
        this.position = valueSize * arrayPosition;
        ByteBuffer b = this.asDirectBuffer(valueSize * capacity).order(ByteOrder.nativeOrder());
        this.position = arrayPosition;
        return b;
    }

    public Buffer asBuffer(int capacity) {
        return this.asByteBuffer(capacity);
    }

    public boolean equals(Object obj) {
        if (obj == null && this.isNull()) {
            return true;
        }
        if (!(obj instanceof Pointer)) {
            return false;
        }
        Pointer other = (Pointer)obj;
        return this.address == other.address && this.position == other.position;
    }

    public int hashCode() {
        return (int)this.address;
    }

    public String toString() {
        return this.getClass().getName() + "[address=0x" + Long.toHexString(this.address) + ",position=" + this.position + ",deallocator=" + this.deallocator + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DeallocatorReference
    extends PhantomReference<Pointer> {
        static DeallocatorReference head = null;
        DeallocatorReference prev = null;
        DeallocatorReference next = null;
        Deallocator deallocator;

        DeallocatorReference(Pointer p, Deallocator deallocator) {
            super(p, referenceQueue);
            this.deallocator = deallocator;
        }

        final synchronized void add() {
            if (head == null) {
                head = this;
            } else {
                this.next = head;
                this.next.prev = head = this;
            }
        }

        final synchronized void remove() {
            if (this.prev == this && this.next == this) {
                return;
            }
            if (this.prev == null) {
                head = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            this.prev = this.next = this;
        }

        @Override
        public void clear() {
            super.clear();
            this.deallocator.deallocate();
        }
    }

    static class ReferenceDeallocator
    extends DeallocatorReference
    implements Deallocator {
        private long allocatedAddress;
        private long deallocatorAddress;

        ReferenceDeallocator(Pointer p, long allocatedAddress, long deallocatorAddress) {
            super(p, (Deallocator)null);
            this.deallocator = this;
            this.allocatedAddress = allocatedAddress;
            this.deallocatorAddress = deallocatorAddress;
        }

        public void deallocate() {
            if (this.allocatedAddress != 0L && this.deallocatorAddress != 0L) {
                this.deallocate(this.allocatedAddress, this.deallocatorAddress);
                this.deallocatorAddress = 0L;
                this.allocatedAddress = 0L;
            }
        }

        private native void deallocate(long var1, long var3);
    }

    protected static interface Deallocator {
        public void deallocate();
    }
}

