/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.CLongPointer;
import com.googlecode.javacpp.CharPointer;
import com.googlecode.javacpp.DoublePointer;
import com.googlecode.javacpp.FloatPointer;
import com.googlecode.javacpp.FunctionPointer;
import com.googlecode.javacpp.IntPointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.LongPointer;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacpp.ShortPointer;
import com.googlecode.javacpp.SizeTPointer;
import com.googlecode.javacpp.annotation.Allocator;
import com.googlecode.javacpp.annotation.ArrayAllocator;
import com.googlecode.javacpp.annotation.ByPtr;
import com.googlecode.javacpp.annotation.ByPtrPtr;
import com.googlecode.javacpp.annotation.ByPtrRef;
import com.googlecode.javacpp.annotation.ByRef;
import com.googlecode.javacpp.annotation.ByVal;
import com.googlecode.javacpp.annotation.Cast;
import com.googlecode.javacpp.annotation.Convention;
import com.googlecode.javacpp.annotation.Function;
import com.googlecode.javacpp.annotation.MemberGetter;
import com.googlecode.javacpp.annotation.MemberSetter;
import com.googlecode.javacpp.annotation.Name;
import com.googlecode.javacpp.annotation.Namespace;
import com.googlecode.javacpp.annotation.NoOffset;
import com.googlecode.javacpp.annotation.Opaque;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.Properties;
import com.googlecode.javacpp.annotation.ValueGetter;
import com.googlecode.javacpp.annotation.ValueSetter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
implements Closeable {
    public static final String JNI_VERSION = "JNI_VERSION_1_4";
    private static final Logger logger = Logger.getLogger(Generator.class.getName());
    private java.util.Properties properties;
    private File file;
    private PrintWriter writer;
    private PrintWriter out;
    private LinkedListRegister<String> functionDefinitions;
    private LinkedListRegister<String> functionPointers;
    private LinkedListRegister<Class> deallocators;
    private LinkedListRegister<Class> arrayDeallocators;
    private LinkedListRegister<Class> jclasses;
    private HashMap<Class, LinkedList<String>> members;
    private boolean generatedSomethingUseful;

    public Generator(java.util.Properties properties, String filename) {
        this(properties, new File(filename));
    }

    public Generator(java.util.Properties properties, File file) {
        this.properties = properties;
        this.file = file;
        this.writer = null;
    }

    public Generator(java.util.Properties properties, PrintWriter writer) {
        this.properties = properties;
        this.file = null;
        this.writer = writer;
    }

    public boolean generate(Class<?> ... classes) throws FileNotFoundException {
        this.out = new PrintWriter(new Writer(){

            public void close() {
            }

            public void flush() {
            }

            public void write(char[] cbuf, int off, int len) {
            }
        });
        this.functionDefinitions = new LinkedListRegister();
        this.functionPointers = new LinkedListRegister();
        this.deallocators = new LinkedListRegister();
        this.arrayDeallocators = new LinkedListRegister();
        this.jclasses = new LinkedListRegister();
        this.members = new HashMap();
        this.doClasses(classes);
        if (this.generatedSomethingUseful) {
            this.out = this.writer != null ? this.writer : new PrintWriter(this.file);
            this.doClasses(classes);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.close();
        }
    }

    private void doClasses(Class<?> ... classes) {
        this.out.println("/* DO NOT EDIT THIS FILE - IT IS MACHINE GENERATED */");
        this.out.println();
        String define = this.properties.getProperty("generator.define");
        if (define != null && define.length() > 0) {
            for (String s : define.split("\u0000")) {
                this.out.println("#define " + s);
            }
            this.out.println();
        }
        String[] include = new String[]{this.properties.getProperty("generator.include"), this.properties.getProperty("generator.cinclude")};
        for (int i = 0; i < include.length; ++i) {
            if (include[i] == null || include[i].length() <= 0) continue;
            if (i == 1) {
                this.out.println("extern \"C\" {");
            }
            for (String s : include[i].split("\u0000")) {
                char[] chars = s.toCharArray();
                this.out.print("#include ");
                char c = chars[0];
                if (c != '<' && c != '\"') {
                    this.out.print('\"');
                }
                this.out.print(chars);
                c = chars[chars.length - 1];
                if (c != '>' && c != '\"') {
                    this.out.print('\"');
                }
                this.out.println();
            }
            if (i == 1) {
                this.out.println("}");
            }
            this.out.println();
        }
        this.out.println("#ifdef _WIN32");
        this.out.println("    #define _JAVASOFT_JNI_MD_H_");
        this.out.println();
        this.out.println("    #define JNIEXPORT __declspec(dllexport)");
        this.out.println("    #define JNIIMPORT __declspec(dllimport)");
        this.out.println("    #define JNICALL __stdcall");
        this.out.println();
        this.out.println("    typedef int jint;");
        this.out.println("    typedef __int64 jlong;");
        this.out.println("    typedef signed char jbyte;");
        this.out.println("#endif");
        this.out.println("#include <jni.h>");
        this.out.println("#include <stddef.h>");
        this.out.println("#ifndef _WIN32");
        this.out.println("    #include <stdint.h>");
        this.out.println("#endif");
        this.out.println("#include <stdio.h>");
        this.out.println("#include <stdlib.h>");
        this.out.println("#include <string.h>");
        this.out.println("#include <exception>");
        this.out.println();
        this.out.println("#define jlong_to_ptr(a) ((void*)(uintptr_t)(a))");
        this.out.println("#define ptr_to_jlong(a) ((jlong)(uintptr_t)(a))");
        this.out.println("#ifdef ANDROID");
        this.out.println("    #define NewWeakGlobalRef(o) NewGlobalRef(o)");
        this.out.println("    #define DeleteWeakGlobalRef(o) DeleteGlobalRef(o)");
        this.out.println("#endif");
        this.out.println();
        this.out.println("#if defined(_MSC_VER)");
        this.out.println("    #define noinline __declspec(noinline)");
        this.out.println("#elif defined(__GNUC__)");
        this.out.println("    #define noinline __attribute__((noinline))");
        this.out.println("#else");
        this.out.println("    #define noinline");
        this.out.println("#endif");
        this.out.println();
        this.out.println("extern \"C\" {");
        this.out.println();
        for (String s : this.functionDefinitions) {
            this.out.println(s);
        }
        this.out.println();
        for (String s : this.functionPointers) {
            this.out.println("static jobject " + s + " = NULL;");
        }
        this.out.println();
        for (Class c : this.deallocators) {
            String mangledName = Generator.mangle(c.getName());
            String typeName = Generator.getCPPTypeName(c);
            this.out.println("static void JavaCPP_" + mangledName + "_deallocate(" + typeName + " address) {");
            this.out.println("    delete address;");
            this.out.println("}");
        }
        for (Class c : this.arrayDeallocators) {
            String mangledName = Generator.mangle(c.getName());
            String typeName = Generator.getCPPTypeName(c);
            this.out.println("static void JavaCPP_" + mangledName + "_deallocateArray(" + typeName + " address) {");
            this.out.println("    delete[] address;");
            this.out.println("}");
        }
        this.out.println();
        this.out.println("static JavaVM *JavaCPP_vm = NULL;");
        this.out.println("static const char *JavaCPP_classNames[" + this.jclasses.size() + "] = {");
        Iterator classIterator = this.jclasses.iterator();
        int maxMemberSize = 0;
        while (classIterator.hasNext()) {
            LinkedList<String> m;
            Class c = (Class)classIterator.next();
            this.out.print("        \"" + c.getName().replace('.', '/') + "\"");
            if (classIterator.hasNext()) {
                this.out.println(",");
            }
            if ((m = this.members.get(c)) == null || m.size() <= maxMemberSize) continue;
            maxMemberSize = m.size();
        }
        this.out.println(" };");
        this.out.println("static jclass JavaCPP_classes[" + this.jclasses.size() + "] = { NULL };");
        this.out.println("static jmethodID JavaCPP_initMethodID = NULL;");
        this.out.println("static jfieldID JavaCPP_addressFieldID = NULL;");
        this.out.println("static jfieldID JavaCPP_positionFieldID = NULL;");
        this.out.println();
        this.out.println("static noinline jclass JavaCPP_getClass(JNIEnv *e, int i) {");
        this.out.println("    if (JavaCPP_classes[i] == NULL) {");
        this.out.println("        jclass c = e->FindClass(JavaCPP_classNames[i]);");
        this.out.println("        if (c == NULL || e->ExceptionCheck()) {");
        this.out.println("            fprintf(stderr, \"Error loading class %s.\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("        JavaCPP_classes[i] = (jclass)e->NewWeakGlobalRef(c);");
        this.out.println("        if (JavaCPP_classes[i] == NULL || e->ExceptionCheck()) {");
        this.out.println("            fprintf(stderr, \"Error creating global reference of class %s.\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    return JavaCPP_classes[i];");
        this.out.println("}");
        this.out.println();
        this.out.println("static noinline void JavaCPP_handleException(JNIEnv *e) {");
        this.out.println("    try {");
        this.out.println("        throw;");
        this.out.println("    } catch (std::exception& ex) {");
        this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(RuntimeException.class) + "), ex.what());");
        this.out.println("    } catch (...) {");
        this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(RuntimeException.class) + "), \"Unknown exception.\");");
        this.out.println("    }");
        this.out.println("}");
        this.out.println();
        this.out.println("static inline int JavaCPP_checkNull(JNIEnv *e, uintptr_t pointer) {");
        this.out.println("    if (pointer == 0) {");
        this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(NullPointerException.class) + "), \"Pointer address is NULL.\");");
        this.out.println("        return 1;");
        this.out.println("    }");
        this.out.println("    return 0;");
        this.out.println("}");
        this.out.println();
        this.out.println("JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM *vm, void *reserved) {");
        this.out.println("    JavaCPP_vm = vm;");
        this.out.println("    JNIEnv* e;");
        this.out.println("    if (vm->GetEnv((void**)&e, JNI_VERSION_1_4) != JNI_OK) {");
        this.out.println("        fprintf(stderr, \"Could not get JNIEnv for JNI_VERSION_1_4 inside JNI_OnLoad().\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    const char *members[" + this.jclasses.size() + "][" + maxMemberSize + "] = {");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            Iterator memberIterator;
            this.out.print("            { ");
            LinkedList<String> m = this.members.get(classIterator.next());
            Iterator iterator = memberIterator = m == null ? null : m.iterator();
            while (memberIterator != null && memberIterator.hasNext()) {
                this.out.print("\"" + (String)memberIterator.next() + "\"");
                if (!memberIterator.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print(" }");
            if (!classIterator.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(" };");
        this.out.println("    int offsets[" + this.jclasses.size() + "][" + maxMemberSize + "] = {");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            Iterator memberIterator;
            this.out.print("            { ");
            Class c = (Class)classIterator.next();
            LinkedList<String> m = this.members.get(c);
            Iterator iterator = memberIterator = m == null ? null : m.iterator();
            while (memberIterator != null && memberIterator.hasNext()) {
                String typeName = Generator.getCPPTypeName(c);
                String valueTypeName = typeName.substring(0, typeName.length() - 1);
                String memberName = (String)memberIterator.next();
                if ("sizeof".equals(memberName)) {
                    if ("void".equals(valueTypeName)) {
                        valueTypeName = "void*";
                    }
                    this.out.print("sizeof(" + valueTypeName + ")");
                } else {
                    this.out.print("offsetof(" + valueTypeName + "," + memberName + ")");
                }
                if (!memberIterator.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print(" }");
            if (!classIterator.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(" };");
        this.out.print("    int memberOffsetSizes[" + this.jclasses.size() + "] = { ");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            LinkedList<String> m = this.members.get(classIterator.next());
            this.out.print(m == null ? "0" : Integer.valueOf(m.size()));
            if (!classIterator.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.println(" };");
        this.out.println("    jmethodID putMemberOffsetMethodID = e->GetStaticMethodID(JavaCPP_getClass(e, " + this.jclasses.register(Loader.class) + "), \"putMemberOffset\", \"(Ljava/lang/String;Ljava/lang/String;I)V\");");
        this.out.println("    if (putMemberOffsetMethodID == NULL || e->ExceptionCheck()) {");
        this.out.println("        fprintf(stderr, \"Error getting putMemberOffset method ID of Loader class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    for (int i = 0; i < " + this.jclasses.size() + " && !e->ExceptionCheck(); i++) {");
        this.out.println("        for (int j = 0; j < memberOffsetSizes[i] && !e->ExceptionCheck(); j++) {");
        this.out.println("            if (e->PushLocalFrame(2) == 0) {");
        this.out.println("                jvalue args[3];");
        this.out.println("                args[0].l = e->NewStringUTF(JavaCPP_classNames[i]);");
        this.out.println("                args[1].l = e->NewStringUTF(members[i][j]);");
        this.out.println("                args[2].i = offsets[i][j];");
        this.out.println("                e->CallStaticVoidMethodA(JavaCPP_getClass(e, " + this.jclasses.register(Loader.class) + "), putMemberOffsetMethodID, args);");
        this.out.println("                e->PopLocalFrame(NULL);");
        this.out.println("            }");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    JavaCPP_initMethodID = e->GetMethodID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"init\", \"(JJ)V\");");
        this.out.println("    if (JavaCPP_initMethodID == NULL || e->ExceptionCheck()) {");
        this.out.println("        fprintf(stderr, \"Error getting init method ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    JavaCPP_addressFieldID = e->GetFieldID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"address\", \"J\");");
        this.out.println("    if (JavaCPP_addressFieldID == NULL || e->ExceptionCheck()) {");
        this.out.println("        fprintf(stderr, \"Error getting address field ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    JavaCPP_positionFieldID = e->GetFieldID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"position\", \"I\");");
        this.out.println("    if (JavaCPP_positionFieldID == NULL || e->ExceptionCheck()) {");
        this.out.println("        fprintf(stderr, \"Error getting position field ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    return e->GetVersion();");
        this.out.println("}");
        this.out.println();
        this.out.println("JNIEXPORT void JNICALL JNI_OnUnload(JavaVM *vm, void *reserved) {");
        this.out.println("    JNIEnv* e;");
        this.out.println("    if (vm->GetEnv((void**)&e, JNI_VERSION_1_4) != JNI_OK) {");
        this.out.println("        fprintf(stderr, \"Could not get JNIEnv for JNI_VERSION_1_4 inside JNI_OnUnLoad().\");");
        this.out.println("        return;");
        this.out.println("    }");
        for (String s : this.functionPointers) {
            this.out.println("    e->DeleteGlobalRef(" + s + ");");
        }
        this.out.println("    for (int i = 0; i < " + this.jclasses.size() + "; i++) {");
        this.out.println("        e->DeleteWeakGlobalRef(JavaCPP_classes[i]);");
        this.out.println("    }");
        this.out.println("}");
        this.out.println();
        this.doMethods(Pointer.class);
        this.doMethods(BytePointer.class);
        this.doMethods(ShortPointer.class);
        this.doMethods(IntPointer.class);
        this.doMethods(LongPointer.class);
        this.doMethods(FloatPointer.class);
        this.doMethods(DoublePointer.class);
        this.doMethods(CharPointer.class);
        this.doMethods(PointerPointer.class);
        this.doMethods(CLongPointer.class);
        this.doMethods(SizeTPointer.class);
        this.generatedSomethingUseful = false;
        for (Class<?> cls : classes) {
            this.doMethods(cls);
        }
        this.out.println("}");
        this.out.println();
    }

    private void doMethods(Class<?> cls) {
        Properties classProperties = cls.getAnnotation(Properties.class);
        boolean platformMatches = false;
        if (classProperties != null) {
            for (Platform p : classProperties.value()) {
                if (!this.checkPlatform(p)) continue;
                platformMatches = true;
            }
        } else if (this.checkPlatform(cls.getAnnotation(Platform.class))) {
            platformMatches = true;
        }
        if (!platformMatches) {
            return;
        }
        this.generatedSomethingUseful = true;
        LinkedList<String> memberList = this.members.get(cls);
        if (!(cls.isAnnotationPresent(Opaque.class) && cls != Pointer.class || FunctionPointer.class.isAssignableFrom(cls) || cls.isAnnotationPresent(NoOffset.class))) {
            if (memberList == null) {
                memberList = new LinkedList();
                this.members.put(cls, memberList);
            }
            if (!memberList.contains("sizeof")) {
                memberList.add("sizeof");
            }
        }
        Class<?>[] classes = cls.getDeclaredClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!Pointer.class.isAssignableFrom(classes[i]) && !Pointer.Deallocator.class.isAssignableFrom(classes[i])) continue;
            this.doMethods(classes[i]);
        }
        Method[] methods = cls.getDeclaredMethods();
        boolean[] callbackAllocators = new boolean[methods.length];
        Method functionMethod = this.doFunctionDefinitions(cls, callbackAllocators);
        for (int i = 0; i < methods.length; ++i) {
            MethodInformation methodInfo;
            if (!this.checkPlatform(methods[i].getAnnotation(Platform.class)) || (methodInfo = Generator.getMethodInformation(methods[i])) == null) continue;
            String baseFunctionName = Generator.mangle(cls.getName()) + "_" + Generator.mangle(methodInfo.name);
            if (!(!methodInfo.memberGetter && !methodInfo.memberSetter || methodInfo.noOffset || memberList == null || Modifier.isStatic(methodInfo.modifiers) || memberList.contains(methodInfo.memberName))) {
                memberList.add(methodInfo.memberName);
            }
            if (callbackAllocators[i]) {
                this.doCallback(cls, functionMethod, baseFunctionName);
            }
            this.out.print("JNIEXPORT " + Generator.getJNITypeName(methodInfo.returnType) + " JNICALL Java_" + baseFunctionName);
            if (methodInfo.overloaded) {
                this.out.print("__" + Generator.mangle(Generator.getSignature(methodInfo.parameterTypes)));
            }
            if (Modifier.isStatic(methodInfo.modifiers)) {
                this.out.print("(JNIEnv *e, jclass c");
            } else {
                this.out.print("(JNIEnv *e, jobject o");
            }
            for (int j = 0; j < methodInfo.parameterTypes.length; ++j) {
                this.out.print(", " + Generator.getJNITypeName(methodInfo.parameterTypes[j]) + " p" + j);
            }
            this.out.println(") {");
            if (callbackAllocators[i]) {
                this.doCallbackAllocator(cls, functionMethod, baseFunctionName);
                continue;
            }
            if (!(Modifier.isStatic(methodInfo.modifiers) || methodInfo.allocator || methodInfo.arrayAllocator || methodInfo.deallocator)) {
                String typeName = Generator.getCPPTypeName(cls);
                String thisType = methodInfo.bufferGetter && "void*".equals(typeName) ? "char*" : typeName;
                this.out.println("    " + thisType + " pointer = (" + thisType + ")" + "jlong_to_ptr(e->GetLongField(o, JavaCPP_addressFieldID));");
                this.out.println("    if (JavaCPP_checkNull(e, (uintptr_t)pointer)) {");
                this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                this.out.println("    }");
                if (!cls.isAnnotationPresent(Opaque.class) || methodInfo.bufferGetter) {
                    this.out.println("    jint position = e->GetIntField(o, JavaCPP_positionFieldID);");
                    if (FunctionPointer.class.isAssignableFrom(cls)) {
                        this.out.println("    pointer = position == 0 ? pointer : (" + thisType + ")((uintptr_t)pointer + position);");
                    } else {
                        this.out.println("    pointer += position;");
                    }
                }
            }
            boolean[] hasPointer = new boolean[methodInfo.parameterTypes.length];
            boolean[] mayChange = new boolean[methodInfo.parameterTypes.length];
            this.doParametersBefore(methodInfo, hasPointer, mayChange);
            String returnVariable = this.doReturnBefore(cls, methodInfo);
            boolean needsCatchBlock = this.doMainOperation(cls, methodInfo, returnVariable, hasPointer);
            this.doReturnAfter(cls, methodInfo, needsCatchBlock);
            this.doParametersAfter(methodInfo, needsCatchBlock, mayChange);
            if (methodInfo.returnType != Void.TYPE) {
                this.out.println("    return r;");
            }
            this.out.println("}");
        }
        this.out.println();
    }

    private void doParametersBefore(MethodInformation methodInfo, boolean[] hasPointer, boolean[] mayChange) {
        for (int j = 0; j < methodInfo.parameterTypes.length; ++j) {
            Class<? extends Annotation> passBy = Generator.getBy(methodInfo.parameterAnnotations[j]);
            if (passBy == null && methodInfo.pairedMethod != null && (methodInfo.valueSetter || methodInfo.memberSetter)) {
                passBy = Generator.getBy(methodInfo.pairedMethod.getAnnotations());
            }
            hasPointer[j] = true;
            String typeName = Generator.getCPPTypeName(methodInfo.parameterTypes[j]);
            if (Pointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.out.println("    " + typeName + " pointer" + j + " = p" + j + " == NULL ? NULL : (" + typeName + ")jlong_to_ptr(e->GetLongField(p" + j + ", JavaCPP_addressFieldID));");
                if (!methodInfo.parameterTypes[j].isAnnotationPresent(Opaque.class) && passBy != ByPtrPtr.class && passBy != ByPtrRef.class) {
                    this.out.println("    jint position" + j + " = p" + j + " == NULL ? 0 : e->GetIntField(p" + j + ", JavaCPP_positionFieldID);");
                    if (FunctionPointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                        this.out.println("    pointer" + j + " = position" + j + " == 0 ? pointer" + j + " : (" + typeName + ")((uintptr_t)pointer" + j + " + position" + j + ");");
                        continue;
                    }
                    this.out.println("    pointer" + j + " += position" + j + ";");
                    continue;
                }
                if (passBy != ByPtrPtr.class && passBy != ByPtrRef.class) continue;
                mayChange[j] = true;
                continue;
            }
            if (methodInfo.parameterTypes[j] == String.class) {
                this.out.println("    const char *pointer" + j + " = p" + j + " == NULL ? NULL : e->GetStringUTFChars(p" + j + ", NULL);");
                continue;
            }
            if (methodInfo.parameterTypes[j].isArray()) {
                Class<?> t = methodInfo.parameterTypes[j].getComponentType();
                String s = t.getName();
                s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
                this.out.println("    " + Generator.getJNITypeName(t) + " *pointer" + j + " = p" + j + " == NULL ? NULL : e->Get" + s + "ArrayElements(p" + j + ", NULL);");
                continue;
            }
            if (Buffer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.out.println("    " + typeName + " pointer" + j + " = p" + j + " == NULL ? NULL : (" + typeName + ")e->GetDirectBufferAddress(p" + j + ");");
                continue;
            }
            if (methodInfo.parameterTypes[j].isPrimitive()) {
                hasPointer[j] = false;
                continue;
            }
            logger.log(Level.WARNING, "Method \"" + methodInfo.method + "\" has unsupported parameter type \"" + methodInfo.parameterTypes[j].getCanonicalName() + "\". Compilation will most likely fail.");
        }
    }

    private String doReturnBefore(Class cls, MethodInformation methodInfo) {
        String returnVariable = "";
        if (methodInfo.returnType == Void.TYPE) {
            String typeName = Generator.getCPPTypeName(cls);
            if (methodInfo.allocator || methodInfo.arrayAllocator) {
                this.out.println("    if (!e->IsSameObject(e->GetObjectClass(o), JavaCPP_getClass(e, " + this.jclasses.register(cls) + "))) {");
                this.out.println("        return;");
                this.out.println("    }");
                this.out.println("    " + typeName + " rpointer;");
                returnVariable = "rpointer = ";
            }
        } else {
            String[] typeName = Generator.getAnnotatedCPPTypeName(methodInfo.annotations, methodInfo.returnType);
            if (methodInfo.valueSetter || methodInfo.memberSetter) {
                this.out.println("    jobject r = o;");
            } else if (methodInfo.returnType == String.class) {
                this.out.println("    jstring r = NULL;");
                this.out.println("    const char *rpointer;");
                returnVariable = "rpointer = ";
            } else if (methodInfo.bufferGetter) {
                this.out.println("    jobject r = NULL;");
                this.out.println("    char *rpointer;");
                returnVariable = "rpointer = ";
            } else if (Pointer.class.isAssignableFrom(methodInfo.returnType)) {
                Class<? extends Annotation> returnBy = Generator.getBy(methodInfo.annotations);
                this.out.println("    jobject r = NULL;");
                if (returnBy == ByVal.class) {
                    this.out.println("    " + typeName[0] + "* rpointer" + typeName[1] + ";");
                    returnVariable = methodInfo.valueGetter || methodInfo.memberGetter ? "rpointer = &" : "rpointer = new " + typeName[0] + typeName[1] + "(";
                } else if (returnBy == ByRef.class) {
                    String valueTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                    this.out.println("    " + valueTypeName + "* rpointer" + typeName[1] + ";");
                    returnVariable = "rpointer = &";
                } else if (returnBy == ByPtrPtr.class) {
                    String pointerTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                    this.out.println("    " + pointerTypeName + " rpointer" + typeName[1] + ";");
                    returnVariable = "rpointer = *";
                } else if (returnBy == ByPtrRef.class) {
                    String pointerTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                    this.out.println("    " + pointerTypeName + " rpointer" + typeName[1] + ";");
                    returnVariable = "rpointer = ";
                } else {
                    this.out.println("    " + typeName[0] + " rpointer" + typeName[1] + ";");
                    returnVariable = "rpointer = ";
                }
            } else if (methodInfo.returnType.isPrimitive()) {
                this.out.println("    " + Generator.getJNITypeName(methodInfo.returnType) + " r = 0;");
                this.out.println("    " + typeName[0] + " rvalue" + typeName[1] + ";");
                returnVariable = "rvalue = ";
            } else {
                logger.log(Level.WARNING, "Method \"" + methodInfo.method + "\" has unsupported return type \"" + methodInfo.returnType.getCanonicalName() + "\". Compilation will most likely fail.");
            }
        }
        return returnVariable;
    }

    private boolean doMainOperation(Class<?> cls, MethodInformation methodInfo, String returnVariable, boolean[] hasPointer) {
        Class<? extends Annotation> returnBy;
        boolean needsCatchBlock = false;
        String typeName = Generator.getCPPTypeName(cls);
        String valueTypeName = typeName.substring(0, typeName.length() - 1);
        String suffix = ");";
        if (methodInfo.deallocator) {
            this.out.println("    void *allocatedAddress = jlong_to_ptr(p0);");
            this.out.println("    void (*deallocatorAddress)(void *) = (void(*)(void*))jlong_to_ptr(p1);");
            this.out.println("    if (deallocatorAddress != NULL && allocatedAddress != NULL) {");
            this.out.println("        (*deallocatorAddress)(allocatedAddress);");
            this.out.println("    }");
            return false;
        }
        if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
            this.out.print("    " + returnVariable);
            if ((methodInfo.valueSetter || methodInfo.memberSetter) && String.class == methodInfo.parameterTypes[methodInfo.parameterTypes.length - 1]) {
                this.out.print("strcpy(");
                suffix = ");";
            } else {
                suffix = ";";
            }
            if (Modifier.isStatic(methodInfo.modifiers)) {
                this.out.print(methodInfo.memberName);
            } else if (methodInfo.memberGetter || methodInfo.memberSetter) {
                this.out.print("pointer->" + methodInfo.memberName);
            } else {
                this.out.print("*pointer");
            }
        } else if (methodInfo.bufferGetter) {
            this.out.println("    " + returnVariable + "pointer;");
            this.out.print("    jlong capacity = ");
            suffix = ";";
        } else {
            this.out.println("    try {");
            needsCatchBlock = true;
            this.out.print("        " + returnVariable);
            if (FunctionPointer.class.isAssignableFrom(cls)) {
                this.out.print("(*pointer)(");
            } else if (methodInfo.allocator) {
                this.out.print("new " + valueTypeName + (methodInfo.arrayAllocator ? "[" : "("));
                suffix = methodInfo.arrayAllocator ? "];" : ");";
            } else if (Modifier.isStatic(methodInfo.modifiers)) {
                if (valueTypeName.length() > 0) {
                    valueTypeName = valueTypeName + "::";
                }
                this.out.print(valueTypeName + methodInfo.memberName + "(");
            } else {
                this.out.print("pointer->" + methodInfo.memberName + "(");
            }
        }
        for (int j = 0; j < methodInfo.parameterTypes.length; ++j) {
            if ((methodInfo.memberSetter || methodInfo.valueSetter) && j >= methodInfo.parameterTypes.length - 1) {
                if (methodInfo.memberNameSuffix != null) {
                    this.out.print(methodInfo.memberNameSuffix);
                }
                if (String.class == methodInfo.parameterTypes[methodInfo.parameterTypes.length - 1]) {
                    this.out.print(", ");
                } else {
                    this.out.print(" = ");
                }
            } else if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
                this.out.print("[p" + j + "]");
                continue;
            }
            String cast = Generator.getCast(methodInfo.parameterAnnotations[j]);
            if ((cast == null || cast.length() == 0) && methodInfo.pairedMethod != null && (methodInfo.valueSetter || methodInfo.memberSetter)) {
                cast = Generator.getCast(methodInfo.pairedMethod.getAnnotations());
            }
            if (("(void*)".equals(cast) || "(void *)".equals(cast)) && methodInfo.parameterTypes[j] == Long.TYPE) {
                this.out.print("jlong_to_ptr(p" + j + ")");
            } else if (hasPointer[j]) {
                Class<? extends Annotation> passBy = Generator.getBy(methodInfo.parameterAnnotations[j]);
                if (passBy == null && methodInfo.pairedMethod != null && (methodInfo.valueSetter || methodInfo.memberSetter)) {
                    passBy = Generator.getBy(methodInfo.pairedMethod.getAnnotations());
                }
                if (passBy == ByVal.class || passBy == ByRef.class) {
                    this.out.print("*" + cast + "pointer" + j);
                } else if (passBy == ByPtrPtr.class) {
                    this.out.print(cast + "&pointer" + j);
                } else {
                    this.out.print(cast + "pointer" + j);
                }
            } else {
                this.out.print(cast + "p" + j);
            }
            if (j >= methodInfo.parameterTypes.length - 1) continue;
            this.out.print(", ");
        }
        if (!methodInfo.memberSetter && !methodInfo.valueSetter && methodInfo.memberNameSuffix != null) {
            this.out.print(methodInfo.memberNameSuffix);
        }
        if (!((returnBy = Generator.getBy(methodInfo.annotations)) != ByVal.class || methodInfo.valueGetter || methodInfo.memberGetter || methodInfo.bufferGetter)) {
            this.out.print(")");
        }
        this.out.println(suffix);
        return needsCatchBlock;
    }

    private void doReturnAfter(Class cls, MethodInformation methodInfo, boolean needsCatchBlock) {
        String indent;
        String string = indent = needsCatchBlock ? "        " : "    ";
        if (methodInfo.returnType == Void.TYPE) {
            if (methodInfo.allocator || methodInfo.arrayAllocator) {
                this.out.println(indent + "jvalue args[2];");
                this.out.println(indent + "args[0].j = ptr_to_jlong(rpointer);");
                this.out.print(indent + "args[1].j = ptr_to_jlong(&JavaCPP_" + Generator.mangle(cls.getName()));
                if (methodInfo.arrayAllocator) {
                    this.out.println("_deallocateArray);");
                    this.arrayDeallocators.register(cls);
                } else {
                    this.out.println("_deallocate);");
                    this.deallocators.register(cls);
                }
                this.out.println(indent + "e->CallNonvirtualVoidMethodA(o, JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
            }
        } else if (!methodInfo.valueSetter && !methodInfo.memberSetter) {
            if (methodInfo.returnType == String.class) {
                this.out.println(indent + "if (rpointer != NULL) {");
                this.out.println(indent + "    r = e->NewStringUTF(rpointer);");
                this.out.println(indent + "}");
            } else if (methodInfo.bufferGetter) {
                this.out.println(indent + "if (rpointer != NULL) {");
                this.out.println(indent + "    r = e->NewDirectByteBuffer(rpointer, capacity);");
                this.out.println(indent + "}");
            } else if (Pointer.class.isAssignableFrom(methodInfo.returnType)) {
                Class<? extends Annotation> returnBy = Generator.getBy(methodInfo.annotations);
                if (!Modifier.isStatic(methodInfo.modifiers) && cls == methodInfo.returnType && returnBy != ByVal.class) {
                    this.out.println(indent + "if (rpointer == pointer) {");
                    this.out.println(indent + "    r = o;");
                    this.out.println(indent + "} else if (rpointer != NULL) {");
                } else {
                    this.out.println(indent + "if (rpointer != NULL) {");
                }
                this.out.println(indent + "    r = e->AllocObject(JavaCPP_getClass(e, " + this.jclasses.register(methodInfo.returnType) + "));");
                if (!(returnBy != ByVal.class || methodInfo.valueGetter || methodInfo.memberGetter || methodInfo.bufferGetter)) {
                    this.out.println(indent + "    jvalue args[2];");
                    this.out.println(indent + "    args[0].j = ptr_to_jlong(rpointer);");
                    this.out.println(indent + "    args[1].j = ptr_to_jlong(&JavaCPP_" + Generator.mangle(methodInfo.returnType.getName()) + "_deallocate);");
                    this.out.println(indent + "    e->CallNonvirtualVoidMethodA(r, JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
                    this.deallocators.register(methodInfo.returnType);
                } else {
                    this.out.println(indent + "    e->SetLongField(r, JavaCPP_addressFieldID, ptr_to_jlong(rpointer));");
                }
                this.out.println(indent + "}");
            } else if (methodInfo.returnType.isPrimitive()) {
                this.out.println(indent + "r = (" + Generator.getJNITypeName(methodInfo.returnType) + ")rvalue;");
            }
        }
    }

    private void doParametersAfter(MethodInformation methodInfo, boolean needsCatchBlock, boolean[] mayChange) {
        int j;
        String indent = needsCatchBlock ? "    " : "";
        for (j = 0; j < methodInfo.parameterTypes.length; ++j) {
            if (!mayChange[j] || methodInfo.valueSetter || methodInfo.memberSetter) continue;
            this.out.println(indent + "    if (p" + j + " != NULL) e->SetLongField(p" + j + ", JavaCPP_addressFieldID, ptr_to_jlong(pointer" + j + "));");
        }
        if (needsCatchBlock) {
            this.out.println("    } catch (...) {");
            this.out.println("        JavaCPP_handleException(e);");
            this.out.println("    }");
        }
        for (j = 0; j < methodInfo.parameterTypes.length; ++j) {
            if (methodInfo.parameterTypes[j] == String.class) {
                this.out.println("    if (p" + j + " != NULL) e->ReleaseStringUTFChars(p" + j + ", pointer" + j + ");");
                continue;
            }
            if (!methodInfo.parameterTypes[j].isArray()) continue;
            String s = methodInfo.parameterTypes[j].getComponentType().getName();
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
            this.out.println("    if (p" + j + " != NULL) e->Release" + s + "ArrayElements(p" + j + ", pointer" + j + ", 0);");
        }
    }

    private Method doFunctionDefinitions(Class<?> cls, boolean[] callbackAllocators) {
        if (!FunctionPointer.class.isAssignableFrom(cls)) {
            return null;
        }
        Method[] methods = cls.getDeclaredMethods();
        Convention convention = cls.getAnnotation(Convention.class);
        String callingConvention = convention == null ? "" : convention.value() + " ";
        Method functionMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            int modifiers = methods[i].getModifiers();
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            Class<?> returnType = methods[i].getReturnType();
            if (!Modifier.isNative(modifiers) || Modifier.isStatic(modifiers)) continue;
            if (methodName.startsWith("allocate") && returnType == Void.TYPE && parameterTypes.length == 0) {
                callbackAllocators[i] = true;
                continue;
            }
            if (!methodName.startsWith("call")) continue;
            functionMethod = methods[i];
        }
        if (functionMethod != null) {
            Class<?> returnType = functionMethod.getReturnType();
            Class<?>[] parameterTypes = functionMethod.getParameterTypes();
            Annotation[] annotations = functionMethod.getAnnotations();
            Annotation[][] parameterAnnotations = functionMethod.getParameterAnnotations();
            String[] typeName = Generator.getAnnotatedCPPTypeName(annotations, returnType);
            String s = "typedef " + typeName[0] + typeName[1] + " (" + callingConvention + "JavaCPP_" + Generator.mangle(cls.getName()) + ")(";
            for (int j = 0; j < parameterTypes.length; ++j) {
                typeName = Generator.getAnnotatedCPPTypeName(parameterAnnotations[j], parameterTypes[j]);
                s = s + typeName[0] + typeName[1] + " p" + j;
                if (j >= parameterTypes.length - 1) continue;
                s = s + ", ";
            }
            this.functionDefinitions.register(s + ");");
        }
        return functionMethod;
    }

    private void doCallback(Class<?> cls, Method callbackMethod, String callbackName) {
        Class<?> callbackReturnType = callbackMethod.getReturnType();
        Class<?>[] callbackParameterTypes = callbackMethod.getParameterTypes();
        Annotation[] callbackAnnotations = callbackMethod.getAnnotations();
        Annotation[][] callbackParameterAnnotations = callbackMethod.getParameterAnnotations();
        Convention convention = cls.getAnnotation(Convention.class);
        String callingConvention = convention == null ? "" : convention.value() + " ";
        this.functionPointers.register("JavaCPP_" + callbackName + "_instance");
        this.out.println("static jmethodID JavaCPP_" + callbackName + "_callMethodID = NULL;");
        String[] typeName = Generator.getAnnotatedCPPTypeName(callbackAnnotations, callbackReturnType);
        this.out.print("static " + typeName[0] + typeName[1] + " " + callingConvention + "JavaCPP_" + callbackName + "_callback(");
        for (int j = 0; j < callbackParameterTypes.length; ++j) {
            typeName = Generator.getAnnotatedCPPTypeName(callbackParameterAnnotations[j], callbackParameterTypes[j]);
            this.out.print(typeName[0] + typeName[1] + " p" + j);
            if (j >= callbackParameterTypes.length - 1) continue;
            this.out.print(", ");
        }
        this.out.println(") {");
        String returnVariable = "";
        if (callbackReturnType != Void.TYPE) {
            this.out.println("    " + Generator.getJNITypeName(callbackReturnType) + " r = 0;");
            returnVariable = "r";
        }
        this.out.println("    JNIEnv *e;");
        this.out.println("    if (JavaCPP_vm->AttachCurrentThread((void **)&e, NULL) != JNI_OK) {");
        this.out.println("        fprintf(stderr, \"Could not attach the JavaVM to the current thread in callback for " + cls.getName() + ".\");");
        this.out.println("        return" + (callbackReturnType == Void.TYPE ? ";" : " " + Generator.getCast(callbackAnnotations) + "0;"));
        this.out.println("    }");
        if (callbackParameterTypes.length > 0) {
            this.out.println("    jvalue args[" + callbackParameterTypes.length + "];");
            for (int j = 0; j < callbackParameterTypes.length; ++j) {
                if (Pointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                    Class<? extends Annotation> passBy = Generator.getBy(callbackParameterAnnotations[j]);
                    this.out.println("    jobject o" + j + " = NULL;");
                    this.out.print("    void *pointer" + j + " = (void*)");
                    if (passBy == ByVal.class || passBy == ByRef.class) {
                        this.out.println("&p" + j + ";");
                    } else if (passBy == ByPtrPtr.class) {
                        this.out.println("*p" + j + ";");
                    } else {
                        this.out.println("p" + j + ";");
                    }
                    String s = "    o" + j + " = e->AllocObject(JavaCPP_getClass(e, " + this.jclasses.register(callbackParameterTypes[j]) + "));";
                    if (passBy == ByPtrPtr.class || passBy == ByPtrRef.class) {
                        this.out.println(s);
                    } else {
                        this.out.println("    if (pointer" + j + " != NULL) { ");
                        this.out.println("    " + s);
                        this.out.println("    }");
                    }
                    this.out.println("    if (o" + j + " != NULL) { ");
                    this.out.println("        e->SetLongField(o" + j + ", JavaCPP_addressFieldID, ptr_to_jlong(pointer" + j + "));");
                    this.out.println("    }");
                    this.out.println("    args[" + j + "].l = o" + j + ";");
                    continue;
                }
                if (callbackParameterTypes[j] == String.class) {
                    this.out.println("    jstring o" + j + " = p" + j + " == NULL ? NULL : e->NewStringUTF(p" + j + ");");
                    this.out.println("    args[" + j + "].l = o" + j + ";");
                    continue;
                }
                if (callbackParameterTypes[j].isPrimitive()) {
                    this.out.println("    args[" + j + "]." + Generator.getSignature(callbackParameterTypes[j]).toLowerCase() + " = p" + j + ";");
                    continue;
                }
                logger.log(Level.WARNING, "Callback \"" + callbackMethod + "\" has unsupported parameter type \"" + callbackParameterTypes[j].getCanonicalName() + "\". Compilation will most likely fail.");
            }
        }
        if (returnVariable.length() > 0) {
            returnVariable = returnVariable + " = ";
        }
        String s = "Object";
        if (callbackReturnType.isPrimitive()) {
            s = callbackReturnType.getName();
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        this.out.println("    " + returnVariable + "e->Call" + s + "MethodA(JavaCPP_" + callbackName + "_instance, JavaCPP_" + callbackName + "_callMethodID, " + (callbackParameterTypes.length == 0 ? "NULL);" : "args);"));
        for (int j = 0; j < callbackParameterTypes.length; ++j) {
            Class<? extends Annotation> passBy;
            if (Pointer.class.isAssignableFrom(callbackParameterTypes[j]) && ((passBy = Generator.getBy(callbackParameterAnnotations[j])) == ByPtrPtr.class || passBy == ByPtrRef.class)) {
                this.out.println("    pointer" + j + " = jlong_to_ptr(e->GetLongField(o" + j + ", JavaCPP_addressFieldID);");
                if (passBy == ByPtrPtr.class) {
                    this.out.print("    *p" + j);
                } else {
                    this.out.print("    p" + j);
                }
                typeName = Generator.getAnnotatedCPPTypeName(callbackParameterAnnotations[j], callbackParameterTypes[j]);
                String pointerTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                this.out.println(" = (" + pointerTypeName + typeName[1] + ")pointer" + j + ";");
            }
            if (callbackParameterTypes[j].isPrimitive()) continue;
            this.out.println("    e->DeleteLocalRef(o" + j + ");");
        }
        if (callbackReturnType != Void.TYPE) {
            if (Pointer.class.isAssignableFrom(callbackReturnType)) {
                typeName = Generator.getAnnotatedCPPTypeName(callbackAnnotations, callbackReturnType);
                this.out.println("    return r == NULL ? NULL : (" + typeName[0] + typeName[1] + ")jlong_to_ptr(e->GetLongField(r, JavaCPP_addressFieldID));");
            } else if (Buffer.class.isAssignableFrom(callbackReturnType)) {
                typeName = Generator.getAnnotatedCPPTypeName(callbackAnnotations, callbackReturnType);
                this.out.println("    return r == NULL ? NULL : (" + typeName[0] + typeName[1] + ")e->GetDirectBufferAddress(r);");
            } else if (callbackReturnType.isPrimitive()) {
                this.out.println("    return " + Generator.getCast(callbackAnnotations) + "r;");
            } else {
                logger.log(Level.WARNING, "Callback \"" + callbackMethod + "\" has unsupported return type \"" + callbackReturnType.getCanonicalName() + "\". Compilation will most likely fail.");
            }
        }
        this.out.println("}");
    }

    private void doCallbackAllocator(Class cls, Method callbackMethod, String callbackName) {
        this.out.println("    e->DeleteGlobalRef(JavaCPP_" + callbackName + "_instance);");
        this.out.println("    JavaCPP_" + callbackName + "_instance = e->NewGlobalRef(o);");
        this.out.println("    if (JavaCPP_" + callbackName + "_instance == NULL) {");
        this.out.println("        fprintf(stderr, \"Error creating global reference of " + cls.getName() + " instance for callback.\");");
        this.out.println("        return;");
        this.out.println("    }");
        this.out.println("    JavaCPP_" + callbackName + "_callMethodID = e->GetMethodID(e->GetObjectClass(o), \"" + callbackMethod.getName() + "\", \"(" + Generator.getSignature(callbackMethod.getParameterTypes()) + ")" + Generator.getSignature(callbackMethod.getReturnType()) + "\");");
        this.out.println("    if (JavaCPP_" + callbackName + "_callMethodID == NULL) {");
        this.out.println("        fprintf(stderr, \"Error getting method ID of function caller \\\"" + callbackMethod + "\\\" for callback.\");");
        this.out.println("        return;");
        this.out.println("    }");
        this.out.println("    e->SetLongField(o, JavaCPP_addressFieldID, ptr_to_jlong(&JavaCPP_" + callbackName + "_callback));");
        this.out.println("}");
    }

    public boolean checkPlatform(Platform platform) {
        if (platform == null) {
            return true;
        }
        String platformName = this.properties.getProperty("platform.name");
        String[][] names = new String[][]{platform.value(), platform.not()};
        boolean[] matches = new boolean[]{false, false};
        block0: for (int i = 0; i < names.length; ++i) {
            for (String s : names[i]) {
                if (!platformName.startsWith(s)) continue;
                matches[i] = true;
                continue block0;
            }
        }
        return !(names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1]);
    }

    public static MethodInformation getMethodInformation(Method method) {
        if (!Modifier.isNative(method.getModifiers())) {
            return null;
        }
        MethodInformation info = new MethodInformation();
        info.method = method;
        info.annotations = method.getAnnotations();
        info.modifiers = method.getModifiers();
        info.returnType = method.getReturnType();
        info.memberName = info.name = method.getName();
        Name memberName = method.getAnnotation(Name.class);
        if (memberName != null) {
            info.memberName = memberName.value();
            info.memberNameSuffix = memberName.suffix();
        }
        info.parameterTypes = method.getParameterTypes();
        info.parameterAnnotations = method.getParameterAnnotations();
        Class<? extends Annotation> behavior = Generator.getBehavior(method);
        boolean canBeGetter = info.returnType != Void.TYPE;
        boolean canBeSetter = true;
        for (int j = 0; j < info.parameterTypes.length; ++j) {
            if (info.parameterTypes[j] == Integer.TYPE || info.parameterTypes[j] == Long.TYPE) continue;
            canBeGetter = false;
            if (j >= info.parameterTypes.length - 1) continue;
            canBeSetter = false;
        }
        boolean canBeAllocator = !Modifier.isStatic(info.modifiers) && info.returnType == Void.TYPE;
        boolean canBeArrayAllocator = canBeAllocator && info.parameterTypes.length == 1 && (info.parameterTypes[0] == Integer.TYPE || info.parameterTypes[0] == Long.TYPE);
        boolean valueGetter = false;
        boolean valueSetter = false;
        boolean memberGetter = false;
        boolean memberSetter = false;
        Method pairedMethod = null;
        Method[] methods = method.getDeclaringClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method2 = methods[i];
            int modifiers2 = method2.getModifiers();
            Class<?> returnType2 = method2.getReturnType();
            String methodName2 = method2.getName();
            Class<?>[] parameterTypes2 = method2.getParameterTypes();
            if (method.equals(method2) || !Modifier.isNative(modifiers2)) continue;
            if ("get".equals(info.name) && "put".equals(methodName2) && info.parameterTypes.length == 0 && parameterTypes2.length == 1 && parameterTypes2[0] == info.returnType && canBeGetter) {
                valueGetter = true;
                pairedMethod = method2;
                continue;
            }
            if ("put".equals(info.name) && "get".equals(methodName2) && info.parameterTypes.length == 1 && parameterTypes2.length == 0 && info.parameterTypes[0] == returnType2 && canBeSetter) {
                valueSetter = true;
                pairedMethod = method2;
                continue;
            }
            if (!methodName2.equals(info.name)) continue;
            info.overloaded = true;
            boolean sameIndexParameters = true;
            for (int j = 0; j < info.parameterTypes.length && j < parameterTypes2.length; ++j) {
                if (info.parameterTypes[j] == parameterTypes2[j]) continue;
                sameIndexParameters = false;
            }
            if (sameIndexParameters && parameterTypes2.length - 1 == info.parameterTypes.length && info.returnType == parameterTypes2[parameterTypes2.length - 1] && canBeGetter) {
                memberGetter = true;
                pairedMethod = method2;
                continue;
            }
            if (!sameIndexParameters || info.parameterTypes.length - 1 != parameterTypes2.length || returnType2 != info.parameterTypes[info.parameterTypes.length - 1] || !canBeSetter) continue;
            memberSetter = true;
            pairedMethod = method2;
        }
        if (canBeGetter && behavior == ValueGetter.class) {
            info.valueGetter = true;
        } else if (canBeSetter && behavior == ValueSetter.class) {
            info.valueSetter = true;
        } else if (canBeGetter && behavior == MemberGetter.class) {
            info.memberGetter = true;
        } else if (canBeSetter && behavior == MemberSetter.class) {
            info.memberSetter = true;
        } else if (canBeAllocator && behavior == Allocator.class) {
            info.allocator = true;
        } else if (canBeArrayAllocator && behavior == ArrayAllocator.class) {
            info.arrayAllocator = true;
            info.allocator = true;
        } else if (behavior == null) {
            if (info.returnType == Void.TYPE && "deallocate".equals(info.name) && !Modifier.isStatic(info.modifiers) && info.parameterTypes.length == 2 && info.parameterTypes[0] == Long.TYPE && info.parameterTypes[1] == Long.TYPE) {
                info.deallocator = true;
            } else if (canBeAllocator && "allocate".equals(info.name)) {
                info.allocator = true;
            } else if (canBeArrayAllocator && "allocateArray".equals(info.name)) {
                info.arrayAllocator = true;
                info.allocator = true;
            } else if (info.returnType.isAssignableFrom(ByteBuffer.class) && "asDirectBuffer".equals(info.name) && !Modifier.isStatic(info.modifiers) && info.parameterTypes.length == 1 && (info.parameterTypes[0] == Integer.TYPE || info.parameterTypes[0] == Long.TYPE)) {
                info.bufferGetter = true;
            } else if (valueGetter) {
                info.valueGetter = true;
                info.pairedMethod = pairedMethod;
            } else if (valueSetter) {
                info.valueSetter = true;
                info.pairedMethod = pairedMethod;
            } else if (memberGetter) {
                info.memberGetter = true;
                info.pairedMethod = pairedMethod;
            } else if (memberSetter) {
                info.memberSetter = true;
                info.pairedMethod = pairedMethod;
            }
        } else {
            logger.log(Level.WARNING, "Method \"" + method + "\" cannot behave like a \"" + behavior + "\". No code will be generated.");
            return null;
        }
        if (memberName == null && info.pairedMethod != null && (memberName = info.pairedMethod.getAnnotation(Name.class)) != null) {
            info.memberName = memberName.value();
            info.memberNameSuffix = memberName.suffix();
        }
        info.noOffset = method.isAnnotationPresent(NoOffset.class);
        if (!info.noOffset && info.pairedMethod != null) {
            info.noOffset = info.pairedMethod.isAnnotationPresent(NoOffset.class);
        }
        return info;
    }

    public static String getCast(Annotation ... annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof Cast)) continue;
            return "(" + ((Cast)a).value() + ")";
        }
        return "";
    }

    public static Class<? extends Annotation> getBy(Annotation ... annotations) {
        Annotation byAnnotation = null;
        for (Annotation a : annotations) {
            if (!(a instanceof ByPtr) && !(a instanceof ByPtrPtr) && !(a instanceof ByPtrRef) && !(a instanceof ByRef) && !(a instanceof ByVal)) continue;
            if (byAnnotation != null) {
                logger.log(Level.WARNING, "\"By\" annotation \"" + byAnnotation + "\" already found. Ignoring superfluous annotation \"" + a + "\".");
                continue;
            }
            byAnnotation = a;
        }
        return byAnnotation == null ? null : byAnnotation.annotationType();
    }

    public static Class<? extends Annotation> getBehavior(Method method) {
        Annotation[] annotations = method.getAnnotations();
        Annotation behaviorAnnotation = null;
        for (Annotation a : annotations) {
            if (!(a instanceof Function) && !(a instanceof Allocator) && !(a instanceof ArrayAllocator) && !(a instanceof ValueSetter) && !(a instanceof ValueGetter) && !(a instanceof MemberGetter) && !(a instanceof MemberSetter)) continue;
            if (behaviorAnnotation != null) {
                logger.log(Level.WARNING, "Behavior annotation \"" + behaviorAnnotation + "\" already found. Ignoring superfluous annotation \"" + a + "\".");
                continue;
            }
            behaviorAnnotation = a;
        }
        return behaviorAnnotation == null ? null : behaviorAnnotation.annotationType();
    }

    public static String[] getAnnotatedCPPTypeName(Annotation[] annotations, Class<?> type) {
        Class<? extends Annotation> by;
        String name = Generator.getCPPTypeName(type);
        for (Annotation a : annotations) {
            if (!(a instanceof Cast)) continue;
            name = ((Cast)a).value();
        }
        String prefix = name;
        String suffix = "";
        int parenthesis = name.indexOf(41);
        if (parenthesis > 0) {
            prefix = name.substring(0, parenthesis).trim();
            suffix = name.substring(parenthesis).trim();
        }
        if ((by = Generator.getBy(annotations)) == ByVal.class) {
            prefix = prefix.substring(0, prefix.length() - 1);
        } else if (by == ByRef.class) {
            prefix = prefix.substring(0, prefix.length() - 1) + "&";
        } else if (by == ByPtrPtr.class) {
            prefix = prefix + "*";
        } else if (by == ByPtrRef.class) {
            prefix = prefix + "&";
        }
        return new String[]{prefix, suffix};
    }

    public static String getCPPTypeName(Class<?> type) {
        if (type == Buffer.class || type == Pointer.class) {
            return "void*";
        }
        if (type == byte[].class || type == ByteBuffer.class || type == BytePointer.class) {
            return "signed char*";
        }
        if (type == short[].class || type == ShortBuffer.class || type == ShortPointer.class) {
            return "short*";
        }
        if (type == int[].class || type == IntBuffer.class || type == IntPointer.class) {
            return "int*";
        }
        if (type == long[].class || type == LongBuffer.class || type == LongPointer.class) {
            return "jlong*";
        }
        if (type == float[].class || type == FloatBuffer.class || type == FloatPointer.class) {
            return "float*";
        }
        if (type == double[].class || type == DoubleBuffer.class || type == DoublePointer.class) {
            return "double*";
        }
        if (type == char[].class || type == CharBuffer.class || type == CharPointer.class) {
            return "unsigned short*";
        }
        if (type == PointerPointer.class) {
            return "void**";
        }
        if (type == String.class) {
            return "const char*";
        }
        if (type == Byte.TYPE) {
            return "signed char";
        }
        if (type == Character.TYPE) {
            return "unsigned short";
        }
        if (type == Long.TYPE) {
            return "jlong";
        }
        if (type == Boolean.TYPE) {
            return "unsigned char";
        }
        if (type.isPrimitive()) {
            return type.getName();
        }
        if (FunctionPointer.class.isAssignableFrom(type)) {
            return "JavaCPP_" + Generator.mangle(type.getName()) + "*";
        }
        String spacedType = "";
        while (type != null) {
            String spaceName;
            Namespace namespace = type.getAnnotation(Namespace.class);
            String string = spaceName = namespace != null ? namespace.value() : "";
            if (Pointer.class.isAssignableFrom(type)) {
                String s;
                Name name = type.getAnnotation(Name.class);
                if (name == null) {
                    s = type.getName();
                    s = s.substring(s.lastIndexOf("$") + 1);
                } else {
                    s = name.value();
                }
                spaceName = spaceName.length() == 0 ? s : spaceName + "::" + s;
            }
            if (spacedType.length() == 0) {
                spacedType = spaceName;
            } else if (spaceName.length() > 0) {
                spacedType = spaceName + "::" + spacedType;
            }
            type = type.getDeclaringClass();
        }
        return spacedType + "*";
    }

    public static String getJNITypeName(Class type) {
        if (type == Byte.TYPE) {
            return "jbyte";
        }
        if (type == Short.TYPE) {
            return "jshort";
        }
        if (type == Integer.TYPE) {
            return "jint";
        }
        if (type == Long.TYPE) {
            return "jlong";
        }
        if (type == Float.TYPE) {
            return "jfloat";
        }
        if (type == Double.TYPE) {
            return "jdouble";
        }
        if (type == Boolean.TYPE) {
            return "jboolean";
        }
        if (type == Character.TYPE) {
            return "jchar";
        }
        if (type == byte[].class) {
            return "jbyteArray";
        }
        if (type == short[].class) {
            return "jshortArray";
        }
        if (type == int[].class) {
            return "jintArray";
        }
        if (type == long[].class) {
            return "jlongArray";
        }
        if (type == float[].class) {
            return "jfloatArray";
        }
        if (type == double[].class) {
            return "jdoubleArray";
        }
        if (type == boolean[].class) {
            return "jbooleanArray";
        }
        if (type == char[].class) {
            return "jcharArray";
        }
        if (type == String.class) {
            return "jstring";
        }
        if (type == Void.TYPE) {
            return "void";
        }
        return "jobject";
    }

    public static String getSignature(Class ... types) {
        StringBuilder signature = new StringBuilder(2 * types.length);
        for (int i = 0; i < types.length; ++i) {
            signature.append(Generator.getSignature(types[i]));
        }
        return signature.toString();
    }

    public static String getSignature(Class type) {
        if (type == Byte.TYPE) {
            return "B";
        }
        if (type == Short.TYPE) {
            return "S";
        }
        if (type == Integer.TYPE) {
            return "I";
        }
        if (type == Long.TYPE) {
            return "J";
        }
        if (type == Float.TYPE) {
            return "F";
        }
        if (type == Double.TYPE) {
            return "D";
        }
        if (type == Boolean.TYPE) {
            return "Z";
        }
        if (type == Character.TYPE) {
            return "C";
        }
        if (type == Void.TYPE) {
            return "V";
        }
        if (type.isArray()) {
            return type.getName().replace(".", "/");
        }
        return "L" + type.getName().replace(".", "/") + ";";
    }

    public static String mangle(String name) {
        StringBuilder mangledName = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                mangledName.append(c);
                continue;
            }
            if (c == '_') {
                mangledName.append("_1");
                continue;
            }
            if (c == ';') {
                mangledName.append("_2");
                continue;
            }
            if (c == '[') {
                mangledName.append("_3");
                continue;
            }
            if (c == '.' || c == '/') {
                mangledName.append("_");
                continue;
            }
            String code = Integer.toHexString(c);
            mangledName.append("_0");
            switch (code.length()) {
                case 1: {
                    mangledName.append("0");
                }
                case 2: {
                    mangledName.append("0");
                }
                case 3: {
                    mangledName.append("0");
                }
            }
            mangledName.append(code);
        }
        return mangledName.toString();
    }

    public static class MethodInformation {
        public Method method;
        public Annotation[] annotations;
        public int modifiers;
        public Class<?> returnType;
        public String name;
        public String memberName;
        public String memberNameSuffix;
        public Class<?>[] parameterTypes;
        public Annotation[][] parameterAnnotations;
        public boolean overloaded;
        public boolean noOffset;
        public boolean deallocator;
        public boolean allocator;
        public boolean arrayAllocator;
        public boolean bufferGetter;
        public boolean valueGetter;
        public boolean valueSetter;
        public boolean memberGetter;
        public boolean memberSetter;
        public Method pairedMethod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedListRegister<E>
    extends LinkedList<E> {
        public int register(E e) {
            int i = this.indexOf(e);
            if (i < 0) {
                this.add(e);
                i = this.size() - 1;
            }
            return i;
        }
    }
}

