/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networking;

import edu.wpi.first.wpilibj.networking.Connection;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import edu.wpi.first.wpilibj.networking.Set;
import edu.wpi.first.wpilibj.networking.TableRequest;
import java.net.InetSocketAddress;
import java.net.Socket;

class ConnectionManager {
    static final boolean IS_SERVER = false;
    private static final int PORT = 1735;
    private static boolean initialized = false;
    private static Connection connection;
    private static final Object lock;
    static String ipaddress;
    private static Set tables;

    ConnectionManager() {
    }

    public static synchronized void initialize() {
        if (ipaddress == null) {
            throw new NetworkTable.NoTeamNumberException();
        }
        if (!initialized) {
            initialized = true;
            new Thread(){

                public void run() {
                    ConnectionManager.acceptConnections();
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void acceptConnections() {
        while (true) {
            try {
                Object object = lock;
                // MONITORENTER : object
                Socket socket = new Socket();
                InetSocketAddress address = new InetSocketAddress(ipaddress, 1735);
                socket.connect(address);
                socket.setTcpNoDelay(true);
                connection = new Connection(socket);
                Class<ConnectionManager> clazz = ConnectionManager.class;
                // MONITORENTER : edu.wpi.first.wpilibj.networking.ConnectionManager.class
                for (int i = 0; i < tables.size(); ++i) {
                    Table table = (Table)tables.get(i);
                    connection.offer(new TableRequest(table.string, table.table));
                    table.table.addConnection(connection);
                }
                // MONITOREXIT : clazz
                connection.start();
                lock.wait();
                // MONITOREXIT : object
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeConnection(Connection connection) {
        Object object = lock;
        synchronized (object) {
            ConnectionManager.connection = null;
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void requestTable(String name, NetworkTable table) {
        tables.add(new Table(name, table));
        if (connection != null) {
            Object object = lock;
            synchronized (object) {
                if (connection != null) {
                    connection.offer(new TableRequest(name, table));
                    table.addConnection(connection);
                }
            }
        }
    }

    static {
        lock = new Object();
        tables = new Set();
    }

    private static class Table {
        final String string;
        final NetworkTable table;

        public Table(String string, NetworkTable table) {
            this.string = string;
            this.table = table;
        }
    }
}

