/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.xml;

import edu.wpi.first.smartdashboard.gui.DisplayElement;
import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.types.DataType;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLWidget {
    Point location = null;
    Dimension size = null;
    HashMap<String, String> properties = new HashMap();
    String field;
    String className = "";
    DataType type;

    public void setLocation(Point p) {
        this.location = p;
    }

    public void setSize(Dimension d) {
        this.size = d;
    }

    public void setClass(String c) {
        this.className = c;
    }

    public void setField(String f) {
        this.field = f;
    }

    public void setType(String type) {
        this.type = DataType.getType(type, false);
    }

    public void setWidth(int width) {
        if (this.size != null) {
            this.size.width = width;
        } else {
            this.size = new Dimension(width, -1);
        }
    }

    public void setHeight(int height) {
        if (this.size != null) {
            this.size.height = height;
        } else {
            this.size = new Dimension(-1, height);
        }
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Dimension getSize() {
        return this.size;
    }

    public DataType getType() {
        return this.type;
    }

    public Point getLocation() {
        return this.location;
    }

    public String getElementClass() {
        return this.className;
    }

    public String getField() {
        return this.field;
    }

    public DisplayElement convertToDisplayElement() {
        DisplayElement element = null;
        try {
            element = (DisplayElement)Class.forName(this.className).newInstance();
            if (this.field != null) {
                ((Widget)element).setFieldName(this.field);
            }
            if (this.size != null) {
                element.setSavedSize(this.size);
            }
            if (this.location != null) {
                element.setSavedLocation(this.location);
            }
            for (String key : this.properties.keySet()) {
                Property property = element.getProperties().get(key);
                if (property == null) continue;
                property.setSaveValue(this.properties.get(key));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(XMLWidget.class.getName()).log(Level.SEVERE, null, ex);
        }
        return element;
    }

    public String toString() {
        String returnValue = "ClassName: " + this.className + "\nField: " + this.field + "\nSize: " + this.size + "\nLocation: " + this.location + "\nProperties";
        for (String s : this.properties.keySet()) {
            String p = this.properties.get(s);
            returnValue = returnValue + "\n\nName: " + s + "\nValue: " + p;
        }
        return returnValue;
    }
}

