/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.xml;

import edu.wpi.first.smartdashboard.xml.XMLWidget;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartDashboardXMLReader {
    private List<XMLWidget> widgets = new ArrayList<XMLWidget>();
    private List<String> hiddenFields = new ArrayList<String>();
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean finishedReading = false;

    public SmartDashboardXMLReader(String fileName) throws FileNotFoundException {
        new ReaderThread(fileName);
    }

    private void waitToFinish() {
        while (!this.finishedReading) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public List<XMLWidget> getXMLWidgets() {
        this.waitToFinish();
        return this.widgets;
    }

    public List<String> getHiddenFields() {
        this.waitToFinish();
        return this.hiddenFields;
    }

    public Map<String, String> getProperties() {
        this.waitToFinish();
        return this.properties;
    }

    public boolean isFinishedReading() {
        return this.finishedReading;
    }

    private class ReaderThread
    extends Thread {
        File xmlFile;

        ReaderThread(String fileName) {
            this.xmlFile = new File(fileName);
            this.start();
        }

        public void run() {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(this.xmlFile);
                doc.getDocumentElement().normalize();
                NodeList list = doc.getElementsByTagName("dashboard");
                if (list.getLength() == 0) {
                    return;
                }
                NodeList elements = list.item(0).getChildNodes();
                for (int e = 0; e < elements.getLength(); ++e) {
                    NamedNodeMap atrib;
                    boolean isWidget = elements.item(e).getNodeName().equals("widget");
                    if (isWidget || elements.item(e).getNodeName().equals("static-widget")) {
                        atrib = elements.item(e).getAttributes();
                        XMLWidget widget = new XMLWidget();
                        for (int a = 0; a < atrib.getLength(); ++a) {
                            if (atrib.item(a).getNodeName().equals("field")) {
                                widget.setField(atrib.item(a).getNodeValue());
                                continue;
                            }
                            if (atrib.item(a).getNodeName().equals("class")) {
                                widget.setClass(atrib.item(a).getNodeValue());
                                continue;
                            }
                            if (!atrib.item(a).getNodeName().equals("type")) continue;
                            widget.setType(atrib.item(a).getNodeValue());
                        }
                        NodeList values = elements.item(e).getChildNodes();
                        for (int a = 0; a < values.getLength(); ++a) {
                            int b;
                            if (values.item(a).getNodeName().trim().equals("location")) {
                                int x = 0;
                                int y = 0;
                                NamedNodeMap location = values.item(a).getAttributes();
                                for (b = 0; b < location.getLength(); ++b) {
                                    if (location.item(b).getNodeName().equals("x")) {
                                        x = Integer.parseInt(location.item(b).getNodeValue());
                                        continue;
                                    }
                                    if (!location.item(b).getNodeName().equals("y")) continue;
                                    y = Integer.parseInt(location.item(b).getNodeValue());
                                }
                                widget.setLocation(new Point(x, y));
                                continue;
                            }
                            if (values.item(a).getNodeName().trim().equals("width")) {
                                widget.setWidth(Integer.parseInt(values.item(a).getChildNodes().item(0).getNodeValue()));
                                continue;
                            }
                            if (values.item(a).getNodeName().trim().equals("height")) {
                                widget.setHeight(Integer.parseInt(values.item(a).getChildNodes().item(0).getNodeValue()));
                                continue;
                            }
                            if (!values.item(a).getNodeName().trim().equals("property")) continue;
                            NamedNodeMap propAtribs = values.item(a).getAttributes();
                            String name = null;
                            String value = null;
                            for (b = 0; b < propAtribs.getLength(); ++b) {
                                if (propAtribs.item(b).getNodeName().equals("name")) {
                                    name = propAtribs.item(b).getNodeValue();
                                    continue;
                                }
                                if (!propAtribs.item(b).getNodeName().equals("value")) continue;
                                value = propAtribs.item(b).getNodeValue();
                            }
                            if (name == null || value == null) continue;
                            widget.addProperty(name, value);
                        }
                        SmartDashboardXMLReader.this.widgets.add(widget);
                        continue;
                    }
                    if (elements.item(e).getNodeName().equals("hidden")) {
                        atrib = elements.item(e).getAttributes();
                        for (int a = 0; a < atrib.getLength(); ++a) {
                            if (!atrib.item(a).getNodeName().equals("field")) continue;
                            SmartDashboardXMLReader.this.hiddenFields.add(atrib.item(a).getNodeValue());
                        }
                        continue;
                    }
                    if (!elements.item(e).getNodeName().equals("property")) continue;
                    NamedNodeMap propAtribs = elements.item(e).getAttributes();
                    String name = null;
                    String value = null;
                    for (int b = 0; b < propAtribs.getLength(); ++b) {
                        if (propAtribs.item(b).getNodeName().equals("name")) {
                            name = propAtribs.item(b).getNodeValue();
                            continue;
                        }
                        if (!propAtribs.item(b).getNodeName().equals("value")) continue;
                        value = propAtribs.item(b).getNodeValue();
                    }
                    if (name == null || value == null) continue;
                    SmartDashboardXMLReader.this.properties.put(name, value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SmartDashboardXMLReader.this.finishedReading = true;
        }
    }
}

