/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.types;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.gui.elements.TextBox;
import edu.wpi.first.smartdashboard.types.NamedDataType;
import edu.wpi.first.wpilibj.networking.NetworkTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataType {
    private final DataType[] parents;
    private final String name;
    private Class<? extends Widget> defaultClass;
    public static final DataType BASIC = new DataType("Basic", TextBox.class, new DataType[0]);
    public static final DataType NUMBER = new DataType("Number", TextBox.class, BASIC);
    public static final DataType INTEGER = new DataType("Integer", TextBox.class, NUMBER);
    public static final DataType DOUBLE = new DataType("Double", TextBox.class, NUMBER);
    public static final DataType BOOLEAN = new DataType("Boolean", TextBox.class, BASIC);
    public static final DataType STRING = new DataType("String", TextBox.class, BASIC);
    public static final DataType TABLE = new DataType("Table", new DataType[0]);

    DataType(String name, DataType ... parents) {
        this.name = name;
        this.parents = parents;
    }

    DataType(String name, Class<? extends Widget> defaultClass, DataType ... parents) {
        this.name = name;
        this.parents = parents;
        this.defaultClass = defaultClass;
    }

    public void setDefault(Class<? extends Widget> defaultClass) {
        this.defaultClass = defaultClass;
    }

    public Class<? extends Widget> getDefault() {
        return this.defaultClass;
    }

    public DataType[] getParents() {
        return (DataType[])this.parents.clone();
    }

    public boolean isNamed() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public boolean isChildOf(DataType parent) {
        if (this.equals(parent)) {
            return true;
        }
        for (int i = 0; i < this.parents.length; ++i) {
            if (!this.parents[i].isChildOf(parent)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[Type:" + this.name + "]";
    }

    public static DataType getType(String type, boolean isNamedType) {
        if (isNamedType) {
            return NamedDataType.get(type);
        }
        if (type.equals(NUMBER.getName())) {
            return NUMBER;
        }
        if (type.equals(DOUBLE.getName())) {
            return DOUBLE;
        }
        if (type.equals(INTEGER.getName())) {
            return INTEGER;
        }
        if (type.equals(BOOLEAN.getName())) {
            return BOOLEAN;
        }
        if (type.equals(BASIC.getName())) {
            return BASIC;
        }
        if (type.equals(STRING.getName())) {
            return STRING;
        }
        if (type.equals(TABLE.getName())) {
            return TABLE;
        }
        return NamedDataType.get(type);
    }

    public static DataType getType(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Can not be given null value");
        }
        if (value instanceof NetworkTable) {
            NetworkTable table = (NetworkTable)value;
            if (table.containsKey("~TYPE~")) {
                String typeName = table.getString("~TYPE~");
                return NamedDataType.get(typeName);
            }
            return TABLE;
        }
        if (value instanceof Double) {
            return DOUBLE;
        }
        if (value instanceof Boolean) {
            return BOOLEAN;
        }
        if (value instanceof Integer) {
            return INTEGER;
        }
        if (value instanceof String) {
            return STRING;
        }
        throw new IllegalArgumentException("Can not get type for class:" + value.getClass().getName());
    }
}

