/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.properties;

import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.smartdashboard.properties.TextInputProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberProperty
extends TextInputProperty<Number> {
    public NumberProperty(PropertyHolder element, String name) {
        super(Number.class, element, name);
    }

    public NumberProperty(PropertyHolder element, String name, Number defaultValue) {
        super(Number.class, element, name, defaultValue);
    }

    @Override
    protected Number transformValue(Object value) {
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                try {
                    return Double.parseDouble((String)value);
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        return (Number)super.transformValue(value);
    }
}

