/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.properties;

import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class MultiProperty
extends Property {
    private JComboBox comboBox = new JComboBox();
    private DefaultCellEditor cellEditor = new DefaultCellEditor(this.comboBox);
    private Map<String, Object> values = new HashMap<String, Object>();
    private TableCellRenderer renderer = new TableCellRenderer(){

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return MultiProperty.this.comboBox;
        }
    };

    public MultiProperty(PropertyHolder holder, String name) {
        super(holder, name);
    }

    public void add(String key, Object value) {
        this.comboBox.addItem(key);
        this.values.put(key, value);
    }

    public boolean setDefault(Object key) {
        if (super.setDefault(key)) {
            if (!this.hasValue()) {
                this.comboBox.setSelectedItem(key);
            }
            return true;
        }
        return false;
    }

    protected void valueChanged() {
        this.comboBox.setSelectedItem(this.getSaveValue());
    }

    public TableCellEditor getEditor(Component c) {
        return this.cellEditor;
    }

    protected Object transformValue(Object value) {
        return this.values.get(value);
    }

    public TableCellRenderer getRenderer() {
        return this.renderer;
    }

    public String getSaveValue() {
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            if (!entry.getValue().equals(this.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

