/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.properties;

import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import javax.swing.table.TableCellRenderer;

public class IntegerListProperty
extends Property {
    private String valueSplit = ", ";
    private String delimiter = ",";

    public IntegerListProperty(PropertyHolder parent, String name) {
        super(parent, name);
    }

    public IntegerListProperty(PropertyHolder parent, String name, int[] value) {
        super(parent, name, value);
    }

    protected void setValueSplit(String split) {
        this.valueSplit = split;
    }

    protected void setDelimeter(String delimiter) {
        this.delimiter = delimiter;
    }

    protected int[] transformValue(Object value) {
        if (value instanceof String) {
            String text = (String)value;
            String[] texts = text.split(this.delimiter);
            int[] values = new int[texts.length];
            for (int i = 0; i < texts.length; ++i) {
                try {
                    values[i] = Integer.parseInt(texts[i].trim());
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return values;
        }
        if (value instanceof int[]) {
            return (int[])value;
        }
        return null;
    }

    public Object getTableValue() {
        return this.getSaveValue();
    }

    public TableCellRenderer getRenderer() {
        return null;
    }

    public String getSaveValue() {
        String text = "";
        int[] value = this.getValue();
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                text = text + this.valueSplit;
            }
            text = text + value[i];
        }
        return text;
    }

    public int[] getValue() {
        return (int[])super.getValue();
    }
}

