/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.net;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.imageio.ImageIO;

public class TCPImageFetcher {
    public static final int MAX_IMG_SIZE_BYTES = 500000;
    public static final int READ_TIMEOUT_MS = 3000;
    public static final int VIDEO_TO_PC_PORT = 1180;
    private Socket m_sock = null;
    private InputStream m_sockistream = null;
    private byte[] m_imgBuffer = null;
    private int m_maxImgBufferSize = 0;
    private ByteArrayInputStream m_baistream = null;
    private DataInputStream m_daistream = null;
    private boolean m_initialized = false;
    private byte[] m_address = null;

    public TCPImageFetcher(int teamNumber) {
        byte high = (byte)(teamNumber / 100);
        byte low = (byte)(teamNumber % 100);
        this.m_address = new byte[]{10, high, low, 2};
    }

    private void init() throws IOException {
        this.m_sock = new Socket(InetAddress.getByAddress(this.m_address), 1180);
        this.m_sock.setSoTimeout(3000);
        this.m_sockistream = this.m_sock.getInputStream();
        this.m_daistream = new DataInputStream(this.m_sockistream);
        this.m_initialized = true;
    }

    public BufferedImage fetch() throws IOException {
        if (!this.m_initialized) {
            this.init();
        }
        try {
            byte[] header = new byte[4];
            do {
                this.blockingRead(this.m_sockistream, header, 4);
            } while (header[0] != 1 || header[1] + header[2] + header[3] != 0);
            while (this.m_sockistream.available() < 4) {
            }
            int imgDataLen = this.m_daistream.readInt();
            this.resizeBuffer(imgDataLen);
            this.blockingRead(this.m_sockistream, this.m_imgBuffer, imgDataLen);
            this.m_baistream.reset();
            return ImageIO.read(this.m_baistream);
        }
        catch (IOException ex) {
            this.m_sock.close();
            this.m_initialized = false;
            throw ex;
        }
    }

    private void resizeBuffer(int size) {
        if (size > this.m_maxImgBufferSize) {
            if (size > 500000) {
                size = 500000;
            }
            this.m_maxImgBufferSize = size + 100;
            this.m_imgBuffer = new byte[this.m_maxImgBufferSize];
            this.m_baistream = new ByteArrayInputStream(this.m_imgBuffer);
        }
    }

    private void blockingRead(InputStream istream, byte[] buf, int requestedBytes) throws IOException {
        int read;
        for (int offset = 0; offset < requestedBytes; offset += read) {
            read = istream.read(buf, offset, requestedBytes - offset);
            if (read >= 0) continue;
            throw new IOException("Connection interrupted");
        }
    }
}

