/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.ColorProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.types.DataType;
import edu.wpi.first.smartdashboard.types.named.SubsystemType;
import edu.wpi.first.wpilibj.networking.NetworkListener;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import java.awt.Color;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Subsystem
extends Widget
implements NetworkListener {
    public static final DataType[] TYPES = new DataType[]{SubsystemType.get()};
    public final ColorProperty background = new ColorProperty(this, "Background");
    private JTextField valueField;
    private NetworkTable table;

    public void init() {
        JLabel nameLabel = new JLabel(this.getFieldName());
        this.valueField = new JTextField("---");
        this.update(this.background, this.valueField.getBackground());
        this.setLayout(new BoxLayout(this, 0));
        this.valueField.setEditable(false);
        this.valueField.setColumns(10);
        this.add(nameLabel);
        this.add(this.valueField);
        this.revalidate();
        this.repaint();
    }

    public void setValue(Object value) {
        if (this.table != null) {
            this.table.removeListener("command", (NetworkListener)this);
        }
        this.table = (NetworkTable)value;
        this.table.addListener("command", (NetworkListener)this);
        this.table.addListener("hasCommand", (NetworkListener)this);
        this.valueChanged("hasCommand", this.table.getBoolean("hasCommand"));
        this.repaint();
    }

    public void valueChanged(String key, Object value) {
        if (key.equals("hasCommand")) {
            if (((Boolean)value).booleanValue()) {
                this.valueField.setText(this.table.getSubTable("command").getString("name"));
            } else {
                this.valueField.setText("---");
            }
        } else if (key.equals("command")) {
            this.valueField.setText(((NetworkTable)value).getString("name"));
        }
    }

    public void valueConfirmed(String key, Object value) {
    }

    public void propertyChanged(Property property) {
        if (property == this.background) {
            this.valueField.setBackground((Color)this.background.getValue());
        }
    }
}

