/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.types.DataType;
import edu.wpi.first.smartdashboard.types.named.SchedulerType;
import edu.wpi.first.wpilibj.networking.NetworkListener;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Scheduler
extends Widget {
    public static final DataType[] TYPES = new DataType[]{SchedulerType.get()};
    private static final String NO_COMMAND_CARD = "No Command";
    private static final String COMMAND_CARD = "Commands";
    private int count;
    private JLabel noCommands;
    private JPanel commandLabels;
    private JPanel cancelButtons;
    private JPanel commandPanel;
    private List<JLabel> labels;
    private List<JButton> buttons;
    private NetworkTable table;
    private GridLayout commandLayout;
    private GridLayout cancelLayout;
    private CardLayout cardLayout;
    private NetworkListener listener = new NetworkListener(){
        boolean running = false;

        public void valueChanged(String key, Object value) {
            if (this.running) {
                return;
            }
            this.running = true;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int newCount = 0;
                    NetworkTable networkTable = Scheduler.this.table;
                    synchronized (networkTable) {
                        newCount = Scheduler.this.table.getInt("count");
                        for (int i = 0; i < newCount; ++i) {
                            JButton button;
                            NetworkTable command = Scheduler.this.table.getSubTable(String.valueOf(i + 1));
                            if (i >= Scheduler.this.labels.size()) {
                                Scheduler.this.labels.add(new JLabel());
                            }
                            JLabel label = (JLabel)Scheduler.this.labels.get(i);
                            label.setText(command.getString("name"));
                            if (i >= Scheduler.this.buttons.size()) {
                                button = new JButton("cancel");
                                final int index = i + 1;
                                button.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        Scheduler.this.table.getSubTable(Integer.toString(index)).putBoolean("running", false);
                                    }
                                });
                                Scheduler.this.buttons.add(button);
                            }
                            button = (JButton)Scheduler.this.buttons.get(i);
                            if (i <= Scheduler.this.count - 1) continue;
                            Scheduler.this.commandLabels.add(label);
                            Scheduler.this.cancelButtons.add(button);
                        }
                    }
                    if (Scheduler.this.count > newCount) {
                        for (int i = newCount; i < Scheduler.this.count; ++i) {
                            Scheduler.this.commandLabels.remove((Component)Scheduler.this.labels.get(i));
                            Scheduler.this.cancelButtons.remove((Component)Scheduler.this.buttons.get(i));
                        }
                    }
                    Scheduler.this.count = newCount;
                    Scheduler.this.cardLayout.show(Scheduler.this, Scheduler.this.count == 0 ? Scheduler.NO_COMMAND_CARD : Scheduler.COMMAND_CARD);
                    running = false;
                }
            });
        }

        public void valueConfirmed(String key, Object value) {
            this.valueChanged(key, value);
        }
    };

    public void setValue(Object value) {
        if (this.table != null) {
            this.table.removeListenerFromAll(this.listener);
        }
        this.table = (NetworkTable)value;
        this.table.addListenerToAll(this.listener);
        this.listener.valueChanged(null, null);
        this.revalidate();
        this.repaint();
    }

    public void init() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.labels = new ArrayList<JLabel>();
        this.buttons = new ArrayList<JButton>();
        this.commandPanel = new JPanel();
        this.commandPanel.setLayout(new GridLayout(0, 2));
        this.commandLabels = new JPanel();
        this.cancelButtons = new JPanel();
        this.commandPanel.add((Component)this.commandLabels, "West");
        this.commandPanel.add((Component)this.cancelButtons, "Center");
        this.commandLayout = new GridLayout(0, 1);
        this.cancelLayout = new GridLayout(0, 1);
        this.commandLabels.setLayout(this.commandLayout);
        this.cancelButtons.setLayout(this.cancelLayout);
        this.add((Component)this.commandPanel, COMMAND_CARD);
        this.noCommands = new JLabel("No commands running.");
        this.noCommands.setHorizontalAlignment(0);
        this.add((Component)this.noCommands, NO_COMMAND_CARD);
        this.cardLayout.show(this, NO_COMMAND_CARD);
        this.repaint();
    }

    public void propertyChanged(Property property) {
    }
}

