/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.StaticWidget;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.robot.Robot;
import edu.wpi.first.wpilibj.networking.NetworkAdditionListener;
import edu.wpi.first.wpilibj.networking.NetworkListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class RobotPreferences
extends StaticWidget
implements NetworkListener,
NetworkAdditionListener {
    private JTable table;
    private PreferenceTableModel model;
    private Map<String, String> values;
    private JButton save;
    private Runnable repainter = new Runnable(){

        public void run() {
            RobotPreferences.this.save.setEnabled(!Robot.getPreferences().getBoolean("~S A V E~"));
            RobotPreferences.this.repaint();
            RobotPreferences.this.repainting = false;
        }
    };
    private boolean repainting = false;

    public void init() {
        this.save = new JButton("Save");
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Robot.getPreferences().putBoolean("~S A V E~", true);
            }
        });
        this.values = new LinkedHashMap<String, String>();
        Robot.getPreferences().addAdditionListener((NetworkAdditionListener)this, true);
        Robot.getPreferences().addListenerToAll((NetworkListener)this);
        this.model = new PreferenceTableModel();
        this.table = new JTable(this.model);
        this.setLayout(new BorderLayout());
        this.add((Component)this.table, "North");
        this.add((Component)this.save, "South");
    }

    public void disconnect() {
        Robot.getPreferences().removeAdditionListener((NetworkAdditionListener)this);
        Robot.getPreferences().removeListenerFromAll((NetworkListener)this);
    }

    public void propertyChanged(Property property) {
    }

    public void valueChanged(String key, Object value) {
        if (key.equals("~S A V E~")) {
            this.save.setEnabled((Boolean)value == false);
        } else {
            this.values.put(key, value.toString());
        }
        System.out.println(key + "->" + value);
        if (!this.repainting) {
            this.repainting = true;
            EventQueue.invokeLater(this.repainter);
        }
    }

    public void valueConfirmed(String key, Object value) {
        this.valueChanged(key, value);
    }

    public void fieldAdded(String key, Object value) {
        this.valueChanged(key, value);
    }

    private class PreferenceTableModel
    extends AbstractTableModel {
        private PreferenceTableModel() {
        }

        public int getRowCount() {
            return RobotPreferences.this.values.size() + 2;
        }

        public int getColumnCount() {
            return 2;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (!RobotPreferences.this.values.containsKey(aValue.toString())) {
                    RobotPreferences.this.values.put(aValue.toString(), "");
                }
            } else {
                int row = 1;
                for (Map.Entry entry : RobotPreferences.this.values.entrySet()) {
                    if (row++ != rowIndex) continue;
                    entry.setValue(aValue.toString());
                    Robot.getPreferences().putString((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return rowIndex > 0 && columnIndex > 0 && rowIndex <= RobotPreferences.this.values.size() || rowIndex == RobotPreferences.this.values.size() + 1 && columnIndex == 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex == 0) {
                return columnIndex == 0 ? "Key" : "Value";
            }
            if (rowIndex == RobotPreferences.this.values.size() + 1) {
                return columnIndex == 0 ? "Add..." : "";
            }
            int row = 1;
            for (Map.Entry entry : RobotPreferences.this.values.entrySet()) {
                if (row++ != rowIndex) continue;
                return columnIndex == 0 ? (String)entry.getKey() : (String)entry.getValue();
            }
            return "ERROR";
        }
    }
}

