/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.ColorProperty;
import edu.wpi.first.smartdashboard.properties.IntegerProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.smartdashboard.types.DataType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressBar
extends Widget {
    public static final DataType[] TYPES = new DataType[]{DataType.NUMBER};
    public final ColorProperty foreground = new ColorProperty(this, "Foreground");
    public final ColorProperty background = new ColorProperty(this, "Background");
    public final IntegerProperty max = new IntegerProperty((PropertyHolder)this, "Maximum", 100);
    public final IntegerProperty min = new IntegerProperty((PropertyHolder)this, "Minimum", 0);
    private JProgressBar progressBar;
    private double scale;

    public void init() {
        this.scale = 1.0;
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximum((int)((double)this.min.getValue().intValue() * this.scale));
        this.progressBar.setMaximum((int)((double)this.max.getValue().intValue() * this.scale));
        this.progressBar.setBorderPainted(false);
        this.progressBar.setBounds(this.progressBar.getX(), this.progressBar.getY(), this.progressBar.getX() + 200, this.progressBar.getY() + 40);
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(this.getFieldName()), "First");
        this.add((Component)this.progressBar, "Center");
        this.update(this.foreground, this.progressBar.getForeground());
        this.update(this.background, this.progressBar.getBackground());
        this.revalidate();
        this.repaint();
    }

    private void calcScale() {
        this.scale = (this.getHeight() + this.getWidth()) / (this.max.getValue() - this.min.getValue());
        this.progressBar.setMinimum((int)((double)this.min.getValue().intValue() * this.scale));
        this.progressBar.setMaximum((int)((double)this.max.getValue().intValue() * this.scale));
    }

    public void setValue(Object value) {
        this.progressBar.setValue((int)(((Number)value).doubleValue() * this.scale));
        this.revalidate();
        this.repaint();
    }

    public void propertyChanged(Property property) {
        if (property == this.foreground) {
            this.progressBar.setForeground((Color)this.foreground.getValue());
        } else if (property == this.background) {
            this.progressBar.setBackground((Color)this.background.getValue());
        } else if (property == this.max || property == this.min) {
            this.calcScale();
        }
    }
}

