/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.IntegerProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.smartdashboard.types.DataType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class LinePlot
extends Widget {
    public static final DataType[] TYPES = new DataType[]{DataType.NUMBER};
    public final IntegerProperty bufferSize = new IntegerProperty((PropertyHolder)this, "Buffer Size (samples)", 5000);
    JPanel m_chartPanel;
    XYSeries m_data;
    XYDataset m_dataset;
    JFreeChart m_chart;
    int m_timeUnit = 0;

    public void init() {
        this.setLayout(new BorderLayout());
        this.m_data = new XYSeries((Comparable)((Object)this.getFieldName()));
        this.m_dataset = new XYSeriesCollection(this.m_data);
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.getFieldName(), (String)"Time (units)", (String)"Data", (XYDataset)this.m_dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.m_chartPanel = new ChartPanel(chart);
        this.m_chartPanel.setPreferredSize(new Dimension(400, 300));
        this.m_chartPanel.setBackground(this.getBackground());
        this.add((Component)this.m_chartPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    public void setValue(Object value) {
        this.m_data.add((double)this.m_timeUnit++, (Number)value);
        if (this.m_data.getItemCount() > this.bufferSize.getValue()) {
            this.m_data.remove(0);
        }
        this.revalidate();
        this.repaint();
    }

    public void propertyChanged(Property property) {
        if (property == this.bufferSize) {
            while (this.m_data.getItemCount() > this.bufferSize.getValue()) {
                this.m_data.remove(0);
            }
        }
    }
}

