/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.ColorProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.smartdashboard.types.DataType;
import edu.wpi.first.smartdashboard.types.named.CommandType;
import edu.wpi.first.wpilibj.networking.NetworkListener;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Command
extends Widget {
    public static final DataType[] TYPES = new DataType[]{CommandType.get()};
    private static final String START_CARD = "Start";
    private static final String CANCEL_CARD = "Cancel";
    public final ColorProperty foreground = new ColorProperty((PropertyHolder)this, "Font Color", Color.WHITE);
    public final ColorProperty startBackground = new ColorProperty((PropertyHolder)this, "Start Button Background", new Color(32, 234, 32));
    public final ColorProperty cancelBackground = new ColorProperty((PropertyHolder)this, "Cancel Button Background", new Color(243, 32, 32));
    private JLabel name;
    private JPanel buttonPanel;
    private CardLayout layout;
    private JButton start;
    private JButton cancel;
    private NetworkTable table;
    private NetworkListener listener = new NetworkListener(){

        public void valueChanged(String key, final Object value) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (((Boolean)value).booleanValue()) {
                        Command.this.layout.show(Command.this.buttonPanel, Command.CANCEL_CARD);
                    } else {
                        Command.this.layout.show(Command.this.buttonPanel, Command.START_CARD);
                    }
                }
            });
        }

        public void valueConfirmed(String key, Object value) {
            this.valueChanged(key, value);
        }
    };

    public void setValue(Object value) {
        if (this.table != null) {
            this.table.removeListener("running", this.listener);
        }
        this.table = (NetworkTable)value;
        this.table.addListener("running", this.listener);
        this.listener.valueChanged("running", (Object)this.table.getBoolean("running"));
        this.revalidate();
        this.repaint();
    }

    public void init() {
        this.setResizable(false);
        this.layout = new CardLayout();
        this.buttonPanel = new JPanel(this.layout);
        this.buttonPanel.setOpaque(false);
        this.start = new JButton("start");
        this.start.setOpaque(false);
        this.start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Command.this.table.putBoolean("running", true);
            }
        });
        this.start.setForeground((Color)this.foreground.getValue());
        this.start.setBackground((Color)this.startBackground.getValue());
        this.buttonPanel.add((Component)this.start, START_CARD);
        this.cancel = new JButton("cancel");
        this.cancel.setOpaque(false);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Command.this.table.putBoolean("running", false);
            }
        });
        this.cancel.setForeground((Color)this.foreground.getValue());
        this.cancel.setBackground((Color)this.cancelBackground.getValue());
        this.buttonPanel.add((Component)this.cancel, CANCEL_CARD);
        this.name = new JLabel(this.getFieldName());
        this.add(this.name);
        this.add(this.buttonPanel);
    }

    public void propertyChanged(Property property) {
        if (property == this.foreground) {
            this.start.setForeground((Color)this.foreground.getValue());
            this.cancel.setForeground((Color)this.foreground.getValue());
        } else if (property == this.startBackground) {
            this.start.setBackground((Color)this.startBackground.getValue());
        } else if (property == this.cancelBackground) {
            this.cancel.setBackground((Color)this.cancelBackground.getValue());
        }
    }
}

