/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui;

import edu.wpi.first.smartdashboard.gui.DashboardFrame;
import edu.wpi.first.smartdashboard.gui.DashboardPrefs;
import edu.wpi.first.smartdashboard.gui.DisplayElement;
import edu.wpi.first.smartdashboard.gui.PropertyEditor;
import edu.wpi.first.smartdashboard.gui.StaticWidget;
import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.robot.Robot;
import edu.wpi.first.smartdashboard.types.DataType;
import edu.wpi.first.smartdashboard.types.DisplayElementRegistry;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class GlassPane
extends JPanel {
    private static final int DRAG_BUFFER = 5;
    private boolean dragging;
    private Rectangle dragStartBounds;
    private Dimension dragMinSizeDelta;
    private Dimension dragMaxSizeDelta;
    private Point dragStartPoint;
    private int dragType = -1;
    private Map<Integer, Rectangle> areas = new HashMap<Integer, Rectangle>();
    private JPopupMenu elementMenu = new JPopupMenu();
    private JMenuItem resizeMenu;
    private JMenu changeToMenu = new JMenu("Change to...");
    private DisplayElement selectedElement;
    private DisplayElement menuElement;
    private boolean showGrid = false;
    private static final Color GRID_COLOR = new Color(0, 0, 0, 40);

    GlassPane() {
        this.elementMenu.add(this.changeToMenu);
        this.elementMenu.add(new JMenuItem(new PropertiesItemAction("Properties...")));
        this.elementMenu.add(new JMenuItem(new MoveToBackAction("Send to Back")));
        this.resizeMenu = new JMenuItem(new ResetSizeAction());
        this.elementMenu.add(this.resizeMenu);
        this.elementMenu.add(new JMenuItem(new DeleteItemAction()));
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                GlassPane.this.requestFocus();
                GlassPane.this.setShowingGrid(false);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    GlassPane.this.setShowingGrid(true);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    GlassPane.this.setShowingGrid(false);
                }
            }
        });
        this.setOpaque(false);
        this.setFocusable(true);
        GlassMouseListener listener = new GlassMouseListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void setShowingGrid(boolean showGrid) {
        if (this.showGrid != showGrid) {
            this.showGrid = showGrid;
            this.repaint();
        }
    }

    private DisplayElement findElementContaining(Point point) {
        return DashboardFrame.getInstance().getPanel().findElementContaining(point);
    }

    private void prepareElementMenu(DisplayElement element) {
        this.menuElement = element;
        Dimension savedSize = this.menuElement.getSavedSize();
        this.resizeMenu.setEnabled(savedSize.width != -1 || savedSize.height != -1);
        if (element instanceof Widget) {
            DataType type = ((Widget)element).getType();
            if (type == null) {
                this.changeToMenu.setEnabled(false);
            } else {
                this.changeToMenu.setEnabled(true);
                Set<Class<? extends Widget>> choices = DisplayElementRegistry.getWidgetsForType(type);
                this.changeToMenu.removeAll();
                int count = 0;
                for (Class<? extends Widget> c : choices) {
                    if (c.equals(element.getClass())) continue;
                    ++count;
                    this.changeToMenu.add(new ChangeToAction(DisplayElement.getName(c), c));
                }
                if (count == 0) {
                    this.changeToMenu.setEnabled(false);
                }
            }
        } else {
            this.changeToMenu.setEnabled(false);
        }
    }

    private void showEditor(DisplayElement element) {
        PropertyEditor editor = DashboardFrame.getInstance().getPropertyEditor();
        editor.setPropertyHolder(element);
        editor.setVisible(true);
    }

    private void defineBounds() {
        Rectangle sb = this.selectedElement.getBounds();
        int ybuffer = Math.max(Math.min(sb.height / 5, 5), 1);
        int xbuffer = Math.max(Math.min(sb.width / 5, 5), 1);
        this.areas.clear();
        if (this.selectedElement.isResizable()) {
            Rectangle area = new Rectangle(sb.x - xbuffer, sb.y - ybuffer, 2 * xbuffer, 2 * ybuffer);
            this.areas.put(8, area);
            area = new Rectangle(sb.x + xbuffer, sb.y - ybuffer, sb.width - 2 * xbuffer, 2 * ybuffer);
            this.areas.put(1, area);
            area = new Rectangle(sb.x + sb.width - xbuffer, sb.y - ybuffer, 2 * xbuffer, 2 * ybuffer);
            this.areas.put(2, area);
            area = new Rectangle(sb.x + sb.width - xbuffer, sb.y + ybuffer, 2 * xbuffer, sb.height - 2 * ybuffer);
            this.areas.put(3, area);
            area = new Rectangle(sb.x + sb.width - xbuffer, sb.y + sb.height - ybuffer, 2 * xbuffer, 2 * ybuffer);
            this.areas.put(4, area);
            area = new Rectangle(sb.x + xbuffer, sb.y + sb.height - ybuffer, sb.width - 2 * xbuffer, 2 * ybuffer);
            this.areas.put(5, area);
            area = new Rectangle(sb.x - xbuffer, sb.y + sb.height - ybuffer, 2 * xbuffer, 2 * ybuffer);
            this.areas.put(6, area);
            area = new Rectangle(sb.x - xbuffer, sb.y + ybuffer, 2 * xbuffer, sb.height - 2 * ybuffer);
            this.areas.put(7, area);
            area = new Rectangle(sb.x + xbuffer, sb.y + ybuffer, sb.width - 2 * xbuffer, sb.height - 2 * ybuffer);
            this.areas.put(0, area);
        } else {
            this.areas.put(0, sb);
        }
    }

    protected void paintComponent(Graphics g) {
        Rectangle bounds = this.getBounds();
        if (this.selectedElement != null) {
            Rectangle eb = this.selectedElement.getBounds();
            g.setColor(Color.GRAY);
            g.drawRoundRect(eb.x - 1, eb.y - 1, eb.width + 1, eb.height + 1, 8, 8);
        }
        if (this.showGrid) {
            int i;
            g.setColor(GRID_COLOR);
            DashboardPrefs pref = DashboardPrefs.getInstance();
            int[] w = pref.grid_widths.getValue();
            int[] h = pref.grid_heights.getValue();
            int cell = -1;
            for (i = 0; i < bounds.width; i += w[cell]) {
                g.drawLine(i, 0, i, bounds.height);
                cell = (cell + 1) % w.length;
            }
            cell = -1;
            for (i = 0; i < bounds.height; i += h[cell]) {
                g.drawLine(0, i, bounds.width, i);
                cell = (cell + 1) % h.length;
            }
        }
    }

    private void setSelected(DisplayElement element) {
        if (this.selectedElement != element) {
            this.selectedElement = element;
            if (this.selectedElement == null) {
                this.areas.clear();
            } else {
                this.defineBounds();
            }
            this.repaint();
        }
    }

    private class DeleteItemAction
    extends AbstractAction {
        public DeleteItemAction() {
            super("Remove");
        }

        public void actionPerformed(ActionEvent e) {
            if (GlassPane.this.menuElement instanceof StaticWidget) {
                DashboardFrame.getInstance().getPanel().removeElement((StaticWidget)GlassPane.this.menuElement);
            } else if (GlassPane.this.menuElement instanceof Widget) {
                DashboardFrame.getInstance().getPanel().removeField(((Widget)GlassPane.this.menuElement).getFieldName());
            }
        }
    }

    private class PropertiesItemAction
    extends AbstractAction {
        private PropertiesItemAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent ae) {
            GlassPane.this.showEditor(GlassPane.this.menuElement);
        }
    }

    private class ResetSizeAction
    extends AbstractAction {
        private ResetSizeAction() {
            super("Reset Size");
        }

        public void actionPerformed(ActionEvent e) {
            GlassPane.this.menuElement.setSavedSize(new Dimension(-1, -1));
            DashboardFrame.getInstance().getPanel().revalidateBacking();
        }
    }

    private class MoveToBackAction
    extends AbstractAction {
        private MoveToBackAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent e) {
            DashboardFrame.getInstance().getPanel().shiftToBack(GlassPane.this.menuElement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChangeToAction
    extends AbstractAction {
        Class<? extends Widget> elementClass;

        private ChangeToAction(String string, Class<? extends Widget> elementClass) {
            super(string);
            this.elementClass = elementClass;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GlassPane.this.menuElement instanceof Widget) {
                Widget oldElement = (Widget)GlassPane.this.menuElement;
                if (Robot.getTable().containsKey(oldElement.getFieldName())) {
                    Object value = Robot.getTable().getValue(oldElement.getFieldName());
                    DashboardFrame.getInstance().getPanel().setField(oldElement.getFieldName(), this.elementClass, value, oldElement.getLocation());
                } else {
                    DashboardFrame.getInstance().getPanel().setField(oldElement.getFieldName(), this.elementClass, oldElement.getType(), null, oldElement.getLocation());
                }
            }
        }
    }

    private class GlassMouseListener
    extends MouseAdapter {
        private int lastDW;
        private int lastDH;
        private int lastDX;
        private int lastDY;

        private GlassMouseListener() {
        }

        private int adjust(int delta, int original, int[] cells) {
            if (GlassPane.this.showGrid) {
                int total = 0;
                for (int cell : cells) {
                    total += cell;
                }
                int n = (delta + original) % total;
                if (n < 0) {
                    n += total;
                }
                int i = 0;
                int cumulative = 0;
                while (i < cells.length) {
                    if (n < cumulative + cells[i] / 2) {
                        return delta - n + cumulative;
                    }
                    cumulative += cells[i++];
                }
                return delta - n + total;
            }
            return delta;
        }

        private int adjustX(int value) {
            DashboardPrefs prefs = DashboardPrefs.getInstance();
            return this.adjust(value, ((GlassPane)GlassPane.this).dragStartBounds.x, prefs.grid_widths.getValue());
        }

        private int adjustY(int value) {
            DashboardPrefs prefs = DashboardPrefs.getInstance();
            return this.adjust(value, ((GlassPane)GlassPane.this).dragStartBounds.y, prefs.grid_heights.getValue());
        }

        private int adjustW(int value) {
            DashboardPrefs prefs = DashboardPrefs.getInstance();
            return this.adjust(value, ((GlassPane)GlassPane.this).dragStartBounds.x + ((GlassPane)GlassPane.this).dragStartBounds.width, prefs.grid_widths.getValue());
        }

        private int adjustH(int value) {
            DashboardPrefs prefs = DashboardPrefs.getInstance();
            return this.adjust(value, ((GlassPane)GlassPane.this).dragStartBounds.y + ((GlassPane)GlassPane.this).dragStartBounds.height, prefs.grid_heights.getValue());
        }

        private int inRange(boolean horizontal, int value) {
            int max;
            int min = horizontal ? ((GlassPane)GlassPane.this).dragMinSizeDelta.width : ((GlassPane)GlassPane.this).dragMinSizeDelta.height;
            int n = max = horizontal ? ((GlassPane)GlassPane.this).dragMaxSizeDelta.width : ((GlassPane)GlassPane.this).dragMaxSizeDelta.height;
            return value <= max ? (value < min ? min : value) : max;
        }

        public void mousePressed(MouseEvent e) {
            GlassPane.this.dragType = -1;
            if (GlassPane.this.selectedElement != null) {
                if (e.isPopupTrigger()) {
                    GlassPane.this.prepareElementMenu(GlassPane.this.selectedElement);
                    GlassPane.this.elementMenu.show(GlassPane.this, e.getPoint().x, e.getPoint().y);
                } else {
                    for (Map.Entry entry : GlassPane.this.areas.entrySet()) {
                        if (!((Rectangle)entry.getValue()).contains(e.getPoint())) continue;
                        GlassPane.this.dragType = (Integer)entry.getKey();
                        break;
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (e.isMetaDown()) {
                return;
            }
            if (GlassPane.this.selectedElement != null && GlassPane.this.dragType != -1) {
                if (!GlassPane.this.dragging) {
                    GlassPane.this.dragging = true;
                    GlassPane.this.dragStartBounds = GlassPane.this.selectedElement.getBounds();
                    GlassPane.this.dragMinSizeDelta = GlassPane.this.selectedElement.getMinimumSize();
                    ((GlassPane)GlassPane.this).dragMinSizeDelta.width -= ((GlassPane)GlassPane.this).dragStartBounds.width;
                    ((GlassPane)GlassPane.this).dragMinSizeDelta.height -= ((GlassPane)GlassPane.this).dragStartBounds.height;
                    GlassPane.this.dragMaxSizeDelta = GlassPane.this.selectedElement.getMaximumSize();
                    ((GlassPane)GlassPane.this).dragMaxSizeDelta.width -= ((GlassPane)GlassPane.this).dragStartBounds.width;
                    ((GlassPane)GlassPane.this).dragMaxSizeDelta.height -= ((GlassPane)GlassPane.this).dragStartBounds.height;
                    GlassPane.this.dragStartPoint = e.getPoint();
                    this.lastDY = 0;
                    this.lastDX = 0;
                    this.lastDW = 0;
                    this.lastDH = 0;
                }
                int dh = 0;
                int dw = 0;
                int dy = 0;
                int dx = 0;
                switch (GlassPane.this.dragType) {
                    case 1: {
                        dh = this.inRange(false, -this.adjustY(e.getPoint().y - ((GlassPane)GlassPane.this).dragStartPoint.y));
                        dy = -dh;
                        break;
                    }
                    case 2: {
                        dh = this.inRange(false, -this.adjustY(e.getPoint().y - ((GlassPane)GlassPane.this).dragStartPoint.y));
                        dy = -dh;
                        dw = this.inRange(true, this.adjustW(e.getPoint().x - ((GlassPane)GlassPane.this).dragStartPoint.x));
                        break;
                    }
                    case 3: {
                        dw = this.inRange(true, this.adjustW(e.getPoint().x - ((GlassPane)GlassPane.this).dragStartPoint.x));
                        break;
                    }
                    case 4: {
                        dw = this.inRange(true, this.adjustW(e.getPoint().x - ((GlassPane)GlassPane.this).dragStartPoint.x));
                        dh = this.inRange(false, this.adjustH(e.getPoint().y - ((GlassPane)GlassPane.this).dragStartPoint.y));
                        break;
                    }
                    case 5: {
                        dh = this.inRange(false, this.adjustH(e.getPoint().y - ((GlassPane)GlassPane.this).dragStartPoint.y));
                        break;
                    }
                    case 6: {
                        dh = this.inRange(false, this.adjustH(e.getPoint().y - ((GlassPane)GlassPane.this).dragStartPoint.y));
                        dw = this.inRange(true, -this.adjustX(e.getPoint().x - ((GlassPane)GlassPane.this).dragStartPoint.x));
                        dx = -dw;
                        break;
                    }
                    case 7: {
                        dw = this.inRange(true, -this.adjustX(e.getPoint().x - ((GlassPane)GlassPane.this).dragStartPoint.x));
                        dx = -dw;
                        break;
                    }
                    case 8: {
                        dh = this.inRange(false, -this.adjustY(e.getPoint().y - ((GlassPane)GlassPane.this).dragStartPoint.y));
                        dy = -dh;
                        dw = this.inRange(true, -this.adjustX(e.getPoint().x - ((GlassPane)GlassPane.this).dragStartPoint.x));
                        dx = -dw;
                        break;
                    }
                    case 0: {
                        DashboardPrefs prefs = DashboardPrefs.getInstance();
                        int leading = this.adjust(e.getPoint().x - ((GlassPane)GlassPane.this).dragStartPoint.x, ((GlassPane)GlassPane.this).dragStartBounds.x, prefs.grid_widths.getValue());
                        int trailing = this.adjust(e.getPoint().x - ((GlassPane)GlassPane.this).dragStartPoint.x, ((GlassPane)GlassPane.this).dragStartBounds.x + ((GlassPane)GlassPane.this).dragStartBounds.width, prefs.grid_widths.getValue());
                        dx = Math.abs(leading) < Math.abs(trailing) ? leading : trailing;
                        leading = this.adjust(e.getPoint().y - ((GlassPane)GlassPane.this).dragStartPoint.y, ((GlassPane)GlassPane.this).dragStartBounds.y, prefs.grid_heights.getValue());
                        trailing = this.adjust(e.getPoint().y - ((GlassPane)GlassPane.this).dragStartPoint.y, ((GlassPane)GlassPane.this).dragStartBounds.y + ((GlassPane)GlassPane.this).dragStartBounds.height, prefs.grid_heights.getValue());
                        dy = Math.abs(leading) < Math.abs(trailing) ? leading : trailing;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                boolean changed = false;
                if (dw != this.lastDW || dh != this.lastDH) {
                    changed = true;
                    Dimension size = GlassPane.this.selectedElement.getSavedSize();
                    if (dw != this.lastDW) {
                        size.width = ((GlassPane)GlassPane.this).dragStartBounds.width + dw;
                        this.lastDW = dw;
                    }
                    if (dh != this.lastDH) {
                        size.height = ((GlassPane)GlassPane.this).dragStartBounds.height + dh;
                        this.lastDH = dh;
                    }
                    GlassPane.this.selectedElement.setSavedSize(size);
                }
                if (dx != this.lastDX || dy != this.lastDY) {
                    changed = true;
                    Point origin = GlassPane.this.dragStartBounds.getLocation();
                    origin.translate(dx, dy);
                    GlassPane.this.selectedElement.setSavedLocation(origin);
                    this.lastDX = dx;
                    this.lastDY = dy;
                }
                if (changed) {
                    DashboardFrame frame = DashboardFrame.getInstance();
                    frame.getPanel().revalidateBacking();
                    frame.repaint();
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            GlassPane.this.dragType = -1;
            GlassPane.this.dragging = false;
            GlassPane.this.setSelected(null);
        }

        public void mouseReleased(MouseEvent e) {
            if (GlassPane.this.dragging) {
                GlassPane.this.dragging = false;
                GlassPane.this.defineBounds();
                this.mouseMoved(e);
            } else if (GlassPane.this.selectedElement != null) {
                if (e.isPopupTrigger()) {
                    GlassPane.this.prepareElementMenu(GlassPane.this.selectedElement);
                    GlassPane.this.elementMenu.show(GlassPane.this, e.getPoint().x, e.getPoint().y);
                } else if (e.getClickCount() == 2) {
                    GlassPane.this.showEditor(GlassPane.this.selectedElement);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            block20: {
                DisplayElement element = GlassPane.this.findElementContaining(e.getPoint());
                if (element != GlassPane.this.selectedElement) {
                    if (element == null) {
                        boolean found = false;
                        for (Rectangle area : GlassPane.this.areas.values()) {
                            if (!area.contains(e.getPoint())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            GlassPane.this.setSelected(null);
                        }
                    } else {
                        GlassPane.this.setSelected(element);
                    }
                }
                if (!GlassPane.this.areas.isEmpty()) {
                    block12: for (Map.Entry entry : GlassPane.this.areas.entrySet()) {
                        Rectangle area;
                        area = (Rectangle)entry.getValue();
                        if (!area.contains(e.getPoint())) continue;
                        switch ((Integer)entry.getKey()) {
                            case 1: {
                                GlassPane.this.setCursor(Cursor.getPredefinedCursor(8));
                                break block20;
                            }
                            case 2: {
                                GlassPane.this.setCursor(Cursor.getPredefinedCursor(7));
                                break block20;
                            }
                            case 3: {
                                GlassPane.this.setCursor(Cursor.getPredefinedCursor(11));
                                break block20;
                            }
                            case 4: {
                                GlassPane.this.setCursor(Cursor.getPredefinedCursor(5));
                                break block20;
                            }
                            case 5: {
                                GlassPane.this.setCursor(Cursor.getPredefinedCursor(9));
                                break block20;
                            }
                            case 6: {
                                GlassPane.this.setCursor(Cursor.getPredefinedCursor(4));
                                break block20;
                            }
                            case 7: {
                                GlassPane.this.setCursor(Cursor.getPredefinedCursor(10));
                                break block20;
                            }
                            case 8: {
                                GlassPane.this.setCursor(Cursor.getPredefinedCursor(6));
                                break block20;
                            }
                            case 0: {
                                GlassPane.this.setCursor(Cursor.getDefaultCursor());
                                break block20;
                            }
                            default: {
                                assert (false);
                                continue block12;
                            }
                        }
                    }
                } else {
                    GlassPane.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }
}

